<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: settings.php 54 2008-03-24 18:34:07Z sean $
 */
include($this->viewsDir . '/include.php');
$settings = $this->Model->getAllSettings();
?>
<div class="wrap">
	<h2><?php echo $this->alinksLang->_('Settings'); ?></h2>
	<form method="post">
		<input type="hidden" name="setting_name" value="alinks_settings" />
		<input type="hidden" name="alinks_action" value="settings" />
		<table class="optiontable"> 

			<tr valign="top"> 
			<th scope="row"><?php echo $this->alinksLang->_('Image to display after links'); ?>: </th> 
			<td><input name="linkimage" type="text" id="linkimage" value="<?php echo $settings['linkimage']; ?>" size="40" /><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon" style="border: 0px; margin-left: 5px;" onclick="al_help('settings-externalimage');"/></td> 
			</tr>

			<tr valign="top"> 
			<th scope="row"><?php echo $this->alinksLang->_('Open links in new window'); ?>: </th> 
			<td><input type="checkbox" name="newwindow" id="newwindow"  <?php if ($settings['newwindow']) echo 'checked="checked"'; ?>/> <?php echo $this->alinksLang->_('Yes'); ?><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon"  style="border: 0px; margin-left: 5px;" onclick="al_help('settings-targetwindow');" /></td> 
			</tr>

			<tr valign="top"> 
			<th scope="row"><?php echo $this->alinksLang->_('Use outbound click tracking'); ?>: </th> 
			<td><input type="checkbox" name="clicktracking" id="clicktracking" <?php if ($settings['clicktracking']) echo 'checked="checked"'; ?>/> <?php echo $this->alinksLang->_('Yes (Needed for click logs)'); ?><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon" style="border: 0px; margin-left: 5px;" onclick="al_help('settings-clicktracking');" /></td> 
			</tr>
			
			<tr valign="top"> 
			<th scope="row"><?php echo $this->alinksLang->_('Log offset hours'); ?>: </th> 
			<td><input type="text" name="offsethours" id="offsethours" size="3" value="<?php echo $settings['offsethours']; ?>" /> <img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon" style="border: 0px; margin-left: 5px;" onclick="al_help('settings-offsethours');" /></td> 
			</tr>

			<tr valign="top"> 
			<th scope="row"><?php echo $this->alinksLang->_('Custom HTML/JavaScript to add to links'); ?>: </th> 
			<td><input name="customhtmljs" type="text" id="customhtmljs" value="<?php echo htmlentities($settings['customhtmljs']); ?>" size="40" /><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" style="border: 0px; margin-left: 5px;" class="alinks_helpicon" onclick="al_help('settings-customhtmljs');" /></td> 
			</tr>

			<tr valign="top"> 
			<th scope="row"><?php echo $this->alinksLang->_('Custom CSS class'); ?>: </th> 
			<td><input name="cssclass" type="text" id="cssclass" value="<?php echo $settings['cssclass']; ?>" size="20" /><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" style="border: 0px; margin-left: 5px;" class="alinks_helpicon" onclick="al_help('settings-cssclass');" /></td> 
			</tr>

			<tr valign="top"> 
			<th scope="row"><?php echo $this->alinksLang->_('Max links per keyphrase'); ?>: </th> 
			<td><input name="maxlinks" type="text" id="maxlinks" value="<?php echo $settings['maxlinks']; ?>" size="2" /> <?php echo $this->alinksLang->_('(Leave blank for unlimited)'); ?><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" style="border: 0px; margin-left: 5px;" class="alinks_helpicon" onclick="al_help('settings-maxlinks');" />
			<br /><small>See <a href="http://forums.headzoo.com/viewtopic.php?f=5&t=7" target="_blank">this forum post</a> to find out why this setting doesn't work as expected.</small>
			</td> 
			</tr>

			<tr valign="top"> 
			<th scope="row"><?php echo $this->alinksLang->_('Keyphrases are case sensitive'); ?>: </th> 
			<td><input type="checkbox" name="casesensitive" id="casesensitive" <?php if ($settings['casesensitive']) echo 'checked="checked"'; ?>/> <?php echo $this->alinksLang->_('Yes'); ?><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" style="border: 0px; margin-left: 5px;" class="alinks_helpicon" onclick="al_help('settings-casesensitive');" /></td>
			</tr>

			<tr valign="top"> 
			<th scope="row"><?php echo $this->alinksLang->_("Don't warn on keyphrase delete"); ?>: </th> 
			<td><input type="checkbox" name="nodeletewarning" id="nodeletewarning" <?php if ($settings['nodeletewarning']) echo 'checked="checked"'; ?>/> <img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" style="border: 0px; margin-left: 5px;" class="alinks_helpicon" onclick="al_help('settings-nodeletewarning');" /></td>
			</tr>

		</table>
		<p class="submit"><input type="submit" value="<?php echo $this->alinksLang->_('Update Settings'); ?> &raquo;" /></p>
	</form>

	<?php
	$modules = $this->Modules->getModules();
	$alinksForms = new aLinksForms;

	if ($modules) {
		foreach ($modules as $module) {
			$safeName = $module['obj']->getName();
			$modOptions = get_option('alinks_mod_' . strtolower($safeName));
			if (!$options = $module['options']) continue;
			
			?>
			<h2><?php echo $module['info']['name']; ?> <?php echo $this->alinksLang->_('Settings'); ?></h2>
			<form method="post">
				<input type="hidden" name="setting_name" value="<?php echo 'alinks_mod_' . strtolower($safeName); ?>" />
				<input type="hidden" name="alinks_action" value="settings" />
				<table class="optiontable">
					<?php
					foreach ($options as $option) {
						$alinksForms->set($option, $modOptions[$option['input']['name']], '', true);
						$alinksForms->show();
					}
					?>
				</table>
				<p class="submit"><input type="submit" value="<?php echo $this->alinksLang->_('Update') . ' ' . $module['info']['name'] . ' ' . $this->alinksLang->_('Settings'); ?> &raquo;" />
			</form>
			<?php
		}
	}
	?>
</div>