<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: modules.php 42 2008-03-24 17:50:25Z sean $
 */
include($this->viewsDir . '/include.php');
$modules = $this->Modules->getModules();
?>
<div class="wrap">
<h2><?php echo $this->alinksLang->_('Modules'); ?></h2>

	<ul style="list-style-type:none;" id="modules_container">
	<li>
		<p><?php echo $this->alinksLang->_('Modules extend the types of keyphrases that aLinks can create links for.'); ?></p>
		<table width="100%" cellpadding="3" cellspacing="3">
			<tr>
				<th><?php echo $this->alinksLang->_('Module'); ?></th>
				<th><?php echo $this->alinksLang->_('Version'); ?></th>
				<th><?php echo $this->alinksLang->_('Description'); ?></th>
				<th><?php echo $this->alinksLang->_('Actions'); ?></th>
			</tr>

			<?php
			if (empty($modules)) {
				echo '<p>' . $this->alinksLang->_('No modules installed.') . '</p>';
			} else {
				foreach ($modules as $module) {
				?>
				<tr class="alternate active">
					<td class='name'><strong><?php echo $module['info']['name']; ?></strong></td>
					<td class='vers'><?php echo $module['info']['version']; ?></td>
					<td class='desc'><?php echo $module['info']['description']; ?> <cite>By <a href="<?php echo $module['info']['authorWebsite']; ?>" title="Visit author homepage"><?php echo $module['info']['author']; ?></a>.</cite> <?php if (isset($module['help'])) echo ' <a href="' . $module['help'] . '" title="View Module Help">View Module Help</a>'; ?></td>
					<td class='togl'><a href='admin.php?page=alinks-Modules&amp;alinks_action=delete&amp;module=<?php echo urlencode($module['dir']); ?>' title='Deactivate this plugin' class='delete' onclick="return deleteMod('<?php echo $module['info']['name']; ?>');">Delete</a></td>
				</tr>
				<?php
				}
			}
			?>
		</table>
	</li>

	<li>
		<h3><?php echo $this->alinksLang->_('Install a new module'); ?> <img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon"  style="border: 0px; margin-left: 5px;" onclick="al_help('modules-install');" /></h3>
		<p><?php echo $this->alinksLang->_('Modules come in ZIP format.  Simply select the module ZIP file from the file browser below, and click "Install Module".'); ?></p>
		<form method="post" enctype="multipart/form-data">
			<input type="hidden" name="alinks_file" value="module" />
			<p><input type="file" name="modulefile" /></p>
			<p class="submit"><input type="submit" value="<?php echo $this->alinksLang->_('Install Module'); ?> &raquo;" /></p>
		</form>
	</li>

	</ul>
</div>
