<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: aLinksView.php 44 2008-03-24 18:00:53Z sean $
 */
/**
 * aLinks view class
 *
 * A "view" is any php page that is displayed to the user.  This class
 * handles the inclusion of the php page, and registering the document
 * with WordPress to be displayed in the admin panel.
 */
class aLinksView extends aLinksApp {

	/**
	 * The name of the view file to be used
	 * to display the admin menu.  This is the
	 * name minus the '.php' extension, since all
	 * views should be written in PHP.
	 * @var string
	 */
	var $view;
	
	/**
	 * The controller object that created this
	 * view.
	 * @var obj
	 */
	var $Controller;
	
	/**
	 * The aLinksLang object to translate strings.
	 * @var obj
	 */
	var $alinksLang;
	
	/**
	 * 1 if this is a main menu, or 0 if this
	 * is a sub menu.
	 * @var int
	 */
	var $menu;
	
	/**
	 * The full path to the views directory.
	 * @var string
	 */
	var $viewsDir;
	
	/**
	 * The full path to the classes directory.
	 * @var string
	 */
	var $classesPath;
	
	/**
	 * The aLinksModel class object.
	 * @var obj
	 */
	var $Model;
	
	/**
	 * Class constructor
	 *
	 * @param	int		$menu		The type of menu: 1 for menu page, 0 for submenu
	 * @param	string	$viewsDir	The full path to the views directory
	 * @param	string	$classesPath	The full path to the classes directory
	 * @parm		string	$view		The name of this view php file for this view
	 * @param	string	$title		The title for this view, displayed in the browser window title bar
	 * @param	string	$name		The name of this view
	 * @param	obj		$controller	The controller object that created this view
	 * @param	obj		$alinksLang	The aLinksLang object to translate strings
	 * @param	obj		$alinksModel	The aLinksModel object for access to the database
	 * @return	void
	 */
	function aLinksView($menu, $viewsDir, $classesPath, $view, $title, $name, &$controller, &$alinksLang, &$alinksModel) {
			$this->menu = $menu;
			$this->viewsDir = $viewsDir;
			$this->view = $view;
			$this->title = $title;
			$this->name = $name;
			$this->alinksLang = $alinksLang;
			$this->Controller = $controller;
			$this->Controller->registerView(array('view' => $this->view, 'obj' => &$this));
			$this->Model = $alinksModel;
			add_action('admin_menu', array(&$this, 'addSubMenu'), 10);
	}
	
	/**
	 * Factory method that returns a views object
	 *
	 * A factory method is used to create new view objects, because a view can use either
	 * this class, or a class that extends this class.  This method looks for files using
	 * the name convetion: aLinksView_{view}, where {view} is the name of the view.  If
	 * a file is found that has that name, the file will be included and a new object will
	 * be created using the class inside that file that has the same name as the file.  That
	 * object will be returned by this method.
	 * If there is no file found, then an instance of this class will be created and returned.
	 *
	 * @param	int		$menu		The type of menu: 1 for menu page, 0 for submenu
	 * @param	string	$viewsDir	The full path to the views directory
	 * @param	string	$classesPath	The full path to the classes directory
	 * @parm		string	$view		The name of this view php file for this view
	 * @param	string	$title		The title for this view, displayed in the browser window title bar
	 * @param	string	$name		The name of this view
	 * @param	obj		$controller	The controller object that created this view
	 * @param	obj		$alinksLang	The aLinksLang object to translate strings
	 * @return	obj
	 */
	function create($menu, $viewsDir, $classesPath, $view, $title, $name, &$controller, &$alinksLang, &$alinksModel) {
		$this->notifyObjects('aLinksView::create', 'View-Created::' . $view);
		if (file_exists($classesPath . '/aLinksView_' . ucwords(strtolower($view)) . '.php')) {
			include($classesPath . '/aLinksView_' . ucwords(strtolower($view)) . '.php');
			$objName = 'aLinksView_' . ucwords(strtolower($view));
			$obj = & new $objName($menu, $viewsDir, $classesPath, $view, $title, $name, $controller, $alinksLang, $alinksModel);
			return $obj;
		} else {
			$obj = & new aLinksView($menu, $viewsDir, $classesPath, $view, $title, $name, $controller, $alinksLang, $alinksModel);
			return $obj;
		}
	}
	
	/**
	 * Registers a menu with WordPress
	 *
	 * Uses WordPress's add_menu_page() and add_submenu_page() functions to add the view
	 * to WordPress's admin panel.
	 *
	 * @return	void
	 */
	function addSubMenu() {
		if ($this->menu == 1) {
			add_menu_page($this->title, $this->name, 8,  ALINKS_PATH . '/alinks.php', array(&$this, 'show'));
		} else if ($this->menu == 0) {
			add_submenu_page('alinks/alinks.php', $this->title, $this->name, 8, 'alinks-' . $this->view, array(&$this, 'show'));
		}
	}
	
	/**
	 * Displays the view's php file
	 *
	 * This is the method that is registered with WordPress's add_menu_page() and
	 * add_submenu_page() functions to be used to display the view.
	 *
	 * @return	void
	 */
	function show() {
		$this->notifyObjects('aLinksView::show', 'Showing-View::' . $this->view);
		include($this->viewsDir . '/' . $this->view . '.php');
	}
}