<?php
/*
Plugin Name: OneButton
Plugin URI: http://blog.sjinks.org.ua/php/wordpress/202-onebutton-better-version-of-odnaknopka/
Description: One Button for all Bookmark Services
Author: Vladimir Kolesnikov
Author URI: http://blog.sjinks.org.ua/
Version: 1.0.2b
*/

    class OneButton
    {
        const option_options  = 'onebutton_settings';
        const option_services = 'onebutton_services';

        protected $my_url;
        protected $options;

        /**
         * @return OneButton
         */
        public static function& instance()
        {
            static $self = false;

            if (false === $self) {
                $self = new OneButton();
            }

            return $self;
        }

        protected function __construct()
        {
            add_action('init', array(&$this, 'init'));
        }

        /**
         * @return array
         */
        public function& loadOptions()
        {
            static $defaults = array(
                'enable'      => 0,
                'only_single' => 1,
                'nofollow'    => 1,
                'newwindow'   => 0,
                'show_icons'  => 1,
                'use_js'      => 0,
                'activation'  => 1,
            );

            static $done = false;

            if (false === $done) {
                $done = true;
                $options = get_option('onebutton_settings');
                if (false === $options || false == is_array($options) || true == empty($options)) {
                    $this->options = $defaults;
                    $this->saveOptions($this->options);
                }
                else {
                    $update = false;
                    foreach ($defaults as $key => $value) {
                        if (false == isset($options[$key])) {
                            $options[$key] = $value;
                            $update = true;
                        }
                    }

                    foreach ($options as $key => $value) {
                        if (false == isset($defaults[$key])) {
                            unset($options[$key]);
                            $update = true;
                        }
                    }

                    $this->options = $options;
                    if (true == $update) {
                        $this->saveOptions($this->options);
                    }
                }
            }

            return $this->options;
        }

        /**
         * @return array
         */
        public function& getServices()
        {
            $services = array(
                array('blink',       'Blink',                10, 1, 'http://www.blinklist.com/index.php?Action=Blink/addblink.php&url={url}&title={title}&description={description}'),
                array('delicious',   'del.ici.ous',          20, 1, 'http://del.icio.us/post?url={url}&title={title}'),
                array('digg',        'Digg',                 30, 1, 'http://digg.com/submit?phase=2&url={url}'),
                array('furl',        'Furl',                 40, 1, 'http://www.furl.net/storeIt.jsp?u={url}&t={title}'),
                array('google',      'Google',               50, 1, 'http://fusion.google.com/add?feedurl={url}'),
                array('simpy',       'Simpy',                60, 1, 'http://simpy.com/simpy/LinkAdd.do?href=&title={title}&note={description}&_doneURI={url}&v=6&src=bookmarklet'),
                array('spurl',       'Spurl',                70, 1, 'http://www.spurl.net/spurl.php?v=3&url={url}&title={title}&blocked={description}'),
                array('ymyweb',      'Y! MyWeb',             80, 1, 'http://myweb2.search.yahoo.com/myresults/bookmarklet?u={url}&t={title}&d=&ei=UTF-8'),
                array('bobrdobr',    'БобрДобр',             90, 1, 'http://bobrdobr.ru/addext.html?url={url}&title={title}'),
                array('mrwong',      'Мистер Вонг',         100, 1, 'http://www.mister-wong.ru/index.php?action=addurl&bm_url={url}&bm_description={title}'),
                array('yabm',        'Yandex.Закладки',     110, 1, 'http://zakladki.yandex.ru/userarea/links/addfromfav.asp?bAddLink_x=1&lurl={url}&lname={title}'),
                array('text20',      'Текст 2.0',           120, 1, 'http://text20.ru/add/?source={url}&title={title}&text={description}'),
                array('news2',       'News2',               130, 1, 'http://news2.ru/add_story.php?url={url}'),
                array('addscoop',    'AddScoop',            140, 1, 'http://myscoop.ru/add/?URL={url}&title={title}'),
                array('ruspace',     'RuSpace',             150, 1, 'http://www.ruspace.ru/index.php?link=bookmark&action=bookmarkNew&bm=1&url={url}&title={title}'),
                array('rumarkz',     'RUmarkz',             160, 1, 'http://rumarkz.ru/bookmarks/?action=add&popup=1&address={url}&title={title}'),
                array('memori',      'Memori',              170, 1, 'http://memori.ru/link/?sm=1&u_data[url]={url}&u_data[name]={title}'),
                array('googlebm',    'Google Bookmarks',    180, 1, 'http://www.google.com/bookmarks/mark?op=add&bkmk={url}&title={title}'),
                array('pisali',      'Писали',              190, 1, 'http://pisali.ru/load_article/'),
                array('smi2',        'СМИ 2',               200, 1, 'http://smi2.ru/add/'),
                array('myplace',     'Моё Место',           210, 1, 'http://moemesto.ru/post.php?url={url}&title={title}'),
                array('bm100',       '100 Закладок',        220, 1, 'http://www.100zakladok.ru/save/?bmurl={url}&bmtitle={title}'),
                array('wow',         'Ваау!',               230, 1, 'http://www.vaau.ru/submit/?action=step2&url={url}'),
                array('technorati',  'Technorati',          240, 1, 'http://technorati.com/faves?add={url}'),
                array('rucity',      'RuCity',              250, 1, 'http://rucity.com/bookmarks.php?action=add&address={url}&title={title}&description={description}'),
                array('linkstore',   'LinkStore',           260, 1, 'http://linkstore.ru/servlet/LinkStore?a=add&url={url}&title={title}'),
                array('newsland',    'NewsLand',            270, 1, 'http://newsland.ru/News/Add/type/news/'),
                array('lopas',       'Lopas',               280, 1, 'http://www.lopas.ru/add_story.php?story_url={url}'),
                array('liua',        'Закладки - IN.UA',    290, 1, 'http://links.i.ua/add/?url={url}&name={title}&text={description}&labels={tags}'),
                array('connotea',    'Connotea',            300, 1, 'http://www.connotea.org/add?uri={url}&usertitle={title}&tags={tags}&description={description}'),
                array('bibsonomy',   'Bibsonomy',           310, 1, 'http://www.bibsonomy.org/ShowBookmarkEntry?c=b&jump=yes&url={url}&description={title}&extended={description}'),
                array('trucking',    'Trucking Bookmarks',  320, 1, 'http://macke1.com/bookmarks.php/?action=add&address={url}&title={title}&description={description}&tags={tags}'),
                array('communizm',   'Communizm',           330, 1, 'http://communizm.ru/index.php?mode=addstory&title={title}&link={url}'),
                array('uca',         'UCA',                 340, 1, 'http://uca.kiev.ua/bookmarks.php/?action=add&address={url}&title={title}&description={description}&tags={tags}'),
                array('slashdot',    'Slashdot',            350, 1, 'http://slashdot.org/bookmark.pl?url={url}&title={title}'),
                array('magnolia',    'Magnolia',            360, 1, 'http://ma.gnolia.com/bookmarklet/add?url={url}&title={title}'),
                array('blogmarks',   'Blogmarks',           370, 1, 'http://blogmarks.net/my/new.php?mini=1&url={url}&title={title}'),
                array('current',     'Current',             380, 1, 'http://current.com/clipper.htm?url={url}&title={title}&src=st'),
                array('meneame',     'Meneame',             390, 1, 'http://meneame.net/submit.php?url={url}'),
                array('oknotizie',   'Oknotizie',           400, 1, 'http://oknotizie.alice.it/post?url={url}&title={title}'),
                array('diigo',       'Diigo',               410, 1, 'http://secure.diigo.com/post?url={url}&title={title}'),
                array('funp',        'Funp',                420, 1, 'http://funp.com/pages/submit/add.php?title={title}&url={url}&via=tools'),
                array('hugg',        'Hugg',                430, 1, 'http://www.hugg.com/node/add/storylink?edit[title]={title}&edit[url]={url}'),
                array('dealsplus',   'Dealspl.us',          440, 1, 'http://dealspl.us/add.php?ibm=1&url={url}'),
                array('n4g',         'N4G',                 450, 1, 'http://www.n4g.com/tips.aspx?url={url}&title={title}'),
                array('mrwongcom',   'Mister Wong',         460, 1, 'http://www.mister-wong.com/index.php?action=addurl&bm_url={url}&bm_description={title}'),
                array('faves',       'Faves',               470, 1, 'http://www.faves.com/Authoring.aspx?u={url}&t={title}'),
                array('yigg',        'Yigg',                480, 1, 'http://www.yigg.de/neu?exturl={url}&exttitle={title}'),
                array('fresqui',     'Fresqui',             490, 1, 'http://ocio.fresqui.com/post?url={url}&title={title}'),
                array('care2',       'Care2',               500, 1, 'http://www.care2.com/news/compose?share[link_url]={url}&share[title]={title}'),
                array('kirtsy',      'Kirtsy',              510, 1, 'http://www.kirtsy.com/submit.php?url={url}'),
                array('sphinn',      'Sphinn',              520, 1, 'http://sphinn.com/submit.php?url={url}'),
                array('savethis',    'SaveThis.ru',         530, 1, 'http://savethis.ru/add_story.php?story_url={url}&story_title={title}&story_desc={description}'),
            );

            $svc = get_option(OneButton::option_services);

            return (true == empty($svc) || false == is_array($svc)) ? $services : $svc;
        }

        /**
         * @param array $options
         */
        public function saveOptions(array& $options)
        {
            update_option(OneButton::option_options, $options);
            $this->options = $options;
        }

        /**
         * @param array $options
         */
        public function saveServices(array& $services)
        {
            update_option(OneButton::option_services, $services);
        }

        public function revertServices()
        {
            delete_option(OneButton::option_services);
        }

        public function init()
        {
            if (true == is_404() || true == is_trackback() && true == is_feed()) {
                return;
            }

            $this->my_url = WP_PLUGIN_URL . '/onebutton';

            load_plugin_textdomain('onebutton', PLUGINDIR . '/' . dirname(plugin_basename(__FILE__)) . '/lang');

            $this->loadOptions();

            if (true == is_admin()) {
                add_action('admin_menu', array(&$this, 'admin_menu'));
                add_action('admin_head', array(&$this, 'admin_head'));
            }

            if (false != $this->options['enable']) {
                add_filter('the_content', array(&$this, 'the_content'), 60);

                if (false == is_admin()) {
                    wp_register_style('onebutton-css', $this->my_url . '/onebutton.css', array(), '');
                    wp_enqueue_style('onebutton-css');
                    if (0 == $this->options['show_icons']) {
                        add_action('wp_head', array(&$this, 'wp_head'));
                    }

                    if (true == $this->shouldAddJs()) {
                        add_action('wp_footer', array(&$this, 'wp_footer'));
                    }
                }
            }
        }

        public function admin_head()
        {
            $url = WP_PLUGIN_URL . '/onebutton';
            print <<< delimiter
<style type="text/css" media="all">
#toplevel_page_onebutton-options div.wp-menu-image{background:url({$url}/icon.png) no-repeat 6px -26px}
#toplevel_page_onebutton-options:hover div.wp-menu-image,#toplevel_page_onebutton-options.wp-has-current-submenu div.wp-menu-image{background-position:6px 7px}
</style>
delimiter;
        }

        /**
         * @return bool
         */
        public function shouldAddJs()
        {
            return (false == $this->options['only_single'] || true == $this->options['use_js'] || 0 == $this->options['activation']);
        }

        public function wp_head()
        {
            print '<style type="text/css" media="screen">#sharepage{width:438px} #sharepage ul li{background:none;padding:0 !important;}</style>';
        }

        public function wp_footer()
        {
            if (false == is_feed()) {
                print "<script type='text/javascript' src='{$this->my_url}/onebutton.js'></script>";
                $services = $this->getServices();
                $this->sortAndFilter($services);

                $class = (1 == $this->options['activation']) ? 'onebutton' : 'onebutton2';

                if (false == empty($services)) {
                    $tpl = $this->buildTemplate($services);

                    if (true == $this->options['use_js']) {
                        $tpl = str_replace(array("\r", "\n", '</'), array('', "\\n", '<\\/'), addslashes($tpl));
?>
<script type="text/javascript">/*<![CDATA[*/
function onebutton_gebcn(a,b,c){var d=(b=="*"&&a.all)?a.all:a.getElementsByTagName(b);var e=[];c=c.replace(/\-/g,"\\-");var f=new RegExp("(^|\\s)"+c+"(\\s|$)");var g;for(var i=0;i<d.length;i++){g=d[i];if(f.test(g.className)){e.push(g)}}return(e)}
function onebutton_build(){var d=document,a=d.createElement('div'),n=onebutton_gebcn(d,'div','onebutton_no_js');a.innerHTML='<?php echo $tpl; ?>';d.getElementsByTagName('body')[0].appendChild(a);for(var i=0; i<n.length;++i){n[i].className='<?php echo $class; ?>'}}
var __u='undefined';if(__u!=typeof odl&&__u!=typeof odl.register){odl.register(onebutton_build)}else if(__u!=typeof Prototype&&__u!=typeof Event&&Event.observe){Event.observe(document,'dom:loaded',onebutton_build)}else if(__u!=typeof jQuery){jQuery(document).ready(onebutton_build)}else{if(window.addEventListener){window.addEventListener('load',onebutton_build,false)}else if(window.addEventListener){window.addEventListener('onload',onebutton_build)}else{window['onload']=onebutton_build}}
/*]]>*/
</script>
<?php
                    }
                    else {
?>
<script type="text/javascript">/*<![CDATA[*/
function onebutton_gebcn(a,b,c){var d=(b=="*"&&a.all)?a.all:a.getElementsByTagName(b);var e=[];c=c.replace(/\-/g,"\\-");var f=new RegExp("(^|\\s)"+c+"(\\s|$)");var g;for(var i=0;i<d.length;i++){g=d[i];if(f.test(g.className)){e.push(g)}}return(e)}
function onebutton_build(){var d=document,n=onebutton_gebcn(d,'div','onebutton_no_js');for(var i=0; i<n.length;++i){n[i].className='<?php echo $class; ?>'}}
var __u='undefined';if(__u!=typeof odl&&__u!=typeof odl.register){odl.register(onebutton_build)}else if(__u!=typeof Prototype&&__u!=typeof Event&&Event.observe){Event.observe(document,'dom:loaded',onebutton_build)}else if(__u!=typeof jQuery){jQuery(document).ready(onebutton_build)}else{if(window.addEventListener){window.addEventListener('load',onebutton_build,false)}else if(window.addEventListener){window.addEventListener('onload',onebutton_build)}else{window['onload']=onebutton_build}}
/*]]>*/
</script>
<?php
                        echo $tpl;
                    }
                }
            }
        }

        /**
         * @return string
         */
        private function getLayout()
        {
            $services = $this->getServices();
            $this->sortAndFilter($services);

            if (false == empty($services)) {
                return $this->buildTemplate($services);
            }

            return '';
        }

        /**
         * @param array $services
         * @return string
         */
        private function buildTemplate(array& $services)
        {
            $header = __("Add to Social Bookmarks", "onebutton");

            $attrs = array();
            if (true == $this->options['nofollow']) {
                $attrs[] = 'rel="nofollow"';
            }

            if (true == $this->options['newwindow']) {
                $attrs[] = 'target="_blank"';
            }

            $attrs = (false == empty($attrs)) ? (' ' . join(' ', $attrs)) : '';

            ob_start();
            print <<< delimiter
<div id="sharepage">
    <div class="title"><a href="http://blog.sjinks.org.ua/?p=202">{$header}</a></div>
    <ul class="clearfix">
delimiter;
            foreach ($services as $x) {
                $x[1] = attribute_escape($x[1]);
                $x[4] = wp_specialchars($x[4]);
                print "<li id='{$x[0]}'><a href='{$x[4]}'{$attrs}>{$x[1]}</a></li>";
            }

            print <<< delimiter
    </ul>
</div>
delimiter;
            return ob_get_clean();
        }

        /**
         * @desc the_content content filter
         * @param string $content
         * @return string
         */
        public function the_content($content)
        {
            $post_id = get_the_ID();
            if (get_post_meta($post_id, 'disable_onebutton', true)) {
                return $content;
            }

            $all = $this->get_metas();

            $permalink   = $all['permalink'];
            $title       = $all['title'];
            $description = $all['description'];
            $tags        = $all['tags'];

            unset($all);

            $add = $this->shouldAddJs();

            if (true == is_singular() && false == $add) {
                $permalink   = rawurlencode($permalink);
                $title       = rawurlencode($title);
                $description = rawurlencode($description);
                $tags        = rawurlencode($tags);

                $template = str_replace(array('{url}', '{title}', '{description}', '{tags}'), array($permalink, $title, $description, $tags), $this->getLayout());
                return $content . '<div class="onebutton"><img class="atb" src="'. $this->my_url . '/bookmarks.png" alt="' . __('Add to Bookmarks', 'onebutton') . '" title="' . __('Add to Bookmarks', 'onebutton') . '"/><!--[if lte IE 6]><a href="#" class="obie"><table><tbody><tr><td><![endif]-->' . $template . '<!--[if lte IE 6]></td></tr></tbody></table></a><![endif]--></div>';
            }

            if (true == $add) {
                $permalink   = js_escape($permalink);
                $title       = js_escape($title);
                $description = js_escape($description);
                $tags        = js_escape($tags);

                if (1 == $this->options['activation']) {
                    return $content . '<div class="onebutton onebutton_no_js" onmouseout="CloseOneButton()" onmouseover="OneButton(this, \'' . $permalink . '\', \'' . $title . '\', \'' . $description . '\', \'' . $tags . '\')"><img class="atb2" src="'. $this->my_url . '/bookmarks.png" alt="' . __('Add to Bookmarks', 'onebutton') . '" title="' . __('Add to Bookmarks', 'onebutton') . '"/></div>';
                }

                return $content . '<div class="onebutton onebutton_no_js" onclick="toggleOneButton(this, \'' . $permalink . '\', \'' . $title . '\', \'' . $description . '\', \'' . $tags . '\')"><img class="atb2" src="'. $this->my_url . '/bookmarks.png" alt="' . __('Add to Bookmarks', 'onebutton') . '" title="' . __('Add to Bookmarks', 'onebutton') . '"/></div>';
            }

            return $content;
        }

        /**
         * @return array
         */
        public function get_metas()
        {
            $permalink   = apply_filters('the_permalink', get_permalink());
            $title       = the_title('', '', false);
            $description = get_post_meta($GLOBALS['post']->ID, "description", true);
            $cats        = get_the_category();
            $tags        = get_the_terms(0, 'post_tag');

            if (true == empty($description)) {
                $description = $title;
            }

            $tax = array();
            if (false == empty($cats)) {
                foreach ($cats as $x) {
                    $tax[] = $x->name;
                }
            }

            if (false == empty($tags)) {
                foreach ($tags as $x) {
                    $tax[] = $x->name;
                }
            }

            $tax  = array_unique($tax);
            $tags = join(',', $tax);

            return compact('permalink', 'title', 'description', 'tags');
        }

        public function admin_menu()
        {
            add_menu_page(__('OneButton Settings', 'onebutton'), __('OneButton'), 'manage_options', 'onebutton/options.php', '', 'div');
            add_submenu_page('onebutton/options.php', __('OneButton Settings', 'onebutton'), __('Settings', 'onebutton'), 'manage_options', 'onebutton/options.php');
            add_submenu_page('onebutton/options.php', __('Bookmark Services', 'onebutton'), __('Services', 'onebutton'), 'manage_options', 'onebutton/services.php');
        }

        protected function sortAndFilter(array &$services)
        {
            $services = array_filter($services, array(&$this, 'filter__'));
            usort($services, array(&$this, 'compare__'));
        }

        /**
         * @internal
         * @desc Callback for array_filter()
         * @access private
         * @param array $x
         * @return bool
         */
        public function filter__($x)
        {
            return true == $x[3];
        }

        /**
         * @internal
         * @desc Callback for usort()
         * @access private
         * @param array $x
         * @param array $y
         * @return int
         */
        public function compare__($x, $y)
        {
            return ($x[2] < $y[2]) ? -1 : (($x[2] == $y[2]) ? 0 : 1);
        }
    }

    $one_button = &OneButton::instance();

    /**
     * Inserts OneButton into template
     *
     * @param string|bool $title
     * @param string|bool $permalink
     * @param string|bool $description
     * @param string|bool $tags
     * @param bool $return
     * @return string
     */
    function insert_onebutton($title = false, $permalink = false, $description = false, $tags = false, $return = false)
    {
        $one_button = &OneButton::instance();
        if (false == $one_button->shouldAddJs()) {
            add_action('wp_footer', array(&$one_button, 'wp_footer'));
        }

        $options = &$one_button->loadOptions();
        $my_url  = WP_PLUGIN_URL . '/onebutton';

        if (false === $title) {
            $all         = $one_button->get_metas();
            $permalink   = js_escape($all['permalink']);
            $title       = js_escape($all['title']);
            $description = js_escape($all['description']);
            $tags        = js_escape($all['tags']);
        }

        if (1 == $options['activation']) {
            $s = '<div class="onebutton onebutton_no_js" onmouseout="CloseOneButton()" onmouseover="OneButton(this, \'' . $permalink . '\', \'' . $title . '\', \'' . $description . '\', \'' . $tags . '\')"><img class="atb2" src="'. $my_url . '/bookmarks.png" alt="' . __('Add to Bookmarks', 'onebutton') . '" title="' . __('Add to Bookmarks', 'onebutton') . '"/></div>';
        }
        else {
            $s = '<div class="onebutton onebutton_no_js" onclick="toggleOneButton(this, \'' . $permalink . '\', \'' . $title . '\', \'' . $description . '\', \'' . $tags . '\')"><img class="atb2" src="'. $my_url . '/bookmarks.png" alt="' . __('Add to Bookmarks', 'onebutton') . '" title="' . __('Add to Bookmarks', 'onebutton') . '"/></div>';
        }

        if (true == $return) {
            return $s;
        }

        return print $s;
    }
?>