<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: aLinksKeyphrases.php 44 2008-03-24 18:00:53Z sean $
 */
/**
 * aLinks keyphrases class
 *
 * The parent class for keyphrase modules.
 */
class aLinksKeyphrases {

	/**
	 * The name of the keyphrase module.
	 * @var string
	 */
	var $name = null;
	
	var $requiredOptions;
	
	var $requiredDefines;
	
	/**
	 * The keyphrase options.
	 * @var array
	 */
	var $options;
	
	/**
	 * The aLinks settings.
	 * @var array
	 */
	var $settings;
	
	/**
	 * A string of extra HTML/JavaScript
	 * that needs to be inserted into
	 * each new link.
	 * @var string
	 */
	var $extraHTML;
	
	/**
	 * The WPDB object.
	 * @var obj
	 */
	var $wpdb;
	
	/**
	 * The string that prefixes all tables
	 * in the WordPress database.
	 * @var string
	 */
	var $table_prefix;
	
	var $realKeyphrase;
	
	function hasKeyphrases() {
		// Not used yet
	}
	function getKeyphrases() {
		// Not used yet
	}
	
	/**
	 * Sets the aLinks settings property
	 *
	 * @param	array	$settings	The aLinks settings
	 * @return	void
	 */
	function setSettings($settings) {
		$this->settings = $settings;
	}
	
	function setRealKeyphrase($keyphrase) {
		$this->realKeyphrase = $keyphrase;
	}
	
	/**
	 * Sets the $extraHTML property.
	 *
	 * @param	string	$html	The HTML to insert into links
	 * @return	void
	 */
	function setExtraHtml($html) {
		$this->extraHTML = $html;
	}
	
	function setImageHtml($html) {
		$this->imageHTML = $html;
	}
	
	/**
	 * Sets the keyphrase options
	 *
	 * @param	array	$options	The keyphrase options
	 * @return	void
	 */
	function setOptions($options) {
		$this->options = $options;
	}
	
	function setDatabase(&$wpdb, $table_prefix) {
		$this->wpdb = &$wpdb;
		$this->table_prefix = $table_prefix;
	}
	
	function checkAll($defines) {
		if (!empty($this->requiredOptions)) {
			foreach ($this->requiredOptions as $option) {
				if (empty($this->options[$option])) {
					return false;
				}
			}
		}
		if (!empty($this->requiredDefines)) {
			foreach ($this->requiredDefines as $define) {
				if (empty($defines[$define])) {
					return false;
				}
			}
		}
		return true;
	}
	
	/**
	 * The linking method
	 *
	 * This method does the work of turning the keyphrase into
	 * a link.  Returns the keyphrase as a link, or returns
	 * the keyphrase without any changes if there was a problem
	 * linking the keyphrase.
	 *
	 * @param	string	$keyphrase		The keyphrase to link
	 * @param	string	$description	The keyphrase description
	 * @param	array	$defines		The additional information defined for the keyphrase
	 * @return	string
	 */
	function doPhrase(&$postObj, $keyphrase, $description, $defines) {
		return $keyphrase;
	}
	
	/**
	 * Returns the name of the module
	 *
	 * @return	string
	 */
	function getName() {
		return $this->name;
	}
	
}