<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: keyphrases.php 42 2008-03-24 17:50:25Z sean $
 */
include($this->viewsDir . '/include.php');
$modules = $this->Modules->getModules();
?>
<div class="wrap">
	<h2><?php echo $this->alinksLang->_('Keyphrases'); ?></h2>
	<div id="keyphrasebox">
		<div class="dbx-group" id="keyphrase-tools">
			<div id="searchreplace" class="dbx-box">
				<h3 class="dbx-handle"><?php echo $this->alinksLang->_('Toolbox'); ?></h3>
				<div class="dbx-content">
				
				<p><strong><?php echo $this->alinksLang->_('Search for keyphrase'); ?>:</strong><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon" style="border: 0px; margin-left: 5px;" onclick="al_help('keyphrases-search');"/><br />
				<input type="text" name="searchterm" id="searchterm" /> <input type="button" value="<?php echo $this->alinksLang->_('Search'); ?>" onclick="searchForKeyphrase();" /></p>
				<p><strong><?php echo $this->alinksLang->_('Find and replace'); ?>:</strong><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon" style="border: 0px; margin-left: 5px;" onclick="al_help('keyphrases-findreplace');"/><br />
				<?php echo $this->alinksLang->_('Find'); ?> <input type="text" name="find" id="find" /> <?php echo $this->alinksLang->_('Replace with'); ?> <input type="text" name="replacement" id="replacement" /> <input type="button" value="<?php echo $this->alinksLang->_('Find & Replace'); ?>" onclick="findAndReplace();" /></p>
				<p><strong><?php echo $this->alinksLang->_('Mass delete keyphrase'); ?>:</strong><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon" style="border: 0px; margin-left: 5px;" onclick="al_help('keyphrases-massdelete');"/><br />
				<input type="text" name="massdelete" id="massdelete" size="30" /> <input type="button" value="<?php echo $this->alinksLang->_('Delete Keyphrase'); ?>" onclick="massDeleteKeyphrase();" /></p>
				<p><strong><?php echo $this->alinksLang->_('Clipboard'); ?>:</strong><img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon" style="border: 0px; margin-left: 5px;" onclick="al_help('keyphrases-clipboard');"/><br />
				<input type="button" value="<?php echo $this->alinksLang->_('Copy 1'); ?>" onclick="clipboard_copy(1);"/><input type="button" value="<?php echo $this->alinksLang->_('Paste 1'); ?>" onclick="clipboard_paste(1);" /> <input type="button" value="<?php echo $this->alinksLang->_('Copy 2'); ?>"  onclick="clipboard_copy(2);"/><input type="button" value="<?php echo $this->alinksLang->_('Paste 2'); ?>" onclick="clipboard_paste(2);" /> <input type="button" value="<?php echo $this->alinksLang->_('Copy 3'); ?>" onclick="clipboard_copy(3);" /><input type="button" value="<?php echo $this->alinksLang->_('Paste 3'); ?>" onclick="clipboard_paste(3);" /> <input type="button" value="<?php echo $this->alinksLang->_('Copy 4'); ?>" onclick="clipboard_copy(4);" /><input type="button" value="<?php echo $this->alinksLang->_('Paste 4'); ?>" onclick="clipboard_paste(4);" /></p>
				</div>
			</div>

			<div class="dbx-box"  id="yourkeyphrases">
				<h3 class="dbx-handle"><?php echo $this->alinksLang->_('Your Keyphrases'); ?></h3>
				<div class="dbx-content">
				<iframe name="keyphrasesList" onload="gridTable = keyphrasesList.table;gridTable.setURL('<?php echo ALINKS_URL; ?>/classes/aLinksBackend.php');gridTable.setRequestMethod('POST');" src="<?php echo ALINKS_URL; ?>/kp/explorer.php" style="width: 95%; height: 200px; margin: 15px;"></iframe>
				</div>
			</div>
			
			<?php
			
			if ($modules) {
				$alinksForms = new aLinksForms;
				foreach ($modules as $moduleName => $module) {
				$defines = $module['defines'];
				
				?>
				<div class="dbx-box" style="list-style-type:none;">
					<form method="post" name="form_<?php echo $module['info']['name']; ?>" onsubmit="return addKeyphrase(this);">
						<input type="hidden" name="alinks_action" value="keyphrase" />
						<input type="hidden" name="module" value="<?php echo $moduleName; ?>" />
						<h3 style="border-bottom: #CCC 1px solid;" class="dbx-handle"><?php echo $module['info']['name']; ?> <?php echo $this->alinksLang->_('Keyphrases'); ?></h3>
						<div class="dbx-content">
							<div style="padding: 10px;">
								<p><strong><?php echo $this->alinksLang->_('Keyphrase'); ?>:</strong> <input type="text" name="keyphrase" id="keyphrase" size="40" onfocus="currentElement = this;" /></p>
								<p><strong><?php echo $this->alinksLang->_('Description'); ?>:</strong> <input type="text" name="description" id="description" size="50" onfocus="currentElement = this;" /></p>
								<?php
								foreach ($defines as $define) {
									$alinksForms->set($define);
									$alinksForms->show();
								}
								?>
								<p class="submit"><input type="submit" value="<?php echo $this->alinksLang->_('Update Keyphrase'); ?> &raquo;" /></p>
							</div>
						</div>
					</form>
				</div>
				<?php
				}
			}
			?>

		</div>
	</div>
</div>
