<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package   alinks
 * @license   GPL
 * @version   $Id: explorer.php 42 2008-03-24 17:50:25Z sean $
 */
include_once('../../../../wp-config.php');
include_once('../../../../wp-admin/admin.php');
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link href="<?php echo ALINKS_URL; ?>/xp/grid.css" rel="stylesheet" type="text/css"></link>
<script type="text/javascript" src="<?php echo ALINKS_JS_URL; ?>/grid.js" charset="utf-8"></script>
<style type="text/css">
body {
	background-color: #FFF;
	margin: 0px;
	padding: 0px;
	font-family: arial;
}
.line, .line2 {
	color: #009;
	font-family: Tahoma, MS Sans Serif, helvetica;
	font-weight: bold;
	font-size: 11px;
	margin-bottom: 5px;
}

.line2 {
	font-weight: normal;
}

.loading {
	width:400px;
	height:20px;
	background:url(xp/loading.gif) no-repeat;
}	
.active-controls-grid {height: 100%; font: menu;}
.active-column-0 {text-align: left; color: #009; width: 150px;}
.active-column-1 {text-align:left; width: 200px;}
.active-column-2 {text-align: left; width: 150px;}
.active-grid-column {border-right: 1px solid threedlightshadow;}
.active-grid-row {border-bottom: 1px solid threedlightshadow;}
.active-templates-row.gecko {display: -moz-box; width: auto; min-width: 100%;}
.active-row-highlight {background-color: #ddeeff!important}
.active-row-highlight .active-row-cell {background-color: #ddeeff;}
.active-mark-true .active-column-2 {color: #f00}


</style>
</head>
<body>
<script type="text/javascript" charset="utf-8">

	var table = new Active.XML.Table;
	table.setURL('<?php echo ALINKS_URL; ?>/classes/aLinksBackend.php');
	
	var columns = ["Keyphrase", "Description", "Type"];
	
	table.request();

	var obj = new Active.Controls.Grid;
	obj.setColumnProperty("texts", columns);
	obj.setDataModel(table);

	var row = new Active.Templates.Row;
	row.setEvent("ondblclick", function () {this.action ("myAction")});
	obj.setTemplate("row", row);
	obj.setAction("myAction", editKeyword);
	
	function editKeyword(src) {
		var iIndex = obj.getSelectionProperty("index");
		var keyphrase = obj.getDataProperty("text", iIndex, 0);
		var description = obj.getDataProperty("text", iIndex, 1);
		var module = obj.getDataProperty("text", iIndex, 2);
		var id = obj.getDataProperty("text", iIndex, 3);
		
		
		table.setRequestMethod('POST');
		table.setParameter('action', 'keyphrase_form');
		table.setParameter('keyphraseID', id);
		table.request();
		table.response = function(xml){
			document.body.innerHTML = xml;
		}
		//alert(id);
	}
	
	document.write(obj);
</script>
</body>
</html>