<?php    
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package   alinks
 * @license   GPL
 * @version   $Id: unicode.php 45 2008-03-24 18:01:45Z sean $
 */
 
function encodeUtfEnt($str) {
	$str = preg_replace_callback('/&#([0-9]+);/', create_function('$s','return dcr2utf8($s[1]);'), $str);
	return preg_replace_callback('/&#x([a-f0-9]+);/i', create_function('$s','return dcr2utf8(hexdec($s[1]));'), $str);
}

function dcr2utf8($src) {
	$dest = '';
	if ($src < 0){
		return false;
	} elseif($src <= 0x007f) {
		$dest .= chr($src);
	} elseif($src <= 0x07ff) {
		$dest .= chr(0xc0 | ($src >> 6));
		$dest .= chr(0x80 | ($src & 0x003f));
	} elseif ($src == 0xFEFF) {
		// nop -- zap the BOM
	}elseif ($src >= 0xD800 && $src <= 0xDFFF) {
		// found a surrogate
		return false;
	} elseif ($src <= 0xffff) {
		$dest .= chr(0xe0 | ($src >> 12));
		$dest .= chr(0x80 | (($src >> 6) & 0x003f));
		$dest .= chr(0x80 | ($src & 0x003f));
	}elseif($src <= 0x10ffff) {
		$dest .= chr(0xf0 | ($src >> 18));
		$dest .= chr(0x80 | (($src >> 12) & 0x3f));
		$dest .= chr(0x80 | (($src >> 6) & 0x3f));
		$dest .= chr(0x80 | ($src & 0x3f));
	} else { 
		// out of range
		return false;
	}
	return $dest;
}

function utf8RawUrlDecode ($source) {
    $decodedStr = "";
    $pos = 0;
    $len = strlen ($source);
    while ($pos < $len) {
        $charAt = substr ($source, $pos, 1);
        if ($charAt == '%') {
            $pos++;
            $charAt = substr ($source, $pos, 1);
            if ($charAt == 'u') {
                // we got a unicode character
                $pos++;
                $unicodeHexVal = substr ($source, $pos, 4);
                $unicode = hexdec ($unicodeHexVal);
                $entity = "&#". $unicode . ';';
                $decodedStr .= utf8_encode ($entity);
                $pos += 4;
            }
            else {
                // we have an escaped ascii character
                $hexVal = substr ($source, $pos, 2);
                $decodedStr .= chr (hexdec ($hexVal));
                $pos += 2;
            }
        } else {
            $decodedStr .= $charAt;
            $pos++;
        }
    }
    return $decodedStr;
}