<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package   alinks
 * @license   GPL
 * @version   $Id: aLinksGraph.php 44 2008-03-24 18:00:53Z sean $
 */
include_once('../../../../wp-config.php');
include_once('../../../../wp-admin/admin.php');
include_once(ALINKS_FUNCTIONS_PATH . '/LastXgraph.php');

/**
 * aLinks graph class
 *
 * Used to build graph images for statistics.
 */
class aLinksGraph extends aLinksApp {

	/**
	 * The data array for the graph.
	 * @var array
	 */
	var $data;
	
	/**
	 * The type of graph.
	 * @var string
	 */
	var $graphMethod;
	
	/**
	 * The title of the graph.
	 * @var string
	 */
	var $title;
	
	/**
	 * The verticle label for the graph.
	 * @var string
	 */
	var $scaleLabel;
	
	/**
	 * Class constructor
	 *
	 * @return	void
	 */
	function aLinksGraph() {
		if (empty($_GET)) {
			return;
		}
		//if(get_magic_quotes_gpc() || get_magic_quotes_runtime()) {
			$_GET = $this->stripSlashesDeep($_GET);
		//}

		$this->data = 		urldecode($_GET['graphdata']);
		$this->data = 		unserialize($this->data);
		$this->graphMethod = 	urldecode($_GET['graphmethod']);
		$this->title = 		urldecode($_GET['title']);
		$this->scaleLabel = 	urldecode($_GET['scalelabel']);
	}
	
	/**
	 * Creates the graph image
	 *
	 * Creates the graph image and sends it to the browser.
	 *
	 * @return	void
	 */
	function show() {
		LastXgraph	(
				$this->data,
				$this->graphMethod,
				$this->title,
				$this->scaleLabel,
				true,
				50,
				600,
				250,
				"arial.ttf",
				11,
				10,
				"6DA6D1",
				"0D324F",
				"FFFFFF",
				"AD6DD1;D1D06D;D19F6D;AD6DD1;D1D06D;D19F6D;"
					);
	}
}

$alinksGraph = new aLinksGraph;
$alinksGraph->show();