<?php
/*
Plugin Name: Pure PHP Localization
Version: 0.3
Plugin URI: http://uplift.ru/projects/
Description: Converts gettext binary message catalog to an array of strings. Allows to save some amount of RAM on a shared hosting server.
Author: Sergey Biryukov
Author URI: http://sergeybiryukov.ru/
*/

$php_l10n_locale = WPLANG;
$php_l10n_path = dirname(__FILE__);
$php_l10n_filename = "$php_l10n_path/strings-$php_l10n_locale.php";
$php_l10n_lang_dir = defined('WP_LANG_DIR') ? WP_LANG_DIR : ABSPATH . LANGDIR;

function php_l10n_create_array() {
	global $l10n, $php_l10n_path, $php_l10n_filename, $php_l10n_strings;

	$strings = array();

	if ( isset($l10n['default']->headers) ) {
		$strings[''] = '';
		foreach ( $l10n['default']->headers as $header => $value ) {
			$strings[''] .= "$header: $value\n";
		}
	}

	if ( isset($l10n['default']->entries) ) {
		foreach ( $l10n['default']->entries as $original => $translation_entry ) {
			if ( isset($translation_entry->plural) )
				$original .= chr(0) . $translation_entry->plural;

			$strings[$original] = implode(chr(0), $translation_entry->translations);
		}
	} elseif ( isset($l10n['default']->cache_translations) ) {
		foreach ( $l10n['default']->cache_translations as $original => $translation ) {
			$strings[$original] = $translation;
		}
	}

	if ( count($strings) <= 1 )
		return;

	$content = file_get_contents("$php_l10n_path/strings-template.php");
	$content = sprintf($content, var_export($strings, true));
	$content = str_replace("\n  ", "\n\t", $content);
	$content = str_replace('\000', chr(0), $content);

	file_put_contents($php_l10n_filename, $content);

	unset($l10n['default']);
	php_l10n_create_imaginary_reader();
	include($php_l10n_filename);
}

function php_l10n_create_imaginary_reader() {
	global $l10n;

	if ( class_exists('gettext_reader') ) {
		$l10n['default'] = new gettext_reader(false);
	    $l10n['default']->cache_translations = array();
		$l10n['default']->table_originals = array();
		$l10n['default']->table_translations = array();
	}
}

function php_l10n_override_default_textdomain($false, $domain, $mofile) {
	return $domain == 'default';
}

function php_l10n_override_default_locale($locale) {
	global $l10n, $php_l10n_locale;

	if ( !isset($l10n['default']) ) {
		$locale = 'en_US';
		php_l10n_create_imaginary_reader();
	} else {
		$locale = $php_l10n_locale;
	}

	return $locale;
}

if ( file_exists("$php_l10n_lang_dir/$php_l10n_locale.mo") ) {
	$mo_creation_time = filemtime("$php_l10n_lang_dir/$php_l10n_locale.mo");

	if ( file_exists($php_l10n_filename) && filemtime($php_l10n_filename) > $mo_creation_time ) {
		include($php_l10n_filename);
		add_filter('override_load_textdomain', 'php_l10n_override_default_textdomain', 10, 3);
		if ( class_exists('gettext_reader') ) {
			add_filter('locale', 'php_l10n_override_default_locale');
		}
	} else {
		add_action('init', 'php_l10n_create_array');
	}
}
?>