<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package   alinks
 * @license   GPL
 * @version   $Id: include.php 51 2008-03-24 18:10:23Z sean $
 */
 
$clipboards = get_option('alinks_clipboards');
for ($i = 1; $i < 5; $i++) {
	if (seems_utf8(encodeUtfEnt($clipboards[1]))) {
		$clipboards[1] = encodeUtfEnt($clipboards[1]);
	}
}
$settings = get_option('alinks_settings');
?>
<script type="text/javascript" src="../wp-includes/js/dbx.js"></script>
<script type="text/javascript" charset="utf-8">
addLoadEvent( function()
{
	var manager = new dbxManager('keyphrase-dbx');
	//create new docking boxes group
	var something = new dbxGroup(
		'keyphrase-tools', 		// container ID [/-_a-zA-Z0-9/]
		'vertical', 	// orientation ['vertical'|'horizontal']
		'10', 			// drag threshold ['n' pixels]
		'yes',			// restrict drag movement to container axis ['yes'|'no']
		'10', 			// animate re-ordering [frames per transition, or '0' for no effect]
		'yes', 			// include open/close toggle buttons ['yes'|'no']
		'open', 		// default state ['open'|'closed']
		'open', 		// word for "open", as in "open this box"
		'close', 		// word for "close", as in "close this box"
		'click-down and drag to move this box', // sentence for "move this box" by mouse
		'click to %toggle% this box', // pattern-match sentence for "(open|close) this box" by mouse
		'use the arrow keys to move this box', // sentence for "move this box" by keyboard
		', or press the enter key to %toggle% it',  // pattern-match sentence-fragment for "(open|close) this box" by keyboard
		'%mytitle%  [%dbxtitle%]' // pattern-match syntax for title-attribute conflicts
		);
	
});
</script>
<script type="text/javascript" charset="utf-8">
	var currentElement;
	var clipboards = new Array();
	clipboards[1] = unescape("<?php echo $clipboards[1]; ?>");
	clipboards[2] = unescape("<?php echo $clipboards[2]; ?>");
	clipboards[3] = unescape("<?php echo $clipboards[3]; ?>");
	clipboards[4] = unescape("<?php echo $clipboards[4]; ?>");
	
	function addKeyphrase(modForm) {

		gridTable.setParameter('action', 'new_keyphrase');
		gridTable.setParameter('module', modForm.elements[1].value);
		gridTable.setParameter('keyphrase', escape(modForm.elements[2].value));
		gridTable.setParameter('description', escape(modForm.elements[3].value));
		
		for (var i = 4; i < modForm.elements.length; i++) {
			gridTable.setParameter('elementName[' + (i - 4) + ']', modForm.elements[i].name);
			gridTable.setParameter('elementValue[' + (i - 4) + ']', modForm.elements[i].value);
		}
		gridTable.request();
		gridTable.response = function(xml){
			gridTable.setXML(xml);
			keyphrasesList.obj.refresh();
		}
		clearAll(modForm);
		return false;
	}
	
	function updateKeyphrase(modForm) {

		gridTable.setParameter('action', 'update_keyphrase');
		gridTable.setParameter('keyphraseID', modForm.elements[1].value);
		gridTable.setParameter('keyphrase', escape(modForm.elements[2].value));
		gridTable.setParameter('description', escape(modForm.elements[3].value));
		
		for (var i = 4; i < modForm.elements.length; i++) {
			gridTable.setParameter('elementName[' + (i - 4) + ']', modForm.elements[i].name);
			gridTable.setParameter('elementValue[' + (i - 4) + ']', escape(modForm.elements[i].value));
		}
		gridTable.request();
		gridTable.response = function(xml){
			gridTable.setXML(xml);
			keyphrasesList.document.body.innerHTML = keyphrasesList.obj;
			keyphrasesList.obj.refresh();
			
		}
		return false;
	}
	
	function massDeleteKeyphrase() {
		var massDeleteKeyphrase = document.getElementById('massdelete').value;
		if (!massDeleteKeyphrase) {
			return;
		}
		var agree = confirm('<?php echo $this->alinksLang->_('Are you sure you want to mass delete the'); ?> "' + massDeleteKeyphrase + '" <?php echo $this->alinksLang->_('keyphrase'); ?>?');
		if (!agree) {
			return false;
		}

		gridTable.setParameter('action', 'massdelete_keyphrase');
		gridTable.setParameter('keyphrase', escape(massDeleteKeyphrase));
		gridTable.request();
		gridTable.response = function(xml){
			gridTable.setXML(xml);
			keyphrasesList.document.body.innerHTML = keyphrasesList.obj;
			keyphrasesList.obj.refresh();
		}
		document.getElementById('massdelete').value = '';
	}
	
	function deleteKeyphrase(keyphraseID) {
		<?php
		if (empty($settings['nodeletewarning'])) {
			?>
			var agree = confirm('<?php echo $this->alinksLang->_('Are you sure you want to delete this keyphrase?'); ?>');
			if (!agree) {
				keyphrasesList.document.body.innerHTML = keyphrasesList.obj;
				return false;
			}
			<?php
		}
		?>

		gridTable.setParameter('action', 'delete_keyphrase');
		gridTable.setParameter('keyphraseID', keyphraseID);
		gridTable.request();
		gridTable.response = function(xml){
			gridTable.setXML(xml);
			keyphrasesList.document.body.innerHTML = keyphrasesList.obj;
			keyphrasesList.obj.refresh();
		}
		return false;
	}
	
	function cancelEdit() {
		keyphrasesList.document.body.innerHTML = keyphrasesList.obj;
	}
	
	function clearAll(modForm) {
		for (var i = 2; i < (modForm.elements.length - 1); i++) {
			modForm.elements[i].value = '';
		}
		keyphrasesList.obj.setSelectionProperty("values", []);
	}

	function deleteMod(modName) {
		var agree = confirm('<?php echo $this->alinksLang->_('Are you sure you want to delete the keyphrase module'); ?> ' + modName + '?');
		if (agree) {
			return true ;
		} else {
			return false ;
		}
	}

	function clipboard_copy(clipboard) {
		var celText = selectedText(currentElement);

		gridTable.setParameter('action', 'new_clipboard');
		gridTable.setParameter('clipboardNumber', clipboard);
		gridTable.setParameter('clipboardValue', escape(celText));
		gridTable.request();
		clipboards[clipboard] = unescape(celText);
	}
	
	function clipboard_paste(clipboard) {
		insertAtCursor(currentElement, clipboards[clipboard]);
	}
	
	function insertAtCursor(myField, myValue) {
		if (!myField) {
			return;
		}
		if (document.selection) {
			myField.focus();
			sel = document.selection.createRange();
			sel.text = myValue;
		} else if (myField.selectionStart || myField.selectionStart == '0') {
			var startPos = myField.selectionStart;
			var endPos = myField.selectionEnd;
			myField.value = myField.value.substring(0, startPos)
			+ myValue
			+ myField.value.substring(endPos, myField.value.length);
		} else {
			myField.value += myValue;
		}
		myField.focus();
	}
	
	function selectedText(input){
		if (!input) {
			return;
		}
		if(document.selection && document.selection.createRange().text != ''){ // IS IE
			return document.selection.createRange().text;
		} else { // Not IE.. assume Mozilla?
			var startPos = input.selectionStart;
			var endPos = input.selectionEnd;
			return input.value.substring(startPos, endPos);
		}
	}
	
	function searchForKeyphrase() {
		var searchTerm = document.getElementById('searchterm').value;
		if (!searchTerm) {
			return;
		}

		gridTable.setParameter('action', 'search_keyphrase');
		gridTable.setParameter('searchTerm', escape(searchTerm));
		gridTable.request();
		gridTable.response = function(xml){
			gridTable.setXML(xml);
			keyphrasesList.obj.refresh();
		}
	}
	
	function findAndReplace() {
		var find = document.getElementById('find').value;
		var replacement = document.getElementById('replacement').value;
		if (!find || !replacement) {
			return;
		}
		var agree = confirm('<?php echo $this->alinksLang->_('Are you sure you want to replace all keyphrases with'); ?> "' + find + '" <?php echo $this->alinksLang->_('with'); ?> "' + replacement + '"?');
		if (!agree) {
			return;
		}
		
		gridTable.setParameter('action', 'find_replace');
		gridTable.setParameter('find', escape(find));
		gridTable.setParameter('replacement', escape(replacement));
		gridTable.request();
		gridTable.response = function(xml){
			gridTable.setXML(xml);
			keyphrasesList.obj.refresh();
		}
		document.getElementById('find').value = '';
		document.getElementById('replacement').value = '';
	}
	
	function al_help(topic) {
		window.location = 'admin.php?page=alinks-help#' + topic;
	}
</script>
<style type="text/css">

#graphsbox {
	width: 630px;
}

#graphsbox h3 {
	padding: 3px;
	font-weight: bold;
	font-size: 13px;
}

#graphsbox a.dbx-toggle, #graphsbox a.dbx-toggle-open:visited {
	height: 25px;
	width: 27px;
	background-position: 0 0px;
}

#graphsbox a.dbx-toggle-open, #graphsbox a.dbx-toggle-open:visited {
	height: 25px;
	width: 27px;
	background-position: 0 -25px;
}

#graphsbox .dbx-content {
	background: url(<?php echo ALINKS_URL; ?>/images/box-butt.gif) no-repeat bottom right;
	padding: 0 10px 10px 10px;
}

#graphsbox .dbx-handle {
	padding: 6px 1em 2px;
	font-size: 12px;
}

#graphsbox .dbx-box {
	margin: 10px 0 10px 0;
	background: url(<?php echo ALINKS_URL; ?>/images/box-bg.gif) repeat-y right;
}

#graphsbox a.dbx-toggle, a.dbx-toggle:visited {
	display:block;
	overflow: hidden;
	background-image: url(<?php echo get_option('siteurl'); ?>/wp-admin/images/toggle.gif);
	position: absolute;
	top: 0px;
	right: 0px;
	background-repeat: no-repeat;
	border: 0px;
	margin: 0px;
	padding: 0px;
}

#keyphrasebox {
	width: 100%;
}

#keyphrasebox h3 {
	padding: 3px;
	font-weight: bold;
	font-size: 13px;
}

#keyphrasebox a.dbx-toggle, #keyphrasebox a.dbx-toggle-open:visited {
	height: 25px;
	width: 27px;
	background-position: 0 0px;
}

#keyphrasebox a.dbx-toggle-open, #keyphrasebox a.dbx-toggle-open:visited {
	height: 25px;
	width: 27px;
	background-position: 0 -25px;
}

#keyphrasebox .dbx-content {
	background: url(<?php echo ALINKS_URL; ?>/images/box-butt.gif) no-repeat bottom right;
	padding-bottom: 15px;
	padding-right: 2px;
}

#keyphrasebox .dbx-handle {
	padding: 6px 1em 2px;
	font-size: 12px;
}

#keyphrasebox .dbx-box {
	margin: 10px 0 10px 0;
	background: url(<?php echo ALINKS_URL; ?>/images/box-bg.gif) repeat-y right;
}

#keyphrasebox a.dbx-toggle, a.dbx-toggle:visited {
	display:block;
	overflow: hidden;
	background-image: url(<?php echo get_option('siteurl'); ?>/wp-admin/images/toggle.gif);
	position: absolute;
	top: 0px;
	right: 0px;
	background-repeat: no-repeat;
	border: 0px;
	margin: 0px;
	padding: 0px;
}
</style>
<?php
aLinksController::showSessionMessages();
?>