<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: help.php 55 2008-03-24 18:36:13Z sean $
 */
include($this->viewsDir . '/include.php');
?>
<div class="wrap"> 
  <h2><?php echo $this->alinksLang->_('Help'); ?></h2>
  <strong>Visit the <a href="http://forums.headzoo.com" target="_blank">forum</a> for additional help</strong>
  <ul>
    <li><a href="#introduction">Introduction</a></li>
    <ul>
      <li><a href="#introduction-whatis">What is aLinks?</a></li>
      <li><a href="#introduction-howwork">How it works</a></li>
      <li><a href="#introduction-changes">Changes in this version</a></li>
      <li><a href="#introduction-next">What's next?</a></li>
      <li><a href="#introduction-morehelp">Getting additional help</a></li>
    </ul>
    <li><a href="#faq">FAQ</a></li>
    <ul>
      <li><a href="#faq-autolinks">Um, wasn't this plugin called Auto Links?</a></li>
      <li><a href="#faq-searchengine">Are the links search engine friendly?</a></li>
      <li><a href="#faq-permanent">Are the links permanent?</a></li>
    </ul>
    <li><a href="#settings">General Settings</a></li>
    <ul>
      <li><a href="#settings-externalimage">Image to display after links</a></li>
      <li><a href="#settings-targetwindow">Open links in new window</a></li>
      <li><a href="#settings-clicktracking">Use outbound click tracking</a>
      <li> 
      <li><a href="#settings-customhtmljs">Custom HTML/JavaScript to add to links</a></li>
      <li><a href="#settings-cssclass">Custom CSS class</a></li>
      <li><a href="#settings-maxlinks">Max links per keyphrase</a></li>
      <li><a href="#settings-casesensitive">Keyphrases are case sensitive</a></li>
    </ul>
    <li><a href="#keyphrases">Keyphrases</a></li>
    <ul>
      <li><a href="#keyphrases-gettingstarted">Getting started</a></li>
      <li><a href="#keyphrases-explorer">The keyphrase data grid</a></li>
      <li><a href="#keyphrases-add">Adding a keyphrase</a></li>
      <li><a href="#keyphrases-editdelete">Edit and delete a keyphrase</a></li>
      <li><a href="#keyphrases-tools">Toolbox</a></li>
      <li><a href="#keyphrases-search">Search for keyphrase</a></li>
      <li><a href="#keyphrases-findreplace">Find and replace</a></li>
	  <li><a href="#keyphrases-massdelete">Mass delete keyphrase</a></li>
      <li><a href="#keyphrases-clipboard">Clipboard</a></li>
    </ul>
    <li><a href="#statistics">Click Statistics</a></li>
    <ul>
      <li><a href="#statistics-query">Querying the log files</a></li>
    </ul>
    <li><a href="#modules">Keyphrase Modules</a></li>
    <ul>
    </ul>
    <li><a href="#importexport">Import / Export</a></li>
    <ul>
      <li><a href="#importexport-allkeyphrases">Export all keyphrases / Only export 
        the keyphrases defined since the last export</a></li>
      <li><a href="#importexport-includesettings">Export general settings</a></li>
      <li><a href="#importexport-includemodules">Export modules</a></li>
      <li><a href="#importexport-importsettings">Import general settings if available</a></li>
      <li><a href="#importexport-importmodules">Import modules if available</a></li>
    </ul>
    <li><a href="#xmlrpc">XML-RPC methods</a></li>
    <ul>
      <li><a href="#xmlrpc-api">The API</a></li>
    </ul>
    <li><a href="#tipstricks">Tips & Tricks</a></li>
    <ul>
    </ul>
    <li><a href="#acknowledgements">Acknowledgements & Thank You</a></li>
  </ul>
  <a name="introduction"></a> 
  <h3 style="color: #CC0000; font-size: 1.5em;">Introduction</h3>
  <a name="introduction-whatis"></a> 
  <h4>What is aLinks?</h4>
  <p>aLinks is plugin that automatically turns defined keyphrases into links.</p>
  <a name="introduction-howwork"></a> 
  <h4>How it works</h4>
  <p>The links created by aLinks are created "on-the-fly". That means as the post 
    is being generated by WordPress for your visitors to see, aLinks works behind 
    the scenes to find any of your defined keyphrases in the post, and turns them 
    into links.</p>
  <a name="introduction-changes"></a> 
  <h4>Changes in this version</h4>
  <p>There are a lot of changes in this version from previous versions. Here is 
    just a short list of those changes.</p>
  <ul>
    <li>Most important, this is a complete rewrite. All the pervious versions 
      put together were written in about 12 hours, and that shows in the code. 
      This version is written from scratch using a lot of time and care.</li>
    <li>Keyphrase click tracking is now accomplished using JavaScript instead 
      of funky redirects.</li>
    <li>The external link image is added via CSS instead of using an IMG tag.</li>
  </ul>
  <a name="introduction-next"></a> 
  <h4>What's next?</h4>
  <p>What have you got? :) I'm open to all suggestions, so if you have a feature 
    you want included in the next version of aLinks, just drop by the <a href="http://www.headzoo.com/support">support 
    forums</a> and drop a line.</p>
  <p>Some features you can expect in future versions of aLinks are:</p>
  <ul>
    <li>Import / Exporting to other blogs via XML-RPC. You'll be able to truly 
      manage all your blogs from one main blog.</li>
    <li>A new (and free!) online service that creates a "community pool" to improve 
      the quality of keyphrases. More on that later!</li>
  </ul>
  <a name="introduction-morehelp"></a> 
  <h4>Getting additional help</h4>
  <p>If you need more help using aLinks, there is a support forum at the <a href="http://www.headzoo.com/support">Headzoo</a> 
    website. You can ask any question you might have about aLinks, find answers, 
    or even report bugs.</p>
  <a name="faq"></a> 
  <h3 style="color: #CC0000; font-size: 1.5em;">FAQ</h3>
  <a name="#faq-autolinks"></a> 
  <h4>Um, wasn't this plugin called Auto Links?</h4>
  <p>Yep, it was. But for a few different reasons, one of which is another plugin 
    named Auto Links, I decided to change the name.</p>
  <a name="#faq-searchengine"></a> 
  <h4>Are the links search engine friendly?</h4>
  <p>Yes they are. In every way possible, the links created by aLinks are normal 
    links. Search engines will pick-up on the links just like any other link.</p>
  <a name="#faq-permanent"></a> 
  <h4>Are the links permanent?</h4>
  <p>No. The links are "magically" generated when a visitor views your WordPress 
    website. The links don't actually exists in the post, in the database. That 
    means if you uninstall aLinks, everything goes back to the way it was before. 
    aLinks doesn't have any long term affects on your post. <a name="settings"></a>
	
  <h3 style="color: #CC0000; font-size: 1.5em;">General Settings</h3>
  <a name="settings-externalimage"></a> 
  <h4>Image to display after links</h4>
  <p>You can display a trendy "external link" image next to each link created by aLinks by entering the full URL to a gif, jpeg, or png image in the field.  The plugin comes with a default link image, and when you first install aLinks, the URL to that image will already be entered in the field.</p>
  
  <a name="settings-targetwindow"></a> 
  <h4>Open links in new window</h4>
  <p>Check this option to open clicked links in a new window or tab.  The setting only affects links created by aLinks, and uses JavaScript instead of the target attribute.  Using JavaScript ensures that your pages remain (X)HTML compliant.</p>

  <a name="settings-clicktracking"></a> 
  <h4>Use outbound click tracking</h4>
  <p>This option must be set if you plan to use the click statistics.  Unlike previous versions of this plugin, this version uses JavaScript to track outbound clicks rather than a redirect.  This ensures that search engines like Google have no problems indexing the links in your blog posts.</p>
  
  <a name="settings-offsethours"></a>
  <h4>Log Offset Hours</h4>
  <p>The click tracking logs keep track of the time and date that links are clicked.  By default that will be the time on your web server, and it's possible, and even likely, that your web server is in a different timezone than you.  Use this setting so that your click logs show clicks in your timezone, not the timezone of your server.</p>
<p>If you server is two hours behind you, then enter `-2`.  If it is 2 hours ahead of you, then enter `2`, and so on.</p>
  
  <a name="settings-customhtmljs"></a> 
  <h4>Custom HTML/JavaScript to add to links</h4>
  <p>Whatever you enter in the field will be inserted into the created links.  You can enter any HTML or JavaScript.</p>
  <p>As examples, you could enter the JavaScript required for other click tracking packages.  If you want to use link
  cloaking, enter the following code into this form field:</p>
  <pre>
  onMouseover="window.status='Search here'; return true" onMouseout="window.status=''"
  </pre>
  
  <p>What you put into this field is completely up to you.</p>
  
  <a name="settings-cssclass"></a> 
  <h4>Custom CSS class</h4>
  <p>You can apply your own custom CSS class to each link created by aLinks.  Enter only the name of the class, and no other markup.  For example, if you want your links to have a fancy dotted underline, add this code to your themes stylesheet:</p>
  <pre>
a.alinks_links {
	text-decoration: none;
	border-bottom: #0000FF 1px dotted;
}
  </pre>
  
  <p>And then enter "alinks_links" (minus the quotes) into the custom CSS class field.  Of course the CSS you put into the stylesheet is entirely up to you.  The above code is only a simple example.</p>
  
  <a name="settings-maxlinks"></a> 
  <h4>Max links per keyphrase</h4>
  <p>Previous versions of this plugin only linkified keyphrases once per post.  With this setting you can control the number of times the same keyphrase is linkified in the same post.  Keep in mind this works on a per-post basis, and not the entire document.  Leave the field blank, or enter -1 to linkify the same keyphrase an unlimited number of times.</p>
  <p>On note on this setting: Unlimited is actually limited by the number of times you have the keyphrase defined.</p>
  
  
  <a name="settings-casesensitive"></a> 
  <h4>Keyphrases are case sensitive</h4>
  <p>By default keyphrases are case insensitive.  That means if you define the keyphrase "wordpress", aLinks will linkify the words "WordPress", "Wordpress", and "wOrdPRess" in your post.</p>
<p>If you check this option keyphrase case will matter.  That means if you define the keyphrase "WordPress", aLinks will not linkify the words "wordpress", "Wordpress", and "WorDPreSs" in your post.</p>
  
  <a name="settings-nodeletewarning"></a>
  <h4>Don't warn on keyphrase delete</h4>
  <p>By default, aLinks will warn you before deleting a keyphrase.  Generally this is a good thing, since prevents you from accidentally deleting keyphrases.  It can be annoying though if you need to delete a lot of keyphrases at once.  You can turn off the warnings with this setting.</p>
  
  <a name="keyphrases"></a> 
  <h3 style="color: #CC0000; font-size: 1.5em;">Keyphrases</h3>
  
  <a name="keyphrases-gettingstarted"></a> 
  <h4>Getting Started</h4>
  <p>Keyphrases are the meat and potatoes of aLinks.  A keyphrase is one or more words -- a phrase -- that you want aLinks to linkify.  The plugin searches through your posts looking for the keyphrases you defined, and turns them into links.</p>
  <p>Keyphrases are managed from the Keyphrases sub menu.  What you see on that menu depends a little bit on which modules you have installed, but there will always be the Toolbox, and the keyphrase data grid.</p>
  
  <a name="keyphrases-grid"></a>
  <h4>The keyphrase Data Grid</h4>
  <p>The keyphrase explorer is the data grid you use to manage your existing keyphrases. 
    From the keyphrase explorer you can edit keyphrases, and delete them.</p>
  <p>The explorer uses Ajax under the hood, and most operations should take place 
    asynchronously, meaning your browser doesn't need to refresh. If your browser 
    window refreshes when adding a new keyphrase, or editing and deleting a keyphrase, 
    make sure you have JavaScript enabled, and are using a current browser such 
    as Firefox 1.x, or IE6.</p>
	
    <a name="keyphrases-add"></a>
	<h4>Adding a keyphrase</h4>
	<p>How a new keyphrase is added is somewhat decided by the module for that keyphrase, so please check the documentation that may be included with the keyphrase module.</p>
	<p>All keyphrases, regardless of the module, with have a keyphrase and a description form field.  All keyphrases will also have an Update Keyphrase button.</p>
	<p>The only field that is required is the keyphrase field.  If you enter a description for the keyphrase, the description will be used in the link's TITLE attribute, and will appear as a pop-up tool tip when your website visitors move their mouse cursor over the link.</p>
	<p>Once you've finished filling out the form fields for a new keyphrase, clicked the Update Keyphrase button to add it to the data grid.</p>
	
    <a name="keyphrases-editdelete"></a>
	<h4>Edit and delete a keyphrase</h4>
	<p>To edit or delete a keyphrase, double click the keyphrase's row in the data grid.  When you do, the grid with become a form that you can use to edit the keyphrase.  Once you've made changes to the keyphrase, clicked the Update Keyphrase button.</p>
	<p>There is also a delete button on that same form.  Click that button to delete the keyphrase.  Once a keyphrase has been deleted, it is gone forever, so be careful.</p>
	
  <a name="keyphrases-tools"></a> 
  <h4>Toolbox</h4>
  <p>The toolbox contains a few tools to make it easier to manage your keyphrases.</p>
  
  <a name="keyphrases-search"></a> 
  <h4>Search for keyphrase</h4>
  <p>With this tool you can find specific keyphrases from your defined list.  You can enter a full keyphrase or part of a keyphrase.  For instance, if you search for word, any keyphrase with word in it will be returned, such as WordPress, word of mouth, etc.</p>
  <p>The search tool only searches keyphrases, not descriptions or any other data.</p>
  
  <a name="keyphrases-findreplace"></a> 
  <h4>Find and replace</h4>
  <p>This tool finds any string of text in you keyphrases, and replaces it with another string of text. For instance, if you have 10 keyphrases that contain the phrase website, and later on you decide you should have used web site, you can easily replace all occurrences of website with web site by using the find and replace tool.  Just type website into the find field, and web site into the replacement field, and click Find & Replace.</p>
  <p>The tool will replace any letter or string of letters in your keyphrases.  You can replace every occurrence of the letter a with the letter b if you want.  Because of that you should be careful when using this tool.</p>
  
  <a name="keyphrases-massdelete"></a>
  <h4>Mass Delete Keyphrase</h4>
  <p>Use this tool to delete two or more of the same keyphrase at once.  If you have dozens of keyphrases defined using the Amazon Basic module, and then you delete the Amazon Basic module, you can quickly delete all of the keyphrases for that module by using this tool.  Be careful, as it will delete every keyphrase that you type in.</p>
  
  <a name="keyphrases-clipboard"></a> 
  <h4>Clipboard</h4>
  <p>The clipboard tool works just like your computer's cut & paste, except whatever you copy with the clipboard remains in the database until you replace it.  You can copy a string of text with one of the copy buttons, and it will remain there for years, if you want it to, to paste into any text field.</p>
  <p>This tool makes it convenient if you use the same long affiliate URL in keyphrases over and over, or the same description for keyphrases over and over.  The copied text will always be there for your use.</p>
  <p>To use the tool, select some text in one of the text fields on the keyphrases menu page, and then click one of the four copy buttons.  You can now use the same number paste button to paste that same text into any of the text fields on the keyphrases menu.</p>
  
  <a name="statistics"></a> 
  <h3 style="color: #CC0000; font-size: 1.5em;">Click Statistics</h3>
  <p>You have the option to turn out outbound click tracking.  When this option is turned on, aLinks will keep a log of aLinks created links that are clicked by your website visitors, and you'll be able to view the logs in an easy to read manner, which includes visual graphs.</p>
<p>You must turn on the option Use outbound click tracking from the aLinks Settings menu to use this feature.</p>
  <p>Unlike previous versions of this plugin, the new click tracking uses a little JavaScript magic to track outbound clicks, rather than redirects.  That makes your links more SEO friendly, but also means if a visitor to your website doesn't have JavaScript enabled, the links they click won't be logged.  That shouldn't be a concern, since the vast majority of people surfing the web are using JavaScript.</p>
  
  <a name="statistics-query"></a> 
  <h4>Query the log files</h4>
  <p>Internally aLinks uses a type of light-weight SQL to manage the click statistics 
    logs. You can use the same SQL to query the log files from the Statistics 
    sub menu. You <em>don't have to</em>, and many people <em>won't need to</em>, 
    but you can if you <em>want to</em>. Click statistics are kept in files, not 
    in the database, and the SQL is my own brand, not true SQL. That being said, 
    it's based on MySQL's SQL, and anyone comfortable with MySQL will have an 
    easy time.</p>
  <p>There are five types of queries supported by aLinks: INSERT, DELETE, SELECT, 
    SHOW, and CREATE. Like I said, this is not true SQL, but a light-weight version, 
    and as such only a small number of query types are supported, and they aren't 
    supported well, but are enough for aLinks to do it's work. I also kept the 
    term &quot;table&quot; in the queries even though it's actually log files.</p>
  <p>Each log files is accessed by using it's name, minus the .log extension. 
    The main log file used is alinks.log, so it would be refered to in queries 
    as just 'alinks'. Also each log file has 3 columns: keyphrase, timestamp, 
    and ip.</p>
  <p><strong>SELECT</strong></p>
  <p>The SELECT statement is used to retrieve records from a log file.</p>
  <pre>
SELECT [ DISTINCT ] column_names 
FROM table_name 
[ WHERE column_name [ = | < | > | <= | >= | != ] "value" ]
[ AND column_name [ = | < | > | <= | >= | != ] "value" ]
[ ORDER BY column_name [ ASC | DESC ] ]
</pre>
  <p>There are a few ways to use the select statement to get just the data you 
    want. Here are a few examples:</p>
  <pre>SELECT * FROM alinks</pre>
  <p>The above example is the most basic select statement. It will return every 
    column of every row in the alinks.log file.</p>
  <pre>SELECT keyphrase, ip FROM alinks</pre>
  <p>This example is a bit more refined, as it will only return the keyphrase 
    and ip columns from every row in the alinks.log file.</p>
  <pre>SELECT timestamp FROM alinks WHERE keyphrase = 'wordpress'</pre>
  <p>This query only returns the timestamp column from rows where the keyphrase 
    equals 'wordpress'. It's <strong>very important</strong> that the value, in 
    this case 'wordpress', is always wrapped in single or double quotes, or the 
    query will fail.</p>
  <pre>SELECT keyphrase, timestamp FROM alinks WHERE ip != '123.45.32.12' ORDER BY keyphrase DESC</pre>
  <p>This query will return the keyphrase and timestamp columns from rows where 
    the ip address does not equal '123.45.32.12', and the return results will 
    be ordered by the keyphrases in descending order.</p>
  <p><strong>INSERT</strong></p>
  <p>The INSERT statement is used to add records to a log file.</p>
  <pre>INSERT INTO table_name 
VALUES('keyphrase', 'timestamp', 'ip')</pre>
  <p>In the above example table_name is the name of the log file to insert values 
    into. Following that are the values to insert. You must insert all three values, 
    and none of them can be null.</p>
  <p>You can also use the insert statement in conjunction with the select statement 
    to move rows from one log file to another:</p>
  <pre>
INSERT INTO table_name
SELECT * FROM table_name 
[ WHERE column_name [ = | < | > | <= | >= | != ] "value" ]
[ AND column_name [ = | < | > | <= | >= | != ] "value" ]
</pre>
  <p>Here is an example:</p>
  <pre>INSERT INTO alinksbackup SELECT * FROM alinks WHERE ip = '123.45.32.12'</pre>
  <p>That query will move all the rows from the alinks.log file that have an ip 
    address that equals '123.45.32.12', into the log file alinksbackup.log. It's 
    important that you select all the columns `*` when using an insert statement 
    like that, or the log file might end up being corrupted.</p>
  <p><strong>DELETE</strong></p>
  <p>The DELETE statement is used to delete rows from a log file:</p>
  <pre>DELETE FROM table_name
[WHERE column_name [ = | &lt; | &gt; | &lt;= | &gt;= | != ] &quot;value&quot;]

</pre>
  <p>Here is an example:</p>
  <pre>DELETE FROM alinks WHERE keyphrase = 'wordpress'</pre>
  <p>The query will delete from the alinks.log file, every row where the keyphrase 
    equals 'wordpress'. If you leave out the WHERE condition, every row in the 
    log file will be deleted, so use caution with the the delete statement.</p>
  <p><strong>CREATE</strong></p>
  <p>The CREATE statement is used to create a new log file:</p>
  <pre>CREATE TABLE 'table_name'</pre>
  <p>It's important to wrap the table name in single or double quotes, or the 
    query will fail. Here is an example:</p>
  <pre>CREATE TABLE 'alinksbackup'</pre>
  <p>This query will create a new log file named alinksbackup.log</p>
  <p><strong>SHOW</strong></p>
  <p>The SHOW statement is used to show all, or one, of your log files:</p>
  <pre>SHOW TABLES [LIKE table_name]</pre>
  <p>A query to list all of the log files in your log files directory would be:</p>
  <pre>SHOW TABLES</pre>
  <p>A query to list a single log file would be:</p>
  <pre>SHOW TABLES LIKE alinks</pre>
  <p>It would seem pointless to use show to return a single table, but if <em>anything</em> 
    is returned from that query, then you know the log file alinks.log actually 
    exists. </p>
  <p><strong>Multiple Queries</strong></p>
  <p>Queries can be chained together by seperating each query with a semi-colon 
    `;`. The following query will make a backup of your alinks.log file:</p>
  <pre>CREATE TABLE 'alinksbackup'; INSERT INTO alinksbackup SELECT * FROM alinks


</pre>
  <p>The first part of the query creates a new log file named alinksbackup.log, 
    and the second part inserts all the rows from the alinks.log file into it. 
    Here is a way to archive your main log file:</p>
  <pre>CREATE TABLE 'alinks_may_2006';
INSERT INTO alinks_may_2006 SELECT * FROM alinks WHERE timestamp &lt; 'june 2006';
DELETE FROM alinks WHERE timestamp &lt; 'june 2006'

</pre>
  <p>The above query looks complicated, but it really isn't. The first part creates 
    a new log file named alinks_may_2006.log. The second part inserts into that 
    new log file all the rows from alinks.log that were created before June 2006. 
    The last part deletes all the rows from alinks.log that were created before 
    June 2006.</p>
  <a name="modules"></a>
  <h3 style="color: #CC0000; font-size: 1.5em;">Keyphrase Modules</h3>
  <p>Modules are to aLinks what plugins are to WordPress.  Modules extend the functionality of aLinks, by extending it's support for keyphrases.  The original versions of this plugin supported two types of keyphrases: General and Amazon.  This version of the plugin doesn't support any kind of keyphrase, all it's keyphrase support comes from the modules you have installed.</p>
<p>The most basic kind of keyphrase is a general keyphrase.  With a general keyphrase you tell aLinks the phrase, and the URL belonging to that phrase.  When aLinks finds that keyphrase in your post, the plugin will turn the phrase into a link for the URL you defined.</p>
<p>To make your blogging easier, aLinks can do much more than that.  For instance you can use the Amazon Basic keyphrase module.  With this module installed (it is by default), you don't have to give aLinks a URL for the keyphrase, you just give it a search term and product type.  aLinks will then turn that keyphrase into a link for Amazon.com search results, using your Amazon Associates ID.</p>
<p>For example, when you define an Amazon Basic keyphrase, you might define the keyphrase "books", using the search term "harry potter", and the product type "Books".  When aLinks finds the word "books" in your post, the plugin will turn the word into a link for Amazon.com.  When your website visitors click on the link, they will be sent to a page on Amazon.com showing all the books from the Harry Potter series.</p>
<p>The links will use your Amazon Associates ID, so you will get a commission if the website visitor buys something from Amazon.</p>
<p>Lots of other modules can be installed, and they make it easier to create links.  For instance you can install the Wikipedia module which creates links to Wikipedia articles.  You can install the Myspace module which creates links to Myspace user pages.  There is also an iTunes module that creates links to the iTunes music store using your LinksShare affiliate ID.</p>
<p>There are lots of modules you can install, and you can download some of them from http://www.headzoo.com/modules.  You can also write your own modules.</p>
  
  
  
  <a name="importexport"></a> 
  <h3 style="color: #CC0000; font-size: 1.5em;">Import / Export</h3>
  <p>The new import / export features in aLinks provide a means to make backups 
    of your keyphrases, general settings, and keyphrase modules that can be used 
    to restore aLinks in the event of database crash, or some other type of accident. 
    It also gives you the ability to manage two or more aLinks powered blogs from 
    one main blog.</p>
  <p>A lot of your run more than one blog with aLinks/Auto Links installed. In 
    the past you would have to either enter all your keyphrases and settings in 
    each blog, or export / import your database. No longer! You can use the import 
    / export features to manage all your aLinks installations from one blog.</p>
 
<p>When exporting to an ale file, you have a couple options.  The first is whether to export all your keyphrases, or only the keyphrases defined since the last time you exported your keyphrases.</p>
<a name="importexport-allkeyphrases"></a>
<p>When exporting only the keyphrases defined since the last time you exported, the ale file will include only those keyphrases.  If you export your keyphrases on Monday, define 10 keyphrases on Tuesday, and export on Wednesday, the exported ale file will only contain those 10 keyphrases.</p>
<p>This is useful for a couple reasons.  The first is your ale files will be reasonably small.  Second it makes it easier to manage multiple blogs.  If you are adding keyphrases from one main blog, and importing the keyphrases into your other blogs, there is no reason to import every single keyphrase every time.</p>
<a name="importexport-includesettings"></a>
<p>The second option when exporting is to include your settings.  When you check this option, your keyphrases and your settings will be included in the ale file.  This is handy when you need to import your keyphrases after a database crash.  This also makes it easier to manage multiple blogs, as once again, you can manage your keyphrases and settings from one main blog, and import everything into the other blogs.</p>
<a name="importexport-includemodules"></a> 
<p>The final option is to include your installed keyphrase modules in the ale file.  When you check this option, each module that you have installed will be included in the ale file.  Once again that makes it easier to recover from a database crash, and makes it easier to manage multiple blogs from one main blog.</p>
  
<p>To import an ale file, simply select the ale file from your computer's hard drive using the file browser on the Import / Export page.  Once selected, click the Import button.</p>
<a name="importexport-importsettings"></a> 
<p>Like the exporting, you have a couple options here.  The first is to include any settings found in the ale file.  Just because you chose to include settings when exporting to an ale file, doesn't mean you have to import them.  If you don't check this option, any settings in the ale file will be ignored.  If you check the option, any settings in the ale file will be imported.</p>
<a name="importexport-importmodules"></a>
<p>The second option for importing is to import any modules in the ale file.  Like the settings, you don't have to import modules if they are found in the ale file.  If you don't check this option, any modules found in the ale file will be ignored.  If you do check this option, modules found in the ale file will be imported, overwriting any modules that you currently have installed.</p>  
<p>If you have a module installed, and import the same module, that's not a big deal.  Even though the imported module will overwrite the existing module, it will simply overwrite it with the same module.
  
  <a name="xmlrpc"></a> 
  <h3 style="color: #CC0000; font-size: 1.5em;">XML-RPC methods</h3>
  <p>There are 7 XML-RPC methods built into aLinks. XML-RPC is a method to make 
    procedure calls remotly, and it's the technology that blogs use for trackbacks 
    and pings. You can learn more about XML-RPC at this <a href="http://www.xmlrpc.com/">website</a>.</p>
  <p>The methods built into aLinks allow third-party applications to control the 
    plugin. Most popular programming lanaguages like Java, PHP, and .NET languages, 
    can use XML-RPC.</p>
  <a name="xmlrpc-api"></a> 
  <h4>The API</h4>
  <pre style="color: #CC0000;">alinks.getKeyphrases</pre>
  <p>Returns a complete list of defined keyphrases, and all the data for each 
    keyphrase.</p>
  <p><strong>Parameters:</strong></p>
<ol>
  <li>Your WordPress username</li>
  <li>Your WordPress password</li>
</ol>
  <pre style="color: #CC0000;">alinks.getKeyphraseById</pre>
  <p>Returns a single keyphrase and all it's data.</p>
  <p><strong>Parameters:</strong></p>
<ol>
  <li>Your WordPress username</li>
  <li>Your WordPress password</li>
  <li>The ID of the keyphrase</li>
</ol>
  <pre style="color: #CC0000;">alinks.getModuleType</pre>
  <p>Returns the keyphrase module type used by the keyphrase for the specified 
    keyphrase ID.</p>
  <p><strong>Parameters:</strong></p>
<ol>
  <li>Your WordPress username</li>
  <li>Your WordPress password</li>
  <li>The ID of the keyphrase</li>
</ol>
  <pre style="color: #CC0000;">alinks.newKeyphrase</pre>
  <p>Adds a new keyphrase.</p>
  <p><strong>Parameters:</strong></p>
<ol>
  <li>Your WordPress username</li>
  <li>Your WordPress password</li>
  <li>The keyphrase</li>
  <li>The keyphrase description</li>
  <li>The keyphrase defines, which is a serialized array of options for the keyphrase</li>
  <li>The module type for the keyphrase</li>
</ol>
  <pre style="color: #CC0000;">alinks.updateKeyphrase</pre>
  <p>Updates an already existing keyphrase.</p>
  <p><strong>Parameters:</strong></p>
<ol>
  <li>Your WordPress username</li>
  <li>Your WordPress password</li>
  <li>The keyphrase ID</li>
  <li>The new keyphrase</li>
  <li>The new description</li>
  <li>The new defines, which is a serialized array of options for the keyphrase</li>
</ol>
  <pre style="color: #CC0000;">alinks.deleteKeyphrase</pre>
  <p>Deletes a defined keyphrase</p>
  <p><strong>Parameters:</strong></p>
<ol>
  <li>Your WordPress username</li>
  <li>Your WordPress password</li>
  <li>The keyphrase ID</li>
</ol>
  <pre style="color: #CC0000;">alinks.queryLogs</pre>
  <p>Returns the results from a SQL query to the click statistics logs. Read the 
    section of <a href="#statistics-query">querying the logs</a> for the SQL syntax.</p>
  <p><strong>Parameters:</strong></p>
<ol>
  <li>Your WordPress username</li>
  <li>Your WordPress password</li>
  <li>The SQL query</li>
</ol>

<p>There is an 8th method, which is <span style="color: #CC0000;">alinks.ping</span>. The method requires no parameters, 
  and always returns 'pong'. The method can be used to make sure aLinks is alive.</p>
<div class="wrap">
<a name="acknowledgements"></a> 
  <h3 style="color: #CC0000; font-size: 1.5em;">Acknowledgements & Thank You</h3>
  <p><strong>Thank you</strong> for downloading and using aLinks. This plugin 
    has become pretty popular since it was first released almost a year ago.</p>
  <p>I personally never expected so many people to find aLinks/Auto Links so useful. 
    People have been using it to make their posts writing more convenient, to 
    monetize their blogs, and improve search engine rankings for their own blogs 
    and the websites of others.</p>
  <p>As long as people continue to find aLinks useful, I'll continue to maintain 
    it and update it. And of course it'll always be <strong>free</strong>!</p>
  <p>- Sean Hickey</p>
  <br />
  <p>aLinks was written entirely using the <a href="http://notepad-plus.sourceforge.net/uk/site.htm">Notepad++</a> 
    text editor, and PDF documentation was created using <a href="http://www.openoffice.org">OpenOffice.org</a>.</p>
  <p>The following people beta tested aLinks:</p>
<p>Petit from <a href="http://www.petitpub.com">http://www.petitpub.com</a></p>
<p>Ken from <a href="http://www.chench.com/emusic">http://www.chench.com/emusic</a></p>
<p>Youn from <a href="http://www.wordpress.co.kr">http://www.wordpress.co.kr</a></p>
<p>Dmitri from <a href="http://www.dmitrivonklein.com">http://www.dmitrivonklein.com</a></p>
<p>Jason from <a href="http://www.voteswagon.com">http://www.voteswagon.com</a></p>
<p>Kevin from <a href="http://www.okevin.net">http://okevin.net</a></p>
<p>I'd like to thank the following people for translating aLinks:</p>
<p>Petit from <a href="http://www.petitpub.com">http://www.petitpub.com</a> - Swedish</p>
<p>Youn from <a href="http://www.wordpress.co.kr">http://www.wordpress.co.kr</a> - Korean</p>
<p>Ali from <a href="http://weblog.corelist.net">http://weblog.corelist.net</a> - Farsi (not ready yet)</p>
<p>Nuno from <a href="http://www.descobre.com">http://www.descobre.com</a> - Portuguese (not ready yet)</p>
  <p>This plugin uses the excellent PclZip library written by <a href="http://www.phpconcept.net">Vincent 
    Blavet</a>, to unzip uploaded keyphrase modules.</p>
  <div> <img src="<?php echo ALINKS_URL; ?>/images/logo_sm.png" /> </div>
</div>
</div>
