<?php
/**
 * aLinks General Keyphrase Module
 *
 * A simple keyphrase module that turns keyphrases into links with a given
 * URL.  Adds rel="external" to external links, and if the external image
 * is being used, removes it when the link isn't external.
 *
 * @author	Sean Hickey <seanhickey@gmail.com>
 * @license	GPL
 * @version	$Id: mod.php 46 2008-03-24 18:02:58Z sean $
 */
class GeneralKeyphrases extends aLinksKeyphrases {
	
	var $name = 'general';
	var $requiredDefines = array('url');

	function doPhrase($postObj, $keyphrase, $description, $defines) {
		if (!stristr($defines['url'], 'http://') && !stristr($defines['url'], 'https://')) {
			$image = '';
			$external = '';
		} else {
			$image = $this->imageHTML;
			$external = 'rel="external"';
		}
		return "<a href=\"{$defines['url']}\" {$this->extraHTML} title=\"$description\" $image $external>$keyphrase</a>";
	}
}