<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package   alinks
 * @license   GPL
 * @version   $Id: hacks.php 45 2008-03-24 18:01:45Z sean $
 */

/**
 * Replacement for file_get_contents()
 *
 * A hack of the file_get_contents() function which wasn't available
 * until PHP 4.3.
 */
if (!function_exists('file_get_contents')) {
	function file_get_contents($fileName) {
		if (!$f = @fopen($fileName, 'rb')) {
			return false;
		}
		$contents = '';
		while (!feof($f)) {
			$contents .= fread($f, 8192);
		}
		@fclose($f);
		return $contents;
	}
}

/**
 * Replacement for file_put_contents()
 *
 * A hack of the file_put_contents() function which wasn't available
 * until PHP 4.3.
 */
if (!function_exists('file_put_contents')) {
	function file_put_contents($fileName, $contents) {
		if (!$f = @fopen($fileName, 'wb')) {
			return false;
		}
		$written = @fwrite($f, $contents);
		@fclose($f);
		return $written;
	}
}