<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: aLinksXml.php 44 2008-03-24 18:00:53Z sean $
 */
/**
 * aLinks XML class
 *
 * A light-weight XML parser specifically designed to parse keyphrase module
 * XML files.
 */
class aLinksXml extends aLinksApp
{
	/**
	 * The module XML data.
	 *
	 * @var		string
	 * @access	private
	 */
	var $xml;
	
	/**
	 * Sets the XML data property
	 *
	 * @param	string	$xml	The XML data
	 * @return	void
	 */
	function setXML($xml) {
		$this->xml = $xml;
	}
	
	/**
	 * Parses the mod XML data
	 *
	 * Specialty XML data parser for module XML files.  Specialty meaning
	 * it will not parse any ol' XML file, only the module XML file.  Returns
	 * an array with the module options and defines.
	 *
	 * @return	array
	 */
	function parse() {
		$modOptions = array();
		$modDefines = array();
		$modInfo = array();
		
		if (preg_match('~<info>(.*?)<\/info>~is', $this->xml, $matches)) {
			$info = $matches[1];
			if (preg_match('~<name>(.*)?<\/name>~is', $info, $matches)) {
				$modInfo['name'] = $matches[1];
			}
			if (preg_match('~<author>(.*?)<\/author>~is', $info, $matches)) {
				$modInfo['author'] = $matches[1];
			}
			if (preg_match('~<authorWebsite>(.*?)<\/authorWebsite>~is', $info, $matches)) {
				$modInfo['authorWebsite'] = $matches[1];
			}
			if (preg_match('~<description>(.*?)<\/description>~is', $info, $matches)) {
				$modInfo['description'] = $matches[1];
			}
			if (preg_match('~<version>(.*?)<\/version>~is', $info, $matches)) {
				$modInfo['version'] = $matches[1];
			}
		}
		
		if (preg_match('~<options>(.*?)<\/options>~is', $this->xml, $matches)) {
			$counter = 0;
			preg_match_all('~<option>(.*?)<\/option>~is', $matches[1], $matches);
			$options = $matches[1];
			foreach($options as $option) {
				preg_match('~<optionLabel>(.*?)</optionLabel>~is', $option, $matches);
				$modOptions[$counter]['label'] = $matches[1];
				
				preg_match('~<optionType.*?>(.*?)</optionType>~is', $option, $matches);
				$modOptions[$counter]['input']['type'] = $matches[1];
				
				preg_match('~<optionType.*?name.*?=.*?[\'|"](.*?)[\'|"].*?>~is', $option, $matches);
				$modOptions[$counter]['input']['name'] = $matches[1];
				
				preg_match('~<optionType.*?size.*?=.*?[\'|"](.*?)[\'|"].*?>~is', $option, $matches);
				$modOptions[$counter]['input']['size'] = $matches[1];
				
				preg_match('~<optionType.*?value.*?=.*?[\'|"](.*?)[\'|"].*?>~is', $option, $matches);
				$modOptions[$counter]['input']['value'] = $matches[1];				
			
				if ($modOptions[$counter]['input']['type'] == 'select') {
					preg_match_all('~<optionValue.*?value.*?=.*?[\'|"](.*?)[\'|"].*?>(.*?)<\/optionValue>~is', $option, $matches);
					$values = $matches[1];
					$labels = $matches[2];
					$subCounter = 0;
					foreach ($values as $value) {
						$modOptions[$counter]['option'][$subCounter]['value'] = $value;
						$modOptions[$counter]['option'][$subCounter]['label'] = $labels[$subCounter];
						$subCounter++;
					}
				}
				$counter++;
			}
		}
				
		if (preg_match('~<defines>(.*?)<\/defines>~is', $this->xml, $matches)) {
			$counter = 0;
			preg_match_all('~<define>(.*?)<\/define>~is', $matches[1], $matches);
			$defines = $matches[1];
			foreach($defines as $define) {
				preg_match('~<defineLabel>(.*?)</defineLabel>~is', $define, $matches);
				$modDefines[$counter]['label'] = $matches[1];
				
				preg_match('~<defineType.*?>(.*?)</defineType>~is', $define, $matches);
				$modDefines[$counter]['input']['type'] = $matches[1];
				
				
				preg_match('~<defineType.*?name.*?=.*?[\'|"](.*?)[\'|"].*?>~is', $define, $matches);
				$modDefines[$counter]['input']['name'] = $matches[1];
				
				preg_match('~<defineType.*?size.*?=.*?[\'|"](.*?)[\'|"].*?>~is', $define, $matches);
				$modDefines[$counter]['input']['size'] = $matches[1];
				
				preg_match('~<defineType.*?value.*?=.*?[\'|"](.*?)[\'|"].*?>~is', $define, $matches);
				$modDefines[$counter]['input']['value'] = $matches[1];				
			
				if ($modDefines[$counter]['input']['type'] == 'select') {
					preg_match_all('~<defineValue.*?value.*?=.*?[\'|"](.*?)[\'|"].*?>(.*?)<\/defineValue>~is', $define, $matches);
					$values = $matches[1];
					$labels = $matches[2];
					$subCounter = 0;
					foreach ($values as $value) {
						$modDefines[$counter]['option'][$subCounter]['value'] = $value;
						$modDefines[$counter]['option'][$subCounter]['label'] = $labels[$subCounter];
						$subCounter++;
					}
				}
				$counter++;
			}
		}

		return array('info' => $modInfo, 'options' => $modOptions, 'defines' => $modDefines);
	}
}