<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: aLinksLang.php 44 2008-03-24 18:00:53Z sean $
 */
/**
 * aLinks lanaguage class
 *
 * Used to translate strings of text into other lanaguages.
 */
class aLinksLang {
	/**
	 * The full path to the directory
	 * where the MO files are stored.
	 *
	 * @var		string
	 * @access	private
	 */
	var $langDir;
	
	/**
	 * The name of the MO file to pull
	 * phrases from.
	 *
	 * @var		string
	 * @access	private
	 */
	var $mofile = null;
	
	/**
	 * The Gettext object.
	 *
	 * @var		obj
	 * @access	private
	 */
	var $lang;
	
	/**
	 * Class constructor
	 *
	 * @param	string	$langDir	The directory where the MO files are stored
	 * @return	void
	 */
	function aLinksLang($langDir) {
		$this->langDir = $langDir;
		$this->setMOFile();
		if ($this->mofile) {
			$input = new FileReader($this->langDir . '/' . $this->mofile);
			$this->lang = new gettext_reader($input);
		}
	}

	/**
	 * Sets the name of the MO file
	 *
	 * Sets the name of the MO file to use for translations based
	 * on what the user has set in WPLANG.
	 *
	 * @return	void
	 */
	function setMOFile() {
		if (WPLANG && is_readable($this->langDir . '/' . strtolower(WPLANG) . '.mo')) {
			$this->mofile = strtolower(WPLANG) . '.mo';
		}
	}
	
	/**
	 * aLinks localization method
	 *
	 * Translates the given string into the language that is
	 * set in WordPress.  Returns the string in the specified
	 * language if the language file is available, or else returns
	 * the string the same way it was passed to the method.
	 *
	 * @param	string	$string	The string to translate
	 * @return	string
	 */
	function _($string) {
		if (!$this->mofile) {
			return $string;
		}
		return $this->lang->translate($string);
	}
}