<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: aLinksBackend.php 52 2008-03-24 18:11:44Z sean $
 */
include_once('../../../../wp-config.php');
include_once('../../../../wp-admin/admin.php');

/**
 * aLinks backend class
 *
 * This class handles backend request from Ajax scripts, and the keyphrase
 * explorer data grid.
 */
class aLinksBackend extends aLinksApp {

	/**
	 * The aLinksModel class object.
	 * @var obj
	 */
	var $alinksModel;
	
	/**
	 * A search term, if any, to use when
	 * sending keyphrases to the data grid.
	 * @var string
	 */
	var $searchTerm = null;
	
	var $sendXml = true;
	
	var $alinksModules;
	
	/**
	 * Class constructor
	 *
	 * @param	obj		$alinksModel	The aLinksModel class object
	 * @param	obj		$alinksStruct	The aLinksStruct class object
	 */
	function aLinksBackend(&$alinksModel, &$alinksStruct) {

		$this->extractTo($this, $alinksStruct->getAll());
		$this->alinksModel =  &$alinksModel;
		$this->alinksModules = & new aLinksModules;
		$contents = file_get_contents('php://input');
		if (!empty($contents)) {
			$this->doPost($contents);
		}
		
		if ($_GET['log']) {
			$this->logKeyphrase($_GET['log']);
			$this->sendXml = false;
		}
		
		if ($this->sendXml) {
			$this->show();
		}
	}
	
	/**
	 * Method to call if there is POST data to process
	 *
	 * If this script is being called with some POST data, then this method will
	 * be called by the class constructor.
	 *
	 * @param	string	$contents	The POST data
	 * @return	mixed
	 */
	function doPost($contents) {
	
		if(get_magic_quotes_gpc() || get_magic_quotes_runtime()) {
			$contents = $this->stripSlashesDeep($contents);
		}
		
		/**
		 * This is kind of tricky, since the POST data can contain any number of things.  The
		 * parse_str() function creates variables out of elements in the POST array, and you
		 * never actually see those variables being created.  They just exists after calling
		 * the parse_str() function.
		 */
		parse_str($contents);
		switch ($action) {
			case 'log_keyphrase':
				$this->logKeyphrase($keyphrase);
				$this->sendXml = false;
				break;
			case 'new_keyphrase':
				$this->newKeyphrase($keyphrase, $description, $module, $elementName, $elementValue);
				break;
			case 'new_clipboard':
				$this->newClipboard($clipboardNumber, $clipboardValue);
				break;
			case 'search_keyphrase':
				$this->searchTerm = utf8RawUrlDecode($searchTerm);
				break;
			case 'find_replace':
				$find = utf8RawUrlDecode($find);
				$replacement = utf8RawUrlDecode($replacement);
				$this->alinksModel->findAndReplace($find, $replacement);
				break;
			case 'keyphrase_form':
				$this->keyphraseForm($keyphraseID);
				$this->sendXml = false;
				break;
			case 'update_keyphrase':
				$this->updateKeyphrase($keyphraseID, $keyphrase, $description, $elementName, $elementValue);
				break;
			case 'delete_keyphrase':
				$this->alinksModel->deleteKeyphrase($keyphraseID);
				break;
			case 'massdelete_keyphrase':
				$keyphrase = utf8RawUrlDecode($keyphrase);
				$this->alinksModel->massDeleteKeyphrase($keyphrase);
				break;
		}
	}
	
	function updateKeyphrase($keyphraseID, $keyphrase, $description, $elementName, $elementValue) {
		$elemArray = array();
		for ($i = 0; $i < count($elementValue); $i++) {
			if (empty($elementName[$i])) continue;
			$elemArray[$elementName[$i]] = utf8RawUrlDecode($elementValue[$i]);
		}
		$defines = serialize($elemArray);
		if (empty($keyphrase)) {
			return;
		}
		
		$keyphrase = utf8RawUrlDecode($keyphrase);
		$description = utf8RawUrlDecode($description);
		return $this->alinksModel->updateKeyphrase($keyphraseID, $keyphrase, $description, $defines);
	}
	
	function newClipboard($clipboardNumber, $clipboardValue) {
		$clipboards = get_option('alinks_clipboards');
		if (empty($clipboards)) {
			$clipboards = array(1 => '', '', '', '');
		}
		$clipboards[$clipboardNumber] = utf8RawUrlDecode($clipboardValue);
		update_option('alinks_clipboards', $clipboards);
		return true;
	}
	
	function newKeyphrase($keyphrase, $description, $module, $elementName, $elementValue) {
		$elemArray = array();
		for ($i = 0; $i < count($elementValue); $i++) {
			if (empty($elementName[$i])) continue;
			$elemArray[$elementName[$i]] = utf8RawUrlDecode($elementValue[$i]);
		}
		$defines = serialize($elemArray);
		if (empty($keyphrase)) {
			return;
		}
		
		$keyphrase = utf8RawUrlDecode($keyphrase);
		$description = utf8RawUrlDecode($description);
		return $this->alinksModel->newKeyphrase($keyphrase, $description, $defines, $module);
	}
	
	function logKeyphrase($keyphrase) {
		$alinksLogger = new aLinksLogger($this->alinks_log_path);
		$ip = $_SERVER['REMOTE_ADDR'];
		$timestamp = time();
		return $alinksLogger->query("INSERT INTO alinks VALUES('$keyphrase', '$timestamp', '$ip')");
	}
	
	function show() {
		$this->notifyObjects('aLinksBackend::show', 'Show-Started');
		if (!$keyphrases = $this->alinksModel->getKeyphraseList($this->searchTerm)) {
			return false;
		}

		$modules = $this->alinksModules->getModules();

		header("Content-Type: text/xml\r\n");
		$this->notifyObjects('aLinksBackend::show', 'Header-Sent');
		echo "<?xml version=\"1.0\"?>\r\n";
		echo "<keyphrases>\r\n";

		foreach ($keyphrases as $keyphrase) {
			$module = strtolower($keyphrase['module']);
			$moduleName = $modules[$module]['info']['name'];
			if(get_magic_quotes_gpc() || get_magic_quotes_runtime()) {
				$phrase = stripslashes($keyphrase['keyphrase']);
				$description = stripslashes($keyphrase['description']);
			} else {
				$phrase = $keyphrase['keyphrase'];
				$description = $keyphrase['description'];
			}
			
			$phrase = utf8_encode($phrase);
			$description = utf8_encode($description);
			
			echo "\t<keyphrase>\r\n";
			echo "\t\t<phrase><![CDATA[$phrase]]></phrase>\r\n";
			echo "\t\t<description><![CDATA[$description]]></description>\r\n";
			echo "\t\t<module><![CDATA[$moduleName]]></module>\r\n";
			echo "\t\t<id>{$keyphrase['id']}</id>\r\n";
			echo "\t</keyphrase>\r\n";
		}
		echo "</keyphrases>\r\n";
		$this->notifyObjects('aLinksBackend::show', 'Show-Done');
	}
	
	function keyphraseForm($keyphraseID) {
		$this->notifyObjects('aLinksBackend::keyphraseForm', 'keyphraseForm-Started');
		$moduleType = $this->alinksModel->getModuleType($keyphraseID);
		$keyphraseData = $this->alinksModel->getKeyphraseById($keyphraseID);
		$keyphrase = utf8_encode($keyphraseData['keyphrase']);
		$keyphraseDescription = utf8_encode($keyphraseData['description']);
		if(get_magic_quotes_gpc() || get_magic_quotes_runtime()) {
			$keyphrase = stripslashes($keyphrase);
			$keyphraseDescription = stripslashes($keyphraseDescription); 
		}
		$keyphraseDefined = $keyphraseData['defines'];
		$keyphraseDefined = unserialize($keyphraseDefined);
		$this->alinksLang = new aLinksLang($this->alinksModel->alinks_languages_path);
		$alinksModules = new aLinksModules;
		$module = $alinksModules->getModule(strtolower($moduleType));
		if (!$module) {
			echo '<div style="padding: 10px; font-size: 0.9em;">';
			echo '<p><strong>Module for this keyphrase not found!</strong></p>';
			echo '<input type="button" onclick="parent.deleteKeyphrase(' . $keyphraseID . ');" value="' . $this->alinksLang->_('Delete Keyphrase') . ' &raquo;" /> ';
			echo '<input type="button" onclick="parent.cancelEdit();" value="' . $this->alinksLang->_('Cancel') . ' &raquo;" />';
			echo '</div>';
			return false;
		}
		
		$alinksForms = new aLinksForms;
		$defines = $module['defines'];
		?>
		<form method="post" name="form_<?php echo $module['info']['name']; ?>" onsubmit="return parent.updateKeyphrase(this);">
			<input type="hidden" name="alinks_action" value="update_keyphrase" />
			<input type="hidden" name="id" value="<?php echo $keyphraseID; ?>" />
				<div style="padding: 10px; font-size: 0.9em;">
					<p><strong>Keyphrase:</strong> <input type="text" name="keyphrase" id="keyphrase" size="40" value="<?php echo $keyphrase; ?>" onfocus="parent.currentElement = this;" /></p>
					<p><strong>Description:</strong> <input type="text" name="description" id="description" size="50" value="<?php echo $keyphraseDescription; ?>" onfocus="parent.currentElement = this;" /></p>
					<?php
					foreach ($defines as $define) {
						$defineName = $define['input']['name'];
						$alinksForms->set($define, $keyphraseDefined[$defineName], 'parent.');
						$alinksForms->show();
					}
					?>
					<input type="submit" value="<?php echo $this->alinksLang->_('Update Keyphrase'); ?> &raquo;" />
					<input type="button" onclick="parent.deleteKeyphrase(<?php echo $keyphraseID; ?>);" value="<?php echo $this->alinksLang->_('Delete Keyphrase'); ?> &raquo;" />
					<input type="button" onclick="parent.cancelEdit();" value="<?php echo $this->alinksLang->_('Cancel'); ?> &raquo;" />
				</div>
		</form>
		<?php
		$this->notifyObjects('aLinksBackend::keyphraseForm', 'keyphraseForm-Done');
		return true;
	}
}
//error_reporting(0);
new aLinksBackend($alinksModel, $alinksStruct);