var ieStyle=true;

if (typeof document.attachEvent!='undefined') {
   window.attachEvent('onload',initNuTooltips);
} else {
	ieStyle=false;
   window.addEventListener('load',initNuTooltips,false);
}


var tipsRepository=new Array();

function initNuTooltips(){
	for(var i=0; i<document.images.length; i++){
		var im=document.images[i];

		if(im.id.match(/^ban_/)){
			tipsRepository.push(new NuTooltip(im));
		}
	}
}

//check if 's' child of 'd'
function getTipDiv(s) {
	while(s) {
		if (s.id!=null && s.id.match(/^ban_tooltip_/i))
			return s;
		s=s.parentNode;
	}
	return false;
}

function unlockAll(exceptClass){
	for(var i=0; i<tipsRepository.length; i++){
		var tClass=tipsRepository[i];
		if(tClass!=exceptClass && tClass.isLocked){
			tClass.unlock();
		}
	}
}

var NuTooltip=function(img){
	this.isLocked=false;
	this.img=img;
	this.tip=tip=document.getElementById('ban_tooltip_'+img.id.substr(4));

	tip.style.position='absolute';
	tip.style.visibility='visible';

	img.tipClass=this;
	tip.tipClass=this;
	//div.style.display='none';

	if(ieStyle){
		img.attachEvent('onmousemove',this.mouseMoveHandler);
		img.attachEvent('onmouseout',this.mouseOutHandler);
		img.attachEvent('onmouseover',this.mouseOverHandler);
		img.attachEvent('onclick',this.mouseClickHandler);
	}else{
		img.addEventListener('mousemove',this.mouseMoveHandler,false);
		img.addEventListener('mouseout',this.mouseOutHandler,false);
		img.addEventListener('mouseover',this.mouseOverHandler,false);
		img.addEventListener('click',this.mouseClickHandler,true);
	}

}

NuTooltip.prototype.mouseMoveHandler=function(e){
	if(!e) e=event;

	image=(e.target ? e.target : e.srcElement);
	image.tipClass.tip.style.display='block';

	tipClass=image.tipClass;

	if(tipClass.isLocked){
		return ;
	}

	ox=10;
	oy=10;
	lockX=10;
	lockY=10;
	// This added to alleviate bug in IE6 w.r.t DOCTYPE
	bodyScrollTop=document.documentElement&&document.documentElement.scrollTop?document.documentElement.scrollTop:document.body.scrollTop;
	bodyScrollLet=document.documentElement&&document.documentElement.scrollLeft?document.documentElement.scrollLeft:document.body.scrollLeft;
	mouseX=e.pageX?e.pageX-bodyScrollLet:e.clientX-document.body.clientLeft;
	mouseY=e.pageY?e.pageY-bodyScrollTop:e.clientY-document.body.clientTop;

	tipClass.tip.style.left=bodyScrollLet+mouseX+ox+lockX+"px";
	tipClass.tip.style.top=bodyScrollTop+mouseY+oy+lockY+"px";
}

NuTooltip.prototype.mouseOutHandler=function(e){
	if(!e) e=event;
	image=(e.target ? e.target : e.srcElement);

	tipClass=image.tipClass;

	if(tipClass.isLocked){
		return ;
	}

	tipClass.tip.style.display='none';
}

NuTooltip.prototype.mouseOverHandler=function(e){
	if(!e) e=event;
	image=(e.target ? e.target : e.srcElement);
}

NuTooltip.prototype.mouseClickHandler=function(e){
	if(!e) e=event;
	image=(e.target ? e.target : e.srcElement);

	tipClass=image.tipClass;

	if(tipClass.isLocked){
		tipClass.unlock();
	}else{
		tipClass.lock();
	}

	if(ieStyle){
		e.cancelBubble=true;
	}else{
		e.stopPropagation();
	}

	return false;
}

NuTooltip.prototype.unlock=function(){
	if(ieStyle){
		document.detachEvent('onclick',this.documentClickHandler);
	}else{
		document.removeEventListener('click',this.documentClickHandler,false);
	}

	this.isLocked=false;
	this.tip.style.display='none';
}

NuTooltip.prototype.lock=function(){
	this.isLocked=true;
	this.tip.style.display='block';

	if(ieStyle){
		document.attachEvent('onclick',this.documentClickHandler);
	}else{
		document.addEventListener('click',this.documentClickHandler,false);
	}

	unlockAll(this);
}

NuTooltip.prototype.documentClickHandler=function(e){
	if(!e) e=event;
	src= (e.target ? e.target : e.srcElement);

	if(getTipDiv(src))
		return ;

	unlockAll();
}