<?php
/*==========================================================================*\
|| ######################################################################## ||
|| # Template Modification System 1.1.5
|| # -------------------------------------------------------------------- # ||
|| # Copyright 2007-2008 Andreas 'Kirby' Kirbach. All Rights Reserved. 
|| # This file may not be redistributed in whole or significant part.     # ||
|| # -------------------------------------------------------------------- # ||
|| # http://www.vbulletin.org/forum/misc.php?do=producthelp&pid=tms
|| ######################################################################## ||
\*==========================================================================*/

require_once(DIR . '/includes/adminfunctions_template.php');

define('TMSVERSION', 'v115');

function construct_templateedits($productinfo, $format, $languageid, $haltonerror = false, $styleid = -1)
{
	global $vbulletin;
	
	$templateedits = $vbulletin->db->query_read("
		SELECT
		*
		FROM " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation
		LEFT JOIN " . TABLE_PREFIX . "templateedit AS templateedit ON (templateedit.varname=templateeditlocation.varname AND templateedit.styleid=$styleid)
		WHERE templateeditlocation.product = '" . $vbulletin->db->escape_string($productinfo['productid']) . "'
			AND templateeditlocation.varname != 'tmsbranding'
			AND templateedit.styleid = $styleid
	");

	if ($vbulletin->db->num_rows($templateedits))
	{
		require_once(DIR . '/includes/functions_misc.php');
		$vbphrase['url'] = fetch_phrase('url', 'style', '', true, true, $languageid, false);
		$vbphrase['version'] = fetch_phrase('version', 'style', '', true, true, $languageid, false);
		if ($format == 'txt')
		{
			$templateeditbits = '';
			while ($templateedit = $vbulletin->db->fetch_array($templateedits))
			{
				if (preg_match('#^' . preg_quote($templateedit['searchstr'], '#') . '(\r\n|\r|\n)(.*)#si', $templateedit['replacestr'], $matches))
				{
					$phrase = 'templateeditbit_insertbelow';
					$templateedit['replacestr'] = $matches[2];
				}
				else if (preg_match('#(.*)(\r\n|\r|\n)' . preg_quote($templateedit['searchstr'], '#') . '$#si', $templateedit['replacestr'], $matches))
				{
					$phrase = 'templateeditbit_insertabove';
					$templateedit['replacestr'] = $matches[1];
				}
				else if (empty($templateedit['replacestr']))
				{
					$phrase = 'templateeditbit_remove';
				}
				else
				{
					$phrase = 'templateeditbit_replace';
				}
				$templateeditbits .= construct_phrase(fetch_phrase($phrase, 'style', '', true, true, $languageid) . "\r\n\r\n\r\n\r\n", (($templateedit['active']) ? '' : fetch_phrase('this_is_an_optional_edit', 'style', '', true, true, $vbulletin->GPC['languageid']) . "\r\n"), $templateedit['template'], rtrim($templateedit['searchstr']), rtrim($templateedit['replacestr']));
			}
			$vbphrase['edit_the_following_templates'] = fetch_phrase('edit_the_following_templates', 'style', '', true, true, $languageid, false);
			eval('$doc = "' . fetch_phrase('templateedit_instructions', 'emailbody', '', true, true, $languageid, false) . '";');
			$doc = substr($doc, 0, -8);
		}
		else
		{
			$doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n";
			eval('$doc .= "' . fetch_phrase('templateedit_xml_info', 'emailbody', '', true, true, $languageid, false) . '\r\n";');
			$doc .= construct_templateedits_xml($productinfo, false, $templateedits, $styleid);
		}
		return $doc;
	}
	else
	{
		print_stop_message('no_templateedits_found');
	}
}

function fetch_modified_template($template, $showcomments)
{
	global $vbulletin;

	$templateeditsq = $vbulletin->db->query_read("
		SELECT templateedit.searchstrregex, templateedit.replacestr, templateeditlocation.title, IF(ISNULL(product.title), 'vBulletin', product.title) AS producttitle
		FROM " . TABLE_PREFIX . "template AS template
		INNER JOIN " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation ON (templateeditlocation.template=template.title)
		INNER JOIN " . TABLE_PREFIX . "templateedit AS templateedit ON (templateedit.varname=templateeditlocation.varname)
		LEFT JOIN " . TABLE_PREFIX . "style AS style ON (style.styleid=template.styleid)
		LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=templateeditlocation.product)
		WHERE (templateeditlocation.product = 'vbulletin' OR product.active = 1) 
			AND templateedit.active = 1
			AND template.templateid = $template[templateid]
			AND (template.styleid = templateedit.styleid OR FIND_IN_SET(templateedit.templateeditid, style.templateeditlist))
			AND templateeditlocation.varname != 'tmsbranding'
			ORDER BY searchorder ASC
	");
	$templateparts = array(0 => array('type' => 1, 'text' => $template['template_un']));
	
	while ($templateedit = $vbulletin->db->fetch_array($templateeditsq))
	{
		$found = false;
		
		if ($showcomments)
		{
			$temptempl = '';
			foreach ($templateparts AS $index => $templatepart)
			{
				if ($templatepart['type'] == 1 AND $temptempl .= $templatepart['text'] AND preg_match("/$templateedit[searchstrregex]/", $temptempl))
				{
					$found = true;
					$replaced = preg_replace("/$templateedit[searchstrregex]/", $templateedit['replacestr'], $temptempl);
					for ($i = 0; $i < strlen($replaced); $i++)
					{
						if ($replaced["$i"] != $temptempl["$i"])
						{
							$startidx = $i;
							break;
						}
					}

					$firstidx = $secondidx = -1;
					$len = 0;
					$temptempl = '';

					foreach ($templateparts AS $partidx => $part)
					{
						if ($part['type'] == 1)
						{
							if (($len += strlen($part['text'])) > $startidx-1 AND $partidx <= $index)
							{
								$temptempl .= $part['text'];
								if ($firstidx == -1)
								{
									$firstidx = $partidx;
								}
							}
						}
					}

					$diff = $index - $firstidx;

					$replaced = preg_replace("/$templateedit[searchstrregex]/", $templateedit['replacestr'], $temptempl);
					for ($i = 0; $i < strlen($replaced); $i++)
					{
						if ($replaced["$i"] != $temptempl["$i"])
						{
							$start = $i;
							break;
						}
					}
					for ($i = 1; $i < strlen($replaced); $i++)
					{
						if ($replaced[strlen($replaced) - $i] != $temptempl[strlen($temptempl) - $i])
						{
							$end = strlen($replaced) - $i;
							break;
						}
					}

					$beforetext = substr($replaced, 0, $start);
					$inserttext = substr($replaced, $start, ($end - $start) + 2);
					$aftertext = substr($replaced, $end + 2);

					$templateparts = array_merge(array_slice($templateparts, 0, $firstidx), array(
						array(
							'type' => 1,
							'text' => $beforetext),
						array(
							'type' => '2',
							'text' => "<!-- $templateedit[producttitle]: $templateedit[title] -->"),
						array(
							'type' => 1,
							'text' => $inserttext),
						array(
							'type' => '2',
							'text' => "<!-- / $templateedit[producttitle]: $templateedit[title] -->"),
						array(
							'type' => 1,
							'text' => $aftertext)
					), array_slice($templateparts, $index + 1));	
					$found = true;
					break;
				}
			}
		}
		if (!$found OR !$showcomments)
		{
			$template['template_un'] = preg_replace("/$templateedit[searchstrregex]/", $templateedit['replacestr'], $template['template_un']);
		}
	}

	if ($showcomments)
	{
		$commtemplate = '';
		foreach ($templateparts AS $templatepart)
		{
			$text = htmlspecialchars_uni($templatepart['text']);
			if ($templatepart['type'] == 2)
			{
				$text = "<span style=\"background-color:yellow; color:red; font-weight:bold\">$text</span>";
			}
			$commtemplate .= $text;
		}
		return '<div id="tms_templatetext" style="margin:20px; margin-top:5px">
			<pre class="bginput" style="margin:0px; padding4px; border:1px inset; width:100%; height:600px; overflow:auto"><div dir="ltr" style="text-align:left;">' . $commtemplate . '</div></pre>
		</div>';
	}
	else
	{
		return $template['template_un'];
	}
}

function print_template_row($value = '', $rows = 4, $cols = 40, $htmlise = true, $doeditbutton = true, $direction = '', $textareaclass = false)
{
	global $vbphrase, $vbulletin;

	$direction = verify_text_direction($direction);

	$resizer = "<div class=\"smallfont\"><a href=\"#\" onclick=\"return resize_textarea(1, '{$vbulletin->textarea_id}')\">$vbphrase[increase_size]</a> <a href=\"#\" onclick=\"return resize_textarea(-1, '{$vbulletin->textarea_id}')\">$vbphrase[decrease_size]</a></div>";

	$class = fetch_row_bgclass();
	echo("<tr><td colspan=\"2\" class=\"$class\">
		<div id=\"ctrl_$name\"><textarea name=\"$name\" id=\"tms_templatetext\"" . iif($textareaclass, " class=\"$textareaclass\"") . " rows=\"$rows\" cols=\"$cols\" wrap=\"virtual\" dir=\"$direction\" style=\"width:100%\" tabindex=\"1\"" . iif($vbulletin->debug, " title=\"name=&quot;$name&quot;\"") . '>' . iif($htmlise, htmlspecialchars_uni($value), $value) . "</textarea>$resizer</div></td></tr>");
}

function print_ajax_table_footer($colspan = 2, $rowhtml = '', $tooltip = '', $echoform = true, $closetbody = false)
{
	global $tableadded, $vbulletin;

	if ($rowhtml)
	{
		$tooltip = iif($tooltip != '', " title=\"$tooltip\"", '');
		if ($tableadded)
		{
			echo "<tr>\n\t<td class=\"tfoot\"" . iif($colspan != 1 ," colspan=\"$colspan\"") . " align=\"center\"$tooltip>$rowhtml</td>\n</tr>\n";
		}
		else
		{
			echo "<p align=\"center\"$tooltip>$extra</p>\n";
		}
	}

	if ($closetbody)
	{
		echo "</tbody>\n";
	}

	if ($tableadded)
	{
		echo "</table>\n";
	}

	if ($echoform)
	{
		print_hidden_fields();

		echo "</form>\n<!-- form ended: " . $vbulletin->db->querycount ." queries executed -->\n\n";
	}
}

function print_ajax_submit_row($submitname = '', $resetname = '_default_', $colspan = 2, $goback = '', $extra = '', $alt = false, $showsubmit = true, $savefunction = '', $abortfunction = '', $closetbody = false)
{
	global $vbphrase, $vbulletin;

	// do submit button
	if ($submitname === '_default_' OR $submitname === '')
	{
		$submitname = $vbphrase['save'];
	}
	
	if ($showsubmit)
	{
		$button1 = "\t<input type=\"submit\" onclick=\"return $savefunction()\" class=\"button\" tabindex=\"1\" value=\"" . str_pad($submitname, 8, ' ', STR_PAD_BOTH) . "\" accesskey=\"s\" />\n";
	}

	// do extra stuff
	if ($extra)
	{
		$extrabutton = "\t$extra\n";
	}

	// do reset button
	if ($resetname)
	{
		if ($resetname === '_default_')
		{
			$resetname = $vbphrase['reset'];
		}

		$resetbutton .= "\t<input type=\"button\" onclick=\"return $abortfunction()\" class=\"button\" tabindex=\"1\" value=\"" . str_pad($resetname, 8, ' ', STR_PAD_BOTH) . "\" accesskey=\"r\" />\n";
	}

	// do goback button
	if ($goback)
	{
		$button2 .= "\t<input type=\"button\" class=\"button\" value=\"" . str_pad($goback, 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"history.back(1);\" />\n";
	}

	if ($alt)
	{
		$tfoot = $button2 . $extrabutton . $resetbutton . $button1;
	}
	else
	{
		$tfoot = $button1 . $extrabutton . $resetbutton . $button2;
	}

	// do debug tooltip
	if ($vbulletin->debug AND is_array($GLOBALS['_HIDDENFIELDS']))
	{
		$tooltip = 'HIDDEN FIELDS:';
		foreach ($GLOBALS['_HIDDENFIELDS'] AS $key => $val)
		{
			$tooltip .= "\n\$$key = &quot;$val&quot;";
		}
	}
	else
	{
		$tooltip = '';
	}
	
	print_ajax_table_footer($colspan, $tfoot, $tooltip, true, $closetbody);
}


function check_tms_codes($productid, $haveedits = false)
{
	global $vbulletin;

	if ($productid == 'vbulletin')
	{
		// vBulletin does not have Installations-/Deinstallationscodes
		return;
	}
	if ($haveedits OR $editcheck = $vbulletin->db->query_first("SELECT templateeditlocationid FROM " . TABLE_PREFIX . "templateeditlocation WHERE product = '" . $vbulletin->db->escape_string($productid) . "'"))
	{
		if (!$codecheck = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "productcode WHERE productid = '" . $vbulletin->db->escape_string($productid) . "' AND version = '*' AND installcode LIKE '%install_templateedits(\$info, \$arr, \$active)%'"))
		{
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "productcode
				(productid, version, installcode, uninstallcode)
				VALUES
				(
					'" . $vbulletin->db->escape_string($productid) . "',
					'*',
					'" . $vbulletin->db->escape_string('if ($vbulletin->products[\'tms\'])
{
	require_once(DIR . \'/includes/adminfunctions_templateedits.php\');
	install_templateedits($info, $arr, $active);
}') . "',
					'" . $vbulletin->db->escape_string('if ($vbulletin->products[\'tms\'])
{
	require_once(DIR . \'/includes/adminfunctions_templateedits.php\');
	uninstall_templateedits($vbulletin->GPC[\'productid\']);
}') . "'
				)
			");
		}
	}
	else
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "productcode WHERE productid = '" . $vbulletin->db->escape_string($productid) . "' AND version = '*' AND installcode LIKE '%install_templateedits(\$info, \$arr, \$active)%'");
	}
}

function construct_searchstr_regex($searchstr)
{
	return preg_replace('/\s+/', '\s*', preg_quote(trim($searchstr), '/'));
}

function check_help_cache()
{
	global $helpcache, $vbulletin;

	if (!$helpcache)
	{
		$helpcache = array();
		$helptopics = $vbulletin->db->query_read("SELECT script, action, optionname FROM " . TABLE_PREFIX . "adminhelp");
		while ($helptopic = $vbulletin->db->fetch_array($helptopics))
		{
			$multactions = explode(',', $helptopic['action']);
			foreach ($multactions AS $act)
			{
				$act = trim($act);
				$helpcache["$helptopic[script]"]["$act"]["$helptopic[optionname]"] = 1;
			}
		}
	}
}

function get_template_edits($templateid, $html, $title = '', $styleid = 0)
{
	define('INTMS', true);

	global $vbulletin, $vbphrase, $bgclass, $templateinfo, $template, $stylevar;
	
	$vbulletin->input->clean_array_gpc('r', array(
		'dostyleid' => TYPE_INT,
		'title' => TYPE_STR
	));

	if ($title)
	{
		if ($styleid != -1)
		{
			$style = $vbulletin->db->query_first("SELECT templatelist FROM " . TABLE_PREFIX . "style WHERE styleid = " . intval($styleid));
			$templatelist = unserialize($style['templatelist']);
			$templateid = $templatelist["$title"];
			$template = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "template WHERE templateid = $templateid");
		}
		else
		{
			$template = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "template WHERE styleid = -1 AND title = '" . $vbulletin->db->escape_string($title) . "'");
			$templateid = $template['templateid'];
		}
	}

	$templateeditbits = '';

	if ($templateid)
	{
		$templateedits = $vbulletin->db->query_read("
			SELECT templateedit.searchorder, templateedit.searchstrregex, templateedit.replacestr, templateeditlocation.title, templateeditid, templateedit.styleid, IF(ISNULL(product.title), 'vBulletin', product.title) AS producttitle, templateedit.active AS editactive, IF(templateeditlocation.product='vbulletin', 1, product.active) AS productactive, template.styleid AS tstyleid
			FROM " . TABLE_PREFIX . "template AS template
			INNER JOIN " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation ON (templateeditlocation.template=template.title)
			INNER JOIN " . TABLE_PREFIX . "templateedit AS templateedit ON (templateedit.varname=templateeditlocation.varname)
			LEFT JOIN " . TABLE_PREFIX . "style AS style ON (style.styleid=template.styleid)
			LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=templateeditlocation.product)
			WHERE template.templateid = $templateid
				AND (template.styleid = templateedit.styleid OR FIND_IN_SET(templateedit.templateeditid, style.templateeditlist))
				AND templateeditlocation.varname != 'tmsbranding'
				ORDER BY searchorder ASC
		");
	}
	else
	{
		$templateedits = $vbulletin->db->query_read("
			SELECT templateedit.searchorder, templateedit.searchstrregex, templateedit.replacestr, templateeditlocation.title, templateeditid, templateedit.styleid, IF(ISNULL(product.title), 'vBulletin', product.title) AS producttitle, templateedit.active AS editactive, IF(templateeditlocation.product='vbulletin', 1, product.active) AS productactive, " . $vbulletin->GPC['dostyleid'] . " AS tstyleid
			FROM " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation
			INNER JOIN " . TABLE_PREFIX . "templateedit AS templateedit ON (templateedit.varname=templateeditlocation.varname)
			LEFT JOIN " . TABLE_PREFIX . "style AS style ON (style.styleid = " . $vbulletin->GPC['dostyleid'] . ")
			LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=templateeditlocation.product)
			WHERE FIND_IN_SET(templateedit.templateeditid, style.templateeditlist)
				AND templateeditlocation.template = '" . $vbulletin->db->escape_string(trim($vbulletin->GPC['title'])) . "'
				AND templateeditlocation.varname != 'tmsbranding'
				ORDER BY searchorder ASC
		");
	}
	if (!empty($templateinfo['template_un']))
	{
		$template = $templateinfo['template_un'];
		$temptitle = $templateinfo['title'];
		$tempstyleid = $templateinfo['styleid'];
	}
	else
	{
		$temptitle = $template['title'];
		$tempstyleid = $template['styleid'];
		$template = $template['template_un'];
	}

	if ($vbulletin->db->num_rows($templateedits))
	{
		$templateid = intval($templateid);
		@ob_start();
		if (!$title)
		{
			echo('<div id="tmsedits">');
		}

		// collapse function courtesy of frontend global.php
		$vbcollapse = array();
		if (!empty($vbulletin->GPC['vbulletin_collapse']))
		{
			$val = preg_split('#\n#', $vbulletin->GPC['vbulletin_collapse'], -1, PREG_SPLIT_NO_EMPTY);
			foreach ($val AS $key)
			{
				$vbcollapse["collapseobj_$key"] = 'display:none;';
				$vbcollapse["collapseimg_$key"] = '_collapsed';
				$vbcollapse["collapsecel_$key"] = '_collapsed';
			}
			unset($val);
		}

		print_form_header('templateedits', 'updateactive', false, true, 'tmsstatus');
		construct_hidden_code('tmstemplate', $temptitle);
		construct_hidden_code('styleid', $tempstyleid);
		check_help_cache();
		$help = construct_help_button('', 'list', 'templateedits', 1);

		echo "<thead>\n<tr>\n\t<td class=\"tcat\" align=\"center\" colspan=\"6\">\n\t\t<a style=\"float:$stylevar[right]\" href=\"#\" onclick=\"return toggle_collapse('templateedits')\"><img id=\"collapseimg_templateedits\" src=\"../images/buttons/collapse_alt$vbcollapse[collapseimg_templateedits].gif\" alt=\"\" border=\"0\" /></a><div style=\"float:$stylevar[right];margin-right:8px\">$help</div>\n\t\t<b>$vbphrase[template_modifications]</b>\n\t</td>\n</tr>\n</thead>\n<tbody id=\"collapseobj_templateedits\" style=\"$vbcollapse[collapseobj_templateedits]\">\n";
		print_cells_row(array($vbphrase['product'], $vbphrase['title'], $vbphrase['search_order'], $vbphrase['status'], $vbphrase['active'], $vbphrase['action']), 1);
	
		while ($templateedit = $vbulletin->db->fetch_array($templateedits))
		{
			if ($templateedit['styleid'] == $templateedit['tstyleid'])
			{
				$editurl = '[<a href="templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;templateeditid=$templateedit[templateeditid]\" onclick=\"return tmseditor.edit('', $templateedit[templateeditid]);\">$vbphrase[edit]</a>]";
			}
			else
			{
				$editurl = '[<a href="templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=add&amp;dostyleid=$templateedit[tstyleid]&amp;templateeditid=$templateedit[templateeditid]\" onclick=\"return tmseditor.edit($templateedit[tstyleid], $templateedit[templateeditid]);\">$vbphrase[customize]</a>]";
			}
			if (($templateedit['editactive'] AND $templateedit['productactive']) AND ($replaced = preg_replace("/$templateedit[searchstrregex]/", $templateedit['replacestr'], $template)) != $template)
			{
				$yesno = 'yes';
				$template = $replaced;
			}
			else
			{
				$yesno = 'no';
			}
			if ($templateedit['editactive'])
			{
				$checked = 'checked="checked"';
			}
			else
			{
				$checked = '';
			}
			if (!$templateedit['productactive'])
			{
				$disabled = 'disabled="disabled"';
			}
			else
			{
				$disabled = '';
			}
			print_cells_row(array(((!$templateedit['productactive']) ? "<span style=\"text-decoration:line-through\">$templateedit[producttitle]</span>" : $templateedit['producttitle']), $templateedit['title'], $templateedit['searchorder'], (($templateedit['editactive'] AND $templateedit['productactive']) ? '<img src="../cpstyles/' . $vbulletin->options['cpstylefolder'] . "/cp_tick_$yesno.gif\" alt=\"\" />" : $vbphrase['n_a']), ((empty($disabled)) ? "<input type=\"hidden\" name=\"templateedits[]\" value=\"$templateedit[templateeditid]\" />" : '') . "<input name=\"activeedits[]\" type=\"checkbox\"  value=\"$templateedit[templateeditid]\" $checked $disabled/>", $editurl));
		}

		print_ajax_submit_row($vbphrase['save_active_status'], '', 6, '', ' <input type="button" class="button" value="' . $vbphrase['activate_all'] . '" onclick="toggle_active(this.form, 1)" /> <input type="button" class="button" value="' . $vbphrase['deactivate_all'] . '" onclick="toggle_active(this.form, 0)" />', false, true, 'tmsupdate.update_active', '', true);
		echo('<div style="margin-top:4px" align="center">' . construct_link_code($vbphrase['view_modified_template'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl_q'] . "do=doviewmodifiedtemplate&amp;template=$temptitle&amp;styleid=$tempstyleid", true) . construct_link_code($vbphrase['view_modified_template_with_comments'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl_q'] . "do=doviewmodifiedtemplate&amp;template=$temptitle&amp;styleid=$tempstyleid&amp;showcomments=1", true) . '</div>');
		if (!$title)
		{
			echo('</div><script type="text/javascript" src="../clientscript/tms_ajax.js?' . TMSVERSION . '"></script>');
			echo('<script type="text/javascript">var tmsupdate = new TMS_AJAX_UpdateActive();</script>');
			$templateedits = @ob_get_contents() . '<div id="tmsedit"></div>';
		}
		else
		{
			$templateedits = @ob_get_contents();
		}
		@ob_end_clean();
		if (!$title)
		{
			return str_replace('<!-- END CONTROL PANEL HEADER -->', "<!-- END CONTROL PANEL HEADER -->$templateedits", $html);
		}
		else
		{
			return $templateedits;
		}
	}
	else
	{
		return $html;
	}
}

function fetch_template_list($modifiedonly = false, $styleid = -1)
{
	global $vbulletin, $only;
	
	$options = array();

	if ($modifiedonly)
	{
		$templq = $vbulletin->db->query_read("
			SELECT template AS title
			FROM " . TABLE_PREFIX . "templateeditlocation
			GROUP BY template
			ORDER BY title ASC
		");
	}
	else
	{
		$templq = $vbulletin->db->query_read("
			SELECT title
			FROM " . TABLE_PREFIX . "template
			WHERE styleid = $styleid
				AND templatetype = 'template'
			ORDER BY title ASC
		");
	}
	while ($template = $vbulletin->db->fetch_array($templq))
	{
		$found = false;
		foreach ($only AS $prefix => $templategroup)
		{
			if (strpos(strtolower(" $template[title]"), $prefix) == 1)
			{
				if (!is_array($options["$templategroup"]))
				{
					$options["$templategroup"] = array($template['title'] => $template['title']);
				}
				else
				{
					$options["$templategroup"]["$template[title]"] = $template['title'];
				}

				$found = true;

				break;
			}
		}

		if (!$found)
		{
			$options["$template[title]"] = $template['title'];
		}
	}

	return $options;
}

function print_build_styleedits($styleid, $title, $templates = '', $product = '', $doidcache = false, $doedits = false)
{
	global $vbphrase;

	echo '<p>&nbsp;</p>
	<blockquote><form><div class="tborder">
	<div class="tcat" style="padding:4px" align="center"><b>' . $vbphrase['rebuild_templateedit_information'] . "</b></div>
	<div class=\"alt1\" style=\"padding:4px\">\n<blockquote>
	<p><b>" . construct_phrase($vbphrase['updating_templateedits_for_x'], $title) . "</b></p>
	<ul class=\"lci\">\n";
	vbflush();
	build_styleedits($styleid, $title, $doidcache, $doedits, '', '', $product, $templates);
	echo "</ul>\n<p><b>" . $vbphrase['done'] . "</b></p>\n</blockquote></div>
	</div></form></blockquote>
	";
	vbflush();
}

function uninstall_templateedits($productid)
{
	global $vbulletin;

	// Step 1: Get currently modified Templates
	$modifiedtemplates = array();

	$templatesq = $vbulletin->db->query_read("
		SELECT
		template
		FROM " . TABLE_PREFIX . "templateeditlocation
		WHERE product = '" . $vbulletin->db->escape_string($productid) . "'
	");
	while ($template = $vbulletin->db->fetch_array($templatesq))
	{
		$modifiedtemplates[] = $template['template'];
	}	

	if (!empty($modifiedtemplates))
	{
		// Step 2: Delete definitions
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "templateeditlocation WHERE product = '" . $vbulletin->db->escape_string($productid) . "' AND varname != 'tmsbranding'");
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "templateedit WHERE product = '" . $vbulletin->db->escape_string($productid) . "' AND varname != 'tmsbranding'");

		// Step 3: Rebuild Templateedits as necessary
		build_templateedit_id_cache(-1);
		rebuild_template_edits('', $modifiedtemplates);
	}
}


function fetch_replace_query_sql($queryvalues, $table)
{
	global $vbulletin;

	if (empty($exclusions))
	{
		$exclusions = array();
	}

	$numfields = sizeof($queryvalues);
	$i = 1;

	$fieldlist = '';
	$valuelist = '';
	foreach ($queryvalues AS $fieldname => $value)
	{
		if (!preg_match('#^\w+$#', $fieldname))
		{
			continue;
		}
		$endbit = iif($i++ == $numfields, '', ', ');
		$fieldlist .= '`' . $fieldname . '`' . $endbit;
		$valuelist .= iif(is_numeric($value) OR in_array($fieldname, $exclusions), "'$value'", "'" . $vbulletin->db->escape_string($value) . "'") . $endbit;
	}
	return "\n### REPLACE QUERY GENERATED BY fetch_replace_query_sql() ###\nREPLACE INTO " . TABLE_PREFIX . "$table\n\t($fieldlist)\nVALUES\n\t($valuelist)";
}


function install_templateedits($productinfo, $xmlarray, $active, $styleid = -1)
{
	global $vbulletin;

	define ('INTMS', true);
	
	// Step 1: Prepare Array
	if (is_array($xmlarray['templateedits']['templateedit']))
	{
		$templateedits =& $xmlarray['templateedits']['templateedit'];
		if (!isset($templateedits[0]))
		{
			$templateedits = array($templateedits);
		}
	}
	else
	{
		$templateedits = array();
	}
	
	// Step 2: Get Style info (if it's not the MASTER style)
	$childstyles = array();
	if ($styleid != -1)
	{
		$style = $vbulletin->db->query_first("SELECT parentlist FROM " . TABLE_PREFIX . "style WHERE styleid = $styleid");
		$childstylesq = $vbulletin->db->query_read("SELECT styleid FROM " . TABLE_PREFIX . "style WHERE FIND_IN_SET('$styleid', parentlist)");
		while ($childstyle = $vbulletin->db->fetch_array($childstylesq))
		{
			$childstyles[] = $childstyle['styleid'];
		}
	}

	// Step 3: Check for conflicting template edits
	$varnames = "''";
	$templatetitles = array();
	foreach ($templateedits AS $templateedit)
	{
		$varnames .= ",'" . $vbulletin->db->escape_string($templateedit['varname']) . "'";
		$templatetitles["$templateedit[varname]"] = $templateedit['template'];
	}
	$conflicts = $vbulletin->db->query_read_slave("
			SELECT templateeditlocation.product, templateeditlocationid, IF(templateeditlocation.product='vbulletin', 'vBulletin', product.title) AS producttitle, templateeditlocation.title AS edittitle, templateeditlocation.addstyleid, templateeditlocation.template, templateeditlocation.varname
			FROM " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation
			LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=templateeditlocation.product)
			WHERE templateeditlocation.varname IN ($varnames)
	");
	while ($conflict = $vbulletin->db->fetch_array($conflicts))
	{
		if ($productinfo['productid'] == $conflict['product'] AND $conflict['template'] == $templatetitles["$conflict[varname]"])
		{
			// ok, this is a new definition for this style or a parent style, for the same template and product
			// => delete old definition later
			// OR
			// this is a new edit for this style, but the location already exists from an inherited style
			// => nothing to do
			continue;
		}

		foreach ($templateedits AS $templateedit)
		{
			if ($templateedit['varname'] == $conflict['varname'])
			{
				$title = $templateedit['title'];
				break;
			}
		}

		print_stop_message('varname_x_already_exists', $templateedit['title'], $conflict['producttitle'], $conflict['varname'], $conflict['edittitle'], $productinfo['title']);
	}
	
	// Step 4: Get currently modified Templates
	$modifiedtemplates = array();

	$templatesq = $vbulletin->db->query_read("
		SELECT
		title
		FROM " . TABLE_PREFIX . "templateeditlocation
		WHERE product = '" . $vbulletin->db->escape_string($productinfo['productid']) . "'
	");
	while ($template = $vbulletin->db->fetch_array($templatesq))
	{
		$modifiedtemplates[] = $template['title'];
	}	

	// Step 5: Delete old definitions
	if ($productinfo['productid'] != 'vbulletin')
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "templateeditlocation WHERE product = '" . $vbulletin->db->escape_string($productinfo['productid']) . "' AND varname != 'tmsbranding' AND addstyleid = $styleid");
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "templateedit WHERE product = '" . $vbulletin->db->escape_string($productinfo['productid']) . "' AND styleid = $styleid AND varname != 'tmsbranding'");
	}

	// Step 6: Insert new definitions
	foreach ($templateedits AS $templateedit)
	{
		$modifiedtemplates[] = $templateedit['template'];

		$templateeditlocation = array(
			'varname' => $templateedit['varname'],
			'title' => $templateedit['title'],
			'template' => $templateedit['template'],
			'product' => $productinfo['productid'],
			'addstyleid' => $styleid
		);
		$vbulletin->db->hide_errors();
		$vbulletin->db->query_write(fetch_query_sql($templateeditlocation, 'templateeditlocation'));
		if (($errno = $vbulletin->db->errno()) == 1062)
		{
			$getlocation = $vbulletin->db->query_first("
				SELECT templateeditlocation.product, templateeditlocationid, IF(templateeditlocation.product='vbulletin', 'vBulletin', product.title) AS title, templateeditlocation.title AS edittitle, templateeditlocation.addstyleid, templateeditlocation.template
				FROM " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation
				LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=templateeditlocation.product)
				WHERE templateeditlocation.varname = '" . $vbulletin->db->escape_string($templateeditlocation['varname']) . "'
			");
			if ($productinfo['productid'] == $getlocation['product'] AND $getlocation['template'] == $templateedit['template'] AND ($styleid == -1 OR in_array($getlocation['addstyleid'], $childstyles)))
			{
				// ok, this is a new definition for this style or a parent style, for the same template and product
				// => delete old definition
				$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "templateeditlocation WHERE templateeditlocationid = $getlocation[templateeditlocationid]");
				$vbulletin->db->query_write(fetch_query_sql($templateeditlocation, 'templateeditlocation'));
			}
			else if ($productinfo['productid'] == $getlocation['product'] AND $getlocation['template'] == $templateedit['template'] AND in_array($styleid, explode(',', $style['parentlist'])))
			{
				// this is a new edit for this style, but the location already exists from an inherited style
				// => nothing to do
			}
			else
			{
				print_stop_message('varname_x_already_exists', $templateeditlocation['title'], $getlocation['title'], $templateeditlocation['varname'], $getlocation['edittitle'], $productinfo['title']);
			}
		}
		$vbulletin->db->show_errors();

		$templateedit = array(
			'styleid' => $styleid,
			'varname' => $templateedit['varname'],
			'searchorder' => $templateedit['searchorder'],
			'searchstr' => $templateedit['searchstr'],
			'searchstrregex' => construct_searchstr_regex($templateedit['searchstr']),
			'replacestr' => $templateedit['replacestr'],
			'product' => $productinfo['productid'],
			'version' => $templateedit['version'],
			'username' => $templateedit['username'],
			'dateline' => $templateedit['dateline'],
			'active' => (array_key_exists('active', $templateedit) ? $templateedit['active'] : 1)
		);
		$vbulletin->db->query_write(fetch_replace_query_sql($templateedit, 'templateedit'));
	}
	
	// Step 7: Delete orphaned templateedits
	$vbulletin->db->query_write("DELETE " . TABLE_PREFIX . "templateedit FROM " . TABLE_PREFIX . "templateedit LEFT JOIN " . TABLE_PREFIX . "templateeditlocation ON (" . TABLE_PREFIX . "templateeditlocation.varname=" . TABLE_PREFIX . "templateedit.varname) WHERE " . TABLE_PREFIX . "templateeditlocation.varname IS NULL");

	// Step 8: Rebuild Templateedits as necessary
	build_templateedit_id_cache(-1);
	rebuild_template_edits((($active) ? $productinfo['productid'] : ''), $modifiedtemplates);
	
	define('TMS_EDITS_INSTALLED', true);	
	define('TMSREBUILT', true);
}

function build_templateedit_id_cache($styleid, $doreturn = false, $parentids = false)
{
	global $vbulletin;

	if ($styleid == -1)
	{
		// build for all styles
		$styles = $vbulletin->db->query_read("SELECT styleid, parentlist FROM " . TABLE_PREFIX . "style");
		while ($style = $vbulletin->db->fetch_array($styles))
		{
				build_templateedit_id_cache($style['styleid'], $doreturn, $childset['parentlist']);
		}
		return;
	}

	if ($parentids == 0)
	{
		$style = $vbulletin->db->query_first("
			SELECT styleid, title, parentlist
			FROM " . TABLE_PREFIX . "style
			WHERE styleid = $styleid
		");
	}
	else
	{
		$style['parentlist'] = $parentids;
	}
	
	if (empty($style['parentlist']))
	{
		$style['parentlist'] = fetch_template_parentlist($style['styleid']);	
	}

	$parents = explode(',', $style['parentlist']);
	$i = sizeof($parents);
	$totalparents = $i;
	foreach ($parents AS $setid)
	{
		if ($setid != -1)
		{
			$querySele = ",\nt$i.templateeditid AS templateeditid_$i, t$i.styleid AS styleid_$i $querySele";
			$queryJoin = "\nLEFT JOIN " . TABLE_PREFIX . "templateedit AS t$i ON (t1.varname=t$i.varname AND t$i.styleid=$setid)$queryJoin";
			$i--;
		}
	}

	$templateeditlist = array();
	$templateedits = $vbulletin->db->query_read("
		SELECT t1.templateeditid AS templateeditid_1, t1.varname $querySele
		FROM " . TABLE_PREFIX . "templateedit AS t1 $queryJoin
		WHERE t1.styleid = -1
	");
	while ($templateedit = $vbulletin->db->fetch_array($templateedits, DBARRAY_BOTH))
	{
		for ($tid = $totalparents; $tid > 0; $tid--)
		{
			if ($templateedit["templateeditid_$tid"])
			{
				$templateeditlist["$templateedit[varname]"] = $templateedit["templateeditid_$tid"];
				break;
			}
		}
	}

	// process style-specific template modifications
	$customdone = array();
	$customedits = $vbulletin->db->query_read("
		SELECT t1.templateeditid, t1.varname, INSTR(',$style[parentlist],', CONCAT(',', t1.styleid, ',') ) AS ordercontrol, t1.styleid
		FROM " . TABLE_PREFIX . "templateedit AS t1
		LEFT JOIN " . TABLE_PREFIX . "templateedit AS t2 ON (t2.varname=t1.varname AND t2.styleid=-1)
		WHERE t1.styleid IN (" . substr(trim($style['parentlist']), 0, -3) . ") AND
		t2.varname IS NULL
		ORDER BY varname, ordercontrol
	");
	while ($customedit = $vbulletin->db->fetch_array($customedits))
	{
		if ($customdone["$customedit[varname]"])
		{
			continue;
		}
		$customdone["$customedit[varname]"] = 1;
		$templateeditlist["$customedit[varname]"] = $customedit['templateeditid'];
	}

	if (!$doreturn)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "style
			SET templateeditlist = '" . implode(',', $templateeditlist) . "'
			WHERE styleid = $styleid
		");
		$childsets = $vbulletin->db->query_read("
			SELECT styleid, title, parentlist
			FROM " . TABLE_PREFIX . "style
			WHERE parentid = $styleid
		");
		if ($vbulletin->db->num_rows($childsets))
		{
			while ($childset = $vbulletin->db->fetch_array($childsets))
			{
				build_templateedit_id_cache($childset['styleid'], $doreturn, $childset['parentlist']);
			}
		}
	}
	else
	{
		$templateeditlist = implode(',', $templateeditlist);
		return $templateeditlist;
	}
}

function build_styleedits($styleid, $title = '', $doidcache = false, $doedits = false, $parentlist = '', $indent = '', $product = '', $templates = '')
{
	global $vbulletin, $vbphrase;

	echo "$indent<li><b>$title</b> ... <span class=\"smallfont\">";
	vbflush();

	// build the templateid cache
	if ($doidcache)
	{
		$templateeditlist = build_templateedit_id_cache($styleid, 1, $parentlist);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "style SET templateeditlist = '" . $vbulletin->db->escape_string($templateeditlist)  . "' WHERE styleid = $styleid");
		echo '(Templateedit-IDs) ';
		vbflush();
	}
		
	if ($doedits)
	{
		rebuild_template_edits($product, $templates, $styleid);
		echo '(Templateedits) ';
		vbflush();
	}

	// finish off the listings
	echo '</span><b>' . $vbphrase['done'] . "</b>.<br />&nbsp;</li>\n"; vbflush();

	$childsets = $vbulletin->db->query_read("
		SELECT styleid, title, parentlist
		FROM " . TABLE_PREFIX . "style
		WHERE parentid = $styleid
	");
	if ($vbulletin->db->num_rows($childsets))
	{
		echo "$indent<ul class=\"ldi\">\n";
		while ($childset = $vbulletin->db->fetch_array($childsets))
		{
			build_styleedits($childset['styleid'], $childset['title'], $doidcache, $doedits, $childset['parentlist'], $indent . "\t", $product, $templates);
		}
		echo "$indent</ul>\n";
	}
}

function rebuild_template_edits($product = '', $templates = '', $styleid = 0)
{
	DEVDEBUG("Rebuilding Templateedits for styleid: $styleid, product: $product" . (is_array($templates) ? ', templates: ' .  implode(',', $templates) : ''));

	global $vbulletin, $tmpledited;

	if ($templates)
	{
		$templatelist = implode("', '", array_map(array($vbulletin->db, 'escape_string'), $templates));
	}

	$templateedits = array();

	$modifiedtemplates = $vbulletin->db->query_read("
		SELECT templateid
		FROM " . TABLE_PREFIX . "template
		WHERE
			edited=1
			" . iif($templates, "AND title IN ('$templatelist')") . "
			" . iif($styleid, "AND styleid = $styleid") . "
	");
	while ($template = $vbulletin->db->fetch_array($modifiedtemplates))
	{
		$templateedits["$template[templateid]"]['search'][] = '/^$/';
		$templateedits["$template[templateid]"]['replace'][] = '';
	}
	$vbulletin->db->free_result($templatesq);

	if (!defined('TMSDEACTIVATED'))
	{
		$templateeditsq = $vbulletin->db->query_read("
			SELECT templateid, searchstrregex, replacestr
			FROM " . TABLE_PREFIX . "templateedit AS templateedit
			INNER JOIN " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation ON (templateeditlocation.varname=templateedit.varname)
			INNER JOIN " . TABLE_PREFIX . "template AS template ON (template.title=templateeditlocation.template)
			LEFT JOIN " . TABLE_PREFIX . "style AS style ON (style.styleid=template.styleid AND FIND_IN_SET(templateedit.templateeditid, style.templateeditlist))
			LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=templateeditlocation.product)
			WHERE (NOT ISNULL(style.styleid) OR (templateedit.styleid=-1 AND template.styleid=-1))
				AND " . iif($product, "(product.active=1 OR templateeditlocation.product='vbulletin' OR templateeditlocation.product='" . $vbulletin->db->escape_string($product) . "')", "(product.active=1 OR templateeditlocation.product='vbulletin')") . "
				AND templateedit.active = 1
				" . iif($templates, "AND template.title IN ('$templatelist')") . "
				" . iif($styleid, "AND template.styleid=$styleid") . "
			ORDER BY searchorder ASC
		");
		while ($templateedit = $vbulletin->db->fetch_array($templateeditsq))
		{
			$templateedits["$templateedit[templateid]"]['search'][] = "/$templateedit[searchstrregex]/sU";
			$templateedits["$templateedit[templateid]"]['replace'][] = $templateedit['replacestr'];
		}
		$vbulletin->db->free_result($templateeditsq);
	}

	if (is_array($templateedits) AND !empty($templateedits))
	{
		$templates = $vbulletin->db->query_read("SELECT templateid, template, template_un FROM " . TABLE_PREFIX . "template WHERE templateid IN (" . implode(',', array_keys($templateedits)) . ")");
		while ($template = $vbulletin->db->fetch_array($templates))
		{
			DEVDEBUG("Checking Template $template[templateid]");
			if (($replaced = compile_template(preg_replace($templateedits["$template[templateid]"]['search'], $templateedits["$template[templateid]"]['replace'], $template['template_un']))) != $template['template'])
			{
				// check if template is still OK
				$errors = check_template_errors($replaced);
				if (empty($errors))
				{
					$edited = 0;
					if (count($templateedits["$template[templateid]"]['search']) > 1 OR $templateedits["$template[templateid]"]['search'][0] != '/^$/')
					{
						$edited = 1;
					}
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "template SET edited = $edited, template='" . $vbulletin->db->escape_string($replaced) . "' WHERE templateid=$template[templateid]");
					DEVDEBUG("Template $template[templateid] updated!");
				}
				else
				{
					DEVDEBUG("Template $template[templateid] has errors after replace!");
				}
			}
		}
		$vbulletin->db->free_result($templates);
	}
	unset($templateedits, $templatelist);
}

function print_template_edits($styleid, $style = '', $searchstring = '', $searchoptions = 0)
{
	global $vbulletin, $stylevar, $stylecache, $masterset, $vbphrase;
	global $vbphrase, $products;

	$titlesonly =& $vbulletin->GPC['titlesonly'];
	$expandset =& $vbulletin->GPC['expandset'];
	$group =& $vbulletin->GPC['group'];
	$searchstring =& $vbulletin->GPC['searchstring'];

	if ($styleid == -1)
	{
		$THISstyleid = 0;
		$style['title'] = $vbphrase['master_style'];
		$style['templateeditlist'] = serialize($masterset);
		$printstyleid = 'MASTER';
	}
	else
	{
		$THISstyleid = $styleid;
		$printstyleid =& $styleid;
	}

	if ($expandset == 'all' OR $expandset == $styleid OR (!empty($searchstring) AND $searchoptions > 0))
	{
		$showstyle = 1;
	}
	else
	{
		$showstyle = 0;
	}
	
	echo "
	<!-- start header row for style '$style[styleid]' -->
	<table cellpadding=\"2\" cellspacing=\"0\" border=\"0\" width=\"100%\" class=\"stylerow\">
	<tr>
		<td>&nbsp; " . construct_depth_mark($style['depth'], '- - ', iif($styleid != -1, '- - ')) .  '<a href="../' . $vbulletin->options['forumhome'] . '.php?' . $vbulletin->session->vars['sessionurl'] . "styleid=$styleid\" target=\"_blank\" title=\"$vbphrase[view_your_forum_using_this_style]\">$style[title]</a></td>
		<td align=\"$stylevar[right]\" nowrap=\"nowrap\">
			" . "
			&nbsp;
			<select name=\"styleEdit_$printstyleid\" id=\"menu_$styleid\" onchange=\"Sdo(this.options[this.selectedIndex].value, $styleid);\" class=\"bginput\">
					<option value=\"templateedits_modify\">$vbphrase[modify_templateedits]</option>
					<option value=\"templateedits_test\">$vbphrase[test_templateedits]</option>
					<option value=\"templateedits_add\">$vbphrase[add_templateedit]</option>
					" . iif($styleid != -1, "<option value=\"templateedits_revertall\">$vbphrase[revert_all_templateedits]</option>") . "
			</select><input type=\"button\" class=\"button\" value=\"$vbphrase[go]\" onclick=\"Sdo(this.form.styleEdit_$printstyleid.options[this.form.styleEdit_$printstyleid.selectedIndex].value, $styleid);\" />
			&nbsp;
			<input type=\"button\" class=\"button\" tabindex=\"1\"
			value=\"" . iif($showstyle, COLLAPSECODE, EXPANDCODE) . '" title="' . iif($showstyle, $vbphrase['collapse_templates'], $vbphrase['expand_templates']) . "\"
			onclick=\"window.location='templateedits.php?" . $vbulletin->session->vars['sessionurl'] . "do=modify&amp;group=$group" . iif($showstyle, '', "&amp;expandset=$styleid") . "';\" />
			&nbsp;
		</td>
	</tr>
	</table>
	<!-- end header row for style '.$style[styleid]' -->
	";
	if ($showstyle)
	{
		if ($styleid == -1)
		{
			$templateeditids = @implode(',', unserialize($style['templateeditlist']));
		}
		else
		{
			$templateeditids = $style['templateeditlist'];
		}

		if (!$templateeditids)
		{
			$templateeditids = '0';
		}
		
		$searchcondes = array();
		
		if ($searchoptions & 1)
		{
			$searchconds[] = "templateeditlocation.title LIKE '%" . $vbulletin->db->escape_string_like($searchstring) . "%'";
		}
		if ($searchoptions & 2)
		{
			$searchconds[] = "templateedit.searchstr LIKE '%" . $vbulletin->db->escape_string_like($searchstring) . "%'";
		}
		if ($searchoptions & 4)
		{
			$searchconds[] = "templateedit.replacestr LIKE '%" . $vbulletin->db->escape_string_like($searchstring) . "%'";
		}

		if (!empty($searchconds))
		{
			$searchconds = "AND (" . implode(' OR ', $searchconds) . ")";
			$searching = true;
		}
		else
		{
			$searchconds = '';
		}
		
		$templateeditsq = $vbulletin->db->query_read("
			SELECT IF(templateedit.product='vbulletin', 1, product.active) AS productactive, templateedit.active AS editactive, templateeditlocation.template, templateeditlocation.product, templateeditlocation.title, templateedit.templateeditid, templateedit.styleid, templateedit.username, templateedit.dateline
			FROM " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation
			LEFT JOIN " . TABLE_PREFIX . "templateedit AS templateedit ON (templateedit.varname=templateeditlocation.varname)
			LEFT JOIN " . TABLE_PREFIX . "style AS style ON (style.styleid=templateedit.styleid)
			LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=templateeditlocation.product)
			WHERE templateeditid IN ($templateeditids)
				AND templateeditlocation.varname != 'tmsbranding'
				$searchconds
			ORDER BY product.title ASC, templateeditlocation.template ASC, templateeditlocation.title ASC
		");

		// just exit if no templates found
		$numtemplates = $vbulletin->db->num_rows($templateeditsq);
		if ($numtemplates == 0)
		{
			return;
		}
		echo "\n<!-- start template list for style '$style[styleid]' -->\n";
			echo "<table cellpadding=\"0\" cellspacing=\"10\" border=\"0\" align=\"center\"><tr valign=\"top\">\n";
			echo "<td>\n<select name=\"tl$THISstyleid\" id=\"templatelist$THISstyleid\" class=\"darkbg\" size=\"" . TEMPLATE_EDITOR_ROWS . "\" style=\"font-weight:bold; width:350px\"\n\t";
			echo "onchange=\"Tprep(this.options[this.selectedIndex], $THISstyleid, 1);";
			echo "\"\n\t";
			echo "ondblclick=\"Tdo(Tprep(this.options[this.selectedIndex], $THISstyleid, 0), '');\">\n";
			echo "\t<option class=\"templategroup\" value=\"\" style=\"color: #FFFFFF\" selected=\"selected\">- - $style[title] Template Edits - -</option>\n";
		while ($templateedit = $vbulletin->db->fetch_array($templateeditsq))
		{
			$templateedits["$templateedit[templateeditid]"] = $templateedit;
		}
		// main templates
			$lastgroup = '';
			$echo_ul = 0;
			foreach ($templateedits AS $templateedit)
			{
				$showtemplate = 1;
				
				if ($templateedit['product'] != $lastgroup)
				{
					foreach ($products AS $thisgroup => $display)
					{
						if ($lastgroup != $thisgroup AND $echo_ul == 1)
						{
							// do nothing
							echo "</optgroup><!--<optgroup label=\"\"></optgroup>-->\n";
							$echo_ul = 0;
						}
						if ($templateedit['product'] == $thisgroup)
						{
							$lastgroup = $thisgroup;
							if ($group == 'all' OR $group == $lastgroup OR $searching)
							{
								echo "<optgroup label=\"\">\n";
								echo "\t<option class=\"templategroup\" value=\"[]\"" . iif($group == $thisgroup AND empty($vbulletin->GPC['templateid']), ' selected="selected"', '') . ">$display &laquo;</option>\n";
								$echo_ul = 1;
							}
							else
							{
								echo "\t<option class=\"templategroup\" value=\"[$thisgroup]\">$display &raquo;</option>\n";

								$showtemplate = 0;
							}
							break;
						}
					}
					// end foreach($only)
				}
				else
				{
					// Template is in the same group as lastgroup
					$showtemplate = ($templateedit['product'] == $group OR $group == 'all' OR $searching);
				}
				if ($showtemplate)
				{
					echo construct_templateedit_option($templateedit, $styleid, $echo_ul);
					vbflush();
				}
			}
			// end foreach ($maintemplates)

			echo "</select>\n";
			echo "</td>\n<td width=\"100%\" align=\"center\" valign=\"top\">";
			echo "
			<table cellpadding=\"4\" cellspacing=\"1\" border=\"0\" class=\"tborder\" width=\"300\">
			<tr align=\"center\">
				<td class=\"tcat\"><b>$vbphrase[controls]</b></td>
			</tr>
			<tr>
				<td class=\"alt2\" align=\"center\" style=\"font: 11px tahoma, verdana, arial, helvetica, sans-serif\">
					<input type=\"button\" class=\"button\" style=\"font-weight: normal\" value=\"$vbphrase[customize]\" id=\"cust$THISstyleid\" onclick=\"Tdo(Tprep(this.form.tl{$THISstyleid}[this.form.tl$THISstyleid.selectedIndex], $THISstyleid, 0), '');\" />
					<input type=\"button\" class=\"button\" style=\"font-weight: normal\" value=\"" . trim(construct_phrase($vbphrase['expand_x'], '')) . '/' . trim(construct_phrase($vbphrase['collapse_x'], '')) . "\" id=\"expa$THISstyleid\" onclick=\"Tdo(Tprep(this.form.tl{$THISstyleid}[this.form.tl$THISstyleid.selectedIndex], $THISstyleid, 0), '');\" /><br />
					<input type=\"button\" class=\"button\" style=\"font-weight: normal\" value=\" $vbphrase[edit] \" id=\"edit$THISstyleid\" onclick=\"Tdo(Tprep(this.form.tl{$THISstyleid}[this.form.tl$THISstyleid.selectedIndex], $THISstyleid, 0), '');\" />
					<input type=\"button\" class=\"button\" style=\"font-weight: normal\" value=\"$vbphrase[view_original]\" id=\"orig$THISstyleid\" onclick=\"Tdo(Tprep(this.form.tl{$THISstyleid}[this.form.tl$THISstyleid.selectedIndex], $THISstyleid, 0), 'vieworiginal');\" />
					<input type=\"button\" class=\"button\" style=\"font-weight: normal\" value=\"$vbphrase[test]\" id=\"test$THISstyleid\" onclick=\"Tdo(Tprep(this.form.tl{$THISstyleid}[this.form.tl$THISstyleid.selectedIndex], $THISstyleid, 0), 'testedit');\" />		
					<input type=\"button\" class=\"button\" style=\"font-weight: normal\" value=\"$vbphrase[revert]\" id=\"kill$THISstyleid\" onclick=\"Tdo(Tprep(this.form.tl{$THISstyleid}[this.form.tl$THISstyleid.selectedIndex], $THISstyleid, 0), 'killtemplate');\" />
					<div class=\"darkbg\" style=\"margin: 4px; padding: 4px; border: 2px inset; text-align: $stylevar[left]\" id=\"helparea$THISstyleid\">
						" . construct_phrase($vbphrase['click_the_expand_collapse_btn'], $style['title']) . '
					</div>
					<input type="button" class="button" value="' . EXPANDCODE . '" title="' . $vbphrase['expand_all_template_groups'] . "\" onclick=\"Texpand('all', '$expandset');\" />
					<b>$vbphrase[all_products]</b>
					<input type=\"button\" class=\"button\" value=\"" . COLLAPSECODE . '" title="' . $vbphrase['collapse_all_template_groups'] . "\" onclick=\"Texpand('', '$expandset');\" />
				</td>
			</tr>
			</table>
			<br />
			<table cellpadding=\"4\" cellspacing=\"1\" border=\"0\" class=\"tborder\" width=\"300\">
			<tr align=\"center\">
				<td class=\"tcat\"><b>$vbphrase[color_key]</b></td>
			</tr>
			<tr>
				<td class=\"alt2\">
				<div class=\"darkbg\" style=\"margin: 4px; padding: 4px; border: 2px inset; text-align: $stylevar[left]\">
				<span class=\"col-g\">$vbphrase[templateedit_is_unchanged_from_default_style]</span><br />
				<span class=\"col-i\">$vbphrase[templateedit_is_inherited_from_a_parent_style]</span><br />
				<span class=\"col-c\">$vbphrase[templateedit_is_customized_in_this_style]</span>
				</div>
				</td>
			</tr>
			</table>
			<script type=\"text/javascript\">
				Tprep(document.forms.tform.tl$THISstyleid.options[document.forms.tform.tl$THISstyleid.selectedIndex], $THISstyleid, 1);
			</script>";

			echo "\n</td>\n</tr>\n</table>\n";
		echo "<!-- end templateedit list for style '$style[styleid]' -->\n\n";
	}
}

function templateedits_xml_handler($xml)
{
	global $templateedits_xml;
	if (!empty($templateedits_xml))
	{
		$xmloutput = str_replace("\n</product>", "\n$templateedits_xml</product>", $xml);

		header('Content-Length: ' . strlen($xmloutput));
		return $xmloutput;
	}
	else
	{
		return $xml;
	}
}

function construct_templateedit_option($templateedit, $styleid, $doindent = false, $htmlise = false)
{
	global $vbulletin;

	$inactive = '';

	if (!$templateedit['productactive'] OR !$templateedit['editactive'])
	{
		$inactive = 'style="text-decoration: line-through"';

		if (is_browser('ie'))
		{
			// workaround for stupid IE
			$templateedit['title'] = "[X] $templateedit[title]";
		}
	}

	if ($vbulletin->GPC['templateeditid'] == $templateedit['templateeditid'])
	{
		$selected = ' selected="selected"';
	}
	else
	{
		$selected = '';
	}

	if ($htmlise)
	{
		$templateedit['title'] = htmlspecialchars_uni($templateedit['title']);
	}

	if ($styleid == -1)
	{
		return "\t<option $inactive value=\"$templateedit[templateeditid]\" i=\"$templateedit[username];$templateedit[dateline]\"$selected>$indent$templateedit[template]: $templateedit[title]</option>\n";
	}
	else
	{
		switch ($templateedit['styleid'])
		{
			// template is inherited from the master set
			case -1:
			{
				return "\t<option $inactive class=\"col-g\" value=\"~$templateedit[templateeditid]~\" i=\"$templateedit[username];$templateedit[dateline]\"$selected>$indent$templateedit[template]: $templateedit[title]</option>\n";
			}

			// template is customized for this specific style
			case $styleid:
			{
				return "\t<option $inactive class=\"col-c\" value=\"$templateedit[templateeditid]\" i=\"$templateedit[username];$templateedit[dateline]\"$templateedit[templateeditid]\"$selected>$indent$templateedit[template]: $templateedit[title]</option>\n";
			}

			// template is customized in a parent style - (inherited)
			default:
			{
				return "\t<option $inactive class=\"col-i\" value=\"[$templateedit[templateeditid]]\" tsid=\"$templateedit[styleid]\" i=\"$templateedit[username];$templateedit[dateline]\"[$templateedit[templateeditid]]\" tsid=\"$templateedit[styleid]\"$selected>$indent$templateedit[template]: $templateedit[title]</option>\n";
			}
		}
	}

}

function construct_templateedit_link($templateedit, $styleid, $doindent = false, $htmlise = false)
{
	global $LINKEXTRA, $info, $templateid, $vbulletin, $vbphrase;

	if ($doindent)
	{
		$indent = "\t";
	}
	else
	{
		$indent = '';
	}

	if ($styleid == -1)
	{
		// (debug option)
		return "$indent<li class=\"col-g\">$templateedit[title]" .
			construct_link_code($vbphrase['edit'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;templateeditid=$templateedit[templateeditid]&amp;dostyleid=$templateedit[styleid]$LINKEXTRA") .
			construct_link_code($vbphrase['delete'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=delete&amp;templateeditid=$templateedit[templateeditid]&amp;dostyleid=$templateedit[styleid]$LINKEXTRA") .
		"</li>\n";
	}
	else
	{
		switch ($template['styleid'])
		{
			case -1:
				// template is inherited from the master set
				return "$indent<li class=\"col-g\">$template[title]" .
					construct_link_code($vbphrase['customize'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=add&amp;dostyleid=$styleid&amp;templateeditid=$templateedit[templateeditid]$LINKEXTRA") . "</li>\n";
			case $styleid:
				// template is customized for this specific style
				return "$indent<li class=\"col-c\">$template[title]" .
					construct_link_code($vbphrase['edit'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;templateeditid=$templateedit[templateeditid]&amp;dostyleid=$templateedit[styleid]$LINKEXTRA") .
					construct_link_code($vbphrase['revert'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=delete&amp;templateeditid=$templateedit[templateeditid]&amp;dostyleid=$templateedit[styleid]$LINKEXTRA") .
					construct_link_code($vbphrase['view_original'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=view&amp;varname=$templateedit[varname]$LINKEXTRA") .
				"</li>\n";
			default:
				// template is customized in a parent style - (inherited)
				return "$indent<li class=\"col-i\">$template[title]" .
					construct_link_code($vbphrase['customize_further'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=add&amp;dostyleid=$styleid&amp;templateeditid=$templateedit[templateeditid]$LINKEXTRA") .
					construct_link_code($vbphrase['view_original'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=view&amp;title=' . urlencode($template['title']), 1) .
				"</li>\n";
		}
	}

}

function construct_templateedits_xml($productinfo, $embedded = false, $templateedits = null, $styleid = -1)
{
	global $vbulletin;

	require_once(DIR . '/includes/class_xml.php');

	$xml = new XMLexporter($vbulletin);

	if ($embedded)
	{
		$xml->tabs = "\t";
		$xml->add_group('templateedits', array());
	}
	else
	{
		$attributes = array('product' => $productinfo['productid'], 'version' => $productinfo['version']);
		if ($styleid != -1)
		{
			$attributes['custom'] = 1;
		}
		$xml->add_group('templateedits', $attributes);
	}

	if (!$templateedits)
	{
		$templateedits = $vbulletin->db->query_read("
			SELECT
			*
			FROM " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation
			LEFT JOIN " . TABLE_PREFIX . "templateedit AS templateedit ON (templateedit.varname=templateeditlocation.varname AND templateedit.styleid=$styleid)
			WHERE templateeditlocation.product = '$productinfo[productid]'
				AND templateeditlocation.varname != 'tmsbranding'
				AND templateedit.styleid = $styleid
		");
	}

	while ($templateedit = $vbulletin->db->fetch_array($templateedits))
	{
		$xml->add_group('templateedit',
			array(
				'template' => $templateedit['template'],
				'varname' => $templateedit['varname'],
				'username' => $templateedit['username'],
				'version' => $templateedit['version'],
				'dateline' => $templateedit['dateline'],
				'searchorder' => $templateedit['searchorder'],
				'active' => $templateedit['active']
			)
		);
		$xml->add_tag('title', $templateedit['title']);
		$xml->add_tag('searchstr', $templateedit['searchstr']);
		$xml->add_tag('replacestr', $templateedit['replacestr']);
		$xml->close_group();
	}
	$xml->close_group();
	
	return $xml->output();
}
/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile: adminfunctions_templateedits.php,v $ - $Revision: 1.46 $
|| ####################################################################
\*======================================================================*/
?>