<?php
/*==========================================================================*\
|| ######################################################################## ||
|| # Template Modification System 1.1.5
|| # -------------------------------------------------------------------- # ||
|| # Copyright 2007-2008 Andreas 'Kirby' Kirbach. All Rights Reserved. 
|| # This file may not be redistributed in whole or significant part.     # ||
|| # -------------------------------------------------------------------- # ||
|| # http://www.vbulletin.org/forum/misc.php?do=producthelp&pid=tms
|| ######################################################################## ||
\*==========================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
// double output buffering does some weird things, so turn it off
define('CVS_REVISION', '$RCSfile: templateedits.php,v $ - $Revision: 1.59 $');
define('NOZIP', 1);
$vbulletin->nozip = true;

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('style');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/adminfunctions_templateedits.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminstyles'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

$vbulletin->input->clean_gpc('r', 'ajax', TYPE_BOOL);

// ############################# Do not print header if we are exporting ###############################
if ($_REQUEST['do'] != 'export' AND !$vbulletin->GPC['ajax'])
{
	print_cp_header($vbphrase['template_edit_manager']);
	echo('<script type="text/javascript" src="../clientscript/tms_templateeditmgr.js?' . TMSVERSION . '"></script>');
}

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'modify';
}

// ########################################################################
// delete all templateedits for product
if ($_REQUEST['do'] == 'deleteall')
{
	$vbulletin->input->clean_gpc('r', 'productid', TYPE_STR);

	print_form_header('templateedits', 'killall');
	print_table_header($vbphrase['delete_templateedits']);
	print_select_row($vbphrase['product'], 'product', fetch_product_list(), $vbulletin->GPC['productid']);
	print_description_row("
		<blockquote>
		$vbphrase[delete_all_templateedits_for_product]
		</blockquote>
	");
	print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
}

// ########################################################################
// delete all templateedits for product
if ($_POST['do'] == 'killall')
{
	$vbulletin->input->clean_gpc('p', 'product', TYPE_STR);
	uninstall_templateedits($vbulletin->GPC['product']);
	if ($vbulletin->GPC['product'] != 'vbulletin')
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "productcode WHERE productid = '" . $db->escape_string($vbulletin->GPC['product']) . "' AND version = '*' AND installcode LIKE '%install_templateedits(\$info, \$arr, \$active)%'");
	}
	define('CP_REDIRECT', 'templateedits.php');
	print_stop_message('deleted_templateedits_successfully');
}

// ########################################################################
// revert all templateedits in a style
if ($_REQUEST['do'] == 'revertall')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'group' => TYPE_STR,
		'dostyleid' => TYPE_INT
	));

	if ($vbulletin->GPC['dostyleid'] != -1 AND $style = $db->query_first("SELECT styleid, title FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->GPC['dostyleid']))
	{
		// select any templates in this style that are customized from the master style
		$templateedits = $db->query_read("
			SELECT title
			FROM " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation
			INNER JOIN " . TABLE_PREFIX . "templateedit AS templateedit ON(templateedit.varname=templateeditlocation.varname)
			WHERE templateedit.styleid = $style[styleid]
		");
		if ($db->num_rows($templateedits) == 0)
		{
			print_stop_message('nothing_to_do');
		}
		else
		{
			$templateeditlist = '';
			while ($templateedit = $db->fetch_array($templateedits))
			{
				$templateeditlist .= "<li>$templateedit[title]</li>\n";
			}
			$db->free_result($templateedits);

			echo '<br /><br />';

			print_form_header('templateedits', 'dorevertall');
			print_table_header($vbphrase['revert_all_templateedits']);
			print_description_row('
					<blockquote><br />
					' . construct_phrase($vbphrase['revert_all_templateedits_from_style_x'], $style['title'], $templateeditlist) . '
					<br /></blockquote>
				');
			construct_hidden_code('dostyleid', $style['styleid']);
			construct_hidden_code('group', $vbulletin->GPC['group']);
			print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
		}
	}
	else
	{
		print_stop_message('invalid_style_specified');
	}
}

// ########################################################################
// do revert all templateedits in a style
if ($_POST['do'] == 'dorevertall')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'group' => TYPE_STR,
		'dostyleid' => TYPE_INT
	));

	if ($vbulletin->GPC['dostyleid'] != -1 AND $style = $db->query_first("SELECT styleid, title FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->GPC['dostyleid']))
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "templateedit WHERE styleid = " . $vbulletin->GPC['dostyleid']);
		print_build_styleedits($style['styleid'], $style['title'], array(), '', true, true);
		print_cp_redirect('templateedits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modify&amp;group=' . $vbulletin->GPC['group'] . "&amp;expandset=$style[styleid]", 1);
	}
	else
	{
		print_stop_message('invalid_style_specified');
	}
}

// ########################################################################
// test (all) templateedits, this also rebuilts all templateedits after a vBulletin upgrade
if ($_REQUEST['do'] == 'test')
{
	if (is_newer_version($vbulletin->options['templateversion'], $vbulletin->options['tmsoldversion']))
	{
		$db->query_write("REPLACE INTO " . TABLE_PREFIX . "setting (varname, value, product, volatile, grouptitle, datatype) VALUES ('tmsoldversion', '" . $db->escape_string($vbulletin->options['templateversion']) . "', 'vbulletin', 1, 'version', 'free')");
		build_options();
		print_build_styleedits(-1, 'MASTER', array(), '', true, true);
		print_cp_redirect('templateedits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=test', 1);
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'dostyleid' => TYPE_INT,
		'sort' => TYPE_STR,
		'productid' => TYPE_STR,
		'templateeditid' => TYPE_UINT
	));

	$templateeditid =& $vbulletin->GPC['templateeditid'];
	$productid =& $vbulletin->GPC['productid'];

	cache_styles();

	if ($vbulletin->GPC['dostyleid'] == -1)
	{
		$condition = "AND template.styleid = -1";
	}
	else if ($vbulletin->GPC['dostyleid'])
	{
		if ($vbulletin->options['tmsstyletest'] == 1)
		{
			$condition = "AND templateid IN (" . implode(',', array_values(unserialize($stylecache["{$vbulletin->GPC['dostyleid']}"]['templatelist']))) . ")" ;
		}
		else
		{
			$condition = "AND template.styleid = " . $vbulletin->GPC['dostyleid'];
		}
	}
	else if ($vbulletin->GPC['templateeditid'])
	{
		$condition = "AND templateedit.templateeditid = " . $vbulletin->GPC['templateeditid'];
	}
	
	if (!empty($vbulletin->GPC['productid']))
	{
		$condition .= "\nAND templateeditlocation.product = '" . $db->escape_string($vbulletin->GPC['productid']) . "'";
	}
	
	if ($vbulletin->GPC['dostyleid'] AND $vbulletin->GPC['dostyleid'] != -1)
	{
		$dostyleid =& $vbulletin->GPC['dostyleid'];
	}
	
	switch ($vbulletin->GPC['sort'])
	{
		case 'product':
			$order = "IF(templateeditlocation.product='vbulletin', 'vBulletin', product.title) ASC";
			break;
		case 'title':
			$order = "templateeditlocation.title ASC";
			break;
		case 'template':
			$order = "template.title ASC";
			break;
		default:
			$order = "template.title ASC, product.title ASC, templateeditlocation.title ASC";
	}
		
	$stylecache['-1']['title'] = 'MASTER';

	$fieldorder = explode(',', $vbulletin->options['tmsfieldorder']);

	$templateeditsq = $vbulletin->db->query_read("
		SELECT IF(templateedit.product='vbulletin', 1, product.active) AS productactive, templateedit.active AS editactive, templateedit.version AS editversion, template.version AS templateversion, templateeditlocation.product, templateeditid, templateedit.styleid AS tstyleid, template.styleid, template.title AS template, templateeditlocation.title, template.template_un, searchstrregex, IF(templateeditlocation.product='vbulletin', 'vBulletin', product.title) AS product, templateedit.replacestr
		FROM " . TABLE_PREFIX . "templateedit AS templateedit
		INNER JOIN " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation ON (templateeditlocation.varname=templateedit.varname)
		INNER JOIN " . TABLE_PREFIX . "template AS template ON (template.title=templateeditlocation.template)
		LEFT JOIN " . TABLE_PREFIX . "style AS style ON (style.styleid=template.styleid AND FIND_IN_SET(templateedit.templateeditid, style.templateeditlist))
		LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=templateeditlocation.product)
		WHERE (NOT ISNULL(style.styleid) OR (templateedit.styleid = -1 AND template.styleid = -1))
			AND (templateedit.product = 'vbulletin' OR product.active = 1) 
			AND templateedit.active = 1 
			AND templateeditlocation.varname != 'tmsbranding'
			$condition
		ORDER BY style.displayorder ASC, style.styleid ASC, $order
	");

	if ($db->num_rows($templateeditsq) == 0)
	{
		if (!empty($vbulletin->GPC['productid']) AND $product = $db->query_first("SELECT title FROM " . TABLE_PREFIX . "product WHERE productid = '" . $db->escape_string($vbulletin->GPC['productid']) . "'"))
		{
			print_stop_message('product_x_has_no_templateedits', $product['title']);
		}
		else if ($vbulletin->GPC['dostyleid'] AND $style = $db->query_first("SELECT title FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->GPC['dostyleid']))
		{
			print_stop_message('style_x_has_no_templateedits', $style['title']);
		}
		else
		{
			print_stop_message('no_templateedits_found');
		}
	}
	else
	{
		print_table_start();
	}

	while ($templateedit = $vbulletin->db->fetch_array($templateeditsq))
	{
		if ($laststyleid != $templateedit[styleid])
		{
			print_table_break();
			print_table_header($vbphrase['testing_templateedits'] . ": <span class=\"normal\">{$stylecache["$templateedit[styleid]"]['title']}</span>", 4);
			print_cells_row(array(
				'<a href="templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=test&amp;dostyleid=$dostyleid&amp;templateeditid=$templateeditid&amp;productid=$productid&amp;sort=$fieldorder[0]\">" . $vbphrase["$fieldorder[0]"] . '</a>',
				'<a href="templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=test&amp;dostyleid=$dostyleid&amp;templateeditid=$templateeditid&amp;productid=$productid&amp;sort=$fieldorder[1]\">" . $vbphrase["$fieldorder[1]"] . '</a>',
				'<a href="templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=test&amp;dostyleid=$dostyleid&amp;templateeditid=$templateeditid&amp;productid=$productid&amp;sort=$fieldorder[2]\">" . $vbphrase["$fieldorder[2]"] . '</a>',
				$vbphrase['test_result']
			), 1);
			$laststyleid = $templateedit[styleid];
		}

		$cells = array(
			$templateedit["$fieldorder[0]"],
			$templateedit["$fieldorder[1]"],
			$templateedit["$fieldorder[2]"]
		);

		$extra = $yesno1 = $yesno2 = '';

		if (preg_match("/$templateedit[searchstrregex]/siU", $templateedit['template_un']))
		{
			$yesno1 = 'yes';
			$extra = '';
			if ($vbulletin->GPC['templateeditid'])
			{
				$yesno2 = ($tplerror = check_template_errors(compile_template(preg_replace("/$templateedit[searchstrregex]/siU", $templateedit['replacestr'], $templateedit['template_un']))) == '') ? 'yes' : 'no';
			}
			if ($templateedit['styleid'] == $templateedit['tstyleid'] AND is_newer_version($templateedit['templateversion'], $templateedit['editversion']))
			{
				$updatesql .= "WHEN $templateedit[templateeditid] THEN '" . $db->escape_string($templateedit['templateversion']) . "' ";
			}
		}
		else
		{
			$yesno1 = 'no';
			$yesno2 = 'no';
		}
		if ($yesno1 == 'no' OR $yesno2 == 'no')
		{
			if ($templateedit['styleid'] == $templateedit['tstyleid'])
			{
				$extra = construct_link_code($vbphrase['edit'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;templateeditid=$templateedit[templateeditid]");
			}
			else
			{
				$extra = construct_link_code($vbphrase['edit'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=add&amp;templateeditid=$templateedit[templateeditid]&amp;dostyleid=$templateedit[styleid]");
			}
		}
		else
		{
			$extra = '';
		}
		$cells[] = '<img src="../cpstyles/' . $vbulletin->options['cpstylefolder'] . "/cp_tick_$yesno1.gif\" title=\"$vbphrase[searchstr_found]\" alt=\"$vbphrase[searchstr_found]\" />" . (($vbulletin->GPC['templateeditid']) ?  ' / <img src="../cpstyles/' . $vbulletin->options['cpstylefolder'] . "/cp_tick_$yesno2.gif\" title=\"$vbphrase[no_template_errors]\" alt=\"$vbphrase[no_template_errors]\" />" : '') . $extra;
		print_cells_row($cells);
	}
	$vbulletin->db->free_result($templateeditsq);
	print_table_footer();

	// are there any templatedits that carry an older templateversion but do still work?
	// if so, update them wit hcurrent templateversion
	if (!empty($updatesql))
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "templateedit SET version = CASE templateeditid $updatesql ELSE version END");
	}
}

// ########################################################################
// lets the user see the original templateedit
if ($_REQUEST['do'] == 'view')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'templateeditid' => TYPE_UINT
	));

	$templateedit = $db->query_first("
		SELECT searchstr, replacestr, title
		FROM " . TABLE_PREFIX . "templateedit AS templateedit
		LEFT JOIN " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation ON (templateeditlocation.varname=templateedit.varname)
		WHERE styleid = -1 AND templateedit.varname = (SELECT varname FROM " . TABLE_PREFIX . "templateedit WHERE templateeditid = " . $vbulletin->GPC['templateeditid'] . ")
	");

	print_form_header('', '');
	print_table_header(construct_phrase($vbphrase['show_default_templateedit_x'], $templateedit['title']));
	print_textarea_row($vbphrase['search_string'], '--[-ORIGINAL-TEMPLATEEDIT-SEARCH]--', $templateedit['searchstr'], 20, 80, true, true, 'ltr', 'code');
	print_textarea_row($vbphrase['replace_string'], '--[-ORIGINAL-TEMPLATEEDIT-SEARCH]--', $templateedit['replacestr'], 20, 80, true, true, 'ltr', 'code');
	print_table_footer();
}

// ########################################################################
// lets the user view a template with all modifications (chooser)
if ($_REQUEST['do'] == 'viewmodifiedtemplate')
{
	print_form_header('templateedits', 'doviewmodifiedtemplate', false, true, 'tmsform');
	print_table_header($vbphrase['view_modified_template']);
	print_style_chooser_row('styleid', '-1', 'MASTER', $vbphrase['style'], 1);
	print_select_row($vbphrase['template'], 'template', fetch_template_list(true));
	print_yes_no_row($vbphrase['show_comments'], 'showcomments');
	print_ajax_submit_row($vbphrase['view'], '', 2, '', '', false, true, 'tmstemplate.fetch_modified_template');
	echo('<script src="../clientscript/vbulletin_templatemgr.js" type="text/javascript"></script><script src="../clientscript/tms_ajax.js?' . TMSVERSION . '" type="text/javascript"></script><script type="text/javascript">var tmstemplate = new TMS_AJAX_TemplateFetch();textarea_id = \'tms_templatetext\';</script>');
	echo('<div id="tmstemplate"></div>');
}

// ########################################################################
// lets the user view a template with all modifications
if ($_REQUEST['do'] == 'doviewmodifiedtemplate')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'template' => TYPE_STR,
		'styleid' => TYPE_INT,
		'showcomments' => TYPE_BOOL
	));
	
	if (!$template = $db->query_first("SELECT templateid, title, template_un FROM " . TABLE_PREFIX . "template WHERE styleid = " . $vbulletin->GPC['styleid'] . " AND templatetype = 'template' AND title = '" . $db->escape_string($vbulletin->GPC['template']) . "'"))
	{
		if ($vbulletin->GPC['ajax'])
		{
			define('DONE_CPHEADER', 1);
			require_once(DIR . '/includes/functions_misc.php');
			$text = fetch_phrase('invalid_template_specified', 'error', '', false);
			print_form_header('', '', 0, 1, 'messageform', '65%');
			print_table_header($vbphrase['vbulletin_message']);
			print_description_row("<blockquote><br />$text<br /><br /></blockquote>");
			print_table_footer(2);
			if (defined('NOSHUTDOWNFUNC'))
			{
				exec_shut_down();
			}
			exit;			
		}
		else
		{
			print_stop_message('invalid_template_specified');
		}
	}

	echo('<script src="../clientscript/vbulletin_templatemgr.js" type="text/javascript"></script>');
	echo('<script type="text/javascript">textarea_id = \'tms_templatetext\';</script>');
	print_form_header('', '');
	print_table_header(construct_phrase($vbphrase['modified_template_x'], $template['title']));
	if ($vbulletin->GPC['showcomments'])
	{
		print_description_row($vbphrase['modifications_marked_with_comments']);
		print_description_row(fetch_modified_template($template, $vbulletin->GPC['showcomments']));
	}
	else
	{
		print_template_row(fetch_modified_template($template, $vbulletin->GPC['showcomments']), 20, 80, true, true, 'ltr', 'code');
		print_label_row(iif(is_browser('ie') OR is_browser('mozilla', '20040707'), $vbphrase['search_in_template'], $vbphrase['additional_functions']), iif(is_browser('ie') OR is_browser('mozilla', '1.7'), '
		<input type="text" class="bginput" name="string" accesskey="t" value="' . htmlspecialchars_uni($vbulletin->GPC['searchstring']) . '" size="20" onChange="n=0;" tabindex="1" />
		<input type="button" class="button" style="font-weight:normal" value=" ' . $vbphrase['find'] . ' " accesskey="f" onClick="findInPage(document.cpform.string.value);" tabindex="1" />
		&nbsp;'));
	}
	print_table_footer();
}

// ########################################################################
// lets the user see the template for the current templateedit
if ($_REQUEST['do'] == 'viewtemplate')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'styleid' => TYPE_INT,
		'title' => TYPE_STR
	));

	$template = $db->query_first("
		SELECT templateid, styleid, title, template_un
		FROM " . TABLE_PREFIX . "template
		WHERE styleid = " . $vbulletin->GPC['styleid'] . " AND title = '" . $db->escape_string($vbulletin->GPC['title']) . "'
	");

	print_form_header('', '');
	print_table_header(construct_phrase($vbphrase['template_x'], $template['title']));
	print_template_row($template['template_un'], 20, 80, true, true, 'ltr', 'code');

	print_label_row(iif(is_browser('ie') OR is_browser('mozilla', '20040707'), $vbphrase['search_in_template'], $vbphrase['additional_functions']), iif(is_browser('ie') OR is_browser('mozilla', '1.7'), '
	<input type="text" class="bginput" name="string" accesskey="t" value="' . htmlspecialchars_uni($vbulletin->GPC['searchstring']) . '" size="20" onChange="n=0;" tabindex="1" />
	<input type="button" class="button" style="font-weight:normal" value=" ' . $vbphrase['find'] . ' " accesskey="f" onClick="findInPage(document.cpform.string.value);" tabindex="1" />
	&nbsp;'));

	print_ajax_submit_row('', $vbphrase['close'], 2, '', '', false, false, '', 'tmstemplate.abort');
}

// ########################################################################
// modify a templateedit
if ($_REQUEST['do'] == 'edit')
{
	$vbulletin->input->clean_array_gpc('r',  array(
		'templateeditid' => TYPE_INT,
		'product' => TYPE_STR
	));

	$templateedit = $db->query_first("
			  SELECT templateedit.*, templateeditlocation.*
			  FROM " . TABLE_PREFIX . "templateedit AS templateedit
			  LEFT JOIN " . TABLE_PREFIX . "style AS style ON (style.styleid=templateedit.styleid)
			  LEFT JOIN " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation ON (templateeditlocation.varname=templateedit.varname)
			  WHERE templateedit.templateeditid=" . $vbulletin->GPC['templateeditid'] . "
	");

	if (!$templateedit)
	{
		print_stop_message('templateedit_not_found');
	}
	
	if ($vbulletin->GPC['ajax'])
	{
		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('tms');
		ob_start();
	}
	else
	{
		$extra = '<script src="../clientscript/vbulletin_templatemgr.js" type="text/javascript"></script><script src="../clientscript/tms_ajax.js?' . TMSVERSION . "\" type=\"text/javascript\"></script><script type=\"text/javascript\">var tmstemplate = new TMS_AJAX_TemplateFetch();textarea_id = 'tms_templatetext';</script><div class=\"smallfont\"><br />[<a href=\"#\" style=\"font-weight: normal;\" onclick=\"return tmstemplate.fetch_template();\">$vbphrase[view_template]</a>]</div>";
	}
	
	print_form_header('templateedits', 'update', false, true, 'tmsform');
	print_table_header(construct_phrase($vbphrase['modify_templateedit_x'], $templateedit['title']));

	if (!$vbulletin->GPC['ajax'] AND $templateedit['styleid'] == $templateedit['addstyleid'])
	{
		print_select_row($vbphrase['product'], 'product', fetch_product_list(), $templateedit['product']);
		print_select_row($vbphrase['template'], 'template', fetch_template_list(false, $templateedit['styleid']), $templateedit['template']);
		print_input_row($vbphrase['title'], 'title', $templateedit['title'], false);
		print_input_row($vbphrase['varname'], 'varname', $templateedit['varname'], true, 25);
	}
	else
	{
		construct_hidden_code('varname', $templateedit['varname']);
		construct_hidden_code('template', $templateedit['template']);
		construct_hidden_code('product', $templateedit['product']);
		construct_hidden_code('title', $templateedit['title']);
	}

	construct_hidden_code('templateeditlocationid', $templateedit['templateeditlocationid']);
	construct_hidden_code('oldvarname', $templateedit['varname']);
	construct_hidden_code('oldtemplate', $templateedit['template']);
	construct_hidden_code('oldproduct', $templateedit['product']);
	construct_hidden_code('ismaster', $templateedit['styleid'] == $templateedit['addstyleid']);
	
	print_yes_no_row($vbphrase['active'], 'active', $templateedit['active']);
	print_input_row($vbphrase['search_order'], 'searchorder', $templateedit['searchorder'], true, 5);
	print_textarea_row($vbphrase['search_for_text'] . $extra . (($vbulletin->GPC['ajax']) ? "<br /><a class=\"smallfont\" href=\"#template\" onclick=\"findInPage(document.tmsform.searchstr.value); return false;\">$vbphrase[search_text_in_template]</a>" :''), 'searchstr', $templateedit['searchstr'], 5, 60);
	if (preg_match('#^' . preg_quote($templateedit['searchstr'], '#') . '(\r\n|\r|\n)(.*)#si', $templateedit['replacestr'], $matches))
	{
		$selected['below'] = 'selected="selected"';
		$templateedit['replacestr'] = $matches[2];
	}
	else if (preg_match('#(.*)(\r\n|\r|\n)' . preg_quote($templateedit['searchstr'], '#') . '$#si', $templateedit['replacestr'], $matches))
	{
		$selected['above'] = 'selected="selected"';
		$templateedit['replacestr'] = $matches[1];
	}
	else if (trim($templateedit['replacestr']) == '')
	{
		$selected['delete'] = 'selected="selected"';
	}
	else
	{
		$selected['replace'] = 'selected="selected"';
	}
	print_textarea_row("<div style=\"margin-bottom:3px\">$vbphrase[processing_mode]</div><select class=\"bginput\" id=\"sel_method\" name=\"method\"><option value=\"\"></option><option value=\"delete\" $selected[delete]>$vbphrase[delete_searchtext]</option><option value=\"replace\" $selected[replace]>$vbphrase[replace_with_text]</option><option value=\"insertabove\" $selected[above]>$vbphrase[insert_text_above]</option><option value=\"insertbelow\" $selected[below]>$vbphrase[insert_text_below]</option></select>", 'replacestr', $templateedit['replacestr'], 5, 60);
	construct_hidden_code('templateeditid', $templateedit['templateeditid']);
	construct_hidden_code('styleid', $templateedit['styleid']);

	if ($vbulletin->GPC['ajax'])
	{
		print_ajax_submit_row($vbphrase['save'], $vbphrase['cancel'], 2, '', '', false, true, 'tmseditor.save', 'tmseditor.abort');
		$html = ob_get_contents();
		ob_end_clean();
		$xml->add_tag('templateedit', $html);
		$xml->close_group();
		$xml->print_xml();
	}
	else
	{
		print_submit_row();
		echo('<div id="tmstemplate"></div>');
	}
}

// ########################################################################
// update a modified templateedit
if ($_REQUEST['do'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'searchorder' => TYPE_UINT,
		'searchstr' => TYPE_NOTRIM,
		'replacestr' => TYPE_NOTRIM,
		'styleid' => TYPE_INT,
		'oldtemplate' => TYPE_STR,
		'template' => TYPE_STR,
		'title' => TYPE_NOHTML,
		'oldproduct' => TYPE_STR,
		'product' => TYPE_STR,
		'varname' => TYPE_STR,
		'oldvarname' => TYPE_STR,
		'templateeditid' => TYPE_INT,
		'templateeditlocationid' => TYPE_INT,
		'method' => TYPE_STR,
		'active' => TYPE_BOOL,
		'ismaster' => TYPE_NOOL
	));

	if (!$vbulletin->GPC['ajax'] AND $vbulletin->GPC['ismaster'])
	{
		if (empty($vbulletin->GPC['title']))
		{
			print_stop_message('invalid_title_specified');
		}
	
		if (!preg_match('#^[a-z0-9_]+$#s', $vbulletin->GPC['varname']) OR strlen($vbulletin->GPC['varname']) > 25)
		{
			$sugg = preg_replace('#\s+#s', '_', strtolower($vbulletin->GPC['varname']));
			$sugg = preg_replace('#[^\w]#s', '', $sugg);
			$sugg = str_replace('__', '_', $sugg);
			$sugg = substr($sugg, 0, 25);
			print_stop_message('templateedit_varname_invalid', htmlspecialchars_uni($vbulletin->GPC['varname']), $sugg);
		}
	}
	
	if (!$vbulletin->GPC['ajax'] AND $vbulletin->GPC['ismaster'] AND $vbulletin->GPC['varname'] != $vbulletin->GPC['oldvarname'] AND $test = $db->query_first("SELECT templateeditlocationid FROM " . TABLE_PREFIX . "templateeditlocation WHERE varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "'"))
	{
		print_stop_message('templateedit_variable_name_exists', $vbulletin->GPC['varname']);
	}

	switch ($vbulletin->GPC['method'])
	{
		case 'insertabove':
			$vbulletin->GPC['replacestr'] .= "\n" . $vbulletin->GPC['searchstr'];
			break;
		case 'insertbelow':
			$vbulletin->GPC['replacestr'] = $vbulletin->GPC['searchstr'] . "\n" . $vbulletin->GPC['replacestr'];
			break;
		case 'delete':
			$vbulletin->GPC['replacestr'] = '';
			break;
		case 'replace':
			break;
		default:
			print_stop_message('please_select_replacement_mode');
	}	

	if ($vbulletin->GPC['ajax'])
	{
		$vbulletin->GPC['title'] = convert_urlencoded_unicode($vbulletin->GPC['title']);
		$vbulletin->GPC['searchstr'] = convert_urlencoded_unicode($vbulletin->GPC['searchstr']);
		$vbulletin->GPC['replacestr'] = convert_urlencoded_unicode($vbulletin->GPC['replacestr']);
	}
	
	if (!$vbulletin->GPC['ajax'] AND $vbulletin->GPC['ismaster'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "templateeditlocation
			SET
				varname='" . $db->escape_string($vbulletin->GPC['varname']) . "',
				title='" . $db->escape_string($vbulletin->GPC['title']) . "',
				template='" . $db->escape_string($vbulletin->GPC['template']) . "',
				product='" . $db->escape_string($vbulletin->GPC['product']) . "'
			WHERE templateeditlocationid=" . $vbulletin->GPC['templateeditlocationid'] . "
		");
		if ($vbulletin->GPC['varname'] != $vbulletin->GPC['oldvarname'])
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "templateedit SET varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "' WHERE varname = '" . $db->escape_string($vbulletin->GPC['oldvarname']) . "'");		
		}
	}

	$template = $db->query_first("SELECT version FROM " . TABLE_PREFIX . "template WHERE styleid=" . $vbulletin->GPC['styleid'] . " AND title = '" . $db->escape_string($vbulletin->GPC['template']) . "'");
	
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "templateedit
		SET
			" . iif (!$vbulletin->GPC['ajax'] AND $vbulletin->GPC['ismaster'], "
			product = '" . $db->escape_string($vbulletin->GPC['product']) . "',
			styleid = " . $vbulletin->GPC['styleid'] . ",
			varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "',") . "
			active = " . $vbulletin->GPC['active'] . ",			
			searchorder = " . $vbulletin->GPC['searchorder'] . ",			
			searchstr = '" . $db->escape_string($vbulletin->GPC['searchstr']) . "',
			searchstrregex = '" . $db->escape_string(construct_searchstr_regex($vbulletin->GPC['searchstr'])) . "',
			replacestr = '" . $db->escape_string($vbulletin->GPC['replacestr']) . "',
			username = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
			dateline = " . TIMENOW . ",
			version = '" . $db->escape_string($template['version']) . "'
		WHERE templateeditid=" . $vbulletin->GPC['templateeditid'] . "
	");

	check_tms_codes($vbulletin->GPC['product'], true);
	if ($vbulletin->GPC['ismaster'] AND $vbulletin->GPC['product'] != $vbulletin->GPC['oldproduct'])
	{
		check_tms_codes($vbulletin->GPC['oldproduct']);
	}

	if ($vbulletin->GPC['ismaster'] AND $vbulletin->GPC['oldtemplate'] != $vbulletin->GPC['template'])
	{
		$templates = array($vbulletin->GPC['template'], $vbulletin->GPC['oldtemplate']);
	}
	else
	{
		$templates = array($vbulletin->GPC['template']);
	}

	rebuild_template_edits('', $templates);

	if ($vbulletin->GPC['ajax'])
	{
		$templateedits = get_template_edits(0, '', $vbulletin->GPC['template'], $vbulletin->GPC['styleid']);
		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('tms');
		$xml->add_tag('templateedits', $templateedits);
		$xml->close_group();
		$xml->print_xml();
	}
	
	$_REQUEST['group'] = $vbulletin->GPC['product'];
	$_REQUEST['expandset'] = $vbulletin->GPC['styleid'];
	$_REQUEST['do'] = 'modify';
}

// ########################################################################
// add a new templateedit, this is also used to customize templatedits
if ($_REQUEST['do'] == 'add')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'dostyleid' => TYPE_INT,
		'templateeditid' => TYPE_UINT
	));


	if ($vbulletin->GPC['ajax'])
	{
		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		ob_start();
	}

	if ($vbulletin->GPC['templateeditid'])
	{
		$templateedit = $db->query_first("
			SELECT templateedit.*, templateeditlocation.*, NOT ISNULL(template.title) AS templateexists
			FROM " . TABLE_PREFIX . "templateedit AS templateedit
			LEFT JOIN " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation ON (templateeditlocation.varname=templateedit.varname)
			LEFT JOIN " . TABLE_PREFIX . "template AS template ON (template.title=templateeditlocation.template AND template.styleid = " . $vbulletin->GPC['dostyleid'] . ")
			WHERE templateeditid = " . $vbulletin->GPC['templateeditid'] . "
		");
		if (!$templateedit)
		{
			print_stop_message('invalidid', $vbprase['template_modification']);
		}
		else
		{
			if (!$templateedit['templateexists'])
			{
				if ($vbulletin->GPC['ajax'])
				{
					require_once(DIR . '/includes/functions_misc.php');
					$xml->add_group('errors');
					$xml->add_tag('error', fetch_phrase('template_not_customized', 'error'));
					$xml->close_group();
					$xml->print_xml();
				}
				else
				{
					print_stop_message('cannot_customize_templateedit_x', $templateedit['title'], $templateedit['template'], $vbulletin->session->vars['sessionurl'], $vbulletin->GPC['dostyleid']);
				}
			}
		}
	}

	if ($vbulletin->GPC['ajax'])
	{
		$xml->add_group('tms');
	}
	
	print_form_header('templateedits', 'insert', false, true, 'tmsform');
	if (!$templateedit)
	{	
		$templateedit = array('searchorder' => 5, 'searchstr' => '', 'replacestr' => '');
		
		$templates = fetch_template_list(false, $vbulletin->GPC['dostyleid']);
		
		if (empty($templates))
		{
			$style = $db->query_first("SELECT title FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->GPC['dostyleid']);
			print_stop_message('no_customized_templates_found_in_style_x', $style['title']);
		}
		
		print_table_header($vbphrase['add_templateedit']);
		print_select_row($vbphrase['product'], 'product', fetch_product_list());
		print_select_row($vbphrase['template'], 'template', $templates);
		construct_hidden_code('styleid', $vbulletin->GPC['dostyleid']);
		construct_hidden_code('ismaster', 1);
		print_input_row($vbphrase['title'], 'title');
		print_input_row($vbphrase['varname'], 'varname', '', true, 25);
	}
	else
	{
		print_table_header(construct_phrase($vbphrase['customize_templateedit_x'], $templateedit['title']));
		construct_hidden_code('styleid', $vbulletin->GPC['dostyleid']);
		construct_hidden_code('product', $templateedit['product']);
		construct_hidden_code('template', $templateedit['template']);
		construct_hidden_code('title', $templateedit['title']);
		construct_hidden_code('varname', $templateedit['varname']);

		if (preg_match('#^' . preg_quote($templateedit['searchstr'], '#') . '(\r\n|\r|\n)(.*)#si', $templateedit['replacestr'], $matches))
		{
			$selected['below'] = 'selected="selected"';
			$templateedit['replacestr'] = $matches[2];
		}
		else if (preg_match('#(.*)(\r\n|\r|\n)' . preg_quote($templateedit['searchstr'], '#') . '$#si', $templateedit['replacestr'], $matches))
		{
			$selected['above'] = 'selected="selected"';
			$templateedit['replacestr'] = $matches[1];
		}
		else if (trim($templateedit['replacestr']) == '')
		{
			$selected['delete'] = 'selected="selected"';
		}
		else
		{
			$selected['replace'] = 'selected="selected"';
		}
	}

	if (!$vbulletin->GPC['ajax'])
	{
		$extra = '<script src="../clientscript/vbulletin_templatemgr.js" type="text/javascript"></script><script src="../clientscript/tms_ajax.js?' . TMSVERSION . "\" type=\"text/javascript\"></script><script type=\"text/javascript\">var tmstemplate = new TMS_AJAX_TemplateFetch();textarea_id = 'tms_templatetext';</script><div class=\"smallfont\"><br />[<a href=\"#\" style=\"font-weight: normal;\" onclick=\"return tmstemplate.fetch_template();\">$vbphrase[view_template]</a>]</div>";
	}

	print_yes_no_row($vbphrase['active'], 'active', ((!$templateedit['templateeditid']) ? true : $templateedit['active']));
	print_input_row($vbphrase['search_order'], 'searchorder', $templateedit['searchorder'], true, 5);
	print_textarea_row($vbphrase['search_for_text'] . $extra, 'searchstr', $templateedit['searchstr'], 5, 60);

	print_textarea_row("<div style=\"margin-bottom:3px\">$vbphrase[processing_mode]</div><select class=\"bginput\" id=\"sel_method\" name=\"method\"><option value=\"\"></option><option value=\"delete\" $selected[delete]>$vbphrase[delete_searchtext]</option><option value=\"replace\" $selected[replace]>$vbphrase[replace_with_text]</option><option value=\"insertabove\" $selected[above]>$vbphrase[insert_text_above]</option><option value=\"insertbelow\" $selected[below]>$vbphrase[insert_text_below]</option></select>", 'replacestr', $templateedit['replacestr'], 5, 60);

	if ($vbulletin->GPC['ajax'])
	{
		print_ajax_submit_row($vbphrase['save'], $vbphrase['cancel'], 2, '', '', false, true, 'tmseditor.save', 'tmseditor.abort');
		$html = ob_get_contents();
		ob_end_clean();
		$xml->add_tag('templateedit', $html);
		$xml->close_group();
		$xml->print_xml();
	}
	else
	{
		print_submit_row();
		echo('<div id="tmstemplate"></div>');
	}
}

// ########################################################################
// save a new templateedit
if ($_POST['do'] == 'insert')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'searchstr' => TYPE_NOTRIM,
		'replacestr' => TYPE_NOTRIM,
		'styleid' => TYPE_INT,
		'template' => TYPE_STR,
		'title' => TYPE_NOHTML,
		'product' => TYPE_STR,
		'varname' => TYPE_STR,
		'searchorder' => TYPE_UINT,
		'method' => TYPE_STR,
		'active' => TYPE_BOOL,
		'ismaster' => TYPE_BOOL
	));

	if (empty($vbulletin->GPC['title']))
	{
		print_stop_message('invalid_title_specified');
	}

	if (!preg_match('#^[a-z0-9_]+$#s', $vbulletin->GPC['varname']) OR strlen($vbulletin->GPC['varname']) > 25)
	{
		$sugg = preg_replace('#\s+#s', '_', strtolower($vbulletin->GPC['varname']));
		$sugg = preg_replace('#[^\w]#s', '', $sugg);
		$sugg = str_replace('__', '_', $sugg);
		$sugg = substr($sugg, 0, 25);
		print_stop_message('templateedit_varname_invalid', htmlspecialchars_uni($vbulletin->GPC['varname']), $sugg);
	}

	if ($test = $db->query_first("SELECT templateeditid FROM " . TABLE_PREFIX . "templateedit WHERE varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "' AND styleid = " . $vbulletin->GPC['styleid']))
	{
		print_stop_message('templateedit_variable_name_exists', $vbulletin->GPC['varname']);
	}

	if (!$template = $db->query_first("SELECT templateid FROM " . TABLE_PREFIX . "template WHERE title = '" . $db->escape_string($vbulletin->GPC['template']) . "' AND templatetype = 'template' AND styleid = " . $vbulletin->GPC['styleid'])  AND $style = $db->query_first("SELECT title FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->GPC['styleid']))
	{
		print_stop_message('template_x_not_found_in_style_y', $vbulletin->GPC['template'], $style['title']);		
	}

	switch ($vbulletin->GPC['method'])
	{
		case 'insertabove':
			$vbulletin->GPC['replacestr'] .= "\n" . $vbulletin->GPC['searchstr'];
			break;
		case 'insertbelow':
			$vbulletin->GPC['replacestr'] = $vbulletin->GPC['searchstr'] . "\n" . $vbulletin->GPC['replacestr'];
			break;
		case 'delete':
			$vbulletin->GPC['replacestr'] = '';
			break;
		case 'replace':
			break;
		default:
			print_stop_message('please_select_replacement_mode');
	}
	
	if ($vbulletin->GPC['ismaster'])
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "templateeditlocation
			(varname, title, template, product, addstyleid)
			VALUES
			(
				'" . $db->escape_string($vbulletin->GPC['varname']) . "',
				'" . $db->escape_string($vbulletin->GPC['title']) . "',
				'" . $db->escape_string($vbulletin->GPC['template']) . "',
				'" . $db->escape_string($vbulletin->GPC['product']) . "',
				" . $vbulletin->GPC['styleid'] . "
			)
		");
		
		// check if we have appropriate install/uninstall-codes
		check_tms_codes($vbulletin->GPC['product'], true);
	}

	$template = $db->query_first("SELECT version FROM " . TABLE_PREFIX . "template WHERE styleid=" . $vbulletin->GPC['styleid'] . " AND title = '" . $db->escape_string($vbulletin->GPC['template']) . "'");

	$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "templateedit
			(styleid, varname, searchorder, active, searchstr, searchstrregex, replacestr, product, username, dateline, version)
			VALUES
			(
				" . $vbulletin->GPC['styleid'] . ",
				'" . $db->escape_string($vbulletin->GPC['varname']) . "',
				" . $vbulletin->GPC['searchorder'] . ",
				" . $vbulletin->GPC['active'] . ",
				'" . $db->escape_string($vbulletin->GPC['searchstr']) . "',
				'" . $db->escape_string(construct_searchstr_regex($vbulletin->GPC['searchstr'])) . "',
				'" . $db->escape_string($vbulletin->GPC['replacestr']) . "',
				'" . $db->escape_string($vbulletin->GPC['product']) . "',
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				" . TIMENOW . ",
				'" . $db->escape_string($template['version']) . "'
			)
	");

	cache_styles();

	if ($vbulletin->GPC['ajax'])
	{
		build_templateedit_id_cache($vbulletin->GPC['styleid']);
		rebuild_template_edits($vbulletin->GPC['styleid'], array($vbulletin->GPC['template']));
		$templateedits = get_template_edits(0, '', $vbulletin->GPC['template'], $vbulletin->GPC['styleid']);
		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('tms');
		$xml->add_tag('templateedits', $templateedits);
		$xml->close_group();
		$xml->print_xml();
	}
	else
	{
		print_build_styleedits($vbulletin->GPC['styleid'], ($vbulletin->GPC['styleid'] == -1 ? 'MASTER' : $stylecache["{$vbulletin->GPC['styleid']}"]['title']), array($vbulletin->GPC['template']), '', true, true);
		print_cp_redirect('templateedits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modify&amp;expandset=' . $vbulletin->GPC['styleid'] . '&amp;group=' . $vbulletin->GPC['product'], 1);
	}
}

// ########################################################################
// confirmation for templateedit deletion
if ($_REQUEST['do'] == 'delete')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'group' => TYPE_STR,
		'templateeditid' => TYPE_UINT
	));

	$templateedit = $db->query_first("
		SELECT
		*
		FROM " . TABLE_PREFIX . "templateedit AS templateedit
		LEFT JOIN " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation ON (templateeditlocation.varname=templateedit.varname)
		WHERE templateedit.templateeditid = " . $vbulletin->GPC['templateeditid']
	);
		
	echo '<p>&nbsp;</p><p>&nbsp;</p>';
	print_form_header('templateedits', 'kill', 0, 1, '', '75%');
	construct_hidden_code('templateeditid', $templateedit['templateeditid']);
	construct_hidden_code('group', $vbulletin->GPC['group']);
	print_table_header(construct_phrase($vbphrase['confirm_deletion_x'], $templateedit['title']));
	print_description_row('
		<blockquote><br />
		' . construct_phrase($vbphrase['are_you_sure_want_to_revert_templateedit_x'], $templateedit['title'], 'templateeditlid', $templateedit['templateeditid'], '') . "
		<br /></blockquote>\n\t");
	print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
}

// ########################################################################
// kill a templateedit, rebuild id caches and templateedits for dependent styles
if ($_POST['do'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'group' => TYPE_STR,
		'templateeditid' => TYPE_UINT
	));

	$templateedit = $db->query_first("
		SELECT
		*
		FROM " . TABLE_PREFIX . "templateedit AS templateedit
		LEFT JOIN " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation ON (templateeditlocation.varname=templateedit.varname)
		WHERE templateedit.templateeditid = " . $vbulletin->GPC['templateeditid']
	);
	
	if (!$templateedit)
	{
		print_stop_message('invalid_templateedit_specified');
	}
	
	if ($templateedit['styleid'] == $templateedit['addstyleid'])
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "templateedit WHERE varname = '" . $db->escape_string($templateedit['varname']) . "'");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "templateeditlocation WHERE varname = '" . $db->escape_string($templateedit['varname']) . "'");
		check_tms_codes($templateedit['product']);
	}
	else
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "templateedit WHERE templateeditid = $templateedit[templateeditid]");
	}

	cache_styles();
	
	print_build_styleedits($templateedit['styleid'], ($templateedit['styleid'] == -1) ? 'MASTER' : $stylecache["$templateedit[styleid]"]['title'], array($templateedit['template']), '', true, true);
	print_cp_redirect('templateedits.php?' . $vbulletin->session->vars['sessionurl'] . "do=modify&amp;expandset=$templateedit[styleid]&amp;group=" . $vbulletin->GPC['group'], 1);
}

// ########################################################################
// import XML file with templateedits
if ($_POST['do'] == 'import')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'filename'   => TYPE_STR,
		'allowoverwrite' => TYPE_BOOL,
		'ignoreversion' => TYPE_BOOL,
		'styleid' => TYPE_INT
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'templateeditsfile' => TYPE_FILE
	));

	if (file_exists($vbulletin->GPC['templateeditsfile']['tmp_name']))
	{
		// got an uploaded file?
		$xml = file_read($vbulletin->GPC['templateeditsfile']['tmp_name']);
	}
	else if (file_exists($vbulletin->GPC['filename']))
	{
		// no uploaded file - got a local file?
		$xml = file_read($vbulletin->GPC['filename']);
	}
	else
	{
		print_stop_message('no_file_uploaded_and_no_local_file_found');
	}

	print_dots_start($vbphrase['importing_templateedits_please_wait'], ':', 'dspan');

	require_once(DIR . '/includes/class_xml.php');

	$xmlobj = new XMLParser($xml);
	if ($xmlobj->error_no == 1)
	{
			print_dots_stop();
			print_stop_message('no_xml_and_no_path');
	}

	if (!$arr = $xmlobj->parse())
	{
		print_dots_stop();
		print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
	}
	
	if (empty($arr['templateedit']))
	{
		print_stop_message('invalid_file_specified');
	}
	
	if ($arr['custom'] AND $vbulletin->GPC['styleid'] < 1)
	{
		print_dots_stop();
		print_stop_message('templateedits_xml_is_not_master');
	}
	
	// check if product is valid
	if ($arr['product'] != 'vbulletin')
	{
		$product = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "product
			WHERE productid = '" . $db->escape_string($arr['product']) . "'
		");
	}
	else
	{
		$product = array('productid' => 'vbulletin', 'version' => $vbulletin->options['templateversion'], 'title' => 'vBulletin');
	}

	if (!$product)
	{
		print_dots_stop();
		print_stop_message('specified_product_not_found', $arr['product']);
	}

	// check if productversion is correct
	if ($product['version'] != $arr['version'] AND !$vbulletin->GPC['ignoreversion'])
	{
		print_dots_stop();
		print_stop_message('templateedits_wrong_productversion_installed', $product['title'], $product['version'], $arr['version']);
	}

	// check if we have existing edits
	$existcheck = $db->query_first("SELECT templateeditlocationid FROM " . TABLE_PREFIX . "templateeditlocation WHERE product = '" . $db->escape_string($product['productid']) . "' AND varname != 'tmsbranding'");
	if ($existcheck AND !$vbulletin->GPC['allowoverwrite'])
	{
		print_dots_stop();
		print_stop_message('templateedits_x_installed_no_overwrite', $product['title']);
	}
	$arr = array('templateedits' => $arr);

	// check if we have appropriate install/uninstall-codes
	check_tms_codes($product['productid'], true);
	install_templateedits($product, $arr, $product['active'], $vbulletin->GPC['styleid']);

	define('CP_REDIRECT', 'templateedits.php');
	print_dots_stop();
	print_stop_message('templateedits_x_imported', $product['title']);
}

// ########################################################################
// export templateedits as XML or instructions as a textfile
if ($_REQUEST['do'] == 'export')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'product'    => TYPE_STR,
		'filename'   => TYPE_STR,
		'fileformat' => TYPE_STR,
		'languageid' => TYPE_UINT,
		'styleid'    => TYPE_INT
	));
			
	
	if ($vbulletin->GPC['product'] != 'vbulletin')
	{
		$productinfo = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "product WHERE productid = '" . $db->escape_string($vbulletin->GPC['product']) . "'");
	}
	else
	{
		$productinfo = array('productid' => 'vbulletin', 'version' => $vbulletin->options['templateversion'], 'title' => 'vBulletin');
	}

	if (!$productinfo)
	{
		print_stop_message('invalid_product_specified');
	}

	$doc = construct_templateedits($productinfo, $vbulletin->GPC['fileformat'], $vbulletin->GPC['languageid'], true, $vbulletin->GPC['styleid']);
		
	require_once(DIR . '/includes/functions_file.php');
	file_download($doc, $vbulletin->GPC['filename'], 'text/' . (($vbulletin->GPC['fileformat'] == 'txt') ? 'plain' : 'xml'));
}

// ########################################################################
// file manager
if ($_REQUEST['do'] == 'files')
{	
	$vbulletin->input->clean_gpc('r', 'productid', TYPE_STR);

	print_form_header('templateedits', 'export', 0, 1, 'downloadform" target="download');
	print_table_header($vbphrase['export_templateedits']);
	print_select_row($vbphrase['product'], 'product', fetch_product_list(), $vbulletin->GPC['productid']);
	print_input_row($vbphrase['filename'], 'filename', 'templateedits.xml');
	print_select_row($vbphrase['file_format'], 'fileformat', array('xml' => $vbphrase['templateedits_xml_file'], 'txt' => $vbphrase['edit_instructions_txt']));
	print_chooser_row($vbphrase['language'], 'languageid', 'language');
	print_style_chooser_row('styleid', '-1', 'MASTER', $vbphrase['style'], 1);
	print_submit_row($vbphrase['download']);

	print_form_header('templateedits', 'import', 1, 1, 'uploadform" onsubmit="return js_confirm_upload(this, this.templateeditsfile);');
	print_table_header($vbphrase['import_templateedits_xml_file']);
	print_upload_row($vbphrase['upload_xml_file'], 'templateeditsfile', 999999999);
	print_input_row($vbphrase['import_xml_file'], 'filename', '');
	print_yes_no_row($vbphrase['ignore_product_version'], 'ignoreversion', 0);
	print_yes_no_row($vbphrase['allow_overwrite'], 'allowoverwrite', 0);
	print_style_chooser_row('styleid', '-1', 'MASTER', $vbphrase['style'], 1);
	print_submit_row($vbphrase['import']);
	?>
	<script type="text/javascript">
	<!--
	function js_confirm_upload(tform, filefield)
	{
		if (filefield.value == "")
		{
			return confirm("<?php echo construct_phrase($vbphrase['you_did_not_specify_a_file_to_upload'], '" + tform.filename.value + "'); ?>");
		}
		return true;
	}
	products = fetch_object('sel_product_1'); 
	fileformat = fetch_object('sel_fileformat_3');
	filename = fetch_object('it_filename_2');
	function update_filename()
	{
		var productid = products.options[products.selectedIndex].value;
		var fileext = fileformat.options[fileformat.selectedIndex].value;
		filename.value = 'templateedits-' + productid  + '.' + fileext;
	}
	products.onchange = update_filename;
	products.onblur = update_filename;
	fileformat.onchange = update_filename;
	fileformat.onblur = update_filename;
	// -->
	<?php
	if ($vbulletin->GPC['productid'])
	{
		echo("update_filename();\n");
	}
	?>
	</script>
	<?php
}

// ########################################################################
// rebuild all id caches and templateedits
if ($_REQUEST['do'] == 'rebuild')
{
	print_build_styleedits(-1, 'MASTER', array(), '', true, true);
	print_cp_redirect('templateedits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modify', 1);
}

if ($_POST['do'] == 'updateactive')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'templateedits' => TYPE_ARRAY_INT,
		'activeedits' => TYPE_ARRAY_INT,
		'tmstemplate' => TYPE_STR,
		'styleid' => TYPE_INT
	));
	
	$vbulletin->GPC['activeedits'][] = 0;
	
	if (!empty($vbulletin->GPC['templateedits']))
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "templateedit SET active = IF(templateeditid IN (" . implode(',', $vbulletin->GPC['activeedits']) . "), 1, 0) WHERE templateeditid IN (" . implode(',', $vbulletin->GPC['templateedits']) . ")");
		rebuild_template_edits('', array($vbulletin->GPC['tmstemplate']));
	}
	if ($vbulletin->GPC['ajax'])
	{
		$templateedits = get_template_edits(0, '', $vbulletin->GPC['tmstemplate'], $vbulletin->GPC['styleid']);
		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('tms');
		$xml->add_tag('templateedits', $templateedits);
		$xml->close_group();
		$xml->print_xml();
	}
}

// ########################################################################
// display search form
if ($_REQUEST['do'] == 'search')
{
	// search only
	print_form_header('templateedits', 'modify', false, true, 'sform', '90%', '', true, 'get');
	print_table_header($vbphrase['search_template_edits']);
	print_style_chooser_row("searchset", $vbulletin->GPC['dostyleid'], $vbphrase['search_in_all_styles'] . iif($vbulletin->debug, ' (' . $vbphrase['including_master_style'] . ')'), $vbphrase['search_in_style'], 1);
	print_textarea_row($vbphrase['search_for_text'], "searchstring");
	print_label_row($vbphrase['elements_to_search_in'], "<div class=\"smallfont\"><label for=\"cb_title\"><input type=\"checkbox\" id=\"cb_title\" name=\"searchoptions[]\" value=\"1\" />$vbphrase[title]</label><br /><label for=\"cb_searchtext\"><input type=\"checkbox\" id=\"cb_searchtext\" name=\"searchoptions\" value=\"2\" />$vbphrase[search_text]</label><br /><label for=\"cb_replacetext\"><input type=\"checkbox\" id=\"cb_replacetext\" name=\"searchoptions[]\" value=\"4\" />$vbphrase[replacement_text]</label></div>");
	print_submit_row($vbphrase['find']);
}

// ########################################################################
// main templateedits display
if ($_REQUEST['do'] == 'modify')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'searchset'    => TYPE_INT,
		'searchstring' => TYPE_STR,
		'expandset'    => TYPE_NOHTML,
		'group'        => TYPE_NOHTML,
		'searchoptions'   => TYPE_ARRAY_INT,
	));


	$searchoptions = array_sum($vbulletin->GPC['searchoptions']);
	
	// populate the stylecache
	cache_styles();
	
	if (is_numeric($vbulletin->GPC['expandset']))
	{
		$style = $db->query_first("SELECT parentlist FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->GPC['expandset']);
		$parentlist = $style['parentlist'];
	}

	$JS_STYLETITLES[] = "\"0\" : \"$vbphrase[master_style]\"";
	$prepend = '--';

	foreach ($stylecache AS $style)
	{
		$JS_STYLETITLES[] = "\"$style[styleid]\" : \"" . addslashes_js($style['title'], '"') . '"';
		$JS_STYLEPARENTS[] = "\"$style[styleid]\" : \"$style[parentid]\"";
	}

	$JS_MONTHS = array();
	$i = 0;
	$months = array('january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december');
	foreach ($months AS $month)
	{
		$JS_MONTHS[] = "\"$i\" : \"" . $vbphrase["$month"] . '"';
		$i++;
	}

	foreach (array(
		'click_the_expand_collapse_btn',
		'this_templateedit_has_been_customized_in_a_parent_style',
		'this_templateedit_has_not_been_customized',
		'this_templateedit_has_been_customized_in_this_style',
		'template_last_edited_js',
		'x_templateedits',
		) AS $phrasename)
	{
		$JS_PHRASES[] = "\"$phrasename\" : \"" . fetch_js_safe_string($vbphrase["$phrasename"]) . '"';
	}

?>

<script type="text/javascript">
<!--
var SESSIONHASH = "<?php echo $vbulletin->session->vars['sessionhash']; ?>";
var EXPANDSET = "<?php echo $vbulletin->GPC['expandset']; ?>";
var SEARCHSTRING = "<?php echo urlencode($vbulletin->GPC['searchstring']); ?>";
var GROUP = "<?php echo $vbulletin->GPC['group']; ?>";
var STYLETITLE = { <?php echo implode(', ', $JS_STYLETITLES); ?> };
var STYLEPARENTS = { <?php echo implode(', ', $JS_STYLEPARENTS); ?> };
var MONTH = { <?php echo implode(', ', $JS_MONTHS); ?> };
var vbphrase = {
	<?php echo implode(",\r\n\t", $JS_PHRASES) . "\r\n"; ?>
};

// -->
</script>

<?php
?>
<form action="template.php" method="post" tabindex="1" name="tform">
<input type="hidden" name="do" value="dodisplayorder" />
<input type="hidden" name="s" value="<?php echo $vbulletin->session->vars['sessionhash']; ?>" />
<input type="hidden" name="expandset" value="<?php echo $vbulletin->GPC['expandset']; ?>" />
<input type="hidden" name="group" value="<?php echo $vbulletin->GPC['group']; ?>" />
<div align="center">
<div class="tborder" style="width:90%; text-align:<?php echo $stylevar['left']; ?>">
<div class="tcat" style="padding:4px; text-align:center"><b><?php echo($vbphrase['template_edit_manager']); ?></b></div>
<div class="stylebg">
<?php
/*
	if (!empty($vbulletin->GPC['expandset']))
	{
*/
		DEVDEBUG('Querying master templateedit IDs');
		$masters = $db->query_read("
			SELECT templateeditlocation.varname, templateeditlocation.title, templateedit.templateeditid
			FROM " . TABLE_PREFIX . "templateeditlocation AS templateeditlocation
			INNER JOIN " . TABLE_PREFIX . "templateedit AS templateedit ON (templateedit.varname=templateeditlocation.varname)
			LEFT JOIN " . TABLE_PREFIX . "product AS product ON (product.productid=templateeditlocation.product)
			WHERE templateedit.styleid=-1
			ORDER BY templateeditlocation.title
		");
		while ($master = $db->fetch_array($masters))
		{
			$masterset["$master[varname]"] = $master['templateeditid'];
		}
/*
	}
	else
	{
		$masterset = array();
	}
*/
	$products = fetch_product_list();

	$LINKEXTRA = '';

	if (!empty($vbulletin->GPC['group']))
	{
		$LINKEXTRA .= '&amp;group=' . $vbulletin->GPC['group'];
	}

	print_template_edits(-1, '', $vbulletin->GPC['searchstring'], $searchoptions);

	foreach ($stylecache AS $styleid => $style)
	{
		print_template_edits($styleid, $style, $vbulletin->GPC['searchstring'], $searchoptions);
	}
?>
</div>
</div>
</div>
</form>
<?php
	echo '<br /><div align="center" class="smallfont">';
	echo(construct_link_code($vbphrase['upload_download_templateedits'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=files'));
	echo(construct_link_code($vbphrase['rebuild_all_templateedits'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=rebuild'));
	echo(construct_link_code($vbphrase['delete_templateedits'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=deleteall'));
	echo(construct_link_code($vbphrase['view_modified_template'], 'templateedits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewmodifiedtemplate'));
	echo('</div>');
}

if (in_array($_REQUEST['do'], array('add', 'edit', 'viewtemplate', 'viewmodifiedtemplate', 'doviewmodifiedtemplate')))
{
	echo('<script type="text/javascript">var vbphrase = {"not_found" : "' . fetch_js_safe_string($vbphrase['not_found']) . '"};</script>');
}

if (!$vbulletin->GPC['ajax'])
{
	print_cp_footer();
}
/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile: templateedits.php,v $ - $Revision: 1.59 $
|| ####################################################################
\*======================================================================*/
?>