<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT',  'local_links_stream');
define('CSRF_PROTECTION', true);

define('NOCOOKIES', 1);

$phrasegroups = array(
	'local_links',
);

$globaltemplates = array();

$specialtemplates = array(
	'attachmentcache',
	'ldm_admin',
	'ldm_cats',
);

$actiontemplates = array();

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

// Turn off php time out so that transfers complete correctly
if (function_exists('set_time_limit') and !SAFEMODE) {
	@set_time_limit(0);
}

$READ_BUFFER_SIZE = READ_BUFFER;

if ($_REQUEST['action'] == "stream") {

	$time = TIMENOW;

	if (isset($_REQUEST['linkid'])) {

		$id = intval($_REQUEST['linkid']);

		if (isset($_REQUEST['entityid'])) {
			$entityid = intval($_REQUEST['entityid']);
			$jumplink = $vbulletin->db->query_read("
				SELECT entity.entityvalue AS linkurl,
					link.linkname AS linkname, link.linkforum AS linkforum,
					".$LINK_OK." AS linkstatus
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksentities AS entity
				ON link.linkid = entity.linkid
				WHERE link.linkid='".$id."'
				AND entity.entityid='".$entityid."'
				LIMIT 1
				");
		}
		else {
			$jumplink = $vbulletin->db->query_read("
				SELECT linkurl, linkname, linkforum, linkstatus FROM ".THIS_TABLE."linkslink
				WHERE linkid='".$id."'
				LIMIT 1
				");
		}

		unset($url);
		while ($jump=$vbulletin->db->fetch_array($jumplink)) {
			$url	   = $jump['linkurl'];
			$linkforum = $jump['linkforum'];
			$linkstatus = $jump['linkstatus'];
			$linkname  = $jump['linkname'];
		}
		if (!isset($url)) {
			exit;
		}

	}
	else {
		exit;
	}

// Check security token
	if (!ldm_decrypt_authority(urldecode($_REQUEST['token']), $id, $_REQUEST['catid'], $error)) {
		exit;
	}

// Patch for requests made by Windows Media Player without correct cookies
	$is_wmp = 0;
	if (stristr($_SERVER['HTTP_USER_AGENT'], "Windows-Media-Player") or stristr($_SERVER['HTTP_USER_AGENT'], "NSPlayer")) {
		$is_wmp = 1;
	}

	if (!$is_wmp) {
// Check for LDM category access permission
		$catidarray = ldm_lookup_categories($id);
		if (!count($catidarray)) {
			$catidarray = array();
		}
		$cataccessok = 0;
		foreach ($catidarray as $thiscatid) {
			if (ldm_catid_is_valid($thiscatid)) {
				if (ldm_lookup_permission($thiscatid, "can_access_link")) {
					$cataccessok = 1;
					break;
				}
			}
		}
		if (!$cataccessok) {
			exit;
		}

// Check for LDM forum access permission
		if (!ldm_forumid_is_valid($linkforum)) {
			exit;
		}
		elseif ($linkforum > 0) {
			$forumperms = fetch_permissions($linkforum);
			if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) || !($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers'])) {
				exit;
			}
		}
	}

// Handle mirrors if any
    require_once(DIR . '/includes/local_links_mirrors.php');
    $patch_mirror = ldm_patch_url_to_mirror($download_mirrors, 1, $url, $error, $mirror_urls);
    if ($patch_mirror==0) {
	    exit;
	}

// Go to it...
	$urlInfo = parse_url($url);
	if ($urlInfo['scheme'] != "" and !array_key_exists($urlInfo['scheme'], $ldm_protocol_schemes)) {
		exit;
	}

	$dfname  = basename($urlInfo['path']);
	$type	 = file_extension($dfname);
	$mimetype = ldm_get_mimetype($type);

// Change any realaudio tags into embedded player tags IF browser is NOT
// Explorer (!is_browser('ie') does not work for IE7)
	if (is_browser('firefox') || is_browser('safari')) {
		foreach ($mimetype as $k=>$mime) {
			if (preg_match("/-real/", $mimetype[$k])) {
				$mimetype[$k] = "Content-type: audio/x-pn-realaudio-plugin";
			}
		}
	}

// Recheck filesize before sending headers...
	$linksize = ldm_get_sizeof_url($url);
	$do206 = 0;
	$ilast = 0;

// Final chance before we begin...
	($hook = vBulletinHook::fetch_hook('ldm_stream_start')) ? eval($hook) : false;

// Record hit only if explicitly asked to do so
	if (isset($_REQUEST['recordhit']) and $_REQUEST['recordhit'] and !$is_wmp) {
		ldm_record_hit($id, $url, $LINK_OK, $linksize);
	}

// Request for partial range(s) - only honour requests for a single range...
	$curr_headers = ldm_parse_headers();
	if ($linksize and isset($curr_headers['Range'])) {
		if (1==preg_match_all("/bytes\s*=\s*(\d+)\s*(\d*)/", $curr_headers['Range'], $ranges, PREG_SET_ORDER)) {
			$do206  = 1;
			$istart = $ranges[0][1];
			$iend   = $ranges[0][2];
			if (!$iend or $iend>=$linksize) {
				$iend  = $linksize-1;
				$ilast = 1;
			}
			$ichars = $iend-$istart+1;
		}
	}

	$file = ldm_cleanto_fopen($url);
	$use_curl = 0;
	$conn = 0;

	if ($urlInfo['host'] == "") {
		$conn = @fopen($file, "rb");
	}
	elseif ($LDM_environment['curl_available']) {
		$conn = @curl_init();
		$use_curl = 1;
	}
	elseif ($LDM_environment['allow_url_fopen']) {
		$conn = @fopen($file, "rb");
	}

	@ini_set('zlib.output_compression', 'Off');

	@header("HTTP/1.1 " . ($do206 ? "206 Partial content" : "200"));
	@header("Expires: 0");

// Get round IE ssl cache problem
	if (strtolower($_SERVER['HTTPS'])=="https" or $_SERVER['SERVER_PORT']==443) {
		@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
	}
	else {
		@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
		@header("Pragma: no-cache"); // HTTP/1.0
	}

	@header("Content-disposition: inline; filename=".str_replace(" ", "_", $dfname)."");
	@header('Content-transfer-encoding: binary');
	if ($linksize>1) {
		if ($do206) {
			@header("Accept-Ranges: bytes");
			@header("Content-Range: bytes $istart-$iend/$linksize");
			@header("Content-Length: $ichars");
		} else {
			@header("Accept-Ranges: " . (!$links_defaults['allow_http_ranges'] ? "none" : "bytes"));
			@header("Content-Length: $linksize");
		}
	}
	if (is_array($mimetype)) {
		foreach ($mimetype AS $index => $header) {
			@header($header);
		}
	}
	else {
		@header("Content-type: unknown/unknown");
	}

	if ($use_curl) {
		if ($urlInfo['user']) {
			ldm_unglue_username_and_password($urlInfo, $rawurl, $userpassword);
			@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $rawurl));
			@curl_setopt($conn, CURLOPT_USERPWD, $userpassword);
		}
		else {
			@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $url));
		}
		@curl_setopt($conn, CURLOPT_FOLLOWLOCATION, true);
		@curl_setopt($conn, CURLOPT_MAXREDIRS, 5);
		@curl_setopt($conn, CURLOPT_HEADER, 0);
		@curl_setopt($conn, CURLOPT_SSL_VERIFYPEER, false);
		@curl_setopt($conn, CURLOPT_USERAGENT, "LDM Downloader");
		if ($do206) {
			@curl_setopt($conn, CURLOPT_RANGE, "$istart-$iend");
		}
		@curl_exec($conn);
		$res = @curl_getinfo($conn);
		$bytes = $res["size_download"];
		@curl_close($conn);

	}
	else {
		$bytes = 0;
		if (!$do206) {
			while ($contents = fread ($conn, $READ_BUFFER_SIZE)) {
				echo $contents;
				$bytes += strlen($contents);
			}
		}
		else {
			$jchar = 0;
			while ($jchar<$istart) {
				$nchar = (($istart-$jchar)<$READ_BUFFER_SIZE ? ($istart-$jchar) : $READ_BUFFER_SIZE);
				$contents = fread($conn, $nchar);
				$jchar += strlen($contents);
			}
			while ($jchar<$iend) {
				$nchar = (($iend-$jchar+1)<$READ_BUFFER_SIZE ? ($iend-$jchar+1) : $READ_BUFFER_SIZE);
				$contents = fread($conn, $nchar);
				echo $contents;
				$jchar += strlen($contents);
			}
			$bytes = $jchar;
		}
		flush();
		fclose($conn);
	}

	exit;
}

?>