<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/* ---------------------------------------------------------------------------
	Displays a thumbnail image generated 'on-the-fly'.
	Used within LDM.

	Use - either

	1. place calls to local_resize.php?pic='xxx'&size=yyy in an <img> tag

	  pic='xxx'		creates a thumbnail of a local file xxx stored relative to the
					website's DOCUMENT_ROOT or a full url
	  size=yyy		resized picture in pixels
	  				an image that is a by b pixels in size will be resized so
	  				that the greater dimension becomes yyy.
	  				Optional, $links_defaults['link_imagesize'] used if parameter
	  				not specified

	  If size=0/omitted, the image is returned at its current size.

	  For security reasons, xxx must be an actual image file with filetype
	  matching one of the types allowed below, i.e. it cannot be a generator
	  script and the contents must be valid for the image format.

	  If xxx is a url, the script tries to use cURL, failing which
	  remote fread() calls, to read the contents.

	  Images created with these parameters are never stored as thumbs in the database

	or

	2. place calls to local_resize.php?linkid=N[&entityid=N]&size=yyy in an <img> tag

	  linkid=N      shows/creates a thumbnail for the image associated with linkid N
	[ entityid=N     entityid N ]

	  size=			as above.

	  If a size= parameter is given, a new image is created, regardless of whether one is already cached

	  The new image is cached in the database *provided* the size parameter is omitted

	or

	3. place calls to local_resize.php?mp3='xxx'&size=yyy in an <img> tag

	  as case 1, except pulls the image from the id3tags in an mp3 file

--------------------------------------------------------------------------- */

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_resize');
define('CSRF_PROTECTION', true);

//define('SKIP_SESSIONCREATE', 1);
define('SESSION_BYPASS', 1);
define('NOCOOKIES', 1);
define('DIE_QUIETLY', 1);

$phrasegroups = array();

$globaltemplates = array();

$specialtemplates = array(
	'attachmentcache',
	'ldm_admin',
	'ldm_cats',
);

$actiontemplates = array();

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');
require_once(DIR . '/includes/local_links_images.php');

/* --------------------------------------------------------------------------- */

$vbulletin->input->clean_array_gpc('g', array(
	'catid'		=> TYPE_INT,
	'entityid'	=> TYPE_INT,
	'linkid'	=> TYPE_INT,
	'mp3'		=> TYPE_STR,
	'pic'		=> TYPE_STR,
	'size'		=> TYPE_INT,
	));

$thumb = "";

($hook = vBulletinHook::fetch_hook('ldm_resize_start')) ? eval($hook) : false;

if ($thumb) {
	@header("Content-type: image/jpeg");
	imagejpeg($thumb,"",90);
	imagedestroy($thumb);
	exit;
}

if ($vbulletin->GPC_exists['pic']) {

	$pic = $vbulletin->GPC['pic'];
	$pic = preg_replace("/\\\\/", "", $pic); // some sites escape quotes around the parameter
	$pic = preg_replace("/^([\'\"])(.*)([\'\"])$/", "$2", $pic);
	$pic_info = ldm_parse_url($pic);
	$size = ($vbulletin->GPC_exists['size'] ? max($vbulletin->GPC['size'], 0) : $links_defaults['link_imagesize']);

	$thumb = ldm_make_thumbnail($pic, $size);

	@header("Content-type: image/jpeg");
	imagejpeg($thumb,"",90);
	imagedestroy($thumb);
	exit;

}

if ($vbulletin->GPC_exists['linkid']) {

	$linkid = $vbulletin->GPC['linkid'];

	$catid = -1;
	if ($vbulletin->GPC_exists['catid']) {
		$catid = $vbulletin->GPC['catid'];
	}
	else {
		$catids = ldm_lookup_categories($linkid);
		if (count($catids)) {
			$catid = $catids[0];
		}
	}

	if ($vbulletin->GPC_exists['entityid']) {
		$entityid = $vbulletin->GPC['entityid'];
		$query = "
			SELECT link.linkid AS linkid, entity.entityvalue AS linkimg, '' AS linkimgthumb, 0 AS linkimgthumbsize
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksentities AS entity
			ON link.linkid=entity.linkid
			WHERE link.linkid='".$linkid."'
			AND entity.entityid='".$entityid."'
			LIMIT 1
		";
	}
	else {
		$query = "
			SELECT linkid, linkimg, linkimgthumb, linkimgthumbsize
			FROM ".THIS_TABLE."linkslink AS link
			WHERE link.linkid='".$linkid."'
			LIMIT 1
		";
	}

	$rec = $vbulletin->db->query_first($query);
	$default_size = ldm_lookup_setting($catid, 'link_imagesize');
	$size = ($vbulletin->GPC_exists['size'] ? max($vbulletin->GPC['size'], 0) : $default_size);

	if ($rec['linkid']) {

// If we already have a thumbnail, just output it
		if ($rec['linkimgthumb'] and $rec['linkimgthumbsize']==$default_size and !$vbulletin->GPC_exists['size']) {

			$file = ldm_get_local_filename($rec['linkimgthumb'],0);
			$fp = @fopen($file,'r');

			if ($fp) {
				$image = fread($fp, filesize($file));
				fclose($fp);
				@header("Content-type: image/jpeg");
				echo $image;
				unset($image);
				exit;
			}

// Thumbnail does not exist - update database
			$rec['linkimgthumb'] = "";
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET linkimgthumb=''
				WHERE linkid=".$linkid."
			";
			$vbulletin->db->query_write($query);
		}

		if ($rec['linkimg']) {
			$thumb = ldm_make_thumbnail($rec['linkimg'], $size);
		}


		if ($thumb and !$entityid and $links_defaults['thumbs_dir']
			and (!$vbulletin->GPC_exists['size'] or $vbulletin->GPC['size']==$default_size)) {
// Cache new thumb
			if ($rec['linkimgthumb']) {
				ldm_delete_thumb($rec['linkimgthumb']);
			}
			$imgthumb = ldm_save_thumbnail($thumb, $links_defaults['thumbs_dir']);
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkimgthumb='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $imgthumb))."',
					linkimgthumbsize='".intval($size)."'
				WHERE linkid=".$linkid."
			";
			$vbulletin->db->query_write($query);
		}

	}

	if (!$thumb) {
		$thumb = ldm_make_clear_thumbnail();
	}

	if ($thumb) {
		@header("Content-type: image/jpeg");
		imagejpeg($thumb,"",90);
		imagedestroy($thumb);
		exit;
	}

}

if ($vbulletin->GPC_exists['mp3']) {

	$url = $vbulletin->GPC['mp3'];
	$url = preg_replace("/^(\')(.*)\'$/", "$2", $url);
	$im = 0;

	$urlInfo = ldm_parse_url($url);
	if (!$urlInfo['host']) {
		$FileName = ldm_cleanto_fopen($url);
		$im = ldm_fetch_mediafile_image($FileName);
	}

	if (!$im) {
		cache_LDMicons();
		if (isset($ldm_icon_cache['jukebox'])) {
			$file = $ldm_icon_cache['jukebox'];
			$fp = @fopen($file, 'r');
			if ($fp) {
				$im = fread($fp, filesize($file));
				fclose($fp);
			}
		}
	}

	$size = ($vbulletin->GPC_exists['size'] ? max($vbulletin->GPC['size'],0) : $links_defaults['link_imagesize']);

	if ($im) {
		$im = @imagecreatefromstring($im);
		$old_x = imageSX($im);
		$old_y = imageSY($im);
		$thumb_w = ($old_x>=$old_y ? (int) ($size) : (int) ($size*$old_x/$old_y));
		if ($thumb_w>$old_x) $thumb_w = $old_x;
		$thumb_h = (int) ($thumb_w*($old_y/$old_x));
		$thumb = ImageCreateTrueColor($thumb_w,$thumb_h);
		imagecopyresampled($thumb,$im,0,0,0,0,$thumb_w,$thumb_h,$old_x,$old_y);
		imagedestroy($im);
	} else {
		$thumb = ImageCreateTrueColor($size,$size);
	}

	if ($thumb) {
		@header("Content-type: image/jpeg");
		imagejpeg($thumb,"",90);
		imagedestroy($thumb);
		exit;
	}

}

?>
