<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_links_search');
define('CSRF_PROTECTION', true);

if (empty($_REQUEST['action'])) $_REQUEST['action'] = "search";
if (empty($_REQUEST['do'])) $_REQUEST['do'] = $_REQUEST['action'];

// get special phrase groups
$phrasegroups = array(
	'local_links',
	'local_links_entities',
	'cprofilefield',
);

$globaltemplates = array(
	'links_access_error',
	'links_bandwidthbit',
	'links_catbit',
	'links_catbit_extras',
	'links_catjump',
	'links_catsortbit',
	'links_downloadbit',
	'links_editbit',
	'links_entitymarkupbit',
	'links_favbit',
	'links_footer',
	'links_header',
	'links_hitparade',
	'links_imgmag',
	'links_introbit',
	'links_keysbit',
	'links_likebit',
	'links_linkbit',
	'links_linkbit_nominations',
	'links_linkbit_photo',
	'links_linkbit_short',
	'links_linkbit_short_cent',
	'links_linkbit_short_direct',
	'links_linkbit_table',
	'links_linkseparator',
	'links_listselect',
	'links_main',
	'links_navbar',
	'links_navbar_popups',
	'links_nominatebit',
	'links_nominated_leaderbit',
	'links_othercatsbit',
	'links_ratebit_ajax',
	'links_ratebit_dropdown',
	'links_ratebit_inline',
	'links_ratesortbit',
	'links_reportlinkbit',
	'links_sendtofriendbit',
	'links_subcatbit',
	'links_viewone_entity',
	'links_viewone_inline_comment',
	'links_viewone_nomination',
	'links_viewone_nominator',
	'links_viewone_popup_comment',
	'STANDARD_ERROR_LITE',
	);

$specialtemplates = array(
	'attachmentcache',
	'smiliecache',
	'bbcodecache',
	'ldm_admin',
	'ldm_cats',
);

$actiontemplates = array(
	'editsearches' => array(
		'links_editsearch',
		'links_editsearch_one',
	),
	'search' => array(
		'humanverify_image',
		'links_search',
		'links_search_catselect',
	),
);

require_once('./global.php');

if (!$vbulletin->products[THIS_PRODUCT_NAME]) {
	eval(standard_error($vbphrase['ll_error_product_disabled']));
	exit;
}

require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

($hook = vBulletinHook::fetch_hook('ldm_start')) ? eval($hook) : false;
($hook = vBulletinHook::fetch_hook('ldm_search_start')) ? eval($hook) : false;

$vbulletin->input->clean_array_gpc('r', array(
	'action'	=> TYPE_STR,
	'pp'		=> TYPE_INT,
	'page'		=> TYPE_INT
	));

$this_action = $vbulletin->GPC_exists['action'] ? $vbulletin->GPC['action'] : "search";

if ($vbulletin->GPC_exists['pp']) {
	$perpage = $vbulletin->GPC['pp'];
}
else {
	$perpage = $vbulletin->userinfo['maxposts'];
	$checkmax = explode(',', $vbulletin->options['usermaxposts'] . ',' . $vbulletin->options['maxposts']);
	if ($perpage < 1 OR $perpage > max($checkmax)) {
		$perpage = $vbulletin->options['maxposts'];
	}
	$perpage = ($links_defaults['links_per_page']!=0 ? $links_defaults['links_per_page'] : $perpage);
}

$pagenumber = ($vbulletin->GPC_exists['page'] ? $vbulletin->GPC['page'] : 1);
$master_title = ($links_defaults['database_name'] ? $links_defaults['database_name'] : $vbphrase['ll_links_database']);

/* ===========================================================================*/
// Main command functions
/* ===========================================================================*/

// #################### Set up a Search

if ($this_action == "search") {

/**
* Build a searchidbits select object for the saved searches
*
* @param	int		Selected search id
* @return	str		Search select bit
*/

function ldm_make_searchidbits($searchid) {
	global $vbulletin, $vbphrase;

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linkssearch
		WHERE searchusername LIKE ('".$vbulletin->db->escape_string($vbulletin->userinfo['username'])."')
		ORDER BY searchname ASC
		");
	$searchidbits = "";
	if ($vbulletin->db->num_rows($asb)) {
		$searchidbits = "<select class='select' name='searchid' size='1' style='width:300px'>";
		while ($rec = $vbulletin->db->fetch_array($asb)) {
			$searchidbits .= "<option value='".$rec['searchid']."' ".($searchid==$rec['searchid'] ? "selected='selected'" : "").">".
				$rec['searchname'].' '.
				'('.
				ldm_date($vbulletin->options['dateformat'], $rec['searchtime']).
				' '.
				$rec['searchhits'].' '.$vbphrase['ll_hits'].
				') '.
				"</option>";
		}
		$searchidbits .= "</select>";
	}
	return $searchidbits;
}

/**
* Build a searchprofilebits select object for profile searches
*
* @param	int		Selected search id
* @return	str		Search select bit
*/

function ldm_make_searchprofilebits($searchprof) {
	global $vbulletin, $vbphrase;
	global $links_defaults, $ldm_myprofilesearch;

	if (isset($ldm_myprofilesearch)) {
		$searchprofilebits = $ldm_myprofilesearch['advmenu'];
	}
	else {
		$searchprofilebits = '';
	}
	return $searchprofilebits;
}

}

// Translate requests to 'retrieve search' into 'show'...
if ($this_action == "search") {
	$vbulletin->input->clean_array_gpc('r', array(
		'retrieve'		=> TYPE_INT,
		));
	if ($vbulletin->GPC['retrieve']==2) {
		$this_action = "show";
	}
}

if ($this_action == "search") {

	$vbulletin->input->clean_array_gpc('r', array(
		'searchid'		=> TYPE_INT,
		'mysearch'		=> TYPE_INT,
		));

	if (!$links_permissions["can_search_link"]) {
		print_no_permission();
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_setup_search_begin')) ? eval($hook) : false;

	$this_navigation_title = $master_title;
	construct_forum_jump();

	$search = array();
	$searchmenu = 0;

	if ($vbulletin->GPC_exists['searchid']>0) {
		$query = "
			SELECT *
			FROM ".THIS_TABLE."linkssearch
			WHERE searchid=".$vbulletin->GPC['searchid']."
			AND   searchuserid=".$vbulletin->userinfo['userid']."
			LIMIT 1
			";
		$asb = $vbulletin->db->query_read($query);
		if ($vbulletin->db->num_rows($asb)) {
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$search = unserialize($row['searchparam']);
				$search['savesearchid'] = $vbulletin->GPC['searchid'];
				$search['savesearch'] = 1;
				$searchmenu = $row['searchmenu'];
			}
		}
		else {
			$vbulletin->url = $SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=search";
			eval(print_standard_redirect(construct_phrase($vbphrase['ll_error_searchid'], $vbulletin->GPC['searchid']),0));
			exit;
		}
	}
	elseif ($vbulletin->GPC_exists['mysearch']) {

		if (!isset($ldm_myprofilesearch[$vbulletin->GPC['mysearch']])) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_mysearch_empty'], "profile.php?".$vbulletin->session->vars['sessionhash']."do=editprofile")));
			exit;
		}

		$search['string'] = $ldm_myprofilesearch[$vbulletin->GPC['mysearch']]['text'];
		$search['literal']	= $links_defaults['profile_search_all'];
		$search['desc']		= $links_defaults['default_search_desc'];
		$search['keys']		= $links_defaults['default_search_keys'];
		$search['ents']		= $links_defaults['default_search_ents'];
		$search['cats']		= 0;
		$search['child']	= 1;
		$search['user']		= "";
		$search['savename'] = "";
		$search['when'] 	= 0;
		$search['after'] 	= 1;
		$search['sort']		= $links_defaults['default_sort_order'];
		$search['savesearchid'] = -1;
		$search['savesearch'] = 0;

	}
	else {

		$search['literal']	= $links_defaults['default_search_all'];
		$search['desc']		= $links_defaults['default_search_desc'];
		$search['keys']		= $links_defaults['default_search_keys'];
		$search['ents']		= $links_defaults['default_search_ents'];
		$search['cats']		= 0;
		$search['child']	= 1;
		$search['user']		= "";
		$search['savename'] = "";
		$search['when'] 	= 0;
		$search['after'] 	= 1;
		$search['sort']		= $links_defaults['default_sort_order'];
		$search['savesearchid'] = -1;
		$search['savesearch'] = 0;

	}

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_search'].' '.$master_title);
	$navbits[$SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=search'] = $vbphrase['ll_search'].' '.$master_title;
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	$catbit = ldm_construct_category_list (explode(',',$search['cats']), "links_search_catselect", 0, "catsearch[]", "catsearch", 1);
	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = ldm_construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	$sortset = $search['sort'];
	$sortdef = 0;
	$sortvar = "sort";
	$sortsubmit = 0;
	$sortwidth = "300";
	eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");

	$searchidbits = ldm_make_searchidbits($searchid);
	$searchprofilebits = "";
	if ($links_defaults['show_profilesearchmenu'] and $links_defaults['profile_searchfield'] and trim($links_defaults['profile_searchfield'])!='-1') {
		$searchprofilebits = ldm_make_searchprofilebits($searchprof);
	}

	$viewcatid = -2;
	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;

// Take care - VB version specific
	if (VALID_VB_VERSION=="3.7") {
    	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_search']) {
    		require_once(DIR . '/includes/class_humanverify.php');
    		$verification =& vB_HumanVerify::fetch_library($vbulletin);
    		$human_verify = $verification->output_token();
    	}
    }
	if (VALID_VB_VERSION=="3.8") {
    	if (!$vbulletin->userinfo['userid'] AND fetch_require_hvcheck('search')) {
    		require_once(DIR . '/includes/class_humanverify.php');
    		$verification =& vB_HumanVerify::fetch_library($vbulletin);
    		$human_verify = $verification->output_token();
    	}
    }
// Take care - VB version specific

	if ($links_defaults['forms_fullwidth']) {
		$stylevar['outertablewidth'] = $stylevar['outerdivwidth'] = "100%";
		eval('$spacer_open = "' . fetch_template('spacer_open') . '";');
		eval('$header = "' . fetch_template('header') . '";');
		eval('$footer = "' . fetch_template('footer') . '";');
	}

	($hook = vBulletinHook::fetch_hook('ldm_setup_search_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_search')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Search for entries that are 'similar' to given entry

// Metric involves finding entries:
// a) visited/downloaded by users who have also visited/downloaded given entry
// b) marked as favourites by users who have also marked given entry as a favourite
// c) share the same keywords
// Each metric is weighted by a factor set on the main admin settings page or as
// command line parameters, and similarity is calculated according to the sum of the
// three values.

if ($this_action == "like") {

	($hook = vBulletinHook::fetch_hook('ldm_like_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid'		=> TYPE_INT,
		'catid'			=> TYPE_INT,
		'favwt'			=> TYPE_INT,
		'hitwt'			=> TYPE_INT,
		'keywt'			=> TYPE_INT,
		'includeown'	=> TYPE_INT,
		'num'			=> TYPE_INT,
		));

	$this_navigation_title = $master_title;
	construct_forum_jump();

	$script = SEARCH_SCRIPT;
	$script_action="like";

	$linkid	= $vbulletin->GPC['linkid'];
	$catid	= $vbulletin->GPC['catid'];

	$favwt	= $vbulletin->GPC_exists['favwt'] ? $vbulletin->GPC['favwt'] : $links_defaults['search_like_favwt'];
	$hitwt	= $vbulletin->GPC_exists['hitwt'] ? $vbulletin->GPC['hitwt'] : $links_defaults['search_like_hitwt'];
	$keywt	= $vbulletin->GPC_exists['keywt'] ? $vbulletin->GPC['keywt'] : $links_defaults['search_like_keywt'];
	$num	= $vbulletin->GPC_exists['num'] ? $vbulletin->GPC['num'] : $links_defaults['search_like_num'];

	$includeown = $vbulletin->GPC_exists['includeown'] ? $vbulletin->GPC['includeown'] : $links_defaults['search_like_own'];

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$this_navigation_title = ldm_kill_bbcodes($master_title);
	$navbits[$SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=like'] = $vbphrase['ll_menu_showlik'];
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = ldm_construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	$viewcatid = $BASE_CAT;
	$catlistbit   = "";

	$query = "
		SELECT linkid, linkname
		FROM ".THIS_TABLE."linkslink
		WHERE linkid=".$linkid."
		LIMIT 1
		";

	$row = $vbulletin->db->query_first($query);
	$message = construct_phrase($vbphrase['ll_find_like'], ldm_parse_features($row['linkname']), $LINKS_SCRIPT, $catid, $linkid);

	$viewcatname  = $vbphrase['ll_searchresults'];
	$viewcatdesc = $message;
	$viewcattext = $message;

	$ranking = array();
	$ranked_visible = array();

	if ($num>0 and $hitwt>0) {
		$query = "
			SELECT userid AS userid
			FROM ".THIS_TABLE."linksdownloads
			WHERE linkid=".$linkid."
			";
		$asb = $vbulletin->db->query_read($query);
		$userlist = array();
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$userlist[$row['userid']] = $row['userid'];
		}

		$totcount = count($userlist);
		if ($totcount and $hitwt) {
			$query = "
				SELECT linkid, COUNT(linkid) AS tothits
				FROM ".THIS_TABLE."linksdownloads
				WHERE userid IN (".implode(',', $userlist).")
				" . ($includeown ? "" : "AND userid<>".$vbulletin->userinfo['userid']) . "
				AND linkid>0
				AND linkid<>".$linkid."
				GROUP BY linkid
				";
			$asb = $vbulletin->db->query_read($query);
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$ranking[$row['linkid']] += $hitwt*$row['tothits']/$totcount;
			}
		}
	}

	if ($num>0 and $favwt>0) {
		$query = "
			SELECT userid
			FROM ".THIS_TABLE."linksfavs
			WHERE linkid=".$linkid."
			";
		$asb = $vbulletin->db->query_read($query);
		$userlist = array();
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$userlist[$row['userid']] = $row['userid'];
		}

		$totcount = count($userlist);
		if ($totcount and $favwt) {
			$query = "
				SELECT linkid, COUNT(linkid) AS totfavs
				FROM ".THIS_TABLE."linksfavs
				WHERE userid IN (".implode(',', $userlist).")
				" . ($includeown ? "" : "AND userid<>".$vbulletin->userinfo['userid']) . "
				AND linkid<>".$linkid."
				GROUP BY linkid
				";
			$asb = $vbulletin->db->query_read($query);
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$ranking[$row['linkid']] += $favwt*$row['totfavs']/$totcount;
			}
		}
	}

	if ($num>0 and $keywt>0) {
		$query = "
			SELECT keyid
			FROM ".THIS_TABLE."linksltok
			WHERE linkid=".$linkid."
			";
		$asb = $vbulletin->db->query_read($query);
		$keylist = array();
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$keylist[$row['keyid']] = $row['keyid'];
		}

		$totcount = count($keylist);
		if ($totcount and $keywt) {
			$query = "
				SELECT linkid, COUNT(linkid) AS totkeys
				FROM ".THIS_TABLE."linksltok
				WHERE keyid IN (".implode(',', $keylist).")
				AND linkid<>".$linkid."
				GROUP BY linkid
				";
			$asb = $vbulletin->db->query_read($query);
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$ranking[$row['linkid']] += $keywt*$row['totkeys']/$totcount;
			}
		}
	}

	if ($num>0 and count($ranking)) {
		$filter = "WHERE linkid IN (".implode(',', array_keys($ranking)).")";
		$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
		$limitfids = ldm_lookup_forum_protections($can_bypass);
		$filter .= "
			AND linkforum NOT IN (".implode(',', $limitfids).")";
		if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
			$filter .= "
				AND linkstatus != $LINK_HIDDEN";
			if (!$vbulletin->userinfo['userid']) {
				$filter .= "
				AND linkmoderate = ".$LINK_ACCEPTED;
			}
			else {
				$filter .= "
					AND
					(linkmoderate = ".$LINK_ACCEPTED." OR
					(linkmoderate = ".$LINK_TO_MODERATE." AND linkuserid = ".$vbulletin->userinfo['userid'].")
					)";
			}
		}

		$query = "
			SELECT linkid
			FROM ".THIS_TABLE."linkslink
			".$filter;
		$asb = $vbulletin->db->query_read($query);
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$ranked_visible[$row['linkid']] = $ranking[$row['linkid']];
		}
	}

	if ($num>0 and count($ranked_visible)) {
		asort($ranked_visible);
		$ranked_visible_slice = array_slice(array_reverse(array_keys($ranked_visible)),  0, $num);
		$squery = array();
		$squery[] = "link.linkid IN (".implode(',', $ranked_visible_slice).")";
		$query = ldm_get_mainsql($squery, 0, 0, 0, 0, 1, 1);

		cache_LDMfavourites();
		cache_LDMnominations();

		$linklistarray = array();

		$ncols = ldm_entrybit_columns($links_defaults["search_linkbit"]);

		$entrybit_options = array(
			'highlight'=>$highlight, 'showcatname'=>1, 'forcedisplayorder'=>1, 'forcereview'=>$links_defaults['links_jump_comment'],
			'viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid,
			);
		$nhits = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $links_defaults['search_linkbit'], $query, $entrybit_options, 1, 20);

		$linklistsort = array();
		foreach ($ranked_visible_slice as $rankedid) {
			$n = 0;
			foreach ($hitids as $linkid=>$catid) {
				if ($linkid==$rankedid) {
					$linklistsort[] = $linklistarray[$n];
					break;
				}
				$n++;
			}
		}
		$linklistbit = ldm_map_listbit_to_grid($linklistsort, $ncols, 1);

		$linkratingspopupbit = "";
		if ($links_defaults["dropdown_comment_and_rate"]>0) {
			$linkratings = ldm_get_ratingsbits($hitids, $pagenumber, 0);
			$linkratingspopupbit = implode("", $linkratings);
		}
	}

	$viewcatid = -2;
	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;

	$pagenav = 0;
	$sortnav = 0;
	unset($emptylistbit);
	$sortorderbit = "";

	if (!$num) {
		$emptylistbit = $vbphrase['ll_find_like_disable'];
	}
	elseif (!$linklistbit) {
		$emptylistbit = $vbphrase['ll_zerohits_sort'];
	}

	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = ldm_construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	($hook = vBulletinHook::fetch_hook('ldm_like_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

// drop through to common code for link/find/show
}

// #################### Find special categories

if ($this_action == "find") {

	($hook = vBulletinHook::fetch_hook('ldm_find_begin')) ? eval($hook) : false;

	$this_navigation_title = $master_title;
	construct_forum_jump();

	$vbulletin->input->clean_array_gpc('r', array(
		'catid'	=> TYPE_INT,
		'sort'	=> TYPE_STR,
		'limit' => TYPE_INT,
		'lastvisit' => TYPE_STR,
		'ratings' => TYPE_INT,
		'userid' => TYPE_INT,
		));

	require_once(DIR . '/includes/local_links_vbafunc.php');

	$viewcatid = ($vbulletin->GPC_exists['catid'] ? $vbulletin->GPC['catid'] : $BASE_CAT);

	if (!$vbulletin->GPC_exists['sort']) {
		$vbulletin->GPC['sort']=="";
	}

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]
		and ($viewcatid==$HIDE_CAT or $viewcatid==$AVL_CAT or $viewcatid==$BRKN_CAT or $viewcatid==$INVD_CAT)) {
		print_no_permission();
		exit;
	}

	$sort = $vbulletin->GPC['sort'];
	if (!$sort) {
		if ($viewcatid==$HOT_CAT) {
			$sort = 'h';
		}
		elseif ($viewcatid==$NEW_CAT) {
			$sort = 'd';
		}
		else {
			$sort = (isset($links_defaults['default_sort_order']) ? $links_defaults['default_sort_order'] : 'N');
		}
	}

	if (is_numeric($sort)) {
		$hitsince = TIMENOW - $sort*24*60*60;
	}

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$viewcatdesc  = $viewcattext  = $viewcatforum = "";
	$when = 0;

	switch ($viewcatid) {
	case $FAVS_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showfav'];
		break;
	case $HIDE_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showhid'];
		break;
	case $AVL_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showavl'];
		break;
	case $BRKN_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showbrk'];
		break;
	case $INVD_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showinv'];
		break;
	case $UPLD_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showupl'];
		break;
	case $HOT_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showhot'];
		break;
	case $NEW_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_shownew'];
		if ($vbulletin->GPC_exists['limit']) {
			$newsince = TIMENOW - $vbulletin->GPC['limit']*24*60*60;
			$viewcatdesc  = $viewcattext  = $vbphrase['ll_newentries'].' ('.$vbulletin->GPC['limit'].' '.$vbphrase['ll_days'].')';
		}
		elseif ($vbulletin->GPC_exists['lastvisit'] or $links_defaults["days_seen_on_portal"]==0) {
			$newsince = $vbulletin->userinfo['lastvisit'];
			$viewcatdesc  = $viewcattext  = $vbphrase['ll_newentries'].' '.$vbphrase['ll_sincelastvisit'];
		}
		else {
			$newsince = TIMENOW - intval($links_defaults["days_seen_on_portal"])*24*60*60;
			$viewcatdesc  = $viewcattext  = $vbphrase['ll_newentries'].' ('.$links_defaults["days_seen_on_portal"].' '.$vbphrase['ll_days'].')';
		}
		break;
	case $RND_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showrnd'];
		break;
	case $MY_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showmyl'];
		break;
	case $FEAT_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showfeat'];
		break;
	case $NEW_RATE:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_shownewrating'];
		break;
	case $NOM_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_shownominate'];
		break;
	case $CNOM_CAT:
		$viewcatname  = $navbits[""] = $vbphrase['ll_menu_showcnominate'];
		break;
	default:
		print_no_permission();
		exit;
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	cache_LDMfavourites();
	cache_LDMnominations();

	$template = $links_defaults["template_linkbit"];
	$allowlinkexpand = ($viewlinkid or !$ldm_linkbitcache[$template]["collapse"] ? 0 : 1 );

	if ($viewlinkid) {
		$template = ($ldm_linkbitcache[$template]["altbit"] ? $ldm_linkbitcache[$template]["altbit"] : $links_defaults["template_altbit"]);
	}
	elseif ($allowlinkexpand and isset($vbcollapse['collapsecel_linkrefreshbit'])) {
		$template = $ldm_linkbitcache[$template]["collapse"];
	}

	if ($viewcatid==$CNOM_CAT) {
		$template = 'links_linkbit_nominations';
		$ncols = 1;
	}
	else {
		$ncols = ldm_entrybit_columns($template);
	}

	$query = ldm_get_specialsearchsql($viewcatid, 0, $sort, 0, $newsince, $hitsince, $vbulletin->GPC['userid']);

	$linklistarray = array();
	$thispage = ($ncols<=1) ? $perpage : $ncols*floor(($perpage+$ncols-1)/$ncols);

	$entrybit_options = array(
		'showcatname'=>1, 'forcedisplayorder'=>1, 'forcereview'=>$links_defaults['links_jump_comment'],
		'viewcatid'=>$viewcatid, 'sort'=>$sort
		);
	$nhits = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $template, $query, $entrybit_options, $pagenumber, $thispage);

	$linklistbit = ldm_map_listbit_to_grid($linklistarray, $ncols, 1);

	$pagenavscript = $SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=find&amp;catid=".$viewcatid."&amp;sort=".$sort;
	$sortreturnbit = array("action"=>"find", "catid"=>$viewcatid, "page"=>1, "pp"=>$thispage);

	if ($vbulletin->GPC_exists['limit']) {
		$pagenavscript .= "&amp;limit=".$vbulletin->GPC['limit'];
		$sortreturnbit["limit"] = $vbulletin->GPC['limit'];
	}
	if ($vbulletin->GPC_exists['lastvisit']) {
		$pagenavscript .= "&amp;lastvisit=".$vbulletin->GPC['lastvisit'];
		$sortreturnbit["lastvisit"] = $vbulletin->GPC['lastvisit'];
	}
	if ($vbulletin->GPC_exists['ratings']) {
		$pagenavscript .= "&amp;ratings=".$vbulletin->GPC['ratings'];
		$sortreturnbit["ratings"] = $vbulletin->GPC['ratings'];
	}
	if ($vbulletin->GPC_exists['userid']) {
		$pagenavscript .= "&amp;userid=".$vbulletin->GPC['userid'];
		$sortreturnbit["userid"] = $vbulletin->GPC['userid'];
	}

	$pagenav = construct_page_nav($pagenumber, $thispage, $nhits, $pagenavscript, "&amp;pp=$thispage");

	$linkratingspopupbit = "";
	if ($links_defaults["dropdown_comment_and_rate"]>0) {
		$linkratings = ldm_get_ratingsbits($hitids, $pagenumber, 0);
		$linkratingspopupbit = implode("", $linkratings);
	}

	$pcatid   = "";
	$catstyle = 1;
	$catclosed = 0;

	$links_permissions["can_add_link"] = $links_permissions["can_edit_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	$sortnav = $viewcatid==$RND_CAT ? 0 : 1;
	if (!$linklistbit and !is_numeric($sort)) {
		$sortnav = 0;
	}
	if ($sortnav) {
		$sortvar = "sort";
		$sortsize = 1;
		$sortset = $sort;
		$sortsubmit = 1;
		$sortreturnbit = ldm_make_hidden_vars($sortreturnbit);
		eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");
	}

	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = ldm_construct_category_list(array(-1), "links_catjump", 0, "catid", "catid", 1);
	}

	unset($emptylistbit);
	unset($linkerrorbit);
	if (!$linklistbit) {
		if (is_numeric($sort)) {
			$emptylistbit = $vbphrase['ll_zerohits_sort'];
		}
		else {
			switch ($viewcatid) {
			case $FAVS_CAT: $emptylistbit = $vbphrase['ll_zerohits_favs']; break;
			case $BASE_CAT: break;
			default: $emptylistbit = $vbphrase['ll_zerohits_sort']; break;
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('ldm_find_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	$script = SEARCH_SCRIPT;

// drop through to common code for link/find/show
}

// #################### Execute a Search

if ($this_action == "show") {

function ldm_search_keywords($sstring, $findall) {
	global $vbulletin;

	$words = preg_split("/[\s,]+/u", $sstring);
	if (!count($words)) return array(-1);

	$query = "SELECT ltok.linkid AS linkid
			FROM ".THIS_TABLE."linksltok AS ltok
			LEFT JOIN ".THIS_TABLE."linkskeys AS lkeys
			ON lkeys.keyid=ltok.keyid
			WHERE
			";

	if ($findall==1) {
		$keywords = array();
		foreach ($words as $word) {
			$thisword = trim(str_replace("*", "%", $word));
			$keywords[] = "lkeys.keyword LIKE '".$vbulletin->db->escape_string($thisword)."'";
		}
		$asb = $vbulletin->db->query_read($query . implode(" OR ", $keywords));
		$idlist = array(-1);
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$idlist[] = $row['linkid'];
		}
	}
	else {
		unset($idlist);
		foreach ($words as $word) {
			$thisword = trim(str_replace("*", "%", $word));
			$keywords = "lkeys.keyword LIKE '".$vbulletin->db->escape_string($thisword)."'";
			$asb = $vbulletin->db->query_read($query . $keywords);
			$thisidlist = array();
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$thisidlist[] = $row['linkid'];
			}
			if (!isset($idlist)) {
				$idlist = $thisidlist;
			}
			else {
				$idlist = array_intersect($idlist, $thisidlist);
			}
		}
		if (!count($idlist)) {
			$idlist = array(-1);
		}
	}

	$idlist = array_unique($idlist);
	return $idlist;
}

function ldm_search_descwords($sstring, $findall) {
	global $vbulletin;
	global $links_defaults;

	$ids = array(-1);
	if ($links_defaults["match_using_like"]) {

		switch ($findall) {
		case 1:
			$query = "";
			$nwords = preg_match_all("/([\*\pL\pN\pS]+)/u", $sstring, $words);
			foreach ($words[1] as $word) {
				$thisword = trim(str_replace("*", "%", $word));
				$query .= ($query ? " OR " : "").
					"(link.linkname LIKE '%".$vbulletin->db->escape_string($thisword)."%' OR link.linkdesc LIKE '%".$vbulletin->db->escape_string($thisword)."%')";
			}
			break;
		case 2:
			$query = "";
			$nwords = preg_match_all("/([\*\pL\pN\pS]+)/u", $sstring, $words);
			foreach ($words[1] as $word) {
				$thisword = trim(str_replace("*", "%", $word));
				$query .= ($query ? " AND " : "").
					"(link.linkname LIKE '%".$vbulletin->db->escape_string($thisword)."%' OR link.linkdesc LIKE '%".$vbulletin->db->escape_string($thisword)."%')";
			}
			break;
		case 3:
			$thisword = trim(str_replace("*", "%", $sstring));
			$query = "(link.linkname LIKE '%".$vbulletin->db->escape_string($thisword)."%' OR link.linkdesc LIKE '%".$vbulletin->db->escape_string($thisword)."%')";
			break;
		}

	}
	else {

		switch ($findall) {
		case 1:
			$query =
				"MATCH (link.linkname, link.linkdesc) AGAINST ('".$vbulletin->db->escape_string($sstring)."'".
				(defined('CANDO_BOOLEAN') ? " IN BOOLEAN MODE" : "").")";
			break;
		case 2:
			$query =
				"MATCH (link.linkname, link.linkdesc) AGAINST ('";
			$nwords = preg_match_all("/([\*\pL\pN\pS]+)/u", $sstring, $words);
			foreach ($words[1] as $word) {
				$query .= " +".$vbulletin->db->escape_string($word);
			}
			$query .= "'".(defined('CANDO_BOOLEAN') ? " IN BOOLEAN MODE" : "").")";
			break;
		case 3:
			$query =
				"MATCH (link.linkname, link.linkdesc) AGAINST ('\"".$vbulletin->db->escape_string($sstring)."\"'".
				(defined('CANDO_BOOLEAN') ? " IN BOOLEAN MODE" : "").")";
			break;
		}

	}

	if ($query) {
		$query = "SELECT link.linkid AS linkid
			FROM ".THIS_TABLE."linkslink AS link
			WHERE ".$query;

		$asb = $vbulletin->db->query_read($query);
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$ids[] = $row['linkid'];
		}
	}

	return $ids;

}

function ldm_search_entwords($sstring, $findall) {
	global $vbulletin;
	global $links_defaults;

	$ids = array(-1);
	if ($links_defaults["match_using_like"]) {

		switch ($findall) {
		case 1:
			$query = array();
			$nwords = preg_match_all("/([\*\pL\pN\pS]+)/u", $sstring, $words);
			foreach ($words[1] as $word) {
				$thisword = $vbulletin->db->escape_string(trim(str_replace("*", "%", $word)));
				$query[] =
					"(entity.entitytype = " . ENTITY_TYPE_TEXT . " AND entity.entityvalue LIKE '%" . $thisword . "%')" .
					" OR " .
					"(entity.entitytype <> " . ENTITY_TYPE_TEXT . " AND entity.entitydesc LIKE '%" . $thisword . "%')";
			}
			$query = implode(" OR ", $query);
			break;
		case 2:
			$query = array();
			$nwords = preg_match_all("/([\*\pL\pN\pS]+)/u", $sstring, $words);
			foreach ($words[1] as $word) {
				$thisword = $vbulletin->db->escape_string(trim(str_replace("*", "%", $word)));
				$query[] =
					"(entity.entitytype = " . ENTITY_TYPE_TEXT . " AND entity.entityvalue LIKE '%" . $thisword . "%')" .
					" OR " .
					"(entity.entitytype <> " . ENTITY_TYPE_TEXT . " AND entity.entitydesc LIKE '%" . $thisword . "%')";
			}
			$query = implode(" AND ", $query);
			break;
		case 3:
			$thisword = $vbulletin->db->escape_string(trim(str_replace("*", "%", $sstring)));
			$query =
					"(entity.entitytype = " . ENTITY_TYPE_TEXT . " AND entity.entityvalue LIKE '%" . $thisword . "%')" .
					" OR " .
					"(entity.entitytype <> " . ENTITY_TYPE_TEXT . " AND entity.entitydesc LIKE '%" . $thisword . "%')";
			break;
		}

	}
	else {

		$canbool = (defined('CANDO_BOOLEAN') ? " IN BOOLEAN MODE" : "");
		switch ($findall) {
		case 1:
			$thisword = $vbulletin->db->escape_string($sstring);
			$query =
                "(" .
                    "entity.entitytype = " . ENTITY_TYPE_TEXT .
                    " AND " .
                    " MATCH (entity.entityvalue, entity.entitydesc) AGAINST ('" . $thisword . "' " . $canbool . ")" .
                ")" .
                " OR " .
                "(" .
                    "entity.entitytype <> " . ENTITY_TYPE_TEXT .
                    " AND " .
                    " MATCH (entity.entitydesc) AGAINST ('" . $thisword . "' " . $canbool . ")" .
                ")";
			break;
		case 2:
			$query =
				"MATCH (entity.entityvalue, entity.entitydesc) AGAINST ('";
			$nwords = preg_match_all("/([\*\pL\pN\pS]+)/u", $sstring, $words);
			$thisword = "";
			foreach ($words[1] as $word) {
				$thisword .= " +" . $vbulletin->db->escape_string($word);
			}
			$query =
                "(" .
                    "entity.entitytype =  " . ENTITY_TYPE_TEXT .
                    " AND " .
                    " MATCH (entity.entityvalue, entity.entitydesc) AGAINST ('\"" . $thisword . "\"' " . $canbool . ")" .
                ")" .
                " OR " .
                "(" .
                    "entity.entitytype <> " . ENTITY_TYPE_TEXT .
                    " AND " .
                    " MATCH (entity.entitydesc) AGAINST ('" . $thisword . "' " . $canbool . ")" .
                ")";
			break;
		case 3:
			$thisword = $vbulletin->db->escape_string($sstring);
			$query =
                "(" .
                    "entity.entitytype =  " . ENTITY_TYPE_TEXT .
                    " AND " .
                    " MATCH (entity.entityvalue, entity.entitydesc) AGAINST ('\"" . $thisword . "\"' " . $canbool . ")" .
                ")" .
                " OR " .
                "(" .
                    "entity.entitytype <> " . ENTITY_TYPE_TEXT .
                    " AND " .
                    " MATCH (entity.entitydesc) AGAINST ('\"" . $thisword . "\"' " . $canbool . ")" .
                ")";
			break;
		}

	}

	if ($query) {
		$query = "SELECT entity.entityname AS entityname, entity.linkid AS linkid, ltoc.catid AS catid
			FROM ".THIS_TABLE."linksentities AS entity
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON entity.linkid=ltoc.linkid
			WHERE " . $query
			;

		$catperms = array();
		$asb = $vbulletin->db->query_read($query);
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$thiscatid = $row['catid'];
			if (!isset($catperms[$thiscatid])) {
				$catperms[$thiscatid] = ldm_lookup_permission($row['catid'],'can_view_entities');
			}
			if ($catperms[$thiscatid]) {
				$ids[$row['linkid']] = $row['linkid'];
			}
		}
	}

	return $ids;

}

	$vbulletin->input->clean_array_gpc('r', array(
		'beforeafter' 	=> TYPE_INT,
		'catlist'		=> TYPE_STR,
		'catsearch'		=> TYPE_ARRAY_INT,
		'childcats'		=> TYPE_INT,
		'deletesearch'	=> TYPE_INT,
		'desc'			=> TYPE_INT,
		'doi'			=> TYPE_STR,
		'entity'		=> TYPE_STR,
		'ents'			=> TYPE_INT,
		'filetype'		=> TYPE_STR,
		'forum' 		=> TYPE_INT,
		'humanverify' 	=> TYPE_ARRAY,
		'keys'			=> TYPE_INT,
		'keyword'		=> TYPE_STR,
		'literal'		=> TYPE_INT,
		'mysearch'		=> TYPE_INT,
		'savename' 		=> TYPE_STR,
		'savesearch'	=> TYPE_INT,
		'savesearchid'	=> TYPE_INT,
		'search'		=> TYPE_STR,
		'searchdate'	=> TYPE_STR,
		'searchfields'	=> TYPE_ARRAY_STR,
		'searchid'		=> TYPE_STR,
		'searchmenu'	=> TYPE_INT,
		'sort'			=> TYPE_STR,
		'retrieve'		=> TYPE_INT,
		'user' 			=> TYPE_STR,
		'userid'		=> TYPE_INT,
	));

	($hook = vBulletinHook::fetch_hook('ldm_show_begin')) ? eval($hook) : false;

	if (!$links_permissions["can_search_link"]) {
		print_no_permission();
		exit;
	}

// Take care - VB version specific
	if (VALID_VB_VERSION=="3.7") {
    	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_search']) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verify =& vB_HumanVerify::fetch_library($vbulletin);
    		if (!$verify->verify_token($vbulletin->GPC['humanverify'])) {
	    		$errors[] = fetch_error($verify->fetch_error());
		    	$vbulletin->url = $SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=search';
			    eval(print_standard_redirect($errors[0],0, 1));
			}
		}
	}
	if (VALID_VB_VERSION=="3.8") {
    	if (!$vbulletin->userinfo['userid'] AND fetch_require_hvcheck('search')) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verify =& vB_HumanVerify::fetch_library($vbulletin);
    		if (!$verify->verify_token($vbulletin->GPC['humanverify'])) {
	    		$errors[] = fetch_error($verify->fetch_error());
		    	$vbulletin->url = $SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=search';
			    eval(print_standard_redirect($errors[0],0, 1));
			}
		}
	}
// Take care - VB version specific

	foreach($vbulletin->GPC['searchfields'] as $searchfield) {
		$vbulletin->GPC[$searchfield] = 1;
		$vbulletin->GPC_exists[$searchfield] = 1;
	}

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_search']);
	$navbits[$SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=search'] = $vbphrase['ll_search'];
	$navbits[""] = $vbphrase['ll_searchresults'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = ldm_lookup_forum_protections($can_bypass);
	construct_forum_jump();

	$search = array();

	if ($vbulletin->GPC_exists['searchid']) {

		$query = "
			SELECT *
			FROM ".THIS_TABLE."linkssearch
			WHERE searchid=".$vbulletin->GPC['searchid']."
			AND   (searchuserid=".$vbulletin->userinfo['userid']." OR searchmenu='2')
			LIMIT 1
			";
		$asb = $vbulletin->db->query_read($query);
		if (!$vbulletin->db->num_rows($asb)) {
			$vbulletin->url = $SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=search";
			eval(print_standard_redirect(construct_phrase($vbphrase['ll_error_searchid'], $vbulletin->GPC['searchid']),0));
			exit;
		}
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$search = unserialize($row['searchparam']);
		}

	}
	elseif ($vbulletin->GPC_exists['mysearch']) {

		if (!isset($ldm_myprofilesearch[$vbulletin->GPC['mysearch']])) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_mysearch_empty'], "profile.php?".$vbulletin->session->vars['sessionhash']."do=editprofile")));
			exit;
		}

		$search['string'] = $ldm_myprofilesearch[$vbulletin->GPC['mysearch']]['text'];

		if (!$search['string']) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_mysearch_empty'], "profile.php?".$vbulletin->session->vars['sessionhash']."do=editprofile")));
			exit;
		}

		$search['literal']	= $links_defaults['profile_search_all'];
		$search['desc'] = $links_defaults['default_search_desc'];
		$search['keys']	= $links_defaults['default_search_keys'];
		$search['ents']	= $links_defaults['default_search_ents'];
		$search['sort'] = 'd';
		$search['forum'] = "";
		$search['doi']  = "";
		$search['user']  = "";
		$search['userid']  = 0;
		$search['type']  = "";
		$search['when'] = "";
		$search['after'] = 1;
		$search['savename'] = $ldm_myprofilesearch[$vbulletin->GPC['mysearch']]['title'];
		$search['searchid'] = "";
		$search['cats'] = "";
		$search['child']  = "";
		$search['ents'] = "";

	}
	elseif ($vbulletin->GPC_exists['entity']) {

		$search['string'] = $vbulletin->GPC['entity'];
		$search['literal'] = ($vbulletin->GPC_exists['literal'] ? $vbulletin->GPC['literal'] : 3);
		$search['desc'] = 0;
		$search['keys'] = 0;
		$search['ents'] = 1;
		$search['sort'] = $vbulletin->GPC['sort'] ? $vbulletin->GPC['sort'] : 'd';
		$search['forum'] = "";
		$search['doi']  = "";
		$search['user']  = "";
		$search['userid']  = 0;
		$search['type']  = "";
		$search['when'] = "";
		$search['after'] = 1;
		$search['savename'] = "";
		$search['searchid'] = "";
		$search['cats'] = "";
		$search['child']  = "";

	}
	elseif ($vbulletin->GPC_exists['keyword']) {

		$search['string'] = $vbulletin->GPC['keyword'];
		$search['literal'] = ($vbulletin->GPC_exists['literal'] ? $vbulletin->GPC['literal'] : 1);
		$search['desc'] = 0;
		$search['keys'] = 1;
		$search['ents'] = 0;
		$search['sort'] = $vbulletin->GPC['sort'] ? $vbulletin->GPC['sort'] : 'd';
		$search['forum'] = "";
		$search['doi']  = "";
		$search['user']  = "";
		$search['userid']  = 0;
		$search['type']  = "";
		$search['when'] = "";
		$search['after'] = 1;
		$search['savename'] = "";
		$search['searchid'] = "";
		$search['cats'] = "";
		$search['child']  = "";
		$search['ents'] = "";

	}
	else {

		$search['string'] = urldecode($vbulletin->GPC['search']);
		$search['literal'] = ($vbulletin->GPC['literal'] ? $vbulletin->GPC['literal'] : $links_defaults['default_search_all']);
		$search['desc']  = $vbulletin->GPC['desc'];
		$search['keys']  = $vbulletin->GPC['keys'];
		$search['ents']  = $vbulletin->GPC['ents'];
		$search['sort']  = $vbulletin->GPC['sort'];
		$search['forum'] = $vbulletin->GPC['forum'];
		$search['doi']   = $vbulletin->GPC['doi'];
		$search['user']  = htmlspecialchars_uni($vbulletin->GPC['user']);
		$search['userid']  = $vbulletin->GPC['userid'];
		$search['type']  = $vbulletin->GPC['filetype'];
		$search['when']	 = $vbulletin->GPC['searchdate'];
		$search['after'] = $vbulletin->GPC['beforeafter'];
		$search['savename'] = $vbulletin->GPC['savename'];
		$search['searchid'] = $vbulletin->GPC['searchid'];

		$search['cats'] = "";
		$search['child']  = "";
		if ($vbulletin->GPC_exists['catsearch'] and !in_array(-1, $vbulletin->GPC['catsearch'])) {
			$search['cats']   = $vbulletin->GPC['catsearch'];
			$search['child']  = $vbulletin->GPC['childcats'];
			if ($search['child']) {
				$ccats = array();
				foreach ($linkscat as $id=>$cat) {
					if (in_array($id, $search['cats'])) continue;
					$pcat = explode(',', $cat['parentlist']);
					foreach ($search['cats'] as $searchcat) {
						if (in_array($searchcat, $pcat)) {
							$ccats[] = $id; break;
						}
					}
				}
				$search['cats'] = array_merge($search['cats'], $ccats);
			}
			if (!count($search['cats'])) $search['cats'][] = -1;
			$search['cats'] = preg_replace("/\s/", "", implode(',', $search['cats']));

		}
		elseif ($vbulletin->GPC_exists['catlist']) {
			$search['cats'] = $vbulletin->GPC['catlist'];
		}

	}

	$squery = array();
	$squery[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";

	if ($search['string']) {
		$keyed_ids = array(-1);
		if ($search['keys'] and $search['string']) {
			$keyed_ids = ldm_search_keywords($search['string'], $search['literal']);
		}

		$desc_ids = array(-1);
		if ($search['desc'] and $search['string']) {
			$desc_ids = ldm_search_descwords($search['string'], $search['literal']);
		}

		$ent_ids = array(-1);
		if ($search['ents'] and $search['string']) {
			$ent_ids = ldm_search_entwords($search['string'], $search['literal']);
		}

		$squery[] =
			"(".
				"link.linkid IN (" . implode(",", $keyed_ids) . ")" .
				" OR " .
				"link.linkid IN (" . implode(",", $desc_ids)  . ")" .
				" OR " .
				"link.linkid IN (" . implode(",", $ent_ids)  . ")" .
			")";
	}

	if (is_numeric($search['sort'])) {
		$sortsince = TIMENOW - $search['sort']*24*60*60;
	}
	else {
		$sortsince = "";
	}

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		$squery[] = "link.linkstatus != $LINK_HIDDEN";
		if (!$vbulletin->userinfo['userid']) {
			$squery[] = "link.linkmoderate = ".$LINK_ACCEPTED;
		}
		else {
			$squery[] = "(link.linkmoderate = ".$LINK_ACCEPTED." OR
				(link.linkmoderate = ".$LINK_TO_MODERATE." AND link.linkuserid = ".$vbulletin->userinfo['userid']."))
			";
		}
	}

	if ($search['cats']) {
		$squery[] = "ltoc.catid IN (".$search['cats'].")";
	}

	if ($search['doi']) {
		$squery[] = "link.linkdoi LIKE ('%".$vbulletin->db->escape_string($search['doi'])."%')";
	}

	if ($search['user']) {
		$squery[] = "link.linkusername LIKE ('".$vbulletin->db->escape_string($search['user'])."')";
	}
	elseif ($search['userid']) {
		$row = $vbulletin->db->query_first("
			SELECT userid, username
			FROM ".TABLE_PREFIX."user AS user
			WHERE userid = '".$vbulletin->db->escape_string($search['userid'])."'
			LIMIT 1
			");
		if (isset($row['userid'])) {
			$search['user']=$row['username'];
			$squery[] = "link.linkusername LIKE ('".$vbulletin->db->escape_string($search['user'])."')";
		}
	}

	if ($search['forum']) {
		if (preg_match ( "/^\s*-*\d+\s*$/", $search['forum'])) {
			$squery[] = "link.linkforum IN (".$search['forum'].")";
		}
		else {
			eval(standard_error($vbphrase['ll_error_forum'].$vbphrase['ll_goback']));
			exit;
		}
	}

	if ($search['type']) {
		if (preg_match("/[^ \.,;\*a-z0-9]/", $search['type'])) {
			eval(standard_error($vbphrase['ll_error_filetype'].$vbphrase['ll_goback']));
			exit;
		}
		else {
			preg_match_all("/[a-z0-9]+/", $search['type'], $type);
			if (count($type[0])) {
				$types = implode("' OR link.linkurl LIKE '%.", $type[0]);
				$squery[] = "(link.linkurl LIKE '%.".$types."')";
			}
		}
	}

	if ($search['when']) {
		$when = ($search['when']<0 ? $vbulletin->userinfo['lastvisit'] : TIMENOW-$search['when']*24*60*60);
		$squery[] = "link.linkdate ".($search['after']==-1 ? "<" : ">=").$when;
	}

	$sorder = ldm_get_sortsql($search['sort'], 0);

	$viewcatid = $BASE_CAT;
	$catlistbit   = "";

	cache_LDMfavourites();
	cache_LDMnominations();

	$search['query'] = ldm_get_mainsql($squery, $sortsince, 0, $sorder, 0, 1, 1);

	$linklistarray = array();
	$ncols = ldm_entrybit_columns($links_defaults["search_linkbit"]);
	$thispage = ($ncols<=1) ? $perpage : $ncols*floor(($perpage+$ncols-1)/$ncols);

	$highlight = array('string'=>$search['string'], 'literal'=>$search['literal'], 'keys'=>$search['keys'], 'desc'=>$search['desc'], 'entities'=>$search['ents']);
	$entrybit_options = array(
		'highlight'=>$highlight, 'showcatname'=>1, 'forcedisplayorder'=>1, 'forcereview'=>$links_defaults['links_jump_comment'],
		'viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid,
		);
	$nhits = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $links_defaults['search_linkbit'], $search['query'], $entrybit_options, $pagenumber, $perpage);

	$linklistbit = ldm_map_listbit_to_grid($linklistarray, $ncols, 1);

	$linkratingspopupbit = "";
	if ($links_defaults["dropdown_comment_and_rate"]>0) {
		$linkratings = ldm_get_ratingsbits($hitids, $pagenumber, 0);
		$linkratingspopupbit = implode("", $linkratings);
	}

	$viewcatname = $vbphrase['ll_searchresults'];
	if ($search['savename']) {
		if ($vbulletin->GPC_exists['mysearch']) {
			$viewcatname = construct_phrase($vbphrase['ll_searchprof'], $search['savename']).'<br />';
		}
		else {
			$viewcatname = construct_phrase($vbphrase['ll_searchid'], $search['savename']).'<br />';
		}
	}


// Process search save
	if ($vbulletin->GPC['deletesearch'] and $vbulletin->GPC['savesearchid']) {
		$query = "
			DELETE FROM ".THIS_TABLE."linkssearch
			WHERE searchid=".$vbulletin->GPC['savesearchid']."
			";
		$vbulletin->db->query_write($query);
	}
	elseif ($vbulletin->GPC['savesearch']) {
// Get rid of the existing saved search
		if ($vbulletin->GPC['savesearchid']) {
			$query = "
				DELETE FROM ".THIS_TABLE."linkssearch
				WHERE searchid=".$vbulletin->GPC['savesearchid']."
				";
			$vbulletin->db->query_write($query);
		}
// Per-user search names must be unique
		$query = "
			DELETE FROM ".THIS_TABLE."linkssearch
			WHERE searchname='".$vbulletin->db->escape_string($search['savename'])."'
			AND searchuserid=".$vbulletin->userinfo['userid']."
			";
		$vbulletin->db->query_write($query);
// Create the new saved search
		$searchmenu = $vbulletin->GPC['searchmenu'];
		$query = "
			INSERT INTO ".THIS_TABLE."linkssearch
			SET
				searchname='".$vbulletin->db->escape_string($search['savename'])."',
				searchparam='".$vbulletin->db->escape_string(serialize($search))."',
				searchusername='".$vbulletin->db->escape_string($vbulletin->userinfo['username'])."',
				searchuserid='".$vbulletin->userinfo['userid']."',
				searchtime='".TIMENOW."',
				searchhits='".$nhits."',
				searchmenu='".$searchmenu."'
			";
		$vbulletin->db->query_write($query);
		$search['searchid'] = $vbulletin->db->insert_id();
// Update the cached menu
		if ($links_defaults['show_searchmenu']) {
			require_once(DIR . '/includes/local_links_misc.php');
			$ldm_mysavedsearch = ldm_make_mysavedsearch();
		}
	}

	$message = "";

	if ($search['string']) {
		$searchwhat = array();
		if ($search['desc']) $searchwhat[] = $vbphrase['ll_searchdesc'];
		if ($search['keys']) $searchwhat[] = $vbphrase['ll_searchkeys'];
		if ($search['ents']) $searchwhat[] = $vbphrase['ll_searchents'];
		$searchwhat = implode(', ', $searchwhat);
		switch ($search['literal']) {
			case 1: $searchwhere = $vbphrase['ll_searchanywords']; break;
			case 2: $searchwhere = $vbphrase['ll_searchallwords']; break;
			case 3: $searchwhere = $vbphrase['ll_searchliteral']; break;
		}
		$message .= construct_phrase($vbphrase['ll_searchmatching'], htmlspecialchars_uni($search['string'],ENT_QUOTES), $searchwhat, $searchwhere);
		$message .= '<br />';
	}

	if ($search['forum'])  $message .= $vbphrase['ll_asso_forum'].' '.$vbulletin->forumcache[$search['forum']][title].'<br />';

	if ($search['doi']) {
		$message .= $vbphrase['ll_digitalobjectidentifier'].' '.$search['doi'].'<br />';
	}

	if ($search['user']) {
		$message .= $vbphrase['ll_submitby'].' '.$search['user'].'<br />';
	}

	if ($search['cats']) {
		$message .= $vbphrase['ll_cats'].': ';
		$thesecats = array();
		foreach ($vbulletin->GPC['catsearch'] as $thiscat) $thesecats[] = $linkscat[$thiscat]['catname_clean'];
		$message .= implode(', ', $thesecats);
		if ($vbulletin->GPC['childcats']) $message .= ' ('.$vbphrase['ll_searchchildcats'].')';
		$message .= '<br />';
	}

	if ($search['type']) {
		$message .= $vbphrase['ll_filetypes'].' '.$search['type'].'<br />';
	}

	if ($search['when']) {
		$message .= $vbphrase['ll_date'].' '.
			ldm_date($vbulletin->options['dateformat'], $when).
			' '.
			($search['after']<0 ? $vbphrase['ll_and_older'] : $vbphrase['ll_and_newer']) . '<br />';
	}

	$message .= construct_phrase($vbphrase['ll_searchhits'], ($nhits ? $nhits : 0));

	$viewcatdesc = $message;
	$viewcattext = $message;

	$viewcatid = -2;
	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;

	$pagenav = construct_page_nav($pagenumber, $thispage, $nhits,
		$SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=show".
							"&amp;sort=".urlencode($search['sort']).
			($search['string'] ? "&amp;search=".urlencode($search['string']) : "").
			($search['literal'] ? "&amp;literal=".$search['literal'] : "").
			($search['desc'] ? "&amp;desc=".$search['desc'] : "").
			($search['ents'] ? "&amp;ents=".$search['ents'] : "").
			($search['keys'] ? "&amp;keys=".$search['keys'] : "").
			($search['forum'] ? "&amp;forum=".$search['forum'] : "").
			($search['doi'] ? "&amp;doi=".$search['doi'] : "").
			($search['user'] ? "&amp;user=".$search['user'] : "").
			($search['when'] ? "&amp;searchdate=".$search['when'] : "").
			($search['after'] ? "&amp;beforeafter=".$search['after'] : "").
			($search['type'] ? "&amp;filetype=".urlencode($search['type']) : "").
			($search['cats'] ? "&amp;catlist=".urlencode($search['cats']) : "").
			($search['child'] ? "&amp;childcats=".$search['child'] : "").
			($search['searchid'] ? "&amp;searchid=".$search['searchid'] : "").
							"&amp;pp=$thispage");

	$sortnav = 0;
	$sortvar = "sort";
	$sortsize = 1;
	$sortset = $search['sort'];
	$sortsubmit = 1;
	$sortvars = array("action"=>"show", "page"=>"1", "pp"=>$perpage);

	if ($search['string'])	 $sortvars["search"] = urlencode($search['string']);
	if ($search['literal'])	 $sortvars["literal"] = $search['literal'];
	if ($search['desc'])	 $sortvars["desc"] = $search['desc'];
	if ($search['ents'])	 $sortvars["ents"] = $search['ents'];
	if ($search['keys'])	 $sortvars["keys"] = $search['keys'];
	if ($search['forum'])	 $sortvars["forum"] = $search['forum'];
	if ($search['doi'])		 $sortvars["doi"] = $search['doi'];
	if ($search['user'])	 $sortvars["user"] = $search['user'];
	if ($search['type'])	 $sortvars["filetype"] = urlencode($search['type']);
	if ($search['cats'])	 $sortvars["catlist"] = urlencode($search['cats']);
	if ($search['child'])	 $sortvars["childcats"] = urlencode($search['child']);
	if ($search['when'])	 $sortvars["searchdate"] = $search['when'];
	if ($search['after'])	 $sortvars["beforeafter"] = $search['after'];
	if ($search['searchid']) $sortvars["searchid"] = $search['searchid'];

	unset($emptylistbit);
	$sortorderbit = "";
	if (!$linklistbit) {
		$emptylistbit = $vbphrase['ll_zerohits_sort'];
	} else {
		$sortnav = 1;
		$sortreturnbit = ldm_make_hidden_vars($sortvars);
		eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");
	}
	if ($links_defaults['category_jump_menu'] and count($linkscat)) {

		$catjumpbit = ldm_construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	$script = SEARCH_SCRIPT;
	$script_action="show";

	$allow = ldm_check_user_allowances(0);

	$viewcatautocreate = "";
	eval("\$viewcatextra = \"".fetch_template('links_catbit_extras')."\";");
	$viewcatextra = ldm_strip_template($viewcatextra);

	($hook = vBulletinHook::fetch_hook('ldm_show_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

// drop through to common code for link/find/show
}

// #################### Common closure code for link/find/show

if ($this_action == "like" || $this_action == "find" || $this_action == "show") {

	($hook = vBulletinHook::fetch_hook('ldm_search_end')) ? eval($hook) : false;
	ldm_process_placed_blocks();

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_main')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");
	print_output($output);
	exit;
}


// #################### Edit Saved Searches

if ($this_action == "editsearches") {

	if (!$links_permissions["can_search_link"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'manage'	=> TYPE_STR,
		));

	($hook = vBulletinHook::fetch_hook('ldm_editsearch_begin')) ? eval($hook) : false;

	$this_navigation_title = $master_title;
	construct_forum_jump();

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_search'].' '.$master_title);
	$navbits[$SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=search'] = $vbphrase['ll_search'].' '.$master_title;
	$navbits[] = $vbphrase['ll_managesearches'];

	$to_manage = $vbulletin->GPC['manage'];

	switch ($to_manage) {
	case 'saved':

		$searchbits = "";
		$query = "
			SELECT *
			FROM ".THIS_TABLE."linkssearch
			WHERE searchuserid=".$vbulletin->userinfo['userid']."
			ORDER BY searchname ASC
			";
		$asb = $vbulletin->db->query_read($query);
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$search = unserialize($row['searchparam']);
			$searchid = $row['searchid'];
			$searchcreated = ldm_date($vbulletin->options['dateformat'], $row['searchtime']);
			$searchmenu = $row['searchmenu'];
			if (!$search['cats']) {
				$searchcats = $vbphrase['ll_searchallcats'];
			}
			else {
				$searchcats = array();
				$catlist = explode(',', $search['cats']);
				foreach ($catlist as $thiscat) {
					$searchcats[] = $linkscat[$thiscat]['catname'];
				}
				$searchcats = implode(', ', $searchcats);
			}
			eval("\$searchbits .= \"".fetch_template('links_editsearch_one')."\";");
		}
		break;

	case 'profiled':
		break;
	}

	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = ldm_construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	$viewcatid = -2;
	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	($hook = vBulletinHook::fetch_hook('ldm_editsearch_end')) ? eval($hook) : false;

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_editsearch')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### Do Edit Saved Searches

if ($this_action == "doeditsearches") {

	if (!$links_permissions["can_search_link"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'manage' => TYPE_STR,
		'status' => TYPE_ARRAY_INT,
		));

	$url = $SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=editsearches";
	$to_manage = $vbulletin->GPC['manage'];

	$searches = array();
	$query = "
		SELECT searchid, searchuserid
		FROM ".THIS_TABLE."linkssearch
		WHERE searchuserid=".$vbulletin->userinfo['userid']."
		";
	$asb = $vbulletin->db->query_read($query);
	while ($row=$vbulletin->db->fetch_array($asb)) {
		$searches[$row['searchid']]['status'] = 0;
		$searches[$row['searchid']]['searchuserid'] = $row['searchuserid'];
	}

// Check that no funny things are going on
	foreach ($vbulletin->GPC['status'] as $thisid=>$thisstatus) {
		if (!isset($searches[$thisid]['status'])) {
			print_no_permission();
			exit;
		}
		if ($vbulletin->userinfo['userid']!=$searches[$thisid]['searchuserid']) {
			print_no_permission();
			exit;
		}
		if ($thisstatus==2 and !$links_permissions["can_admin_links"]) {
			print_no_permission();
			exit;
		}
		$searches[$thisid]['status'] = $thisstatus;
	}

	foreach ($searches as $thisid=>$thissearch) {
		$thisstatus = $thissearch['status'];
		switch ($thisstatus) {
		case -1: // delete
			$query = "
				DELETE
				FROM ".THIS_TABLE."linkssearch
				WHERE searchid=".$thisid."
				";
			$vbulletin->db->query_write($query);
			unset($searches[$thisid]);
			break;

		default:   // change menu display status
			$query = "
				UPDATE ".THIS_TABLE."linkssearch
				SET
					searchmenu='".intval($thisstatus)."'
				WHERE searchid='".$thisid."'
				";
			$vbulletin->db->query_write($query);
			break;
		}
	}

	if (count($searches)) {
		$url = $SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=editsearches&amp;manage=".$to_manage;
	}
	else {
		$url = $SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=search";
	}
	$vbulletin->url = $url;
	eval(print_standard_redirect($vbphrase['ll_accepted'],0));

	exit;
}

/* ===========================================================================*/
// Fall through
/* ===========================================================================*/

$vbulletin->url = $LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'];
eval(print_standard_redirect($vbphrase['ll_error_command'],0));
exit;

?>