<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT', 'local_links_ajax');
define('CSRF_PROTECTION', true);
define('CSRF_SKIP_LIST', 'swfupload'); // because of problems with flash scripts assuming IE

define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

$phrasegroups = array('posting');

$specialtemplates = array(
	'attachmentcache',
	'bbcodecache',
	'ldm_admin',
	'ldm_cats',
);

$globaltemplates = array();

$actiontemplates = array();

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

($hook = vBulletinHook::fetch_hook('ldm_ajax_start')) ? eval($hook) : false;

if (strtolower($vbulletin->userinfo['lang_charset']) == 'iso-8859-1') {
	$ajax_charset = 'windows-1252';
}
else {
	$ajax_charset = $vbulletin->userinfo['lang_charset'];
}

$vbulletin->input->clean_array_gpc('r',
	array(
		'do' => TYPE_STR,
		'fragment' => TYPE_STR
		)
);

$action = $vbulletin->GPC['do'];

function ldm_clean_ajax_reply($reply) {
	$reply = str_replace('\\', '\\\\', $reply);
	$reply = str_replace("'", "\\'", $reply);
	$reply = str_replace("\r\n", "", $reply);
	$reply = str_replace("\n", "", $reply);
	return $reply;
}

/* ===========================================================================*/
// Keyword search
/* ===========================================================================*/

if ($action == 'keysearch') {

	($hook = vBulletinHook::fetch_hook('ldm_ajax_keysearch_begin')) ? eval($hook) : false;

	$vbulletin->GPC['fragment'] = convert_urlencoded_unicode($vbulletin->GPC['fragment']);

	if ($vbulletin->GPC['fragment'] != '' AND strlen($vbulletin->GPC['fragment']) >= 1) {
		$fragment = htmlspecialchars_uni($vbulletin->GPC['fragment']);
	}
	else {
		$fragment = '';
	}

	@header('Content-Type: text/xml' . ($ajax_charset != '' ? '; charset=' . $ajax_charset : ""));
	echo '<?xml version="1.0" encoding="' . $ajax_charset . '"?>' . "\r\n<keys>\r\n";

	if ($fragment != '') {
		$query = "
			SELECT lkeys.keyid AS keyid, lkeys.keyword AS keyword, COUNT(ltok.linkid) AS matches
			FROM " . THIS_TABLE . "linkskeys AS lkeys
			LEFT JOIN " . THIS_TABLE . "linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			WHERE lkeys.keyword LIKE('" . $vbulletin->db->escape_string_like($fragment) . "%')
			GROUP BY keyid
			ORDER BY keyword
			LIMIT 15
			";
		$keys = $vbulletin->db->query_read($query);
		while ($key = $vbulletin->db->fetch_array($keys)) {
			echo "\t<key keyid=\"$key[keyid]\">$key[keyword]: $key[matches]</key>\r\n";
		}
	}

	echo "</keys>";
}

/* ===========================================================================*/
// DOI search
/* ===========================================================================*/

if ($action == 'doisearch') {
	($hook = vBulletinHook::fetch_hook('ldm_ajax_doisearch_begin')) ? eval($hook) : false;

	$vbulletin->GPC['fragment'] = convert_urlencoded_unicode($vbulletin->GPC['fragment']);

	if ($vbulletin->GPC['fragment'] != '' AND strlen($vbulletin->GPC['fragment']) >= 1) {
		$fragment = htmlspecialchars_uni($vbulletin->GPC['fragment']);
	}
	else {
		$fragment = '';
	}

	@header('Content-Type: text/xml' . ($ajax_charset != '' ? '; charset=' . $ajax_charset : ""));
	echo '<?xml version="1.0" encoding="' . $ajax_charset . '"?>' . "\r\n<keys>\r\n";

	if ($fragment != '') {
		$query = "
			SELECT linkid, linkdoi
			FROM " . THIS_TABLE . "linkslink
			WHERE linkdoi LIKE('%" . $vbulletin->db->escape_string_like($fragment) . "%')
			ORDER BY linkdoi
			LIMIT 15
			";
		$keys = $vbulletin->db->query_read($query);
		while ($key = $vbulletin->db->fetch_array($keys)) {
			echo "\t<key keyid=\"$key[linkdoi]\">$key[linkdoi]</key>\r\n";
		}
	}

	echo "</keys>";
}

/* ===========================================================================*/
// Generalised fetch intended for use by plugins
/* ===========================================================================*/

if ($action == 'fetch') {

	$vbulletin->input->clean_array_gpc('r',
		array(
			'plugin' => TYPE_STR,
			'id' => TYPE_STR,
			'catid' => TYPE_INT,
			'linkid' => TYPE_INT,
			)
	);

	unset($ldm_ajax_reply);

	($hook = vBulletinHook::fetch_hook('ldm_ajax_fetch')) ? eval($hook) : false;

	if (isset($ldm_ajax_reply)) {
		$ldm_ajax_reply = ldm_clean_ajax_reply($ldm_ajax_reply);
		$ldm_ajax_reply = "var ldm_newinfo = '$ldm_ajax_reply'; var doalert = '';";
		echo $ldm_ajax_reply;
		exit;
	}
}

/* ===========================================================================*/
// Inline Comment and Ratings Handler
/* ===========================================================================*/

if ($action == 'inlinecomment') {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'vote' => TYPE_INT,
		'message' => TYPE_STR,
		'messageusername' => TYPE_STR,
		'messageuserid' => TYPE_INT,
		'newusername' => TYPE_STR,
		'rateid' => TYPE_INT,
		'ratesort' => TYPE_STR,
		'lpage' => TYPE_INT,
		'uniqueid' => TYPE_INT,
		'wysiwyg' => TYPE_BOOL,
	));

	if ($vbulletin->GPC['wysiwyg']) {
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else {
		$message =& $vbulletin->GPC['message'];
	}

	$lcomment  = ($message ? $vbulletin->db->escape_string($message) : '');
	$linkid	   = $vbulletin->GPC['linkid'];
	$linkvote  = $vbulletin->GPC['vote'];
	$lpage     = $vbulletin->GPC['lpage'];
	$rateid    = $vbulletin->GPC['rateid'];
	$ratesort  = $vbulletin->GPC['ratesort'];
	$viewcatid = $vbulletin->GPC['catid'];
	$uniqueid  = $vbulletin->GPC['uniqueid'];

	if (!$links_permissions["can_rate_link"]) {
		$ldm_ajax_reply =
			"doalert = ''; ".
			"";
		echo $ldm_ajax_reply;
		exit;
	}

	if (!$links_defaults['hide_rate'] and ($linkvote<$MIN_VOTE or $linkvote>$MAX_VOTE or (!$linkvote and $links_defaults['must_comment_and_rate']))) {
		$ldm_ajax_reply =
			"doalert = '".$vbphrase['ll_error_rating']."'; ".
			"";
		echo $ldm_ajax_reply;
		exit;
	}

	if (!$linkvote and !$lcomment) {
		$ldm_ajax_reply =
			"doalert = ''; ".
			"";
		echo $ldm_ajax_reply;
		exit;
	}

	require_once(DIR . '/includes/local_links_actions.php');
	$rates = ldm_insert_rate($linkid, $rateid, $linkvote, $message, $vbulletin->userinfo['username'], $vbulletin->userinfo['userid']);

	$linkratings = ldm_get_ratingsbits(array($linkid=>0), 1, 1);
	$ldm_newinfo = ldm_clean_ajax_reply($linkratings[$linkid]);

	$ldm_ajax_reply =
		"ldm_var[0] = 'inlinecommentdiv{$uniqueid}_entries'; ".
		"ldm_val[0] = '" . '<strong>'.construct_phrase($vbphrase[ll_rate_and_comment], $rates['numrate'], $rates['numcomment']).'</strong>' . "'; ".
		"ldm_var[1] = 'inlinecommentvote{$uniqueid}'; ".
		"ldm_val[1] = '" . ldm_clean_ajax_reply(ldm_strip_template($linkratings[$linkid])) . "'; ".
		"doalert = ''; ".
		"";

	echo $ldm_ajax_reply;
	exit;

}
/* ===========================================================================*/
// File upload processor used by swfupload plugin
/* ===========================================================================*/

if ($action == 'swfupload') {

	$vbulletin->input->clean_array_gpc('r',
		array(
			'isadmin' => TYPE_INT,
			'userid' => TYPE_INT,
			'uploadfile' => TYPE_STR,
			'uploadfileid' => TYPE_STR,
			'renamefileid' => TYPE_STR,
			)
	);

// Work round flash cookie bug
	$links_permissions['can_upload_files'] = 1;
	$LDM_environment['is_admin'] = $vbulletin->GPC['isadmin'];
	$filename = $vbulletin->GPC['uploadfile'];
	$vbulletin->userinfo['userid'] = $vbulletin->GPC['userid'];

	if (isset($_FILES[$filename])) {
		require_once(DIR . '/includes/local_links_actions.php');
		$uploaded = ldm_process_upload($_FILES[$filename], $linkurl, $links_defaults['upload_filetypes'], $errorstatus);
		if ($uploaded) {
			$rename = str_replace("#", "", $_FILES[$filename]['name']);
			$response = '#OK#'.$vbulletin->GPC['uploadfileid'].'#'.$linkurl.'#'.$vbulletin->GPC['renamefileid'].'#'.$rename.'#';
		}
		else {
			$response = '#ER#'.$errorstatus.'#';
		}
	} else {
		$response = '#ER#'.$vbphrase['ll_error_upload_4'].'#';
	}

	echo $response;

}


?>