<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & E_STRICT & ~E_NOTICE);

define('THIS_SCRIPT',  'local_links_admin');
define('CSRF_PROTECTION', true);

if (!isset($_REQUEST['action'])) {
	$_REQUEST['action'] = "admin";
}

if ($_REQUEST['action'] == "admin" and !isset($_REQUEST['set'])) {
	$_REQUEST['set'] = "settings";
}

if (isset($_REQUEST['set'])) {
	$_REQUEST['do'] = $_REQUEST['set'];
}

$phrasegroups = array(
	'local_links',
	'local_links_entities',
	'cprofilefield',
);

$globaltemplates = array(
	'links_addnewlink_catselect_one',
	'links_admin',
	'links_admin_category',
	'links_admin_category_confirm',
	'links_admin_environment',
	'links_admin_options',
	'links_admin_scan_start',
	'links_admin_scan_end',
	'links_admin_scan_line',
	'links_admin_scan_one',
    'links_admin_setting_break',
	'links_admin_setting_foot',
	'links_admin_setting_jump',
	'links_admin_setting_title',
	'links_admin_statistics',
	'links_catjump',
	'links_catsortbit',
	'links_footer',
	'links_header',
	'links_listselect',
	'links_massedit',
	'links_massedit_linkbit',
	'links_navbar',
	'links_navbar_popups',
	'links_scantext',
	'links_selectkeyword',
	'STANDARD_ERROR_LITE',
);

$specialtemplates = array(
	'attachmentcache',
	'forumcache',
	'ldm_admin',
	'ldm_cats',
);

$actiontemplates = array(

	'bandwidth' => array(
	'links_admin_bandwidth_other',
	'links_admin_bandwidth_usergroup1',
	'links_admin_bandwidth_usergroup2',
	'links_admin_bandwidth_uploads',
	'links_admin_bandwidth_use',
	),

	'categories' => array(
	'links_admin_forum',
	'links_admin_forums',
	),

	'debug' => array(
	'links_admin_debugrow',
	),

	'entities' => array(
	'links_admin_oneentity',
	),

	'filetypes' => array(
	'links_admin_onemimetype',
	),

	'initialise' => array(
	'humanverify',
	),

	'linkbits' => array(
	'links_admin_viewcatbit',
	'links_admin_viewlinkbit',
	'links_catbit',
	'links_catbit_brief',
	'links_linkbit',
	'links_linkbit_featured',
	'links_linkbit_greg',
	'links_linkbit_jukebox',
	'links_linkbit_mshort',
	'links_linkbit_mtop',
	'links_linkbit_photo',
	'links_linkbit_short',
	'links_linkbit_short_cent',
	'links_linkbit_short_direct',
	'links_linkbit_table',
	'links_linkbit_title',
	),

	'logjumps' => array(
	'links_admin_bandwidth_other',
	'links_admin_bandwidth_usergroup1',
	'links_admin_bandwidth_usergroup2',
	'links_admin_bandwidth_uploads',
	'links_admin_bandwidth_use',
	'links_admin_downloads',
	'links_admin_downloads_group',
	'links_admin_downloads_item',
	'links_admin_downloads_item_none',
	),

	'mirrors' => array(
	'links_admin_onemirror',
	),

	'nominations' => array(
	'links_admin_onenominate',
	),

	'permissions' => array(
	'links_admin_forum',
	'links_admin_forums',
	'links_admin_oneperm',
	'links_admin_oneperm_end',
	'links_admin_onesetting',
	'links_admin_onesetting_start',
	'links_admin_onesetting_end',
	'links_admin_onetranspose_end',
	'links_admin_onetranspose_perm',
	'links_admin_onetranspose_start',
	),

	'players' => array(
	'links_admin_playerbit',
	),

	'settings' => array(
	'links_admin_onesetting',
	'links_admin_onesetting_start',
	'links_admin_onesetting_end',
	'links_admin_oneperm',
	'links_admin_oneperm_end',
	),

	'showinfo' => array(
	'links_admin_entryinfo',
	'links_admin_permscategory',
	'links_admin_permsinfo',
	),

	'showusers' => array(
	'links_admin_showoneuser',
	),

);

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

if (file_exists(DIR . '/includes/version_ldm.php')) {
	include_once(DIR . '/includes/version_ldm.php');
}
if (defined('FILE_VERSION_LDM') AND FILE_VERSION_LDM !== '')
{
	$LDM_environment['LDM_PVersion'] = FILE_VERSION_LDM;
}
else {
	$LDM_environment['LDM_PVersion'] = $LDM_environment['LDM_Version'];
}

// The big authority - permission to use the admin/maintenance commands
// By default, requires user to be in the vb superadmins list.  Can be set otherwise
// using the admin_maintain extra

require_once(DIR . '/includes/adminfunctions.php');
$links_permissions['is_vbsuperadmin'] = in_array($vbulletin->userinfo['userid'], preg_split('#\s*,\s*#s', $vbulletin->config['SpecialUsers']['superadministrators'], -1, PREG_SPLIT_NO_EMPTY));

$vbulletin->input->clean_array_gpc('r', array(
	'action'	=> TYPE_STR,
	'set' 		=> TYPE_STR,
	'pp'		=> TYPE_INT,
	'page'		=> TYPE_INT,
));

$this_action = ($vbulletin->GPC['action'] ? $vbulletin->GPC['action'] : "admin");
$master_title = ($links_defaults['database_name'] ? $links_defaults['database_name'] : $vbphrase['ll_links_database']);

if ($vbulletin->GPC_exists['pp']) {
	$perpage = $vbulletin->GPC['pp'];
}
else {
	$perpage = ($links_defaults['links_per_page']!=0 ? $links_defaults['links_per_page'] : 25);
}

$pagenumber = ($vbulletin->GPC_exists['page'] ? $vbulletin->GPC['page'] : 1);

$ADMIN_IMPEXP = 120; // cut-off time limit for import and export scripts

$ft = $vbulletin->db->query_read("
	SHOW VARIABLES
");
$LDM_environment['mysql_timeout'] = 0; // guess, in case not found
while ($row=$vbulletin->db->fetch_array($ft)) {
	if ($row['Variable_name'] ==  'wait_timeout') {
		$LDM_environment['mysql_timeout'] = $row['Value'];
	}
}

$myrow = $vbulletin->db->query_first("SELECT VERSION() AS version");
$LDM_environment['mysql_version'] = $myrow['version'];

function ldm_build_cat_children() {
	global $linkscat, $BASE_CAT;

	$linkscat[$BASE_CAT]['childlist'] = array();
	foreach ($linkscat as $k=>$thiscat) {
		$linkscat[$k]['childlist'] = array();
	}
	foreach ($linkscat as $k=>$thiscat) {
		if ($linkscat[$k]['parentid']) {
			$linkscat[$linkscat[$k]['parentid']]['childlist'][] = $linkscat[$k]['catid'];
		}
	}

}

function ldm_exportcattree($level) {
	global $linkscat;
	$keys = array_keys($linkscat);
	$tree = "";
	foreach ($keys as $thiskey) {
		$thiscat = $linkscat[$thiskey];
		if ($thiscat['parentid'] == $level) {
			$search = array ("'\r'", "'\n'", "'&amp;'", "'\"'");
			$replace = array ("\\\\r", "\\\\n", "&", "\"\"");
			$tree .= "category," . $thiscat["catid"] . ",\"" . preg_replace ($search, $replace, $thiscat["catname"]) . "\",\"" .
				preg_replace ($search, $replace, $thiscat["catdesc"]) . "\",\"" . $thiscat["parentlist"] . "\"\r\n";
			$tree .= ldm_exportcattree($thiscat['catid']);
		}
	}
	return $tree;
}

function ldm_dopagehead() {
	echo '<html><head><title>'.$master_title.'</title><style type="text/css">
		<!--
		body {
			background: #CCCCCC; color: #00476C; font: 10pt tahoma, arial, helvetica, sans-serif;
			margin: 5px 5px 10px 5px;
		}
		body a:link { color: #22229C; }
		body a:visited { color: #22229C; }
		body a:hover, body a:active { color: #FF4400; }
		-->
		</style>
		</head><body>';
	flush();
}

function ldm_dopagefoot() {
	echo '</body></html>';
	flush();
}

function ldm_doredirect($gotopage) {
	global $vbphrase;
	$gotopage = str_replace('&amp;', '&', $gotopage);
	echo "\n<script type=\"text/javascript\">\n";
	echo "window.location=\"$gotopage\";";
	echo "\n</script>\n";
	echo "</body></html>";
	exit;
}

function cache_LDMadminstats() {
	global $vbulletin, $vbphrase;
	global $linkscat;
	global $linkstats, $userstats;
	global $LINKS_SCRIPT, $ADMIN_SCRIPT, $SEARCH_SCRIPT;
	global $LINK_BROKEN, $LINK_NO_ACCESS, $LINK_HIDDEN, $LINK_UPLOAD, $LINK_TO_MODERATE;

	$linkstats['links'] = $linkstats['linksok'] = $linkstats['linksbroken'] = 0;
	$linkstats['linksinvalid'] = $linkstats['linksmod'] = $linkstats['linkshidden'] = 0;
	$linkstats['uploads'] = $linkstats['uploadspace'] = $linkstats['linksreview'] = 0;
	$linkstats['linkimg'] = $linkstats['linkimgthumb'] = 0;
	$linkstats['users'] = array();

	$asb = $vbulletin->db->query_read("
		SELECT linkstatus, linkmoderate, linkreviewfreq, linkmoddate, linksize, linkimg, linkimgthumb,
			linkusername, linkuserid
		FROM ".THIS_TABLE."linkslink
	");

	$userstats = array();
	while ($row=$vbulletin->db->fetch_array($asb)) {
		$linkstats['links'] += 1;
		if ($row['linkstatus']>0) $linkstats['linksok'] += 1;
		if ($row['linkstatus']==$LINK_BROKEN) $linkstats['linksbroken'] += 1;
		if ($row['linkstatus']==$LINK_NO_ACCESS) $linkstats['linksinvalid'] += 1;
		if ($row['linkstatus']==$LINK_HIDDEN) $linkstats['linkshidden'] += 1;
		if ($row['linkstatus']==$LINK_UPLOAD) {
			$linkstats['uploads'] += 1;
			$linkstats['uploadspace'] += $row['linksize'];
		}
		if ($row['linkmoderate']==$LINK_TO_MODERATE) $linkstats['linksmod'] += 1;
		if ($row['linkreviewfreq'] and ($row['linkmoddate']+$row['linkreviewfreq']*24*60*60<TIMENOW)) $linkstats['linksreview'] += 1;
		if ($row['linkimg']) $linkstats['linkimg'] += 1;
		if ($row['linkimgthumb']) $linkstats['linkimgthumb'] += 1;

		$userstats[$row['linkusername']]['count'] += 1;
		$userstats[$row['linkusername']]['userid'] = $row['linkuserid'];
	}

	$linkstats['uploadspace'] = ldm_format_bytes($linkstats['uploadspace'], 2);

	$linkstats['categories'] = count($linkscat);
	$linkstats['catsmod'] = 0;
	foreach ($linkscat as $thiscat) {
		if ($thiscat['catmoderate']==$LINK_TO_MODERATE) $linkstats['catsmod'] += 1;
	}

	$linkstats['users'] = construct_phrase($vbphrase['ll_admin_total_users'], count($userstats));

	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS keywords
		FROM ".THIS_TABLE."linkskeys
	");
	$linkstats['keywords'] = $count['keywords'];

	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS cachebits
		FROM ".THIS_TABLE."linksbitcache
	");
	$linkstats['cachebits'] = $count['cachebits'];

}

function ldm_admin_clearfromtable($table, $where="") {
	global $vbulletin;
	if (!$where) {
		$query = 'TRUNCATE TABLE '.THIS_TABLE.$table;
	}
	else {
		$query = 'DELETE FROM '.THIS_TABLE.$table.' WHERE '.$where;
	}
	$vbulletin->db->query_write($query);
}

function ldm_get_adminforumperms() {
	global $vbulletin, $vbphrase, $stylevar;
	global $linkscat, $links_defaults, $ldm_usergroup_cache, $ldm_icon_cache;
	global $ADMIN_SCRIPT, $ADMINCP_FORUMPERM_SCRIPT;
	global $forum, $linkstats;

	$n = 1;
	$forum_perms = array();
	foreach ($linkscat as $thiscat) {
		if (isset($thiscat['catforum'])) {
			$forum_perms[$thiscat['catforum']]['cat'] += 1;
		}
	}

	$links = $vbulletin->db->query_read("
		SELECT linkforum, COUNT(linkforum) AS count
		FROM ".THIS_TABLE."linkslink AS link
		GROUP BY linkforum
		");
	while ($link=$vbulletin->db->fetch_array($links)) {
		$forum_perms[$link['linkforum']]['link'] = $link['count'];
	}

	cache_LDMusergroup();

	$linkstats['defaultforum'] = "";
	if ($links_defaults['default_forumid']>0) {
		if (isset($forum[$links_defaults['default_forumid']])) {
			$linkstats['defaultforum'] = $forum[$links_defaults['default_forumid']];
		}
		else {
			$linkstats['defaultforum'] = '<span class="highlight">forumid='.$links_defaults['default_forumid'].' ('.$vbphrase['ll_error_forum'].')</span>';
		}
	}
	else {
		$linkstats['defaultforum'] = $vbphrase['ll_unset'];
	}

	$linkstats['forums'] = "";
	$doforumstats = 0;

	foreach ($forum_perms as $forumid=>$thisforum) {
		if ($forumid>0 and ($thisforum['cat']>0 or $thisforum['link']>0)) {
			$doforumstats = 1;
			break;
		}
	}

	if ($doforumstats) {
		foreach ($forum_perms as $forumid=>$thisforum) {
			$forumerror = ($forumid>0 and !isset($forum[$forumid]) ? 1 : 0);
			if ($forumid>0 and isset($forum[$forumid])) {
				$forumlist = '';
				foreach ($ldm_usergroup_cache as $usergroupid => $title) {
					$perms = fetch_forum_permissions($usergroupid, $forumid);
					$yesno = ($perms['forumpermissions'] & $vbulletin->bf_ugp_forumpermissions['canview']) && ($perms['forumpermissions'] & $vbulletin->bf_ugp_forumpermissions['canviewothers']);
					if ($yesno) {
						$forumlist .= $title.'<br />';
					}
				}
			}
			elseif ($forumid>0) {
				$forumlist = '&nbsp';
			}
			else {
				$forumlist = $vbphrase['ll_allusergroups'];
			}
			eval('$linkstats[forums] .= "' . fetch_template('links_admin_forum') . '";');
		}
	}

	eval('$linkstats[forums] = "' . fetch_template('links_admin_forums') . '";');

}

if ($links_defaults["prune_downloadtable"]>0) {
	$when = TIMENOW-24*60*60*intval($links_defaults["prune_downloadtable"]);
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksdownloads
		WHERE usertime<'".$when."'
	");
}

// Force construct_forum_jump to return a result even if user has turned off the forumjump menu
$vbulletin->options['useforumjump'] = 1;
construct_forum_jump();
if ($links_defaults['category_jump_menu']) {
	$catjumpbit = ldm_construct_category_list(array(0), "links_catjump", 0, "catid", "catid");
}

$config_warnings = array();

$forum = array();
$forum[$DEFAULT_FORUMID] = $vbphrase['ll_forumdefault'];
foreach ($vbulletin->forumcache as $thisforum) {
	$forum[$thisforum['forumid']] = $thisforum['title'];
}

if ($LDM_environment['mysql_timeout'] and $LDM_environment['mysql_timeout']<10) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_mysql1'], $LDM_environment['mysql_timeout']);
}

if ($links_defaults['upload_enabled']) {
	if (!$links_defaults['upload_dir']) {
		$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm1'], 'upload_enabled', 'upload_dir');
	}
	if (!ldm_can_accessdir($links_defaults['upload_dir'], 1)) {
		$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm3'], 'upload_dir', $links_defaults['upload_dir']);
	}
}

if ($links_defaults['force_redirect'] and $links_defaults['local_file_root']) {
	$config_warnings[] = $vbphrase['ll_admin_vb_warning_ldm4'];
}

if (!$links_defaults['file_icons_dir']) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm2'], 'file_icons_dir');
}
elseif (!ldm_can_accessdir($links_defaults['file_icons_dir'], 0)) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm3'], 'file_icons_dir', $links_defaults['file_icons_dir']);
}

if ($links_defaults['thumbs_dir']) {
	if ($links_defaults['link_imagesize']=='0') {
		$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm1'], 'thumbs_dir', 'link_imagesize');
	}
	elseif (!ldm_can_accessdir($links_defaults['thumbs_dir'], 0)) {
		$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm3'], 'thumbs_dir', $links_defaults['thumbs_dir']);
	}
}

if (!$LDM_environment['allow_url_fopen'] and !$LDM_environment['curl_available']) {
	$config_warnings[] = $vbphrase['ll_admin_vb_warning_php1'];
}

if (ldm_decode_bytes($LDM_environment['upload_max_filesize'])>=ldm_decode_bytes($LDM_environment['post_max_size'])) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_php2'],$LDM_environment['upload_max_filesize'],$LDM_environment['post_max_size']);
}

if (!is_dir(LDM_DOCUMENT_ROOT)) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_server'],LDM_DOCUMENT_ROOT);
}

$myrow = $vbulletin->db->query_first("
	SELECT COUNT(*) AS hits
	FROM ". THIS_TABLE . "linksdownloads
");
$ldm_hits_recorded = $myrow['hits'];
if ($ldm_hits_recorded>10000) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_downloads'],$ldm_hits_recorded);
}

$config_warnings = implode("\r\n<br />", $config_warnings);

// Check for inconsistencies between the VBulletin and LDM databases...

$vbsync_warnings = array();
cache_LDMusergroup();
$vb_usergroup = $ldm_usergroup_cache;

$ldm_usergroups = unserialize($links_defaults['bandwidth_limit']);
if (is_array($ldm_usergroups)) {
	foreach ($ldm_usergroups as $ldm_usergroupid=>$ldm_bandwidth) {
		if (isset($vb_usergroup[$ldm_usergroupid])) {
			$vb_usergroup[$ldm_usergroupid] = 0;
		}
	}
	foreach ($vb_usergroup as $vb_usergroup=>$value) {
		if ($value) {
			$vbsync_warnings[] = construct_phrase($vbphrase['ll_admin_vb_usergroup'], $value);
		}
	}
}

$vbsync_warnings = implode('<br />', $vbsync_warnings);

if (!function_exists('unhtmlentities')) {
	function unhtmlentities($string) {
	// replace numeric entities
	$string = preg_replace('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $string);
	$string = preg_replace('~&#([0-9]+);~e', 'chr(\\1)', $string);
	// replace literal entities
	$trans_tbl = get_html_translation_table(HTML_ENTITIES);
	$trans_tbl = array_flip($trans_tbl);
	return strtr($string, $trans_tbl);
	}
}

if ($links_defaults['forms_fullwidth']) {
	$stylevar['outertablewidth'] = $stylevar['outerdivwidth'] = "100%";
	eval('$spacer_open = "' . fetch_template('spacer_open') . '";');
	eval('$header = "' . fetch_template('header') . '";');
	eval('$footer = "' . fetch_template('footer') . '";');
}

cache_LDMicons();

$adminsettings = array(
		"bandwidth", "categories", "debug", "duplicates", "entities", "filetypes", "importexport",
		"initialise", "keywords", "linkbits", "logjumps", "massedit", "mirrors", "nominations",
		"overrides", "permissions", "players", "plugins", "scan", "seo", "settings", "showinfo",
		"showusers", "validate",
		);

($hook = vBulletinHook::fetch_hook('ldm_start')) ? eval($hook) : false;
($hook = vBulletinHook::fetch_hook('ldm_admin_start')) ? eval($hook) : false;

// Administrators only

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

// Main Administration Functions

if ($this_action == "admin") {

	$this_set = ($vbulletin->GPC_exists['set'] ? $vbulletin->GPC['set'] : "settings");
	if (in_array($this_set, $adminsettings)) {
		$adminset = $this_set;
	}
	else {
		print_no_permission();
		exit;
	}

	$navbits = array();
	$navbits[$LINKS_SCRIPT.".php".$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$this_navigation_title = $navbits[$ADMIN_SCRIPT.".php".$vbulletin->session->vars['sessionurl_q']] = $vbphrase['ll_links_administration'];

	eval('$adminoptions = "' . fetch_template('links_admin_options') . '";');
	eval('$adminenvinmt = "' . fetch_template('links_admin_environment') . '";');

	cache_LDMadminstats();
	eval('$adminstatistics = "' . fetch_template('links_admin_statistics') . '";');

	($hook = vBulletinHook::fetch_hook('ldm_admin_option')) ? eval($hook) : false;

// --------------------------------------------------------------------------------

	if ($adminset == "bandwidth") {
		require_once(DIR . '/includes/local_links_admin_bandwidth.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "categories") {
		require_once(DIR . '/includes/local_links_admin_categories.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "debug") {

		if (!$links_permissions["is_vbsuperadmin"]) {
			print_no_permission();
			exit;
		}

		$vbulletin->input->clean_array_gpc('r', array(
			'highlight' => TYPE_INT,
		));

		$navbits[""] = $vbphrase['ll_debug'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		$vbulletin->url = $debugscript = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=debug";

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksdebug
			ORDER BY adminid
		");
		$nrec = 0;
		$line = array();
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$nrec++;
			if ($nrec>=$pagenumber*$perpage) {
				continue;
			}
			elseif ($nrec>($pagenumber-1)*$perpage) {
				$line[] = $myrow;
				$index = $myrow['adminid'];
			}
		}

		$vbulletin->db->free_result($asb);

		$pagenav = construct_page_nav($pagenumber, $perpage, $nrec, $debugscript,"&amp;pp=$perpage");

		if ($nrec) {

			foreach ($line as $thisline) {

				$command = $thisline['command'];
				$sep = '?';
				foreach (unserialize($thisline['get']) as $k=>$v) {
					$command .= $sep.$k.'='.$v;
					$sep = '&amp;';
				}

				$expansion = '';
				if ($vbulletin->GPC['highlight']==$thisline['adminid']) {
					$todo = array('get', 'post', 'files', 'cookie', 'settings');
					foreach ($todo as $thistodo) {
						$expansion .= '<tr>';
						$expansion .= '<td class="alt2" width="10%" valign="top">';
						$expansion .= '<span class="smallfont">'.$thistodo.'</span>';
						$expansion .= '</td><td class="alt2" valign="top" colspan="3">';
						$expansion .= '<span class="smallfont">';
						$thisunser = unserialize($thisline[$thistodo]);
						if (is_array($thisunser)) {
							ksort($thisunser);
							foreach ($thisunser as $kk=>$kv) {
								$expansion .= $kk.':'.$kv.'<br />';
							}
						}
						else {
							ob_start();
							var_dump(unserialize($thisline[$thistodo]));
							$expansion .=  ob_get_contents();
							ob_end_clean();
						}
						$expansion .= '</span></td>';
						$expansion .= '</tr>';
					}
				}

				$adminid = $thisline['adminid'];
				$message = $thisline['message'];
				$datetime = ldm_date($vbulletin->options['dateformat'], $thisline['settingtime']).' '.ldm_date($vbulletin->options['timeformat'], $thisline['settingtime']);
				eval('$debuginfo .= "' . fetch_template('links_admin_debugrow') . '";');
			}
		}

	}

// --------------------------------------------------------------------------------

	if ($adminset == "duplicates") {

		$navbits[""] = $vbphrase['ll_duplicates'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		$linkdups = array();
		$duplicates = "";

		$asb = $vbulletin->db->query_read("
			SELECT link.linkname AS linkname, link.linkid AS linkid, link.linkurl AS linkurl,
			cat.catid AS catid, cat.catname AS catname
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON link.linkid = ltoc.linkid
			LEFT JOIN ".THIS_TABLE."linkscat AS cat
			ON ltoc.catid = cat.catid
			ORDER BY catname ASC
			");

		while ($row = $vbulletin->db->fetch_array($asb)) {
			$linkdups[$row['linkurl']][] = $row;
		}

		foreach ($linkdups as $thisurl=>$thisdup) {
			if (count($thisdup)<=1) {
				continue;
			}
			$duplicates .= $thisurl." [".count($thisdup)."]";
			foreach ($thisdup as $thisentry) {
				$duplicates .=
					'<br />&nbsp;&nbsp;&nbsp;'.
					'<a href="'.$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$thisentry['catid'].'&amp;linkid='.$thisentry['linkid'].'" target="_blank">'.
					$thisentry['catname'].
					'</a>';
			}
			$duplicates .= "<br /><br />";
		}

	}

// --------------------------------------------------------------------------------

	if ($adminset == "entities") {
		require_once(DIR . '/includes/local_links_admin_entities.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "filetypes") {
		require_once(DIR . '/includes/local_links_admin_filetypes.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "importexport") {

		if (!$links_permissions["is_vbsuperadmin"]) {
			print_no_permission();
			exit;
		}

		$navbits[""] = $vbphrase['ll_menu_admimex'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

	}

// --------------------------------------------------------------------------------

	if ($adminset == "initialise") {

		if (!$links_permissions["is_vbsuperadmin"]) {
			print_no_permission();
			exit;
		}

		$human_verify = '';

// Take care - VB version specific
		require_once(DIR . '/includes/class_humanverify.php');
		$verification =& vB_HumanVerify::fetch_library($vbulletin);
		$human_verify = $verification->output_token();
// Take care - VB version specific

		$navbits[""] = $vbphrase['ll_menu_admreinit'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

	}

// --------------------------------------------------------------------------------

	if ($adminset == "keywords") {
		require_once(DIR . '/includes/local_links_admin_keywords.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "linkbits") {
		require_once(DIR . '/includes/local_links_admin_linkbits.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "logjumps") {
		require_once(DIR . '/includes/local_links_admin_logjumps.php');
	}

// --------------------------------------------------------------------------------

    if ($adminset == "massedit") {
	    require_once(DIR . '/includes/local_links_admin_massedit.php');
    }

// --------------------------------------------------------------------------------

	if ($adminset == "mirrors") {
		require_once(DIR . '/includes/local_links_admin_mirrors.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "nominations") {
		require_once(DIR . '/includes/local_links_admin_nominations.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "overrides") {
		require_once(DIR . '/includes/local_links_admin_overrides.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "permissions") {

		$vbulletin->input->clean_array_gpc('r', array(
			'transpose' => TYPE_INT,
		));

		$navbits[""] = $vbphrase['ll_menu_admperm'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/local_links_misc.php');
		ldm_build_permissions($linksperms, $permjump, $BASE_CAT, "", 1, 1, $vbulletin->GPC['transpose']);

		require_once(DIR . '/includes/adminfunctions_forums.php');
		ldm_get_adminforumperms();

	}

// --------------------------------------------------------------------------------

	if ($adminset == "players") {

		require_once(DIR . '/includes/local_links_admininclude.php');

		$navbits[""] = $vbphrase['ll_menu_admplay'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/local_links_players.php');

		$linksplayers = edit_ldm_players();

	}

// --------------------------------------------------------------------------------

	if ($adminset == "plugins") {

		require_once(DIR . '/includes/local_links_admin_plugins.php');

	}

// --------------------------------------------------------------------------------

	if ($adminset == "scan") {

		require_once(DIR . '/includes/local_links_admin_scan.php');

	}

// --------------------------------------------------------------------------------

	if ($adminset == "seo") {

		if (!$links_permissions["is_vbsuperadmin"]) {
			print_no_permission();
			exit;
		}

		$navbits[""] = $vbphrase['ll_seo_opt'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

	}

// --------------------------------------------------------------------------------

	if ($adminset == "settings") {

		$navbits[""] = $vbphrase['ll_menu_admset'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/local_links_misc.php');

		ldm_build_settings($linkssettings, $settingjump, $BASE_CAT, "", 1, 1);

	}

// --------------------------------------------------------------------------------

	if ($adminset == "showinfo") {

		$navbits[""] = $vbphrase['ll_viewdetails'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/local_links_admin_information.php');

	}

// --------------------------------------------------------------------------------

	if ($adminset == "showusers") {

		$navbits[""] = $vbphrase['ll_users'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		ksort($userstats);
		foreach ($userstats as $thisusername=>$thisuser) {
		    $thisuserid = $thisuser['userid'];
		    $thisusercount = $thisuser['count'];
    		eval('$linkusers .= "' . fetch_template('links_admin_showoneuser') . '";');
		}

	}

// --------------------------------------------------------------------------------

	if ($adminset == "validate") {

		require_once(DIR . '/includes/local_links_admininclude.php');

		$navbits[""] = $vbphrase['ll_menu_admvald'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

	}

// --------------------------------------------------------------------------------

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_edit_category"] = 0;
	$viewcatid=-1;

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_admin')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### Do (Mass Edit) Links

if ($this_action == "doadmin" and isset($_REQUEST["domassedit"])) {
	require_once(DIR . '/includes/local_links_admin_massedit.php');
}

// #################### Download/Bandwidth

if ($this_action == "doadmin" and isset($_REQUEST["dobandwidth"])) {
	require_once(DIR . '/includes/local_links_admin_bandwidth.php');
}

// #################### Mass actions on categories

if ($this_action == "doadmin" and isset($_REQUEST["docategories"])) {
	require_once(DIR . '/includes/local_links_admin_categories.php');
}

// #################### Clear display bit cache

if ($this_action == "doadmin" and isset($_REQUEST['doclearcachebits'])) {

	require_once(DIR . '/includes/local_links_bitcache.php');

	ldm_clear_bitcache();
	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=".$vbulletin->GPC['set'];
	eval(print_standard_redirect($vbphrase['ll_admin_clearcache'],0));

	exit;

}

// #################### Manage Debug Table

if ($this_action == "doadmin" and isset($_REQUEST['dodebugexport'])) {

	$vbulletin->input->clean_array_gpc('r', array(
		'save' => TYPE_INT,
	));

	if ($vbulletin->GPC['save']==1) {
		require_once(DIR . '/includes/class_xml.php');

		$xml = new XMLexporter($vbulletin);

		$xml->add_group('LDM', array('name' => 'Trace', 'version' => $links_defaults["this_version"],
			'date' => date('d-m-Y H:i:s', TIMENOW)));

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksdebug
			ORDER BY adminid
		");

		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$xml->add_group(($myrow['message']=='TRACE' ? 'command' : 'debug'), array('id'=>$myrow['adminid']));
			foreach ($myrow as $k=>$v) {
				$xml->add_tag($k, $v, array(), true);
			}
			$xml->close_group();
		}
		$xml->close_group();

		$doc = '<?xml version="1.0" encoding="ISO-8859-1"?>'. "\r\n";
		$doc .= $xml->output();
		$xml = null;

		$vbulletin->db->free_result($asb);

		$vbulletin->db->query_write("
			TRUNCATE TABLE
			".THIS_TABLE."linksdebug
		");

		require_once(DIR . '/includes/functions_file.php');
		file_download($doc, 'trace.xml', 'text/xml');
		exit;
	}

	if ($vbulletin->GPC['save']==-1) {
		$vbulletin->db->query_write("
			TRUNCATE TABLE
			".THIS_TABLE."linksdebug
		");
	}

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=debug&amp;page=$pagenumber";
	eval(print_standard_redirect($vbphrase['ll_deleted'],0));

}

if ($this_action == "doadmin" and isset($_REQUEST['dodebug'])) {

	$vbulletin->input->clean_array_gpc('r', array(
		'debug' => TYPE_INT,
		'trace' => TYPE_INT,
	));

	if ($vbulletin->GPC_exists['debug']) {
		ldm_update_oneadminrow(-1, 'DEBUG', $vbulletin->GPC['debug']);
	}

	if ($vbulletin->GPC_exists['trace']) {
		ldm_update_oneadminrow(-1, 'TRACE', $vbulletin->GPC['trace']);
	}

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=debug&amp;page=$pagenumber";
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

}

// #################### Entities

if ($this_action == "doadmin" and isset($_REQUEST["doentities"])) {
	require_once(DIR . '/includes/local_links_admin_entities.php');
}

// #################### File Export

if ($this_action == "doadmin" and isset($_REQUEST['doexport'])) {
	require_once(DIR . '/includes/local_links_admin_impexp.php');
}

// #################### XML Export

if ($this_action == "doadmin" and isset($_REQUEST['doexportxml'])) {
	require_once(DIR . '/includes/local_links_admin_impexp.php');
}

// #################### Filetypes

if ($this_action == "doadmin" and isset($_REQUEST["dofiletypes"])) {
	require_once(DIR . '/includes/local_links_admin_filetypes.php');
}

// #################### CSV file import

if ($this_action == "doadmin" and isset($_REQUEST['doimport'])) {
	require_once(DIR . '/includes/local_links_admin_impexp.php');
}

// #################### XML Import

if ($this_action == "doadmin" and isset($_REQUEST['doimportxml'])) {
	require_once(DIR . '/includes/local_links_admin_impexp.php');
}

// #################### Mass edit keyword list

if ($this_action == "doadmin" and isset($_REQUEST['dokeywords'])) {
	require_once(DIR . '/includes/local_links_admin_keywords.php');
}

// #################### Linkbits/Catbits

if ($this_action == "doadmin" and isset($_REQUEST["dolinkbits"])) {
	require_once(DIR . '/includes/local_links_admin_linkbits.php');
}

// #################### Hits table

if ($this_action == "doadmin" and isset($_REQUEST["dologjumps"])) {
	require_once(DIR . '/includes/local_links_admin_logjumps.php');
}

// #################### Mirrors

if ($this_action == "doadmin" and isset($_REQUEST["domirrors"])) {
	require_once(DIR . '/includes/local_links_admin_mirrors.php');
}

// #################### Nominations

if ($this_action == "doadmin" and isset($_REQUEST['donominations'])) {

	$vbulletin->input->clean_array_gpc('p', array(
		'period' => TYPE_INT,
		'entry' => TYPE_ARRAY_INT,
	));

	$entries = $vbulletin->GPC['entry'];
	if (count($entries)) {
		$entries = implode(',',$entries);
		$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linkstarred
			WHERE starid IN (".$entries.")
			");
	}

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=nominations&amp;period=".$vbulletin->GPC['period'];
	eval(print_standard_redirect($vbphrase['ll_deleted'],0));

	exit;

}

// #################### Hits table

if ($this_action == "doadmin" and isset($_REQUEST["dooverrides"])) {
	require_once(DIR . '/includes/local_links_admin_overrides.php');
}

// #################### Permissions

if ($this_action == "doadmin" and isset($_REQUEST["dopermissions"])) {

	require_once(DIR . '/includes/local_links_misc.php');
	ldm_update_permissions(-1, $_REQUEST);
	$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=".$adminset;
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));
	exit;
}

// #################### Players

if ($this_action == "doadmin" and isset($_REQUEST["doplayers"])) {

	require_once(DIR . '/includes/local_links_players.php');

	update_ldm_players($_REQUEST);

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=".$adminset;
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

	exit;
}

// #################### Plugins

if ($this_action == "doadmin" and isset($_REQUEST['doplugins'])) {
	require_once(DIR . '/includes/local_links_admin_plugins.php');
}

// #################### Reinitialise

if ($this_action == "doadmin" and isset($_REQUEST['doreinit'])) {

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=initialise";

	if (!$links_permissions["is_vbsuperadmin"]) {
		print_no_permission();
		exit;
	}

// Take care - VB version specific
	$vbulletin->input->clean_array_gpc('p', array(
		'doreinit'		=> TYPE_STR,
		'ldmreinit'		=> TYPE_INT,
		'humanverify' => TYPE_ARRAY,
	));
	require_once(DIR . '/includes/class_humanverify.php');
	$verify =& vB_HumanVerify::fetch_library($vbulletin);
	if (!$verify->verify_token($vbulletin->GPC['humanverify'])) {
		$errors[] = fetch_error($verify->fetch_error());
		eval(print_standard_redirect($errors[0],0, 1));
	}
// Take care - VB version specific

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=initialise";

	if ($vbulletin->GPC['doreinit']!=$vbphrase['ll_go'] or !$vbulletin->GPC['ldmreinit']) {
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
	}

	require_once(DIR . '/includes/local_links_admininclude.php');

	ldm_admin_clearfromtable('linksadmin');
	ldm_admin_clearfromtable('linksbitcache');
	ldm_admin_clearfromtable('linksdebug');
	ldm_admin_clearfromtable('linkscat');
	ldm_admin_clearfromtable('linkslink');
	ldm_admin_clearfromtable('linksltoc');
	ldm_admin_clearfromtable('linkskeys');
	ldm_admin_clearfromtable('linksltok');
	ldm_admin_clearfromtable('linksfavs');
	ldm_admin_clearfromtable('linksentities');
	ldm_admin_clearfromtable('linksrate');
	ldm_admin_clearfromtable('linksdownloads');
	ldm_admin_clearfromtable('linkssearch');

	init_LDMadmintable();
	record_LDM_version(THIS_VERSION, 1);

	ldm_datastore_markdirty('ldm_admin');
	ldm_datastore_markdirty('ldm_cats');

	eval(print_standard_redirect($vbphrase['ll_admin_reinitialised'],0));
	exit;

}

// #################### Search Engine Optimisation

if ($this_action == "doadmin" and isset($_REQUEST['doseo'])) {

	if (!$links_permissions["is_vbsuperadmin"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'seo_friendly' => TYPE_INT,
		'seo_title' => TYPE_STR,
	));

	if ($vbulletin->GPC_exists['seo_friendly']) {
		ldm_update_oneadminrow(-1, 'seo_friendly', min(2, max(0, $vbulletin->GPC['seo_friendly'])));
	}

	if ($vbulletin->GPC_exists['seo_title']) {
		ldm_update_oneadminrow(-1, 'seo_title', $vbulletin->GPC['seo_title']);
	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=seo";
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

}

// #################### Settings

if ($this_action == "doadmin" and isset($_REQUEST["dosettings"])) {

	require_once(DIR . '/includes/local_links_misc.php');
	ldm_update_settings(-1, $_REQUEST, $errors);
	$isok = 1;

	foreach ($errors as $k => $v) {
		if ($isok) {
			ldm_dopagehead();
			echo $vbphrase['ll_error_invalidsettings'].'<br />';
		}
		echo '<b>'.$k.'</b> : '.$v['value'].'<br />'.$v['message'].'<br />';
		$isok = 0;
	}

	if ($isok) {
		$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=".$adminset;
		eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

	}
	else {
		echo $vbphrase['ll_goback'];
		ldm_dopagefoot();
	}

	exit;
}

// #################### Rebuild thumbs
// [actually just reset them all, so that they get rebuilt the next time they are displayed]

if ($this_action == "doadmin" and isset($_REQUEST['dothumbs'])) {

	$vbulletin->input->clean_array_gpc('g', array(
		'set' => TYPE_STR,
	));

	require_once(DIR . '/includes/local_links_images.php');

	ldm_clear_thumbnails();

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=".$vbulletin->GPC['set'];
	eval(print_standard_redirect($vbphrase['ll_resetthumbs'],0));

	exit;

}

// #################### Do (Synchronise) Links

if ($this_action == "doadmin" and isset($_REQUEST["dosync"])) {

	$url  = ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=admin&amp;set=categories";

	$vbulletin->input->clean_array_gpc('g', array(
		'catid' => TYPE_INT,
		'set' => TYPE_STR,
		'expand' => TYPE_STR,
	));

	$catid = $vbulletin->GPC['catid'];

	ldm_dopagehead();
	echo '<p class="smallfont">';
	echo '<strong>'.$vbphrase['ll_resync'].'</strong>';
	echo '</p>';
	flush();

	require_once(DIR . '/includes/local_links_misc.php');
	$continue = ldm_synchronise_category($catid, $links_defaults['sync_maxcpu_allowed_manual'], 1);

	if (!$continue) {
		$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=doadmin&dosync=1&set=".$vbulletin->GPC['set']."&catid=".$catid."&expand=".$vbulletin->GPC['expand'];
		echo '<p class="smallfont">' . $vbphrase['ll_resync_notcomplete'] . '</p>';
		echo '<p class="smallfont"><a href="' . $url . '">' . $vbphrase['ll_resync_continue'] . '</a></p>';
	}
	else {
		$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=".$vbulletin->GPC['set']."&expand=".$vbulletin->GPC['expand'];
		echo '<p class="smallfont">' . $vbphrase['ll_resync_complete'] . '</p>';
		echo "\n<script type=\"text/javascript\">\n";
		echo "window.location=\"$url\";";
		echo "\n</script>\n";
	}
	$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=".$vbulletin->GPC['set']."&expand=".$vbulletin->GPC['expand'];
	echo '<p class="smallfont"><a href="' . $url . '">' . $vbphrase['ll_return'] . '</a></p>';

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	ldm_dopagefoot();
	flush();
	exit;

}

// #################### Validate access to links/files in database

if ($this_action == "dovalidate") {

	$vbulletin->input->clean_array_gpc('r', array(
		'status' => TYPE_INT,
		'at' => TYPE_INT,
		'done' => TYPE_INT,
		'total' => TYPE_INT,
	));

	$lstatus	= ($vbulletin->GPC_exists['status'] ? $vbulletin->GPC['status'] : $LINK_ALL);
	$where = "";
	$limit = 50;

	if ($lstatus == $LINK_BROKEN) {
		$where .= "AND linkstatus = ".$LINK_BROKEN;
	}
	elseif ($lstatus == $LINK_NO_ACCESS) {
		$where .= "AND linkstatus = $LINK_NO_ACCESS ";
	}

	if ($vbulletin->GPC_exists['total']) {
		$total = $vbulletin->GPC['total'];
	}
	else {
		$query = "
			SELECT COUNT(linkid) AS total
			FROM ".THIS_TABLE."linkslink
			WHERE (1)
			$where
		";
		$myrow = $vbulletin->db->query_first($query);
		$total = $myrow['total'];
	}

	$done 	 = ($vbulletin->GPC_exists['done'] ? $vbulletin->GPC['done'] : 0);
	$startat = ($vbulletin->GPC_exists['at'] ? $vbulletin->GPC['at'] : 0);
	$where	.= "
		AND linkid >= $startat ";

	$query = "
		SELECT linkid, linkurl, linkforum, linkstatus
		FROM ".THIS_TABLE."linkslink
		WHERE (1)
		$where
		ORDER BY linkid
		LIMIT $limit
	";
	$asb = $vbulletin->db->query_read($query);

	$num = 0;
	ldm_dopagehead();

	echo '<b>'.$vbphrase['ll_validate'].'</b> ('.$done.'/'.$total.') ';
	echo '<a href="'.$ADMIN_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=dovalidate&amp;status='.$lstatus.'&amp;at=9999999&amp;total='.$total.'&amp;done='.$done.'">'.$vbphrase['ll_quit'].'</a><br /><br />';

	$newstatus = array();

	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		$linkid	= $myrow["linkid"];
		$linkurl    = $myrow["linkurl"];
		$linkforum = $myrow["linkforum"];
		$linkstatus = $myrow["linkstatus"];
		$nextid	= $linkid + 1;
		$done += 1;

		echo '&nbsp;&nbsp;-- '.$linkid.' '.$linkurl;
		echo '&nbsp;&nbsp;(<a href="'.$ADMIN_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=dovalidate&amp;status='.$lstatus.'&amp;at='.$nextid.'&amp;total='.$total.'&amp;done='.$done.'">'.$vbphrase['ll_next'].'</a>)';
		flush();

		if (!ldm_forumid_is_valid($linkforum)) {
			$status = $LINK_NO_ACCESS;
			echo ': <b>'.$vbphrase['ll_error_forum'].'</b><br />';
		}
		else {
			$status = ldm_check_url($linkurl);
			switch ($status) {
			case $LINK_NO_ACCESS:
				echo ': <b>'.$vbphrase['ll_invalid'].'</b><br />';
				break;
			case $LINK_BROKEN:
				echo ': <b>'.$vbphrase['ll_error_linkcheckfailed'].'</b><br />';
				break;
			default:
				if ($linkstatus==$LINK_UPLOAD and $status==$LINK_OK) {
					$status = $LINK_UPLOAD;
				}
				echo ': <b>'.$vbphrase['ll_ok'].'</b><br />';
			}
		}

		($hook = vBulletinHook::fetch_hook('ldm_admin_validated')) ? eval($hook) : false;

		if (!isset($statuses[$status])) {
			$statuses[$status] = array();
		}
		$statuses[$status][] = $linkid;

		$num++;
		flush();
	}

	foreach ($statuses as $thisstatus=>$theselinkids) {
		if (count($theselinkids)) {
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkstatus='".$thisstatus."',
					linkcheck='".TIMENOW."'
				WHERE linkid IN (".implode(',', $theselinkids).")
				");
		}
	}

	if ($num >= $limit) {
		sleep(1);
		$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=dovalidate&amp;status=".$lstatus."&at=$nextid&total=$total&done=$done";
		ldm_doredirect($url);
	}
	else {
		$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=admin&amp;set=validate";
		ldm_doredirect($url);
	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	ldm_dopagefoot();

}

/* ===========================================================================*/
// Fall through
/* ===========================================================================*/

$vbulletin->url = $ADMIN_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'];
eval(print_standard_redirect($vbphrase['ll_error_command'],0));
exit;

?>