<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_links_actions');
define('CSRF_PROTECTION', true);

// get special phrase groups
$phrasegroups = array(
	'local_links',
	'local_links_entities',
	'threadmanage',
	'posting',
	'postbit'
);

// pre-cache all templates used by this hack
$globaltemplates = array(
	'links_downloadbit',
	'links_editbit',
	'links_favbit',
	'links_footer',
	'links_header',
	'links_imgmag',
	'links_likebit',
	'links_linkseparator',
	'links_navbar',
	'links_navbar_popups',
	'links_nominatebit',
	'links_nominated_leaderbit',
	'links_reportlinkbit',
	'links_sendtofriendbit',
	'links_main',
	'links_moderate_linkbit',
	'links_moderate_select',
	'links_othercatsbit',
	'links_ratebit_dropdown',
	'links_ratebit_inline',
	'STANDARD_ERROR_LITE',
	);

// get special data templates from the datastore
$specialtemplates = array(
	'attachmentcache',
	'smiliecache',
	'bbcodecache',
	'ldm_admin',
	'ldm_cats',
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// fire up VBulletin backend
require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');
require_once(DIR . '/includes/local_links_actions.php');

($hook = vBulletinHook::fetch_hook('ldm_start')) ? eval($hook) : false;
($hook = vBulletinHook::fetch_hook('ldm_actions_start')) ? eval($hook) : false;

$vbulletin->input->clean_array_gpc('r', array(
	'action'	=> TYPE_STR,
	'pp'		=> TYPE_INT,
	'page'		=> TYPE_INT
	));

$this_action = $vbulletin->GPC['action'];

if ($vbulletin->GPC_exists['pp']) {
	$perpage = $vbulletin->GPC['pp'];
}
else {
	$perpage = $vbulletin->userinfo['maxposts'];
	$checkmax = explode(',', $vbulletin->options['usermaxposts'] . ',' . $vbulletin->options['maxposts']);
	if ($perpage < 1 OR $perpage > max($checkmax)) $perpage = $vbulletin->options['maxposts'];
	$perpage = ($links_defaults['links_per_page']!=0 ? $links_defaults['links_per_page'] : $perpage);
}

$pagenumber = ($vbulletin->GPC_exists['page'] ? $vbulletin->GPC['page'] : 1);
$master_title = htmlspecialchars_uni(($links_defaults['database_name'] ? $links_defaults['database_name'] : $vbphrase['ll_links_database']));

/* ===========================================================================*/
// Follow-up ('do') command functions
/* ===========================================================================*/

if ($this_action == "domod") {

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'id' => TYPE_INT,
		'catid' => TYPE_INT,
		'catpage' => TYPE_INT,
	));

	$this_navigation_title = $vbphrase['ll_links_moderation'];

	construct_forum_jump();
	unset($linkid);
	unset($viewcatid);
	if ($vbulletin->GPC_exists['id']) {
		$linkid = $vbulletin->GPC['id'];
	}

	$viewcatid = $vbulletin->GPC['catid'];
	if (!isset($linkid) and !isset($viewcatid)) {
		eval(standard_error($vbphrase['ll_error_catlinknull'].' <a href="'.$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'].'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$catpage = ($vbulletin->GPC['catpage'] ? $vbulletin->GPC['catpage'] : 1);

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = ldm_lookup_forum_protections($can_bypass);

	if (isset($linkid)) {
		$where[] = "link.linkid = '".$linkid."'";
	}
	$where[] = "ltoc.catid = '".$viewcatid."'";
	$where[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
	$where[] = "(link.linkmoderate = ".$LINK_TO_MODERATE."
					OR
				(link.linkreviewfreq>0 AND (link.linkmoddate+link.linkreviewfreq*24*60*60)<".TIMENOW.")
				)";
	$order = "linkcatid, linkname";
	$query = ldm_get_mainsql($where, 0, 0, $order);
	$catlistbit   = "";

	$linklistarray = array();
	$pagenav = "";
	$entrybits_option = array('showcatname'=>1, 'forcedisplayorder'=>1, 'viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid,);
	if (isset($viewcatid)) {
		$nhits = ldm_get_entrybits($linklistarray, $hitids, $expiredids, 'links_moderate_linkbit', $query, $entrybit_options, $pagenumber, $perpage);
		$linklistbit = ldm_map_listbit_to_grid($linklistarray, 1, 1);
		$pagenav = construct_page_nav($pagenumber, $perpage, $nhits, $ACTION_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=domod&amp;catid=$viewcatid&amp;catpage=$catpage", "&amp;pp=$perpage");
	}
	else {
		$nhits = ldm_get_entrybits($linklistarray, $hitids, $expiredids, 'links_moderate_linkbit', $query, $entrybit_options);
		$linklistbit = ldm_map_listbit_to_grid($linklistarray, 1, 1);
	}

	$linkratingspopupbit = "";
	if ($links_defaults["dropdown_comment_and_rate"]>0) {
		$linkratings = ldm_get_ratingsbits($hitids, $pagenumber, 0);
		$linkratingspopupbit = implode("", $linkratings);
	}

	$navbits = array();
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $this_navigation_title;

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$pcatid   = $linkscat[$viewcatid]["parentid"];
	$viewcatname  = $linkscat[$viewcatid]["catname_clean"];
	$message = ($nhits ? $nhits : 0) . ' ' . $vbphrase['ll_entries_to_moderate'];
	$viewcatdesc = $message;
	$viewcattext = $message;

	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;
	$links_permissions["can_add_link"] = 0;

	($hook = vBulletinHook::fetch_hook('ldm_moderate_select')) ? eval($hook) : false;

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_moderate_select')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Do (Moderate) Categories

if ($this_action == "domodcats") {

	$url = $LINKS_SCRIPT.".php".$vbulletin->session->vars['sessionurl_q'];

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'modcatid' => TYPE_ARRAY_INT,
		'catpage' => TYPE_INT,
		'domod' => TYPE_STR,
	));

	$domod = $vbulletin->GPC['domod'];
	$catpage = ($vbulletin->GPC['catpage'] ? $vbulletin->GPC['catpage'] : 1);

	$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=mod&amp;page=".$catpage;

	switch ($domod) {
	case 'accept':
		$query = "UPDATE ".THIS_TABLE."linkscat
			SET
				catmoderate='".$LINK_ACCEPTED."'
			WHERE catid IN (0,".implode(',',$vbulletin->GPC['modcatid']).")
			";
		$vbulletin->db->query_write($query);
		ldm_datastore_markdirty('ldm_cats');
		$reply = $vbphrase['ll_accepted'];
		break;

	case 'delete':
    	require_once(DIR . '/includes/local_links_misc.php');
		ldm_empty_category($vbulletin->GPC['modcatid'], 1);
		ldm_delete_category($vbulletin->GPC['modcatid']);
		ldm_fix_cat_count();
		$reply = $vbphrase['ll_deleted'];
		break;

	default:
		print_no_permission();
		exit;
	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	($hook = vBulletinHook::fetch_hook('ldm_moderate_category_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($reply,0));

}

// #################### Do (Moderate) Entries

if ($this_action == "domodlinks") {

	$url = $LINKS_SCRIPT.".php".$vbulletin->session->vars['sessionurl_q'];

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'linkid' => TYPE_ARRAY_INT,
		'catid' => TYPE_INT,
		'catpage' => TYPE_INT,
		'domod' => TYPE_STR,
	));

	$domod = $vbulletin->GPC['domod'];
	$viewcatid = $vbulletin->GPC['catid'];
	$catpage = ($vbulletin->GPC['catpage'] ? $vbulletin->GPC['catpage'] : 1);
	$auto_errormessages = array();

	$url = $ACTION_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=domod&amp;catid=".$viewcatid.'&amp;catpage='.$catpage;

	if (count($vbulletin->GPC['linkid'])) {

		switch ($domod) {

		case 'acceptannounce':
		case 'accept':
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkmoderate='".$LINK_ACCEPTED."',
					linkmoddate='".TIMENOW."'
				WHERE linkid IN (0,".implode(',',$vbulletin->GPC['linkid']).")
				";
			$vbulletin->db->query_write($query);

			if ($links_defaults['moderate_email_accept']) {
				require_once(DIR . '/includes/local_links_misc.php');
				foreach ($vbulletin->GPC['linkid'] as $linkid) {
					ldm_notify_moderated($linkid, $viewcatid, 1);
				}
			}

			$reply = $vbphrase['ll_moderate_accepted'];
			break;

		case 'hide':
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkmoderate='".$LINK_TO_MODERATE."',
					linkstatus='".$LINK_HIDDEN."',
					linkmoddate='".TIMENOW."'
				WHERE linkid IN (0,".implode(',',$vbulletin->GPC['linkid']).")
				";
			$vbulletin->db->query_write($query);

			$reply = $vbphrase['ll_hidden'];
			break;

		case 'unhide':
			$query = "
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkmoderate='".$LINK_TO_MODERATE."',
					linkstatus='".$LINK_OK."',
					linkmoddate='".TIMENOW."'
				WHERE linkid IN (0,".implode(',',$vbulletin->GPC['linkid']).")
				";
			$vbulletin->db->query_write($query);

			$reply = $vbphrase['ll_unhidden'];
			break;

		case 'delete':
            require_once(DIR . '/includes/local_links_misc.php');
			ldm_delete_entry($vbulletin->GPC['linkid']);
			ldm_fix_cat_count();

			if ($links_defaults['moderate_email_accept']) {
				require_once(DIR . '/includes/local_links_misc.php');
				foreach ($vbulletin->GPC['linkid'] as $linkid) {
					ldm_notify_moderated($linkid, $viewcatid, 0);
				}
			}

			$reply = $vbphrase['ll_deleted'];
			break;

		default:
			print_no_permission();
			exit;
		}

// Repeat the switch for follow-up actions
		switch ($domod) {

		case 'acceptannounce':
			if ($links_defaults['autocreate_active']) {

				$query = "
					SELECT links.linkid AS linkid, links.linkname AS linkname, links.linkdesc AS linkdesc,
						links.linkimg AS linkimg, links.linkforum AS linkforum,
						links.linkusername AS linkusername, links.linkuserid AS linkuserid,
						ltoc.catid AS catid
					FROM ".THIS_TABLE."linkslink AS links
					LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
					ON links.linkid=ltoc.linkid
					WHERE links.linkid IN (".implode(',', $vbulletin->GPC['linkid']).")
					AND links.linkthread=0
					ORDER BY links.linkid
					";
				$asb = $vbulletin->db->query_read($query);

				$thislinkid = -1;

				while ($row=$vbulletin->db->fetch_array($asb)) {
					if ($thislinkid!=$row['linkid']) {
						$thislinkid = $row['linkid'];
						$auto_announced = array();
					}
					$thiscatid = $row['catid'];

					$auto_active = ldm_lookup_setting($thiscatid, 'autocreate_active');
					$auto_forum = ldm_lookup_setting($thiscatid, 'autocreate_forum');
					$auto_forum = ($auto_forum>0 ? $auto_forum : $row['linkforum']);
					if (!$auto_active or $auto_forum<=0 or isset($auto_announced[$thislinkid])) {
						continue;
					}
					$auto_announced[$thislinkid] = 1;

            		$auto_prefix = ldm_lookup_setting($thiscatid, 'autocreate_prefix');

                    if ($auto_prefix) {
        				require_once(DIR . '/includes/local_links_forumsinterface.php');
                        if (!ldm_validate_threadprefix($auto_prefix, $thiscatid, $auto_forum)) {
                            $auto_prefix = "";
                        }
                    }

					require_once(DIR . '/includes/local_links_forumsinterface.php');
					$thisuserid = ldm_lookup_setting($thiscatid, 'autocreate_userid');
					if (!$thisuserid) {
						$thisusername = $row['linkusername'];
						$thisuserid = $row['linkuserid'];
					}
					else {
						$thisusername = ldm_lookup_setting($thiscatid, 'autocreate_username');
					}

					list($auto_error, $auto_reply) = ldm_announce_in_forum(
						$auto_forum,
						ldm_lookup_setting($thiscatid, 'autocreate_both_ways'),
						$thislinkid,
						$thiscatid,
						$row['linkname'],
						$row['linkdesc'],
						(in_array(strtolower(file_extension($row['linkimg'])), array("jpg", "gif", "png")) ? $row['linkimg'] : ""),
						$auto_prefix,
						$thisusername,
						$thisuserid
						);

					if ($auto_error) {
						$auto_errormessages[$thislinkid] = construct_phrase($vbphrase['ll_moderate_announcewarning'], $linkid, $auto_reply);
					}

				}
			}

			if (count($auto_errormessages)) {
				eval(standard_error(construct_phrase($vbphrase['ll_moderate_warnings'], $reply, $url, implode('<br />', $auto_errormessages))));
				exit;
			}

			break;

		default:
			break;
		}

	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	($hook = vBulletinHook::fetch_hook('ldm_moderate_entry_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($reply,0));

}

// #################### Do (Add) Entry

if ($this_action == "doaddlink") {

	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_INT,
		'change_display_order' => TYPE_INT,
		'date' => TYPE_ARRAY_STR,
		'display_order' => TYPE_INT,
		'entities' => TYPE_ARRAY_ARRAY,
		'hide' => TYPE_INT,
		'keywords' => TYPE_ARRAY_STR,
		'linkautocreate' => TYPE_INT,
		'linkautoprefix' => TYPE_STR,
		'linkdoi' => TYPE_STR,
		'linkdups' => TYPE_INT,
		'linkfile' => TYPE_STR,
		'linkimg' => TYPE_STR,
		'linkname' => TYPE_STR,
		'linkreviewfreq' => TYPE_INT,
		'linkuploadfile' => TYPE_STR,
		'linkurl' => TYPE_STR,
		'linkuser' => TYPE_STR,
		'message' => TYPE_STR,
		'newkeywords' => TYPE_STR,
		'pcatid' => TYPE_ARRAY_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
		'wysiwyg' => TYPE_BOOL,
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'entityfiles' => TYPE_ARRAY_FILE,
	));

	if ($vbulletin->GPC['wysiwyg']) {
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else {
		$message =& $vbulletin->GPC['message'];
	}

	$viewcatid 	= $vbulletin->GPC['catid'];

	$catuserid   = $linkscat[$viewcatid]["catuserid"];
	if ($vbulletin->userinfo['userid']==$catuserid) {
		$links_permissions["can_add_link"] = 1;
	}

	if (!$links_permissions["can_add_link"]) {
		print_no_permission();
		exit;
	}

	$pcatid		= $vbulletin->GPC['pcatid'];  // an array ...
	$pforum		= $vbulletin->GPC['pforum'];
	$linkname 	= $vbulletin->GPC['linkname'];
	$linkdoi 	= $vbulletin->GPC['linkdoi'];
	$linkurl 	= $vbulletin->GPC['linkurl'];
	$linkuploadfile = $vbulletin->GPC['linkuploadfile'];
	$linkimg 	= $vbulletin->GPC['linkimg'];
	$linkfile	= $vbulletin->GPC['linkfile'];
	$linkdesc	= $message;
	$linkdups	= $vbulletin->GPC['linkdups'];
	$display_order = $vbulletin->GPC['display_order'];
	$change_display_order = $vbulletin->GPC['change_display_order'];
	$linkreviewfreq = $vbulletin->GPC['linkreviewfreq'];
	$linkuser 	= $vbulletin->GPC['linkuser'];

	$linkkeywords = $vbulletin->GPC['keywords'];
	$linknewkeywords = $vbulletin->GPC['newkeywords'];
	$linkentities = $vbulletin->GPC['entities'];
	$linkentityfiles = $vbulletin->GPC['entityfiles'];

	$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid";

	if (!$vbulletin->GPC_exists['submit']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
		exit;
	}

	if ($pforum<=0) { $pforum = $DEFAULT_FORUMID; }

	$linkusergroupid = $vbulletin->userinfo['usergroupid'];
	if ($linkusergroupid<=1) {
		if (!is_valid_email($linkuser)) {
			$err = $vbphrase['ll_error_email'].' '.$linkuser.'. <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
		$linkuserid = $vbulletin->userinfo['userid'];
	}
	else {
		if ($linkuser) {
			$userinfo = ldm_lookup_userids(array($linkuser));
			$linkuserid = $userinfo[0];
			if (!$linkuserid) {
				$err = construct_phrase($vbphrase['ll_error_username'],$linkuser).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
				eval(standard_error($err));
				exit;
			}
		}
		else {
			$linkuser = $vbulletin->userinfo['username'];
			$linkuserid = $vbulletin->userinfo['userid'];
		}
	}

	if (!ldm_forumid_is_valid($pforum)) {
		$err = $vbphrase['ll_error_forum'].' '.$pforum.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	if (!ldm_catid_is_valid($pcatid)) {
		$err = $vbphrase['ll_error_catnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	$closed = "";
	foreach ($pcatid as $thiscat) {
		if ($linkscat[$thiscat]["catclosed"] and !$links_permissions["can_admin_links"]) {
			$closed .= $linkscat[$thiscat]["catname_clean"].' ';
		}
	}
	if ($closed) {
		$err = construct_phrase($vbphrase['ll_error_catclosed'],$closed).$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	if (!$linkname) {
		$err = $vbphrase['ll_error_linknull'].$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	if ($links_permissions['must_add_keyword'] and
		!count($linkkeywords) and !$linknewkeywords) {
		$err = $vbphrase['ll_error_keywords_required'].$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	if ($linkdoi) {
		$row = $vbulletin->db->query_first("
			SELECT linkid, linkdoi
			FROM ".THIS_TABLE."linkslink
			WHERE linkdoi LIKE ('".$linkdoi."')
			LIMIT 1
		");
		if ($row['linkid']) {
			$err = construct_phrase($vbphrase['ll_error_doi_exists'], $linkdoi, $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'linkid='.$row['linkid']).
				$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
	}

	$date = $vbulletin->GPC['date'];
	if ($date['ampm']==2 and $date['hour']<=12) $date['hour'] +=12;
	if ($date['now']) {
		$linkdate = TIMENOW;
	}
	else {
		require_once(DIR . '/includes/functions_misc.php');
		$linkdate = vbmktime($date['hour'], $date['min'], 0, $date['month'], $date['day'], $date['year']);
		if ($linkdate<0 or $date['hour']<0 or $date['hour']>24 or $date['min']<0 or $date['min']>60 or $date['day']>31) {
			$err = $vbphrase['ll_error_date'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
	}

    $vbstrlen = vbstrlen($linkdesc);
	if ($vbstrlen<$links_defaults['min_textlength'] and $links_defaults['min_textlength'] != 0) {
		eval(standard_error(fetch_error('tooshort', $vbstrlen, $links_defaults['min_textlength'])));
	}

	if ($vbstrlen>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
		eval(standard_error(fetch_error('toolong', $vbstrlen, $links_defaults['max_textlength'])));
	}

	if ($linkuploadfile) { // swfuploader

		$linkurl = $linkuploadfile;
		if (!$linkfile) { // Default to a standardised name
			$linkfile = basename($linkurl);
            $linkfile = 'download' . '.' . file_extension($linkfile);
		}

		($hook = vBulletinHook::fetch_hook('ldm_upload_completed')) ? eval($hook) : false;

		$statuscheck = $LINK_UPLOAD;
		$filesize = ldm_get_sizeof_url($linkurl);

	}
	elseif ($linkurl) {

		$statuscheck = ldm_check_url($linkurl);
		$filesize = ($statuscheck==$LINK_OK ? ldm_get_sizeof_url($linkurl) : 0);

	}
	else {
		$vbulletin->input->clean_array_gpc('f', array(
			'linkupload' => TYPE_FILE
		));
		if ($vbulletin->GPC['linkupload']['name']) {

			$linkupload = $vbulletin->GPC['linkupload'];

			if (!$linkfile) {
				$linkfile = $linkupload['name'];
			}

			if (!ldm_process_upload($linkupload, $linkurl, $links_defaults['upload_filetypes'], $err)) {
				eval(standard_error($err));
				exit;
			}

			($hook = vBulletinHook::fetch_hook('ldm_upload_completed')) ? eval($hook) : false;

			$filesize = ldm_get_sizeof_url($linkurl);
			$statuscheck = $LINK_UPLOAD;
			if ($linkfile) {
				ldm_fix_filename($linkfile, 1);
			}

		}
		elseif ($links_defaults["allow_null_links"]) {
			$statuscheck = $LINK_OK;
			$filesize = 0;
			$linkdups = 1;
		}
		else {
			$err = $vbphrase['ll_error_urlnull'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

	}

	if ($statuscheck == $LINK_NO_ACCESS) {
		$err = $vbphrase['ll_error_protocol'].' '.$linkurl.$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}
	elseif ($statuscheck == $LINK_NO_REMOTE_DOWNLOADS) {
		$err = $vbphrase['ll_error_remote'].' '.$linkurl.$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	if ($linkfile and $linkurl) {
	    $linktype = file_extension($linkurl);
    	if (!ldm_known_filetype($linktype)) {
    	    $linkfile = ""; // filename is irrelevant for links
    	}
    }

	if ($linkfile and $linkurl) {
		if (ldm_fix_filename($linkfile)) {
			$err = construct_phrase($vbphrase['ll_error_rename_name'], $linkfile).$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
		$lft_url = strtolower(file_extension($linkurl));
		$lft_fil = strtolower(file_extension($linkfile));
		if ($lft_fil != $lft_url) {
			$err = $vbphrase['ll_error_rename_type'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
	}

	$imgstatuscheck = 0;

	$vbulletin->input->clean_array_gpc('f', array(
		'imgupload' => TYPE_FILE
	));

	if ($vbulletin->GPC['imgupload']['name']) {
		if (!ldm_process_upload($vbulletin->GPC['imgupload'], $linkimg, $links_defaults['image_filetypes'], $err, "imageuploads")) {
			eval(standard_error($err.$vbphrase['ll_goback']));
			exit;
		}
		$imgstatuscheck = $LINK_UPLOAD;
	}

	if (!$linkimg) {
		ldm_set_autoimage($linkurl, $linkimg);
		$imgstatuscheck = $statuscheck;
	}
	else {
		$imgcheck = ldm_check_url($linkimg);

		if ($imgcheck == $LINK_NO_ACCESS) {
			$err = $vbphrase['ll_error_protocol'].' ['.$linkimg.']'.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
		elseif ($imgcheck == $LINK_NO_REMOTE_DOWNLOADS) {
			$err = $vbphrase['ll_error_remote'].' ['.$linkimg.']'.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		if (!$imgstatuscheck) {
			$imgstatuscheck = $imgcheck;
		}

        require_once (DIR . '/includes/local_links_images.php');
        if (ldm_can_handle_as_image($linkimg)<=0 and ldm_can_handle_as_mediaimage($linkimg)<=0) {
			$err = $vbphrase['ll_error_invalidimage'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
        }
	}

	$linkimgthumb = "";
	$linkimgthumbsize = 0;
	if ($imgstatuscheck and $links_defaults['thumbs_dir'] and $links_defaults['create_thumbs_oninsert']) {
		require_once(DIR . '/includes/local_links_images.php');
		$thumb = ldm_make_thumbnail($linkimg, $links_defaults['link_imagesize']);
		if ($thumb) {
			$linkimgthumb = ldm_save_thumbnail($thumb, $links_defaults['thumbs_dir']);
			$linkimgthumbsize = $links_defaults['link_imagesize'];
		}
	}

	$moderate = $LINK_ACCEPTED;
	$moderate_email_submit = 0;
	foreach ($pcatid as $thiscat) {
		if (ldm_lookup_permission($thiscat, 'can_moderate_links')) {
			continue;
		}
		if (ldm_lookup_setting($thiscat, 'moderate_links')) {
			$moderate = $LINK_TO_MODERATE;
		}
		if (ldm_lookup_setting($thiscat, 'autocreate_require_moderate')
		    and ldm_lookup_setting($thiscat, 'autocreate_active')
		    and $vbulletin->GPC['linkautocreate']) {
			$moderate = $LINK_TO_MODERATE;
		}
		if (ldm_lookup_setting($thiscat, 'moderate_email_submit')) {
			$moderate_email_submit = 1;
		}
	}

	if ($vbulletin->GPC['hide'] and ($statuscheck==$LINK_OK or $statuscheck==$LINK_UPLOAD)) {
		$statuscheck = $LINK_HIDDEN;
	}

	require_once(DIR . '/includes/functions_newpost.php');
	$linkdesc = convert_url_to_bbcode($linkdesc);

	($hook = vBulletinHook::fetch_hook('ldm_addlink_preinsert')) ? eval($hook) : false;

	require_once(DIR . '/includes/local_links_misc.php');
	$ldm_entry = ldm_entry_template(
		array(
			'linkname' => $linkname,
			'linkdesc' => $linkdesc,
			'linkdoi' => $linkdoi,
			'linkurl' => $linkurl,
			'linkfile' => $linkfile,
			'linkimg' => $linkimg,
			'linkimgthumb' => $linkimgthumb,
			'linkimgthumbsize' => $linkimgthumbsize,
			'linkforum' => $pforum,
			'linksize' => $filesize,
			'linkstatus' => $statuscheck,
			'linkimgstatus' => $imgstatuscheck,
			'linkdate' => $linkdate,
			'linkusername' => $linkuser,
			'linkuserid' => $linkuserid,
			'linkmoderate' => $moderate,
			'linkreviewfreq' => $linkreviewfreq,
			)
		);

	list ($insert_status, $linkid) = ldm_create_entry($ldm_entry, $linkdups);

	if ($insert_status<=0) {
		$message = $vbphrase['ll_error_linkduplicate'];
		if ($LDM_environment['is_admin']) {
			$message .= $vbphrase['ll_goback'];
		}
		eval(standard_error($message));
		exit;
	}

	if ($links_permissions['can_edit_entities'] and count($linkentities)) {
		require_once(DIR . '/includes/local_links_entities.php');
		if (!ldm_associate_entities($linkid, $linkentities, $linkentityfiles, $message)) {
            require_once(DIR . '/includes/local_links_misc.php');
			ldm_delete_entry($linkid); // unwind...
			eval(standard_error($message));
			exit;
		}
	}

	$dorder = array();
	foreach ($pcatid as $k=>$p) {
		$dorder[$k] = ($change_display_order==2 ? $display_order : ($p==$viewcatid ? $display_order : 1));
	}
	ldm_insert_entry_in_category($linkid, $pcatid, $dorder);

	if ($links_permissions['can_add_keyword'] or $links_permissions['can_edit_keyword']) {
		ldm_associate_keywords($linkid, $linkkeywords, 0);
		ldm_associate_keywords($linkid, ldm_lookup_keywords(ldm_explode_keywords($linknewkeywords)), 1);
	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	if ($moderate != $LINK_TO_MODERATE) {

		$message = $vbphrase['ll_accepted'];

		$auto_announced = array();
		$auto_img = (in_array(strtolower(file_extension($linkimg)), array("jpg", "gif", "png")) ? $linkimg : "");
		$auto_create = $vbulletin->GPC['linkautocreate'];
		$auto_error = 0;

		if ($auto_create) {
			foreach ($pcatid as $thiscat) {

				$auto_active = ldm_lookup_setting($thiscat, 'autocreate_active');
				$auto_forum = ldm_lookup_setting($thiscat, 'autocreate_forum');
				$auto_forum = ($auto_forum>0 ? $auto_forum : $pforum);

				if (!$auto_active or $auto_forum<=0 or isset($auto_announced[$auto_forum])) {
					continue;
				}

				require_once(DIR . '/includes/local_links_forumsinterface.php');

                if (ldm_lookup_setting($thiscat, 'autocreate_allow_userprefix')
                    and ldm_lookup_setting($thiscat, 'autocreate_require_userok')) {
            		$auto_prefix = $vbulletin->GPC['linkautoprefix'];
            	}
            	else {
            		$auto_prefix = ldm_lookup_setting($thiscat, 'autocreate_prefix');
            	}

                if ($auto_prefix) {
                    if (!ldm_validate_threadprefix($auto_prefix, $thiscat, $auto_forum)) {
                        $auto_prefix = "";
                    }
                }

				$auto_userid = ldm_lookup_setting($thiscat, 'autocreate_userid');
				if ($auto_userid) {
					$auto_username = ldm_lookup_setting($thiscat, 'autocreate_username');
				}
				else {
					$auto_username = $vbulletin->userinfo['username'];
					$auto_userid = $vbulletin->userinfo['userid'];
				}

				$auto_bothways = ldm_lookup_setting($thiscat, 'autocreate_both_ways');

				list($auto_error, $message) = ldm_announce_in_forum(
					$auto_forum,
					$auto_bothways,
					$linkid,
					$thiscat,
					$linkname,
					$linkdesc,
					$auto_img,
					$auto_prefix,
					$auto_username,
					$auto_userid
					);

				$auto_announced[$auto_forum] = 1;

			}
		}

		if ($links_defaults['validate_on_entry'] and !$statuscheck) {
			$eurl = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=editlink&amp;linkid=$linkid&amp;catid=$viewcatid";
			$message = $vbphrase['ll_error_linkcheckfailed'].' <a href="'.$linkurl.'" target="_blank">'.$linkurl.'</a><br /><br />'.
				'<a href="'.$url.'"><b>'.$vbphrase['ll_accept'].'</b></a>&nbsp;&nbsp;<a href="'.$eurl.'"><b>'.$vbphrase['ll_modify'].'</b></a>'
				;
			eval(standard_error($message));
		}

		($hook = vBulletinHook::fetch_hook('ldm_addlink_inserted')) ? eval($hook) : false;

		$vbulletin->url = $url."#linkid".$linkid;

		if ($auto_error) {
			eval(standard_error($message.'<br /><br /><a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}

		eval(print_standard_redirect($message,0));

	}
	else {

		if ($links_defaults['validate_on_entry'] and !$statuscheck) {
			$eurl = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=editlink&linkid=$linkid&catid=$viewcatid";
			$message = $vbphrase['ll_error_linkcheckfailed'].' <a href="'.$linkurl.'" target="_blank">'.$linkurl.
				'</a><br /><a href="'.$url.'"><b>'.$vbphrase['ll_accept'].'</b></a>&nbsp;&nbsp;<a href="'.$eurl.'"><b>'.
				$vbphrase['ll_modify'].'</b></a>'
				;
			eval(standard_error($message));
		}

		if ($moderate_email_submit) {
			require_once(DIR . '/includes/local_links_misc.php');
			$subject = construct_phrase($vbphrase['ll_admin_newentry_subject'], $vbulletin->options['bbtitle']);
			$modemails = array();
			foreach ($pcatid as $thiscatid) {
				$mod_users = ldm_lookup_userids(explode(';', ldm_lookup_setting($thiscatid, 'moderate_usernames')));
				$mods = ldm_fetch_moderators($thiscatid, $mod_users);
				foreach ($mods AS $index => $moderator) {
					$modemail = $moderator['email'];
					if ($modemail and empty($modemails[$modemail])) {
						$message = construct_phrase($vbphrase['ll_admin_newentry_body'],
							$vbulletin->userinfo['username'],
							$vbulletin->userinfo['email'],
							ldm_make_filename($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$thiscatid.'&linkid='.$linkid)
							);
						$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);
						vbmail($modemail, $subject, $message, true);
						$modemails[$modemail] += 1;
					}
				}
			}
		}

		$message = $vbphrase['ll_submit_moderation'];
		$error = 0;
		($hook = vBulletinHook::fetch_hook('ldm_addlink_inserted_tomoderate')) ? eval($hook) : false;
		$vbulletin->url = $url."#linkid".$linkid;
		if ($error) {
			eval(standard_error($message.'<br /><br /><a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
		eval(print_standard_redirect($vbphrase['ll_submit_moderation'],0));
	}
	exit;

}

// #################### Do (Add) Multiple Entries

if ($this_action == "domultilink") {

	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_INT,
		'change_display_order' => TYPE_ARRAY_INT,
		'date' => TYPE_ARRAY_ARRAY,
		'display_order' => TYPE_ARRAY_INT,
		'linkautocreate' => TYPE_ARRAY_INT,
		'linkautoprefix' => TYPE_ARRAY_STR,
		'linkdoi' => TYPE_ARRAY_STR,
		'linkdups' => TYPE_ARRAY_INT,
		'linkfile' => TYPE_ARRAY_STR,
		'linkhide' => TYPE_ARRAY_INT,
		'linkimg' => TYPE_ARRAY_STR,
		'linkname' => TYPE_ARRAY_STR,
		'linkreviewfreq' => TYPE_ARRAY_INT,
		'linkurl' => TYPE_ARRAY_STR,
		'linkuser' => TYPE_STR,
		'message' => TYPE_ARRAY_STR,
		'newkeywords' => TYPE_ARRAY_STR,
		'numadd' => TYPE_INT,
		'pcatid' => TYPE_ARRAY_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'linkupload' => TYPE_FILE,
		'imgupload' => TYPE_FILE,
	));

	$viewcatid 	= $vbulletin->GPC['catid'];
	$numadd 	= $vbulletin->GPC['numadd'];

	$catuserid   = $linkscat[$viewcatid]["catuserid"];
	if ($vbulletin->userinfo['userid']==$catuserid) {
		$links_permissions["can_add_link"] = 1;
	}

	if (!$links_permissions["can_add_link"]) {
		print_no_permission();
		exit;
	}

	$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid";

	if (!$vbulletin->GPC_exists['submit']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
		exit;
	}

	$pcatid	= $vbulletin->GPC['pcatid'];  // an array ...
	$linkuser = $vbulletin->GPC['linkuser'];

	$pforum	= $vbulletin->GPC['pforum'];
	if ($pforum<=0) { $pforum = $DEFAULT_FORUMID; }

	$linkusergroupid = $vbulletin->userinfo['usergroupid'];
	if ($linkusergroupid<=1) {
		if (!is_valid_email($linkuser)) {
			$err = $vbphrase['ll_error_email'].' '.$linkuser.'. <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
		$linkuserid = $vbulletin->userinfo['userid'];
	}
	else {
		if ($linkuser) {
			$userinfo = ldm_lookup_userids(array($linkuser));
			$linkuserid = $userinfo[0];
			if (!$linkuserid) {
				$err = construct_phrase($vbphrase['ll_error_username'],$linkuser).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
				eval(standard_error($err));
				exit;
			}
		}
		else {
			$linkuser = $vbulletin->userinfo['username'];
			$linkuserid = $vbulletin->userinfo['userid'];
		}
	}

	if (!ldm_forumid_is_valid($pforum)) {
		$err = $vbphrase['ll_error_forum'].' '.$pforum.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	if (!ldm_catid_is_valid($pcatid)) {
		$err = $vbphrase['ll_error_catnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	$closed = "";
	foreach ($pcatid as $thiscat) {
		if ($linkscat[$thiscat]["catclosed"] and !$links_permissions["can_admin_links"]) {
			$closed .= $linkscat[$thiscat]["catname_clean"].' ';
		}
	}
	if ($closed) {
		$err = construct_phrase($vbphrase['ll_error_catclosed'],$closed).$vbphrase['ll_goback'];
		eval(standard_error($err));
		exit;
	}

	$array_linkname 	= $vbulletin->GPC['linkname'];
	$array_linkurl 		= $vbulletin->GPC['linkurl'];
	$array_linkimg 		= $vbulletin->GPC['linkimg'];
	$array_linkhide		= $vbulletin->GPC['linkhide'];
	$array_linkfile		= $vbulletin->GPC['linkfile'];
	$array_linkdoi 		= $vbulletin->GPC['linkdoi'];
	$array_linkdesc		= $vbulletin->GPC['message'];
	$array_linkupload	= $vbulletin->GPC['linkupload'];
	$array_imgupload	= $vbulletin->GPC['imgupload'];
	$array_newkeywords	= $vbulletin->GPC['newkeywords'];
	$array_linkdups		= $vbulletin->GPC['linkdups'];
	$array_date			= $vbulletin->GPC['date'];

	$array_change_display_order = $vbulletin->GPC['change_display_order'];
	$array_display_order = $vbulletin->GPC['display_order'];
	$array_autocreate	= $vbulletin->GPC['linkautocreate'];
	$array_reviewfreq	= $vbulletin->GPC['linkreviewfreq'];

	$errors = array();

// Validate everything first
	for ($thislink=1; $thislink<=$numadd; $thislink++) {

		$linkname	= $array_linkname[$thislink];
		$linkurl	= $array_linkurl[$thislink];
		$linkimg 	= $array_linkimg[$thislink];
		$linkfile	= $array_linkfile[$thislink];
		$linkdoi 	= $array_linkdoi[$thislink];
		$linkdesc	= $array_linkdesc[$thislink];
		$newkeywords= $array_newkeywords[$thislink];
		$linkdups	= $array_linkdups[$thislink];
		$linkdate	= $array_date[$thislink];

		$linkupload = array();
		foreach ($array_linkupload as $k=>$v) {
			$linkupload[$k] = $array_linkupload[$k][$thislink];
		}
		foreach ($array_imgupload as $k=>$v) {
			$imgupload[$k] = $array_imgupload[$k][$thislink];
		}

		if (!$linkname and !$linkdesc) {
			continue;
		}

		if ($links_permissions['must_add_keyword'] and !$newkeywords) {
			$errors[$thislink][] = $vbphrase['ll_error_keywords_required'];
		}

		if ($linkdoi) {
			$row = $vbulletin->db->query_first("
				SELECT linkid, linkdoi
				FROM ".THIS_TABLE."linkslink
				WHERE linkdoi LIKE ('".$linkdoi."')
				LIMIT 1
			");
			if ($row['linkid']) {
				$errors[$thislink][] = construct_phrase($vbphrase['ll_error_doi_exists'], $linkdoi, $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'linkid='.$row['linkid']);
			}
		}

        $vbstrlen = vbstrlen($linkdesc);
	    if ($vbstrlen<$links_defaults['min_textlength'] and $links_defaults['min_textlength'] != 0) {
		    eval(standard_error(fetch_error('tooshort', $vbstrlen, $links_defaults['min_textlength'])));
	    }

    	if ($vbstrlen>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
	    	eval(standard_error(fetch_error('toolong', $vbstrlen, $links_defaults['max_textlength'])));
	    }

		if ($linkurl) {

			if ($linkdups!=1) {
				$asb = $vbulletin->db->query_read("
					SELECT linkid FROM ".THIS_TABLE."linkslink
					WHERE linkurl='".$vbulletin->db->escape_string($linkurl)."'
					");
				$count = $vbulletin->db->num_rows($asb);
				$vbulletin->db->free_result($asb);
				if ($count) {
					$errors[$thislink][] = $vbphrase['ll_error_linkduplicate'];
					continue;
				}
			}

			$statuscheck = ldm_check_url($linkurl);
			$filesize = ($statuscheck==$LINK_OK ? ldm_get_sizeof_url($linkurl) : 0);

		}
		else {
			if ($linkupload['name']) {
				if (!ldm_process_upload($linkupload, $linkurl, $links_defaults['upload_filetypes'], $err)) {
					$errors[$thislink][] = $err;
				}
				else {

					if (!$linkfile) {
						$linkfile = $linkupload['name'];
					}

					($hook = vBulletinHook::fetch_hook('ldm_upload_completed')) ? eval($hook) : false;

					$statuscheck = $LINK_UPLOAD;
					$filesize = ldm_get_sizeof_url($linkurl);

					if ($linkfile) {
						ldm_fix_filename($linkfile, 1);
					}

				}
			}
			elseif ($links_defaults["allow_null_links"]) {
				$statuscheck = $LINK_OK;
				$filesize = 0;
				$linkdups = 1;
			}
			else {
				$errors[$thislink][] = $vbphrase['ll_error_urlnull'];
			}

		}

		if ($statuscheck == $LINK_NO_ACCESS) {
			$errors[$thislink][] = $vbphrase['ll_error_protocol'].' '.$linkurl;
		}
		elseif ($statuscheck == $LINK_NO_REMOTE_DOWNLOADS) {
			$errors[$thislink][] = $vbphrase['ll_error_remote'].' '.$linkurl;
		}

    	if ($linkfile and $linkurl) {
	        $linktype = file_extension($linkurl);
    	    if (!ldm_known_filetype($linktype)) {
    	        $linkfile = ""; // filename is irrelevant for links
    	    }
        }

		if ($linkfile and $linkurl) {
			if (ldm_fix_filename($linkfile)) {
				$errors[$thislink][] = construct_phrase($vbphrase['ll_error_rename_name'], $linkfile);
			}
			$lft_url = strtolower(file_extension($linkurl));
			$lft_fil = strtolower(file_extension($linkfile));
			if ($lft_fil != $lft_url) {
				$errors[$thislink][] = $vbphrase['ll_error_rename_type'];
			}
		}

		$imgstatuscheck = 0;

		if ($imgupload['name']) {
			if (!ldm_process_upload($imgupload, $linkimg, $links_defaults['image_filetypes'], $err, "imageuploads")) {
				$errors[$thislink][] = $err;
			}
			$imgstatuscheck = $LINK_UPLOAD;
		}

		if (!$linkimg) {
			ldm_set_autoimage($linkurl, $linkimg);
			$imgstatuscheck = $statuscheck;
		}
		else {
			$imgcheck = ldm_check_url($linkimg);
			if ($imgcheck == $LINK_NO_ACCESS) {
				$errors[$thislink][] = $vbphrase['ll_error_protocol'];
			}
			elseif ($imgcheck == $LINK_NO_REMOTE_DOWNLOADS) {
				$errors[$thislink][] = $vbphrase['ll_error_remote'];
			}
			if (!$imgstatuscheck) {
			    $imgstatuscheck = $imgcheck;
			}

            require_once (DIR . '/includes/local_links_images.php');
            if (ldm_can_handle_as_image($linkimg)<=0 and ldm_can_handle_as_mediaimage($linkimg)<=0) {
		    	$errors[$thislink][] = $vbphrase['ll_error_invalidimage'];
            }

		}

		$linkimgthumb = "";
		$linkimgthumbsize = 0;
		if ($imgstatuscheck and $links_defaults['thumbs_dir'] and $links_defaults['create_thumbs_oninsert']) {
			require_once(DIR . '/includes/local_links_images.php');
			$thumb = ldm_make_thumbnail($linkimg, $links_defaults['link_imagesize']);
			if ($thumb) {
				$linkimgthumb = ldm_save_thumbnail($thumb, $links_defaults['thumbs_dir']);
				$linkimgthumbsize = $links_defaults['link_imagesize'];
			}
		}

		if ($linkdate['ampm']==2 and $linkdate['hour']<=12) {
			$linkdate['hour'] +=12;
		}
		if ($linkdate['now']) {
			$linkdate['linkdate'] = TIMENOW;
		}
		else {
			require_once(DIR . '/includes/functions_misc.php');
			$linkdate['linkdate'] = vbmktime($linkdate['hour'], $linkdate['min'], 0, $linkdate['month'], $linkdate['day'], $linkdate['year']);
			if ($linkdate['linkdate']<0 or $linkdate['hour']<0 or $linkdate['hour']>24 or $linkdate['min']<0 or $linkdate['min']>60 or $linkdate['day']>31) {
				$errors[$thislink][] = $vbphrase['ll_error_date'];
			}
		}

		if ($array_linkhide[$thislink] and ($statuscheck==$LINK_OK or $statuscheck==$LINK_UPLOAD)) {
			$statuscheck = $LINK_HIDDEN;
		}

		require_once(DIR . '/includes/functions_newpost.php');
		$linkdesc = convert_url_to_bbcode($linkdesc);

		$array_linkset[$thislink] = 1;
		$array_linkuser[$thislink] = $linkuser;
		$array_linkuserid[$thislink] = $linkuserid;
		$array_linkname[$thislink] = $linkname;
		$array_linkdoi[$thislink] = $linkdoi;
		$array_linkurl[$thislink] = $linkurl;
		$array_linkfile[$thislink] = $linkfile;
		$array_linkimg[$thislink] = $linkimg;
		$array_linkdesc[$thislink] = $linkdesc;
		$array_pforum[$thislink] = $pforum;
		$array_filesize[$thislink] = $filesize;
		$array_statuscheck[$thislink] = $statuscheck;
		$array_imgstatuscheck[$thislink] = $imgstatuscheck;
		$array_linkimgthumb[$thislink] = $linkimgthumb;
		$array_linkimgthumbsize[$thislink] = $linkimgthumbsize;
		$array_linkdups[$thislink] = $linkdups;
		$array_date[$thislink] = $linkdate['linkdate'];

	}

// Any errors?
	if (count($errors)) {
		$error = $vbphrase['ll_error_addmulti']."<br />";
		foreach ($errors as $k=>$v) {
			$error .= $vbphrase['ll_entry']." $k<br />";
			$error .= implode("<br />", $v);
		}
		$error .= $vbphrase['ll_goback'];
		eval(standard_error($error));
		exit;
	}

// No errors, continue with the action

	$array_moderate	= array();
	$array_moderate_email_submit = array();
	for ($thislink=1; $thislink<=$numadd; $thislink++) {
		$moderate = $LINK_ACCEPTED;
		$moderate_email_submit = 0;
		foreach ($pcatid as $thiscat) {
			if (ldm_lookup_permission($thiscat, 'can_moderate_links')) {
				continue;
			}
			if (ldm_lookup_setting($thiscat, 'moderate_links')) {
				$moderate = $LINK_TO_MODERATE;
			}
			if (ldm_lookup_setting($thiscat, 'autocreate_require_moderate') and ldm_lookup_setting($thiscat, 'autocreate_active') and $vbulletin->GPC['linkautocreate'][$thislink]) {
				$moderate = $LINK_TO_MODERATE;
			}
			if (ldm_lookup_setting($thiscat, 'moderate_email_submit')) {
				$moderate_email_submit = 1;
			}
		}
		$array_moderate[$thislink] = $moderate;
		$array_moderate_email_submit[$thislink] = $moderate_email_submit;
	}

	for ($thislink=1; $thislink<=$numadd; $thislink++) {

		if (!$array_linkset[$thislink]) {
			continue;
		}

		($hook = vBulletinHook::fetch_hook('ldm_addmultilink_preinsert')) ? eval($hook) : false;

		require_once(DIR . '/includes/local_links_misc.php');
		$ldm_entry = ldm_entry_template(
			array(
				'linkname' => $array_linkname[$thislink],
				'linkdesc' => $array_linkdesc[$thislink],
				'linkdoi' => $array_linkdoi[$thislink],
				'linkurl' => $array_linkurl[$thislink],
				'linkfile' => $array_linkfile[$thislink],
				'linkimg' => $array_linkimg[$thislink],
				'linkimgthumb' => $array_linkimgthumb[$thislink],
				'linkimgthumbsize' => $array_linkimgthumbsize[$thislink],
				'linkforum' => $array_pforum[$thislink],
				'linksize' => $array_filesize[$thislink],
				'linkstatus' => $array_statuscheck[$thislink],
				'linkimgstatus' => $array_imgstatuscheck[$thislink],
				'linkdate' => $array_date[$thislink],
				'linkusername' => $array_linkuser[$thislink],
				'linkuserid' => $array_linkuserid[$thislink],
				'linkmoderate' => $array_moderate[$thislink],
				'linkreviewfreq' => $array_reviewfreq[$thislink],
				)
			);

		list ($insert_status, $array_linkid[$thislink]) = ldm_create_entry($ldm_entry, $array_linkdups[$thislink]);

		$dorder = array();
		foreach ($pcatid as $k=>$p) {
			$dorder[$k] = $array_change_display_order[$thislink]==2 ? $array_display_order[$thislink] : ($p==$viewcatid ? $array_display_order[$thislink] : 1);
		}
		ldm_insert_entry_in_category($array_linkid[$thislink], $pcatid, $dorder);

		if ($links_permissions['can_add_keyword'] or $links_permissions['can_edit_keyword']) {
			ldm_associate_keywords($array_linkid[$thislink], ldm_lookup_keywords(ldm_explode_keywords($array_newkeywords[$thislink])), 1);
		}

		if ($array_moderate[$thislink] != $LINK_TO_MODERATE) {
			$auto_announced = array();
			$auto_type = strtolower(file_extension($array_linkimg[$thislink]));
			$auto_img = in_array($auto_type, array("jpg", "gif", "png")) ? $array_linkimg[$thislink] : "";

			$auto_create = 	$array_autocreate[$thislink];
			if ($auto_create) {
				foreach ($pcatid as $thiscat) {

					$auto_active = ldm_lookup_setting($thiscat, 'autocreate_active');
					$auto_forum = ldm_lookup_setting($thiscat, 'autocreate_forum');
					$auto_forum = ($auto_forum>0 ? $auto_forum : $pforum);
					if (!$auto_active or $auto_forum<=0 or isset($auto_announced[$auto_forum])) {
						continue;
					}

					require_once(DIR . '/includes/local_links_forumsinterface.php');

                    if (ldm_lookup_setting($thiscat, 'autocreate_allow_userprefix')
                        and ldm_lookup_setting($thiscat, 'autocreate_require_userok')) {
                		$auto_prefix = $vbulletin->GPC['linkautoprefix'][$thislink];
                	}
            	    else {
            		    $auto_prefix = ldm_lookup_setting($thiscat, 'autocreate_prefix');
            	    }

                    if ($auto_prefix) {
                        if (!ldm_validate_threadprefix($auto_prefix, $thiscat, $auto_forum)) {
                            $auto_prefix = "";
                        }
                    }

					$auto_announced[$auto_forum] = 1;
					$auto_userid = ldm_lookup_setting($thiscat, 'autocreate_userid');
					if ($auto_userid) {
						$auto_username = ldm_lookup_setting($thiscat, 'autocreate_username');
					}
					else {
						$auto_username = $vbulletin->userinfo['username'];
						$auto_userid = $vbulletin->userinfo['userid'];
					}
					$auto_bothways = ldm_lookup_setting($thiscat, 'autocreate_both_ways');

					list($error, $message) = ldm_announce_in_forum(
						$auto_forum,
						$auto_bothways,
						$array_linkid[$thislink],
						$thiscat,
						$array_linkname[$thislink],
						$array_linkdesc[$thislink],
						$auto_img,
						$auto_prefix,
						$auto_username,
						$auto_userid
						);
				}
			}
		}

	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	if ($moderate != $LINK_TO_MODERATE) {
		$message = $vbphrase['ll_accepted'];
		$error = 0;

		($hook = vBulletinHook::fetch_hook('ldm_addmultilink_inserted')) ? eval($hook) : false;

		$vbulletin->url = $url;
		if ($error) {
			eval(standard_error($message.'<br /><br /><a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
		eval(print_standard_redirect($message,0));
	}
	else {

		if ($moderate_email_submit) {
			require_once(DIR . '/includes/local_links_misc.php');
			$subject = construct_phrase($vbphrase['ll_admin_newentry_subject'], $vbulletin->options['bbtitle']);
			$modemails = array();
			foreach ($pcatid as $thiscatid) {
				$mod_users = ldm_lookup_userids(explode(';', ldm_lookup_setting($thiscatid, 'moderate_usernames')));
				$mods = ldm_fetch_moderators($thiscatid, $mod_users);
				foreach ($mods AS $moderator) {
					$modemail = $moderator['email'];
					if ($modemail and empty($modemails[$modemail])) {
						$messagelist = array();
						foreach ($array_linkid as $thislink) {
							$messagelist[] = ldm_make_filename($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$thiscatid.'&linkid='.$thislink);
						}
						$message = construct_phrase($vbphrase['ll_admin_newentry_body'],
							$vbulletin->userinfo['username'],
							$vbulletin->userinfo['email'],
							implode(', ', $messagelist)
							);
						$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);
						vbmail($modemail, $subject, $message, true);
						$modemails[$modemail] += 1;
					}
				}
			}
		}
		$message = $vbphrase['ll_submit_moderation'];
		$error = 0;
		($hook = vBulletinHook::fetch_hook('ldm_addmultilink_inserted_tomoderate')) ? eval($hook) : false;
		$vbulletin->url = $url;
		if ($error) {
			eval(standard_error($message.'<br /><br /><a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
		eval(print_standard_redirect($vbphrase['ll_submit_moderation'],0));
	}

	exit;

}

// #################### Do (Edit) Entry

if ($this_action == "doeditlink") {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'change_display_order' => TYPE_INT,
		'confirmdelete' => TYPE_INT,
		'date' => TYPE_ARRAY_STR,
		'delete' => TYPE_INT,
		'display_order' => TYPE_INT,
		'entities' => TYPE_ARRAY_ARRAY,
		'hide' => TYPE_INT,
		'keywords' => TYPE_ARRAY_STR,
		'linkdate' => TYPE_INT,
		'linkdesc' => TYPE_STR,
		'linkdoi' => TYPE_STR,
		'linkdups' => TYPE_INT,
		'linkfile' => TYPE_STR,
		'linkid' => TYPE_INT,
		'linkimg' => TYPE_STR,
		'linkimg_delete' => TYPE_INT,
		'linkimg_replace' => TYPE_STR,
		'linkname' => TYPE_STR,
		'linkreviewfreq' => TYPE_INT,
		'linkuploadfile' => TYPE_STR,
		'linkurl' => TYPE_STR,
		'linkurl_replace' => TYPE_STR,
		'linkuser' => TYPE_STR,
		'message' => TYPE_STR,
		'newkeywords' => TYPE_STR,
		'notify' => TYPE_INT,
		'pcatid' => TYPE_ARRAY_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
		'updatetimestamp' => TYPE_INT,
		'wysiwyg' => TYPE_BOOL,
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'entityfiles' => TYPE_ARRAY_FILE,
	));

	if ($vbulletin->GPC['wysiwyg']) {
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else {
		$message =& $vbulletin->GPC['message'];
	}

	$pcatid 	= $vbulletin->GPC['pcatid'];  // an array ...

	$viewcatid 	= $vbulletin->GPC['catid'];
	$viewlinkid = $vbulletin->GPC['linkid'];
	$pforum 	= $vbulletin->GPC['pforum'];
	$linkname 	= $vbulletin->GPC['linkname'];
	$linkdoi 	= $vbulletin->GPC['linkdoi'];
	$linkurl 	= $vbulletin->GPC['linkurl'];
	$linkuploadfile = $vbulletin->GPC['linkuploadfile'];
	$linkimg 	= $vbulletin->GPC['linkimg'];
	$linkfile 	= $vbulletin->GPC['linkfile'];
	$linkdesc 	= $message;
	$linkuser	= $vbulletin->GPC['linkuser'];

	$linkkeywords = $vbulletin->GPC['keywords'];
	$linknewkeywords = $vbulletin->GPC['newkeywords'];
	$linkentities = $vbulletin->GPC['entities'];
	$linkentityfiles = $vbulletin->GPC['entityfiles'];

	$display_order = $vbulletin->GPC['display_order'];
	$change_display_order = $vbulletin->GPC['change_display_order'];
	$linkreviewfreq = $vbulletin->GPC['linkreviewfreq'];

	if ($viewcatid>=$BASE_CAT) {
		$url = $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$viewcatid;
	}
	else {
		$url = $SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=find&amp;catid='.$viewcatid;
	}
	$urlp = $url.'&page='.$pagenumber;

	if ($viewlinkid == '') {
		$err = construct_phrase($vbphrase['ll_error_linkid'], $linkid).'<br /><br /><a href="'.$url.'">'.$vbphrase['ll_return'].'</a>';
		eval(standard_error($err));
		exit;
	}

	$asb = $vbulletin->db->query_read("
		SELECT * FROM ".THIS_TABLE."linkslink
		WHERE linkid=".$viewlinkid."
		LIMIT 1
		");

	if ($vbulletin->db->num_rows($asb)<=0) {
		$err = construct_phrase($vbphrase['ll_error_linkid'], $viewlinkid).'<br /><br /><a href="'.$url.'">'.$vbphrase['ll_return'].'</a>';
		eval(standard_error($err));
		exit;
	}

	$myrow=$vbulletin->db->fetch_array($asb);
	$oldurl = $myrow['linkurl'];
	$oldstatus = $myrow['linkstatus'];
	$oldimg = $myrow['linkimg'];
	$oldimgstatus = $myrow['linkimgstatus'];
	$oldthumb = $myrow['linkimgthumb'];
	$oldfile = $myrow['linkfile'];
	$olduserid = $myrow['linkuserid'];
	$oldusername = $myrow['linkusername'];

	if ($vbulletin->userinfo['userid']<>$olduserid and (!isset($links_permissions["can_edit_link"]) or !$links_permissions["can_edit_link"])) {
		print_no_permission();
		exit;
	}

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linksltoc
		WHERE linkid='".$viewlinkid."'
		");
	$oldcat = array();
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$oldcat[] = $myrow['catid'];
	}

	if ($vbulletin->GPC_exists['submit']) {
		$submit = "submit";
	}
	elseif ($vbulletin->GPC_exists['delete']) {
		$submit = "delete";
	}
	else {
		$statuscheck = ldm_check_url($oldurl);
		if ($statuscheck) {
			$vbulletin->url = $urlp;
			eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
			exit;
		}
		else {
			$eurl = $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=editlink&linkid='.$viewlinkid.'&catid='.$viewcatid.'&page=$pagenumber';
			$message = $vbphrase['ll_error_linkcheckfailed'].' <a href="'.$linkurl.'" target="_blank">'.$linkurl.'</a><br />'.
			'<a href="'.$urlp.'"><b>'.$vbphrase['ll_accept'].'</b></a>&nbsp;&nbsp;<a href="'.$eurl.'"><b>'.$vbphrase['ll_modify'].'</b></a>'
			;
			eval(standard_error($message));
		}
	}

	if (($submit=="delete" and !$vbulletin->GPC['confirmdelete']) or ($submit!="delete" and $vbulletin->GPC['confirmdelete'])) {
		eval(standard_error($vbphrase['ll_confirm_delete'].$vbphrase['ll_goback']));
		exit;
	}

	$statustime = TIMENOW;

	if ($submit == 'submit') {

		if ($oldusername != $linkuser) {
			if ($vbulletin->userinfo['usergroupid']<=1) {
				if (!is_valid_email($linkuser)) {
					$err = $vbphrase['ll_error_email'].' '.$linkuser.$vbphrase['ll_goback'];
					eval(standard_error($err));
					exit;
				}
				$linkuserid = $vbulletin->userinfo['userid'];
			}
			elseif ($linkuser) {
				$userinfo = ldm_lookup_userids(array($linkuser));
				if ($userinfo[0]) {
					$linkuserid = $userinfo[0];
				}
				elseif (is_valid_email($linkuser)) {
					$linkuserid = 0;
				}
				else {
					$err = construct_phrase($vbphrase['ll_error_username'],$linkuser).$vbphrase['ll_goback'];
					eval(standard_error($err));
					exit;
				}
			}
			else {
				$linkuser = $vbulletin->userinfo['username'];
				$linkuserid = $vbulletin->userinfo['userid'];
			}
		}
		else {
			$linkuser = $oldusername;
			$linkuserid = $olduserid;
		}

		if ($pforum<=0) {
			$pforum = $DEFAULT_FORUMID;
		};

		if (!ldm_forumid_is_valid($pforum)) {
			$err = $vbphrase['ll_error_forum'].' '.$pforum.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		if (!$links_permissions["can_admin_links"]) {
			$newcat = array_diff($pcatid, $oldcat);
			$closed = "";
			foreach ($newcat as $thiscat) {
				if ($linkscat[$thiscat]["catclosed"]) {
					$closed .= $linkscat[$thiscat]["catname_clean"].' ';
				}
			}
			if ($closed) {
				$err = construct_phrase($vbphrase['ll_error_catclosed'],$closed).$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
			foreach ($oldcat as $thiscat) { // fix browser bug with selected/disabled
				if ($linkscat[$thiscat]["catclosed"] and !in_array($thiscat, $pcatid)) $pcatid[] = $thiscat;
			}
		}

		if (!ldm_catid_is_valid($pcatid)) {
			$err = construct_phrase($vbphrase['ll_error_category'], implode(',',$pcatid)).$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		if ($linkname == '') {
			$err = $vbphrase['ll_error_linknull'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		if ($links_permissions['must_add_keyword'] and
			!count($linkkeywords) and !$linknewkeywords) {
			$err = $vbphrase['ll_error_keywords_required'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

		if ($linkdoi) {
			$row = $vbulletin->db->query_first("
				SELECT linkid, linkdoi
				FROM ".THIS_TABLE."linkslink
				WHERE linkdoi LIKE ('".$linkdoi."')
				AND linkid <> ".$viewlinkid."
				LIMIT 1
			");
			if ($row['linkid']) {
				$err = construct_phrase($vbphrase['ll_error_doi_exists'], $linkdoi, $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'linkid='.$row['linkid']).$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
		}

        $vbstrlen = vbstrlen($linkdesc);
	    if ($vbstrlen<$links_defaults['min_textlength'] and $links_defaults['min_textlength'] != 0) {
		    eval(standard_error(fetch_error('tooshort', $vbstrlen, $links_defaults['min_textlength'])));
	    }

    	if ($vbstrlen>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
	    	eval(standard_error(fetch_error('toolong', $vbstrlen, $links_defaults['max_textlength'])));
	    }

		$vbulletin->input->clean_array_gpc('f', array(
			'linkupload' => TYPE_FILE
		));

		if ($linkuploadfile) { // swfuploader
			$linkurl = $linkuploadfile;

			($hook = vBulletinHook::fetch_hook('ldm_upload_completed')) ? eval($hook) : false;

			$statuscheck = $LINK_UPLOAD;
			$filesize = ldm_get_sizeof_url($linkurl);
			if ($oldstatus == $LINK_UPLOAD) {
				ldm_delete_upload($oldurl);
			}
			if ($oldurl == $linkimg) {
				$linkimg = "";
			}

		}
		elseif ($vbulletin->GPC['linkupload']['name']) {

			$linkupload = $vbulletin->GPC['linkupload'];
			if (!ldm_process_upload($linkupload, $linkurl, $links_defaults['upload_filetypes'], $err)) {
				eval(standard_error($err.$vbphrase['ll_goback']));
				exit;
			}

			if ($oldstatus == $LINK_UPLOAD) {
				ldm_delete_upload($oldurl);
			}

			if ($oldurl == $linkimg) {
				$linkimg = "";
			}

			if (!$linkfile) {
				$linkfile = $linkupload['name'];
			}

			($hook = vBulletinHook::fetch_hook('ldm_upload_completed')) ? eval($hook) : false;

			$statuscheck = $LINK_UPLOAD;
			$filesize = ldm_get_sizeof_url($linkurl);

		}
		elseif ($vbulletin->GPC['linkurl_replace']) {
			if ($oldstatus == $LINK_UPLOAD) {
				ldm_delete_upload($oldurl);
			}
			$linkurl = $vbulletin->GPC['linkurl_replace'];
			$statuscheck = ldm_check_url($linkurl);
			$filesize = ldm_get_sizeof_url($linkurl);
		}
		elseif (!$linkurl) {
			if ($links_defaults["allow_null_links"]) {
				$statuscheck = $LINK_OK;
				$filesize = 0;
				$linkfile	= '';
			}
			else {
				$err = $vbphrase['ll_error_urlnull'].$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
		}
		else {
			$statuscheck = ($oldstatus==$LINK_UPLOAD ? $LINK_UPLOAD : ldm_check_url($linkurl));
			$filesize = ldm_get_sizeof_url($linkurl);
			$linkfile = ($linkfile!=$oldfile ? $linkfile : ($oldurl==$linkurl ? $oldfile : ""));
		}

		if ($statuscheck==$LINK_UPLOAD and !$linkfile) {
			$linkfile = basename($linkurl);
            $linkfile = 'download' . '.' . file_extension($linkfile);
		}

		if ($linkfile) {
			ldm_fix_filename($linkfile, 1);
		}

		if ($vbulletin->GPC['hide'] and ($statuscheck==$LINK_UPLOAD or $statuscheck==$LINK_OK)) {
			$statuscheck = $LINK_HIDDEN;
		}

		if ($statuscheck == $LINK_NO_ACCESS) {
			$err = $vbphrase['ll_error_protocol'].' '.$linkurl.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
		elseif ($statuscheck == $LINK_NO_REMOTE_DOWNLOADS) {
			$err = $vbphrase['ll_error_remote'].' '.$linkurl.$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}

    	if ($linkfile and $linkurl) {
	        $linktype = file_extension($linkurl);
    	    if (!ldm_known_filetype($linktype)) {
    	        $linkfile = ""; // filename is irrelevant for links
    	    }
        }

		if ($linkfile and $linkurl) {
			if (ldm_fix_filename($linkfile)) {
				$err = construct_phrase($vbphrase['ll_error_rename_name'], $linkfile).$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
			$lft_url = strtolower(file_extension($linkurl));
			$lft_fil = strtolower(file_extension($linkfile));
			if ($lft_fil != $lft_url) {
				$err = $vbphrase['ll_error_rename_type'].$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
		}

		$vbulletin->input->clean_array_gpc('f', array(
			'imgupload' => TYPE_FILE
		));

		$imgstatuscheck = 0;
		if ($vbulletin->GPC['imgupload']['name']) {
			if (!ldm_process_upload($vbulletin->GPC['imgupload'], $linkimg, $links_defaults['image_filetypes'], $err, "imageuploads")) {
				eval(standard_error($err.$vbphrase['ll_goback']));
				exit;
			}
			if ($oldimgstatus == $LINK_UPLOAD and $oldimg!=$linkurl) {
				ldm_delete_upload($oldimg);
			}
			$imgstatuscheck = $LINK_UPLOAD;
		}
		elseif ($vbulletin->GPC['linkimg_delete'] and !$vbulletin->GPC['linkimg_replace']) {
			if ($oldimgstatus == $LINK_UPLOAD and $oldimg!=$linkurl) {
				ldm_delete_upload($oldimg);
			}
			$linkimg = "";
		}
		elseif ($vbulletin->GPC['linkimg_replace']) {
			if ($oldimgstatus == $LINK_UPLOAD and $oldimg!=$linkurl) {
				ldm_delete_upload($oldimg);
			}
			$linkimg = $vbulletin->GPC['linkimg_replace'];
		}

		if (!$linkimg) {
			ldm_set_autoimage($linkurl, $linkimg);
			$imgstatuscheck = $statuscheck;
		}
		else {
			$imgcheck = ldm_check_url($linkimg);
			if ($imgcheck == $LINK_NO_ACCESS) {
				$err = $vbphrase['ll_error_protocol'].' ['.$linkimg.']'.$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
			elseif ($imgcheck == $LINK_NO_REMOTE_DOWNLOADS) {
				$err = $vbphrase['ll_error_remote'].' ['.$linkimg.']'.$vbphrase['ll_goback'];
				eval(standard_error($err));
				exit;
			}
			if (!$imgstatuscheck) {
			    $imgstatuscheck = $imgcheck;
			}

            require_once (DIR . '/includes/local_links_images.php');
            if (ldm_can_handle_as_image($linkimg)<=0 and ldm_can_handle_as_mediaimage($linkimg)<=0) {
		    	$err = $vbphrase['ll_error_invalidimage'].$vbphrase['ll_goback'];
			    eval(standard_error($err));
			    exit;
            }
		}

    	$linkimgthumb = "";
	    $linkimgthumbsize = 0;
    	if ($imgstatuscheck and $links_defaults['thumbs_dir'] and $links_defaults['create_thumbs_oninsert']) {
	    	require_once(DIR . '/includes/local_links_images.php');
		    $thumb = ldm_make_thumbnail($linkimg, $links_defaults['link_imagesize']);
    		if ($thumb) {
	    		$linkimgthumb = ldm_save_thumbnail($thumb, $links_defaults['thumbs_dir']);
		    	$linkimgthumbsize = $links_defaults['link_imagesize'];
    		}
	    }

		if ($oldthumb and $linkimgthumb!=$oldthumb) {
			ldm_delete_thumb($oldthumb);
		}

		$date = $vbulletin->GPC['date'];
		if ($date['ampm']==2 and $date['hour']<=12) $date['hour'] +=12;
		if ($date['now']) {
			$linkdate = TIMENOW;
		}
		else {
			require_once(DIR . '/includes/functions_misc.php');
			$linkdate = vbmktime($date['hour'], $date['min'], 0, $date['month'], $date['day'], $date['year']);
			if ($linkdate<0 or $date['hour']<0 or $date['hour']>24 or $date['min']<0 or $date['min']>60 or $date['day']>31) {
				eval(standard_error($vbphrase['ll_error_date'].$vbphrase['ll_goback']));
				exit;
			}
		}

		require_once(DIR . '/includes/functions_newpost.php');
		$linkdesc = convert_url_to_bbcode($linkdesc);

		($hook = vBulletinHook::fetch_hook('ldm_editlink_preupdate')) ? eval($hook) : false;

		$query = "
			UPDATE ".THIS_TABLE."linkslink
			SET
			linkname='".$vbulletin->db->escape_string($linkname)."',
			linkdoi='".$vbulletin->db->escape_string($linkdoi)."',
			linkurl='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $linkurl))."',
			linkfile='".$vbulletin->db->escape_string($linkfile)."',
			linkimg='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $linkimg))."',
			linkimgthumb='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $linkimgthumb))."',
			linkimgthumbsize='".$linkimgthumbsize."',
			linkdesc='".$vbulletin->db->escape_string($linkdesc)."',
			linkusername='".$vbulletin->db->escape_string($linkuser)."',
			linkuserid='".$linkuserid."',
			linkforum='".$pforum."',
			linkcheck='".$statustime."',
			linkstatus='".$statuscheck."',
			linksize='".$filesize."',
			linkimgstatus='".$imgstatuscheck."',
			linkdate='".$linkdate."',
			linkreviewfreq='".$linkreviewfreq."'
			WHERE linkid=".$viewlinkid."
			";
		$vbulletin->db->query_write($query);

		$np = 0;
		foreach ($pcatid as $p) { $np++; }
		if ($np==1) { // Assume that user wishes to keep the chosen display order
			$change_display_order = 2;
		}

		if ($change_display_order==2) {

			$vbulletin->db->query_write("
				DELETE FROM ".THIS_TABLE."linksltoc
				WHERE linkid='".$viewlinkid."'
				");
			foreach ($pcatid as $p) {
				$vbulletin->db->query_write("
				INSERT INTO ".THIS_TABLE."linksltoc
				SET
					linkid='".$viewlinkid."',
					catid='".$p."',
					displayorder='".$display_order."'
				");
			}

		}
		else {

			$dn = array();
			foreach ($pcatid as $p) {  // Default is to put everything in group 1
				$dn[$p] = 1;
			}
			$asb = $vbulletin->db->query_read("
				SELECT catid, displayorder
				FROM ".THIS_TABLE."linksltoc
				WHERE linkid='".$viewlinkid."'
				");
			while ($myrow=$vbulletin->db->fetch_array($asb)) { // Update according to existing display orders
				$dn[$myrow['catid']] = $myrow['displayorder'];
			}
			$dn[$viewcatid] = $display_order;  // Force this category to new display order

			$vbulletin->db->query_write("
				DELETE FROM ".THIS_TABLE."linksltoc
				WHERE linkid='".$viewlinkid."'
				");

			foreach ($pcatid as $p) {
				$vbulletin->db->query_write("
				INSERT INTO ".THIS_TABLE."linksltoc
				SET
					linkid='".$viewlinkid."',
					catid='".$p."',
					displayorder='".$dn[$p]."'
				");
			}
		}

		if ($date['expirenow']) {
			$expiredids = array();
			foreach ($pcatid as $p) {
				$expiredids[] = array("linkid"=>$viewlinkid, "catid"=>$p);
			}
			ldm_process_expired($expiredids);
		}

		ldm_fix_cat_count();

		if ($links_permissions['can_add_keyword'] or $links_permissions['can_edit_keyword']) {
			ldm_associate_keywords($viewlinkid, $linkkeywords, 0);
			ldm_associate_keywords($viewlinkid, ldm_lookup_keywords(ldm_explode_keywords($linknewkeywords)), 1);
		}

		if ($links_permissions['can_edit_entities'] and count($linkentities)) {
			require_once(DIR . '/includes/local_links_entities.php');
			if (!ldm_associate_entities($viewlinkid, $linkentities, $linkentityfiles, $message)) {
				eval(standard_error($message));
				exit;
			}
		}

		if ($links_defaults['validate_on_entry'] and !$statuscheck) {
			$eurl = $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=editlink&amp;linkid='.$viewlinkid.'&amp;catid='.$viewcatid.'&amp;page='.$pagenumber;
			$message = $vbphrase['ll_error_linkcheckfailed'].' <a href="'.$linkurl.'" target="_blank">'.$linkurl.
			'</a><br /><a href="'.$urlp.'"><b>'.$vbphrase['ll_accept'].'</b></a>&nbsp;&nbsp;<a href="'.$eurl.
			'"><b>'.$vbphrase['ll_modify'].'</b></a>'
			;
			eval(standard_error($message));
			exit;
		}
		else {

			if ($vbulletin->GPC['notify']) {
				ldm_notify_updated($viewlinkid, $viewcatid);
			}

			($hook = vBulletinHook::fetch_hook('ldm_editlink_submit_complete')) ? eval($hook) : false;

			$message = $vbphrase['ll_edited'];
			$vbulletin->url = $urlp."#linkid".$viewlinkid;
			eval(print_standard_redirect($message,0));
		}

	}

	if ($submit == 'delete') {
        require_once(DIR . '/includes/local_links_misc.php');
		ldm_delete_entry($viewlinkid);
		ldm_fix_cat_count();

		($hook = vBulletinHook::fetch_hook('ldm_editlink_delete_complete')) ? eval($hook) : false;

		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_deleted'],0));
	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	exit;
}

// #################### Do (Edit) Keywords

if ($this_action == "doeditkeys") {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'keywords' => TYPE_STR,
		'linkid' => TYPE_INT,
		'submit' => TYPE_INT,
		'viewlinkid' => TYPE_INT,
	));

	if (!$links_permissions["can_add_keyword"] and !$links_permissions["can_edit_keyword"]) {
		print_no_permission();
		exit;
	}

	$viewcatid 	= $vbulletin->GPC['catid'];
	$viewlinkid = $vbulletin->GPC['viewlinkid'];
	$linkid = $vbulletin->GPC['linkid'];

	if ($viewcatid>=$BASE_CAT) {
		$url = $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$viewcatid.($viewlinkid ? '&linkid='.$viewlinkid : '').'&page='.$pagenumber."#linkid".$linkid;
	}
	else {
		$url = $SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=find&amp;catid='.$viewcatid.'&page='.$pagenumber."#linkid".$linkid;
	}

	if (!$linkid) {
		$err = construct_phrase($vbphrase['ll_error_linkid'], $linkid).'<br /><br /><a href="'.$url.'">'.$vbphrase['ll_return'].'</a>';
		eval(standard_error($err));
		exit;
	}

	$asb = $vbulletin->db->query_read("
		SELECT * FROM ".THIS_TABLE."linkslink
		WHERE linkid=".$linkid." LIMIT 1
		");

	if ($vbulletin->db->num_rows($asb)<=0) {
		$err = construct_phrase($vbphrase['ll_error_linkid'], $viewlinkid).'<br /><br /><a href="'.$url.'">'.$vbphrase['ll_return'].'</a>';
		eval(standard_error($err));
		exit;
	}

	ldm_associate_keywords($linkid, ldm_lookup_keywords(ldm_explode_keywords($vbulletin->GPC['keywords'])), 0);

	$message = $vbphrase['ll_edited'];
	$vbulletin->url = $url;
	eval(print_standard_redirect($message,0));

}

// #################### Do (Rate) Entry

if ($this_action == "doratelink") {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'vote' => TYPE_INT,
		'message' => TYPE_STR,
		'messageusername' => TYPE_STR,
		'messageuserid' => TYPE_INT,
		'newusername' => TYPE_STR,
		'rateid' => TYPE_INT,
		'ratesort' => TYPE_STR,
		'lpage' => TYPE_INT,
		'wysiwyg' => TYPE_BOOL,
	));

	if ($vbulletin->GPC['wysiwyg']) {
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else {
		$message =& $vbulletin->GPC['message'];
	}

	$viewcatid = $vbulletin->GPC['catid'];
	$linkid	   = $vbulletin->GPC['linkid'];
	$linkvote  = $vbulletin->GPC['vote'];
	$lpage     = $vbulletin->GPC['lpage'];
	$rateid    = $vbulletin->GPC['rateid'];
	$ratesort  = $vbulletin->GPC['ratesort'];
	$lcomment  = ($message ? $vbulletin->db->escape_string($message) : '');

	$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=ratelink&amp;linkid=$linkid&amp;catid=$viewcatid&amp;lpage=$lpage&amp;ratesort=$ratesort&amp;page=$pagenumber";

	if ($rateid>0 and $linkvote==-1) {
		$rec = $vbulletin->db->query_first("
			SELECT linkuserid
			FROM ".THIS_TABLE."linksrate
			WHERE lrate='".$rateid."'
			");
		if ($rec['linkuserid']==$vbulletin->userinfo['userid'] or isset($links_permissions["can_admin_links"])) {
			$vbulletin->db->query_write("
				DELETE FROM ".THIS_TABLE."linksrate
				WHERE lrate='".$rateid."'
			");
			ldm_fix_rating_counts($linkid);
			$vbulletin->url = $url;
			eval(print_standard_redirect($vbphrase['ll_deleted'],0));
		}
		else {
			print_no_permission();
		}
		exit;
	}

	if (!isset($links_permissions["can_rate_link"]) or !$links_permissions["can_rate_link"]) {
		print_no_permission();
		exit;
	}

	if (!$links_defaults['hide_rate'] and ($linkvote<$MIN_VOTE or $linkvote>$MAX_VOTE or (!$linkvote and $links_defaults['must_comment_and_rate']))) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_error_rating'],0));
		exit;
	}

    $vbstrlen = vbstrlen($message);
	if ($vbstrlen>0 and $vbstrlen<$links_defaults['min_commentlength'] and $links_defaults['min_commentlength'] != 0) {
		eval(standard_error(fetch_error('tooshort', $vbstrlen, $links_defaults['min_commentlength'])));
	}

	if ($vbstrlen>$links_defaults['max_commentlength'] and $links_defaults['max_commentlength'] != 0) {
		eval(standard_error(fetch_error('toolong', $vbstrlen, $links_defaults['max_commentlength'])));
	}

	if (!$linkvote and !$lcomment) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_accepted'],0));
	}

	$messageusername = $vbulletin->GPC['messageusername'] ? $vbulletin->GPC['messageusername'] : $vbulletin->userinfo['username'];
	$messageuserid = $vbulletin->GPC['messageuserid'] ? $vbulletin->GPC['messageuserid'] : $vbulletin->userinfo['userid'];

	if ($vbulletin->GPC['newusername'] and $links_permissions['can_moderate_links']) {
		$userinfo = ldm_lookup_userids(array($vbulletin->GPC['newusername']));
		if ($userinfo[0]) {
			$messageuserid = $userinfo[0];
			$messageusername = $vbulletin->GPC['newusername'];
		}
	}

	$rec = $vbulletin->db->query_first("
		SELECT COUNT(linkid) AS linkcount
		FROM ".THIS_TABLE."linkslink
		WHERE linkid='".$linkid."'
		");

	if (!$rec['linkcount']) {
		$vbulletin->url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid";
		eval(print_standard_redirect(construct_phrase($vbphrase['ll_error_linkid'], $linkid),0));
		exit;
	}

	ldm_insert_rate($linkid, $rateid, max(0,$linkvote), $message, $messageusername, $messageuserid);

	($hook = vBulletinHook::fetch_hook('ldm_ratelink_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($vbphrase['ll_accepted'],0));

	exit;
}

// #################### Do Add/Remove Favourite

if ($this_action == "dofavlink") {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'id' => TYPE_INT,
		'set' => TYPE_INT
		));

	$viewcatid = $vbulletin->GPC['catid'];
	$linkid	   = $vbulletin->GPC['id'];
	$linkset   = $vbulletin->GPC['set'];

	if ($viewcatid>=$BASE_CAT) {
		$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid&page=$pagenumber#linkid$linkid";
	}
	else {
		$url = $SEARCH_SCRIPT.".php?'.$vbulletin->session->vars['sessionurl'].'action=find&amp;catid=$viewcatid&page=$pagenumber#linkid$linkid";
	}

	if ($linkset < 0) {
		$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linksfavs
			WHERE linkid='".$linkid."'
			AND   userid='".$vbulletin->userinfo['userid']."'
			");
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_myfav_deleted'],0));
		exit;
	}

	if (!isset($links_permissions["can_mark_link"]) or !$links_permissions["can_mark_link"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksfavs
		WHERE linkid='".$linkid."'
		AND   userid='".$vbulletin->userinfo[userid]."'
		");

	$vbulletin->db->query_write("
		INSERT INTO ".THIS_TABLE."linksfavs (linkid, userid)
		VALUES (
		'".$linkid."',
		'".$vbulletin->userinfo[userid]."'
		)
	");

	($hook = vBulletinHook::fetch_hook('ldm_favourite_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($vbphrase['ll_myfav_added'],0));

	exit;
}

// #################### Do Nominate Star Entry

if ($this_action == "donominatelink") {

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'id' => TYPE_INT,
		'remove' => TYPE_INT,
		));

	$viewcatid = $vbulletin->GPC['catid'];
	$linkid	   = $vbulletin->GPC['id'];

	if ($viewcatid>$BASE_CAT) {
		$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid&page=$pagenumber#linkid$linkid";
	}
	else {
		$url = $SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=find&amp;catid=$viewcatid&page=$pagenumber#linkid$linkid";
	}

	if (!isset($links_permissions["can_nominate_link"]) or !$links_permissions["can_nominate_link"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linkstarred
		WHERE userid='".$vbulletin->userinfo[userid]."'
		AND   usertime>".$links_defaults["starred_entries_periodstart"]."
		");

	if (!$vbulletin->GPC_exists['remove']) {
		$vbulletin->db->query_write("
			INSERT INTO ".THIS_TABLE."linkstarred (linkid, userid, usertime)
			VALUES (
			'".$linkid."',
			'".$vbulletin->userinfo[userid]."',
			'".TIMENOW."'
			)
		");
	}

	($hook = vBulletinHook::fetch_hook('ldm_nominate_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;

	if ($vbulletin->GPC_exists['remove']) {
		eval(print_standard_redirect($vbphrase['ll_unnominated'],0));
	}
	else {
		eval(print_standard_redirect($vbphrase['ll_nominated'],0));
	}

	exit;
}

// #################### Do (Add) Category

if ($this_action == "doaddcat") {

	require_once(DIR . '/includes/local_links_misc.php');

	if (!isset($links_permissions["can_add_category"]) or !$links_permissions["can_add_category"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'auto_forumlink' => TYPE_INT,
		'catadminscan' => TYPE_INT,
		'catclosed' => TYPE_INT,
		'catdesc' => TYPE_STR,
		'catname' => TYPE_STR,
		'catsyncdir' => TYPE_STR,
		'cattext' => TYPE_STR,
		'catuser' => TYPE_STR,
		'display_order' => TYPE_INT,
		'entitygroupcollapse' => TYPE_ARRAY_INT,
		'entitygrouphidden' => TYPE_ARRAY_INT,
		'entitygrouporder' => TYPE_ARRAY_INT,
		'entityorder' => TYPE_ARRAY_INT,
		'entityrequired' => TYPE_ARRAY_INT,
		'entityrevert' => TYPE_INT,
		'forumname' => TYPE_STR,
		'pcatid' => TYPE_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
	));

	$pcatid		= $vbulletin->GPC['pcatid']; // NB - single value
	$catname	= $vbulletin->GPC['catname'];
	$catdesc	= $vbulletin->GPC['catdesc'];
	$cattext	= $vbulletin->GPC['cattext'];
	$catsyncdir	= $vbulletin->GPC['catsyncdir'];
	$catuser	= $vbulletin->GPC['catuser'];
	$pforum		= $vbulletin->GPC['pforum'];
	$display_order = $vbulletin->GPC['display_order'];
	$auto_forumlink = ($vbulletin->GPC_exists['auto_forumlink'] ? $vbulletin->GPC['auto_forumlink'] : 0);
	$forumname = ($vbulletin->GPC_exists['forumname'] ? $vbulletin->GPC['forumname'] : $catname);
	$catclosed = ($vbulletin->GPC['catclosed'] ? 1 : 0);

	$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pcatid";

	$catusergroupid = $vbulletin->userinfo['usergroupid'];
	if ($catusergroupid<=1) {
		if (!is_valid_email($catuser)) {
			$err = $vbphrase['ll_error_email'].' '.$catuser.'. <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
		$catuserid = $vbulletin->userinfo['userid'];
	}
	else {
		if ($catuser) {
			$userinfo = ldm_lookup_userids(array($catuser));
			$catuserid = $userinfo[0];
			if (!$catuserid) {
				$err = construct_phrase($vbphrase['ll_error_username'],$catuser).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
				eval(standard_error($err));
				exit;
			}
		}
		else {
			$catuser = $vbulletin->userinfo['username'];
			$catuserid = $vbulletin->userinfo['userid'];
		}
	}

	if (!$vbulletin->GPC_exists['submit']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
		exit;
	}

	if ($pcatid > 0) {
		if (ldm_catid_is_valid($pcatid)) {
			$pcatlist = "$pcatid,".$linkscat[$pcatid]["parentlist"];
		}
		else {
			$url = $LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'];
			eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $pcatid).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
	}
	elseif ($pcatid == $BASE_CAT) {
		$pcatlist = $pcatid;
	}
	else {
		$url = $LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'];
		eval(standard_error($vbphrase['ll_error_pcatnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
	}

	if ($catname == ''){
		eval(standard_error($vbphrase['ll_error_catnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	if ($pforum<=0) { $pforum = $DEFAULT_FORUMID; };

	if (!ldm_forumid_is_valid($pforum)) {
		eval(standard_error($vbphrase['ll_error_forum'].' '.$pforum.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	if ($pforum<=0 and $auto_forumlink==1) {
		eval(standard_error($vbphrase['ll_error_forumlink'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

    $vbstrlen = vbstrlen($catdesc);
	if ($vbstrlen<$links_defaults['min_textlength'] and $links_defaults['min_textlength'] != 0) {
		eval(standard_error(fetch_error('tooshort', $vbstrlen, $links_defaults['min_textlength'])));
	}

	if ($vbstrlen>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
		eval(standard_error(fetch_error('toolong', $vbstrlen, $links_defaults['max_textlength'])));
	}

	if ($cattext == '') {
		$cattext = $catdesc;
	}

	if ($catsyncdir) {
		$fulldir = ldm_cleanto_fopen($catsyncdir);
		if ($dir_handle = @opendir($fulldir)) {
			closedir($dir_handle);
		}
		else {
			eval(standard_error(construct_phrase($vbphrase['ll_error_catsyncdir'], $catsyncdir).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}
	}

	if ($links_permissions["can_moderate_links"]) {
		$moderate = $LINK_ACCEPTED;
	}
	else {
		$moderate = ($links_defaults["moderate_links"]!='0' ? $LINK_TO_MODERATE : $LINK_ACCEPTED);
	}

	require_once(DIR . '/includes/functions_newpost.php');
	$catdesc = convert_url_to_bbcode($catdesc);
	$cattext = convert_url_to_bbcode($cattext);

	$category = ldm_category_template(array(
		'catusername' => $catuser,
		'catuserid' => $catuserid,
		'catname' => $catname,
		'catdesc' => $catdesc,
		'cattext' => $cattext,
		'parentid' => $pcatid,
		'parentlist' => $pcatlist,
		'catforum' => $pforum,
		'catmoderate' => $moderate,
		'catsyncdir' => $catsyncdir,
		'displayorder' => $display_order,
		'catclosed' => $catclosed,
					));

	$catid = ldm_create_category($category);
	ldm_fix_cat_count();

	if (!ldm_update_settings($catid, $_REQUEST, $errors)) {
		$message = $vbphrase['ll_error_settings'].'<br />';
		foreach ($errors as $name=>$t) {
			$message .= $name.' ('.$t['value'].') '.$t['message'].'<br />';
		}
		eval(standard_error($message.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	ldm_update_permissions($catid, $_REQUEST);

	if ($vbulletin->GPC['entityrevert']==1) {
		require_once(DIR . '/includes/local_links_entities.php');
		ldm_clear_entity_displayorder($catid);
	}
	elseif ($vbulletin->GPC_exists['entitygroupcollapse'] or $vbulletin->GPC_exists['entitygrouphidden'] or $vbulletin->GPC_exists['entitygrouporder'] or $vbulletin->GPC_exists['entityorder'] or $vbulletin->GPC_exists['entityrequired']) {
		require_once(DIR . '/includes/local_links_entities.php');
		ldm_set_entity_displayorder($catid, $vbulletin->GPC['entitygroupcollapse'], $vbulletin->GPC['entitygrouphidden'], $vbulletin->GPC['entitygrouporder'], $vbulletin->GPC['entityorder'], $vbulletin->GPC['entityrequired']);
	}

	require_once(DIR . '/includes/local_links_forumsinterface.php');
	ldm_insert_cat_in_forum($auto_forumlink, $catid, $pforum, $forumname);

	($hook = vBulletinHook::fetch_hook('ldm_addcat_inserted')) ? eval($hook) : false;

	if ($vbulletin->GPC['catadminscan']) {
		$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=admin&amp;set=scan&amp;catid=$catid".($catsyncdir ? "&amp;dir=$catsyncdir" : "");
		eval(print_standard_redirect($vbphrase['ll_accepted'],0));
	}
	else {
		$vbulletin->url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$catid";
		eval(print_standard_redirect($vbphrase['ll_accepted'],0));
	}
	exit;

}

// #################### Do (Edit) Category

if ($this_action == "doeditcat") {

	require_once(DIR . '/includes/local_links_misc.php');

	$vbulletin->input->clean_array_gpc('r', array(
		'auto_forumlink' => TYPE_INT,
		'catadminscan' => TYPE_INT,
		'catname' => TYPE_STR,
		'catclosed' => TYPE_INT,
		'catdesc' => TYPE_STR,
		'catid' => TYPE_INT,
		'catsyncdir' => TYPE_STR,
		'cattext' => TYPE_STR,
		'catuser' => TYPE_STR,
		'confirmdelete' => TYPE_INT,
		'delete' => TYPE_INT,
		'display_order' => TYPE_INT,
		'entitygroupcollapse' => TYPE_ARRAY_INT,
		'entitygrouphidden' => TYPE_ARRAY_INT,
		'entitygrouporder' => TYPE_ARRAY_INT,
		'entityorder' => TYPE_ARRAY_INT,
		'entityrequired' => TYPE_ARRAY_INT,
		'entityrevert' => TYPE_INT,
		'force_permissions' => TYPE_INT,
		'forumname' => TYPE_STR,
		'mod' => TYPE_INT,
		'pcatid' => TYPE_INT,
		'pforum' => TYPE_INT,
		'submit' => TYPE_INT,
	));

	$catclosed = ($vbulletin->GPC['catclosed'] ? 1 : 0);
	$catdesc = $vbulletin->GPC['catdesc'];
	$catid	 = $vbulletin->GPC['catid'];
	$catmod	 = $vbulletin->GPC['mod'];
	$catname = $vbulletin->GPC['catname'];
	$catsyncdir	= $vbulletin->GPC['catsyncdir'];
	$cattext = $vbulletin->GPC['cattext'];
	$catuser = $vbulletin->GPC['catuser'];
	$display_order = $vbulletin->GPC['display_order'];
	$pcatid	 = $vbulletin->GPC['pcatid'];
	$pforum	 = $vbulletin->GPC['pforum'];
	$auto_forumlink = ($vbulletin->GPC_exists['auto_forumlink'] ? $vbulletin->GPC['auto_forumlink'] : 0);
	$forumname = ($vbulletin->GPC_exists['forumname'] ? $vbulletin->GPC['forumname'] : $catname);
	$force_permissions = (($links_permissions[can_set_permissions] and $vbulletin->GPC_exists['force_permissions']) ?
		$vbulletin->GPC['force_permissions'] : 0);

	$url = ($catmod==1 ? $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=mod" : $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pcatid");

	if ($vbulletin->GPC_exists['submit']) {
		$submit = "submit";
	}
	elseif ($vbulletin->GPC_exists['delete']) {
		$submit = "delete";
	}
	else {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
		exit;
	}

	if (($submit=="delete" and !$vbulletin->GPC['confirmdelete']) or ($submit!="delete" and $vbulletin->GPC['confirmdelete'])) {
		eval(standard_error($vbphrase['ll_confirm_delete'].$vbphrase['ll_goback']));
		exit;
	}

	if (!ldm_catid_is_valid($catid)) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $catid).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$catuserid = -1;
	$asb = $vbulletin->db->query_read("
		SELECT catuserid, catusername
		FROM ".THIS_TABLE."linkscat
		WHERE catid=".$catid."
		LIMIT 1
	");
	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		$olduserid = $myrow["catuserid"];
		$oldusername = $myrow["catusername"];
	}

	if ($vbulletin->userinfo['userid']<>$olduserid and (!isset($links_permissions["can_edit_category"]) or !$links_permissions["can_edit_category"])) {
		print_no_permission();
		exit;
	}

	if ($submit == 'submit') {

		if ($oldusername != $catuser) {
			if ($vbulletin->userinfo['usergroupid']<=1) {
				if (!is_valid_email($catuser)) {
					$err = $vbphrase['ll_error_email'].' '.$catuser.$vbphrase['ll_goback'];
					eval(standard_error($err));
					exit;
				}
				$catuserid = $vbulletin->userinfo['userid'];
			}
			elseif ($catuser != "") {
				$userinfo = ldm_lookup_userids(array($catuser));
				if ($userinfo[0]) {
					$catuserid = $userinfo[0];
				}
				elseif (is_valid_email($catuser)) {
					$catuserid = 0;
				}
				else {
					$err = construct_phrase($vbphrase['ll_error_username'],$catuser).$vbphrase['ll_goback'];
					eval(standard_error($err));
					exit;
				}
			}
			else {
				$catuser = $vbulletin->userinfo['username'];
				$catuserid = $vbulletin->userinfo['userid'];
			}
		}
		else {
			$catuser = $oldusername;
			$catuserid = $olduserid;
		}

		if ($pforum<=0) {
			$pforum = $DEFAULT_FORUMID;
		};

		if (!ldm_forumid_is_valid($pforum)) {
			$err = $vbphrase['ll_error_forum'].' '.$pforum.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}

		if ($catname == ''){
			eval(standard_error($vbphrase['ll_error_catnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			exit;
		}

        $vbstrlen = vbstrlen($catdesc);
    	if ($vbstrlen<$links_defaults['min_textlength'] and $links_defaults['min_textlength'] != 0) {
	    	eval(standard_error(fetch_error('tooshort', $vbstrlen, $links_defaults['min_textlength'])));
	    }

    	if ($vbstrlen>$links_defaults['max_textlength'] and $links_defaults['max_textlength'] != 0) {
	    	eval(standard_error(fetch_error('toolong', $vbstrlen, $links_defaults['max_textlength'])));
	    }

		if ($cattext == '') {
			$cattext = $catdesc;
		}

		if ($catsyncdir) {
			$fulldir = ldm_cleanto_fopen($catsyncdir);
			if ($dir_handle = @opendir($fulldir)) {
				closedir($dir_handle);
			}
			else {
				eval(standard_error(construct_phrase($vbphrase['ll_error_catsyncdir'], $catsyncdir).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			}
		}

		if ($pcatid > 0) {
			if (ldm_catid_is_valid($pcatid)) {
				if ($catid == $pcatid or in_array($catid, explode(",", $linkscat[$pcatid]["parentlist"]))) {
					eval(standard_error($vbphrase['ll_error_catrecurse'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
					exit;
				}
				$pcatlist = "$pcatid,".$linkscat[$pcatid]["parentlist"];
			}
			else {
				$url = $LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'];
				eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $pcatid).' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			}
		}
		elseif ($pcatid == $BASE_CAT) {
			$pcatlist = $pcatid;
		}
		else {
			$url = $LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'];
			eval(standard_error($vbphrase['ll_error_pcatnull'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		}

		if ($pforum<=0 and $auto_forumlink==1) {
			eval(standard_error($vbphrase['ll_error_forumlink'].' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			exit;
		}

		if ($pforum<=0) {
			$pforum = $DEFAULT_FORUMID;
		};


		if (!ldm_update_settings($catid, $_REQUEST, $errors)) {
			$message = $vbphrase['ll_error_settings'].'<br />';
			foreach ($errors as $name=>$t) {
				$message .= $name.' ('.$t['value'].') '.$t['message'].'<br />';
			}
			eval(standard_error($message.' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			exit;
		}

		ldm_update_permissions($catid, $_REQUEST);

		if ($vbulletin->GPC['entityrevert']==1) {
			require_once(DIR . '/includes/local_links_entities.php');
			ldm_clear_entity_displayorder($catid);
		}
		elseif ($vbulletin->GPC_exists['entitygroupcollapse'] or $vbulletin->GPC_exists['entitygrouphidden'] or $vbulletin->GPC_exists['entitygrouporder'] or $vbulletin->GPC_exists['entityorder'] or $vbulletin->GPC_exists['entityrequired']) {
			require_once(DIR . '/includes/local_links_entities.php');
			ldm_set_entity_displayorder($catid, $vbulletin->GPC['entitygroupcollapse'], $vbulletin->GPC['entitygrouphidden'], $vbulletin->GPC['entitygrouporder'], $vbulletin->GPC['entityorder'], $vbulletin->GPC['entityrequired']);
		}

		require_once(DIR . '/includes/functions_newpost.php');
		$catdesc = convert_url_to_bbcode($catdesc);
		$cattext = convert_url_to_bbcode($cattext);

		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkscat
			SET
				catid='".$catid."',
				catname='".$vbulletin->db->escape_string($catname)."',
				catdesc='".$vbulletin->db->escape_string($catdesc)."',
				cattext='".$vbulletin->db->escape_string($cattext)."',
				catusername='".$vbulletin->db->escape_string($catuser)."',
				catuserid='".$catuserid."',
				parentid='".$pcatid."',
				parentlist='".$pcatlist."',
				catforum='".$pforum."',
				catclosed='".$catclosed."',
				catsyncdir='".$vbulletin->db->escape_string($catsyncdir)."',
				catsynctime='0',
				catsyncdone='0',
				displayorder='".$display_order."'
			WHERE catid='".$catid."'
		");

		ldm_datastore_markdirty('ldm_cats');

		require_once(DIR . '/includes/local_links_forumsinterface.php');
		$res = ldm_insert_cat_in_forum($auto_forumlink, $catid, $pforum, $forumname);
		ldm_fix_cat_parentlist();
		ldm_fix_cat_count();

		if ($force_permissions == 1) {

			$asb = $vbulletin->db->query_read("
				SELECT DISTINCT link.linkid AS linkid
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid = ltoc.linkid
				WHERE ltoc.catid='$catid'
			");
			if ($vbulletin->db->num_rows($asb)>0) {
				$linkidlist = array();
				while ($myrow=$vbulletin->db->fetch_array($asb)) {
					$linkidlist[] = $myrow["linkid"];
				}
				$linkidlist = implode(',', $linkidlist);
				$query = "
					UPDATE ".THIS_TABLE."linkslink SET
					linkforum='$pforum'
					WHERE linkid IN($linkidlist)
				";
				$vbulletin->db->query_write($query);
			}
		}

		($hook = vBulletinHook::fetch_hook('ldm_editcat_complete')) ? eval($hook) : false;

		if ($vbulletin->GPC['catadminscan']) {
			$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=admin&amp;set=scan&amp;catid=$catid".($catsyncdir ? "&amp;dir=$catsyncdir" : "");
			eval(print_standard_redirect($vbphrase['ll_accepted'],0));
		}
		else {
			if ($catmod != 1) {
				$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$catid";
			}
			$vbulletin->url = $url;
			eval(print_standard_redirect($vbphrase['ll_edited'],0));
		}

	}

	if ($submit == 'delete' and $catid>0) {
		$hasentries = 0;
		foreach ($linkscat as $thiscat) {
			if ($thiscat["parentid"] == $catid) {
				$hasentries = 1;
				break;
			}
		}
		if (!$hasentries) {
			$asb = $vbulletin->db->query_read("
				SELECT * FROM ".THIS_TABLE."linksltoc
				WHERE catid='".$catid."'
				");
			$hasentries = $vbulletin->db->num_rows($asb);
		}
		if ($hasentries) {
			$err = $vbphrase['ll_error_catnotempty'].$vbphrase['ll_goback'];
			eval(standard_error($err));
			exit;
		}
		else {
        	require_once(DIR . '/includes/local_links_misc.php');
			ldm_delete_category($catid);
			($hook = vBulletinHook::fetch_hook('ldm_editcat_delete_complete')) ? eval($hook) : false;
			$vbulletin->url = $url;
			eval(print_standard_redirect($vbphrase['ll_deleted'],0));
		}
	}

	exit;
}

// ################# Do report bad link

if ($this_action == 'doreport') {

	if (!$links_permissions["can_report_link"]) {
		print_no_permission();
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'message'	=> TYPE_STR,
		'linkid'	=> TYPE_INT,
		'cancel'	=> TYPE_STR,
		'catid'		=> TYPE_INT,
		'humanverify' => TYPE_ARRAY,
	));

	$linkid = $vbulletin->GPC['linkid'];
	$catid = $vbulletin->GPC['catid'];

// Take care - VB version specific
	if (VALID_VB_VERSION=="3.7") {
    	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_contactus']) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verify =& vB_HumanVerify::fetch_library($vbulletin);
    		if (!$verify->verify_token($vbulletin->GPC['humanverify'])) {
	    		$errors[] = fetch_error($verify->fetch_error());
		    	$vbulletin->url = $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=reportlink&linkid='.$linkid.'&catid='.$catid;
    			eval(print_standard_redirect($errors[0],0, 1));
	    	}
	    }
	}
	if (VALID_VB_VERSION=="3.8") {
    	if (!$vbulletin->userinfo['userid'] AND fetch_require_hvcheck('contactus')) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verify =& vB_HumanVerify::fetch_library($vbulletin);
    		if (!$verify->verify_token($vbulletin->GPC['humanverify'])) {
	    		$errors[] = fetch_error($verify->fetch_error());
		    	$vbulletin->url = $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=reportlink&linkid='.$linkid.'&catid='.$catid;
    			eval(print_standard_redirect($errors[0],0, 1));
	    	}
	    }
	}
// Take care - VB version specific

	if ($catid>0) {
		$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=".$catid."&amp;page=".$pagenumber;
	}
	else {
		$catidarray = ldm_lookup_categories($linkid);
		if (!count($catidarray)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $linkid)));
		}
		if ($catid==$BASE_CAT) {
			$catid = $catidarray[0];
			$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=".$catid;
		}
		else {
			$url = $SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=find&amp;catid=".$catid."&amp;page=".$pagenumber;
			$catid = $catidarray[0];
		}
	}

	if ($vbulletin->GPC['cancel']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
	}

	if (!$vbulletin->GPC['message']) {
		eval(print_standard_redirect($vbphrase['ll_error_required_fields'],0, 1));
	}

	$rec = $vbulletin->db->query_first("
		SELECT linkid, linkforum
		FROM " . THIS_TABLE . "linkslink
		WHERE linkid = ".$linkid."
		LIMIT 1
	");

	$linkforum = $rec['linkforum'];
	$foruminfo = false;
	if ($linkforum>0) {
		$foruminfo = fetch_foruminfo($rec['linkforum']);
	}

	require_once(DIR . '/includes/local_links_misc.php');
	$report_users = ldm_lookup_userids(explode(';', ldm_lookup_setting($catid, 'report_email_usernames')));
	$mods = ldm_fetch_moderators($catid, $report_users, ldm_lookup_setting($catid, 'report_email'));

	($hook = vBulletinHook::fetch_hook('ldm_report_send_process')) ? eval($hook) : false;

	$subject = construct_phrase($vbphrase['ll_admin_report_subject'], $vbulletin->options['bbtitle']);
	$message = construct_phrase($vbphrase['ll_admin_report_body'],
		$vbulletin->userinfo['username'],
		$vbulletin->userinfo['email'],
		ldm_make_filename($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$catid.'&linkid='.$linkid),
		$vbulletin->GPC['message'],
		(isset($_SERVER[REMOTE_ADDR]) ? $_SERVER[REMOTE_ADDR] : 'unknown')
		);

	$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);

	foreach ($mods AS $index => $moderator) {
		if (!empty($moderator['email'])) {
			vbmail($moderator['email'], $subject, $message, true);
		}
	}

	($hook = vBulletinHook::fetch_hook('ldm_report_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	eval(print_standard_redirect($vbphrase['ll_admin_report_thanks'],0));

}

// ################# Do send to friend

if ($this_action == 'dosendtofriend') {

	if (!$links_permissions["can_send_tofriend"]) {
		eval(standard_error($vbphrase['ll_error_nosend']));
		exit;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'emailmessage' => TYPE_STR,
		'emailsubject' => TYPE_STR,
		'linkid'	=> TYPE_INT,
		'cancel'	=> TYPE_STR,
		'catid'		=> TYPE_INT,
		'humanverify' => TYPE_ARRAY,
		'sendtoemail' => TYPE_STR,
		'sendtoname' => TYPE_STR,
	));

	$linkid = $vbulletin->GPC['linkid'];
	$catid = $vbulletin->GPC['catid'];

// Take care - VB version specific
	if (VALID_VB_VERSION=="3.7") {
    	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_contactus']) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verify =& vB_HumanVerify::fetch_library($vbulletin);
    		if (!$verify->verify_token($vbulletin->GPC['humanverify'])) {
	    		$errors[] = fetch_error($verify->fetch_error());
		    	$vbulletin->url = $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=sendtofriend&linkid='.$linkid.'&catid='.$catid;
			    eval(print_standard_redirect($errors[0],0, 1));
		    }
		}
	}
	if (VALID_VB_VERSION=="3.8") {
    	if (!$vbulletin->userinfo['userid'] AND fetch_require_hvcheck('contactus')) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verify =& vB_HumanVerify::fetch_library($vbulletin);
    		if (!$verify->verify_token($vbulletin->GPC['humanverify'])) {
	    		$errors[] = fetch_error($verify->fetch_error());
		    	$vbulletin->url = $LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=sendtofriend&linkid='.$linkid.'&catid='.$catid;
			    eval(print_standard_redirect($errors[0],0, 1));
		    }
		}
	}
// Take care - VB version specific

	if ($catid>0) {
		$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=".$catid."&amp;page=".$pagenumber;
	}
	else {
		$catidarray = ldm_lookup_categories($linkid);
		if (!count($catidarray)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $linkid)));
		}
		if ($catid==$BASE_CAT) {
			$catid = $catidarray[0];
			$url = $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=".$catid;
		}
		else {
			$url = $SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=find&amp;catid=".$catid."&amp;page=".$pagenumber;
			$catid = $catidarray[0];
		}
	}

	if ($vbulletin->GPC['cancel']) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_abandoned'],0));
	}

	if (empty($vbulletin->GPC['sendtoname']) OR !is_valid_email($vbulletin->GPC['sendtoemail'])
		OR empty($vbulletin->GPC['emailsubject']) OR empty($vbulletin->GPC['emailmessage'])
		OR !is_valid_email($vbulletin->GPC['sendtoemail'])
		) {
		eval(print_standard_redirect($vbphrase['ll_error_required_fields'],0, 1));
	}

	$postusername = $vbulletin->userinfo['username'];
	eval(fetch_email_phrases('sendtofriend'));

	vbmail($vbulletin->GPC['sendtoemail'], $vbulletin->GPC['emailsubject'], $vbulletin->GPC['emailmessage'], true);

	($hook = vBulletinHook::fetch_hook('ldm_sendtofriend_complete')) ? eval($hook) : false;

	$vbulletin->url = $url;
	$sendtoname = htmlspecialchars_uni($vbulletin->GPC['sendtoname']);
	eval(print_standard_redirect($vbphrase['ll_emailsent'].' '.$sendtoname,0));

}

/* ===========================================================================*/
// Fall through
/* ===========================================================================*/

$vbulletin->url = $LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'];
eval(print_standard_redirect($vbphrase['ll_error_command'],0));
exit;

?>