<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_links');
define('CSRF_PROTECTION', true);
define('GET_EDIT_TEMPLATES', true);

if (empty($_REQUEST['action'])) $_REQUEST['action'] = "links";
if (empty($_REQUEST['do'])) $_REQUEST['do'] = $_REQUEST['action'];

// get special phrase groups
$phrasegroups = array(
	'cprofilefield',
	'local_links',
	'local_links_entities',
	'postbit',
	'posting',
	'threadmanage',
	'timezone',
);

// pre-cache all templates used by this hack
$globaltemplates = array(
	'links_access_error',
	'links_agreement',
	'links_bandwidthbit',
	'links_catbit',
	'links_catbit_brief',
	'links_catbit_extras',
	'links_catjump',
	'links_catmouseover',
	'links_catsortbit',
	'links_downloadbit',
	'links_editbit',
	'links_entitymarkupbit',
	'links_favbit',
	'links_filter',
	'links_footer',
	'links_header',
	'links_hitparade',
	'links_hitparadebit',
	'links_imgmag',
	'links_keysbit',
	'links_introbit',
	'links_likebit',
	'links_linkbit',
	'links_linkbit_featured',
	'links_linkbit_greg',
	'links_linkbit_jukebox',
	'links_linkbit_mshort',
	'links_linkbit_mtop',
	'links_linkbit_photo',
	'links_linkbit_short',
	'links_linkbit_short_cent',
	'links_linkbit_short_direct',
	'links_linkbit_table',
	'links_linkseparator',
	'links_listselect',
	'links_main',
	'links_navbar',
	'links_navbar_popups',
	'links_nominatebit',
	'links_nominated_leaderbit',
	'links_othercatsbit',
	'links_ratebit_ajax',
	'links_ratebit_dropdown',
	'links_ratebit_inline',
	'links_ratesortbit',
	'links_reportlinkbit',
	'links_scantext',
	'links_search',
	'links_search_catselect',
	'links_selectkeyword',
	'links_sendemail',
	'links_sendtofriendbit',
	'links_subcatbit',
	'links_uploadinfo',
	'links_viewone_entity',
	'links_viewone_inline_comment',
	'links_viewone_nomination',
	'links_viewone_nominator',
	'links_viewone_popup_comment',

	'forumdisplay_moderator',
	'STANDARD_ERROR_LITE',

	);

// get special data templates from the datastore
$specialtemplates = array(
	'attachmentcache',
	'bbcodecache',
	'ldm_admin',
	'ldm_cats',
	'smiliecache',
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'play' => array(
		'links_JWplayer_header',
		'links_linkbit_jukebox',
		'links_play_embedded',
		'links_play_standalone',
		'links_playbit',
		'links_playerbit_DivX',
		'links_playerbit_JWPlayer',
		'links_playerbit_MediaPlayer',
		'links_playerbit_QuickTime',
		'links_playerbit_RealPlayer',
		'links_playerbit_Wimpy',
		'links_playerbit_WimpyFlash',
		'links_WimpyButton_header',
		'links_WimpyFlash_header',
		'links_Wimpyplayer_header',
	),
	'addcat' => array(
		'links_addnewcat',
		'links_addnewcat_oneentity',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_addnewlink_catinput_one',
		'links_admin_oneperm',
		'links_admin_oneperm_end',
		'links_admin_onesetting',
		'links_admin_onesetting_end',
		'links_admin_onesetting_start',
		'links_admin_setting_break',
		'links_admin_setting_foot',
		'links_admin_setting_jump',
		'links_admin_setting_title',
	),
	'editcat' => array(
		'links_addnewcat',
		'links_addnewcat_oneentity',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_addnewlink_catinput_one',
		'links_admin_oneperm',
		'links_admin_oneperm_end',
		'links_admin_onesetting',
		'links_admin_onesetting_end',
		'links_admin_onesetting_start',
		'links_admin_setting_break',
		'links_admin_setting_foot',
		'links_admin_setting_jump',
		'links_admin_setting_title',
	),
	'addlink' => array(
		'links_addentity',
		'links_addentitygroup',
		'links_addnewlink',
		'links_addnewlink_catinput',
		'links_addnewlink_catinput_multi',
		'links_addnewlink_catinput_one',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_addnewlink_upload',
		'links_timebit',
	),
	'addmultilink' => array(
		'links_addnewmultilink',
		'links_addnewmultilink_one',
		'links_addnewlink_catinput',
		'links_addnewlink_catinput_multi',
		'links_addnewlink_catinput_one',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_addnewlink_upload',
		'links_timebit_multi',
	),
	'editlink' => array(
		'links_addentity',
		'links_addentitygroup',
		'links_addnewlink',
		'links_addnewlink_catinput',
		'links_addnewlink_catinput_multi',
		'links_addnewlink_catinput_one',
		'links_addnewlink_catselect',
		'links_addnewlink_catselect_hidden',
		'links_addnewlink_catselect_multi',
		'links_addnewlink_catselect_one',
		'links_addnewlink_upload',
		'links_timebit',
	),
	'ratelink' => array(
		'links_view_all_comments',
		'links_viewone_comment',
	),
	'iframe' => array(
		'links_iframed',
		'links_linkbit_jukebox',
	),
	'jump' => array(
		'links_mirror_select',
		'links_mirror_select_one',
	),
	'mod' => array(
		'links_moderate_main',
		'links_moderate_catbit',
		'links_moderate_catbit_null',
	),
	'reportlink' => array(
		'links_report',
		'humanverify',
		'imagereg',
	),
	'sendtofriend' => array(
		'humanverify',
		'imagereg',
	)
);

// fire up VBulletin backend
require_once('./global.php');

if (!$vbulletin->products[THIS_PRODUCT_NAME]) {
	eval(standard_error($vbphrase['ll_error_product_disabled']));
	exit;
}

if (!empty($vbulletin->db->explain)) {
	$vbulletin->db->timer_start('Including LDM initialisation functions');
	require_once(DIR . '/includes/local_links_init.php');
	require_once(DIR . '/includes/local_links_include.php');
	$vbulletin->db->timer_stop(false);
}
else {
	require_once(DIR . '/includes/local_links_init.php');
	require_once(DIR . '/includes/local_links_include.php');
}

($hook = vBulletinHook::fetch_hook('ldm_start')) ? eval($hook) : false;

// Abbreviated quick jump .. script.php?go=N
if (array_key_exists('go', $_REQUEST)) {
	$_REQUEST['action'] = "jump";
	$_REQUEST['linkid'] = intval($_REQUEST['go']);
	unset($_REQUEST['go']);
}

$vbulletin->input->clean_array_gpc('r', array(
	'action'	=> TYPE_STR,
	'pp'		=> TYPE_INT,
	'page'		=> TYPE_INT,
	));

$this_action = $vbulletin->GPC_exists['action'] ? $vbulletin->GPC['action'] : "links";

if ($vbulletin->GPC_exists['pp']) {
	$perpage = $vbulletin->GPC['pp'];
}
else {
	$perpage = $vbulletin->userinfo['maxposts'];
	$checkmax = explode(',', $vbulletin->options['usermaxposts'] . ',' . $vbulletin->options['maxposts']);
	if ($perpage < 1 OR $perpage > max($checkmax)) {
		$perpage = $vbulletin->options['maxposts'];
	}
	$perpage = ($links_defaults['links_per_page']!=0 ? $links_defaults['links_per_page'] : $perpage);
}

$pagenumber = ($vbulletin->GPC_exists['page'] ? $vbulletin->GPC['page'] : 1);
$master_title = htmlspecialchars_uni(($links_defaults['database_name'] ? $links_defaults['database_name'] : $vbphrase['ll_links_database']));

/**
* Process 'accept me' form.  User's agreement set as an entry in the links_downloads table with linkid=0.
* Acceptance good until 24 hours after that record's timestamp...
*
* @return	bool		Can proceed
*/

function ldm_lookup_acceptme_form() {
	global $vbulletin, $links_defaults;

	if (!$links_defaults['force_accept']) {
		return 1;
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'ldm_accept_form' => TYPE_STR,
		));

	$ldm_accept = 0;
	if ($vbulletin->GPC_exists['ldm_accept_form']) {
		$ldm_accept = $vbulletin->GPC['ldm_accept_form'];
		$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linksdownloads
			WHERE linkid=0
			AND userid=".$vbulletin->userinfo['userid']."
			");
		if ($ldm_accept>0) {
			$vbulletin->db->query_write("
				INSERT INTO ".THIS_TABLE."linksdownloads
				SET
					linkid=0,
					linkurl='Accepts site terms',
					bytes=0,
					userid='".$vbulletin->userinfo['userid']."',
					username='".$vbulletin->db->escape_string($vbulletin->userinfo['username'])."',
					usertime='".TIMENOW."',
					userip='".(isset($_SERVER[REMOTE_ADDR]) ? $_SERVER[REMOTE_ADDR] : 'unknown')."'
				");
		}
	}
	else {
		$asb = $vbulletin->db->query_read("
			SELECT linkid, userid, usertime
			FROM ".THIS_TABLE."linksdownloads
			WHERE linkid=0
			AND ".
				($vbulletin->userinfo['userid']
				 ? "userid='".$vbulletin->userinfo['userid']."'"
				 : "userid='0' AND userip='" . (isset($_SERVER[REMOTE_ADDR]) ? $_SERVER[REMOTE_ADDR] : 'unknown') ."'"
				) . "
			ORDER BY usertime DESC
			LIMIT 1
		");
		if ($vbulletin->db->num_rows($asb)) {
			$ldm_accept_timeout = 24*60*60; // one day
			$rec = $vbulletin->db->fetch_array($asb);
			if (($rec['usertime']+$ldm_accept_timeout)>TIMENOW) {
				$ldm_accept = 1;
			}
		}
	}
	return $ldm_accept;
}

/* ===========================================================================*/
// Main command functions
/* ===========================================================================*/

// #################### Main display page

if ($this_action == "links") {

    require_once('./includes/local_links_main_links.php');
    exit;

}

// #################### Embedded linkbit only, for Jukebox

if ($this_action == "iframe") {

    require_once('./includes/local_links_main_links.php');
    exit;

}

// #################### Moderate

if ($this_action == "mod") {

    require_once('./includes/local_links_main_moderate.php');
    exit;

}

// #################### Add Entry

if ($this_action == "addlink") {

    require_once('./includes/local_links_main_entries.php');
    exit;

}

// #################### Add Multiple Entries

if ($this_action == "addmultilink") {

    require_once('./includes/local_links_main_entries.php');
    exit;

}

// #################### Edit Entry

if ($this_action == "editlink") {

    require_once('./includes/local_links_main_entries.php');
    exit;

}

// #################### View Link and its Comments/Ratings

if ($this_action == "ratelink") {

    require_once('./includes/local_links_main_reactions.php');
    exit;

}

// #################### Report bad link

if ($this_action == "reportlink") {

    require_once('./includes/local_links_main_reactions.php');
    exit;
}

// #################### Send email about link

if ($this_action == "sendtofriend") {

    require_once('./includes/local_links_main_reactions.php');
    exit;
}

// #################### Add Category

if ($this_action == "addcat") {

    require_once('./includes/local_links_main_categories.php');
    exit;

}

// #################### Edit Category

if ($this_action == "editcat") {

    require_once('./includes/local_links_main_categories.php');
    exit;

}

/* ===========================================================================*/
// Action [play, download] functions
/* ===========================================================================*/

// Launch embedded media player

if ($this_action == "play") {

    require_once('./includes/local_links_main_fetch.php');
    exit;

}

// Jump to link - open/download

if ($this_action == "jump") {

    require_once('./includes/local_links_main_fetch.php');
    exit;

}

/* ===========================================================================*/
// Fall through
/* ===========================================================================*/

($hook = vBulletinHook::fetch_hook('ldm_fallthrough_error')) ? eval($hook) : false;

$vbulletin->url = $LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q'];
eval(print_standard_redirect($vbphrase['ll_error_command'],0));
exit;

?>