<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

function ldm_vba_cats($base_cat, $cat_depth_display, $cat_cols_display, $cat_sub_display, $main_template, $sub_template) {
	global $links_permissions, $links_defaults, $linkscat;
	global $limitfids;

	$limitfids = ldm_lookup_forum_protections($links_permissions['can_see_protected_links_on_portal']);
	$sort = (isset($links_defaults['default_sort_order']) ? $links_defaults['default_sort_order'] : 'N');
	$links_permissions['can_edit_category'] = 0;

	$hold_cat_sub_display = $links_defaults['cat_sub_display'];
	$links_defaults['cat_sub_display'] = $cat_sub_display;

	$catlistarray = array();
	$base_cats = explode(',', $base_cat);

	if ($cat_depth_display<=0) {
		foreach ($base_cats as $thiscatid) {
			$thiscatid = intval($thiscatid);
			if ($thiscatid<=0 or !isset($linkscat[$thiscatid])) {
				continue;
			}
			ldm_get_categorybits($catlistarray, $main_template, $sub_template, $thiscatid, array(), 0);
		}
	}
	else {
		foreach ($base_cats as $thiscatid) {
			$thiscatid = intval($thiscatid);
			if ($thiscatid<=0) {
				$thiscatid = -1;
			}
			$cattree = ldm_cat_walk($thiscatid, $cat_depth_display, $sort);
			foreach ($cattree AS $thisid=>$thischildren) {
				ldm_get_categorybits($catlistarray, $main_template, $sub_template, $thisid, $thischildren, 0);
			}
		}
	}

	$cats = ldm_map_listbit_to_vba_grid($catlistarray, $cat_cols_display);

	$links_defaults['cat_sub_display'] = $hold_cat_sub_display;

	return $cats;
}

function ldm_vba_links($filter, $hitssince, $order, $template, $catsee, $linksee, $ncols=1, $showsubcats=0, $showcatname=0, $pagenumber=1) {
	global $vbulletin;
	global $links_defaults, $links_permissions, $linkscat;

	$limitfids = ldm_lookup_forum_protections($links_permissions["can_see_protected_links_on_portal"]);
	$filter[] = 'link.linkforum NOT IN ('.implode(',', $limitfids).') ';

	$pagenumber = max($pagenumber, 1);

	if ($showsubcats and $catsee) {
		$catparents = explode(',', $catsee);
		foreach ($linkscat as $thiscat) {
			$cplist = explode(',', $thiscat['parentlist']);
			foreach ($catparents as $cp) {
				if (in_array($cp, $cplist)) {
					$catsee .= ", ".$thiscat['catid'];
				}
			}
		}
	}

	if ($catsee) {
		$filter[] = 'ltoc.catid IN ('.$vbulletin->db->escape_string($catsee).')';
	}

	$query = ldm_get_mainsql($filter, $hitssince, 0, $order, 0, 0);
	$linklistarray = array();
	$entrybit_options = array('showcatname'=>$showcatname, );
	$nhits = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $template, $query, $entrybit_options, $pagenumber, $linksee);

	$links = ldm_map_listbit_to_vba_grid($linklistarray, $ncols);

	unset($linklistarray);

	return array($links, $nhits, $query);
}

/**
* Map listbit vector onto a grid to produce multicolumn layouts
*
* @param	array	Listbit vector
* @param	int		No. columns
* @return	bool	String, html
*
* Modified version of ldm_map_listbit_to_vba_grid for use in vba
*/

function ldm_map_listbit_to_vba_grid($listbit, $columns=1) {

	$ilast = count($listbit)-1;
	if ($ilast<0) {
		return "";
	}

    foreach ($listbit as $inext=>$ibit) { // Kill any separator rows
		if ($listbit[$inext] and ctype_digit($listbit[$inext])) {
			unset($listbit[$inext]);
		}
	}

	$result = ldm_layout_listbit_vba($listbit, $columns);

	return $result;

}

/**
* Do the detailed work for ldm_map_listbit_to_grid for one group of listbits
*
* @param	array	Listbit vector
* @param	int		No. columns
* @return	str		Table structure
*
*/

function ldm_layout_listbit_vba($listbit, $columns) {
	global $stylevar;
	$result = "";

// Straightforward single column cases
	if ($columns==1) {
		$alt = 1;
		foreach ($listbit as $thisbit) {
		    $thisbit = preg_replace("#<td#", "<td class='alt".$alt."'", $thisbit);
			$result .= "\n".$thisbit."\n";
		    $alt = ($alt==1 ? 2 : 1);
		}
		return $result;
	}

// Multicolumn cases
	$kr  = 1;
	$kc  = 1;
	$alt = 1;
	$tcl = 2*$columns - 1;

    $width = (int) round(100/$columns);

	foreach ($listbit as $thisbit) {
		$thisbit = preg_replace("#<tr[^>]*>(.*)</tr>#s", "$1", $thisbit); // Remove table row tags

        if (preg_match("#<td[^>]*style\s*=\s*#", $thisbit)) { // Add width within style attribute
    		$thisbit = preg_replace('#(<td[^>]*)style\s*=\s*"#', '$1style="width:'.$width.'%; ', $thisbit);
        }
        else {
    		$thisbit = preg_replace('#<td#', '<td style="width:'.$width.'%;"', $thisbit);
        }

		$thisbit = preg_replace('#<td#', '<td class="alt'.$alt.'" ', $thisbit);

		$table[$kr][$kc] = $thisbit;
		$kc+=1;
		if ($kc<$tcl) {
    		$table[$kr][$kc] = '<td class="alt'.$alt.'" style="width:'.$stylevar['cellpadding'].'px;">&nbsp;</td>';
	    	$kc+=1;
	    }

		if ($kc>$tcl) {
			$kc=1;
			$kr+=1;
    	    $alt = ($alt==1 ? 2 : 1);
		}
	}

	if ($kc>1) {
		while ($kc<=$tcl) {
			$table[$kr][$kc] = '<td class="alt'.$alt.'"' . ( $kc%2==0 ? ' style="width:"'.$stylevar['cellpadding'].'px;"' : '') . ">&nbsp;</td>";
			$kc+=1;
		}
	}

	foreach ($table as $kr=>$row) {
		$result .= "\n<tr>\n";
		foreach ($row as $kc=>$cell) {
			$result .= "\n".$cell."\n";
		}
	    $result .= "\n</tr>\n";
	}

	unset($table);
	return $result;

}

/**
* Construct the requested 'hit parades'
*
* @param	int		Categoryid
* @return	str		Displaybit
*/

function ldm_get_hitparades($catid, $template="links_hitparade") {
	global $vbulletin, $vbphrase, $stylevar;
	global $links_defaults, $links_permissions;
	global $FAVS_CAT, $HIDE_CAT, $AVL_CAT, $BRKN_CAT, $INVD_CAT, $HOT_CAT;
	global $NEW_CAT, $RND_CAT, $MY_CAT, $UPLD_CAT, $FEAT_CAT, $NEW_RATE, $NOM_CAT, $CNOM_CAT;
	global $LINK_ACCEPTED, $LINK_TO_MODERATE;
	global $SEARCH_SCRIPT;

    require_once(DIR . '/includes/local_links_bitcache.php');

    $pageident = "ldmhits_$catid";
    $cachebit = "LDM_vba_".$pageident;

    if (!ldm_fetch_cachedbit($cachebit, $hitbits, $showme)) {

    	$linksee  = (isset($links_defaults['links_seen_on_portal']) ? $links_defaults['links_seen_on_portal'] : 3);
	    $newsince = $hitsince = ($links_defaults['days_seen_on_portal'] ? TIMENOW-intval($links_defaults['days_seen_on_portal'])*24*60*60 : $vbulletin->userinfo['lastvisit']);
    	$catids	  = ($catid>0 ? array($catid) : 0);
	    $showme   = 0;

    	if ($links_defaults['show_hp_new_summary']) {
	    	$mquery = "";
		    if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
			    if (!$vbulletin->userinfo['userid']) {
    				$mquery = "AND link.linkmoderate = ".$LINK_ACCEPTED;
	    		}
		    	else {
			    	$mquery = "AND (link.linkmoderate = ".$LINK_ACCEPTED." OR
				    		(link.linkmoderate = ".$LINK_TO_MODERATE." AND link.linkuserid = ".$vbulletin->userinfo['userid'].")
					    		)";
			    }
		    }
    		$limitfids = ldm_lookup_forum_protections($can_bypass);
	    	$query = "
		    	SELECT COUNT(linkid) AS newlinks
			    FROM ".THIS_TABLE."linkslink AS link
    			WHERE link.linkforum NOT IN (".implode(',', $limitfids).")
	    		AND linkdate > ".$hitsince."
		    	$mquery
			    ";
    		$count = $vbulletin->db->query_first("$query");
	    	$hitdate = ldm_date($vbulletin->options['dateformat'], $hitsince);
		    $links['new_summary']	= $count['newlinks'];
    		$showme = 1;
	    }

    	if ($links_defaults['show_hp_new']) {
	    	$query = ldm_get_specialsearchsql($NEW_CAT, $linksee, "", $catids);
		    list($links['show_hp_new'], $hits) = ldm_get_entrybits_brief($query, $linksee, $template);
    		$showme = ($hits ? 1 : $showme );
	    }

    	if ($links_defaults['show_hp_top']) {
	    	$query = ldm_get_specialsearchsql($HOT_CAT, $linksee, "", $catids, 0, $hitsince);
    		list($links['show_hp_top'], $hits) = ldm_get_entrybits_brief($query, $linksee, $template);
	    	$showme = ($hits ? 1 : $showme );
	    }

    	if ($links_defaults['show_hp_topall']) {
	    	$query = ldm_get_specialsearchsql($HOT_CAT, $linksee, "", $catids);
		    list($links['show_hp_topall'], $hits) = ldm_get_entrybits_brief($query, $linksee, $template);
    		$showme = ($hits ? 1 : $showme );
	    }

    	if ($links_defaults['show_hp_newcomment']) {
	    	$query = ldm_get_specialsearchsql($NEW_RATE, $linksee, "", $catids);
		    list($links['show_hp_newcomment'], $hits) = ldm_get_entrybits_brief($query, $linksee, $template);
    		$showme = ($hits ? 1 : $showme );
	    }

    	if ($links_defaults['show_hp_nominate']) {
	    	$query = ldm_get_specialsearchsql($NOM_CAT, $linksee, "", $catids);
		    list($links['show_hp_nominate'], $hits) = ldm_get_entrybits_brief($query, $linksee, $template);
    		$showme = ($hits ? 1 : $showme );
	    }

    	if ($links_defaults['show_hp_random']) {
	    	$query = ldm_get_specialsearchsql($RND_CAT, $linksee, "", $catids);
		    list($links['show_hp_random'], $hits) = ldm_get_entrybits_brief($query, $linksee, $template);
    		$showme = ($hits ? 1 : $showme );
	    }

    	$hitbits = "";
    	if ($showme) {
	    	eval("\$hitbits  = \"".fetch_template('links_hitparadebit')."\";");
	    }

        ldm_store_cachedbit($cachebit, $hitbits, $showme);

    }

	return $hitbits;
}

/**
* Simplified linkbit constructor used by portal interfaces and hit parades
*
* @param	str		Search query
* @param	int		Maximum number of entries to display
* @param	str		Linkbit
* @param	array	Optional, additional attribute values to patch into linkbits
* @return	str		Displaybit
*/

function ldm_get_entrybits_brief($query, $linksee, $template, $addvars=0) {
	global $vbulletin, $stylevar, $bgclass;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;
	global $links_defaults, $links_permissions, $linkscat, $ldm_icon_cache;
	global $show_catname;

	cache_LDMicons();
	$nhits = 0;
	$hits = array();
	$linkbit = array();

	$expire = 0;
	if ($links_defaults['links_expiry_days']>0) {
		$expire = $links_defaults['links_expiry_days']*86400;
	}

	$asb = $vbulletin->db->query_read($query);
	while ($myrow=$vbulletin->db->fetch_array($asb) and $nhits<$linksee) {
		$linkid	   = $myrow["linkid"];
		if (is_array($addvars)) {
			if (isset($addvars[$linkid])) {
				foreach ($addvars[$linkid] as $thiskey=>$thisval) {
					$myrow[$thiskey] = $thisval;
				}
			}
		}
		if (isset($hits[$linkid])) {
			continue;
		}

		$linkexpired = 0;
		$linkdatebin = $myrow["linkdate"];
		$linkstatus = $myrow["linkstatus"];
		if ($expire) {
			if ($linkdatebin>TIMENOW+60) {
				$linkexpired = -1;  // post-dated, so just invisible
			}
			elseif ($linkdatebin+$expire<TIMENOW) {
				$linkexpired = +1;
			}
		}
		if (($linkstatus==$LINK_HIDDEN or $linkexpired) and !$links_permissions["can_view_hidden"]) {
			continue;
		}

		$hits[$linkid] = 1;
		$nhits++;
		$catid		= $myrow["linkcatid"];
		$linkname	= $myrow["linkname"];
		$linkshortname = fetch_trimmed_title(ldm_kill_bbcodes($linkname), $links_defaults['length_shortname'], 1);
		$linkname	= ldm_parse_features($linkname);
		$linkdesc	= $myrow["linkdesc"];
		$linkshortdesc = fetch_trimmed_title(ldm_kill_bbcodes($linkdesc), $links_defaults['length_shortdesc'], 1);
		$linkdesc	= ldm_parse_features($myrow["linkdesc"]);
		if (array_key_exists("linkrecenthits", $myrow)) {
			$linkhits = $myrow["linkrecenthits"];
		}
		else {
			$linkhits = $myrow["linkhits"];
		}
		$linksize   = ldm_format_bytes($myrow["linksize"]);
		$linkurllink = ldm_get_url_atag(-1, $catid, $linkid, $linkname);
		$linkurlshortlink = ldm_get_url_atag(-1, $catid, $linkid, $linkshortname);
		$linkimg	= $myrow["linkimg"];
		$linkimgthumb = $myrow["linkimgthumb"];
		$linkimgthumbsize = $myrow["linkimgthumbsize"];
		$linkdate	= ldm_date($vbulletin->options['dateformat'], $myrow["linkdate"]);
		$linkusername = $myrow["linkusername"];
		$linkuserid = $myrow["linkuserid"];

		$linkurl	= $myrow["linkurl"];
		$urlInfo	= ldm_parse_url($linkurl);

		$linkname_clean = str_replace(array("'", '"'), "", $linkname);
		$linkimgshow = ($linkimg ?
			(($linkimgthumb  and $linkimgthumbsize==$links_default['link_imagesize'] and !$urlInfo['user']) ?
		        ldm_get_imagebit(create_full_url(($linkimgthumb{0}!= '/' ? "/" : "") . $linkimgthumb), $linkname_clean) :
				ldm_get_imagebit(ldm_make_filename($vbulletin->options['bburl'],$RESIZE_SCRIPT.".php") . "?" . $vbulletin->session->vars['sessionurl'] . "linkid=$linkid&amp;catid=$catid'", $linkname_clean)
			) : "");
		$linkimgjump = ldm_get_url_atag(-1, $catid, $linkid, $linkimgshow);
		$linkcatname = $linkscat[$catid]["catname_clean"];
		$urlType	= file_extension($urlInfo['path']);
		if ($urlType and array_key_exists($urlType, $ldm_icon_cache)) {
			$linktypebit = ldm_get_imagebit($ldm_icon_cache[$urlType], $urlType);
		}
		else {
			$linktypebit = " ";
		}
		$linkhit	= $nhits;
		eval("\$linkbit[$linkid] = \"".fetch_template($template)."\";");
	}
	$vbulletin->db->free_result($asb);
	unset($hits); unset($myrow);

	if (is_array($addvars)) {
// return results sorted in same order as addvars
		$sortbit = array();
		foreach ($addvars as $thisid=>$thisvar) {
			$sortbit[] = $linkbit[$thisid];
		}
		$linkbit = implode(" ", $sortbit);
	}
	else {
		$linkbit = implode(" ", $linkbit);
	}

	return array($linkbit, $nhits);
}

/**
* Build the sql query used for special searches (hot, new, etc)
*
* @param	int		Search type, index into special categories defined in ldm_general_init
* @param	int		Optional, maximum number of entries to return
* @param	str		Optional, sort type, character or number of days
* @param	array	Optional, limit search to entries in these categories
* @param	int		Optional, limit search to entries created since this time
* @param	int		Optional, limit search to entries visited since this time
* @param	int		Optional, limit search to entries by userid
* @param	array	Optional, additional query terms
* @return	str		SQL query
*/

function ldm_get_specialsearchsql($searchtype, $showmax=0, $sort="", $catids=0, $newsince=0, $hitsince=0, $userid=0, $specialqueries=array()) {
	global $vbulletin;
	global $links_defaults, $links_permissions;
	global $links_starred;
	global $FAVS_CAT, $HIDE_CAT, $AVL_CAT, $BRKN_CAT, $INVD_CAT, $HOT_CAT;
	global $NEW_CAT, $RND_CAT, $MY_CAT, $UPLD_CAT, $FEAT_CAT, $NEW_RATE, $NOM_CAT, $CNOM_CAT;
	global $LINK_HIDDEN, $LINK_BROKEN, $LINK_UPLOAD, $LINK_NO_ACCESS, $LINK_ACCEPTED, $LINK_TO_MODERATE;

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = ldm_lookup_forum_protections($can_bypass);
	$joinfavs = 0;

	$query = $specialqueries;

	$query[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";

	if ($newsince) {
		$query[] = "link.linkdate > ".$newsince;
	}

	if ($userid) {
		$query[] = "link.linkuserid='".$userid."'";
	}

	if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
		if ($vbulletin->userinfo['userid'] == 0) {
			$query[] = "link.linkmoderate = $LINK_ACCEPTED";
		}
		else {
			$query[] = "(link.linkmoderate = $LINK_ACCEPTED OR
				(link.linkmoderate = $LINK_TO_MODERATE AND link.linkuserid = ".$vbulletin->userinfo['userid']."))";
		}
	}

	if (is_array($catids) and count($catids)) {
		$query[] = "ltoc.catid IN ('" . implode("','", $catids) ."')";
	}

    $lexpquery = "";
    if (!$links_permissions["can_view_hidden"] and $links_defaults['links_expiry_days']>0) {
	    $lexpwhen = intval(TIMENOW) - intval($links_defaults['links_expiry_days']*86400);
	    $lexpquery = "
    	    AND link.linkdate > " . $lexpwhen . "
    	    AND link.linkdate <= " . TIMENOW . "
    	    ";
    }

	switch ($searchtype) {

	case $FAVS_CAT:
		$joinfavs = 1;
		$query[] = "lfav.userid = '".$vbulletin->userinfo['userid']."'";
		break;

	case $HIDE_CAT:
		$query[] = "link.linkstatus='".$LINK_HIDDEN."'";
		break;

	case $AVL_CAT:
		$query[] = "link.linkstatus>0";
		break;

	case $BRKN_CAT:
		$query[] = "link.linkstatus='".$LINK_BROKEN."'";
		break;

	case $INVD_CAT:
		$query[] = "link.linkstatus='".$LINK_NO_ACCESS."'";
		break;

	case $UPLD_CAT:
		$query[] = "link.linkstatus='".$LINK_UPLOAD."'";
		break;

	case $NEW_CAT:

		$lquery = "
			SELECT link.linkid AS linkid
			FROM ".THIS_TABLE."linkslink AS link
			";
		if (is_array($catids) and count($catids)) {
			$lquery .= "
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid=ltoc.linkid
				";
		}
		$lquery .= "
			WHERE link.linkstatus>0
			AND " .implode(' AND ', $query) . "
			";
		if (is_array($catids) and count($catids)) {
			$lquery .= "
				AND ltoc.catid IN (" . implode(',', $catids) . ")
				";
		}
	    $lquery .= $lexpquery;
		$lquery .= "
			ORDER BY link.linkdate DESC
			";
		if ($showmax>0) {
		    $lquery .= "
		    LIMIT " . intval($showmax) . "
		    ";
		}
		$asb = $vbulletin->db->query_read($lquery);
		$ids = array(-1);
		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$ids[] = $myrow['linkid'];
		}
		$ids = implode(',', $ids);
		$query[] = "link.linkid IN (".$ids.")";
		break;

	case $MY_CAT:
		$query[] = "link.linkuserid=".$vbulletin->userinfo['userid'];
		break;

	case $FEAT_CAT:
		$feat_users = unserialize($links_defaults['featured_userid_favs']);
		$feat_users[] = -1;
		$joinfavs = 1;
		$query[] = "lfav.userid IN (".implode(',', $feat_users).")";
		break;

	case $RND_CAT:

		$lquery = "
			SELECT link.linkid AS linkid
			FROM ".THIS_TABLE."linkslink AS link
			";
		if (is_array($catids) and count($catids)) {
			$lquery .= "
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid=ltoc.linkid
				";
		}
		$lquery .= "
			WHERE link.linkstatus>0
			AND " .implode(' AND ', $query) . "
			";
		if (is_array($catids) and count($catids)) {
			$lquery .= "
				AND ltoc.catid IN (" . implode(',', $catids) . ")
				";
		}
	    $lquery .= $lexpquery;
		$lquery .= "
			ORDER BY RAND()
			LIMIT " . ($showmax>0 ? intval($showmax) : intval($links_defaults["links_seen_on_portal"])) . "
			";
		$asb = $vbulletin->db->query_read($lquery);
		$ids = array(-1);
		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$ids[] = $myrow['linkid'];
		}
		$ids = implode(',', $ids);
		$query[] = "link.linkid IN (".$ids.")";
		break;

	case $HOT_CAT:

		if ($hitsince) {
			if (count($limitfids)<=1 or (!is_array($catids) or !count($catids))) {
// Cheapest case, no forum protections to worry about
				$lquery = "
					SELECT linkid, COUNT(linkid) AS linkhits
					FROM ".THIS_TABLE."linksdownloads
					WHERE usertime>=".$hitsince."
					";
        	    $lquery .= $lexpquery;
				$lquery .= "
					GROUP BY linkid
					ORDER BY linkhits DESC
					";
        		if ($showmax>0) {
		            $lquery .= "
		            LIMIT " . intval($showmax) . "
		            ";
		        }
			}
			else {
				$lquery = "
					SELECT link.linkforum, lhits.linkid AS linkid, COUNT(lhits.linkid) AS linkhits
					FROM ".THIS_TABLE."linkslink AS link
					LEFT JOIN ".THIS_TABLE."linksdownloads AS lhits
					ON link.linkid = lhits.linkid
					";
				if (is_array($catids) and count($catids)) {
					$lquery .= "
						LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
						ON link.linkid=ltoc.linkid
						";
				}
				$lquery .= "
                    WHERE link.linkforum NOT IN (".implode(',', $limitfids).")
					AND usertime>=".$hitsince."
					";
				if (is_array($catids) and count($catids)) {
					$lquery .= "
						AND ltoc.catid IN (" . implode(',', $catids) . ")
						";
				}
        	    $lquery .= $lexpquery;
				$lquery .= "
					GROUP BY linkid
					ORDER BY linkhits DESC
					";
        		if ($showmax>0) {
		            $lquery .= "
		            LIMIT " . intval($showmax) . "
		            ";
		        }
			}
		}
		else {
			$lquery = "
				SELECT link.linkid AS linkid
				FROM ".THIS_TABLE."linkslink AS link
				";
			if (is_array($catids) and count($catids)) {
				$lquery .= "
					LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
					ON link.linkid=ltoc.linkid
					";
			}
			$lquery .= "
				WHERE link.linkstatus>0
				AND link.linkhits>0
				AND " .implode(' AND ', $query) . "
				";
			if (is_array($catids) and count($catids)) {
				$lquery .= "
					AND ltoc.catid IN (" . implode(',', $catids) . ")
					";
			}
    	    $lquery .= $lexpquery;
			$lquery .= "
				ORDER BY linkhits DESC
    			";
    		if ($showmax>0) {
	    	    $lquery .= "
		        LIMIT " . intval($showmax) . "
		        ";
		    }
		}

		$asb = $vbulletin->db->query_read($lquery);
		$ids = array(-1);
		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$ids[] = $myrow['linkid'];
		}
		$ids = implode(',', $ids);
		$query[] = "link.linkid IN (".$ids.")";
		break;

	case $NEW_RATE:

		$limit = ($showmax>0 ? intval($showmax) : intval($links_defaults["links_seen_on_portal"]));
		$lquery = "
			SELECT lrate.linkid AS linkid
			FROM ".THIS_TABLE."linksrate AS lrate
			LEFT JOIN ".THIS_TABLE."linkslink AS link
			ON lrate.linkid=link.linkid
			";
		if (is_array($catids) and count($catids)) {
			$lquery .= "LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid=ltoc.linkid
				";
		}
		$lquery .= "
			WHERE link.linkforum NOT IN (".implode(',', $limitfids).")
			";
		if (is_array($catids) and count($catids)) {
			$lquery .= "
				AND ltoc.catid IN (" . implode(',', $catids) . ")
				";
		}
	    $lquery .= $lexpquery;
		$lquery .= "
			ORDER BY lrate.ltime DESC
			LIMIT " . 3*$limit . "
		";

		$asb = $vbulletin->db->query_read($lquery);
		$ids = array(-1);
		$nids = 0;
		while ($myrow=$vbulletin->db->fetch_array($asb) and $nids<$limit) {
			if (!in_array($myrow['linkid'], $ids)) {
				$ids[] = $myrow['linkid'];
				$nids++;
			}
		}
		$ids = implode(',', $ids);
		$query[] = "link.linkid IN (".$ids.")";
		break;

	case $NOM_CAT:

		cache_LDMnominations();
		$ids = array(-1);
		if (is_array($links_starred)) {
			foreach ($links_starred as $thisperiod=>$thesestars) {
				if (is_array($thesestars['scores'])) {
					foreach ($thesestars['scores'] as $thisstar) {
						$ids[] = $thisstar['linkid'];
					}
				}
			}
		}
		$ids = implode(',', $ids);
		$query[] = "link.linkid IN (".$ids.")";
		break;

	case $CNOM_CAT:

		$lquery = "
			SELECT star.linkid AS linkid, COUNT(star.linkid) AS stars
			FROM ".THIS_TABLE."linkstarred AS star
			WHERE star.usertime>=".intval($links_defaults['starred_entries_periodstart'])."
			GROUP BY star.linkid
			ORDER BY stars DESC
			";
		$asb = $vbulletin->db->query_read($lquery);
		$ids = array(-1);
		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$ids[] = $myrow['linkid'];
		}
		$ids = implode(',', $ids);
		$query[] = "link.linkid IN (".$ids.")";
		break;

	}

	if ($links_defaults['links_show_othercats']) {
	    $query[] = "ltoc.catid <= ltoc2.catid";
	}

	$sorder = "";

	switch ($searchtype) {

	case $HIDE_CAT:
	case $AVL_CAT:
	case $BRKN_CAT:
	case $INVD_CAT:
	case $UPLD_CAT:
	case $FAVS_CAT:
	case $MY_CAT:
	case $FEAT_CAT:
	case $NEW_RATE:
		$sorder = ldm_get_sortsql($sort, 1);
		break;

	case $NEW_CAT:
	case $HOT_CAT:
	case $RND_CAT:
	case $NOM_CAT:
	case $CNOM_CAT:
		$sorder = "FIELD(link.linkid, ".$ids.")";
		$showmax = 0;
		break;

	}

	($hook = vBulletinHook::fetch_hook('ldm_specialsql_complete')) ? eval($hook) : false;

	$query = ldm_get_mainsql($query, $hitsince, $joinfavs, $sorder, $showmax, $links_defaults['links_show_othercats'], 1);
	return $query;

}

function ldm_vba_do_mediacols($modcol, $vba_modcols) {
    global $links_defaults;

    $my_column = $vba_modcols[$modcol];

    $JW_cols = str_replace(' ', '', $links_defaults['vba_media_JW_cols']);
    if ($JW_cols) {
        $JW_cols = explode(',', $JW_cols);
    }
    else {
        $JW_cols = array();
    }

    $links_defaults['inlineJWplayer_active'] = (in_array($my_column, $JW_cols) ? 1 : 0);

    $WB_cols = str_replace(' ', '', $links_defaults['vba_media_WB_cols']);
    if ($WB_cols) {
        $WB_cols = explode(',', $WB_cols);
    }
    else {
        $WB_cols = array();
    }

    $links_defaults['inlineWimpy_active'] = (in_array($my_column, $WB_cols) ? 1 : 0);

}

?>