<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

define(LDM_ENTRIES_TO_SHOW, 10);


function ldm_member_customfields_myentries($profilefieldid) {
	global $vbulletin, $vbphrase, $userinfo;

// Entries to show
	$entries_to_show = LDM_ENTRIES_TO_SHOW;
	$entries_to_scan = 3*LDM_ENTRIES_TO_SHOW;  // in case entries are in multiple categories

	$results = '';

	$rec = $vbulletin->db->query_read("
			SELECT links.linkid AS linkid, links.linkname AS linkname, links.linkdate AS linkdate,
			links.linkuserid AS userid, ltoc.catid AS catid, lcat.catname AS catname
			FROM ".THIS_TABLE."linkslink AS links
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON links.linkid = ltoc.linkid
			LEFT JOIN ".THIS_TABLE."linkscat AS lcat
			ON lcat.catid = ltoc.catid
			WHERE links.linkuserid = ".$userinfo[userid]."
			ORDER BY linkdate DESC, linkid ASC
			LIMIT ".$entries_to_scan."
			");
	$local_bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	$nrec = 0;
	$thislinkid = -1;

	while ($myrow = $vbulletin->db->fetch_array($rec)) {

		$catname_clean = htmlspecialchars_uni($myrow['catname']);
		$this_link = '<a href="'.LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$myrow['catid'].'&amp;linkid='.$myrow['linkid'].'" title="'.$catname_clean.'" target="_blank">';
		$this_item = "";

		if ($thislinkid==$myrow['linkid']) {
			$this_item =
				' '.
				$this_link.
				'+'.
				'</a>';
		}
		else {
			if ($thislinkid>0) {
				$this_item .= '<br />';
			}
			$linkname = $local_bbcode_parser->do_parse($myrow['linkname']);
			$this_item .=
				vbdate($vbulletin->options['dateformat'], $myrow['linkdate']).
				' '.
				vbdate($vbulletin->options['timeformat'], $myrow['linkdate']).
				' '.
				$this_link.
				$linkname.
				'</a>';
			$thislinkid = $myrow['linkid'];
			$nrec++;
		}

		($hook = vBulletinHook::fetch_hook('ldm_customfields_myentries')) ? eval($hook) : false;

		$results .= $this_item;

		if ($nrec>=$entries_to_show) {
			break;
		}

	}

	$this_item = "";
	if ($nrec>=$entries_to_show) {
		$this_item =
			'<br />'.
			'<a href="'.SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=show&amp;userid='.$userinfo['userid'].'&amp;sort=d">'.
			$vbphrase['ldm_all_entries'].
			'</a><br />';
	}
	elseif ($nrec==0) {
		$this_item = $vbphrase['none'];
	}

	($hook = vBulletinHook::fetch_hook('ldm_customfields_myentries')) ? eval($hook) : false;

	$results .= $this_item;

	return $results;

}

function ldm_member_customfields_myhits($profilefieldid) {
	global $vbulletin, $vbphrase, $userinfo;

	$entries_to_show = LDM_ENTRIES_TO_SHOW;
	$results = '';

	$rec = $vbulletin->db->query_read("
			SELECT downloads.linkid AS linkid, downloads.userid AS userid, downloads.usertime AS usertime,
			links.linkname AS linkname, ltoc.catid AS catid, lcat.catname AS catname
			FROM ".THIS_TABLE."linksdownloads AS downloads
			LEFT JOIN ".THIS_TABLE."linkslink AS links
			ON downloads.linkid = links.linkid
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON links.linkid = ltoc.linkid
			LEFT JOIN ".THIS_TABLE."linkscat AS lcat
			ON lcat.catid = ltoc.catid
			WHERE userid=".$userinfo[userid]."
			ORDER BY usertime DESC
			LIMIT ".$entries_to_show."
			");

	$hits = array();
	$local_bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	while ($myrow = $vbulletin->db->fetch_array($rec)) {

		if (!$hits[$myrow['linkid']]) {

			$catname_clean = htmlspecialchars_uni($myrow['catname']);
			$linkname = $local_bbcode_parser->do_parse($myrow['linkname']);

			$this_link = '<a href="'.LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$myrow['catid'].'&amp;linkid='.$myrow['linkid'].'" title="'.$catname_clean.'" target="_blank">';
			$this_item =
				vbdate($vbulletin->options['dateformat'], $myrow['usertime']).
				' '.
				vbdate($vbulletin->options['timeformat'], $myrow['usertime']).
				' '.
				$this_link.
				$linkname.
				'</a><br />';

			($hook = vBulletinHook::fetch_hook('ldm_customfields_myhits')) ? eval($hook) : false;

			$results .= $this_item;
		}

		$hits[$myrow['linkid']] = 1;

	}

	if (!count($hits)) {
		$results = $vbphrase['none'];
	}

	return $results;

}

?>