<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/**
* Fix a new set of players in the database
*
* @param	arr		New player set
* @return			Nothing
*/

function dbset_ldm_players($ldm_players) {
	global $links_defaults, $ldm_master_settings;
	global $vbulletin;

	require_once(DIR . '/includes/local_links_admininclude.php');

	$new_players = array();
	foreach ($ldm_players as $thisid=>$thisplayer) {
		if ($thisplayer['ismaster']) {
			$new_players['ldm_player_'.$thisplayer['name']] = $thisplayer;
		}
	}

	$old_players = array();
	foreach ($ldm_master_settings as $this_set) {
		if (isset($this_set[-1])) {
			if ($this_set[-1]['rowtype']=='define_mediaplayer') {
				$old_players[] = $this_set[-1];
			}
		}
	}

	$seq = locate_LDMadminrow_space(count($new_players), ADMIN_PRIVATE_START, ADMIN_PRIVATE_END);

	foreach ($old_players as $thisid=>$thisplayer) {
		$thisname = $thisplayer['settingname'];
		if (isset($new_players[$thisname])) {
			if ($new_players[$thisname]['delete']==1) {
				remove_LDMadminrow($thisname);
				unset($new_players[$thisname]);
			}
			elseif ($new_players[$thisname]==$thisplayer['setting']) {
				unset($new_players[$thisname]);
				continue;
			}
			else {
				$this_serialise = serialize($new_players[$thisname]);
				require_LDMadminrow($seq++, $thisname, $this_serialise, 'define_mediaplayer', 0, 1);
				$links_defaults[$thisname] = $this_serialise;
				unset($new_players[$thisname]);
			}
		}
	}

	if (count($new_players)) {
		foreach ($new_players as $thisname=>$thisplayer) {
			require_LDMadminrow($seq++, $thisname, serialize($new_players[$thisname]), 'define_mediaplayer', 0, 1);
		}
	}

	ldm_datastore_markdirty('ldm_admin');

}

/**
* Load local data structure from admin settings
*
* @return	arr		Player structures
*/

function load_ldm_players() {
	global $ldm_players, $links_defaults, $ldm_master_settings;

	cache_LDMadmintable();

// Get the standard players
	if (!is_array($ldm_players)) {
		$ldm_players = array();

		foreach ($ldm_master_settings as $this_set) {
			if (isset($this_set[-1])) {
				if ($this_set[-1]['rowtype']=='define_mediaplayer') {
					$ldm_players[] = unserialize($this_set[-1]['setting']);
				}
			}
		}
	}

// Give people a chance to add some more...
	($hook = vBulletinHook::fetch_hook('ldm_playme_initplayers')) ? eval($hook) : false;

	usort($ldm_players, "sort_ldm_players");

}

/**
* Add a player into the local data structure
*
* @param	arr		Player structure
* @param	int		yes/no fix player in database
* @return			Nothing
*/

function add_ldm_player($player, $fix=0) {
	global $ldm_players;

	if (!is_array($ldm_players)) {
		load_ldm_players();
	}

	foreach ($ldm_players as $id=>$thisplayer) {
		if ($ldm_players[$id]["name"]==$player["name"]) {
			return;
		}
	}

	$ldm_players[] = $player;
	usort($ldm_players, "sort_ldm_players");

	if ($fix) {
		dbset_ldm_players($ldm_players);
	}

}

/**
* Helper routine for sorting players into current priority order
*/

function sort_ldm_players($a, $b) {
	if ($a["priority"] == $b["priority"]) {
		return 0;
	}
	return ($a["priority"] < $b["priority"]) ? 1 : -1;
}

/**
* Prepare the admin Edit Players bits
*
* @return	str		Edit players bit
*/

function edit_ldm_players() {
	global $vbphrase, $stylevar;
	global $ldm_players;

	if (!is_array($ldm_players)) {
		load_ldm_players();
	}

	$playerbit = "";

	foreach ($ldm_players as $thisid=>$thisplayer) {
		$vars = "";
		foreach ($thisplayer['vars'] as $thisvar=>$thisval) {
			$vars .= $thisvar.'="'.$thisval.'", ';
		}
		eval("\$playerbit .= \"".fetch_template("links_admin_playerbit")."\";");
	}

	return $playerbit;

}

/**
* Process admin/edit players
*
* @return			Nothing
*/

function update_ldm_players() {
	global $vbulletin, $ldm_players, $vbphrase, $stylevar;

	if (!is_array($ldm_players)) {
		load_ldm_players();
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'bitfunc' => TYPE_ARRAY_STR,
		'deleteplayer' => TYPE_ARRAY_INT,
		'enabled' => TYPE_ARRAY_INT,
		'filetypes_played' => TYPE_ARRAY_STR,
		'idfunc' => TYPE_ARRAY_STR,
		'linux' => TYPE_ARRAY_INT,
		'mac' => TYPE_ARRAY_INT,
		'playerbit' => TYPE_ARRAY_STR,
		'playerheader' => TYPE_ARRAY_STR,
		'player_stream' => TYPE_ARRAY_STR,
		'priority' => TYPE_ARRAY_INT,
		'urlencode' => TYPE_ARRAY_INT,
		'vars' => TYPE_ARRAY_STR,
		'windows' => TYPE_ARRAY_INT,
	));

	$new_players = $ldm_players;

	foreach ($new_players as $thisid=>$thisplayer) {

		if ($vbulletin->GPC['deleteplayer'][$thisid]==1) {
			if ($new_players[$thisid]['canremove']) {
				$new_players[$thisid]['delete'] = 1;
				continue;
			}
		}
		$new_players[$thisid]['enabled'] = ($vbulletin->GPC['enabled'][$thisid] ? 1 : 0);
		$new_players[$thisid]['filetypes_played'] = $vbulletin->GPC['filetypes_played'][$thisid];
		$new_players[$thisid]['opsys']['Windows'] = ($vbulletin->GPC['windows'][$thisid] ? 1 : 0);
		$new_players[$thisid]['opsys']['Linux'] = ($vbulletin->GPC['linux'][$thisid] ? 1 : 0);
		$new_players[$thisid]['opsys']['Mac'] = ($vbulletin->GPC['mac'][$thisid] ? 1 : 0);
		$new_players[$thisid]['playerbit'] = $vbulletin->GPC['playerbit'][$thisid];
		$new_players[$thisid]['playerheader'] = $vbulletin->GPC['playerheader'][$thisid];
		$new_players[$thisid]['playerbit_func'] = $vbulletin->GPC['bitfunc'][$thisid];
		$new_players[$thisid]['playerid_func'] = $vbulletin->GPC['idfunc'][$thisid];
		$new_players[$thisid]['player_stream'] = $vbulletin->GPC['player_stream'][$thisid];
		$new_players[$thisid]['priority'] = $vbulletin->GPC['priority'][$thisid];
		$new_players[$thisid]['urlencode'] = $vbulletin->GPC['urlencode'][$thisid];

		$vars = $vbulletin->GPC['vars'][$thisid];
		preg_match_all("#\s*([^=]+)\s*=\s*\"([^\"]*)\"\s*,#", $vars, $matches, PREG_SET_ORDER);
		$nvars = array();
		foreach ($matches as $m) {
			$nvars[$m[1]] = $m[2];
		}
		$new_players[$thisid]['vars'] = $nvars;
	}

	dbset_ldm_players($new_players);

}

/**
* Select an appropriate player for given item.
*
* @param	int		Linkid
* @param	str		Linkurl
* @param	str		Link filetype
* @param	str		If set, force select that player
* @return	str		Playerid
*/

function get_ldm_playerid($linkid, $linkurl, $filetype, $player="") {
	global $ldm_players, $LDM_environment, $links_defaults;

	load_ldm_players();

	unset($playerid);

	($hook = vBulletinHook::fetch_hook('ldm_playerid_begin')) ? eval($hook) : false;

	if (isset($playerid)) {
		return $playerid;
	}

	$playerid = -1;
	foreach ($ldm_players as $id=>$thisplayer) {

		$thisplayer_name = (isset($thisplayer['name']) ? $thisplayer['name'] : "");
		if ($player) {
			if ($thisplayer_name==$player) {  // explicit choice of player over-rides all controls
				$playerid = $id;
				break;
			}
			else {
				continue;
			}
		}

		$thisplayer_enabled = isset($thisplayer['enabled']) ? $thisplayer['enabled'] : "";
		if (!$thisplayer_enabled) {
			continue;
		}

		if (!$thisplayer['opsys'][$LDM_environment['user_os']]) {
			continue;
		}

// can only handle local files as urls if local_file_root is off
		$howtostream = (isset($thisplayer['player_stream']) ? $thisplayer['player_stream'] : "url");
		if ($howtostream=="stream" and $links_defaults['force_redirect']>0) {
			$howtostream = "url";
		}
		if ($howtostream!='stream' and $links_defaults['local_file_root']) {
			$urlInfo = ldm_parse_url($linkurl);
			if (!$urlInfo['host']) {
				continue;
			}
		}

// id function takes precedence over filetype
		$thisplayer_idfunc = isset($thisplayer['playerid_func']) ? $thisplayer['playerid_func'] : "";
		if (function_exists($thisplayer_idfunc)) {
			$playerid = $thisplayer_idfunc($id, $linkid, $linkurl, $filetype);
		}

		if ($playerid<0) {
			$link_known_mimetype = ldm_known_filetype($filetype);
			$thisplayer_filetype = isset($thisplayer['filetypes_played']) ? $thisplayer['filetypes_played'] : "";
			if (in_array($filetype, explode(',', str_replace(" ", "", $thisplayer_filetype))) and $link_known_mimetype) {
				$playerid = $id;
				break;
			}
		}

	}

	return $playerid;
}

/**
* Build pre-configured player bit
*
* @param	int		linkid
* @param	int		catid
* @param	int		if not null, adds entityid onto streaming script
* @param	str		linkurl
* @param	str		linkimg
* @param	str		if not null, forces selection of that player regardless of control settings
* @return	str		playerbit
*/

function get_ldm_playerbit($linkid, $catid, $entityid, $linkurl, $linkimg, $player) {
	global $ldm_players, $ldm_protocol_schemes;
	global $vbulletin;
	global $STREAM_SCRIPT, $RESIZE_SCRIPT;
	global $links_defaults, $links_permissions;

	load_ldm_players();

	$urlInfo = ldm_parse_url($linkurl);
	$imgInfo = ldm_parse_url($linkimg);
	$player_filetype = strtolower(file_extension($urlInfo['path']));
	$playerid = get_ldm_playerid($linkid, $linkurl, $player_filetype, $player);

	if (isset($ldm_players[$playerid])) {
		$thisplayer = $ldm_players[$playerid];
	}
	else {
		return "";
	}

// If a playerbit function is specified, call it and return the result
	$thisplayer_bitfunc = (isset($thisplayer['playerbit_func']) ? $thisplayer['playerbit_func'] : "");
	if (function_exists($thisplayer_bitfunc)) {
		$playerbit = $thisplayer_bitfunc($playerid, $linkid, $linkurl);
		if ($playerbit) {
			return $playerbit;
		}
	}

// Set up required environment
	$thisplayer_vars = (isset($thisplayer['vars']) ? $thisplayer['vars'] : "");
	foreach ($thisplayer["vars"] as $thisvar=>$thisval) {
		${$thisvar} = $thisval;
	}

// Over-ride instruction to stream if force_redirect is set to non-zero value
	$howtostream = (isset($thisplayer['player_stream']) ? $thisplayer['player_stream'] : "url");
	if ($howtostream=="stream") {
		if (ldm_lookup_setting($catid, 'force_redirect')>0) {
			$howtostream = "url";
		}
	}

// *** Handover from 2.2.6, which should be re-done
// Does the protocol force a particular method of grabbing the bit stream?
	if (($urlInfo['scheme'] and $ldm_protocol_schemes[$urlInfo['scheme']]["musicbox"]==2)) {
		$howtostream = "url";
	}
// *** End of handover from 2.2.6, which should be re-done

	switch ($howtostream) {
	case "url":
		$player_stream = $linkurl;
		$player_image = $linkimg;
		break;
	case "fullurl":
		$fullurl = ($urlInfo['host'] ? $linkurl : ldm_make_filename("http://".$_SERVER['HTTP_HOST'], $linkurl));
		$player_stream = $fullurl;
		$fullimage = ($imgInfo['host'] ? $linkimg : ldm_make_filename("http://".$_SERVER['HTTP_HOST'], $linkimg));
		$player_image = $fullimage;
		break;
	default:
		$token = ldm_encrypt_authority($linkid, $catid);
		if ($token) {
			$token = "&token=".$token;
		}
		$player_stream = ldm_make_filename($vbulletin->options['bburl'],$STREAM_SCRIPT.".php").
			"?".$vbulletin->session->vars['sessionurl_js']."action=stream&linkid=".$linkid."&catid=".$catid.
			($entityid ? "&entityid=".$entityid : '').$token;
		$fullimage = ($imgInfo['host'] ? $linkimg : ldm_make_filename("http://".$_SERVER['HTTP_HOST'], $linkimg));
		$player_image = $fullimage;
	}

	$thisplayer_urlencode = (isset($thisplayer['urlencode']) ? $thisplayer['urlencode'] : "");
	if ($thisplayer_urlencode) {
		$player_stream = urlencode($player_stream);
		$player_image = urlencode($player_image);
	}

	$player_autostart = "true";

	($hook = vBulletinHook::fetch_hook('ldm_playme_preplay')) ? eval($hook) : false;

	if (isset($thisplayer['playerbit'])) {
		eval("\$playerbit_player = \"".fetch_template($thisplayer['playerbit'])."\";");
		return $playerbit_player;
	}
	else {
		return "";
	}

}

/**
* Returns appropriate player header include for use within LDM
*
* @param	int		linkid
* @param	int		catid
* @param	str		linkurl
* @param	str		if set, forces selection of that player regardless of control settings
* @return	str		Player header
*/

function get_ldm_playerheader($linkid, $catid, $linkurl, $player="") {
	global $ldm_players;
	global $vbulletin;

	load_ldm_players();

	$urlInfo = ldm_parse_url($linkurl);
	$fullurl = ($urlInfo['host'] ? $linkurl : ldm_make_filename("http://".$_SERVER['HTTP_HOST'], $linkurl));
	$player_filetype = strtolower(file_extension($urlInfo['path']));
	$playerid = get_ldm_playerid($linkid, $linkurl, $player_filetype, $player);

	if (isset($ldm_players[$playerid])) {
		$thisplayer = $ldm_players[$playerid];
	}
	else {
		return "";
	}

// If a player_header function is specified, call it
	$thisplayer_headfunc = (isset($thisplayer['playerhead_func']) ? $thisplayer['playerhead_func'] : "");
	if ($thisplayer_headfunc) {
		$playerbit_header = $thisplayer_headfunc($playerid, $linkid, $linkurl);
		if ($playerbit_header) {
			return $playerbit_header;
		}
	}

// Otherwise, use the header template if specified
	if (isset($thisplayer['playerheader'])) {
		eval("\$playerbit_header = \"".fetch_template($thisplayer['playerheader'])."\";");
		return $playerbit_header;
	}
	else {
		return "";
	}

}

?>