<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/**
* Build the update settings form for specified category
*
* @param	&array	On return, contains settings bit
* @param	&array	On return, contains <select> bit for quick jump
* @param	int		Category
* @param	str		Category parent list
* @param	int		Show all settings/only over-ridable settings
* @param	int		Include an update button in the displayed form
* @return	bool	True
*/

function ldm_build_settings(&$settings, &$settingjump, $thiscatid, $parentlist, $showall=0, $includeupdate=0) {
	global $vbulletin, $stylevar, $vbphrase, $jumpforumbits, $forumjump, $vbcollapse;
	global $ldm_linkbitcache, $ldm_catbitcache, $linkscat, $ldm_usergroup_cache;
	global $DEFAULT_FORUMID;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;
	global $UNKNOWN, $INHERIT, $CUSTOM, $STANDARD, $BASE_CAT;

	$cat_choice = explode(',', $thiscatid.','.$parentlist);

	$doupdate = ($includeupdate ? "dosettings" : "");
	$query = "SELECT *
		FROM ".THIS_TABLE."linksadmin
		WHERE sequence<=".ADMIN_SETTINGS_END."
		" . (!$showall ? "AND canoverride='1'" : "") ."
		ORDER BY sequence
		";
	$asb = $vbulletin->db->query_read($query);

	$open = 0;
	while ($admin_settings = $vbulletin->db->fetch_array($asb)) {
		if ($admin_settings["rowtype"]=="title") {
			$open = $admin_settings["sequence"];
		}
		if (!$open) {
			continue;
		}
		if (in_array($admin_settings["catid"], $cat_choice)) {
			$master_settings[$admin_settings["settingname"]][$admin_settings["catid"]] = $admin_settings;
		}
		if ($thiscatid==$BASE_CAT and $admin_settings["catid"]>0) {
			$master_settings[$admin_settings["settingname"]]['catconfig'][] = $admin_settings["catid"];
		}
		if ($admin_settings["rowtype"]=="close") {
			$open = 0;
		}
	}

	$open = 0;
	$settings = "";
	$settingtitles = array();

	foreach ($master_settings as $this_set) {

		unset($admin_settings);
		$adminboxstyle = $UNKNOWN;
		$revert = "";

		foreach ($cat_choice as $catid) {
			if (isset($this_set[$catid])) {
				$admin_settings = $this_set[$catid];
				if ($thiscatid==$BASE_CAT) {
					$adminboxstyle = $STANDARD;
					if ($admin_settings["canoverride"]) {
						if (isset($this_set['catconfig'])) {
							$configs = array();
    						$adminboxstyle = $CUSTOM;
							foreach ($this_set['catconfig'] as $ts) {
								$configs[] = "<a href='".$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=editcat&amp;catid=".
									$ts."' title='".$vbphrase['ll_editcat'].
									' '.$linkscat[$ts]['catname_clean']."' target='_blank'>" .$ts. "</a>";
							}
							sort($configs);
							$revert = construct_phrase($vbphrase['ll_admin_can_customise'],implode(', ', $configs)).
								'<br /><input type="checkbox" name="'.$admin_settings["settingname"].'_revert" value="1" /> '.
								$vbphrase['ll_revert_cats'];
						}
						else {
							$revert = construct_phrase($vbphrase['ll_admin_can_customise'],$vbphrase['ll_none']);
						}
					}
				}
				elseif ($catid==$thiscatid) {
					$adminboxstyle = $CUSTOM;
					$revert = $vbphrase['ll_customised'].
						'<br /><input type="checkbox" name="'.$admin_settings["settingname"].'_revert" value="1" /> '.
						$vbphrase['ll_revert'];
				}
				elseif ($catid<0) {
					$adminboxstyle = $STANDARD;
				}
				else {
					$adminboxstyle = $INHERIT;
					$revert = $vbphrase['ll_inherit'];
				}
				break;
			}
		}

		if (!isset($admin_settings)) { // should not happen
			ldm_general_failure($vbphrase['ll_error_critical_settings'].' '.$thiscatid.($parentlist ? ", ".$parentlist : ""));
			exit;
		}

		if ($admin_settings["rowtype"] == "title") {
			if ($open) {
				eval("\$settings .= \"".fetch_template('links_admin_setting_foot')."\";");
			}
			$title = (isset($vbphrase[$admin_settings["setting"]]) ? $vbphrase[$admin_settings["setting"]] : $admin_settings["setting"]);
			$settingname = $admin_settings["settingname"];
			$settingcode = $admin_settings["setting"];
			$settingcode = preg_replace("#[^a-z0-9_]#i", "", $settingcode);
			$settingtitles[$title] = '<option value="#'.$settingcode.'" >'.$title.'</option>';
			$a_set = "adminset_".$settingname;
			$extra_initiated = 0;
			if ($admin_settings["sequence"]>=ADMIN_ADDON_START and $admin_settings["sequence"]<=ADMIN_ADDON_END) {
				if (ldm_extra_has_loaded($admin_settings["settingname"])) {
					$extra_initiated = 1;
				}
				else {
					$extra_initiated = -1;
				}
			}
			eval("\$settings .= \"".fetch_template('links_admin_setting_title')."\";");
			$open = $admin_settings["sequence"];
			continue;
		}

		if ($admin_settings["rowtype"] == "close") {
			if ($open) {
				if ($open>=ADMIN_ADDON_START and $open<=ADMIN_ADDON_END and $thiscatid==$BASE_CAT) {
					$addons .= '<span class="smallfont">
						<input type="hidden" name="remove_start[]" value="'.$open.'" />
						<input type="hidden" name="remove_end[]" value="'.$admin_settings["sequence"].'" />
						<input type="checkbox" name="remove_do[]" value="'.$open.'" />'.$vbphrase['ll_admin_delete_addonset'].
						'</span>';
				}
				eval("\$settings .= \"".fetch_template('links_admin_setting_foot')."\";");
				$addons = "";
			}
			$open = 0;
			continue;
		}

		if ($admin_settings["rowtype"] == "break") {
			if ($open) {
//				$dobreak = 1;
				eval("\$settings .= \"".fetch_template('links_admin_setting_break')."\";");
//				$dobreak = 0;
			}
//			$open = 0;
			continue;
		}

		if (!$open) {
			continue;
		}

		if (!$admin_settings["rowtitle"]) {
			$description = $vbphrase['ll_perms_'.$admin_settings['settingname']];
		}
		else {
			$description = isset($vbphrase[$admin_settings["rowtitle"]]) ? $vbphrase[$admin_settings["rowtitle"]] : $admin_settings["rowtitle"];
		}

		eval("\$settings .= \"".fetch_template('links_admin_onesetting_start')."\";");

		switch ($admin_settings["rowtype"]) {

		case "forum":

			$setting = preg_replace(
			    array("/class=\".*?\"/", "/selected=\"selected\"/",),
			    array("", "",),
			    $jumpforumbits);

			$setting = '<div class="smallfont">'.
				'<select class="select" name="' . $admin_settings["settingname"] . '[]" style="width:200px">'.
				'<option value="'.$DEFAULT_FORUMID.'" >' . $vbphrase['ll_none'] . '</option>'.
				$setting .
				'</select><br />'.
				'<input type="checkbox" name="'.$admin_settings["settingname"].'_reapply" checked="checked" />' . $vbphrase['ll_forumdefault_reapply'] .
				'<input type="hidden" name="'.$admin_settings["settingname"].'_old" value="'.$admin_settings["setting"].'" />' .
				'</div>'
				;

			$local_select = $admin_settings["setting"]>0 ? $admin_settings["setting"] : $DEFAULT_FORUMID;
			$setting = preg_replace("/option (value=\"".$local_select."\")/", "option selected=\"selected\" $1", $setting);
			break;

		case "forumselect":

			$setting = preg_replace(
			    array("/class=\".*?\"/", "/selected=\"selected\"/",),
			    array("", "",),
			    $jumpforumbits);

			$setting = '<div class="smallfont">'.
				'<select class="select" name="' . $admin_settings["settingname"] . '[]" style="width:200px">'.
				'<option value="'.$DEFAULT_FORUMID.'" >' . $vbphrase['ll_none'] . '</option>'.
				$setting .
				'</select>'.
				'</div>';

			$local_select = $admin_settings["setting"]>0 ? $admin_settings["setting"] : $DEFAULT_FORUMID;
			$setting = preg_replace("/option (value=\" *".$local_select." *\")/", "option selected=\"selected\" $1", $setting);

			break;

		case "category":

			$setting = ldm_construct_category_list(array($admin_settings["setting"]), 'links_addnewlink_catselect_one', 1, $admin_settings["settingname"].'[]', "catid", 0, "", 1);
			break;

		case "category_selection":

			$tcs = $admin_settings["setting"]=="links_addnewlink_catinput" ? '' : 'checked="checked"';
			$tci = $admin_settings["setting"]=="links_addnewlink_catinput" ? 'checked="checked"' : '';
			$setting = '<table width="250"><tr><td align="left"><span class="smallfont">' .
				'<input type="radio" name="template_category_selection[]" value="links_addnewlink_catselect" '.$tcs.' /> links_addnewlink_catselect<br />' .
				'<input type="radio" name="template_category_selection[]" value="links_addnewlink_catinput" '.$tci.' /> links_addnewlink_catinput' .
				'</span></td></tr></table>';
			break;

		case "catbit":

			$catbit = ldm_construct_bitselect_list($ldm_catbitcache, $admin_settings["setting"], $admin_settings["settingname"]."[]");
			$setting = '<table><tr><td align="left">' . $catbit . '</td></tr></table>';
			break;

		case "linkbit":

			$linkbit = ldm_construct_bitselect_list($ldm_linkbitcache, $admin_settings["setting"], $admin_settings["settingname"]."[]");
			$setting = '<table><tr><td align="left">' . $linkbit . '</td></tr></table>';
			break;

		case "mainbit_placement":
			$placements = array('leftcol', 'rightcol', 'precat', 'postcat', 'prefeat', 'postfeat', 'prelink', 'postlink', 'closing', );
			$setting =
					'<div class="smallfont">' .
					'<select class="select" name="'.$admin_settings["settingname"].'[]" style="width:200px">'
					;
			foreach ($placements as $placement) {
				$setting .= "<option value='".$placement."' ". ($placement==$admin_settings[setting] ? "selected='selected'" : "" ) .">".
					$vbphrase['ll_placement_'.$placement].
					"</option>";
			}
			$setting .=
					'</select>' .
					'</div>'
					;
			break;

		case "profile":

			$setting = '<table width="250"><tr><td align="left"><span class="smallfont">';
			$fields = explode(',', $admin_settings["setting"]);

			$bsb = $vbulletin->db->query_read("
				SELECT *
				FROM ".TABLE_PREFIX."phrase
				WHERE fieldname = 'cprofilefield'
				AND varname LIKE 'field%_title'
			");
			while ($myrow=$vbulletin->db->fetch_array($bsb)) {
				if ($id = preg_replace("/field(\d*)_title/", "$1", $myrow['varname'])) {
					$profilefieldname[$id] = $myrow['text'];
				}
			}
			$bsb = $vbulletin->db->query_read("
				SELECT *
				FROM ".TABLE_PREFIX."profilefield
			");
			while ($myrow=$vbulletin->db->fetch_array($bsb)) {
				$chk = (in_array($myrow['profilefieldid'], $fields) ? 'checked="checked"' : '');
				$setting .= '<input type="checkbox" name="'.$admin_settings["settingname"].'[]" value="'.$myrow['profilefieldid'].'" '.$chk.' /> '.$profilefieldname[$myrow['profilefieldid']].'<br />';
			}

			$setting .= '<input type="hidden" name="'.$admin_settings["settingname"].'[]" value="-1" /> ';
			$setting .= '</span></td></tr></table>';
			break;

		case "sortcat":

			$sortvar = $admin_settings["settingname"]."[]";
			$sortset = (trim($admin_settings["setting"]) ? $admin_settings["setting"] : "");
			$sortdef = 0;
			$sortwidth = "300";
			$sortcats = 1;
			eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");
			$setting = '<table><tr><td align="left">' . $sortorderbit . '</td></tr></table>';
			break;

		case "sort":

			$sortvar = $admin_settings["settingname"]."[]";
			$sortset = (trim($admin_settings["setting"]) ? $admin_settings["setting"] : "");
			$sortdef = 0;
			$sortwidth = "300";
			$sortcats = 0;
			eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");
			$setting = '<table><tr><td align="left">' . $sortorderbit . '</td></tr></table>';
			break;

		case "style":

			$stylebit = ldm_construct_style_list($admin_settings["setting"], $admin_settings["settingname"]."[]");
			$setting = '<table><tr><td align="left">' . $stylebit . '</td></tr></table>';
			break;

		case "textbox":

			$setting = '<textarea class="bginput" name="' . $admin_settings["settingname"] .
				'[]" rows="4" cols="40">'.$admin_settings[setting].'</textarea>';
			break;

		case "usergroup_text":

			$setting = "<table>";
			cache_LDMusergroup();
			$array = unserialize($admin_settings['setting']);
			foreach ($ldm_usergroup_cache as $usergroupid => $title) {
				$value = $array[$usergroupid];
				if (!$value) $value="";
				$setting .= '<tr>'.
					'<td width="40%"><span class="smallfont">'.$title.'</span></td>'.
					'<td><input type="text" name="'.$admin_settings['settingname'].'['.$usergroupid.']" value="'.$value.'" /></td>'.
					'</tr>';
			}
			$setting .= "</table>";
			break;

		case "usergroup_setting":

			$setting = "";
			cache_LDMusergroup();
			$array = preg_split("/[\s,]+/", $admin_settings['setting']);
			foreach ($ldm_usergroup_cache as $usergroupid => $title) {
				if (in_array($usergroupid, $array)) {
					$checked = 'checked="checked"';
				}
				else {
					$checked = '';
				}
				eval("\$setting .= \"".fetch_template('links_admin_oneperm')."\";");
			}
			break;

		case "username":
		case "username_one":

			$sn = $admin_settings["settingname"];
			$setting = '
	<table><tr><td align="left">
	<div id="ldmuser'.$sn.'">
	<input type="text" class="bginput" id="ldmuser'.$sn.'_txt" name="'.$admin_settings["settingname"].'[]" style="width:200px" value="'.$admin_settings["setting"].'" />
	</div>

	<div class="vbmenu_popup" id="ldmuser'.$sn.'_menu" style="display:none; z-index:50"></div>
	<script type="text/javascript" src="clientscript/vbulletin_ajax_namesugg.js"></script>
	<script type="text/javascript">
	<!--
	vbmenu_register(\'ldmuser'.$sn.'\', true);
	recip_sugg'.$sn.' = new vB_AJAX_NameSuggest(\'recip_sugg'.$sn.'\', \'ldmuser'.$sn.'_txt\', \'ldmuser'.$sn.'\');
	recip_sugg'.$sn.($admin_settings["rowtype"]=="username" ? '.allow_multiple = true;' : '.allow_multiple = false;').'
	//-->
	</script>
	</td></tr>
	</table>
						';
			break;

		case "yesno":

			$ly  = $admin_settings['setting'] ? 'checked="checked"' : '';
			$ln  = $admin_settings['setting'] ? '' : 'checked="checked"';
// If a right-to-left language, place boxes vertically, else horizontally
			if ($stylevar['textdirection']=='rtl') {
				$setting = '<div class="smallfont"><input type="radio" name="' . $admin_settings['settingname'] .
					'[]" value="1" '.$ly.' />&nbsp;' . $vbphrase['ll_yes'] . '</div><div class="smallfont">' .
					'<input type="radio" name="' . $admin_settings['settingname'] . '[]" value="0" ' .
					$ln . ' />&nbsp;' . $vbphrase['ll_no'] . '</div>';
			}
			else {
				$setting = '<span class="smallfont"><input type="radio" name="' . $admin_settings['settingname'] .
					'[]" value="1" '.$ly.' />&nbsp;' . $vbphrase['ll_yes'] . '&nbsp;' .
					'<input type="radio" name="' . $admin_settings['settingname'] . '[]" value="0" ' .
					$ln . ' />&nbsp;' . $vbphrase['ll_no'] . '</span>';
			}
			break;

		case "special":
// Settings requiring individual handling
			switch ($admin_settings["settingname"]) {

			case "autocreate_prefix": // Thread prefix - depends on autocreate_forum
				$prefix_options = "";
				if ($admin_settings["settingname"]=="autocreate_prefix") {
					$local_forum = ldm_lookup_setting($thiscatid, 'autocreate_forum');
					if (ldm_forumid_is_valid($local_forum, false)) {
						require_once(DIR . '/includes/functions_prefix.php');
						$prefix_options = fetch_prefix_html($local_forum, $admin_settings["setting"]);
					}
				}
				$setting = '<div class="smallfont">'.
					'<select class="select" name="' . $admin_settings["settingname"] . '[]" style="width:200px">'.
					'<option value="" >' . $vbphrase['ll_none'] . '</option>'.
					$prefix_options .
					'</select>' .
					'</div>';
				break;

			default:
				$setting = '<input class="bginput" type="text" name="' . $admin_settings['settingname'] .
					'[]" value="'.htmlspecialchars($admin_settings['setting']).'" style="width:200px" />';
			}

			break;

		default:

			$setting = '<input class="bginput" type="text" name="' . $admin_settings['settingname'] .
				'[]" value="'.htmlspecialchars($admin_settings['setting']).'" style="width:200px" />';
		}

		if ($admin_settings["rowtype"]=="usergroup_setting") {
			$settings .= $setting;
			eval("\$settings .= \"".fetch_template('links_admin_oneperm_end')."\";");
		}
		else {
			eval("\$settings .= \"".fetch_template('links_admin_onesetting')."\";");
			eval("\$settings .= \"".fetch_template('links_admin_onesetting_end')."\";");
		}
	}

	if ($open) {
		if ($open>=ADMIN_ADDON_START and $open<=ADMIN_ADDON_END and $thiscatid==$BASE_CAT) {
			$addons .= '<span class="smallfont">
				<input type="hidden" name="remove_start[]" value="'.$open.'" />
				<input type="hidden" name="remove_end[]" value="'.$admin_settings["sequence"].'" />
				<input type="checkbox" name="remove_do[]" value="'.$open.'" />'.$vbphrase['ll_admin_delete_addonset'].
				'</span>';
		}
		eval("\$settings .= \"".fetch_template('links_admin_setting_foot')."\";");
		$addons = "";
	}
	$open = 0;

	uksort($settingtitles, create_function('$a,$b', 'return strnatcasecmp($a, $b);'));

	$settingtitles = implode(' ', $settingtitles);
	eval("\$settingjump = \"".fetch_template('links_admin_setting_jump')."\";");

	return 1;

}

/**
* Update settings for given category
*
* @param	int		Category parent
* @param	array	New settings array
* @param	&array	Returns array of errors
* @return	bool	Success/failure
*/

function ldm_update_settings($catid, $settings, &$errors) {
	global $vbulletin;
	global $ldm_master_settings, $links_defaults, $LDM_environment;
	global $LINK_OK;

	$cache_settings = cache_LDMsettings($catid);

	$errors = array();
	$updates = array();
	$reverts = array();
	$retest = array();

	$new_local_file_root = "";
	$new_local_file_root_prefix = "";

// Check if local_file_root/prefix are changing since other settings need to know this
	if (isset($settings['local_file_root'])) {
		$new_local_file_root = trim(implode(',', $settings['local_file_root']));
		$retest['upload_dir'] = 1;
	}
	if (isset($settings['local_file_root_prefix'])) {
		$new_local_file_root_prefix = trim(implode(',', $settings['local_file_root_prefix']));
		$retest['upload_dir'] = 1;
	}

	foreach ($cache_settings as $settingname=>$currentvalue) {

		if (!isset($settings[$settingname])) continue;
		if (!is_array($settings[$settingname])) continue;

		if ($settings[$settingname."_revert"]) {
			$reverts[$settingname] = 1;
			if ($settingname == "autocreate_username") {
				$reverts["autocreate_userid"] = 1;
			}
			if ($settingname == "featured_user_favs") {
				$reverts["featured_userid_favs"] = 1;
			}
			if ($settingname == "sync_username") {
				$reverts["sync_userid"] = 1;
			}
			if ($catid>0) { // reverts take priority over new settings
				continue;
			}
		}

		switch ($ldm_master_settings[$settingname][-1]['rowtype']) {
		case "usergroup_text":
			$newsetting = serialize($settings[$settingname]);
			break;
		default:
			$newsetting = trim(implode(',', $settings[$settingname]));
			break;
		}
		if ($newsetting==$currentvalue and !$retest[$settingname]) continue;

		$error = 0;
		$errormessage = "";

		switch ($ldm_master_settings[$settingname][-1]['rowtype']) {

		case "forum":
		case "forumselect":
			if (!ldm_forumid_is_valid($newsetting)) {
				$error = 1;
				$errormessage = "Invalid forumid";
			}
			break;

		case "mainbit_placement":
			if (!in_array($newsetting, array('leftcol', 'rightcol', 'precat', 'postcat', 'prefeat', 'postfeat', 'prelink', 'postlink', 'closing', ))) {
				$error = 1;
				$errormessage = "Invalid placement";
			}
			break;

		case "textbox":
			$newsetting = preg_replace("/ *\\r/", "", $newsetting);
			break;

		case "username":
			$newsetting = preg_replace("/\s+;\s+/", ";", $newsetting);
			break;

		case "yesno":
			if ($newsetting) {
				$newsetting = 1;
			}
			else {
				$newsetting = 0;
			}
			break;

		case "icon":
			if ($newsetting and $newsetting != "0") {
				$parseicon = parse_url($newsetting);
				if (!$parseicon['host']) {
					$thisicon = ldm_make_filename_nonrel($vbulletin->options['bburl'],$newsetting);
				}
				else {
					$thisicon = $newsetting;
				}
				$thisicon_status = ldm_check_url($thisicon);
				if ($thisicon_status!=$LINK_OK) {
					$error = 1;
					$errormessage = "Cannot find icon '".$thisicon."' - specify relative to forum directory or use full url";
				}
				else {
					$newsetting = $thisicon;
				}
			}
			break;

		}

		switch ($settingname) {

		case "force_redirect":
		case "protected_link":
		case "show_hit_parade":
			if ($newsetting != "0" and $newsetting != "1" and $newsetting != "2") {
				$error = 1;
				$errormessage = "Select 0/1/2 only";
			}
			break;

		case "default_search_all":
			if ($newsetting != "1" and $newsetting != "2" and $newsetting != "3") {
				$error = 1;
				$errormessage = "Select 1/2/3 only";
			}
			break;

		case "autocreate_username":
			if (!$newsetting) {
				$newsetting = "";
				$updates["autocreate_userid"]['setting'] = 0;
				break;
			}
			$row = $vbulletin->db->query_first("
				SELECT userid, username
				FROM ".TABLE_PREFIX."user AS user
				WHERE username = '".$vbulletin->db->escape_string($newsetting)."'
				LIMIT 1
				");
			if (isset($row['userid'])) {
				$newsetting = $row['username'];
				$updates["autocreate_userid"]['setting'] = $row['userid'];
			}
			else {
				$error = 1;
				$errormessage = "User $newsetting not recognised";
			}
			break;

		case "featured_user_favs":
			if (!$newsetting) {
				$newsetting = "";
				$updates["featured_userid_favs"]['setting'] = serialize(array());
				break;
			}
			$feat_users = explode(';', $newsetting);
			foreach ($feat_users as $k=>$v) {
				if (!trim($v)) {
					unset($feat_users[$k]);
				}
			}
			$feat_userids = ldm_lookup_userids($feat_users);
			$feat_user_errors = array();
			foreach ($feat_users as $k=>$v) {
				if (!$feat_userids[$k]) {
					$feat_user_errors[] = $v;
				}
			}
			if (count($feat_user_errors)) {
				$error = 1;
				$errormessage = "Users ".implode(', ', $feat_user_errors)." not recognised";
			}
			else {
				$newsetting = implode(' ; ', $feat_users).'; ';
				$updates["featured_userid_favs"]['setting'] = serialize($feat_userids);
			}
			break;

		case "featured_usergroupid_favs":
			if (!$newsetting) {
				$newsetting = "";
				break;
			}
			$feat_usergroupids = explode(',', $newsetting);
			foreach ($feat_usergroupids as $k=>$v) {
				if (trim($v)==="") {
					unset($feat_usergroupids[$k]);
				}
				elseif (!ldm_is_valid_int($v, 1)) {
					$error = 1;
					$errormessage = "Usergroupids must have positive integer values";
				}
				else {
					$feat_usergroupids[$k] = intval($v);
				}
			}
			if (!$error) {
				$newsetting = implode(',', $feat_usergroupids);
			}
			break;

		case "sync_username":
			if (!$newsetting) {
				$newsetting = "";
				$updates["sync_userid"]['setting'] = 0;
				break;
			}
			$row = $vbulletin->db->query_first("
				SELECT userid, username
				FROM ".TABLE_PREFIX."user AS user
				WHERE username = '".$vbulletin->db->escape_string($newsetting)."'
				LIMIT 1
				");
			if (isset($row['userid'])) {
				$newsetting = $row['username'];
				$updates["sync_userid"]['setting'] = $row['userid'];
			}
			else {
				$error = 1;
				$errormessage = "User $newsetting not recognised";
			}
			break;

		case "links_expiry_days":
			if (!ldm_is_valid_int($newsetting)) {
				$error = 1;
				$errormessage = "Select integer value only";
			}
			else {
				$newsetting = intval($newsetting);
			}
			break;

		case "link_imagesize":
			if (strlen(trim($newsetting))!=0) {
				if (!ldm_is_valid_int($newsetting, 0)) {
					$error = 1;
					$errormessage = "Select blank/0/positive value only";
				}
				else {
					$newsetting = intval($newsetting);
				}
			}
			else {
				$newsetting = "";
			}
			break;

		case "cat_cols_display":
		case "cat_depth_indent":
		case "cat_sub_display":
		case "cat_sub_display_limit":
		case "cat_sub_display_perline":
		case "days_seen_on_portal":
		case "default_cat_dseq":
		case "default_link_dseq":
		case "dropdown_comment_and_rate":
		case "dropdown_rows_comment_and_rate":
		case "dropdown_width_comment_and_rate":
		case "encrypt_lock_expiry":
		case "featured_sites":
		case "inline_comment_and_rate":
		case "inline_rows_comment_and_rate":
		case "inline_width_comment_and_rate":
		case "length_shortdesc":
		case "link_cols_display":
		case "link_imagemagsize":
		case "link_review_freq":
		case "links_per_page":
		case "links_seen_on_portal":
		case "musicbox_files_seen":
		case "perpage_downloadtable":
		case "prune_downloadtable":
		case "search_like_favwt":
		case "search_like_hitwt":
		case "search_like_keywt":
		case "search_like_num":
		case "starred_entries_pastperiods":
		case "sync_depth":
		case "sync_freq":
		case "sync_maxcpu_allowed":
		case "sync_maxcpu_allowed_manual":
		case "timeout_hit_allow":
		case "timeout_hit_recording":
		case "word_wrap":
			if (!$newsetting) {
				$newsetting = 0;
			}
			if (!ldm_is_valid_int($newsetting, 0)) {
				$error = 1;
				$errormessage = "Select 0/positive value only";
			}
			break;

		case "cat_depth_display":
		case "entity_perrow":
		case "musicbox_standalone_height":
		case "musicbox_standalone_width":
		case "musicbox_width":
		case "starred_entries_perpast":
			if (!ldm_is_valid_int($newsetting, 1)) {
				$error = 1;
				$errormessage = "Select positive value only";
			}
			break;

		case "min_textlength":
		case "max_textlength":
		case "min_commentlength":
		case "max_commentlength":
			if (!ldm_is_valid_int($newsetting, 0, 65536)) {
				$error = 1;
				$errormessage = "Select value in range 0-65536";
			}
			break;

		case "starred_entries_gather":
			if (!ldm_is_valid_int($newsetting, -1, 365)) {
				$error = 1;
				$errormessage = "Select value in range 1-365 (days) or 0 (monthly) or -1 (yearly)";
			}
			break;

		case "featured_linkbit":
		case "search_catbit":
		case "template_category_selection":
		case "template_altbit":
		case "template_catbit":
		case "template_linkbit":
			if (!preg_match("/^\w+$/", $newsetting)) {
				$error = 1;
				$errormessage = "Not a valid template choice";
			}
			break;

		case "encrypt_lock_userid":
			if (!preg_match("/^[\d\, ]+|USER$/i", $newsetting)) {
				$error = 1;
				$errormessage = "Not a valid IP address mask choice";
			}
			break;

		case "encrypt_lock_userip":
			if (!preg_match("/^[\d\.]+|IPADDRESS$/i", $newsetting)) {
				$error = 1;
				$errormessage = "Not a valid IP address mask choice";
			}
			break;

		case "cat_default_sort_order":
		case "default_sort_order":
			if (!preg_match("/^(N|H|D|R|30|7|1)$/i", $newsetting)) {
				$error = 1;
				$errormessage = "Not a valid sort order choice";
			}
			break;

		case "mod_rewrite":
			if ($newsetting != '') {
				$file = ldm_cleanto_fopen($newsetting);
				if ($fp = @fopen($file, "rb")) {
					fclose($fp);
				}
				else {
					$error = 1;
					$errormessage = $file." not found";
				}
			}
			break;

		case "file_icons_dir":
			if ($newsetting != '') {
				$newsetting = str_replace(DIRECTORY_SEPARATOR, "/", $newsetting);
				if (substr($newsetting, 0, 1) == '/') {
					$newsetting = substr($newsetting, 1);
				}
				if (substr($newsetting,-1, 1) != '/') {
					$newsetting .= '/';
				}
				$settings[$settingname] = array($newsetting);
				$can_access = ldm_can_accessdir($newsetting, 0);
				if (!$can_access) {
					$error = 1;
					$errormessage = "Cannot find/read directory ".$newsetting;
				}
			}
			break;

		case "thumbs_dir":
		case "upload_dir":
			if (preg_match("#://#", $newsetting)) {
				$error = 1;
				$errormessage = "Setting must point to a local directory, not a full url";
				break;
			}
			if ($newsetting != '') {
				$newsetting = str_replace(DIRECTORY_SEPARATOR, "/", $newsetting);
				if (substr($newsetting, 0, 1) != '/') {
					$newsetting = '/'.$newsetting;
				}
				$this_dir = trim($newsetting);
				if ($settingname=="thumbs_dir") {
					$fullpath = ldm_get_local_filename($this_dir, 0);
				}
				if ($settingname=="upload_dir") {
					$fullpath = ldm_get_local_filename($this_dir, 1, $new_local_file_root, $new_local_file_root_prefix);
				}
				$check = ldm_create_test_file($fullpath);
				switch ($check) {
				case 1: // directory doesn't exist and can't create it...
					$error = 1;
					$errormessage = "Cannot access or create directory ".$this_dir;
					if (!ldm_can_openbasedir($fullpath)) {
						$errormessage .= " [real directory ".$fullpath." not within permitted <em>open_basedir</em> ".$LDM_environment['open_basedir']."]";
					}
					else {
						$errormessage .= " [real directory: ".$fullpath."]";
					}
					break;
				case 2: // can't create file in directory
					$error = 1;
					$errormessage = "Cannot create a test file in ".$this_dir;
					if (!ldm_can_openbasedir($fullpath)) {
						$errormessage .= " [".$fullpath." not within permitted <em>open_basedir</em> ".$LDM_environment['open_basedir']."]";
					}
					else {
						$errormessage .= " [".$fullpath."]";
					}
					break;
				}
			}
			break;

		case "upload_maxspace":
			$decode_newsetting = ldm_decode_bytes($newsetting);
			if ($decode_newsetting<0) {
				$error = 1;
				$errormessage = construct_phrase($vbphrase['ll_error_decodebytes'], $newsetting);
			}
			else {
				$newsetting = ldm_encode_bytes($decode_newsetting);
			}
			break;

		case "sync_filetypes":
		case "upload_filetypes":
			$limit_mimetypes = explode(',', preg_replace('/\s/','',$newsetting));
			foreach ($limit_mimetypes as $type) {
				if ($type and !ldm_known_filetype($type)) {
					$error = 1;
					$errormessage .= $type." ";
				}
			}
			if ($error) {
				$errormessage .= " not set in VB mimetype table";
			}
			break;
		}

		($hook = vBulletinHook::fetch_hook('ldm_update_settings_validate')) ? eval($hook) : false;

// track error or flag for action
		if ($error) {
			$errors[$settingname]['value'] = $newsetting;
			$errors[$settingname]['message'] = $errormessage;
		}
		else {
			$updates[$settingname]['old'] = $currentvalue;
			$updates[$settingname]['setting'] = $newsetting;
		}

	}

	if (count($errors)) {
		return 0;
	}

	if (count($reverts)) {
		if ($catid>0) {
			foreach ($reverts as $name=>$value) {
				$vbulletin->db->query_write("
					DELETE FROM ".THIS_TABLE."linksadmin
					WHERE settingname = '".$name."'
					AND   catid='".$catid."'
					");
			}
		}
		else {
			foreach ($reverts as $name=>$value) {
				$vbulletin->db->query_write("
					DELETE FROM ".THIS_TABLE."linksadmin
					WHERE settingname = '".$name."'
					AND   catid>0
					");
			}
		}
	}

	if (isset($updates['starred_entries_gather']) or $updates['starred_entries_enabled']) {
		$now = ldm_date("Ymd", TIMENOW);
		require_once(DIR . '/includes/functions_misc.php');
		if ($updates['starred_entries_gather']['setting']==0) {
			$updates['starred_entries_periodstart']['setting'] = vbmktime(0, 0, 0, substr($now, 4, 2), 1, substr($now, 0, 4));
		}
		elseif ($updates['starred_entries_gather']['setting']<0) {
			$updates['starred_entries_periodstart']['setting'] = vbmktime(0, 0, 0, 1, 1, substr($now, 0, 4));
		}
		else {
			if (!$cache_settings['starred_entries_periodstart']) {
				$updates['starred_entries_periodstart']['setting'] = vbmktime(0, 0, 0, substr($now, 4, 2), substr($now, 6, 2), substr($now, 0, 4)); // today
			}
		}
		$updates['starred_entries_validuntil']['setting'] = 0;
	}

	foreach ($updates as $name=>$value) {
		ldm_update_oneadminrow($catid, $name, $value['setting']);
	}

	unset ($row);

	if ($updates['default_forumid'] and $settings['default_forumid_reapply']) {
		$query_cat = "
			UPDATE ".THIS_TABLE."linkscat
			SET catforum='".intval($updates['default_forumid']['setting'])."'
			WHERE catforum='".intval($updates['default_forumid']['old'])."'
		";
		$query_link = "
			UPDATE ".THIS_TABLE."linkslink
			SET linkforum='".intval($updates['default_forumid']['setting'])."'
			WHERE linkforum='".intval($updates['default_forumid']['old'])."'
		";
		$vbulletin->db->query_write($query_cat);
		$vbulletin->db->query_write($query_link);
	}

	if ($updates['profile_ldmactivity']) {
		ldm_patch_profile_dbtables($updates['profile_ldmactivity']['setting']);
	}

	if (is_array($settings['remove_do'])) {
		foreach ($settings['remove_do'] as $kval) {
			foreach ($settings['remove_start'] as $kset=>$kstart) {
				if ($kval==$settings['remove_start'][$kset]) {
					$query = "
						DELETE FROM ".THIS_TABLE."linksadmin
						WHERE sequence>= '".intval($settings['remove_start'][$kset])."'
						AND   sequence<= '".intval($settings['remove_end'][$kset])."'
					";
					$vbulletin->db->query_write($query);
					break;
				}
			}
		}
	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();
	ldm_datastore_markdirty('ldm_admin');
	ldm_datastore_markdirty('ldm_cats');

	return 1;

}

/**
* Attempt to create test file, also creating directory tree if necessary
*
* @param	str		Full path to target directory
* @return	int		0=success, 1=fail at directory create/access stage, 2=fail at file create stage
*/

function ldm_create_test_file($fullpath) {
	global $LDM_environment, $links_defaults;

	require_once(DIR . '/includes/functions_file.php');

	if (trim($LDM_environment['open_basedir'])) {
		$can_access = 0;
		foreach (explode(PATH_SEPARATOR, $LDM_environment['open_basedir']) as $thisdir) {
			$thisdir = trim($thisdir);
			if ($thisdir and preg_match("#^$thisdir#i", $fullpath)) {
				$can_access = 1;
				break;
			}
		}
		if (!$can_access) {
			return(1); // directory may exist but can't access it...
		}
	}

	if (!ldm_create_directory($fullpath, $links_defaults['secure_nullindexfile'])) {
		return(1); // directory doesn't exist and can't create it...
	}

	for ($k=0; $k<9; $k++) {
		$fullfile = ldm_make_filename($fullpath, rand(1000,9999).TIMENOW.rand(1000,9999).'.txt');
		if (!file_exists($fullfile)) break;
	}

	if (file_exists($fullfile)) {
		return(0); // assume ok
	}
	$fp = @fopen($fullfile, "w");
	if (!$fp) {
		return 2; // directory exists but can't create file
	}
	fclose($fp);
	@unlink($fullfile);
	return 0;
}

/**
* Build the update permissions form for specified category
*
* @param	&array	On return, contains permissions bit
* @param	&array	On return, contains <select> bit for quick jump
* @param	int		Category
* @param	str		Category parent list
* @param	int		All settings/over-ridable settings
* @param	int		Include an update button in the displayed form
* @param	int		Transpose permissions matrix to by-usergroup base
* @return	bool	True
*/

function ldm_build_permissions(&$linksperms, &$settingjump, $thiscatid, $parentlist, $showall=0, $includeupdate=0, $transpose=0) {
	global $vbulletin, $stylevar, $vbphrase, $forumjump, $vbcollapse;
	global $linkscat, $ldm_usergroup_cache;
	global $DEFAULT_FORUMID;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;
	global $UNKNOWN, $INHERIT, $CUSTOM, $STANDARD, $BASE_CAT;

	$doupdate = ($includeupdate ? "dopermissions" : "");
	cache_LDMusergroup();

	$cat_choice = explode(',', $thiscatid.','.$parentlist);

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linksadmin
		WHERE sequence<=".ADMIN_SETTINGS_END."
		" . (!$showall ? "AND canoverride='1'" : "") . "
		ORDER BY sequence
	");

	$open = 0;
	$master_settings = array();
	while ($admin_settings = $vbulletin->db->fetch_array($asb)) {
		if ($admin_settings["rowtype"]=="title_perms") {
			$open = $admin_settings["sequence"];
		}
		if (!$open) {
			continue;
		}
		if (in_array($admin_settings["catid"], $cat_choice)) {
			$master_settings[$admin_settings["settingname"]][$admin_settings["catid"]] = $admin_settings;
		}
		if ($thiscatid==$BASE_CAT and $admin_settings["catid"]>0) {
			$master_settings[$admin_settings["settingname"]]['catconfig'][] = $admin_settings["catid"];
		}
		if ($admin_settings["rowtype"]=="close") {
			$open = 0;
		}
	}

	$open = 0;
	$linksperms = '';
	$settingjump = '';

	if ($thiscatid==$BASE_CAT) {
		$showtranspose = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=permissions&amp;transpose=" . ($transpose ? '0' : '1');
	}
	else {
		$showtranspose = "";
	}
	$addons = "";
	$dobreak = "";

	if ($transpose) {
// Ordered by usergroup
		$adminboxstyle = $UNKNOWN;
		$title = $vbphrase['ll_permissions'];
		$settingname = "transposed";
		eval("\$linksperms .= \"".fetch_template('links_admin_setting_title')."\";");
		$open = 1;
		foreach ($ldm_usergroup_cache as $usergroupid => $title) {
			eval("\$linksperms .= \"".fetch_template('links_admin_onetranspose_start')."\";");
			foreach ($master_settings as $this_set) {
				unset($admin_settings);
				foreach ($cat_choice as $catid) {
					if (isset($this_set[$catid])) {
						$admin_settings = $this_set[$catid];
						break;
					}
				}

				if (!isset($admin_settings)) { // should not happen
					ldm_general_failure($vbphrase['ll_error_critical_settings'] . ' ' . $thiscatid . ($parentlist ? ", ".$parentlist : ""));
					exit;
				}

				if ($admin_settings["rowtype"] == "usergroup_check") {

					if (!$admin_settings["rowtitle"]) {
						$description = $vbphrase['ll_perms_'.$admin_settings['settingname']];
					}
					else {
						$description = isset($vbphrase[$admin_settings["rowtitle"]]) ? $vbphrase[$admin_settings["rowtitle"]] : $admin_settings["rowtitle"];
					}

					$array = preg_split("/[\s,]+/", $admin_settings['setting']);
					if (in_array($usergroupid, $array)) {
						$checked = 'checked="checked"';
					}
					else {
						$checked = '';
					}
					eval("\$linksperms .= \"".fetch_template('links_admin_onetranspose_perm')."\";");
				}

			}
			eval("\$linksperms .= \"".fetch_template('links_admin_onetranspose_end')."\";");
		}

	}
	else {
// Ordered by permission

		$settingtitles = array();
		foreach ($master_settings as $this_set) {

			unset($admin_settings);
			$adminboxstyle = $UNKNOWN;
			$revert = "";

			foreach ($cat_choice as $catid) {
				if (isset($this_set[$catid])) {
					$admin_settings = $this_set[$catid];
					if ($thiscatid==$BASE_CAT) {
						$adminboxstyle = $STANDARD;
						if ($admin_settings["canoverride"]) {
							if (isset($this_set['catconfig'])) {
								$configs = array();
    							$adminboxstyle = $CUSTOM;
								foreach ($this_set['catconfig'] as $ts) {
									$configs[] = "<a href='".$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=editcat&amp;catid=".
										$ts."' title='".$vbphrase['ll_editcat'].
										' '.$linkscat[$ts]['catname_clean']."' target='_blank'>" .$ts. "</a>";
								}
								sort($configs);
								$revert = construct_phrase($vbphrase['ll_admin_can_customise'],implode(', ', $configs)).
									'<br /><input type="checkbox" name="'.$admin_settings["settingname"].'_revert" value="1" /> '.
									$vbphrase['ll_revert_cats'];
							}
							else {
								$revert = construct_phrase($vbphrase['ll_admin_can_customise'],$vbphrase['ll_none']);
							}
						}
					}
					elseif ($catid==$thiscatid) {
						$adminboxstyle = $CUSTOM;
						$revert = $vbphrase['ll_customised'].'<br /><input type="checkbox" name="'.$admin_settings["settingname"].'_revert" value="1" /> '.$vbphrase['ll_revert'];
					}
					elseif ($catid<0) {
						$adminboxstyle = $STANDARD;
					}
					else {
						$adminboxstyle = $INHERIT;
						$revert = $vbphrase['ll_inherit'];
					}
					break;
				}
			}

			if (!isset($admin_settings)) { // should not happen
				ldm_general_failure($vbphrase['ll_error_critical_settings'] . ' ' . $thiscatid . ($parentlist ? ", ".$parentlist : ""));
				exit;
			}

			if ($admin_settings["rowtype"] == "title_perms") {
				if ($open) {
					eval("\$linksperms .= \"".fetch_template('links_admin_setting_foot')."\";");
				}
				$title = $vbphrase[$admin_settings["setting"]];
				$settingname = $admin_settings["settingname"];
				$settingtitles[$title] = '<option value="#'.$admin_settings["setting"].'" >'.$title.'</option>';
				$a_set = "adminset_".$settingname;
				eval("\$linksperms .= \"".fetch_template('links_admin_setting_title')."\";");
				$open = $admin_settings["sequence"];
				continue;
			}

			if ($admin_settings["rowtype"] == "close") {
				if ($open) {
					eval("\$linksperms .= \"".fetch_template('links_admin_setting_foot')."\";");
				}
				$open = 0;
				continue;
			}

			if (!$open) {
				continue;
			}

			if ($admin_settings["rowtype"] == "usergroup_check") {

				if (!$admin_settings["rowtitle"]) {
					$description = $vbphrase['ll_perms_'.$admin_settings['settingname']];
				}
				else {
					$description = isset($vbphrase[$admin_settings["rowtitle"]]) ? $vbphrase[$admin_settings["rowtitle"]] : $admin_settings["rowtitle"];
				}

				eval("\$linksperms .= \"".fetch_template('links_admin_onesetting_start')."\";");
				$array = preg_split("/[\s,]+/", $admin_settings['setting']);
				foreach ($ldm_usergroup_cache as $usergroupid => $title) {
					if (in_array($usergroupid, $array)) {
						$checked = 'checked="checked"';
					}
					else {
						$checked = '';
					}
					eval("\$linksperms .= \"".fetch_template('links_admin_oneperm')."\";");
				}
				eval("\$linksperms .= \"".fetch_template('links_admin_oneperm_end')."\";");
			}
		}

		ksort($settingtitles);
		$settingtitles = implode(' ', $settingtitles);
		eval("\$settingjump = \"".fetch_template('links_admin_setting_jump')."\";");

	}

	if ($open) eval("\$linksperms .= \"".fetch_template('links_admin_setting_foot')."\";");

	return 1;

}

/**
* Update permissions for given category
*
* @param	int		Category parent
* @param	array	New settings array
*/

function ldm_update_permissions($catid, $settings) {
	global $vbulletin;

	$cache_settings = cache_LDMpermissions($catid);

	foreach ($cache_settings as $name=>$currentvalue) {

		if (!isset($settings[$name])) {
			continue;
		}

		$newset = $settings[$name];

// request to revert?
		if ($settings[$name."_revert"]) {
			if ($catid>0) {
				$vbulletin->db->query_write("
					DELETE FROM ".THIS_TABLE."linksadmin
					WHERE settingname = '".$name."'
					AND   catid='".$catid."'
				");
				continue; // revert takes priority over new setting
			}
			else {
				$vbulletin->db->query_write("
					DELETE FROM ".THIS_TABLE."linksadmin
					WHERE settingname = '".$name."'
					AND   catid>0
				");
			}
		}

// sanitise old and new permission sets, in case any glitches have crept in, then
// check whether permissions have changed/differ from those inherited
		$mycurr = array();
		$mynew = array();
		$mymerge = array();
		$mycurr[-1] = $mynew[-1] = $mymerge[-1] = -1;
		foreach ($newset as $thisnew) {
			$mynew[$thisnew] = $mymerge[$thisnew] = $thisnew;
		}
		$currset = explode(",", $currentvalue);
		foreach ($currset as $thiscur) {
			$mycurr[$thiscur] = $thiscur;
			$mymerge[$thiscur] = $thiscur;
		}

		$cmerge = count($mymerge);
		$cnew = count($mynew);
		$ccurr = count($mycurr);

		if ($cmerge!=$cnew or $cmerge!=$ccurr) {
			$newsetting = implode(',', $mynew);
			ldm_update_oneadminrow($catid, $name, $newsetting);
		}
	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();
	ldm_datastore_markdirty('ldm_admin');
	ldm_datastore_markdirty('ldm_cats');

}


/**
* Return list of all categories with specified setting value
*
* @param	str		Setting
* @param	str		Value
* @return   array   Category ids
*/

function ldm_lookup_categories_with_setting($settingname, $settingvalue) {
	global $ldm_master_settings, $linkscat;

	$catids = array();

	if (!isset($ldm_master_settings[$settingname])) {
	    return $catids;
	}

    foreach ($linkscat as $catid=>$thiscat) {
		$cat_choice = explode(',', $catid.','.(isset($linkscat[$catid]['parentlist']) ? $linkscat[$catid]['parentlist'] : "-1"));
		foreach ($cat_choice as $c_catid) {
			if (isset($ldm_master_settings[$settingname][$c_catid])) {
				$c_value = $ldm_master_settings[$settingname][$c_catid]["setting"];
			    if ($c_value==$settingvalue) {
			        $catids[$catid] = $catid;
				}
				break;
			}
		}
	}

	$catids = array_keys($catids);
	sort($catids);
	return $catids;

}

/**
* Return list of all categories with specified permission value
*
* @param	str		Setting
* @param	str		Value
* @return   array   Category ids
*/

function ldm_lookup_categories_with_permission($settingname, $settingvalue) {
	global $ldm_master_settings, $linkscat;
	global $links_usergroupids;

	$catids = array();

	if (!isset($ldm_master_settings[$settingname])) {
	    return $catids;
	}

    foreach ($linkscat as $catid=>$thiscat) {
		$cat_choice = explode(',', $catid.','.(isset($linkscat[$catid]['parentlist']) ? $linkscat[$catid]['parentlist'] : "-1"));
		foreach ($cat_choice as $c_catid) {
			if (isset($ldm_master_settings[$settingname][$c_catid])) {
			    $c_value = 0;
				$sets = explode(',', $ldm_master_settings[$settingname][$c_catid]["setting"]);
				foreach ($links_usergroupids as $i) {
					if (in_array($i, $sets)) {
						$c_value = 1;
						break;
					}
				}
			    if ($c_value==$settingvalue) {
			        $catids[$catid] = $catid;
				}
				break;
			}
		}
	}

	$catids = array_keys($catids);
	sort($catids);
	return $catids;

}

/**
* Report whether an 'extra' has initiated itself
*
* @param	str		Extra's title setting
*/

function ldm_extra_has_loaded($title) {
	global $vbulletin;
	global $ldm_extras_loaded;

	$has_initiated = isset($ldm_extras_loaded[$title]);
	return ($has_initiated ? 1 : 0);

}

/**
* Test for valid integer string in given range
*
* @param	str		String to test
* @param	int		Minimum value allowed
* @param	int		Maximum value allowed
* @return	bool	true/false
*/

function ldm_is_valid_int($value, $min=-999999999, $max=999999999) {
	if (!preg_match("/^[+\-]?[0-9]+$/", $value)) {
		return 0;
	}
	elseif ($value<$min or $value>$max) {
		return 0;
	}
	return 1;
}

/**
* Build a <select> list for linkbit/catbit template selection
*
* @param	array	Array of template choices
* @param	int		Index of pre-selected template
* @param	str		Name of variable in which selection choice is returned
* @return	str		<select> list html
*/

function ldm_construct_bitselect_list($bitcache, $bit_selected, $list_id) {
	global $vbphrase, $stylevar;

	$stylewidth = "width:300px";
	$selectsubmit = 0;
	$stylesize = 3;
	$select_stage = 1;
	$label = $vbphrase['ll_stylelabel'];
	eval("\$optbit = \"".fetch_template('links_listselect')."\";");

	$select_stage = 2;
	foreach ($bitcache as $styleid=>$bit) {
		$stylename  = $bit["name"];
		$stylesel = ($styleid==$bit_selected ? 1 : 0);
		eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	}

	$select_stage = 3;
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	return $optbit;

}

/**
* Build a date/time selection bit, approximating the VB settings
*
* @param	int		Time stamp
* @param	str		Field identifier
* @return	str		Date and time bit
*/

function ldm_get_datetimebit($timestamp, $id="", $can_expire=0) {
	global $vbphrase, $vbulletin, $stylevar, $links_permissions, $links_defaults;

// approximate the site's date and time settings in the layout
	$df = (preg_match("/[mMn].*[Ddj]/", $vbulletin->options['dateformat']) ? 1 : 2); // m-d or d-m
	$tf = (preg_match("/[hAa]/", $vbulletin->options['timeformat']) ? 1 : 2); // 12hr or 24 hr

	$hourdiff = $vbulletin->options['hourdiff'];
	$timestamp_adjusted = max(0, $timestamp - $hourdiff);

	$year = date('Y', $timestamp_adjusted);
	$mon = date('n', $timestamp_adjusted);
	$month[$mon] = 'selected="selected"';
	$day = date('d', $timestamp_adjusted);
	$hour = ($tf==1 ? date('h', $timestamp_adjusted) : date('H', $timestamp_adjusted));
	$hour24 = date('H', $timestamp_adjusted);
	$min = date('i', $timestamp_adjusted);
	$ampm[date('A', $timestamp_adjusted)] = 'selected="selected"';

// select timezone and build timezone options
	require_once(DIR . '/includes/functions_misc.php');
	$timezones = fetch_timezone();
	$tzoffset = $vbulletin->userinfo['tzoffset']-$vbulletin->userinfo['dstonoff'];
	$tzoffset = (abs(round($tzoffset)-$tzoffset)<0.1) ? intval($tzoffset) : round($tzoffset, 1);
	$timezonephrase = $timezones["$tzoffset"];
	$timezone = $vbphrase[$timezonephrase];

	$date = ldm_date($vbulletin->options['dateformat'], $timestamp);
	$time = ldm_date($vbulletin->options['timeformat'], $timestamp);
	$dateandtime = $date.' '.$time;

	if (!$id) {
		eval("\$datetimebit .= \"".fetch_template('links_timebit')."\";");
	}
	else {
		eval("\$datetimebit .= \"".fetch_template('links_timebit_multi')."\";");
	}

	return $datetimebit;
}

/**
* Similar to the simple bits of the Apache mod_rewrite
* NB: no error checking at the moment. Rewrite file is assumed valid.
* Records that fail the required syntax are ignored without warning
*
* @param	str		Url to test
* @param	int		Category id
* @param	int		Entry id
* @return	mixed	Either patched url or an array of alternative urls
*/

function ldm_mod_rewrite($url, $catid="", $linkid="") {
	global $vbulletin, $vbphrase;
	global $links_defaults, $linkscat, $LDM_environment, $BASE_CAT;

	$rewrites = array();
	$rewrites_set = 0;

	if ($links_defaults['mod_rewrite']) {
		$file = ldm_cleanto_fopen($links_defaults['mod_rewrite']);
		if ($fp = @fopen($file, "rb")) {
			$contents = "";
			while (!feof($fp)) {
				$contents .= fread($fp, 8192);
			}
			fclose($fp);
			$rewrites = explode("\n", $contents);
			$rewrites_set = 1;
		}
	}

	if ($rewrites_set) {

// Set any category or entry variables
		foreach ($rewrites as $k=>$rewrite) {
			$search = array('/%\{catid\}/i', '/%\{linkid\}/i');
			$replace = array($catid, $linkid);
			$this_rewrite[$k] = preg_replace($search, $replace, $rewrites[$k]);
		}

// Process the rules
		foreach ($this_rewrite as $rewrite) {
			if (!preg_match("/RewriteRule\s+(\S+)\s+(\S+)(\s+|)(\[([^\]]+)\]|)/i", $rewrite, $matches)) {
				continue;
			}
			$flags = explode(',', preg_replace('/\s+/', '', $matches[5]));
			$lc = in_array("nocase", $flags) or in_array("NC", $flags) ? "i" : "";
			$url = preg_replace("|".$matches[1]."|".$lc, $matches[2], $url);
		}

	}

	($hook = vBulletinHook::fetch_hook('ldm_mod_rewrite_end')) ? eval($hook) : false;

	return $url;

}

/**
* Recursively scan directory and return list of subdirectories and files with specified
* (case-insensitive) filetypes.
*
* @param	str		Directory to scan (within usual LDM space)
* @param	str		Filetypes to match
* @param	&int	Array; keys = subdirectory names
* @param	&int	Array; keys = filenames
* @param	&int	Array; keys = count of skipped files by filetype
* @param	int		Scan subdirectories to this depth
*/

function ldm_read_directory($directory, $filetypes, &$dir_list, &$fil_list, &$skip_list, $flatten_depth=0) {

	$dir_list	= array();
	$fil_list	= array();
	$skip_list	= array();

	$fulldir = ldm_cleanto_fopen($directory);

	if ($dir_handle = @opendir($fulldir)) {
		while (false !== ($file = readdir($dir_handle))) {
			if ($file{0} == '.') {
				continue; // never record files or directories that start with '.'
			}
			if (is_dir(ldm_make_filename($fulldir, $file))) {
				$dir_list[$file] = 0;
			}
			else {
				$type = file_extension($file);
				$typematch = 0;
				foreach ($filetypes as $thistype) {
					if (strcasecmp($type, $thistype) == 0) {
						$fil_list[$file] = 0;
						$typematch = 1;
						break;
					}
				}
				if (!$typematch) {
					$skip_list[$type] += 1;
				}
			}
		}
		closedir($dir_handle);
	}

	if ($flatten_depth>0) { // Recursively scan sub-directories
		$cdir_list = array();
		foreach ($dir_list as $thisdir=>$d) {
			$ndir_list = array();
			$nfil_list = array();
			$nskip_list = array();
			ldm_read_directory(ldm_make_filename($directory, $thisdir), $filetypes, $ndir_list, $nfil_list, $nskip_list, $flatten_depth-1);
			unset($dir_list[$thisdir]);
			foreach ($ndir_list as $thisndir=>$n) {
				$cdir_list[ldm_make_filename($thisdir, $thisndir)] = 0;
			}
			foreach ($nfil_list as $thisnfil=>$n) {
				$fil_list[ldm_make_filename($thisdir, $thisnfil)] = 0;
			}
			foreach ($nskip_list as $thisnskip=>$n) {
				$skip_list[$thisnskip] += $n;
			}
		}
		$dir_list = $cdir_list;
	}

}

/**
* Scan directory and its subdirectories for at least one file of indicated (case-insensitive) type
*
* @param	str		Directory to search
* @param	str		Filetypes
* @return	bool	Found/not found
*/

function ldm_scan_directory($directory, $filetypes) {

	$fulldir = ldm_cleanto_fopen($directory);
	$result = 0;
	$dir_list = array();
	if ($dir_handle = @opendir($fulldir)) {
		while (!$result and false !== ($file = readdir($dir_handle))) {
			if ($file{0} == '.') {
				continue; // never record files or directories that start with '.'
			}
			$child_dir = ldm_make_filename($fulldir, $file);
			if (is_dir($child_dir)) {
				$dir_list[] = $file;
			}
			else {
				$type = file_extension($file);
				foreach ($filetypes as $thistype) {
					if (strcasecmp($type, $thistype) == 0) {
						$result = 1;
						break;
					}
				}
			}
		}
		closedir($dir_handle);
	}

	if ($result) {
		return 1;
	}
	else {
		foreach ($dir_list as $dir) {
			if (ldm_scan_directory(ldm_make_filename($directory, $dir), $filetypes)) {
				return 1;
			}
		}
		return 0;
	}
}

/**
* Recurively synchronise category with directory, limiting time spent.
* Main cost is in creating thumbnails (if enabled) but trawling a
* large directory tree is also costly
*
* @param	int		Category
* @param	int		Time limit, seconds
* @param	int		If set, force resynchronisation
* @param	int		Depth of subcategories to synchronise
* @return	int		Task complete 0/1
*/

function ldm_synchronise_category($catid, $time_limit, $force_sync=0, $sync_depth=-1) {
	global $vbulletin;
	global $links_defaults, $linkscat;
	global $LINK_OK, $LINK_ACCEPTED;

	$directory = $linkscat[$catid]['catsyncdir'];

	if (!$directory) {
		return 1;
	}

	if (!$force_sync) {
		if ($links_defaults['sync_freq']<=0) {
			return $linkscat[$catid]['catsyncdone'];
		}
		if ($linkscat[$catid]['catsyncdone']
			and ($linkscat[$catid]['catsynctime']+$links_defaults['sync_freq'])>TIMENOW) {
			return $linkscat[$catid]['catsyncdone'];
		}
	}

	if ($time_limit<=0.5) {
		return $linkscat[$catid]['catsyncdone']; // always require at least half a second
	}

	require_once(DIR . '/includes/functions_misc.php');
	$start_time = microtime();

	($hook = vBulletinHook::fetch_hook('ldm_sync_begin')) ? eval($hook) : false;

	$linkuserid	= $links_defaults['sync_userid'] ? $links_defaults['sync_userid'] : $linkscat[$catid]['catuserid'];
	$linkuser	= $links_defaults['sync_username'] ? $links_defaults['sync_username'] : $linkscat[$catid]['catusername'];

	$continue = 1;
	$this_sync_depth = ($sync_depth<0 ? $links_defaults['sync_depth'] : $sync_depth);

	$def = preg_replace('/\s/','',$links_defaults['sync_filetypes']);
	$filetypes = ($def ?
		array_intersect(explode(',', strtolower($def)), array_keys($vbulletin->attachmentcache)) :
		array_keys($vbulletin->attachmentcache));

// Scan the directory
	ldm_read_directory($directory, $filetypes, $dir_list, $fil_list, $skip_list, ($links_defaults['sync_flatten'] ? $this_sync_depth : 0));

	$cat_list = array();
	$lnk_list = array();

// Scan the category
	$query = "
		SELECT link.linkid AS linkid, link.linkurl AS linkurl, ltoc.catid AS linkcatid
			FROM ".THIS_TABLE."linkslink AS link
		LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
		ON link.linkid = ltoc.linkid
			WHERE ltoc.catid='".$catid."'
	";
	$asb = $vbulletin->db->query_read($query);
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$lnk_list[$myrow['linkurl']] = $myrow['linkid'];
	}

	foreach ($linkscat as $kcat=>$thiscat) {
		if ($thiscat['parentid']==$catid and $thiscat['catsyncdir']) {
			$cat_list[$thiscat['catsyncdir']]['catid'] = $thiscat['catid'];
			$cat_list[$thiscat['catsyncdir']]['exists'] = 0;
			$cat_list[$thiscat['catsyncdir']]['catsynctime'] = $thiscat['catsynctime'];
			if (!$thiscat['catsyncdone']) {
				$cat_list[$thiscat['catsyncdir']]['catsynctime'] -= 100;  // to give it a kick start
			}
		}
	}

// Create any new categories
	if ($links_defaults['sync_populate_categories'] and $continue) {
		foreach ($dir_list as $thisdir=>$kd) {
			if (($time_limit-fetch_microtime_difference($start_time))<0.5) {
				$continue = 0;
				break;
			}
			$subdirectory = trim(ldm_make_filename($directory, $thisdir));
			if (isset($cat_list[$subdirectory])) {
				$cat_list[$subdirectory]['exists'] = 1;
			}
			elseif (ldm_scan_directory($subdirectory, $filetypes)) {
				$subcategory = ldm_category_template(array(
					'catusername' => $linkuser,
					'catuserid' => $linkuserid,
					'catname' => $thisdir,
					'parentid' => $catid,
					'parentlist' => "$catid,".$linkscat[$catid]['parentlist'],
					'catforum' => $linkscat[$catid]['catforum'],
					'catsyncdir' => $subdirectory,
					));
				$subcatid = ldm_create_category($subcategory);
				$cat_list[$subdirectory]['catid'] = $subcatid;
				$cat_list[$subdirectory]['exists'] = 1;
				$cat_list[$subdirectory]['catsynctime'] = 0;
				($hook = vBulletinHook::fetch_hook('ldm_sync_cat_inserted')) ? eval($hook) : false;
			}
		}
	}

// Remove obsolete categories and their entries
	if ($links_defaults['sync_populate_categories'] and $continue) {
		$cat_delete = array();
		foreach ($cat_list as $thiscat=>$kc) {
			if (($time_limit-fetch_microtime_difference($start_time))<0.5) {
				$continue = 0;
				break;
			}
			if (!$cat_list[$thiscat]['exists']) {
				$cat_delete[] = $cat_list[$thiscat]['catid'];
			}
			if (!ldm_scan_directory($thiscat, $filetypes)) {
				$cat_delete[] = $cat_list[$thiscat]['catid'];
			}
		}
		if (count($cat_delete)) {
			ldm_empty_category($cat_delete, 1);
			ldm_delete_category($cat_delete);
			foreach ($cat_delete as $thiscat) {
				unset($cat_list[$thiscat]);
			}
			($hook = vBulletinHook::fetch_hook('ldm_sync_cat_deleted')) ? eval($hook) : false;
		}
	}

// Add any new entries...
	if ($links_defaults['sync_populate_entries'] and $continue) {

		$auto_forumid = $links_defaults['autocreate_forum']>0 ? $links_defaults['autocreate_forum'] : $links_defaults['default_forumid'];
		$auto_username = $links_defaults['autocreate_username'] ? $links_defaults['autocreate_username'] :
			$links_defaults['sync_username'] ? $links_defaults['sync_username'] : $vbulletin->userinfo['username'];
		$auto_userid = $links_defaults['autocreate_userid']>0 ? $links_defaults['autocreate_userid'] :
			$links_defaults['sync_userid']>0 ? $links_defaults['sync_userid'] : $vbulletin->userinfo['userid'];
		$linkdesctemplate = $links_defaults['monitor_template'];

		foreach ($fil_list as $thisfil=>$thisentry) {
			if (($time_limit-fetch_microtime_difference($start_time))<0.5) {
				$continue = 0;
				break;
			}
			$linkurl = $fil_list[$thisfil] = ldm_make_filename($directory, $thisfil);
			if (isset($lnk_list[$linkurl])) {
				unset($lnk_list[$linkurl]);
			}
			else {
				$statuscheck = $LINK_OK;
				$filesize = ldm_get_sizeof_url($linkurl);
				$file = array();
				ldm_get_file_info($linkurl, $file, $linkdesctemplate);
				$linkname = $file['linkname'];
				$linkdesc = $file['linkdesc'];
				$linkimg = $file['linkimg'];
				$linkimgthumb = $file['imgthumb'];
				$linkimgthumbsize = $file['imgthumbsize'];
				$linkfile = '';
				$linkdoi = '';
				$linkreviewfreq = 0;
				$linkdups = 1;
				$linkdate = time();
				$pforum = $links_defaults['default_forumid'];
				$imgstatuscheck = 0;
				$moderate = $LINK_ACCEPTED;

				$linkkeywords = array();
				$linknewkeywords = "";
				$linkentities = array();

				($hook = vBulletinHook::fetch_hook('ldm_addlink_preinsert')) ? eval($hook) : false;

				$ldm_entry = ldm_entry_template(
					array(
						'linkname' => $linkname,
						'linkdesc' => $linkdesc,
						'linkdoi' => $linkdoi,
						'linkurl' => $linkurl,
						'linkfile' => $linkfile,
						'linkimg' => $linkimg,
						'linkimgthumb' => $linkimgthumb,
						'linkimgthumbsize' => $linkimgthumbsize,
						'linkforum' => $pforum,
						'linksize' => $filesize,
						'linkstatus' => $statuscheck,
						'linkimgstatus' => $imgstatuscheck,
						'linkdate' => $linkdate,
						'linkusername' => $linkuser,
						'linkuserid' => $linkuserid,
						'linkmoderate' => $moderate,
						'linkreviewfreq' => $linkreviewfreq,
						)
					);

				list ($insert_status, $linkid) = ldm_create_entry($ldm_entry, $linkdups);

				if ($linkid) {
					ldm_insert_entry_in_category($linkid, array($catid));
				}

				if (count($linkkeywords)) {
					ldm_associate_keywords($linkid, $linkkeywords, 0);
				}
				if ($linknewkeywords) {
					ldm_associate_keywords($linkid, ldm_lookup_keywords(ldm_explode_keywords($linknewkeywords)), 1);
				}
				if (count($linkentities)) {
					require_once(DIR . '/includes/local_links_entities.php');
					ldm_associate_entities($linkid, $linkentities, $linkentityfiles, $message);
				}

// Be very careful about enabling this - it may run riot with your forums....
				if ($links_defaults['autocreate_active'] and
					$links_defaults['autocreate_active_sync'] and
					$auto_forumid>0) {

					require_once(DIR . '/includes/local_links_forumsinterface.php');

            		$auto_prefix = ldm_lookup_setting($catid, 'autocreate_prefix');
                    if ($auto_prefix) {
        				require_once(DIR . '/includes/local_links_forumsinterface.php');
                        if (!ldm_validate_threadprefix($auto_prefix, $catid, $auto_forumid)) {
                            $auto_prefix = "";
                        }
                    }

					list($error, $message) = ldm_announce_in_forum(
						$auto_forumid,
						$links_defaults['autocreate_both_ways'],
						$linkid,
						$catid,
						$linkname,
						$linkdesc,
						in_array(strtolower(file_extension($linkimg)), array("jpg", "gif", "png")) ? $linkimg : "",
						$auto_prefix,
						$auto_username,
						$auto_userid
						);
				}

				($hook = vBulletinHook::fetch_hook('ldm_sync_link_inserted')) ? eval($hook) : false;
			}
		}
	}

// Delete any entries which no longer exist...
	if ($links_defaults['sync_populate_entries'] and $continue) {
		if (count($lnk_list)) {
			ldm_delete_entry($lnk_list);
		}
		($hook = vBulletinHook::fetch_hook('ldm_sync_link_deleted')) ? eval($hook) : false;
	}

// Resynchronise children - least recently synchronised first...
	if (!function_exists('ldm_sync_cmp')) {
		function ldm_sync_cmp($a, $b) {
			global $cat_list;
			$icomp = strcmp($a['catsynctime'], $b['catsynctime']);
			if ($icomp) {
				return $icomp;
			}
			else {
				$icomp = rand(0, 2) - 1;
				return $icomp;
			}
		}
	}

	if ($continue and $links_defaults['sync_populate_categories'] and !$links_defaults['sync_flatten']) {
		usort($cat_list, "ldm_sync_cmp");
		foreach ($cat_list as $thiscat=>$kc) {
			$time_left = $time_limit-fetch_microtime_difference($start_time);
			$continue = ldm_synchronise_category($cat_list[$thiscat]['catid'], $time_left, $force_sync, $this_sync_depth-1);
			if (!$continue) {
				break;
			}
		}
	}

	if ($sync_depth<0) {
		ldm_datastore_markdirty('ldm_cats');
		cache_LDMcategories(1);
		ldm_fix_cat_count();
	}

	$timenow = time();
	$linkscat[$catid]['catsynctime'] = $timenow;
	$linkscat[$catid]['catsyncdone'] = $continue;
	$vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linkscat
		SET
			catsynctime=".$timenow.",
			catsyncdone=".($continue ? 1 : 0)."
		WHERE catid='".intval($catid)."'
		LIMIT 1
		");

	($hook = vBulletinHook::fetch_hook('ldm_sync_end')) ? eval($hook) : false;
	return $continue;

}

// Return information on supplied file

function ldm_get_file_info($linkurl, &$file, $template) {
	global $links_defaults;
	global $vbphrase;

	foreach ($file as $k=>$v) {
		unset($file[$k]);
	}

	if (!preg_match(":(.*)/([^/]*)\.(.*)$:", $linkurl, $matches)) {
		return;
	}

	$file['dir'] = $matches[1];
	$file['prefix'] = $matches[2];
	$file['type'] = $matches[3];

	($hook = vBulletinHook::fetch_hook('ldm_addlink_getfileinfo')) ? eval($hook) : false;

	if (!$file['linkname']) {
		$file['linkname'] = $file['prefix'];
	}

	if (!$file['linkdesc']) {
		eval("\$desc = \"".fetch_template($template, 0, 0)."\";");
		$file['linkdesc'] = $desc;
	}

	if (!$file['linkimg']) {
		ldm_set_autoimage($linkurl, $file['linkimg']);
	}

// potentially time consuming, so have the option to delay until first display
	$file['imgthumb'] = "";
	if ($file['linkimg'] and $links_defaults['thumbs_dir'] and $links_defaults['create_thumbs_oninsert']) {
		require_once(DIR . '/includes/local_links_images.php');
		$thumb = ldm_make_thumbnail($file['linkimg'], $links_defaults['link_imagesize']);
		if ($thumb) {
			$file['imgthumb'] = ldm_save_thumbnail($thumb, $links_defaults['thumbs_dir']);
			$file['imgthumbsize'] = $links_defaults['link_imagesize'];
		}
		else {
			$file['imgthumb'] = "";
			$file['imgthumbsize'] = 0;
		}
		unset($thumb);
	}

}

/**
* Return information needed for upload bit construction
*
* @param	str	    List of allowed filetypes, if blank, all defined mimetypes allowed
* @param	&int	Maximum upload size
* @param	&str	Comma-separated list of uploadable filetypes
* @param	&int	Disk space currently used by uploads
* @param	&int	Maximum disk space to be used by uploads
* @param	&str	Upload info bit
*/

function ldm_fetch_uploadinfo($upload_filetypes, &$maxupload, &$mimetypes, &$space_used, &$space_max, &$uploadinfo) {
	global $links_permissions, $links_defaults, $ldm_mimetype_cache;
	global $ldm_icon_cache, $LINK_UPLOAD, $LDM_environment;
	global $vbulletin, $vbphrase, $stylevar;

	$maxupload = 0;
	$mimetypes = '';
	$space_max = ldm_decode_bytes($links_defaults['upload_maxspace']);
	$space_used = 0;

	$uploadinfo = "";
	if ($links_permissions['can_upload_files'] and $links_defaults['upload_enabled']) {

		cache_LDMicons();
    	cache_LDMmimetype();

		if ($links_defaults['bandwidth_limit']) {
			$usergroupid = $vbulletin->userinfo['usergroupid'];
			$limit = unserialize($links_defaults['bandwidth_limit']);
			$allow_uploadenable = $limit[$usergroupid]['uploadenable'];
			$allow_uploadlimit = ldm_decode_bytes($limit[$usergroupid]['uploadlimit']);
		}

		if ($allow_uploadenable) {
			$rec = $vbulletin->db->query_first("
				SELECT SUM(linksize) AS spaceused
				FROM ".THIS_TABLE."linkslink
				WHERE linkuserid='".intval($vbulletin->userinfo['userid'])."'
				AND linkstatus=".$LINK_UPLOAD."
				");
			$space_used = ($rec['spaceused'] ? $rec['spaceused'] : 0);
			if ($space_max) {
				$space_max = min($space_max, $allow_uploadlimit);
			}
			else {
				$space_max = $allow_uploadlimit;
			}
		}
		else {
			$rec = $vbulletin->db->query_first("
				SELECT SUM(linksize) AS spaceused
				FROM ".THIS_TABLE."linkslink
				WHERE linkstatus=".$LINK_UPLOAD."
			");
			$space_used = ($rec['spaceused'] ? $rec['spaceused'] : 0);
		}

		if (!$space_max or $space_used<$space_max) {

			$post_max = min(ldm_decode_bytes(ini_get('upload_max_filesize')), ldm_decode_bytes(ini_get('post_max_size')));
			if ($space_max) {
				$post_max = min($space_max-$space_used, $post_max);
			}

			$mimes = array();
			foreach ($ldm_mimetype_cache as $type=>$mime) {
                $size = ldm_max_allowed_upload($type, $upload_filetypes, $post_max);
				if ($size==0) {
					continue;
				}
				$mimes[] = $type;
				$icon = (isset($ldm_icon_cache[$type]) ? $ldm_icon_cache[$type] : "");
				$maxupload = max($maxupload, $size);
				$size = ldm_format_bytes($size);
				eval("\$uploadinfo .= \"".fetch_template('links_uploadinfo')."\";");
			}

			$mimetypes = implode(', ', $mimes);
			$maxupload = min($maxupload, $post_max);
		}
	}

}

/**
* Check current user's maximum allowed upload for specified file type
*
* @param	str		File type
* @param    str     List of allowed filetypes; if blank, all defined mimetypes allowed
* @param	int		Maximum allowed upload post
* @return	int     Max allowed upload, bytes, 0 if not allowed
*/

function ldm_max_allowed_upload($type, $upload_filetypes, $post_max=-1) {
	global $vbulletin;
	global $links_defaults;
	global $LDM_environment, $ldm_mimetype_cache;

	if ($post_max<0) {
	    $post_max = min(ldm_decode_bytes(ini_get('upload_max_filesize')), ldm_decode_bytes(ini_get('post_max_size')));
	}

	cache_LDMmimetype();
	$type = trim($type);
    $max_upload = 0;

// Disallowed by upload_filetypes setting?
    $upload_filetypes = preg_replace("/\s/","", $upload_filetypes);
    if ($upload_filetypes) {
        $in_setting = 0;
        $upload_filetypes = explode(',', $upload_filetypes);
        foreach ($upload_filetypes as $thistype) {
        	if (strcasecmp($type, $thistype)==0) {
                $in_setting = 1;
                break;
            }
        }
        if (!$in_setting) {
            return 0;
        }
    }

// Disallowed because not in vb attachment table, disallowed or disabled?
	$in_cache = 0;
	foreach ($ldm_mimetype_cache as $thistype=>$mime) {
        if ($upload_filetypes) { // Just check on existence and permissions
        	if (strcasecmp($type, $thistype)==0 and $mime['permissions']) {
        	    $in_cache = 1;
    	        $max_size = $mime['size'];
    	        break;
    	    }
    	}
    	else { // Check on existence, enabled and permissions
        	if (strcasecmp($type, $thistype)==0 and $mime['enabled'] and $mime['permissions']) {
        	    $in_cache = 1;
    	        $max_size = $mime['size'];
    	        break;
    	    }
    	}

    }
    if (!$in_cache) {
        return 0;
    }

// Allowed, determine max size
	if ($LDM_environment['is_admin']) {
		$max_upload = 0;
	}
	else {
		$max_upload = $max_size;
	}

	if ($max_upload==0) {
		$max_upload = $post_max;
	}

	return $max_upload;
}

/**
* Grab a web page, optionally recursing...
*
* @param	str		URL
* @param	int		Maximum recursion on HTTP-EQUIV's
* @param	bool	Fetch header
* @return	str		Page
*/

function ldm_fetch_page($url, $maxcycle=2, $grabheader=1) {
	global $READ_BUFFER_SIZE, $LDM_environment;

	$file = ldm_cleanto_fopen($url);
	$ch = 0;
	if ($LDM_environment['curl_available']) {
		$ch = @curl_init();
		@curl_setopt($ch, CURLOPT_URL, str_replace(" ", "%20", $url));
		@curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		@curl_setopt($ch, CURLOPT_HEADER, $grabheader);
		@curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		@curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		@curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
		@curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$contents = @curl_exec($ch);
		$error = @curl_error($ch);
		@curl_close($ch);
		if (preg_match('/<META HTTP-EQUIV=\"Refresh\" .*URL=([^\" ]*)\">/i', $contents, $matches) and $maxcycle) {
			return ldm_fetch_page($matches[1], $maxcycle-1);
		}
	}
	elseif ($LDM_environment['allow_url_fopen']) {
		$ch = @fopen($file, "rb");
		while ($contents .= fread($ch, $READ_BUFFER_SIZE)) { }
		fclose($ch);
	}

	return $contents;
}

/**
* Fetch list of moderators
*
* @param	int		category id
* @param	array	userids
* @param	int		0=userids only; 1=0+category/forum moderators; 2=1+plus members of VB moderators usergroup; 3=2+plus VB supermoderator and admin usergroups
* @return	arr		moderator array
*/

function ldm_fetch_moderators($catid, $fetchuserids=array(), $fetch=1) {
	global $vbulletin;
	global $linkscat, $links_permissions;
	global $ldm_master_settings;

	$mods = array();
	$usergroups = array();
	$query = array();

// Start with named users
	if (count($fetchuserids)) {
		$query[] = "userid IN (" . implode(',', $fetchuserids) . ")";
	}

// Add users in usergroups with *can_moderate_links* permission plus those defined by setting of fetch
	if ($fetch>=1) {
		$cattree = explode(',', $catid.',' . (isset($linkscat[$catid]['parentlist']) ? $linkscat[$catid]['parentlist'] : "-1"));
		if (isset($ldm_master_settings['can_moderate_links'])) {
			foreach ($cattree as $c_catid) {
				if (isset($ldm_master_settings['can_moderate_links'][$c_catid])) {
					$usergroups = explode(',', $ldm_master_settings['can_moderate_links'][$c_catid]["setting"]);
					break;
				}
			}
		}
	}

	if ($fetch>=2) {
		$asb = $vbulletin->db->query_read("
			SELECT usergroupid
			FROM " . TABLE_PREFIX . "usergroup
			WHERE adminpermissions " . ($fetch==2 ? "=1" : "<> 0" ) . "
		");
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			if (!in_array($myrow['usergroupid'], $usergroups)) {
				$usergroups[] = $myrow['usergroupid'];
			}
		}
		$vbulletin->db->free_result($asb);
	}

	foreach ($usergroups as $thisgroup) {
		$query[] = "usergroupid='" . $thisgroup ."'";
		$query[] = "FIND_IN_SET('" . $thisgroup . "', membergroupids)";
	}

	if (count($query)) {
		$query = "
			SELECT DISTINCT user.email, user.languageid, user.userid, user.username AS musername
			FROM " . TABLE_PREFIX . "user AS user
			WHERE " . implode(" OR ", $query);
		$moderators = $vbulletin->db->query_read($query);
		while ($moderator = $vbulletin->db->fetch_array($moderators)) {
			$mods["$moderator[userid]"] = $moderator;
		}
	}

// Add moderators for associated forum, if any
	if ($fetch>=1) {
		unset ($foruminfo);
		if (isset($linkscat[$catid]['catforum']) and $linkscat[$catid]['catforum']>0) {
			$foruminfo = fetch_foruminfo($linkscat[$catid]['catforum']);
		}
		if ($foruminfo) {
			$query = "
				SELECT DISTINCT user.email, user.languageid, user.userid, user.username AS musername
				FROM " . TABLE_PREFIX . "moderator AS moderator," . TABLE_PREFIX . "user AS user
				WHERE user.userid = moderator.userid
				AND moderator.forumid IN (".$foruminfo['parentlist'].")
				AND moderator.forumid <> -1
				";
			$moderators = $vbulletin->db->query_read($query);
			while ($moderator = $vbulletin->db->fetch_array($moderators)) {
				$mods["$moderator[userid]"] = $moderator;
			}
		}
	}

	return $mods;
}

/**
* Create html for 'My Profile' search dropdown
*
* @param	str		Profile field
* @return	arr		Search dropdown data structure
*/

function ldm_make_myprofilesearch($profile_searchfield) {
	global $vbulletin, $vbphrase;
	global $links_defaults;

	$ldm_mysearch = array();
	$keywords = array();
	$counts = array();
	$nsearch = 0;

	if (!$profile_searchfield or trim($profile_searchfield)=='-1') {
		return;
	}

	$fields = explode(',', $profile_searchfield);
	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".TABLE_PREFIX."profilefield
	");

	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		if (in_array($myrow['profilefieldid'], $fields)) {

			switch ($myrow['type']) {

			case 'input':
			case 'textarea':

				$field = html_entity_decode($vbulletin->userinfo['field'.$myrow['profilefieldid']]);

				if ($links_defaults['profile_search_all']==1) {
					$choices = explode(' ', preg_replace("/[\W\"']+/"," ", $field));
				}
				else {
					$choices = array($field);
				}

				foreach ($choices as $k=>$c) {
					$c = trim($c);
					if ($c) {
						$ldm_mysearch[$nsearch]['profilefieldid'] = $myrow['profilefieldid'];
						$ldm_mysearch[$nsearch]['profilefieldtitle'] = $vbphrase["field".$myrow['profilefieldid']."_title"];
						$ldm_mysearch[$nsearch]['text'] = $c;
						$ldm_mysearch[$nsearch]['title'] =
							(strlen($ldm_mysearch[$nsearch]['text'])>15 ?
								substr($ldm_mysearch[$nsearch]['text'],0, 12).'...' :
								$ldm_mysearch[$nsearch]['text']);
						$keywords[] = $ldm_mysearch[$nsearch]['text'];
						$nsearch++;
					}
				}
				break;

			case 'radio':
			case 'select':

				$field = html_entity_decode($vbulletin->userinfo['field'.$myrow['profilefieldid']]);
				$ldm_mysearch[$nsearch]['profilefieldid'] = $myrow['profilefieldid'];
				$ldm_mysearch[$nsearch]['profilefieldtitle'] = $vbphrase["field".$myrow['profilefieldid']."_title"];
				$ldm_mysearch[$nsearch]['text'] = $field;
				$ldm_mysearch[$nsearch]['title'] =
					(strlen($ldm_mysearch[$nsearch]['text'])>15 ?
						substr($ldm_mysearch[$nsearch]['text'],0, 12).'...' :
						$ldm_mysearch[$nsearch]['text']);
				$keywords[] = $ldm_mysearch[$nsearch]['text'];
				$nsearch++;
				break;

			case 'select_multiple':
			case 'checkbox':

				$mask = $vbulletin->userinfo['field'.$myrow['profilefieldid']];
				$choices = unserialize($myrow['data']);
				foreach ($choices as $k=>$c) {
					$pow = pow(2,$k);
					if ($mask & $pow) {
						$field = html_entity_decode($c);
						$ldm_mysearch[$nsearch]['profilefieldid'] = $myrow['profilefieldid'];
						$ldm_mysearch[$nsearch]['profilefieldtitle'] = $vbphrase["field".$myrow['profilefieldid']."_title"];
						$ldm_mysearch[$nsearch]['text'] = $c;
						$ldm_mysearch[$nsearch]['title'] =
							(strlen($ldm_mysearch[$nsearch]['text'])>15 ?
								substr($ldm_mysearch[$nsearch]['text'],0, 12).'...' :
								$ldm_mysearch[$nsearch]['text']);
						$keywords[] = $ldm_mysearch[$nsearch]['text'];
						$nsearch++;
					}
				}
				break;

			}
		}
	}
	$vbulletin->db->free_result($asb);

	if (count($ldm_mysearch)) {
		$menu = '<tr><td class="thead" colspan="2">'.$vbphrase['ll_menu_mysearch'].'</td></tr>';
		$advmenu = '';
		foreach ($ldm_mysearch as $k=>$s) {
			$menu .=
				'<tr>'.
				'<td class="vbmenu_option" width="5">'.
				'<a href="profile.php?'.$vbulletin->session->vars['sessionurl'].'do=editprofile" title="'.$vbphrase['edit_your_details'].'">*</a>'.
				'</td><td class="vbmenu_option">';
			if ($s['text']) {
				$menu .=
				'<a href="'.SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=show&amp;mysearch='.$k.'" title="'.
					$count[$s['text']].' '.$vbphrase['ll_search'].'">'.$s['title'].'</a>';
			}
			else {
				$menu .= $s['profilefieldtitle'].' '.$vbphrase['ll_unset'];
			}
			$menu .= '</td></tr>';
			$advmenu .=
				'<option value="'.$k .'">' . $s['title'] . '</option>';
		}
		$ldm_mysearch['menu'] = $menu;
		$ldm_mysearch['advmenu'] =
			'<select class="select" name="mysearch" size="1" style="width:300px">' . $advmenu . '</select>';
	}
	else {
		$ldm_mysearch['menu'] = '';
		$ldm_mysearch['advmenu'] = '';
	}

	return $ldm_mysearch;

}

/**
* Create html for 'Saved Searches' search dropdown
*
* @return	str		Searchbit
*/

function ldm_make_mysavedsearch() {
	global $vbulletin, $vbphrase;
	global $links_defaults;
	global $SEARCH_SCRIPT;

	$menu = "";
	$editmenu = 0;
	$maxmenu = 4;
	$nummenu = 0;
	if ($links_defaults['show_searchmenu']) {
		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linkssearch
			WHERE (searchmenu=1 AND searchuserid = '".$vbulletin->userinfo['userid']."')
			OR (searchmenu=2)
			ORDER BY searchtime DESC
			");
		while ($rec=$vbulletin->db->fetch_array($asb)) {
			if ($rec['searchuserid']==$vbulletin->userinfo['userid']) {
				$editmenu = 1;
			}
			if ($nummenu<$maxmenu) {
				$menu .= '<tr>';
				$menu .= '<td class="vbmenu_option" style="width:5px;"><a href="'.$SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=search&amp;searchid='.$rec['searchid'].'" title="'.$vbphrase['ll_retrieve'].'">*</a></td>';
				$menu .= '<td class="vbmenu_option"><a href="'.SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=show&amp;searchid='.$rec['searchid'].'" title="'.$vbphrase['ll_search'].'">'.$rec['searchname'].'</a></td>';
				$menu .= '</tr>';
			}
			elseif ($nummenu==$maxmenu) {
				$menu .= '<tr>';
				$menu .= '<td class="vbmenu_option" colspan="2"><a href="'.$SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=editsearches&amp;manage=saved" title="'.$vbphrase['ll_managesearches'].'">'.$vbphrase['ll_more'].'</a></td>';
				$menu .= '</tr>';
			}
			$nummenu++;
		}
	}

	if ($menu) {
		if ($editmenu) {
			$ldm_mysearch['menu'] =
				'<tr><td class="thead" colspan="2">'.
				'<a href="'.$SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=editsearches&amp;manage=saved" title="'.$vbphrase['ll_managesearches'].'">'.$vbphrase['ll_menu_savedsearch'].'</a>'.
				'</td></tr>' .
				$menu;
		}
		else {
			$ldm_mysearch['menu'] =
				'<tr><td class="thead" colspan="2">'.
				$vbphrase['ll_menu_savedsearch'].
				'</td></tr>' .
				$menu;
		}
	}
	else {
		$ldm_mysearch['menu'] = "";
	}
	return $ldm_mysearch;
}

/**
* Extend VB profiles table to add/remove LDM profile fields
*
* @param	int		Enable/disable
*/

function ldm_patch_profile_dbtables($enable) {
	global $vbulletin, $vbphrase;

	$to_patch = array($vbphrase['ldm_recent_hits'], $vbphrase['ldm_recent_entries']);
	$txt_patch = array($vbphrase['ll_profile_showhits'], $vbphrase['ll_profile_showentries']);

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".TABLE_PREFIX."phrase
		WHERE fieldname = 'cprofilefield'
		AND varname LIKE 'field%_title'
		AND text IN ('".implode("', '", $to_patch)."')
	");

	$gotprofile = array();
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$profilefieldid[$myrow['text']] = preg_replace("/field(\d*)_title/", "$1", $myrow['varname']);
	}

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".TABLE_PREFIX."profilefield
	");

	$gotprofile = array();
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$profilefield[$myrow['profilefieldid']] = 1;
	}

	foreach ($to_patch as $thispatch) {
		if (isset($profilefieldid[$thispatch])) {
			if (!isset($profilefield[$profilefieldid[$thispatch]])) {
				$profilefieldid[$thispatch] = 0;
			}
		}
	}

	$rebuild = 0;
	$k = 0;
	while ($k<count($to_patch)) {
		if ($profilefieldid[$to_patch[$k]]) {
			$vbulletin->db->query_write("
				UPDATE ".TABLE_PREFIX."profilefield
				SET
					editable='".intval($enable)."'
				WHERE profilefieldid='".$profilefieldid[$to_patch[$k]]."'
				");
		}
		else {
			$vbulletin->db->query_write("
				INSERT INTO ".TABLE_PREFIX."profilefield
				SET
					type='input',
					data='',
					def='0',
					searchable='0',
					memberlist='1',
					form='0',
					editable='".intval($enable)."'
			");
			$id = $vbulletin->db->insert_id();
			$vbulletin->db->query_write("
				ALTER TABLE " . TABLE_PREFIX . "userfield
				ADD field$id MEDIUMTEXT NOT NULL
				");
			$vbulletin->db->query_write("
				OPTIMIZE TABLE " . TABLE_PREFIX . "userfield
				");

			$vbulletin->db->query_write("
				REPLACE INTO " . TABLE_PREFIX . "phrase
					(languageid, fieldname, varname, text, product, username, dateline, version)
				VALUES
					(
						0,
						'cprofilefield',
						'field" . $id . "_title',
						'" . $vbulletin->db->escape_string($to_patch[$k]) .  "',
						'vbulletin',
						'" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
						" . TIMENOW . ",
						'" . $vbulletin->db->escape_string($vbulletin->options['templateversion']) . "'
					),
					(
						0,
						'cprofilefield',
						'field" . $id . "_desc',
						'" . $vbulletin->db->escape_string($txt_patch[$k]) . "',
						'vbulletin',
						'" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
						" . TIMENOW . ",
						'" . $vbulletin->db->escape_string($vbulletin->options['templateversion']) . "'
					)
			");
			$rebuild = 1;
		}
		$k++;
	}

	if ($rebuild) {
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/adminfunctions_language.php');
		require_once(DIR . '/includes/adminfunctions_profilefield.php');
		build_language();
		build_profilefield_cache();
	}

}

/**
* Set up nominations timeslots
*
* @return	array	Time stamps for the start of the successive nominations time-slots, working backwards
*/

function ldm_nomination_timeslots() {
	global $vbulletin;
	global $links_defaults, $links_starred;

	require_once(DIR . '/includes/functions_misc.php');

	$starred_gather = intval($links_defaults['starred_entries_gather']);
	$now = ldm_date("Ymd", TIMENOW);

	$periodstart = array();

// Set up calculation periods
	if ($starred_gather==0) { // Month
		$periodstart[0] = vbmktime(0, 0, 0, substr($now, 4, 2) + 1, 1, substr($now, 0, 4));
		$periodstart[1] = vbmktime(0, 0, 0, substr($now, 4, 2)    , 1, substr($now, 0, 4));
		$n=1;
		while ($n<=$links_defaults['starred_entries_pastperiods']) {
			$periodstart[$n+1] = vbmktime(0, 0, 0, substr($now, 4, 2) - $n, 1, substr($now, 0, 4));
			$n+=1;
		}
	}
	elseif ($starred_gather<0) { // Year
		$periodstart[0] = vbmktime(0, 0, 0, 1, 1, substr($now, 0, 4) + 1);
		$periodstart[1] = vbmktime(0, 0, 0, 1, 1, substr($now, 0, 4)  );
		$n=1;
		while ($n<=$links_defaults['starred_entries_pastperiods']) {
			$periodstart[$n+1] = vbmktime(0, 0, 0, 1, 1, substr($now, 0, 4) - $n);
			$n+=1;
		}
	}
	else { // Specified number of days
		$periodstart[0] = 0;
		$periodstart[1] = $links_defaults['starred_entries_periodstart'];
		if ($periodstart[1]<=0) { // Assume we start today
			$periodstart[1] = vbmktime(0, 0, 0, substr($now, 4, 2), substr($now, 6, 2), substr($now, 0, 4));
		}
		else { // Wind clock forward until we're in the current period
			$periodspan = $starred_gather*24*60*60;
			while ($periodstart[1]<(TIMENOW-$periodspan)) {
				$periodstart[1]+=$periodspan;
			}
		}
		$then = ldm_date("Ymd", $periodstart[1]);
		$periodstart[0] = vbmktime(0, 0, 0, substr($then, 4, 2), substr($then, 6, 2)+$starred_gather, substr($then, 0, 4));
		$n=1;
		while ($n<=$links_defaults['starred_entries_pastperiods']) {
			$periodstart[$n+1] = vbmktime(0, 0, 0, substr($then, 4, 2), substr($then, 6, 2) - $n*$starred_gather, substr($then, 0, 4));
			$n+=1;
		}
	}

	return $periodstart;

}

/**
* Taken from includes/adminfunctions_template.php because 'including' file conflicts with other hacks
* Should be re-written to use vbulletin->stylecache, but not important since only used during admin setting/category edits
*
*/

function ldm_cache_styles($getids = false, $styleid = -1, $depth = 0) {
	global $vbulletin, $stylecache, $count;
	static $i, $cache;

	// check to see if we have already got the results from the database
	if (empty($cache)) {
		$styles = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "style
			ORDER BY displayorder
			");
		while ($style = $vbulletin->db->fetch_array($styles)) {
			$cache["$style[parentid]"]["$style[displayorder]"]["$style[styleid]"] = $style;
		}
		$vbulletin->db->free_result($styles);
	}

	// database has already been queried
	if (isset($cache["$styleid"])) {
		foreach ($cache["$styleid"] AS $holder) {
			foreach ($holder AS $style) {
				$stylecache["$style[styleid]"] = $style;
				$stylecache["$style[styleid]"]['depth'] = $depth;
				ldm_cache_styles($getids, $style['styleid'], $depth + 1);
			}
		}
	}

}

function ldm_construct_style_list($style_selected, $list_id) {
	global $vbphrase, $links_defaults, $stylecache, $stylevar;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	ldm_cache_styles();

	$stylewidth = "width:300px";
	$selectsubmit = 0;
	$stylesize = 3;

	$select_stage = 1;
	$label = $vbphrase['ll_stylelabel'];
	eval("\$optbit = \"".fetch_template('links_listselect')."\";");
	$stylename = $vbphrase['ll_usedefaultsetting'];
	$styleid = "-1";
	$stylesel = ($styleid==$style_selected ? 1 : 0);

	$select_stage = 2;
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	foreach ($stylecache as $style) {
		$styleid	= $style["styleid"];
		$stylename  = substr("------------", 0, $style["depth"]) . " " . htmlspecialchars_uni($style["title"]);
		$stylesel = ($styleid==$style_selected ? 1 : 0);
		eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	}

	$select_stage = 3;
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	return $optbit;
}

/**
* Process nominations table to determine winners in each time-slot
*
* @return	bool	Success/failure
*/

function ldm_recalc_nominations() {
	global $vbulletin;
	global $links_defaults, $links_starred;

	$periodstart = ldm_nomination_timeslots();

	$periodcount = array();
	$perioduser = array();

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linkstarred
		WHERE usertime<".TIMENOW."
		AND usertime>=".$periodstart[$links_defaults['starred_entries_pastperiods']+1]."
		ORDER BY usertime DESC
		");

	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		for ($thatperiod=1; $thatperiod<=$links_defaults['starred_entries_pastperiods']; $thatperiod++) {
			if ($myrow['usertime']>$periodstart[$thatperiod+1] and $myrow['usertime']<=$periodstart[$thatperiod]) {
				if (!isset($perioduser[$thatperiod][$myrow['userid']])) {
					$perioduser[$thatperiod][$myrow['userid']] = 1;
					$periodcount[$thatperiod][$myrow['linkid']] += 1;
				}
				continue 2;
			}
		}
	}
	$vbulletin->db->free_result($asb);

	foreach ($periodcount as $thatindex=>$thatperiod) {
		arsort($periodcount[$thatindex]);
	}

	$links_starred = array();
	for ($thiskey=1; $thiskey<=$links_defaults['starred_entries_pastperiods']; $thiskey++) {
		$date_from = ldm_date($vbulletin->options['dateformat'], $periodstart[$thiskey+1]);
		$date_to = ldm_date($vbulletin->options['dateformat'], $periodstart[$thiskey]);
		$links_starred[$thiskey] = array('scores'=>array(), 'from'=>$date_from, 'to'=>$date_to);
	}

	foreach ($periodcount as $thiskey=>$thisperiod) {
		foreach ($thisperiod as $thisid=>$thisscore) {
			if (count($links_starred[$thiskey]['scores'])<$links_defaults['starred_entries_perpast']) {
				$links_starred[$thiskey]['scores'][] = array("linkid"=>$thisid, "score"=>$thisscore);
			}
		}
	}

// Clean up
	$vbulletin->db->query_write("
		DELETE
		FROM ".THIS_TABLE."linkstarred
		WHERE usertime<".$periodstart[$links_defaults['starred_entries_pastperiods']+1]."
		");

// Update records
	$links_defaults['starred_entries_validuntil'] = $periodstart[0];
	$links_defaults['starred_entries'] = serialize($links_starred);

	ldm_update_setting(-1, 'starred_entries_validuntil', $links_defaults['starred_entries_validuntil']);
	ldm_update_setting(-1, 'starred_entries', $links_defaults['starred_entries']);

	cache_LDMadmintable(1);

	return 1;

}

// -----------------------------------------------------------------------------
// Category creation and deletion
// -----------------------------------------------------------------------------

/**
* Create category template
*
* @param	array	Category template variables
* @return	array	Category template
*/

function ldm_category_template($keysandvals) {
	global $vbulletin;
	global $links_defaults;

	$ldm_template = array(
		'catname' => '',
		'catdesc' => '',
		'cattext' => '',
		'parentid' => '',
		'parentlist' => '',
		'catforum' => $links_defaults['default_forumid'],
		'catusername' => $vbulletin->userinfo['username'],
		'catuserid' => $vbulletin->userinfo['userid'],
		'catentry' => 0,
		'catdate' => TIMENOW,
		'catmoderate' => 0,
		'catsyncdir' => '',
		'catsynctime' => 0,
		'catsyncdone' => 0,
		'displayorder' => 1,
		'catclosed' => 0,
	);

// overwrite with supplied values
	foreach ($keysandvals as $thiskey=>$thisval) {
		$ldm_template[$thiskey] = $thisval;
	}

	return $ldm_template;
}

/**
* Create category
*
* @param	array	Category template
* @return	int		Categoryid
*/

function ldm_create_category($category) {
	global $vbulletin;
	global $links_defaults, $linkscat;

	$vbulletin->db->query_write("
		INSERT INTO ".THIS_TABLE."linkscat
		SET
			catname='".$vbulletin->db->escape_string($category['catname'])."',
			catdesc='".$vbulletin->db->escape_string($category['catdesc'])."',
			cattext='".$vbulletin->db->escape_string($category['cattext'])."',
			parentid='".$category['parentid']."',
			parentlist='".$category['parentlist']."',
			catforum='".$category['catforum']."',
			catusername='".$vbulletin->db->escape_string($category['catusername'])."',
			catuserid=".$category['catuserid'].",
			catentry='".$category['catentry']."',
			catdate='".$category['catdate']."',
			catmoderate='".$category['catmoderate']."',
			catsyncdir='".$vbulletin->db->escape_string($category['catsyncdir'])."',
			catsynctime='".$category['catsynctime']."',
			catsyncdone='".$category['catsyncdone']."',
			displayorder='".intval($category['displayorder'])."',
			catclosed='".intval($category['catclosed'])."'
		");
	$catid = $vbulletin->db->insert_id();

	ldm_datastore_markdirty('ldm_cats');

	if ($catid) {
		cache_LDMcategories(1);
	}

	return $catid;
}

/**
* Empty one or more categories and optionally all its subcategories
* NB: entries that also appear in other categories remain in these categories
*
* @param	int		Category id
* @param	int		Also empty subcategories
*/

function ldm_empty_category($catid, $empty_subcats=0) {
	global $vbulletin;
	global $linkscat;

	if (!is_array($catid)) {
		$catlist = array($catid);
	}
	else {
		$catlist = $catid;
	}

	if ($empty_subcats) {
		foreach ($linkscat as $thiscat) {
			if (!isset($thiscat['catid'])) continue;
			$parentlist = explode(',',$thiscat['parentlist']);
			foreach ($catlist as $c) {
				if (in_array($c,$parentlist)) {
					$catlist[] = $thiscat['catid'];
				}
			}
		}
	}

	if (!count($catlist)) return;

	$cids = implode(',', $catlist);
	$ids = array();

	$query = "
		SELECT linkid, catid
			FROM ".THIS_TABLE."linksltoc
			WHERE catid IN (".$cids.")
		";

	$asb = $vbulletin->db->query_read($query);
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$ids[$myrow['linkid']] = $myrow['linkid'];
	}
	$vbulletin->db->free_result($asb);
	if (!count($ids)) return;

	$query = "
		DELETE FROM ".THIS_TABLE."linksltoc
			WHERE catid IN (".$cids.")
		";
	$asb = $vbulletin->db->query_write($query);

// check for links that are in multiple categories
	$query = "
		SELECT linkid, catid
			FROM ".THIS_TABLE."linksltoc
			WHERE linkid IN (".implode(',',$ids).")
		";
	$asb = $vbulletin->db->query_read($query);

	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		unset($ids[$myrow['linkid']]);
	}
	$vbulletin->db->free_result($asb);

	if (!count($ids)) return;

	ldm_delete_entry($ids);

}

/**
* Delete one or more categories and all subcategories:
* NB: Call ldm_empty_category first to remove entries
*
* @param	int		Category id
*/

function ldm_delete_category($catid) {
	global $vbulletin;
	global $linkscat;

	if (!is_array($catid)) {
		$catlist = array($catid);
	}
	else {
		$catlist = $catid;
	}

	foreach ($linkscat as $thiscat) {
		if (!isset($thiscat['catid'])) continue;
		$parentlist = explode(',',$thiscat['parentlist']);
		foreach ($catlist as $c) {
			if (in_array($c,$parentlist)) $catlist[] = $thiscat['catid'];
		}
	}

	if (!count($catlist)) return;

	$ids = implode(',', $catlist);

	require_once(DIR . '/includes/local_links_forumsinterface.php');
	foreach ($catlist as $thiscatid) {
		ldm_insert_cat_in_forum(-1, $thiscatid, $linkscat[$thiscatid]['catforumlink']);
	}

	$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linkscat
			WHERE catid IN (".$ids.")
			");

	$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linksadmin
			WHERE catid IN (".$ids.")
			");

	foreach ($catlist as $id) {
		unset($linkscat[$id]);
	}

	ldm_datastore_markdirty('ldm_cats');
	ldm_datastore_markdirty('ldm_admin');
}

// -----------------------------------------------------------------------------
// Entry creation and deletion
// -----------------------------------------------------------------------------

/**
* Create entry template
*
* @param	array	Entry template variables
* @return	array	Entry template
*/

function ldm_entry_template($keysandvals) {
	global $vbulletin;
	global $links_defaults;

	$ldm_template = array(
		'linkname' => '',
		'linkdesc' => '',
		'linkdoi' => '',
		'linkurl' => '',
		'linkfile' => '',
		'linkimg' => '',
		'linkimgthumb' => '',
		'linkimgthumbsize' => 0,
		'linkhits' => 0,
		'linkforum' => $links_defaults['default_forumid'],
		'linkcheck' => TIMENOW,
		'linksize' => 0,
		'linkstatus' => 0,
		'linkimgstatus' => 0,
		'linkdate' => TIMENOW,
		'linkusername' => $vbulletin->userinfo['username'],
		'linkuserid' => $vbulletin->userinfo['userid'],
		'linkmoderate' => 0,
		'linkreviewfreq' => 0,
	);

// overwrite with supplied values
	foreach ($keysandvals as $thiskey=>$thisval) {
		$ldm_template[$thiskey] = $thisval;
	}

	return $ldm_template;
}

/**
* Create new entry and returns array (returncode, linkid)
* For new urls, returncode = 1;
* If url already exists in database, test value of allowduplicate:
*    1:  create a new entry and return (1, newlinkid)
*    0:  do not create new entry and return (0, oldlinkid)
*   -1:  make no changes to the database and return (-1, oldlinkid)
*
*/

function ldm_create_entry($ldm_entry, $allowduplicate=1) {
	global $vbulletin;

	$insert = 1;
	$linkid = -1;

	$asb = $vbulletin->db->query_read("
		SELECT linkid FROM ".THIS_TABLE."linkslink
		WHERE linkurl='".$vbulletin->db->escape_string($ldm_entry['linkurl'])."'
		");
	$count = $vbulletin->db->num_rows($asb);
	$vbulletin->db->free_result($asb);

	if ($allowduplicate != 1 and $count) {
		$myrow = $vbulletin->db->fetch_array($asb);
		$linkid = $myrow["linkid"];
		return array($allowduplicate, $linkid);
	}

	$query = "
		INSERT INTO ".THIS_TABLE."linkslink
		SET
			linkname='".$vbulletin->db->escape_string($ldm_entry['linkname'])."',
			linkdoi='".$vbulletin->db->escape_string($ldm_entry['linkdoi'])."',
			linkurl='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $ldm_entry['linkurl']))."',
			linkfile='".$vbulletin->db->escape_string($ldm_entry['linkfile'])."',
			linkimg='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $ldm_entry['linkimg']))."',
			linkimgthumb='".$vbulletin->db->escape_string(str_replace('"', '&quot;', $ldm_entry['linkimgthumb']))."',
			linkimgthumbsize='".intval($ldm_entry['linkimgthumbsize'])."',
			linkdesc='".$vbulletin->db->escape_string($ldm_entry['linkdesc'])."',
			linkhits='".$ldm_entry['linkhits']."',
			linkforum='".intval($ldm_entry['linkforum'])."',
			linkcheck=".intval($ldm_entry['linkcheck']).",
			linksize='".intval($ldm_entry['linksize'])."',
			linkstatus='".intval($ldm_entry['linkstatus'])."',
			linkimgstatus='".intval($ldm_entry['linkimgstatus'])."',
			linkdate=".intval($ldm_entry['linkdate']).",
			linkusername='".$vbulletin->db->escape_string(htmlspecialchars_uni($ldm_entry['linkusername']))."',
			linkuserid='".intval($ldm_entry['linkuserid'])."',
			linkmoderate='".intval($ldm_entry['linkmoderate'])."',
			linkreviewfreq='".intval($ldm_entry['linkreviewfreq'])."'
		";

	$vbulletin->db->query_write($query);
	$linkid = $vbulletin->db->insert_id();

	return array(1, $linkid);

}

/**
* Insert entry into its categories
*
* @param	int		Entry id
* @param	array	Category ids
* @param	mixed	Display orders
* @param	int		? used
*/

function ldm_insert_entry_in_category($linkid, $pcatid, $displayorder=0, $moderate=0) {
	global $vbulletin;
	global $linkscat;

	foreach ($pcatid as $k=>$p) {
		$do = (is_array($displayorder) ? $displayorder[$k] : 1);
		$vbulletin->db->query_write("
			REPLACE INTO ".THIS_TABLE."linksltoc (linkid, catid, displayorder)
			VALUES ('".intval($linkid)."', '".intval($p)."', '".intval($do)."')
		");
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkscat
			SET
				catentry=catentry+1,
				catdate=".TIMENOW."
			WHERE catid='".intval($p)."'
			LIMIT 1
		");
		$linkscat[$p]['catentry']+=1;
		$linkscat[$p]['catdate']=TIMENOW;
	}

	ldm_datastore_markdirty('ldm_cats');

}

/**
* Delete one or an array of entries and tidy up
*
* @param	mixed	Entry id/ids
*/

function ldm_delete_entry($linkid) {
	global $vbulletin;
	global $LINK_UPLOAD;

	if (!is_array($linkid)) {
		$ids = $linkid;
	}
	else {
		if (count($linkid)<=0) return;
		$ids = implode(',', $linkid);
	}

	require_once(DIR . '/includes/local_links_entities.php');
	ldm_delete_entities($linkid);

	$asb = $vbulletin->db->query_read("
		SELECT linkid, linkurl
		FROM ". THIS_TABLE . "linkslink
		WHERE linkstatus=" . $LINK_UPLOAD ."
		AND linkid IN (" . $ids .")
		");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		ldm_delete_upload($rec['linkurl']);
	}
	$vbulletin->db->free_result($asb);

	$asb = $vbulletin->db->query_read("
		SELECT linkid, linkimg
		FROM ". THIS_TABLE . "linkslink
		WHERE linkimgstatus=" . $LINK_UPLOAD ."
		AND linkid IN (" . $ids .")
		");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		ldm_delete_upload($rec['linkimg']);
	}
	$vbulletin->db->free_result($asb);

	$asb = $vbulletin->db->query_read("
		SELECT linkid, linkimgthumb
		FROM ". THIS_TABLE . "linkslink
		WHERE linkimgthumb!=''
		AND linkid IN (" . $ids .")
		");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		ldm_delete_thumb($rec['linkimgthumb']);
	}
	$vbulletin->db->free_result($asb);

	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linkslink
		WHERE linkid IN (". $ids .")
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksltoc
		WHERE linkid IN (". $ids .")
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksfavs
		WHERE linkid IN (". $ids .")
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksltok
		WHERE linkid IN (". $ids .")
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksrate
		WHERE linkid IN (". $ids .")
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksentities
		WHERE linkid IN (". $ids .")
		");

}

?>