<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/


/**
* Return list of potential mirror sites for url
*
* @param	str		URL to test
* @param	array	Download mirror data structure, normally obtained by unserializing links_defaults['download_mirrors']
* @param	array	Array of mirrors with current response codes
* @return   int     Count of matching mirrors that are currently 'alive', or -1 if url does not match a mirror
*/

function ldm_mirrors($url, $download_mirrors, &$mirrors) {
	global $vbulletin;
	global $links_defaults;

// HTTP codes
	$HTTP_CODES = array(
	"0"=>"Unknown",
	"100"=>"Continue",
	"101"=>"Switching Protocols",
	"200"=>"OK",
	"201"=>"Created",
	"202"=>"Accepted",
	"203"=>"Non-Authoritative Information",
	"204"=>"No Content",
	"205"=>"Reset Content",
	"206"=>"Partial Content",
	"300"=>"Multiple Choices",
	"301"=>"Moved Permanently",
	"302"=>"Found Temporarily",
	"303"=>"See Other",
	"304"=>"Not Modified",
	"305"=>"Use Proxy",
	"307"=>"Temporary Redirect",
	"400"=>"Bad Request",
	"401"=>"Unauthorized",
	"402"=>"Payment Required",
	"404"=>"Not Found",
	"405"=>"Method Not Allowed",
	"406"=>"Not Acceptable",
	"407"=>"Proxy Authentication Required",
	"408"=>"Request Timeout",
	"409"=>"Conflict",
	"410"=>"Gone",
	"411"=>"Length Required",
	"412"=>"Precondition Failed",
	"413"=>"Request Entity Too Large",
	"414"=>"Request-URI Too Long",
	"415"=>"Unsupported Media Type",
	"416"=>"Requested Range Not Satisfiable",
	"417"=>"Expectation Failed",
	"500"=>"Internal Server Error",
	"502"=>"Bad Gateway",
	"503"=>"Service Unavailable",
	"504"=>"Gateway Timeout",
	"505"=>"HTTP Version Not Supported",
	);

	$mirrors = array();
	$alive_mirrors = 0;
	$match_mirrors = 0;

	($hook = vBulletinHook::fetch_hook('ldm_precheck_mirrors')) ? eval($hook) : false;

	foreach ($download_mirrors as $this_mirror) {
		if (!$this_mirror['active']) {
			continue;
		}
		$this_find = preg_replace("/#/", "//#", $this_mirror['find']);
		if (preg_match('#^'.$this_find.'#i', $url)) {
		    $match_mirrors++;
			$this_site = preg_replace('#^'.$this_find.'#i', $this_mirror['replace'], $url);
			$this_status = 0;
			$this_start = ldm_microtime();
			$header = ldm_fetch_headers($this_site);
			$this_end = ldm_microtime();
			if ($header !== false) {
				$nmatches = preg_match_all("/HTTP.1.. (\d\d\d)/", $header, $matches);
				if ($nmatches) {  // find the last HTTP code
					$this_status = $matches[1][$nmatches-1];
				}
			}
			if ($this_status==0) {
				$this_alive = -1;
			}
			elseif ($this_status<400) {
				$this_alive = 1;
            	$alive_mirrors++;
			}
			else {
				$this_alive = 0;
			}
			if (isset($HTTP_CODES[$this_status])) {
				$this_code = $HTTP_CODES[$this_status];
			}
			else {
				$this_code = $HTTP_CODES["0"];
			}
			$mirrors[] = array(
				'name' => $this_mirror['name'],
				'url' => $this_site,
				'status' => $this_status,
				'code' => $this_code,
				'alive' => $this_alive,
				'responsetime' => round(($this_end-$this_start)+rand(0,100)/1000, 2),
				'priority' => ($this_mirror['priority'] ? $this_mirror['priority'] : 100),
				);
		}
	}

    function ldm_mirror_cmp($a, $b) {
        if ($a['priority'] == $b['priority']) {
            if ($a['responsetime'] == $b['responsetime']) {
                return 0;
            }
            else {
                if ($a['responsetime'] < $b['responsetime']) {
                    return -1;
                }
                else {
                    return 1;
                }
            }
        }
        elseif ($a['priority'] > $b['priority']) {
            return -1;
        }
        else {
            return 1;
        }
    }

// This hook allows, e.g., adjustment of priority based on location
	($hook = vBulletinHook::fetch_hook('ldm_postcheck_mirrors')) ? eval($hook) : false;

    if ($match_mirrors) {
        usort($mirrors, "ldm_mirror_cmp");
    	return $alive_mirrors;
    }
    else {
        return -1;
    }

}


/**
* Process url to use a mirror
*
* @param	array	Download mirror data structure, normally obtained by unserializing links_defaults['download_mirrors']
* @param    int     If >0, code will autoselect best mirror
* @param	str		URL to test, updated when choice of mirror is clear
* @param	str		Error message when function returns 0
* @param	array	Array of mirrors with current response codes
* @param    int     Count of mirrors that are currently 'alive'
* @return   int     =0, error; =1, ok, url updated if appropriate; =2, ok but user needs to choose a mirror
*/

// Handle mirrors if any

function ldm_patch_url_to_mirror($download_mirrors, $forcebest, &$url, &$error, &$mirror_urls) {
    global $vbulletin, $vbphrase;

	if (!count($download_mirrors)) {
        return 1;
    }

	$alive_mirrors = ldm_mirrors($url, $download_mirrors, $mirror_urls);
	switch ($alive_mirrors) {
// url does not match a mirror
	case -1:
		return 1;

// No mirror available - error
    case 0:
		$error = standard_error($vbphrase['ll_mirrors_nonactive']);
		return 0;

// Only one mirror - force its use
	case 1:
        foreach ($mirror_urls as $mirror) {
		    if ($mirror['alive']) {
        		$url = $mirror['url'];
        		return 1;
        	}
        }
		$error = standard_error($vbphrase['ll_mirrors_nonactive']); // should never happen
        return 0;

    default:
// Check if we've been told to force use of the best mirror
		if ($forcebest) {
            foreach ($mirror_urls as $mirror) {
	    	    if ($mirror['alive']) {
            		$url = $mirror['url'];
        	    	return 1;
        	    }
            }
    		$error = standard_error($vbphrase['ll_mirrors_nonactive']);
            return 0;
		}
	}

// Fall through: several mirrors available

// Check if the user has asked to use a specific mirror
	if ($vbulletin->GPC_exists['mirror']) {
		$mirror = "";
		foreach ($mirror_urls as $thismirror) {
			if (strcasecmp($thismirror['name'], $vbulletin->GPC['mirror'])==0) {
				$mirror = $thismirror;
				break;
			}
		}
		if (!$mirror) { // can't find requested mirror
            $error = standard_error($vbphrase['ll_mirrors_badchoice']);
        	return 0;
		}
		if ($mirror['alive']) {
    		$url = $mirror['url'];
        	return 1;
        }
		$error = standard_error($vbphrase['ll_mirrors_nonactive']);
		return 0;
	}

// Several mirrors available and no directions given as to which to select.
    return 2;

}

?>