<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

// #################### View Link and its Comments/Ratings

if ($this_action == "ratelink") {

	($hook = vBulletinHook::fetch_hook('ldm_ratelink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid' 	=> TYPE_INT,
		'catid' 	=> TYPE_INT,
		'lpage' 	=> TYPE_INT,
		'rateid'	=> TYPE_INT,
		'ratesort'	=> TYPE_STR
	));

	if (!$vbulletin->GPC_exists['linkid']) {
		$vbulletin->url = $LINKS_SCRIPT.".php".$vbulletin->session->vars['sessionurl_q'];
		eval(print_standard_redirect(construct_phrase($vbphrase['ll_error_linkid'], 0),0));
		exit;
	}

	$linkid = $vbulletin->GPC['linkid'];
	$viewcatid = $vbulletin->GPC['catid'];
	$lpage = ($vbulletin->GPC_exists['lpage'] ? $vbulletin->GPC['lpage'] : 1);
	$lrate = ($vbulletin->GPC_exists['rateid'] ? $vbulletin->GPC['rateid'] : 0);
	$ratesort = ($vbulletin->GPC['ratesort'] ? $vbulletin->GPC['ratesort'] : 'd');

	$catidarray = ldm_lookup_categories($linkid);
	if (!count($catidarray)) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $linkid)));
	}

	if ($viewcatid<=0) {
		$viewcatid = $catidarray[0];
	}

	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_rating_and_comments']);

	construct_forum_jump();
	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = ldm_lookup_forum_protections($can_bypass);

	$navbits = array();
	$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_rating_and_comments'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$where[] = "link.linkid = '".$linkid."'";
	$where[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
	if ($viewcatid>0) {
		$where[] = "ltoc.catid = '".$viewcatid."'";
	}
	$query = ldm_get_mainsql($where, 0, 0, 0, "", $links_defaults['links_show_othercats'], 1);
	$template = $links_defaults["template_linkbit"];
	$template = ($ldm_linkbitcache[$template]["altbit"] ? $ldm_linkbitcache[$template]["altbit"] : $links_defaults["template_altbit"]);

	$linklistarray = array();
	$hold = $links_permissions['can_rate_link'];
	$links_permissions['can_rate_link'] = 0; // hide the ratings popup

	cache_LDMicons();
	cache_LDMnominations();

	$entrybit_options = array('showcatname'=>1, 'forcedisplayorder'=>0, 'viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid,);
	$nhits  = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $template, $query, $entrybit_options);

	$links_permissions['can_rate_link'] = $hold;
	$ncols = ($viewlinkid ? 1 : ldm_entrybit_columns($template));
	$linklistbit = ldm_map_listbit_to_grid($linklistarray, $ncols, 1);

	switch ($ratesort) {
		case 'U':
			$ratesortorder = "linkusername ASC, ltime ASC";
			break;
		case 'D':
			$ratesortorder = "ltime ASC";
			break;
		case 'd':
		default :
			$ratesortorder = "ltime DESC";
			break;
	}

	$linkcommentsbit = "";
	$thits = 0;
	$nhits = 0;
	$message = "";
	$messageusername = $vbulletin->userinfo['username'];
	$messageuserid = $vbulletin->userinfo['userid'];
	$rating = 0;

	$first = $pagenumber*$perpage - $perpage;
	$last = $first + $perpage - 1;

	$switch = 1;
	$query = "
		SELECT lrate.lrate AS lrate, lrate.linkid AS linkid, lrate.linkuserid AS linkuserid,
			lrate.linkusername AS linkusername, lrate.linkvote AS linkvote, lrate.lcomment AS lcomment, lrate.ltime AS ltime
			" . ($links_defaults['show_avatars'] ? ', user.*, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight' : "") . "
		FROM ".THIS_TABLE."linksrate AS lrate
			" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = lrate.linkuserid)" : "") . "
			" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)" : "") . "
			" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)" : "") . "
		WHERE linkid=".$linkid."
		ORDER BY ".$ratesortorder."
	";
	$asb = $vbulletin->db->query_read($query);

	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		if ($thits >= $first and $nhits <= $perpage-1) {
			$comment = ldm_parse_features($myrow['lcomment']);
			$linkuserid = $myrow["linkuserid"];
			$linkusername = $myrow["linkusername"];
			$linkvote = $myrow['linkvote'];
			$rateid = $myrow['lrate'];

			if (!$lrate and $linkuserid==$vbulletin->userinfo['userid']) {
				$rating = $myrow['linkvote'];
			}

			if ($myrow['lrate']==$lrate) {
				$message = $myrow['lcomment'];
				$messageusername = $myrow['linkusername'];
				$messageuserid = $myrow['linkuserid'];
				$rating = $myrow['linkvote'];
			}

			if (strlen($comment) > 0 or $myrow["linkuserid"]==$vbulletin->userinfo['userid'] or $LDM_environment['is_admin']) {
				if (strlen($comment) == 0) {
					$comment = $vbphrase['ll_noremark'];
				}
    			$linkavatar = ldm_get_avatarinfo($myrow);
	    		$dateandtime = ldm_date($vbulletin->options['dateformat'], $myrow['ltime']).' '.ldm_date($vbulletin->options['timeformat'], $myrow['ltime']);
            	($hook = vBulletinHook::fetch_hook('ldm_ratelink_comment')) ? eval($hook) : false;
		    	eval("\$linkcommentsbit .= \"".fetch_template('links_viewone_comment')."\";");
			    $nhits++;
			    $switch = ($switch==1 ? 2 : 1);
			}
		}
		$thits++;
	}
	$vbulletin->db->free_result($asb);

	if ($thits == 0) {
		$link_viewall_comments = $vbphrase['ll_noremark'];
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $thits, $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=ratelink&amp;catid=$catid&amp;linkid=$linkid&amp;lpage=$lpage&amp;ratesort=$ratesort", "&amp;pp=$perpage");

	$sortvar = "ratesort";
	$sortset = $ratesort;
	$sortsubmit = 1;
	$ratearray = array("action"=>"ratelink", "catid"=>$viewcatid, "linkid"=>$linkid,
						"lpage"=>$lpage, "page"=>"1", "pp"=>$perpage);
	if ($vbulletin->GPC_exists['rateid']) $ratearray["rateid"] = $lrate;
	$ratereturnbit = ldm_make_hidden_vars($ratearray);
	eval("\$ratesortbit  = \"".fetch_template('links_ratesortbit')."\";");

	$returnscript = ($viewcatid>=$BASE_CAT ? $LINKS_SCRIPT : $SEARCH_SCRIPT);

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;
	$links_permissions["can_delete_category"] = 0;

	require_once(DIR . '/includes/functions_editor.php');
	require_once(DIR . '/includes/functions_newpost.php');
	$stylevar['messagewidth'] = $stylevar['messagewidth_usercp'];

	$vbulletin->options['allowbbcode'] = $links_defaults['allow_bbcode'];
	$vbulletin->options['allowbbimagecode'] = $links_defaults['allow_images'];
	$editorid = construct_edit_toolbar($message, false, 'nonforum', $links_defaults['allow_smilies'], $links_defaults['allow_smilies']);

	($hook = vBulletinHook::fetch_hook('ldm_ratelink_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_view_all_comments')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");
	print_output($output);
	exit;

}

// #################### Report bad link

if ($this_action == "reportlink") {

	if (!$links_permissions["can_report_link"]) {
		print_no_permission();
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_reportlink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid' => TYPE_INT,
		'catid' => TYPE_INT
	));

	$linkid = $vbulletin->GPC['linkid'];
	$viewcatid = $vbulletin->GPC['catid'];

	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_report_bad_link']);
	construct_forum_jump();

	$navbits = array();
	$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
	$parentlist = $linkscat[$viewcatid["parentlist"]];
	$parentlist = array_reverse(explode(',', $parentlist));
	foreach ($parentlist AS $pid) {
		if ($pid > 0) {
			$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
		}
	}
	$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=".$viewcatid] = $linkscat[$viewcatid]["catname_clean"];
	$navbits[""] = $vbphrase['ll_report_bad_link'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$where[] = "link.linkid = '".$linkid."'";
	$query = ldm_get_mainsql($where, 0, 0, 0);

	$template = $links_defaults["template_linkbit"];
	$template = ($ldm_linkbitcache[$template]["altbit"] ? $ldm_linkbitcache[$template]["altbit"] : $links_defaults["template_altbit"]);

	$linklistarray = array();

	$entrybit_options = array('showcatname'=>1, 'viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid,);
	$nhits  = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $template, $query, $entrybit_options);

	$ncols = ($viewlinkid ? 1 : ldm_entrybit_columns($template));
	$linklistbit = ldm_map_listbit_to_grid($linklistarray, $ncols, 1);

	$linkratingspopupbit = "";
	if ($links_defaults["dropdown_comment_and_rate"]>0) {
		$linkratings = ldm_get_ratingsbits($hitids, $pagenumber, 0);
		$linkratingspopupbit = implode("", $linkratings);
	}

	$imagereg = '';
	$human_verify = '';

// Take care - VB version specific
	if (VALID_VB_VERSION=="3.7") {
    	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_contactus']) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verification =& vB_HumanVerify::fetch_library($vbulletin);
		    $human_verify = $verification->output_token();
	    }
	}
	if (VALID_VB_VERSION=="3.8") {
    	if (!$vbulletin->userinfo['userid'] AND fetch_require_hvcheck('contactus')) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verification =& vB_HumanVerify::fetch_library($vbulletin);
		    $human_verify = $verification->output_token();
	    }
	}
// Take care - VB version specific

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	($hook = vBulletinHook::fetch_hook('ldm_reportlink_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_report')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

// #################### Send email about link

if ($this_action == "sendtofriend") {

	if (!$links_permissions["can_send_tofriend"]) {
		eval(standard_error($vbphrase['ll_error_nosend']));
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_sendtofriend_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid' => TYPE_INT,
		'catid' => TYPE_INT
	));

	$linkid = $vbulletin->GPC['linkid'];
	$viewcatid = $vbulletin->GPC['catid'];

	$this_navigation_title = $master_title;
	construct_forum_jump();

	// Make Links Nav Bar
	$navbits = array();
	$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
	$parentlist = $linkscat[$viewcatid["parentlist"]];
	$parentlist = array_reverse(explode(',', $parentlist));
	foreach ($parentlist AS $pid) {
		if ($pid > 0) {
			$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
		}
	}
	$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=".$viewcatid] = $linkscat[$viewcatid]["catname_clean"];
	$navbits[""] = $vbphrase['ll_sendtofriend'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$asb = $vbulletin->db->query_read("
		SELECT link.linkforum AS linkforum, link.linkname AS linkname, link.linkdesc AS linkdesc
		FROM ".THIS_TABLE."linkslink AS link
		WHERE linkid='".$linkid."'
		LIMIT 1
		");
	unset($linkname);
	while ($jump=$vbulletin->db->fetch_array($asb)) {
		$linkforum = $jump['linkforum'];
		$linkname  = $jump['linkname'];
		$linkdesc  = $jump['linkdesc'];
	}
	$vbulletin->db->free_result($asb);
	if (!isset($linkname)) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $id)));
		exit;
	}

	if (!ldm_forumid_is_valid($linkforum)) {
		eval(standard_error($vbphrase['ll_error_unknownaccess'].' '.$id.', '.$linkforum));
		exit;
	}
	elseif ($linkforum > 0) {
		$forumperms = fetch_permissions($linkforum);
		if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) || !($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers'])) {
			print_no_permission();
			exit;
		}
	}

	$where[] = "link.linkid = '".$linkid."'";
	$query = ldm_get_mainsql($where, 0, 0, 0);

	$template = $links_defaults["template_linkbit"];
	$template = ($ldm_linkbitcache[$template]["altbit"] ? $ldm_linkbitcache[$template]["altbit"] : $links_defaults["template_altbit"]);

	$linklistarray = array();

	$entrybit_options = array('showcatname'=>1, 'viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid,);
	$nhits  = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $template, $query, $entrybit_options);
	$ncols = ($viewlinkid ? 1 : ldm_entrybit_columns($template));
	$linklistbit = ldm_map_listbit_to_grid($linklistarray, $ncols, 1);

	$linkratingspopupbit = "";
	if ($links_defaults["dropdown_comment_and_rate"]>0) {
		$linkratings = ldm_get_ratingsbits($hitids, $pagenumber, 0);
		$linkratingspopupbit = implode("", $linkratings);
	}

	$human_verify = '';

// Take care - VB version specific
	if (VALID_VB_VERSION=="3.7") {
    	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_contactus']) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verification =& vB_HumanVerify::fetch_library($vbulletin);
		    $human_verify = $verification->output_token();
	    }
	}
	if (VALID_VB_VERSION=="3.8") {
    	if (!$vbulletin->userinfo['userid'] AND fetch_require_hvcheck('contactus')) {
	    	require_once(DIR . '/includes/class_humanverify.php');
		    $verification =& vB_HumanVerify::fetch_library($vbulletin);
		    $human_verify = $verification->output_token();
	    }
	}
// Take care - VB version specific

	$title = $linkname;

	$catid = $vbulletin->GPC['catid'];
	if ($catid<=0) {
		$catidarray = ldm_lookup_categories($linkid);
		if (!count($catidarray)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $linkid)));
		}
		$catid = $catidarray[0];
	}

	$url = ldm_get_url_atag(-2, ($catid>0 ? $catid : $MY_CAT), $linkid, $linkname);
	$message = $vbphrase['ll_seethis']."\r\n\r\n"
		. $url
		. "\r\n\r\n" .$linkdesc;

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	($hook = vBulletinHook::fetch_hook('ldm_sendtofriend_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_sendemail')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

?>