<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if ($this_action == "links") {

	($hook = vBulletinHook::fetch_hook('ldm_maindisplay_begin')) ? eval($hook) : false;

	construct_forum_jump();

	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = ldm_lookup_forum_protections($can_bypass);
	$vbulletin->input->clean_array_gpc('r', array(
		'catid'	=> TYPE_INT,
		'doi' => TYPE_STR,
		'filter' => TYPE_STR,
		'keyid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'ratings' => TYPE_INT,
		'resync' => TYPE_INT,
		'sort'	=> TYPE_STR,
		));

	if ($vbulletin->GPC['linkid']) {
		$viewlinkid = $vbulletin->GPC['linkid'];
		$asb = $vbulletin->db->query_read("
				SELECT link.linkname AS linkname, ltoc.catid AS linkcatid, link.linkurl AS linkurl
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid=ltoc.linkid
				WHERE link.linkid='".$viewlinkid."'
				");
		$catids = array();
		unset($viewlinkname);
		while ($rec=$vbulletin->db->fetch_array($asb)) {
			$viewlinkname = $rec['linkname'];
			$viewlinkurl = $rec['linkurl'];
			$catids[] = $rec['linkcatid'];
		}
		$vbulletin->db->free_result($asb);
		if (!isset($viewlinkname)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $viewlinkid).
				$vbphrase['ll_goback']));
			exit;
		}
		elseif ($vbulletin->GPC['catid']) {
			if (!in_array($vbulletin->GPC['catid'], $catids)) {
				$newurl = ldm_get_url_atag(-2, $catids[0], $viewlinkid, $viewlinkname);
// implement as a 301 redirect
				@header( "HTTP/1.1 301 Moved Permanently" );
				@header( "Location: ".$newurl );
				exit;
			}
		}
		else {
			$viewlinkcatid = $catids[0];
		}
	}
	elseif ($vbulletin->GPC['doi']) {
		$viewdoi = $vbulletin->GPC['doi'];
		$rec = $vbulletin->db->query_first("
				SELECT link.linkid AS linkid, link.linkname AS linkname, ltoc.catid AS linkcatid
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid=ltoc.linkid
				WHERE link.linkdoi LIKE ('".$vbulletin->db->escape_string($viewdoi)."')
				LIMIT 1
				");
		if (!isset($rec['linkname'])) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_doi'], $viewdoi).
				$vbphrase['ll_goback']));
			exit;
		}
		$viewlinkid = $rec['linkid'];
		$viewlinkname = $rec['linkname'];
		$viewlinkcatid = $rec['linkcatid'];
	}
	else {
		$viewlinkid = 0;
	}

	if ($vbulletin->GPC['catid']) {
		$viewcatid = $vbulletin->GPC['catid'];
	}
	elseif ($viewlinkid) {
		$viewcatid = $viewlinkcatid;
	}
	else {
		$viewcatid = $BASE_CAT;
	}

	if ($vbulletin->GPC['keyid']) {
		$viewkeyid = $vbulletin->GPC['keyid'];
	}

	if (!$vbulletin->GPC['sort']) {
		$vbulletin->GPC['sort']=="";
		$sort = (isset($links_defaults['default_sort_order']) ? $links_defaults['default_sort_order'] : 'N');
	}
	else {
		$sort = $vbulletin->GPC['sort'];
	}

	$viewfilter = "";
	if ($vbulletin->GPC_exists['filter']) {
		$viewfilter = $vbulletin->GPC['filter'];
	}

// Owner can always see his categories.  Otherwise require both forum-based and LDM permission
	if (!$vbulletin->userinfo['userid'] or $vbulletin->userinfo['userid'] != $linkscat[$viewcatid]['catuserid']) {
		if (!$links_permissions['can_view_category']) {
			print_no_permission();
			exit;
		}

		if (isset($linkscat[$viewcatid]) and in_array($linkscat[$viewcatid]["catforum"], $limitfids)) {
			print_no_permission();
			exit;
		}
	}

	cache_LDMicons();

	$navbits = array();
	$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;

// Check if user has to accept site conditions...
	$ldm_accept = ldm_lookup_acceptme_form();
	if ($ldm_accept<=0) {
		$ldm_accept_vars = array();
		foreach (array('action','pp','page','catid','doi','filter','keyid','linkid','ratings','resync', 'sort') as $key) {
			if ($vbulletin->GPC_exists[$key]) {
				$ldm_accept_vars[$key] = $vbulletin->GPC[$key];
			}
		}
		$ldm_accept_hidden_vars = ldm_make_hidden_vars($ldm_accept_vars);
		$ldm_accept_script = LINKS_SCRIPT;
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
		$links_permissions['can_add_link'] = $links_permissions['can_search_quick'] = $links_permissions['can_search_link'] = 0;
		$this_navigation_title = $master_title;

		eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
		eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

		eval("\$output  = \"".fetch_template('links_header')."\";");
		eval("\$output .= \"".fetch_template('links_agreement')."\";");
		eval("\$output .= \"".fetch_template('links_footer')."\";");
		print_output($output);
		exit;
	}

	if ($viewcatid>0) {

		if (!ldm_catid_is_valid($viewcatid)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $viewcatid)));
			exit;
		}

		$viewcatforum = $linkscat["$viewcatid"]["catforum"];
		if ($viewcatforum>0) {
			$foruminfo = fetch_foruminfo($viewcatforum);
			verify_forum_password($viewcatforum, $foruminfo["password"]);
		}

		if ($links_defaults['sync_enabled'] and $linkscat[$viewcatid]['catsyncdir']) {
			require_once(DIR . '/includes/local_links_misc.php');
			$resync = $vbulletin->GPC['resync'];
			ldm_synchronise_category($viewcatid, ($resync ? $links_defaults['sync_maxcpu_allowed_manual'] : $links_defaults['sync_maxcpu_allowed']), $resync);
		}

		($hook = vBulletinHook::fetch_hook('ldm_maindisplay_title')) ? eval($hook) : false;

		$viewcatname  = ldm_parse_features($linkscat["$viewcatid"]["catname"]);
		$viewcatdesc  = ldm_parse_features($linkscat["$viewcatid"]["catdesc"]);
		$viewcattext  = ldm_parse_features($linkscat["$viewcatid"]["cattext"]);
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		if (!$viewlinkid) {
			$navbits[""] = $linkscat["$viewcatid"]["catname_clean"];
		}
		else {
			$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
			$navbits[""] = ldm_parse_features($viewlinkname);
		}
		if ($linkscat["$viewcatid"]["catforumlink"]>0 and $linkscat["$viewcatid"]["catforum"]>0) {
			$viewcatforumname = $foruminfo['title_clean'];
			$viewcatforumicon = (isset($ldm_icon_cache['forum_link']) ? ldm_get_imagebit($ldm_icon_cache['forum_link'], $vbphrase['ll_linkedforum']) : "");
		}
		else {
			$viewcatforum = "";
		}

	}
	elseif ($viewcatid == $BASE_CAT) {
		$viewcatdesc  = $viewcattext  = $viewcatforum = "";
		$viewcatname  = $master_title;
	}
	else {
		eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $viewcatid).' '.$vbphrase['ll_goback']));
		exit;
	}

	if ($viewcatid>0 and $viewlinkid>0) {
		$this_navigation_title = $master_title . ' - ' . $linkscat["$viewcatid"]["catname_clean"] . ' - ' . htmlspecialchars_uni(ldm_kill_bbcodes($viewlinkname));
	}
	elseif ($viewcatid>0) {
		$this_navigation_title = $master_title . ' - ' . $linkscat["$viewcatid"]["catname_clean"];
	}
	else {
		$this_navigation_title = $master_title;
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

// Statistics hit parades
	if ($viewcatid>0 and $links_defaults['show_hit_parade'] == 2) {
		require_once(DIR . '/includes/local_links_vbafunc.php');
		ldm_place_block(ldm_get_hitparades($viewcatid), $links_defaults['hit_parade_placement'], $links_defaults['hit_parade_placeorder']);
	}
	elseif ($viewcatid == $BASE_CAT and $links_defaults['show_hit_parade']) {
		require_once(DIR . '/includes/local_links_vbafunc.php');
		ldm_place_block(ldm_get_hitparades($BASE_CAT), $links_defaults['hit_parade_placement'], $links_defaults['hit_parade_placeorder']);
	}

// Treat viewing a single entry that has no url as a hit
	if ($vbulletin->GPC['linkid'] and !$viewlinkurl) {
		require_once(DIR . '/includes/local_links_misc.php');
		ldm_record_hit($vbulletin->GPC['linkid'], construct_phrase($vbphrase['ll_null_link'], $viewlinkname), $LINK_OK);
	}

	$linklistbit = "";
	$linklistarray = array();
	$moderatorlistbit = "";

	cache_LDMfavourites();
	cache_LDMnominations();

	if ($viewcatid>0) {

		$query = array();
		$query[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
		$query[] = "ltoc.catid = '".$viewcatid."'";

		if (!$links_permissions["can_moderate_links"] and !$links_permissions["can_moderate_forums"]) {
			if ($vbulletin->userinfo['userid'] == 0) {
				$query[] = "link.linkmoderate = $LINK_ACCEPTED";
			}
			else {
				$query[] = "(link.linkmoderate = $LINK_ACCEPTED OR
					(link.linkmoderate = $LINK_TO_MODERATE AND link.linkuserid = ".$vbulletin->userinfo['userid']."))";
			}
		}

		$showcatname = 0;
		if ($viewlinkid) {
			$query[] = "link.linkid = '".$viewlinkid."'";
			$showcatname = 1;
		}

		if (strlen($viewfilter)) {
			$query[] = "link.linkname REGEXP '^".$vbulletin->db->escape_string($viewfilter)."'";
		}

		$forcedisplayorder = 1;
		$sorder = ldm_get_sortsql($sort, 1);
		$forcedisplayorder = 0;

		$template = $links_defaults["template_linkbit"];
		$allowlinkexpand = 1;
		if ($viewlinkid or !$ldm_linkbitcache[$template]["collapse"]) {
			$allowlinkexpand = 0;
		}
		if ($viewlinkid) {
			$template = ($ldm_linkbitcache[$template]["altbit"] ? $ldm_linkbitcache[$template]["altbit"] : $links_defaults["template_altbit"]);
		}
		elseif ($allowlinkexpand and isset($vbcollapse['collapsecel_linkrefreshbit'])) {
			$template = $ldm_linkbitcache[$template]["collapse"];
		}

		if (is_numeric($sort)) {
			$sortsince = TIMENOW - $sort*24*60*60;
		}
		else {
			$sortsince = "";
		}

		$query = ldm_get_mainsql($query, $sortsince, 0, $sorder, "", $links_defaults['links_show_othercats'], 1);
		$ncols = ($viewlinkid ? 1 : ldm_entrybit_columns($template));
		$thispage = ($ncols<=1) ? $perpage : $ncols*floor(($perpage+$ncols-1)/$ncols);

		$entrybit_options = array(
			'showcatname'=>$showcatname, 'forcedisplayorder'=>$forcedisplayorder, 'forcereview'=>$links_defaults['links_jump_comment'],
			'viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid, 'sort'=>$sort,
			);
		if ($viewkeyid) {
			$entrybit_options['requirekeyid'] = $viewkeyid;
		}
		$nhits = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $template, $query, $entrybit_options, $pagenumber, $thispage);

		$linklistbit = ldm_map_listbit_to_grid($linklistarray, $ncols, 1, 'links_linkseparator', $links_defaults['cat_entry_dseq_titles']);

		$linkratingspopupbit = "";
		if ($links_defaults["dropdown_comment_and_rate"]>0) {
			$linkratings = ldm_get_ratingsbits($hitids, $pagenumber, 0);
			$linkratingspopupbit = implode("", $linkratings);
		}

		ldm_process_expired($expiredids);

		$pagenav = construct_page_nav($pagenumber, $thispage, $nhits, $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid&amp;sort=$sort".(strlen($viewfilter) ? "&amp;filter=$viewfilter" : ""), "&amp;pp=$thispage");

		if ($links_defaults['moderate_links'] and $links_defaults['show_moderators_catbit']) {
			require_once(DIR . '/includes/local_links_misc.php');
			$mod_users = ldm_lookup_userids(explode(';', $links_defaults['moderate_usernames']));
			$mods = ldm_fetch_moderators($viewcatid, $mod_users);
			$show['comma_leader'] = 0;
			foreach ($mods as $moderator) {
				eval("\$moderatorlistbit .= \"".fetch_template('forumdisplay_moderator')."\";");
				$show['comma_leader'] = 1;
			}
		}

	}

	$pcatid   = $linkscat[$viewcatid]["parentid"];
	$catstyle = 1;

	unset ($thisorder);
	$catlistarray = array();
	if (!$viewlinkid and $links_defaults['cat_show_catbit']) {

	    $is_cached = 0;
	    if ($viewcatid==$BASE_CAT) {
	        require_once(DIR . '/includes/local_links_bitcache.php');
            $pageident = "categories";
            $cachebit = "LDM_".$pageident."_".$viewcatid;
            $is_cached = ldm_fetch_cachedbit($cachebit, $catlistbit, $thiscatid);
        }

        if (!$is_cached) {
    		$catsort = (isset($links_defaults['cat_default_sort_order']) ? $links_defaults['cat_default_sort_order'] : 'N');
	    	$cattree = ldm_cat_walk($viewcatid, $links_defaults['cat_depth_display'], $catsort);
		    $cat_template = $links_defaults['template_catbit'];
    		$cat_subtitles = cache_LDMsubtitles($links_defaults['cat_sub_dseq_titles']);
	    	foreach ($cattree AS $thisid=>$thischildren) {
		    	$displayorder = $linkscat[$thisid]['displayorder'];
			    $separator_title = $cat_subtitles[$displayorder];
    			if (isset($thisorder)) {
	    			if ($thisorder!=$displayorder) {
		    			$catlistarray[] = $displayorder;
			    	}
    			}
	    		elseif ($separator_title) {
		    		$catlistarray[] = $displayorder;
			    }
    			$thisorder = $displayorder;
	    		ldm_get_categorybits($catlistarray, $cat_template, $ldm_catbitcache[$cat_template]['subbit'], $thisid, $thischildren, 0);
    		}
    		$catlistbit = ldm_map_listbit_to_grid($catlistarray, ldm_catbit_columns($cat_template), 0, 'links_linkseparator', $links_defaults['cat_sub_dseq_titles']);

    	    if ($viewcatid==$BASE_CAT) {
	            ldm_store_cachedbit($cachebit, $catlistbit, $viewcatid);
	        }
    	}

		$catfulltextpopupbit = "";
		if ($links_defaults['cat_desc_popup']) {
			$catfulltextpopupbit = ldm_get_catextdesc_popupbit($viewcatid);
		}
	}

	$linkfeatbit = "";
	$flinklistarray = array();
	if ($links_defaults['favandfeat_entries_enabled'] and $links_defaults['featured_sites'] and !$viewlinkid) {
		$feat_users = unserialize($links_defaults['featured_userid_favs']);
		if ($links_defaults['featured_usergroupid_favs']) {
			$uquery = "
				SELECT lfav.userid AS userid
				FROM ". THIS_TABLE . "linksfavs AS lfav
				LEFT JOIN ". TABLE_PREFIX . "user AS user
				ON user.userid=lfav.userid
				WHERE user.usergroupid IN (".$links_defaults['featured_usergroupid_favs'].")
				";
			$feat_usergroupids = explode(",", $links_defaults['featured_usergroupid_favs']);
			foreach ($feat_usergroupids AS $feat_usergroupid) {
				$uquery .= "
				OR FIND_IN_SET('".intval($feat_usergroupid)."', user.membergroupids)
				";
			}
			$asb = $vbulletin->db->query_read($uquery);
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$feat_users[] = $row['userid'];
			}
			$vbulletin->db->free_result($asb);
		}
		if (count($feat_users)) {
			$fquery[] = "lfav.userid IN (".implode(',', $feat_users).")";
			$fquery[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
            if ($viewcatid>0) {
			    switch ($links_defaults['featured_all_categories']) {
				case 0: // find in this category
				    $fquery[] = "ltoc.catid = " . $viewcatid;
				    break;
				case 2: // find in this category or any child
				    $childcatlist = array($viewcatid);
				    foreach ($linkscat as $thiscatid=>$thiscat) {
				        if (in_array($viewcatid, explode(',', $thiscat['parentlist']))) {
				            $childcatlist[] = $thiscatid;
				        }
				    }
				    $fquery[] = "ltoc.catid IN (" . implode(',', $childcatlist) . ")";
				    break;
				default:
				    break;
                }
			}
			$query = ldm_get_mainsql($fquery, 0, 1, "RAND()", 0, 0, 1);
			$entrybit_options = array('forcedisplayorder'=>1, 'viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid,);
			$nfhits = ldm_get_entrybits($flinklistarray, $hitids, $expiredids, $links_defaults['featured_linkbit'], $query, $entrybit_options, 1, $links_defaults['featured_sites']);
			$linkfeatbit = ldm_map_listbit_to_grid($flinklistarray, 1);
		}
	}

	$catuserid   = $linkscat[$viewcatid]["catuserid"];

	if ($vbulletin->userinfo['userid']==$catuserid) {
		$links_permissions["can_add_link"] = 1;
		$links_permissions["can_edit_category"] = 1;
	}

	$catchildren = $linkscat[$viewcatid]["childcats"];

	$catclosed = $linkscat[$viewcatid]["catclosed"];
	if ($catclosed) {
		if (!$links_permissions["can_admin_links"]) {
			$links_permissions["can_add_link"] = $links_permissions["can_edit_link"] = 0;
			$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;
		}
	}
	$catsync = $catsync_next = $catsync_last = "";
	if ($links_defaults['sync_enabled'] and $linkscat[$viewcatid]['catsyncdir']) {
		$links_permissions["can_add_link"] = 0;
		if ($linkscat[$viewcatid]['catsynctime']) {
			$catsync_last = ldm_date($vbulletin->options['dateformat'], $linkscat[$viewcatid]['catsynctime']).' '.ldm_date($vbulletin->options['timeformat'], $linkscat[$viewcatid]['catsynctime']);
		}
		else {
			$catsync_last = $vbphrase['ll_never'];
		}
		$catsync_last = construct_phrase($vbphrase['ll_synctime_last'], $catsync_last);
		if ($linkscat[$viewcatid]['catsyncdone']) {
			$catsync_done = "";
			if ($links_defaults['sync_freq']>0) {
				$catsync_next = ldm_date($vbulletin->options['dateformat'], $links_defaults['sync_freq']+$linkscat[$viewcatid]['catsynctime']).' '.ldm_date($vbulletin->options['timeformat'], $links_defaults['sync_freq']+$linkscat[$viewcatid]['catsynctime']);
				$catsync_next = construct_phrase($vbphrase['ll_synctime_next'], $catsync_next);
			}
			else {
				$catsync_next = $vbphrase['ll_synctime_manual'];
			}
		}
		else {
			$catsync_done = $vbphrase['ll_sync_notcompleted'];
			if ($links_defaults['sync_freq']<=0) {
				$catsync_next = $vbphrase['ll_synctime_manual'];
			}
		}
	}

	$sortnav = 1;
	if ($vbulletin->GPC['linkid'] or $viewcatid<0 or (!$linklistbit and !is_numeric($sort))) {
		$sortnav = 0;
	}

	if ($links_defaults['category_filter_menu'] and ($nhits or strlen($viewfilter))) {
		eval("\$linkfilterbit = \"".fetch_template('links_filter')."\";");
	}

	if ($sortnav) {
		$sortvar = "sort";
		$sortsize = 1;
		$sortset = $sort;
		$sortsubmit = 1;
		$sortreturnbit = ldm_make_hidden_vars(array("catid"=>$viewcatid, "keyid"=>$viewkeyid, "filter"=>$viewfilter, "page"=>1, "pp"=>$perpage));
		eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");
		if ($links_defaults['category_keyword_menu']) {
			$keyfilterbit = ldm_construct_keyword_list("keyid", $viewcatid, $viewkeyid);
		}
		if ($keyfilterbit) {
			$keyreturnbit = ldm_make_hidden_vars(array("catid"=>$viewcatid, "filter"=>$viewfilter, "sort"=>$sort, "page"=>1, "pp"=>$perpage));
		}
	}

	$catjumpbit = "";
	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
        $is_cached = 0;
	    if ($viewcatid==$BASE_CAT) {
	        require_once(DIR . '/includes/local_links_bitcache.php');
            $pageident = "catjump";
            $cachebit = "LDM_".$pageident."_".$viewcatid;
            $is_cached = ldm_fetch_cachedbit($cachebit, $catjumpbit, $thiscatid);
        }
        if (!$is_cached) {
            $catjumpbit = ldm_construct_category_list(array($viewcatid), "links_catjump", 0, "catid", "catid", 1);
    	    if ($viewcatid==$BASE_CAT) {
	            ldm_store_cachedbit($cachebit, $catjumpbit, $viewcatid);
	        }
        }
	}
	$allow = ldm_check_user_allowances(0);

	$viewcatautocreate = "";
	if ($links_defaults['autocreate_active'] and ($links_defaults['autocreate_forum']>0 or $linkscat['catforum']>0)) {
		$autoforum = $links_defaults['autocreate_forum']>0 ? $links_defaults['autocreate_forum'] : $linkscat['catforum'];
		$autoforuminfo = fetch_foruminfo($autoforum);
		if (isset($autoforuminfo['title_clean'])) {
			$viewcatautocreate = construct_phrase($vbphrase['ll_autocreate_forum'], $autoforuminfo['title_clean'], "forumdisplay.php?".$vbulletin->session->vars['sessionurl']."f=".$autoforum);
		}
	}

	$script = LINKS_SCRIPT;

	($hook = vBulletinHook::fetch_hook('ldm_maindisplay_end')) ? eval($hook) : false;

	eval("\$viewcatextra = \"".fetch_template('links_catbit_extras')."\";");
	$viewcatextra = ldm_strip_template($viewcatextra);

	ldm_process_placed_blocks();

	$emptylistbit = "";
	$linkerrorbit = "";

	if (count($linklistarray)==0
	    and count($flinklistarray)==0
	    and ($viewcatid>0 and count($catlistarray)==0 and $links_defaults['cat_show_catbit'])) {
		$emptylistbit = ldm_emptypage_warning($viewcatid);
	}
	elseif ($viewcatid>0 and !$nhits and $vbulletin->GPC['linkid']) {
		eval("\$linkerrorbit = \"".fetch_template('links_access_error')."\";");
	}
	elseif ($viewcatid>0 and !$nhits and is_numeric($sort)) {
		$emptylistbit = $vbphrase['ll_zerohits_sort'];
	}

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_main')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	unset($linklistarray);
	unset($catlistarray);
	unset($flinklistarray);

	print_output($output);
	exit;
}

// Embedded linkbit only, for Jukebox

if ($this_action == "iframe") {

	($hook = vBulletinHook::fetch_hook('ldm_iframe_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'sort'	=> TYPE_STR,
	));

	$linkid = $vbulletin->GPC['linkid'];
	$viewcatid = $vbulletin->GPC['catid'];

	$perpage = ($links_defaults['musicbox_files_seen'] ? $links_defaults['musicbox_files_seen'] : $perpage);

	if ($viewcatid>0) {

		$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
		$limitfids = ldm_lookup_forum_protections($can_bypass);
		$viewcatname  = ldm_parse_features($linkscat["$viewcatid"]["catname"]);

		$query = array();
		$query[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";
		$query[] = "ltoc.catid = '".$viewcatid."'";

		if ($vbulletin->userinfo['userid'] == 0) {
			$query[] = "link.linkmoderate = $LINK_ACCEPTED";
		}
		else {
			$query[] = "(link.linkmoderate = $LINK_ACCEPTED OR
				(link.linkmoderate = $LINK_TO_MODERATE AND link.linkuserid = ".$vbulletin->userinfo['userid']."))";
		}

		$sort = $vbulletin->GPC['sort'];
		if (!$sort) {
			$sort = (isset($links_defaults['musicbox_default_sort_order']) ? $links_defaults['musicbox_default_sort_order'] : 'h');
		}
		if (is_numeric($sort)) {
			$sortsince = TIMENOW - $sort*24*60*60;
		}
		else {
			$sortsince = "";
		}
		$sorder = ldm_get_sortsql($sort, 1);
		$query = ldm_get_mainsql($query, $sortsince, 0, $sorder, "", $links_defaults['links_show_othercats'], 1);

		$linklistarray = array();
		$template = $links_defaults["template_linkbit"];
		$entrybit_options = array('viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid, 'sort'=>$sort);
		$nhits = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $template, $query, $entrybit_options, $pagenumber, $perpage);
		$ncols = 1;
		$linklistbit = ldm_map_listbit_to_grid($linklistarray, $ncols, 1);

		$linkratingspopupbit = "";
		if ($links_defaults["dropdown_comment_and_rate"]>0) {
			$linkratings = ldm_get_ratingsbits($hitids, $pagenumber, 0);
			$linkratingspopupbit = implode("", $linkratings);
		}

		$pagenav = construct_page_nav($pagenumber, $perpage, $nhits, $LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=iframe&amp;linkid=$linkid&amp;catid=$viewcatid&amp;sort=$sort", "&amp;pp=$perpage");

		$sortnav = 1;
		$sortvar = "sort";
		$sortsize = 1;
		$sortset = $sort;
		$sortsubmit = 1;
		$sortreturnbit = ldm_make_hidden_vars(array("action"=>"iframe", "linkid"=>$linkid, "catid"=>$viewcatid, "page"=>1, "pp"=>$perpage));
		eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");

		$script = LINKS_SCRIPT;

		$catuserid   = $linkscat[$viewcatid]["catuserid"];
		if ($vbulletin->userinfo['userid']==$catuserid) {
			$links_permissions["can_add_link"] = 1;
		}

	}

	eval("\$output .= \"".fetch_template('links_iframed')."\";");

// we don't want the debug info to appear twice
	$vbulletin->debug = 0;
	define('DEBUG', 0);

	print_output($output);

	($hook = vBulletinHook::fetch_hook('ldm_iframe_complete')) ? eval($hook) : false;

	exit;
}

?>