<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/* ===========================================================================*/
// Action [play, download] functions
/* ===========================================================================*/

// Launch embedded media player

if ($this_action == "play") {

	require_once(DIR . '/includes/local_links_misc.php');

	if (!$links_permissions["can_play_musicbox"]) {
		print_no_permission();
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_playlink_begin')) ? eval($hook) : false;

	$time = TIMENOW;
	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_links_jukebox']);

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'entityid' => TYPE_INT,
		'player' => TYPE_STR,
		'sort'	=> TYPE_STR,
		'token'	=> TYPE_STR,
	));

// Check if user has to accept site conditions...
	$ldm_accept = ldm_lookup_acceptme_form();
	if ($ldm_accept<=0) {
		$ldm_accept_vars = array();
		foreach (array('action','catid','entityid','linkid','player','sort') as $key) {
			if ($vbulletin->GPC_exists[$key]) {
				$ldm_accept_vars[$key] = $vbulletin->GPC[$key];
			}
		}
		$ldm_accept_hidden_vars = ldm_make_hidden_vars($ldm_accept_vars);
		$ldm_accept_script = LINKS_SCRIPT;
		$navbits = array();
		$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
		$links_permissions['can_add_link'] = $links_permissions['can_search_quick'] = $links_permissions['can_search_link'] = 0;
		$this_navigation_title = $master_title;

		eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
		eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

		eval("\$output  = \"".fetch_template('links_header')."\";");
		eval("\$output .= \"".fetch_template('links_agreement')."\";");
		eval("\$output .= \"".fetch_template('links_footer')."\";");
		print_output($output);
		exit;
	}

	$entityid = 0;

	if ($vbulletin->GPC_exists['linkid']) {
		$linkid = $vbulletin->GPC['linkid'];

		if ($vbulletin->GPC_exists['entityid']) {
			$entityid = $vbulletin->GPC['entityid'];

			$query = "
				SELECT link.linkname AS linkname, link.linkdesc AS linkdesc,
					link.linkdate AS linkdate, link.linkforum AS linkforum,
					link.linkimg AS linkimg, link.linkuserid AS linkuserid,
					link.linkusername AS linkusername, link.linkuserid AS linkuserid,
					entity.entityvalue AS linkurl, entity.entityname AS entityname,
					0 AS linksize, ".$LINK_OK." AS linkstatus
					" . ($links_defaults['show_avatars'] ? ', user.*, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight' : "") . "
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksentities AS entity
				ON link.linkid = entity.linkid
					" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = link.linkuserid)" : "") . "
					" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)" : "") . "
					" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)" : "") . "
				WHERE link.linkid='".$linkid."'
				AND entity.entityid='".$entityid."'
				LIMIT 1
			";
		}
		else {
			$query = "
				SELECT link.linkurl AS linkurl, link.linkname AS linkname, link.linkdesc AS linkdesc,
					link.linkdate AS linkdate, link.linkforum AS linkforum, link.linkstatus AS linkstatus,
					link.linksize AS linksize, link.linkimg AS linkimg, link.linkuserid AS linkuserid,
					link.linkusername AS linkusername, link.linkuserid AS linkuserid, '' AS entityname
					" . ($links_defaults['show_avatars'] ? ', user.*, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight' : "") . "
				FROM ".THIS_TABLE."linkslink AS link
					" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = link.linkuserid)" : "") . "
					" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)" : "") . "
					" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)" : "") . "
				WHERE linkid='$linkid'
				LIMIT 1
			";
		}

		$asb = $vbulletin->db->query_read($query);

		unset($url);
		while ($jump=$vbulletin->db->fetch_array($asb)) {
			$url		= $jump['linkurl'];
			$linkname	= $jump['linkname'];
			$linkdesc	= $jump['linkdesc'];
			$linkdate	= $jump['linkdate'];
			$linkforum	= $jump['linkforum'];
			$linkimg	= $jump['linkimg'];
			$linkstatus	= $jump['linkstatus'];
			$linksize	= $jump['linksize'];
			$linkraters = $jump['numrate'];
			$linkuserid = $jump['linkuserid'];
			$linkusername = $jump["linkusername"];
			$linkrate = 0;
			if ($linkraters>0) {
				$linkrate = round($jump["totrate"]/$jump["numrate"]);
			}
			$linkcomments = $jump['numcomment'];
			$entityname = $jump['entityname'];
			$linkavatar = ldm_get_avatarinfo($jump);
		}
		$vbulletin->db->free_result($asb);
		if (!isset($url)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $id)));
			exit;
		}

	}
	else {
		eval(standard_error($vbphrase['ll_error_nolinkid']));
		exit;
	}

// Check security token
	if (!ldm_decrypt_authority($vbulletin->GPC['token'], $linkid, $vbulletin->GPC['catid'], $error)) {
		eval(standard_error($error));
		exit;
	}

// Check LDM category and access permission, allowing for possibility that the user is playing silly games
	$catids = ldm_lookup_categories($linkid);

	$catid = 0;
	if ($vbulletin->GPC_exists['catid']) {
		$catid = $vbulletin->GPC['catid'];
		if (!in_array($catid, $catids)) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $linkid)));
		}
	}
	if ($catid<=0) {
		if (count($catids)) {
			$catid = $catids[0];
		}
	}

	if (!ldm_catid_is_valid($catid)) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $catid)));
		exit;
	}

	$cataccessok = 0;
	foreach ($catids as $thiscatid) {
		if (ldm_lookup_permission($thiscatid, "can_access_link")) {
			$cataccessok = 1;
			break;
		}
	}
	if (!$cataccessok) {
		ldm_jump_access_error();
	}

	if (!ldm_forumid_is_valid($linkforum)) {
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkslink
			SET linkstatus=".$LINK_NO_ACCESS.", linkcheck=".TIMENOW."
			WHERE linkid='$linkid'
			LIMIT 1
		");
		eval(standard_error($vbphrase['ll_error_unknownaccess']." $linkid, $linkforum"));
		exit;

	}

	if ($linkforum > 0) {
		$forumperms = fetch_permissions($linkforum);
		if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) || !($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers'])) {
			print_no_permission();
			exit;
		}
		$foruminfo = fetch_foruminfo($linkforum);
		verify_forum_password($linkforum, $foruminfo["password"]);
	}

	if ($links_defaults['links_expiry_days']>0 and !$links_permissions['can_view_hidden']) {
		$linkexpired = 0;
		$expire = $links_defaults['links_expiry_days']*86400;
		if ($linkdate>TIMENOW) {
			ldm_jump_access_error(); // post-dated, so invisible
			exit;
		}
		elseif ($linkdate+$expire<TIMENOW) {
			ldm_jump_access_error(); // expired
			exit;
		}
	}

// Check that user is not trying another hit within timeout period
	if ($links_defaults["timeout_hit_allow"]>0) {
		$timeout = $time - $links_defaults["timeout_hit_allow"];
		$asb = $vbulletin->db->query_read("
			SELECT userid, usertime
			FROM ".THIS_TABLE."linksdownloads
			WHERE userid='".$vbulletin->userinfo['userid']."'
			AND linkid<>'".$linkid."'
			AND linkid>0
			ORDER BY usertime DESC
			LIMIT 1
		");
		while ($jump=$vbulletin->db->fetch_array($asb)) {
			$timeleft = $jump['usertime'] - $timeout;
			if ($jump['usertime'] > $timeout) {
				$wait = construct_phrase($vbphrase['ll_wait'], $timeleft, $links_defaults["timeout_hit_allow"]);
				eval(standard_error($wait));
				exit;
			}
		}
		$vbulletin->db->free_result($asb);
	}

	if ($links_permissions['must_rate_play'] and $linkuserid!=$vbulletin->userinfo['userid']) {
		$count = $vbulletin->db->query_first("
			SELECT COUNT(linkid) AS ratings
			FROM ".THIS_TABLE."linksrate
			WHERE linkuserid='".$vbulletin->userinfo['userid']."'
			AND linkid='".$linkid."'
		");
		if (!$count['ratings']) {
			eval(standard_error($vbphrase['ll_must_rate_play']));
			exit;
		}
		$vbulletin->db->free_result($asb);
	}

// Patch any variables in url
	$url = ldm_mod_rewrite($url, $catid, $linkid);

// Check that user has sufficient allowance to complete the download
	$allow = ldm_check_user_allowances( ($urlInfo['scheme'] and $ldm_protocol_schemes[$urlInfo['scheme']]['mode']!=MODE_HIDE) ? 0 : $linksize, $linkid);
	if (!$allow['can_download']) {
		eval(standard_error($allow['errormessage']));
		exit;
	}

	$urlInfo = ldm_parse_url($url);
	$dfname	= basename($urlInfo['path']);
	$type	= file_extension($dfname);

	if ($links_defaults['force_redirect'] and $links_defaults['local_file_root'] and !$urlInfo['host']) {
		eval(standard_error($vbphrase['ll_error_forceredirect']));
	}

	if ($urlInfo['scheme'] and $ldm_protocol_schemes[$urlInfo['scheme']]['mode']!=MODE_HIDE) {
		$vbulletin->url = $url;
		eval(print_standard_redirect($vbphrase['ll_redirect'],0));

	}
	else {

		$viewcatid = $catid;
		$viewlinkid = $linkid;
		$linkname	= ldm_parse_features($linkname);
		$linkdesc	= ldm_parse_features($linkdesc);

		cache_LDMicons();
		if (isset($ldm_icon_cache['jukebox'])) {
			$jukeboxpic = ldm_get_imagebit($ldm_icon_cache['jukebox'], $vbphrase['ll_links_jukebox']);
		}

		if ($links_defaults['open_musicbox_newwindow']) {
			$outertemplate = 'links_play_standalone';
			$innertemplate = 'links_playbit';
		}
		else {
			$outertemplate = 'links_play_embedded';
			$innertemplate = 'links_playbit';
		}

		($hook = vBulletinHook::fetch_hook('ldm_playme_preplaybit')) ? eval($hook) : false;

		require_once(DIR . '/includes/local_links_players.php');
		$playerbit_player = get_ldm_playerbit($linkid, $catid, $entityid, $url, $linkimg, $vbulletin->GPC['player']);
		$ldm_headtag_include .= get_ldm_playerheader($linkid, $catid, $url, $vbulletin->GPC['player']);

		if (!$playerbit_player) {
			eval(standard_error($vbphrase['ll_error_filetype']));
			exit;
		}

		cache_LDMfavourites();
		cache_LDMnominations();

		$query = ldm_get_mainsql(array("link.linkid = '".$linkid."'",));
		$ncols = ($viewlinkid ? 1 : ldm_entrybit_columns($template));
		$thispage = ($ncols<=1) ? $perpage : $ncols*floor(($perpage+$ncols-1)/$ncols);

		$entrybit_options = array(
			'showcatname'=>1, 'forcedisplayorder'=>0, 'forcereview'=>0,
			'viewlinkid'=>$viewlinkid, 'viewcatid'=>$viewcatid, 'sort'=>'N',
			);

		$links_defaults["inline_comment_and_rate"] = $links_defaults["musicbox_inline_comment_and_rate"];

		$nhits = ldm_get_entrybits($linklistarray, $hitids, $expiredids, $innertemplate, $query, $entrybit_options);

// Patch the playerbit
		$playerbit = implode("", $linklistarray);
		$playerbit = str_replace("<!--$linkid::playerbit-->", $playerbit_player, $playerbit);
		$playerbit = str_replace("<!--$linkid::playerbitextras-->", $playbit_extras, $playerbit);
		$playerbit = str_replace("<!--$linkid::jukeboxpic-->", $jukeboxpic, $playerbit);

// Record a hit (moved here in 2.2.9 because some players use the direct url)
		ldm_record_hit($linkid, $url, $LINK_OK, ldm_get_sizeof_url($url));

		if ($links_defaults['open_musicbox_newwindow']) {

			eval("\$output  = \"".fetch_template($outertemplate)."\";");

		}
		else {

			construct_forum_jump();
			$navbits = array();
			$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
			$viewcatname  = ldm_parse_features($linkscat["$catid"]["catname"]);
			$viewcatdesc  = ldm_parse_features($linkscat["$catid"]["catdesc"]);
			$viewcattext  = ldm_parse_features($linkscat["$catid"]["cattext"]);
			$parentlist = $linkscat["$catid"]["parentlist"];
			$parentlist = array_reverse(explode(',', $parentlist));
			foreach ($parentlist AS $pid) {
				if ($pid > 0) {
					$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
				}
			}
			$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$catid"] = $linkscat["$catid"]["catname_clean"];
			$navbits[""] = $linkname;

			$navbits = construct_navbits($navbits);
			eval('$navbar = "' . fetch_template('navbar') . '";');

			$script = LINKS_SCRIPT;

			$catjumpbit = "";
			if ($links_defaults['category_jump_menu']) {
				$catjumpbit = ldm_construct_category_list(array($catid), "links_catjump", 0, "catid", "catid", 1);
			}

			$links_permissions["can_add_link"] = $links_permissions["can_edit_link"] = 0;
			$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

			eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
			eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

			eval("\$output  = \"".fetch_template('links_header')."\";");
			eval("\$output .= \"".fetch_template($outertemplate)."\";");
			eval("\$output .= \"".fetch_template('links_footer')."\";");

		}

		($hook = vBulletinHook::fetch_hook('ldm_playlink_complete')) ? eval($hook) : false;

		print_output($output);

	}

	exit;
}

// Jump to link - open/download

if ($this_action == "jump") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_jumplink_begin')) ? eval($hook) : false;

	$time = TIMENOW;
	unset($url);

	if (isset($_REQUEST['id']) and !isset($_REQUEST['linkid'])) {
		$_REQUEST['linkid'] = $_REQUEST['id'];
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'linkid' => TYPE_INT,
		'entityid' => TYPE_INT,
		'doi' => TYPE_STR,
		'link' => TYPE_STR,
		'mirror' => TYPE_STR,
		'token' => TYPE_STR,
	));

// Check if user has to accept site conditions...
	$ldm_accept = ldm_lookup_acceptme_form();
	if ($ldm_accept<=0) {
		$ldm_accept_vars = array();
		foreach (array('action','catid','entityid','linkid','doi','link','mirror') as $key) {
			if ($vbulletin->GPC_exists[$key]) {
				$ldm_accept_vars[$key] = $vbulletin->GPC[$key];
			}
		}
		$ldm_accept_hidden_vars = ldm_make_hidden_vars($ldm_accept_vars);
		$ldm_accept_script = LINKS_SCRIPT;
		$navbits = array();
		$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
		$links_permissions['can_add_link'] = $links_permissions['can_search_quick'] = $links_permissions['can_search_link'] = 0;
		$this_navigation_title = $master_title;

		eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
		eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

		eval("\$output  = \"".fetch_template('links_header')."\";");
		eval("\$output .= \"".fetch_template('links_agreement')."\";");
		eval("\$output .= \"".fetch_template('links_footer')."\";");
		print_output($output);
		exit;
	}

	unset($catid);
	if ($vbulletin->GPC_exists['catid']) {
		$catid = $vbulletin->GPC['catid'];
	}

	unset($entityid);

	if ($vbulletin->GPC_exists['link']) {
		$link = preg_replace("/(['\"]*)(.*)\\1/", "\\2", $vbulletin->GPC['link']);
		if (preg_match("/(.*)\/(.*)/", $link, $match)) {
			$lname = $vbulletin->db->escape_string($match[2]);
			$cname = $vbulletin->db->escape_string($match[1]);
		}
		else {
			$lname = $vbulletin->db->escape_string($link);
			$cname = "%";
		}
		$asb = $vbulletin->db->query_read("
			SELECT link.linkid AS linkid, link.linkname AS linkname, link.linkfile AS linkfile,
				link.linkurl AS linkurl, link.linkforum AS linkforum, link.linkdate AS linkdate,
				link.linksize AS linksize, link.linkstatus AS linkstatus, link.linkuserid AS linkuserid,
				ltoc.catid AS catid, cat.catname AS catname
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON link.linkid = ltoc.linkid
			LEFT JOIN ".THIS_TABLE."linkscat AS cat
			ON ltoc.catid = cat.catid
			WHERE link.linkname LIKE '$lname' AND cat.catname LIKE '$cname'
			LIMIT 1
			");
		while ($jump=$vbulletin->db->fetch_array($asb)) {
			$url = $jump['linkurl'];
			$linkid = $jump['linkid'];
			$linkname = $jump['linkname'];
			$linkforum = $jump['linkforum'];
			$linkstatus = $jump['linkstatus'];
			$linksize = $jump['linksize'];
			$linkfile = $jump['linkfile'];
			$linkdate = $jump['linkdate'];
			$linkuserid = $jump['linkuserid'];
			if (!isset($catid)) {
				$catid = $jump['catid'];
			}
		}
		$vbulletin->db->free_result($asb);
		if (!isset($url)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $lname.'/'.$cname)));
			exit;
		}

	}
	elseif ($vbulletin->GPC_exists['doi']) {
		$viewdoi = $vbulletin->GPC['doi'];
		$jumplink = $vbulletin->db->query_read("
			SELECT link.linkid AS linkid, link.linkname AS linkname, link.linkfile AS linkfile,
				link.linkurl AS linkurl, link.linkforum AS linkforum, link.linkdate AS linkdate,
				link.linksize AS linksize, link.linkstatus AS linkstatus, link.linkuserid AS linkuserid,
				ltoc.catid AS catid
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
			ON link.linkid = ltoc.linkid
			WHERE link.linkdoi LIKE ('".$vbulletin->db->escape_string($viewdoi)."')
			LIMIT 1
			");
		while ($jump=$vbulletin->db->fetch_array($jumplink)) {
			$url = $jump['linkurl'];
			$linkid = $jump['linkid'];
			$linkname = $jump['linkname'];
			$linkforum = $jump['linkforum'];
			$linkstatus = $jump['linkstatus'];
			$linksize = $jump['linksize'];
			$linkfile = $jump['linkfile'];
			$linkdate = $jump['linkdate'];
			$linkuserid = $jump['linkuserid'];
			if (!isset($catid)) {
				$catid = $jump['catid'];
			}
		}
		if (!isset($url)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_doi'], $vbulletin->GPC['doi'])));
			exit;
		}

	}
	elseif ($vbulletin->GPC_exists['linkid']) {

		$linkid = $vbulletin->GPC['linkid'];
		if ($vbulletin->GPC_exists['entityid']) {
			$entityid = $vbulletin->GPC['entityid'];
			$query = "
				SELECT link.linkid AS linkid, link.linkname AS linkname,
					link.linkforum AS linkforum, link.linkdate AS linkdate,
					ltoc.catid AS catid,
					entity.entityvalue AS linkurl, '' AS linkfile,
					0 AS linksize, ".$LINK_OK." AS linkstatus, link.linkuserid AS linkuserid
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid = ltoc.linkid
				LEFT JOIN ".THIS_TABLE."linksentities AS entity
				ON link.linkid = entity.linkid
				WHERE link.linkid='".$linkid."'
				AND entity.entityid='".$entityid."'
				LIMIT 1
				";
		}
		else {
			$query = "
				SELECT link.linkid AS linkid, link.linkname AS linkname, link.linkfile AS linkfile,
					link.linkurl AS linkurl, link.linkforum AS linkforum, link.linkdate AS linkdate,
					link.linksize AS linksize, link.linkstatus AS linkstatus, link.linkuserid AS linkuserid,
					ltoc.catid AS catid
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid = ltoc.linkid
				WHERE link.linkid='".$linkid."'
				LIMIT 1
				";
		}

		$asb = $vbulletin->db->query_read($query);
		while ($jump=$vbulletin->db->fetch_array($asb)) {
			$url = $jump['linkurl'];
			$linkname = $jump['linkname'];
			$linkforum = $jump['linkforum'];
			$linkstatus = $jump['linkstatus'];
			$linksize = $jump['linksize'];
			$linkfile = $jump['linkfile'];
			$linkdate = $jump['linkdate'];
			$linkuserid = $jump['linkuserid'];
			if (!isset($catid)) {
				$catid = $jump['catid'];
			}
		}
		$vbulletin->db->free_result($asb);
		if (!isset($url)) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $linkid)));
			exit;
		}

	}
	else {
		eval(standard_error($vbphrase['ll_error_nolinkid']));
		exit;
	}

// Check security token
	if (!ldm_decrypt_authority($vbulletin->GPC['token'], $linkid, $catid, $error)) {
		eval(standard_error($error));
		exit;
	}

// Check LDM category access permission, allowing for possibility that the user is playing silly games
	$catids = ldm_lookup_categories($linkid);
	$cataccessok = 0;
	foreach ($catids as $thiscatid) {
		if (ldm_lookup_permission($thiscatid, "can_access_link")) {
			$cataccessok = 1;
			break;
		}
	}
	if (!$cataccessok) {
		ldm_jump_access_error();
	}

// Check LDM forum access permission
	if (!ldm_forumid_is_valid($linkforum)) {
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkslink
			SET linkstatus=".$LINK_NO_ACCESS.", linkcheck=".TIMENOW."
			WHERE linkid='".$linkid."'
			LIMIT 1
		");
		eval(standard_error($vbphrase['ll_error_unknownaccess']." ".$linkid.", ".$linkforum));
		exit;

	}

	if ($linkforum > 0 and !$links_permissions["can_bypass_forumperms"]) {
		$forumperms = fetch_permissions($linkforum);
		if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) || !($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers'])) {
			ldm_jump_access_error();
			exit;
		}
		$foruminfo = fetch_foruminfo($linkforum);
		verify_forum_password($linkforum, $foruminfo["password"]);
	}

// Check entry is visible and not expired
	if ($links_defaults['links_expiry_days']>0 and !$links_permissions['can_view_hidden']) {
		$linkexpired = 0;
		$expire = $links_defaults['links_expiry_days']*86400;
		if ($linkdate>TIMENOW) {
			ldm_jump_access_error(); // post-dated, so invisible
			exit;
		}
		elseif ($linkdate+$expire<TIMENOW) {
			ldm_jump_access_error(); // expired
			exit;
		}
	}

// Check that user is not trying another hit within timeout period
	if ($links_defaults["timeout_hit_allow"]>0) {
		$timeout = $time - $links_defaults["timeout_hit_allow"];
		$asb = $vbulletin->db->query_read("
			SELECT userid, usertime
			FROM ".THIS_TABLE."linksdownloads
			WHERE userid='".$vbulletin->userinfo['userid']."'
			AND linkid<>'".$linkid."'
			AND linkid>0
			ORDER BY usertime DESC
			LIMIT 1
		");
		while ($jump=$vbulletin->db->fetch_array($asb)) {
			$timeleft = $jump['usertime'] - $timeout;
			if ($jump['usertime'] > $timeout) {
				$wait = construct_phrase($vbphrase['ll_wait'], $timeleft, $links_defaults["timeout_hit_allow"]);
				eval(standard_error($wait));
				exit;
			}
		}
		$vbulletin->db->free_result($asb);
	}

// Check whether 'must rate first' condition
	if ($links_permissions['must_rate_download'] and $linkuserid!=$vbulletin->userinfo['userid']) {
		$count = $vbulletin->db->query_first("
			SELECT COUNT(linkid) AS ratings
			FROM ".THIS_TABLE."linksrate
			WHERE linkuserid='".$vbulletin->userinfo['userid']."'
			AND linkid='".$linkid."'
		");
		if (!$count['ratings']) {
			eval(standard_error($vbphrase['ll_must_rate_download']));
			exit;
		}
		$vbulletin->db->free_result($asb);
	}

// Got through all the hurdles, now sort out what we are trying to fetch

// Patch any variables in url
	$url = ldm_mod_rewrite($url, $catid, $linkid);

// Handle mirrors if any
	$download_mirrors = unserialize($links_defaults['download_mirrors']);
	if (count($download_mirrors)) {
	    require_once(DIR . '/includes/local_links_mirrors.php');
        $patch_mirror = ldm_patch_url_to_mirror($download_mirrors, 0, $url, $error, $mirror_urls);
        if ($patch_mirror==0) {
	    	eval(standard_error($error));
		    exit;
		}

		if ($patch_mirror==2) {
		// Present a form and ask user to choose
			$this_navigation_title = $vbphrase['ll_mirrors'];
			$mirrorbit = "";
			$checked = 1;
			foreach ($mirror_urls as $mirror_name=>$thismirror) {
				eval('$mirrorbit .= "' . fetch_template('links_mirror_select_one') . '";');
   				$checked = 0;
			}
			eval("\$output = \"".fetch_template('links_mirror_select')."\";");
			print_output($output);
			exit;
		}
	}

// Down to a single url.  Go for it...
	$urlInfo = ldm_parse_url($url);
	if ($urlInfo['scheme'] and !array_key_exists($urlInfo['scheme'], $ldm_protocol_schemes)) {
		ldm_record_hit($linkid, $url, $LINK_BROKEN);
		eval(standard_error($vbphrase['ll_error_protocol'].' '.$urlInfo['scheme']));
		exit;
	}

	$dfname   = ($linkfile ? $linkfile : basename($urlInfo['path']));
	$type	  = file_extension($dfname);
	$mimetype = ldm_get_mimetype($type);

	if ($links_defaults['force_redirect'] and $links_defaults['local_file_root'] and !$urlInfo['host']) {
		eval(standard_error($vbphrase['ll_error_forceredirect']));
	}

// Access by redirecting if:
// 		in force redirect mode
//		full url and not a known mimetype
//		qualified mimetype (a la Sourceforge)
//		local file, not a known mimetype, and neither local_file_root nor local_file_root_prefix is set

	if (	  $links_defaults["force_redirect"]
		or 	( $urlInfo['scheme'] and $ldm_protocol_schemes[$urlInfo['scheme']]['mode']==MODE_REDIRECT)
		or 	( $urlInfo['host'] and !is_array($mimetype))
		or 	  $urlInfo['query']
		or 	(!$urlInfo['host'] and !is_array($mimetype) and !$links_defaults["local_file_root"] and !$links_defaults["local_file_root_prefix"])
		) {
		$transfer_mode = MODE_REDIRECT;
	}
	else {
		$transfer_mode = MODE_OPEN;
	}

// Check allowances and keep a record of bytes transferred if:
// 		MODE_OPEN
// 		held on this server
// 		held on a mirror server

	$handle_allowances = 0;
	if (	$transfer_mode==MODE_OPEN
		or  !$urlInfo['host']
		or ($urlInfo['host']==$_SERVER["HTTP_HOST"])
		or  $mirror
		) {
		$handle_allowances = 1;
	}

	if ($handle_allowances) {
		$allow = ldm_check_user_allowances($linksize, $linkid);
		if (!$allow['can_download']) {
			eval(standard_error($allow['errormessage']));
			exit;
		}
	}

// About to start - last chance to change things...
	($hook = vBulletinHook::fetch_hook('ldm_download_begin')) ? eval($hook) : false;

	if ($transfer_mode == MODE_REDIRECT) {

		if ($handle_allowances) {
			$linksize = ldm_get_sizeof_url($url);
			ldm_record_hit($linkid, $url, $LINK_OK, $linksize);
		}
		else {
			ldm_record_hit($linkid, $url, $LINK_OK);
		}

		if ($urlInfo['user']) {
			ldm_unglue_username_and_password($urlInfo, $rawurl, $userpassword);
			if ($LDM_environment['curl_available']) {
				$conn = @curl_init();
				if ($conn) {
					@header("HTTP/1.1 200");
					@header("Expires: 0");

// Get round IE ssl cache problem
					if (strtolower($_SERVER['HTTPS'])=="https" or $_SERVER['SERVER_PORT']==443) {
						@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
					}
					else {
						@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
						@header("Pragma: no-cache"); // HTTP/1.0
					}

					@header("Pragma: no-cache"); // HTTP/1.0
					if ($type == 'htm' or $type == 'html') {
						@header("Content-type: text/html");
					}
					else {
						@header("Content-type: unknown/unknown");
					}
					@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $rawurl));
					@curl_setopt($conn, CURLOPT_USERPWD, $userpassword);
					@curl_setopt($conn, CURLOPT_FOLLOWLOCATION, true);
					@curl_setopt($conn, CURLOPT_SSL_VERIFYPEER, false);
					@curl_setopt($conn, CURLOPT_MAXREDIRS, 5);
					@curl_setopt($conn, CURLOPT_HEADER, 0);
					@curl_exec($conn);
					@curl_close($conn);
				}
				else { // otherwise we just have to try the redirect without username and password...
					$vbulletin->url = $rawurl;
					eval(print_standard_redirect($vbphrase['ll_redirect'],0));
				}
			}
		}
		else {
			$vbulletin->url = $url;
			eval(print_standard_redirect($vbphrase['ll_redirect'],0));
		}

		exit;
	}

	if ($urlInfo['host'] and !$links_defaults['allow_remote_downloads']) {
		eval(standard_error($vbphrase['ll_error_dldisable']));
		exit;
	}

	if ($urlInfo['host'] and !$LDM_environment['allow_url_fopen'] and !$LDM_environment['curl_available']) {
		eval(standard_error($vbphrase['ll_error_dldisable']));
		exit;
	}

// Recheck filesize before sending headers...
	$linksize = ldm_get_sizeof_url($url);
	$do206 = 0;
	$ilast = 0;

// Request for partial range(s) - only honour requests for a single range...
	$curr_headers = ldm_parse_headers();
	if ($linksize and isset($curr_headers['Range'])) {
		if (1==preg_match_all("/bytes\s*=\s*(\d+)\s*(\d*)/", $curr_headers['Range'], $ranges, PREG_SET_ORDER)) {
			$do206  = 1;
			$istart = $ranges[0][1];
			$iend   = $ranges[0][2];
			if (!$links_defaults['allow_http_ranges']) {
				if ($istart>0 or $iend!=$linksize) {
					@header('HTTP/1.1 404 Not Found');
					exit;
				}
			}
			if ($istart>=$linksize) {
				@header('HTTP/1.1 416 Requested Range Not Satisfiable');
				@header("Accept-Ranges: " . ($type=='pdf' or !$links_defaults['allow_http_ranges'] ? "none" : "bytes"));
				@header('Content-Range: bytes */'. $attachmentinfo['filesize']);
				exit;
			}

			if (!$iend or $iend>=$linksize) {
				$iend  = $linksize-1;
				$ilast = 1;
			}
			$ichars = $iend-$istart+1;
		}
	}

	$file = ldm_cleanto_fopen($url);
	$use_curl = 0;
	$conn = 0;
	if ($urlInfo['host'] == "") {
		$conn = @fopen($file, "rb");
	}
	elseif ($LDM_environment['curl_available']) {
		$conn = @curl_init();
		$use_curl = 1;
	}
	elseif ($LDM_environment['allow_url_fopen']) {
		$conn = @fopen($file, "rb");
	}

	if (!$conn) {
		ldm_record_hit($linkid, $url, $LINK_BROKEN);
		eval(standard_error($vbphrase['ll_error_linknotavail']));
		exit;
	}

	if (!$do206 or $ilast) {
		ldm_record_hit($linkid, $url, ($linkstatus==$LINK_UPLOAD ? $LINK_UPLOAD : $LINK_OK), $linksize);
	}

// Try to turn off php timeouts so that downloads complete correctly
	if (function_exists('set_time_limit') and !SAFEMODE) {
		@set_time_limit(0);
	}

	@ini_set('zlib.output_compression', 'Off');

	if ($do206) {
		if (SAPI_NAME == 'cgi' OR SAPI_NAME == 'cgi-fcgi') {
			header('Status: 206 Partial Content');
		}
		else {
			header('HTTP/1.1 206 Partial Content');
		}
	}
	else {
		@header("HTTP/1.1 200");
	}

	@header("Expires: 0");

// Avoid IE SSL cache problem
	if (strtolower($_SERVER['HTTPS'])=="https" or $_SERVER['SERVER_PORT']==443) {
		@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
	}
	else {
		@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
		@header("Pragma: no-cache"); // HTTP/1.0
	}

	if ($linksize>1) {
		if ($do206) {
			@header("Accept-Ranges: bytes");
			@header("Content-Range: bytes $istart-$iend/$linksize");
			@header("Content-Length: $ichars");
		}
		else {
			@header("Accept-Ranges: " . ($type=='pdf' or !$links_defaults['allow_http_ranges'] ? "none" : "bytes"));
			@header("Content-Length: $linksize");
		}
	}

	if ($type!='txt') {
		@header('Content-transfer-encoding: binary');
	}

	if ($links_defaults['force_saveas']) {
		@header("Content-type: application/x-download");
		@header("Content-disposition: attachment; filename=".str_replace(" ", "_", $dfname)."");
	}
	else {
		@header("Content-disposition: inline; filename=".str_replace(" ", "_", $dfname)."");
		if (is_array($mimetype)) {
			foreach ($mimetype AS $header) {
				@header($header);
			}
		}
		elseif ($type == 'htm' or $type == 'html') {
			@header("Content-type: text/html");
		}
		else {
			@header("Content-type: unknown/unknown");
		}
	}

	if ($use_curl) {
		if ($urlInfo['user']) {
			ldm_unglue_username_and_password($urlInfo, $rawurl, $userpassword);
			@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $rawurl));
			@curl_setopt($conn, CURLOPT_USERPWD, $userpassword);
		}
		else {
			@curl_setopt($conn, CURLOPT_URL, str_replace(" ", "%20", $url));
		}
		@curl_setopt($conn, CURLOPT_FOLLOWLOCATION, true);
		@curl_setopt($conn, CURLOPT_MAXREDIRS, 5);
		@curl_setopt($conn, CURLOPT_HEADER, 0);
		@curl_setopt($conn, CURLOPT_SSL_VERIFYPEER, false);
		@curl_setopt($conn, CURLOPT_USERAGENT, "LDM Downloader");
		if ($do206) {
			@curl_setopt($conn, CURLOPT_RANGE, "$istart-$iend");
		}
		@curl_exec($conn);
		$res = @curl_getinfo($conn);
		$bytes = $res["size_download"];
		@curl_close($conn);

	}
	else {
		$bytes = 0;
		if (!$do206) {
			$bytes = fpassthru($conn);
		}
		else {
			$jchar = 0;
			while ($jchar<$istart) {
				$nchar = (($istart-$jchar)<$READ_BUFFER_SIZE ? ($istart-$jchar) : $READ_BUFFER_SIZE);
				$contents = fread($conn, $nchar);
				$jchar += strlen($contents);
			}
			while ($jchar<$iend) {
				$nchar = (($iend-$jchar+1)<$READ_BUFFER_SIZE ? ($iend-$jchar+1) : $READ_BUFFER_SIZE);
				$contents = fread($conn, $nchar);
				echo $contents;
				$jchar += strlen($contents);
			}
			$bytes = $jchar;
		}
		flush();
		fclose($conn);
	}

	if (!$do206 or $ilast) {
		($hook = vBulletinHook::fetch_hook('ldm_download_complete')) ? eval($hook) : false;
	}

	if (is_object($vbulletin->session)) {
		$vbulletin->session->save();
	}

	exit;
}

?>