<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

// #################### Add Entry

if ($this_action == "addlink") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_addlink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'url' 			=> TYPE_STR,
		'name' 			=> TYPE_STR,
		'description' 	=> TYPE_STR,
		'catid'			=> TYPE_INT
	));

	$viewcatid = ($vbulletin->GPC_exists['catid'] ? $vbulletin->GPC['catid'] : $BASE_CAT);

	$catuserid   = $linkscat[$viewcatid]["catuserid"];
	if ($vbulletin->userinfo['userid']==$catuserid) {
		$links_permissions["can_add_link"] = 1;
	}

	if (!$links_permissions["can_add_link"]) {
		print_no_permission();
		exit;
	}

	if (!$links_permissions["can_upload_files"] and !$links_permissions["can_link_files"] and !$links_defaults['allow_null_links']) {
		eval(standard_error($vbphrase['ll_error_uploadandlink']));
		exit;
	}

	$linkurl = "";
	if ($vbulletin->GPC_exists['url']) {
		$linkurl = preg_replace("/(['\"]*)(.*)\\1/", "\\2", $vbulletin->GPC['url']);
	}
	$linkname = "";
	if ($vbulletin->GPC_exists['name']) {
		$linkname = preg_replace("/(['\"]*)(.*)\\1/", "\\2", $vbulletin->GPC['name']);
	}
	$linkdesc = "";
	if ($vbulletin->GPC_exists['description']) {
		$linkdesc = preg_replace("/(['\"]*)(.*)\\1/", "\\2", $vbulletin->GPC['description']);
	}
	$linkimg = "";
	$linkfile = "";

	$viewcatname = "";
	if (isset($linkscat[$viewcatid]["catname_clean"])) {
		$viewcatname = $linkscat[$viewcatid]["catname_clean"];
	}
	$viewlinkid  = -1;
	$linkmod  = 0;

	if ($linkscat[$viewcatid]["catclosed"] != 0 and !$links_permissions["can_admin_links"]) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_catclosed'],$linkscat[$viewcatid]["catname_clean"]).' <a href="'.$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	if (!isset($links_defaults["default_forumid"]) or
		!ldm_forumid_is_valid($links_defaults["default_forumid"])
		) {
		eval(standard_error($vbphrase['ll_error_noforum'].' <a href="'.$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$curforumid = $linkscat[$viewcatid]["catforum"];

	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_menu_addlink']);

	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = ($curforumid<=0 ? $vbphrase['ll_none'] : $vbulletin->forumcache[$curforumid][title]);

	$linkusername = $vbulletin->userinfo['username'];
	$linkdatebits = ldm_get_datetimebit(TIMENOW);

	$navbits = array();
	$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_menu_addlink'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$pcatid = array($viewcatid);
	$template = ($links_permissions["can_select_category"] ? $links_defaults["template_category_selection"].SELECT_MULTI_CAT : "links_addnewlink_catselect_hidden");
	$optbit = ldm_construct_category_list($pcatid, $template, 0, "pcatid[]", "linkcat", 1, "can_add_link", $links_permissions["can_admin_links"]);
	$expandcatlist = ($template=="links_addnewlink_catselect".SELECT_MULTI_CAT ? 1 : 0);
	$link_pcatbit = ldm_construct_parent_list($pcatid);

	if ($links_permissions['can_edit_entities']) {
		require_once(DIR . '/includes/local_links_entities.php');
		$entitybits = ldm_get_addentitybits(-1, $viewcatid, $links_permissions['can_view_hidden']);
	}

	$action = "doaddlink";

	$display_order = $links_defaults["default_link_dseq"];
	$instructions = ldm_parse_features($links_defaults["use_instructions"]);

	$haveupload = 0;
	$haveimgupload = 0;
	ldm_fetch_uploadinfo($links_defaults['upload_filetypes'], $maxupload, $mimetypes, $space_used, $space_max, $uploadinfo);
	if (!$links_defaults['upload_enabled'] or !$mimetypes) {
		$links_permissions["can_upload_files"] = 0;
	}
	eval("\$uploadbit = \"".fetch_template('links_addnewlink_upload')."\";");

	$links_permissions["can_upload_images"] = 0;
	if ($links_permissions["can_add_image"] and $links_permissions["can_upload_files"]) {
		$links_permissions["can_upload_images"] = 1;
	}

	if ($links_permissions["can_upload_images"]) {
    	ldm_fetch_uploadinfo($links_defaults['image_filetypes'], $imaxupload, $imimetypes, $ispace_used, $ispace_max, $iuploadinfo);
    }

	$keywordlistbit = ldm_get_keywordsbit();

	$links_permissions["can_add_link"] = $links_permissions["can_delete_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	$pcatid = $viewcatid;
	$linkreviewfreq = $links_defaults['link_review_freq'];
	unset($linkstatus);

	require_once(DIR . '/includes/functions_editor.php');
	require_once(DIR . '/includes/functions_newpost.php');
	$stylevar['messagewidth'] = $stylevar['messagewidth_usercp'];

	if ($links_defaults['autocreate_require_userok']) {
		if (!$links_defaults['autocreate_active']
			or ($curforumid<0 and !$links_defaults['autocreate_forum'] and !$links_permissions['can_set_permissions'])
			or $links_defaults['moderate_links']
			) {
			$links_defaults['autocreate_require_userok'] = 0;
		}
	}

	$prefix_options = "";
    $local_forum = $DEFAULT_FORUMID;
	if ($links_defaults['autocreate_require_userok'] and $links_defaults['autocreate_allow_userprefix']) {
		if ($links_defaults['autocreate_forum']) {
			$local_forum = $links_defaults['autocreate_forum'];
		}
		else {
			$local_forum = $links_defaults['default_forumid'];
		}
		if (ldm_forumid_is_valid($local_forum, false)) {
			require_once(DIR . '/includes/functions_prefix.php');
			$prefix_options = fetch_prefix_html($local_forum, $admin_settings["setting"]);
		}
	}

	$vbulletin->options['allowbbcode'] = $links_defaults['allow_bbcode'];
	$vbulletin->options['allowbbimagecode'] = $links_defaults['allow_images'];
	$editorid = construct_edit_toolbar($linkdesc, false, 'nonforum', $links_defaults['allow_smilies'], $links_defaults['allow_smilies']);

	($hook = vBulletinHook::fetch_hook('ldm_addlink_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	if ($links_defaults['forms_fullwidth']) {
		$stylevar['outertablewidth'] = $stylevar['outerdivwidth'] = "100%";
		eval('$spacer_open = "' . fetch_template('spacer_open') . '";');
		eval('$header = "' . fetch_template('header') . '";');
		eval('$footer = "' . fetch_template('footer') . '";');
	}

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewlink')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### Add Multiple Entries

if ($this_action == "addmultilink") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_addmultilink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('g', array(
		'catid'		=> TYPE_INT,
		'numadd'	=> TYPE_INT,
	));

	$viewcatid = $vbulletin->GPC_exists['catid'] ? $vbulletin->GPC['catid'] : $BASE_CAT;
	$numadd = $vbulletin->GPC['numadd'] ? min($vbulletin->GPC['numadd'], $links_defaults['allow_add_multi']) : $links_defaults['allow_add_multi'];
	$catuserid   = $linkscat[$viewcatid]["catuserid"];

	if (!$links_permissions["can_add_link"]) {
		print_no_permission();
		exit;
	}

	if (!$links_permissions["can_upload_files"] and !$links_permissions["can_link_files"] and !$links_defaults['allow_null_links']) {
		eval(standard_error($vbphrase['ll_error_uploadandlink']));
		exit;
	}

	$viewcatname = "";
	if (isset($linkscat[$viewcatid]["catname_clean"])) {
		$viewcatname = $linkscat[$viewcatid]["catname_clean"];
	}
	$viewlinkid  = -1;
	$linkmod  = 0;

	if ($linkscat[$viewcatid]["catclosed"] != 0 and !$links_permissions["can_admin_links"]) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_catclosed'],$linkscat[$viewcatid]["catname_clean"]).' <a href="'.$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	if (!isset($links_defaults["default_forumid"]) or
		!ldm_forumid_is_valid($links_defaults["default_forumid"])
		) {
		eval(standard_error($vbphrase['ll_error_noforum'].' <a href="'.$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$curforumid = $linkscat[$viewcatid]["catforum"];

	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_menu_addlink']);

	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = ($curforumid<=0 ? $vbphrase['ll_none'] : $vbulletin->forumcache[$curforumid][title]);

	$linkusername = $vbulletin->userinfo['username'];

	$navbits = array();
	$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_menu_addlink'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$pcatid = array($viewcatid);
	$template = ($links_permissions["can_select_category"] ? $links_defaults["template_category_selection"].SELECT_MULTI_CAT : "links_addnewlink_catselect_hidden");
	$optbit = ldm_construct_category_list($pcatid, $template, 0, "pcatid[]", "linkcat", 1, "can_add_link", $links_permissions["can_admin_links"]);
	$expandcatlist = ($template=="links_addnewlink_catselect".SELECT_MULTI_CAT ? 1 : 0);
	$link_pcatbit = ldm_construct_parent_list ($pcatid);

	$display_order = $links_defaults["default_link_dseq"];
	$instructions = ldm_parse_features($links_defaults["use_instructions"]);

	ldm_fetch_uploadinfo($links_defaults['upload_filetypes'], $maxupload, $mimetypes, $space_used, $space_max, $uploadinfo);

	if (!$links_defaults['upload_enabled'] or !$mimetypes) {
		$links_permissions["can_upload_files"] = 0;
	}

	$links_permissions["can_upload_images"] = 0;
	if ($links_permissions["can_add_image"] and $links_permissions["can_upload_files"]) {
		$links_permissions["can_upload_images"] = 1;
	}

	if ($links_permissions["can_upload_images"]) {
    	ldm_fetch_uploadinfo($links_defaults['image_filetypes'], $imaxupload, $imimetypes, $ispace_used, $ispace_max, $iuploadinfo);
    }

	$keywordlistbit = ldm_get_keywordsbit();

	$links_permissions["can_add_link"] = $links_permissions["can_delete_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	$pcatid = $viewcatid;
	$linkreviewfreq = $links_defaults['link_review_freq'];
	unset($linkstatus);

	if ($links_defaults['autocreate_require_userok']) {
		if (!$links_defaults['autocreate_active']
			or ($curforumid<0 and !$links_defaults['autocreate_forum'] and !$links_permissions['can_set_permissions'])
			or $links_defaults['moderate_links']
			) {
			$links_defaults['autocreate_require_userok'] = 0;
		}
	}

	$prefix_options = "";
    $local_forum = $DEFAULT_FORUMID;
	if ($links_defaults['autocreate_require_userok'] and $links_defaults['autocreate_allow_userprefix']) {
		if ($links_defaults['autocreate_forum']) {
			$local_forum = $links_defaults['autocreate_forum'];
		}
		else {
			$local_forum = $links_defaults['default_forumid'];
		}
		if (ldm_forumid_is_valid($local_forum, false)) {
			require_once(DIR . '/includes/functions_prefix.php');
			$prefix_options = fetch_prefix_html($local_forum, $admin_settings["setting"]);
		}
	}

	$linkaddmultibit = "";
	for ($linknum=1; $linknum<=$numadd; $linknum++) {
		$linkdatebits = ldm_get_datetimebit(TIMENOW, $linknum);
		eval("\$linkaddmultibit .= \"".fetch_template('links_addnewmultilink_one')."\";");
	}

	($hook = vBulletinHook::fetch_hook('ldm_addmultilink_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	if ($links_defaults['forms_fullwidth']) {
		$stylevar['outertablewidth'] = $stylevar['outerdivwidth'] = "100%";
		eval('$spacer_open = "' . fetch_template('spacer_open') . '";');
		eval('$header = "' . fetch_template('header') . '";');
		eval('$footer = "' . fetch_template('footer') . '";');
	}

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewmultilink')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### Edit Entry

if ($this_action == "editlink") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_editlink_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid' 	=> TYPE_INT,
		'catid' 	=> TYPE_INT,
	));

	$viewlinkid = $vbulletin->GPC['linkid'];
	$viewcatid  = $vbulletin->GPC['catid'];
	$viewcatname = "";
	if (isset($linkscat[$viewcatid]["catname_clean"])) {
		$viewcatname = $linkscat[$viewcatid]["catname_clean"];
	}

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linkslink
		WHERE linkid=$viewlinkid
		LIMIT 1
	");
	if ($vbulletin->db->num_rows($asb)) {
		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$linkname = htmlspecialchars_uni($myrow["linkname"]);
			$linkdoi = $myrow["linkdoi"];
			$linkurl = $myrow["linkurl"];
			$linkfile = $myrow["linkfile"];
			$linkimg = $myrow["linkimg"];
			$linkdesc = $myrow["linkdesc"];
			$linkforum = $myrow["linkforum"];
			$linkuserid	= $myrow["linkuserid"];
			$linkusername  = $myrow["linkusername"];
			$linkreviewfreq = $myrow["linkreviewfreq"];
			$linkstatus = $myrow["linkstatus"];
			$linkimgstatus = $myrow["linkimgstatus"];
			$linkdate = $myrow["linkdate"];
		}
		$vbulletin->db->free_result($asb);
	}
	else {
		eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $viewlinkid).'<br /><br /><a href="'.$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'].'">'.$vbphrase['ll_return'].'</a>'));
		exit;
	}

	if ($vbulletin->userinfo['userid']==$linkuserid) {
	    $links_permissions["can_edit_link"] = 1;
	}

	if (!isset($links_permissions["can_edit_link"]) or !$links_permissions["can_edit_link"]) {
		print_no_permission();
		exit;
	}

	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_editlink']);

	$can_expire = 0;
	if ($links_defaults['links_expiry_days']>0 and $links_defaults['links_expired_catid']>0) {
		$can_expire = 1;
	}
	$linkdatebits = ldm_get_datetimebit($linkdate, "", $can_expire);

	$navbits = array();
	$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_editlink'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$curforumid = $linkforum;
	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = ($curforumid<=0 ? $vbphrase['ll_none'] : $vbulletin->forumcache[$curforumid][title]);

	$pcatid = array();
	$asb = $vbulletin->db->query_read("
		SELECT catid FROM ".THIS_TABLE."linksltoc
		WHERE linkid=$viewlinkid
	");

	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		$pcatid[] = $myrow["catid"];
	}
	$vbulletin->db->free_result($asb);

	$template = ($links_permissions["can_select_category"] ? $links_defaults["template_category_selection"].SELECT_MULTI_CAT : "links_addnewlink_catselect_hidden");
	$optbit = ldm_construct_category_list($pcatid, $template, 0, "pcatid[]", "linkcat", 1, "can_edit_link", $links_permissions["can_admin_links"]);
	$expandcatlist = ($template=="links_addnewlink_catselect".SELECT_MULTI_CAT ? 1 : 0);
	$link_pcatbit = ldm_construct_parent_list($pcatid);

	if ($links_permissions['can_edit_entities']) {
		require_once(DIR . '/includes/local_links_entities.php');
		$entitybits = ldm_get_addentitybits($viewlinkid, $viewcatid, $links_permissions['can_view_hidden']);
	}

	$action = "doeditlink";

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linksltoc
		WHERE linkid=$viewlinkid AND catid=$viewcatid
		LIMIT 1
	");

	if ($vbulletin->db->num_rows($asb)) {
		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$display_order = $myrow["displayorder"];
		}
		$vbulletin->db->free_result($asb);
	}
	else {
		$display_order = $links_defaults["default_link_dseq"];
	}

	$instructions = ldm_parse_features($links_defaults["use_instructions"]);
	$haveupload = ($linkstatus==$LINK_UPLOAD ? 1 : 0);
	$haveimgupload = ($linkimgstatus==$LINK_UPLOAD ? 1 : 0);
	ldm_fetch_uploadinfo($links_defaults['upload_filetypes'], $maxupload, $mimetypes, $space_used, $space_max, $uploadinfo);

	if (!$links_defaults['upload_enabled'] or !$mimetypes) {
		$links_permissions["can_upload_files"] = 0;
	}
	eval("\$uploadbit = \"".fetch_template('links_addnewlink_upload')."\";");

	$links_permissions["can_upload_images"] = 0;
	if ($links_permissions["can_add_image"] and $links_permissions["can_upload_files"]) {
		$links_permissions["can_upload_images"] = 1;
	}

	if ($links_permissions["can_upload_images"]) {
    	ldm_fetch_uploadinfo($links_defaults['image_filetypes'], $imaxupload, $imimetypes, $ispace_used, $ispace_max, $iuploadinfo);
    }

	$keywordlistbit = ldm_get_keywordsbit($viewlinkid);

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;

	if ($linkuserid==$vbulletin->userinfo['userid']) {
		$links_permissions['can_delete_link'] = 1;
	}

	$pcatid = $viewcatid;

	require_once(DIR . '/includes/functions_editor.php');
	require_once(DIR . '/includes/functions_newpost.php');
	$stylevar['messagewidth'] = $stylevar['messagewidth_usercp'];

	$vbulletin->options['allowbbcode'] = $links_defaults['allow_bbcode'];
	$vbulletin->options['allowbbimagecode'] = $links_defaults['allow_images'];
	$editorid = construct_edit_toolbar($linkdesc, false, 'nonforum', $links_defaults['allow_smilies'], $links_defaults['allow_smilies']);

	$links_defaults['autocreate_require_userok'] = 0;
	$prefix_options = "";

	($hook = vBulletinHook::fetch_hook('ldm_editlink_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	if ($links_defaults['forms_fullwidth']) {
		$stylevar['outertablewidth'] = $stylevar['outerdivwidth'] = "100%";
		eval('$spacer_open = "' . fetch_template('spacer_open') . '";');
		eval('$header = "' . fetch_template('header') . '";');
		eval('$footer = "' . fetch_template('footer') . '";');
	}

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewlink')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

?>