<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

// #################### Add Category

if ($this_action == "addcat") {

	require_once(DIR . '/includes/local_links_misc.php');

	$catmod  = 0;

	if (!isset($links_permissions["can_add_category"]) or !$links_permissions["can_add_category"]) {
		print_no_permission();
		exit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_addcat_begin')) ? eval($hook) : false;

	if (!isset($links_defaults["default_forumid"]) or
		!ldm_forumid_is_valid($links_defaults["default_forumid"])
		) {
		eval(standard_error($vbphrase['ll_error_noforum'].' <a href="'.$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$viewcatid.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$forum = $curforumid = $links_defaults["default_forumid"];
	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_addcat']);
	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = ($curforumid<=0 ? $vbphrase['ll_none'] : $vbulletin->forumcache[$curforumid][title]);

	$vbulletin->input->clean_array_gpc('r', array('catid' => TYPE_INT));
	$pcatid = ($vbulletin->GPC_exists['catid'] ? $vbulletin->GPC['catid'] : $BASE_CAT);

	$template = ($links_permissions["can_select_category"] ? $links_defaults["template_category_selection"].SELECT_ONE_CAT : "links_addnewlink_catselect_hidden");
	$optbit = ldm_construct_category_list(array($pcatid), $template, 1, "pcatid", "linkcat", 1);

	$expandcatlist = ($links_defaults["template_category_selection"]=="links_addnewlink_catselect" ? 1 : 0);
	$display_order = $links_defaults["default_cat_dseq"];

	$navbits = array();
	$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
	if ($pcatid>0 and isset($linkscat[$pcatid])) {
		$parentlist = $linkscat[$pcatid]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=".$pcatid] = $linkscat[$pcatid]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_addcat'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$action	   = "doaddcat";
	$viewcatid = ($vbulletin->GPC_exists['catid'] ? $vbulletin->GPC['catid'] : $BASE_CAT);
	$catname   = "";
	$catdesc   = "";
	$cattext   = "";
	$catforumlink = 0;
	$forumname = $catname;
	$catsyncdir = "";

	$catusername  = $vbulletin->userinfo['username'];
	$catclosed = 0;

	ldm_build_settings($cat_settings, $settingjump, ($pcatid<0 ? $BASE_CAT : $pcatid), ($pcatid<0 ? $BASE_CAT : $linkscat[$pcatid]['parentlist']));
	ldm_build_permissions($cat_perms, $permjump, ($pcatid<0 ? $BASE_CAT : $pcatid), ($pcatid<0 ? $BASE_CAT : $linkscat[$pcatid]['parentlist']));

	$cat_entities = "";
	if ($links_permissions['can_set_display_order']) {
		require_once(DIR . '/includes/local_links_entities.php');
		$cat_entities = ldm_get_catentitybits($pcatid, $links_permissions['can_view_hidden']);
	}

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;
	$links_permissions["can_delete_category"] = 0;

	($hook = vBulletinHook::fetch_hook('ldm_addcat_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	if ($links_defaults['forms_fullwidth']) {
		$stylevar['outertablewidth'] = $stylevar['outerdivwidth'] = "100%";
		eval('$spacer_open = "' . fetch_template('spacer_open') . '";');
		eval('$header = "' . fetch_template('header') . '";');
		eval('$footer = "' . fetch_template('footer') . '";');
	}

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewcat')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### Edit Category

if ($this_action == "editcat") {

	require_once(DIR . '/includes/local_links_misc.php');

	($hook = vBulletinHook::fetch_hook('ldm_editcat_begin')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'mod' => TYPE_INT
	));

	$catmod  = ($vbulletin->GPC['mod']==1 ? 1 : 0); // may be moderating
	$viewcatid = $vbulletin->GPC['catid'];

	if (!ldm_catid_is_valid($viewcatid)) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $viewcatid).' <a href="'.$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'].'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$pcatid = array();

	$catname	= htmlspecialchars_uni($linkscat[$viewcatid]["catname"]);
	$catdesc	= htmlspecialchars_uni($linkscat[$viewcatid]["catdesc"]);
	$cattext	= htmlspecialchars_uni($linkscat[$viewcatid]["cattext"]);
	$pcatid[0]	= $linkscat[$viewcatid]["parentid"];
	$forum		= $linkscat[$viewcatid]["catforum"];
	$catuserid	= $linkscat[$viewcatid]["catuserid"];
	$catusername = htmlspecialchars_uni($linkscat[$viewcatid]["catusername"]);
	$catforumlink = $linkscat[$viewcatid]["catforumlink"];
	$catclosed	= $linkscat[$viewcatid]["catclosed"];
	$catsyncdir	= $linkscat[$viewcatid]["catsyncdir"];

	$forumname = ($catforumlink ? $vbulletin->forumcache[$linkscat[$viewcatid]["catforumlink"]][title] : $linkscat[$viewcatid]["catname_clean"]);

	if ($vbulletin->userinfo['userid']<>$catuserid and (!isset($links_permissions["can_edit_category"]) or !$links_permissions["can_edit_category"])) {
		print_no_permission();
		exit;
	}

	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_editcat']);

	$display_order = $linkscat[$viewcatid]["displayorder"];

	$navbits = array();
	$navbits[$LINKS_SCRIPT . '.php' . $vbulletin->session->vars['sessionurl_q']] = $master_title;
	if ($viewcatid>0 and isset($linkscat["$viewcatid"])) {
		$parentlist = $linkscat["$viewcatid"]["parentlist"];
		$parentlist = array_reverse(explode(',', $parentlist));
		foreach ($parentlist AS $pid) {
			if ($pid > 0) {
				$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$pid"] = $linkscat["$pid"]["catname_clean"];
			}
		}
		$navbits[$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=$viewcatid"] = $linkscat["$viewcatid"]["catname_clean"];
	}
	$navbits[""] = $vbphrase['ll_editcat'];

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$curforumid = $forum;
	$vbulletin->options['useforumjump'] = 1;
	construct_forum_jump();
	$curforumtitle = ($curforumid<=0 ? $vbphrase['ll_none'] : $vbulletin->forumcache[$curforumid][title]);

	$template = ($links_permissions["can_select_category"] ? $links_defaults["template_category_selection"].SELECT_ONE_CAT : "links_addnewlink_catselect_hidden");
	$optbit = ldm_construct_category_list($pcatid, $template, 1, "pcatid", "linkcat", 1);

	$expandcatlist = ($links_defaults["template_category_selection"]=="links_addnewlink_catselect" ? 1 : 0);

	$action = "doeditcat";

	ldm_build_settings($cat_settings, $settingjump, $viewcatid, $linkscat[$viewcatid]['parentlist']);
	ldm_build_permissions($cat_perms, $permjump, $viewcatid, $linkscat[$viewcatid]['parentlist']);

	$cat_entities = "";
	if ($links_permissions['can_set_display_order']) {
		require_once(DIR . '/includes/local_links_entities.php');
		$cat_entities = ldm_get_catentitybits($viewcatid, $links_permissions['can_view_hidden']);
	}

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = $links_permissions["can_edit_category"] = 0;
	$pcatid = $pcatid[0];

	($hook = vBulletinHook::fetch_hook('ldm_editcat_end')) ? eval($hook) : false;

	ldm_process_placed_blocks();

	if ($links_defaults['forms_fullwidth']) {
		$stylevar['outertablewidth'] = $stylevar['outerdivwidth'] = "100%";
		eval('$spacer_open = "' . fetch_template('spacer_open') . '";');
		eval('$header = "' . fetch_template('header') . '";');
		eval('$footer = "' . fetch_template('footer') . '";');
	}

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_addnewcat')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

?>