<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

define('THIS_VERSION', '2.3.0');
define('THIS_PRODUCT_NAME', 'eirma_ldm');
define('THIS_PRODUCT_EXTRA_NAME', 'eirma_ldm_extras');

define('LINKS_SCRIPT',  'local_links');
define('ACTION_SCRIPT', 'local_links_actions');
define('ADMIN_SCRIPT',  'local_links_admin');
define('SEARCH_SCRIPT', 'local_links_search');
define('STREAM_SCRIPT', 'local_stream');
define('RESIZE_SCRIPT', 'local_resize');

// This defines the usergroups that can access the LDM admin pages
// Usergroup 6 is the default VBulletin admininstrators' group
// If you want to give access to more than one usergroup, use a comma-separated list
// for example define('ADMIN_USER_GROUP', '5,6,7');
define('ADMIN_USER_GROUP', '6');

if ($_SERVER["DOCUMENT_ROOT"]) {
	define('LDM_DOCUMENT_ROOT', $_SERVER["DOCUMENT_ROOT"]);
}
else {
// If you are running the IIS web server in CGI mode on Windows or if otherwise warned, uncomment and edit this line
//	define('LDM_DOCUMENT_ROOT', '/path/to/your/site');
}

define('NO_REGISTER_GLOBALS', 1);

// Database Table Prefix
define('THIS_TABLE', 'local_');
// Uncomment this to use the standard VB table prefix...
// define ('THIS_TABLE', TABLE_PREFIX);

// Maximum length of user comments on links
define('MAX_COMMENT', 32000);

// Buffer size used for fread()'s -
// On Windows-based servers, increase *substantially*
if (strcasecmp(substr(@php_uname('s'),0,3),'win')==0) {
	define('READ_BUFFER', 256000);
}
else {
	define('READ_BUFFER', 32000);
}

if (isset($GLOBALS['vbulletin']->db)) {
	$vb_version = substr($vbulletin->options['templateversion'], 0, 3);
	if (version_compare($vbulletin->options['templateversion'], '3.7.0', 'ge')) {
		define('VALID_VB_VERSION', $vb_version);
	}
}

// Admin parameter ranges in database
define('ADMIN_PERMISSIONS_START', 100); // permissions
define('ADMIN_PERMISSIONS_END',	  999);
define('ADMIN_SETTINGS_START',	 1000); // settings
define('ADMIN_ADDON_START', 	25000); // rows above this value are available to add-ons
define('ADMIN_ADDON_END', 		49999);
define('ADMIN_SETTINGS_END', 	49999);
define('ADMIN_PRIVATE_START', 	50000); // rows above this are kept free for system settings
define('ADMIN_PRIVATE_END', 	65000); // the very end

define('CANDO_BOOLEAN','');

define('SELECT_MULTI_CAT', '_multi');
define('SELECT_ONE_CAT', '_one');

define('MODE_HIDE', 0);
define('MODE_REDIRECT', 1);
define('MODE_OPEN', 2);

define('ENTITY_ADMIN_GROUP', 'Administration');
define('ENTITY_TYPE_YESNO', 1);
define('ENTITY_TYPE_TEXT', 2);
define('ENTITY_TYPE_URL', 3);
define('ENTITY_TYPE_MEDIA', 5);
define('ENTITY_TYPE_UPLOAD', 6);
define('ENTITY_TYPE_MEDIAUPLOAD', 7);
define('ENTITY_TYPE_IMAGE', 8);
define('ENTITY_TYPE_IMAGEUPLOAD', 9);
define('ENTITY_TYPE_HIDDEN', 99);

define('LDM_USING_IMAGEMAGICK', 0); // set to 1 when the new imagemagick code is activated

?>