<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/* ======== Initialisation====================================================*/

ldm_general_init();
ldm_trace();

function ldm_general_init() {

	global $vbulletin, $vbphrase, $phrasegroups;
	global $LDM_environment, $ldm_protocol_schemes;
	global $links_permissions, $links_defaults, $links_usergroupids, $ldm_myprofilesearch, $ldm_mysavedsearch;
	global $linkscat, $catstyle;
	global $ldm_headtag_include, $ldm_header_include, $ldm_footer_include;
	global $ldm_mimetype_cache, $ldm_icon_cache, $ldm_linkbitcache, $ldm_catbitcache, $stylecache;
	global $links_fav, $ldm_child, $ldm_holdcat, $ldm_holdsort;
	global $ldm_toincludeinmain;
	global $ldm_extras_loaded;
	global $ldm_linkid_ratings;

	global $LINK_BROKEN, $LINK_OK, $LINK_UPLOAD, $LINK_NO_ACCESS, $LINK_NO_REMOTE_DOWNLOADS, $LINK_HIDDEN;
	global $LINK_ALL, $LINK_TO_MODERATE, $LINK_ACCEPTED, $MIN_VOTE, $MAX_VOTE;
	global $BASE_CAT, $FAVS_CAT, $HIDE_CAT, $AVL_CAT, $BRKN_CAT, $INVD_CAT, $HOT_CAT, $NEW_CAT, $RND_CAT, $MY_CAT, $UPLD_CAT, $FEAT_CAT, $NEW_RATE, $NOM_CAT, $CNOM_CAT;
	global $DEFAULT_FORUMID, $READ_BUFFER_SIZE, $UNKNOWN, $INHERIT, $CUSTOM, $STANDARD;
	global $LINKS_SCRIPT, $ACTION_SCRIPT, $ADMIN_SCRIPT, $SEARCH_SCRIPT, $STREAM_SCRIPT, $RESIZE_SCRIPT;
	global $ADMINCP_FORUMPERM_SCRIPT, $ADMINCP_ATTACH_SCRIPT, $ADMINCP_ATTACHUSERPERMS_SCRIPT;

	if (!defined('VALID_VB_VERSION')) {
		ldm_general_failure(
			"Links and Downloads Manager v.".THIS_VERSION." requires VBulletin version 3.7 or higher"
			);
	}

	if (!defined('LDM_DOCUMENT_ROOT')) {
		ldm_general_failure(
			"Document Root not set: ".
			"Refer to the <a href='http://www.eirma.org/wikis'>LDM wiki</a> for information on how to edit local_links_init.php"
			);
	}

// Link statuses
	$LINK_BROKEN				=	 0;
	$LINK_OK					=	 1;
	$LINK_UPLOAD				=	 2;
	$LINK_NO_ACCESS				=   -1;
	$LINK_NO_REMOTE_DOWNLOADS	=   -2;
	$LINK_HIDDEN				=   -3;

// Validation request statuses
	$LINK_ALL			=	 3;

// Moderation statuses
	$LINK_TO_MODERATE	=   -2;
	$LINK_ACCEPTED		=    0;

// Voting limits
	$MIN_VOTE			=	 0;
	$MAX_VOTE			=	 5;

// Special categories
	$BASE_CAT			= 	-1;
	$FAVS_CAT			=	-2;
	$HIDE_CAT			=   -3;
	$AVL_CAT			=   -4;
	$BRKN_CAT			=   -5;
	$INVD_CAT			=   -6;
	$HOT_CAT			=   -7;
	$NEW_CAT			=   -8;
	$RND_CAT			=   -9;
	$MY_CAT				=  -10;
	$UPLD_CAT			=  -11;
	$FEAT_CAT			=  -12;
	$NEW_RATE			=  -13;
	$NOM_CAT			=  -14;
	$CNOM_CAT			=  -15;

// Special Forum
	$DEFAULT_FORUMID	= -999;

// Size of chunk read from files and thrown at the user's browser
	$READ_BUFFER_SIZE   = READ_BUFFER;

// Styles used in admin settings
	$UNKNOWN  = 'class="alt1"';
	$INHERIT  = 'class="inlinemod"';
	$CUSTOM   = 'class="inlinemod"';
	$STANDARD = 'class="alt1"';

// Protocols supported
	$ldm_protocol_schemes = array(
		"http"	=> array("mode"=>MODE_HIDE, "validate"=>1, "musicbox"=>1, "savemusicbox"=>1),
		"https"	=> array("mode"=>MODE_HIDE, "validate"=>1, "musicbox"=>1, "savemusicbox"=>1),
		"ftp"	=> array("mode"=>MODE_HIDE, "validate"=>1, "musicbox"=>1, "savemusicbox"=>1),
		"irc"	=> array("mode"=>MODE_OPEN, "validate"=>0, "musicbox"=>0, "savemusicbox"=>0),
		"mms"	=> array("mode"=>MODE_HIDE, "validate"=>0, "musicbox"=>2, "savemusicbox"=>0),
	);

	$admincpdir =& $vbulletin->config['Misc']['admincpdir'];
	$ADMINCP_FORUMPERM_SCRIPT = $admincpdir.'/forumpermission.php?'.$vbulletin->session->vars['sessionurl'].'do=modify';
	$ADMINCP_ATTACH_SCRIPT = $admincpdir.'/attachment.php?'.$vbulletin->session->vars['sessionurl'].'do=types';
    $ADMINCP_ATTACHUSERPERMS_SCRIPT = $admincpdir.'/attachmentpermission.php?'.$vbulletin->session->vars['sessionurl'];

	$LINKS_SCRIPT = LINKS_SCRIPT;
	$ACTION_SCRIPT = ACTION_SCRIPT;
	$ADMIN_SCRIPT = ADMIN_SCRIPT;
	$SEARCH_SCRIPT = SEARCH_SCRIPT;
	$STREAM_SCRIPT = STREAM_SCRIPT;
	$RESIZE_SCRIPT = RESIZE_SCRIPT;

	$ldm_headtag_include = "";
	$ldm_header_include = "";
	$ldm_footer_include = "";
	$ldm_toincludeinmain = array();

	$ldm_extras_loaded = array();

	$links_usergroupids = array();
	if ($vbulletin->userinfo['membergroupids']) {
		$links_usergroupids = explode(',', $vbulletin->userinfo['membergroupids']);
	}
	$links_usergroupids[] = $vbulletin->userinfo['usergroupid'];

	$links_permissions = array();
	$links_defaults	= array();

// Moderation off by default
	$links_defaults["moderate_links"] = '0';

	$LDM_environment = array();

	$LDM_admins = ADMIN_USER_GROUP;
	$LDM_environment['is_admin'] = 0;
	if ($LDM_admins) {
		$LDM_admins = explode(',', $LDM_admins);
		foreach ($LDM_admins AS $k_admin) {
			if ($k_admin and is_member_of($vbulletin->userinfo, $k_admin)) {
				$LDM_environment['is_admin'] = 1;
				break;
			}
		}
	}

// Must cache the categories first
	cache_LDMcategories();

	if (isset($_REQUEST['catid'])) {
		$cache_catid = $_REQUEST['catid'];
	}
	else {
		$cache_catid = $BASE_CAT;
	}

	$links_defaults = cache_LDMsettings($cache_catid);
	if ($links_defaults["version_installed"] != 1) {
		eval(standard_error($vbphrase['ll_error_critical_installed'].
			'<br />'.$vbphrase['ll_error_cannotcontinue']));
		exit;
	}
	elseif ($links_defaults["this_version"] != THIS_VERSION) {
		eval(standard_error($vbphrase['ll_error_critical_version'].'<br />Software: '.THIS_VERSION.' database: '.
			$links_defaults['this_version'].'<br />'.$vbphrase['ll_error_cannotcontinue']));
		exit;
	}

	$values = cache_LDMpermissions($cache_catid);
	foreach ($values as $k=>$v) {
		$vk = explode(',', $v);
		$links_permissions[$k] = 0;
		foreach ($links_usergroupids as $i) {
			if (in_array($i, $vk)) $links_permissions[$k] = 1;
		}
	}

	$ldm_linkbitcache = cache_LDMbits($cache_catid, "define_linkbit");
	$ldm_catbitcache  = cache_LDMbits($cache_catid, "define_catbit");

	$stylecache = array();
	$catstyle = 1;

	($hook = vBulletinHook::fetch_hook('ldm_cache_built')) ? eval($hook) : false;

	$LDM_environment['allow_url_fopen']		= ini_get('allow_url_fopen');
	$LDM_environment['curl_available']		= (function_exists('curl_init') & !$links_defaults['force_fopen']);
	$LDM_environment['gd2_available']		= function_exists('imagecreatefromstring');
	$LDM_environment['post_max_size']		= ini_get('post_max_size');
	$LDM_environment['upload_max_filesize'] = ini_get('upload_max_filesize');

	$LDM_environment['user_os'] = "Unknown";
	if (strstr($_SERVER['HTTP_USER_AGENT'],"Windows")!==FALSE) {
		$LDM_environment['user_os'] = "Windows";
	}
	elseif (strstr($_SERVER['HTTP_USER_AGENT'],"Mac")!==FALSE) {
		$LDM_environment['user_os'] = "Mac";
	}
	elseif (strstr($_SERVER['HTTP_USER_AGENT'],"Linux")!==FALSE) {
		$LDM_environment['user_os'] = "Linux";
	}

	$LDM_environment['php_version'] = phpversion();
	if (version_compare($LDM_environment['php_version'], '5.0.0', 'ge')) {
		if (version_compare($LDM_environment['php_version'], '5.1.0', 'ge')) {
			$LDM_environment['cando_utf8_regex'] = 1;
		}
		else {
			$LDM_environment['cando_utf8_regex'] = 0;
		}
	}
	else {
		if (version_compare($LDM_environment['php_version'], '4.4.0', 'ge')) {
			$LDM_environment['cando_utf8_regex'] = 1;
		}
		else {
			$LDM_environment['cando_utf8_regex'] = 0;
		}
	}

	$LDM_environment['memory_limit'] = ini_get('memory_limit');

	$LDM_environment['open_basedir'] = trim(
		str_replace(PATH_SEPARATOR, PATH_SEPARATOR." ",
			str_replace(DIRECTORY_SEPARATOR, "/", ini_get('open_basedir'))
			)
		);
	if (strtolower($LDM_environment['open_basedir'])=="none") {
		$LDM_environment['open_basedir'] = "";
	}

	$LDM_environment['HOST'] = "zzz-unknown";
	$site = parse_url($vbulletin->options['homeurl']);
	if (isset($site['host'])) {
		$LDM_environment['HOST'] = "http://".$site['host'];
	}

	if (!ldm_forumid_is_valid($links_defaults["default_forumid"])) {
		if ($LDM_environment['is_admin']) {
			$vbulletin->db->query_write("
					UPDATE ".THIS_TABLE."linksadmin
					SET setting = ".$DEFAULT_FORUMID."
					WHERE settingname='default_forumid'
					LIMIT 1
				");
			eval(standard_error($vbphrase['ll_admin_critical_forum']));
			ldm_datastore_markdirty('ldm_admin');
			exit;
		}
		else {
			eval(standard_error($vbphrase['ll_error_critical_forum'].'<br />'.
					$vbphrase['ll_error_cannotcontinue']));
			exit;
		}
	}

	$LDM_environment['LDM_Version'] = THIS_VERSION;

	$links_defaults['reltag_image'] = 'rel="image"'; // default rel tag on images
	$links_defaults['reltag_media'] = 'rel="player"'; // default rel tag on media

// Admin group always has admin permissions to prevent getting locked out
	if ($LDM_environment['is_admin']) {
		$links_permissions['can_admin_links'] = 1;
	}

// Moderator privileges can also be picked up from VB forums
	$links_permissions["can_moderate_forums"] = can_moderate(0, 'canmoderateposts');

// Search permission may be restricted
	$links_permissions["can_search_quick"] = $links_permissions["can_search_link"];
// Take care - VB version specific
	if (VALID_VB_VERSION=="3.7") {
	    if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['hvcheck_search']) {
		    $links_permissions["can_search_quick"] = 0;
		}
	}
	if (VALID_VB_VERSION=="3.8") {
    	if (!$vbulletin->userinfo['userid'] AND fetch_require_hvcheck('search')) {
		    $links_permissions["can_search_quick"] = 0;
		}
	}
// Take care - VB version specific

	$ldm_myprofilesearch = array();
	if ($links_defaults['show_profilesearchmenu'] and $links_defaults['profile_searchfield'] and trim($links_defaults['profile_searchfield'])!='-1') {
		require_once(DIR . '/includes/local_links_misc.php');
		$ldm_myprofilesearch = ldm_make_myprofilesearch($links_defaults["profile_searchfield"]);
	}

	$ldm_mysavedsearch = array();
	if ($links_defaults['show_searchmenu']) {
		require_once(DIR . '/includes/local_links_misc.php');
		$ldm_mysavedsearch = ldm_make_mysavedsearch();
	}

	$ldm_mimetype_cache = array();
	$links_fav = array();
	$ldm_icon_cache = array();
	$ldm_child = array();
	$ldm_holdcat = array();
	$ldm_holdsort = 0;
	$ldm_linkid_ratings = array();

// Required for vbAdvanced
	if (!in_array('local_links', $phrasegroups)) {
		require_once(DIR . '/includes/functions_databuild.php');
		fetch_phrase_group('local_links');
	}

}

/* ======== Failure/debugging =======================================*/

function ldm_debug($text, $values) {
	global $links_defaults;
	if ($links_defaults['DEBUG']) {
		ldm_savedebug('DEBUG: '.$text, $_SERVER["PHP_SELF"], $values);
	}
}

function ldm_trace() {
	global $vbulletin, $links_defaults;
	if ($links_defaults['TRACE']) {
		ldm_savedebug('TRACE', $_SERVER["PHP_SELF"], $links_defaults);
	}
}

function ldm_savedebug($string, $command, $settings) {
	global $vbulletin;

	$vbulletin->db->query_write("
		INSERT INTO ".THIS_TABLE."linksdebug
		SET
			userid='".$vbulletin->userinfo['userid']."',
			settingtime='".TIMENOW."',
			message='".$vbulletin->db->escape_string($string)."',
			command='".$vbulletin->db->escape_string($command)."',
			settings='".$vbulletin->db->escape_string(serialize($settings))."',
			get='".$vbulletin->db->escape_string(serialize($_GET))."',
			post='".$vbulletin->db->escape_string(serialize($_POST))."',
			files='".$vbulletin->db->escape_string(serialize($_FILES))."',
			cookie='".$vbulletin->db->escape_string(serialize($_COOKIE))."'
	");

	$week = TIMENOW-3600*24*7;
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksdebug
		WHERE settingtime<'".$week."'
	");

}

function ldm_general_failure($why) {
	for ($k=1; $k<40; $k++) echo '=';
	echo "<br />Unexpected critical failure<br />";
	echo $why.'<br />';
	for ($k=1; $k<40; $k++) echo '=';
	exit;
}

function ldm_jump_access_error() {
	global $vbulletin, $show, $stylevar, $master_title;
	global $header, $footer, $headinclude, $vbphrase, $vboptions, $stylevar, $pmbox;
	global $links_permissions, $links_defaults, $LDM_environment;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT;
	global $BASE_CAT, $FAVS_CAT, $HIDE_CAT, $AVL_CAT, $BRKN_CAT, $INVD_CAT, $HOT_CAT, $NEW_CAT, $RND_CAT, $MY_CAT, $UPLD_CAT, $FEAT_CAT, $NEW_RATE, $NOM_CAT, $CNOM_CAT;

	$usergroupid = $vbulletin->userinfo['usergroupid'];

	$this_navigation_title = $master_title;
	construct_forum_jump();
	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_access_error')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

/* ======== Wrapper functions ==================================================*/

/**
* Return microtime as float, replicating PHP5 behaviour
*
* @return	float	Time
*/

function ldm_microtime() {
	list($usec, $sec) = explode(" ", microtime());
	return ((float)$usec + (float)$sec);
}

/**
* Return lower case string, using the multibyte routines if available
*
* param		str		String to convert
* @return	str		Lower case string
*/

function ldm_strtolower($str) {
	if (function_exists(mb_strtolower)) {
		return mb_strtolower($str);
	}
	else {
		return strtolower($str);
	}
}

/* ======== Wrapper on vBulletin datastore ===========================================*/

/**
* Rebuild datastore entry and mark as clean
*
* @param	str		Datastore item
* @param	mixed	Data
*/

function ldm_datastore($title, $settings) {
	global $ldm_datastore_status;
	build_datastore($title, $settings, 1);
	$ldm_datastore_status[$title] = 1;
}

/**
* Mark datastore entry dirty and empty it
*
* @param	str		Datastore item
*/

function ldm_datastore_markdirty($title) {
	global $ldm_datastore_status;
	if ($ldm_datastore_status[$title] !== 0) {
		build_datastore($title, '', 1);
	}
	$ldm_datastore_status[$title] = 0;
}

/* ======== Cache Functions ==================================================*/

/**
* Cache admin table (settings, permissions, linkbits, entities, etc), using datastore if available
*
* @param	bool	Force recache
*/

function cache_LDMadmintable($force_recache=0) {
	global $vbulletin;
	global $ldm_master_settings;

	if (isset($ldm_master_settings) and !$force_recache) {
		return;
	}

	if (is_array($vbulletin->ldm_admin) and !$force_recache) {
		$ldm_master_settings = $vbulletin->ldm_admin;
		return;
	}

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linksadmin
		ORDER BY sequence
	");
	while ($admin_settings = $vbulletin->db->fetch_array($asb)) {
		$settingname = $admin_settings["settingname"];
		$catid = $admin_settings["catid"];
		$ldm_master_settings[$settingname][$catid] = $admin_settings;
	}

	ldm_datastore('ldm_admin', serialize($ldm_master_settings));

	$vbulletin->db->free_result($asb);

}

/**
* Extract selected LDM settings from admin cache
*
* @param	int		Category, -1 = base
* @param	bool	Force recache
*/

function cache_LDMsettings($catid, $force_recache=0) {
	global $vbulletin;
	global $linkscat, $ldm_master_settings;

	cache_LDMadmintable($force_recache);

	if (isset($linkscat[$catid]['parentlist'])) {
		$parentlist = $catid.", ".$linkscat[$catid]['parentlist'];
	}
	else {
		$parentlist = "-1";
	}
	$parentlist = preg_replace("/\s/", "", $parentlist);

	$cat_choice = explode(',', $parentlist);
	foreach ($ldm_master_settings as $this_set) {
		foreach ($cat_choice as $c_catid) {
			if (isset($this_set[$c_catid])) {
				if (
					$this_set[$c_catid]["rowtype"]!="usergroup_check" and
					$this_set[$c_catid]["rowtype"]!="define_linkbit" and
					$this_set[$c_catid]["rowtype"]!="define_mediaplayer"
					) {
					$values[$this_set[$c_catid]["settingname"]] = trim($this_set[$c_catid]["setting"]);
					break;
				}
			}
		}
	}

// Patch unset defaults...
	if ($values['link_imagesize']=="") {
		$values['link_imagesize'] = $vbulletin->options["attachthumbssize"];
	}

	unset($this_set, $cat_choice, $c_catid);

    DEVDEBUG('building LDM settings cache');

	return $values;

}

/**
* Extract selected LDM permissions from admin cache
*
* @param	int		Category, -1 = base
* @param	bool	Force recache
*/

function cache_LDMpermissions($catid, $force_recache=0) {
	global $vbulletin;
	global $linkscat, $ldm_master_settings;

	cache_LDMadmintable($force_recache);

	if (isset($linkscat[$catid]['parentlist'])) {
		$parentlist = $catid.", ".$linkscat[$catid]['parentlist'];
	}
	else {
		$parentlist = "-1";
	}
	$parentlist = preg_replace("/\s/", "", $parentlist);

	$cat_choice = explode(',', $parentlist);
	foreach ($ldm_master_settings as $this_set) {
		foreach ($cat_choice as $c_catid) {
			if (isset($this_set[$c_catid])) {
				if (
					$this_set[$c_catid]["rowtype"] == "usergroup_check"
					) {
					$values[$this_set[$c_catid]["settingname"]] = $this_set[$c_catid]["setting"];
					break;
				}
			}
		}
	}
	unset($this_set, $cat_choice, $c_catid);

    DEVDEBUG('building LDM permissions cache');

	return $values;

}

/**
* Extract selected LDM bit types from admin cache
*
* @param	int		Category, -1 = base
* @param	str		Bit type (currently "define_linkbit", "define_catbit")
*/

function cache_LDMbits($catid, $rowtype) {
	global $vbulletin;
	global $linkscat, $ldm_master_settings;

	cache_LDMadmintable();

	if (isset($linkscat[$catid]['parentlist'])) {
		$parentlist = $catid.", ".$linkscat[$catid]['parentlist'];
	}
	else {
		$parentlist = "-1";
	}
	$parentlist = preg_replace("/\s/", "", $parentlist);

	$cat_choice = explode(',', $parentlist);
	foreach ($ldm_master_settings as $this_set) {
		foreach ($cat_choice as $c_catid) {
			if (isset($this_set[$c_catid])) {
				if ($this_set[$c_catid]["rowtype"]==$rowtype) {
					$values[$this_set[$c_catid]["settingname"]] = unserialize($this_set[$c_catid]["setting"]);
					$values[$this_set[$c_catid]["settingname"]]["sequence"] = $this_set[$c_catid]["sequence"];
					break;
				}
			}
		}
	}

	unset($this_set, $cat_choice, $c_catid);
	return $values;

}

/**
* Cache category table, using datastore if available
*
* @param	bool	Force recache
* @param	bool	React to problems
*/

function cache_LDMcategories($force_recache=0, $react_to_problems=1) {
	global $vbulletin, $vbphrase;
	global $linkscat, $LDM_environment;
	global $BASE_CAT;

	if (is_array($vbulletin->ldm_cats) and !$force_recache) {
		$GLOBALS['linkscat'] =& $vbulletin->ldm_cats;
		return;
	}

	$linkscat = array();
	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linkscat
		ORDER BY displayorder, catname
		");
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$linkscat[$myrow["catid"]] = $myrow;
	}
	$vbulletin->db->free_result($asb);

// Sanity check on the category hierarchy (just in case)
	$mustfix = 0;
	foreach ($linkscat as $catid => $thiscat) {

		if ($linkscat[$catid]['parentid'] == $BASE_CAT
			and $linkscat[$catid]['parentlist'] == $BASE_CAT
			) continue;

		$catlist = explode(',', $linkscat[$catid]['parentlist']);
		if ($linkscat[$catid]['parentid'] > 0
			and  isset($linkscat[$linkscat[$catid]['parentid']]['catid'])
			and  in_array($BASE_CAT, $catlist)
			and !in_array($catid, $catlist)
			) continue;

		$mustfix += 1;
	}

	if ($mustfix) { // Something's wrong
		if ($LDM_environment['is_admin']) {
            if ($react_to_problems) {
    			ldm_fix_cat_parentlist();
	    		eval(standard_error($vbphrase['ll_admin_critical_cat']));
          		exit;
	    	}
		}
		else {
			eval(standard_error($vbphrase['ll_error_critical_cat'].'<br />'.
					$vbphrase['ll_error_cannotcontinue']));
            exit;
		}
	}

// Build the counts
	foreach ($linkscat as $catid => $thiscat) {
    	$linkscat[$catid]['childlinks'] = $thiscat['catentry'];
		$linkscat[$catid]['childcats'] = 0;
		$linkscat[$catid]['childdate'] = $linkscat[$catid]['catdate'];
		$linkscat[$catid]['catsub'] = 0;
		$linkscat[$catid]['catname_clean'] = htmlspecialchars_uni(ldm_kill_bbcodes($linkscat[$catid]['catname']));
    }

	foreach ($linkscat as $catid => $thiscat) {
		$parents = explode(',', $thiscat['parentlist']);
		foreach ($parents as $p) {
			if (isset($linkscat[$p])) {
				$linkscat[$p]['childlinks'] += $thiscat['catentry'];
				$linkscat[$p]['childcats'] += 1;
				$linkscat[$p]['childdate'] = max($linkscat[$p]['catdate'], $thiscat['catdate']);
			}
		}
		if (isset($linkscat[$thiscat['parentid']])) {
			$linkscat[$thiscat['parentid']]['catsub'] += 1;
		}
	}

	ldm_datastore('ldm_cats', serialize($linkscat));
    DEVDEBUG('building LDM category cache');

}

/**
* Cache filetype/mimetype table
*
*/

function cache_LDMmimetype() {
	global $vbulletin;
	global $ldm_mimetype_cache;
	static $ldm_mimetype_cache_set = 0;
	global $links_defaults;

	if (!$ldm_mimetype_cache_set) {

		$jumpmime = $vbulletin->db->query_read("
			SELECT extension, mimetype, size, thumbnail, enabled
			FROM " . TABLE_PREFIX . "attachmenttype AS attachmenttype
			ORDER BY extension
			");

		while ($jump=$vbulletin->db->fetch_array($jumpmime)) {
			$thisextension =& $jump['extension'];
			$ldm_mimetype_cache[$thisextension]['mimetype'] = unserialize($jump['mimetype']);
			$ldm_mimetype_cache[$thisextension]['thumbnail'] = $jump['thumbnail'];

  			$ldm_mimetype_cache[$thisextension]['enabled'] = $jump['enabled'];
    		$ldm_mimetype_cache[$thisextension]['size'] = $jump['size'];
	    	$ldm_mimetype_cache[$thisextension]['width'] = $jump['width'];
		    $ldm_mimetype_cache[$thisextension]['height'] = $jump['height'];

  			$ldm_mimetype_cache[$thisextension]['permissions'] = 1;

    	    if (isset($vbulletin->userinfo['attachmentpermissions'][$thisextension]['permissions'])) {
    			$ldm_mimetype_cache[$thisextension]['permissions'] = $vbulletin->userinfo['attachmentpermissions'][$thisextension]['permissions'];
    		}
    	    if (isset($vbulletin->userinfo['attachmentpermissions'][$thisextension]['size'])) {
    			$ldm_mimetype_cache[$thisextension]['size'] = $vbulletin->userinfo['attachmentpermissions'][$thisextension]['size'];
        	}
    	    if (isset($vbulletin->userinfo['attachmentpermissions'][$thisextension]['width'])) {
    			$ldm_mimetype_cache[$thisextension]['width'] = $vbulletin->userinfo['attachmentpermissions'][$thisextension]['width'];
        	}
    	    if (isset($vbulletin->userinfo['attachmentpermissions'][$thisextension]['height'])) {
    			$ldm_mimetype_cache[$thisextension]['height'] = $vbulletin->userinfo['attachmentpermissions'][$thisextension]['height'];
        	}

		}

		$ldm_mimetype_cache_set = 1;
		$vbulletin->db->free_result($jumpmime);

        DEVDEBUG('building LDM filetype cache');

	}

}

/**
* Cache usergroup table
*
*/

function cache_LDMusergroup() {
	global $vbulletin;
	global $ldm_usergroup_cache;
	static $ldm_usergroup_cache_set = 0;

	if (!$ldm_usergroup_cache_set) {
		$asb = $vbulletin->db->query_read("
			SELECT usergroupid, title
			FROM " . TABLE_PREFIX . "usergroup
		");
		while ($row = $vbulletin->db->fetch_array($asb)) {
			$ldm_usergroup_cache[$row['usergroupid']] = $row['title'];
		}
		$ldm_usergroup_cache_set = 1;
		$vbulletin->db->free_result($jumpmime);

        DEVDEBUG('building LDM usergroup cache');

	}

}

/**
* Cache favourites
*
*/

function cache_LDMfavourites() {
	global $vbulletin;
	global $links_defaults, $links_fav;
	static $links_fav_set = 0;

	if (!$links_fav_set) {
		$links_fav = array();
		if ($links_defaults['favandfeat_entries_enabled']) {
			$asb = $vbulletin->db->query_read("
				SELECT linkid
				FROM ".THIS_TABLE."linksfavs
				WHERE userid='".$vbulletin->userinfo['userid']."'
			");
			while ($myrow = $vbulletin->db->fetch_array($asb)) {
				$links_fav[$myrow['linkid']] = 1;
			}
			$links_fav_set = 1;
			$vbulletin->db->free_result($asb);

            DEVDEBUG('building LDM favourites cache');

		}
	}
}

/**
* Cache nominated entries
*
*/

function cache_LDMnominations() {
	global $vbulletin;
	global $links_defaults, $links_mystarred, $links_starred;

	$link_mystarred = array();
	if (!is_array($links_starred)) {
		if ($links_defaults['starred_entries_enabled']) {
			if ($links_defaults['starred_entries_validuntil']<TIMENOW) {
				require_once(DIR . '/includes/local_links_misc.php');
				ldm_recalc_nominations();
			}
			$links_starred = unserialize($links_defaults['starred_entries']);

			if (!is_array($links_starred)) {
				$links_starred = array(0);
			}

			$query = "
				SELECT star.linkid AS linkid, link.linkname AS linkname, ltoc.catid AS catid
				FROM ".THIS_TABLE."linkstarred AS star
				LEFT JOIN ".THIS_TABLE."linkslink AS link
				ON star.linkid=link.linkid
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON star.linkid=ltoc.linkid
				WHERE star.userid='".$vbulletin->userinfo['userid']."'
				AND star.usertime>=".intval($links_defaults['starred_entries_periodstart'])."
				ORDER BY star.usertime DESC
				LIMIT 1
			";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow = $vbulletin->db->fetch_array($asb)) {
				$links_mystarred = $myrow;
			}
			$vbulletin->db->free_result($asb);

            DEVDEBUG('building LDM nominations cache');

		}
		else {
			$links_starred = array(0);
		}
	}

}

/**
* Cache list of filenames of available icons
*
*/

function cache_LDMicons() {
	global $vbulletin, $stylevar;
	global $links_defaults, $ldm_icon_cache;
	static $ldm_icon_cache_set = 0;

	if (!$ldm_icon_cache_set and $links_defaults["file_icons_dir"]!="") {
		if ($handle = @opendir($links_defaults["file_icons_dir"])) {
			while (false !== ($file = readdir($handle))) {
				if (preg_match("/(.*?).(gif|png|jpg)$/", $file, $matches)) {
					$ldm_icon_cache[$matches[1]] = ldm_make_filename_nonrel($vbulletin->options['bburl'], $links_defaults["file_icons_dir"], $file);
				}
			}
			closedir($handle);
		}
		$ldm_icon_cache_set = 1;

        DEVDEBUG('building LDM icon cache');

	}

	($hook = vBulletinHook::fetch_hook('ldm_icons_cached')) ? eval($hook) : false;

}

/* ======== End of Cache Functions =============================================*/

/**
* Return array of forumids for which the 'canview' or 'canviewothers' permission is turned off
*
* @param	int		If set, user's access is not restricted by forumids
* @return	intarr	Array of forumids which are blocked to current user
*/

function ldm_lookup_forum_protections($can_bypass=0) {
	global $vbulletin;
	global $links_permissions;
	static $ldm_forum_cache_set = 0;
	static $limitfids;

	if ($can_bypass) {
		return array(0);
	}

	if (!$ldm_forum_cache_set) {
		$perms = array(
			$vbulletin->bf_ugp_forumpermissions['canview'],
			$vbulletin->bf_ugp_forumpermissions['canviewothers'],
			);
		$forumperms = array();
		$limitfids = array(0,);
		foreach ($vbulletin->forumcache AS $forum) {
			if (isset($forum['forumid'])) {
				$forumperms["$forum[forumid]"] = fetch_permissions($forum['forumid']);
				$blocked = 0;
				foreach ($perms as $thisperm) {
					if (!($forumperms["$forum[forumid]"] & $thisperm)) {
						$blocked = 1;
					}
				}
				if ($blocked) {
					$limitfids[] = $forum['forumid'];
				}
			}
		}
		$ldm_forum_cache_set = 1;
	}

	return $limitfids;
}

/**
* Format a timestamp, avoiding special overrides
*
* @param	str		Format
* @param	int		Timestamp
* @return	str		Time and date string
*/

function ldm_date($format, $timestamp) {
	global $vbulletin;

	if ($format==$vbulletin->options['dateformat'] or $format==$vbulletin->options['timeformat']) {
		return vbdate($format, $timestamp);
	}
	else {
		return vbdate($format, $timestamp, false, false);
	}
}

/**
* Look up LDM setting in specified or nearest parent category
*
* @param	int		Category id
* @param	str		Setting
* @return	str		Value
*/

function ldm_lookup_setting($catid, $settingname) {
	global $vbulletin, $vbphrase;
	global $ldm_master_settings, $linkscat, $links_defaults;
	global $BASE_CAT;

	unset($returnvalue);

	if ($catid==$BASE_CAT or isset($linkscat[$catid])) {
		if (isset($ldm_master_settings[$settingname])) {
			$cat_choice = explode(',', $catid.','.(isset($linkscat[$catid]['parentlist']) ? $linkscat[$catid]['parentlist'] : "-1"));
			foreach ($cat_choice as $c_catid) {
				if (isset($ldm_master_settings[$settingname][$c_catid])) {
					$returnvalue = $ldm_master_settings[$settingname][$c_catid]["setting"];
					break;
				}
			}
		}
	}

// Patch unset defaults...
	if ($settingname=='link_imagesize') {
		if ($returnvalue=="") {
			$returnvalue = $vbulletin->options["attachthumbssize"];
		}
	}
// Are we dealing with an ad hoc setting?
    elseif (isset($links_permissions[$settingname])) {
        $returnvalue = $links_permissions[$settingname];
    }

	if (!isset($returnvalue)) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $catid) . '[' . $settingname . ']' ));
	}

	return $returnvalue;

}

/**
* Look up LDM permission for current user (all usergroups) in specified or nearest parent category
*
* @param	int		Category id
* @param	str		Setting
* @return	str		Value
*/

function ldm_lookup_permission($catid, $settingname) {
	global $ldm_master_settings, $linkscat, $links_permissions;
	global $BASE_CAT;
	global $links_usergroupids, $vbphrase;

	if ($catid==$BASE_CAT or isset($linkscat[$catid])) {
		if (isset($ldm_master_settings[$settingname])) {
			$cat_choice = explode(',', $catid.',' . (isset($linkscat[$catid]['parentlist']) ? $linkscat[$catid]['parentlist'] : "-1"));
			foreach ($cat_choice as $c_catid) {
				if (isset($ldm_master_settings[$settingname][$c_catid])) {
					$sets = explode(',', $ldm_master_settings[$settingname][$c_catid]["setting"]);
					foreach ($links_usergroupids as $i) {
						if (in_array($i, $sets)) {
							return 1;
						}
					}
					return 0;
				}
			}
			return 0;
		}
	}

// Are we dealing with an ad hoc permission?
    if (isset($links_permissions[$settingname])) {
        return $links_permissions[$settingname];
    }

	eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $catid)));

}

/**
* Update LDM setting in cache and database
*
* @param	int		Category id
* @param	str		Setting
* @param	str		New value
*/

function ldm_update_setting($catid, $settingname, $settingvalue) {
	global $ldm_master_settings;

	$ldm_master_settings[$settingname][$catid]["setting"] = $settingvalue;
	ldm_update_oneadminrow($catid, $settingname, $settingvalue);

}

/**
* Insert/Update a single value in the main admin table
*
* @param	int		Categoryid
* @param	str		Setting name
* @param	str		Setting value
*/

function ldm_update_oneadminrow($catid, $name, $value) {
	global $vbulletin;
	global $ldm_master_settings;

	if (isset($ldm_master_settings[$name]["$catid"])) {
		$query = "
			UPDATE ".THIS_TABLE."linksadmin
			SET
				setting='".$vbulletin->db->escape_string($value)."'
			WHERE settingname='".$name."'
			AND	catid='".$catid."'
			";
		$vbulletin->db->query_write($query);
		$ldm_master_settings[$name]["$catid"]['settingname'] = $value;
	}
	elseif ($catid<0 or isset($ldm_master_settings[$name]["-1"])) {
		$query = "
			INSERT INTO ".THIS_TABLE."linksadmin
			SET
				settingname='". $vbulletin->db->escape_string($name). "',
				setting='". $vbulletin->db->escape_string($value). "',
				sequence='". $vbulletin->db->escape_string($ldm_master_settings[$name]['-1']['sequence']). "',
				rowtype='". $vbulletin->db->escape_string($ldm_master_settings[$name]['-1']['rowtype']). "',
				canoverride='". $vbulletin->db->escape_string($ldm_master_settings[$name]['-1']['canoverride']). "',
				catid='". $catid. "'
			";
		$vbulletin->db->query_write($query);
		$ldm_master_settings[$name]["$catid"] =
			array(
			'settingname' => $name, 'setting' => $value, 'sequence' => $ldm_master_settings[$name]['-1']['sequence'],
			'rowtype=' => $ldm_master_settings[$name]['-1']['rowtype'], 'canoverride' => $ldm_master_settings[$name]['-1']['canoverride'],
			'catid' => $catid
				);
	}
	else {
		ldm_general_failure(
			"ldm_update_oneadminrow('$catid', '$name', '$value') - no base value found"
			);
	}

	ldm_datastore_markdirty('ldm_admin');

}

/**
* Record that an 'extra' has initiated itself
*
* @param	str		Extra's title setting
* @param	str		Extra's full name
* @param	str		Extra's version id
*/

function ldm_extra_is_loaded($title, $fullname="", $version="") {
	global $vbulletin;
	global $ldm_extras_loaded;

	$ldm_extras_loaded[$title] = array('version'=>$version, 'fullname'=>$fullname);

}

/**
* Obtain mimetype information for specified file type
*
* @param	str		File type
* @return	str		Mimetype
*/

function ldm_get_mimetype($type) {
	global $ldm_mimetype_cache;

	$ltype = strtolower($type);
	cache_LDMmimetype();
	if (strlen($type) <= 1) {
		return '';
	}

	foreach ($ldm_mimetype_cache as $thistype=>$mime) {
    	if (strcasecmp($type, $thistype)==0) {
    		return $ldm_mimetype_cache[$thistype]['mimetype'];
    	}
    }

	return '';
}

/**
* Check whether specified file type is recognised
*
* @param	str		File type
* @return	bool	Recognised
*/

function ldm_known_filetype($type) {
	global $vbulletin;
	global $ldm_mimetype_cache;

	cache_LDMmimetype();
	$type = trim($type);

	if (strlen($type) <= 1) {
		return 0;
	}

	foreach ($ldm_mimetype_cache as $thistype=>$mime) {
    	if (strcasecmp($type, $thistype)==0) {
    	    return 1;
    	}
    }

	return 0;
}

/**
* Parse/expand string according to permitted features
*
* @param	str		String to parse
* @return	str		Parsed string
*/

function ldm_parse_features($string) {
	global $links_defaults, $vbulletin;
	static $bbcode_parser;

	if (!is_object($bbcode_parser)) {
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	}

	$result = $string;
	if ($links_defaults['apply_censor']) {
		$result = fetch_censored_text($result);
	}

	$saved = $vbulletin->registry->options['word_wrap'];
	$vbulletin->options['wordwrap'] = $links_defaults['word_wrap'];
	$result = $bbcode_parser->do_parse(
		$result,
		$links_defaults['allow_html'],
		$links_defaults['allow_smilies'],
		$links_defaults['allow_bbcode'],
		$links_defaults['allow_images']
		);
	$vbulletin->options['wordwrap'] = $saved;

//    $result = preg_replace("/&(?!(#\d{1,4};|\w{1,4};))/", "&amp;", $result); // fix raw ampersands

	$result = str_replace("&lt;br /&gt;", "<br />", $result); // unfix line breaks

	return $result;

}

/**
* Build category menu
*
* @param	int()	Categoryids to select
* @param	str		Template
* @param	bool	Whether to include *none* as one of the menu choices
* @param	str		Menu name
* @param	str		Menu id
* @param	bool	Use forum-based permissions to hide protected categories
* @param	str		Use the specified LDM permission to hide protected categories
* @param	bool	Include closed categories
* @return	str		Menu
*/

function ldm_construct_category_list($cat_selected, $template, $allow_none, $list_name, $list_id, $with_forum_permission=0, $with_category_permission="", $with_closed=1) {
	global $vbulletin, $vbphrase, $stylevar;
	global $linkscat, $links_permissions, $links_defaults;
	global $limitfids, $ldm_child, $limitcats;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	if ($with_forum_permission) {
		if (!isset($limitfids)) {
			$can_bypass = $links_permissions['can_bypass_forumperms'];
			$limitfids = ldm_lookup_forum_protections($can_bypass);
		}
	}
	$limitcats = array(-1);
	if ($with_category_permission) {
		foreach ($linkscat as $k=>$thiscat) {
			if (!ldm_lookup_permission($thiscat['catid'], $with_category_permission)) {
				$limitcats[] = $thiscat['catid'];
			}
		}
	}

	$ldm_child = array();
	foreach ($linkscat as $k=>$thiscat) {
		$ldm_child[$linkscat[$k]['parentid']][] = $k;
	}

	($hook = vBulletinHook::fetch_hook('ldm_construct_catlist')) ? eval($hook) : false;

	$catsel = (in_array(0, $cat_selected) ? 1 : 0);
	$select_stage = 1;
	eval("\$optbit = \"".fetch_template($template)."\";");
	if ($allow_none) {
		$catname = $vbphrase['ll_none'];
		$catid = "-1";
		$catsel = (in_array($catid, $cat_selected) ? 1 : 0);
		$select_stage = 2;
		eval("\$optbit .= \"".fetch_template($template)."\";");
	}
	$optbit .= ldm_construct_category_item(-1, "", $cat_selected, $template, $list_name, $list_id, $with_forum_permission, $with_closed);
	$select_stage = 3;
	eval("\$optbit .= \"".fetch_template($template)."\";");

	return $optbit;
}

/**
* Build category menu - handle children of specified category and recursing
*
* @param	int		Parent category
* @param	str		Prepend string, extended with each depth of recursion
* @param	int		Categoryids to select
* @param	str		Template
* @param	str		Menu name
* @param	str		Menu id
* @param	bool	Use forum-based permissions to hide protected categories
* @param	bool	Include closed categories
* @return	str		Menu
*/

function ldm_construct_category_item($thisparent, $prepend, $cat_selected, $template, $list_name, $list_id, $with_forum_permission, $with_closed) {
	global $vbulletin, $stylevar, $vbphrase;
	global $links_permissions, $links_defaults, $limitfids, $ldm_child, $limitcats, $linkscat;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$optbit = array();
	$select_stage = 2;

	if (isset($ldm_child["$thisparent"])) {
		$thesechildren = $ldm_child["$thisparent"];
		foreach ($thesechildren as $c) {
			$myrow =& $linkscat[$c];
			$catid = $myrow["catid"];
			if ($with_forum_permission and in_array($linkscat[$catid]["catforum"], $limitfids)) {
				continue;
			}
			$catname = $prepend." ".$myrow["catname_clean"];
			$catsel = (in_array($catid, $cat_selected) ? 1 : 0);
			$catclosed = $linkscat[$catid]["catclosed"];
			$disabled = ($catclosed and !$with_closed and !$links_permissions["can_admin_links"] ? 1 : 0);
			$thisoptbit = "";
			if (!in_array($catid, $limitcats)) {
				eval("\$thisoptbit .= \"".fetch_template($template)."\";");
			}
			$thisoptbit .= ldm_construct_category_item($catid, $prepend."-", $cat_selected, $template, $list_name, $list_id, $with_forum_permission, $with_closed);
			$optbit[$catname.'['.sprintf("%06d", $catid).']'] = $thisoptbit;
		}
	}

	uksort($optbit, create_function('$a,$b', 'return strnatcasecmp($a, $b);'));
	return implode('', $optbit);

}

/**
* Return list of names of indicated categories
*
* @param	int*	Categoryids
* @return	str		Comma-separated list of category names
*/

function ldm_construct_parent_list($pcatid) {
	global $linkscat;

	$pbit = array();
	foreach ($pcatid as $thiscat) {
		if (isset($linkscat[$thiscat])) {
			$pbit[] = $linkscat[$thiscat]["catname_clean"];
		}
	}

	if (count($pbit)) {
		$pbit = implode(", ", $pbit);
	}
	else {
		$pbit = "None";
	}

	return $pbit;
}

/**
* Rebuild category parentlists
*
* @return			Null
*/

function ldm_fix_cat_parentlist() {
	global $vbulletin;
	global $linkscat;
	global $BASE_CAT;

    cache_LDMcategories(1, 0);

	$tmpcat = array();
	foreach ($linkscat as $thisid=>$cat) {
		$tmpcat[$thisid] = $linkscat[$thisid];

		if ($linkscat[$thisid]['parentid'] == $BASE_CAT
			and $linkscat[$thisid]['parentlist'] == $BASE_CAT) {
			continue;
		}

		$catlist = explode(',', $linkscat[$thisid]['parentlist']);
		if ($linkscat[$thisid]['parentid'] > 0
			and  isset($linkscat[$linkscat[$thisid]['parentid']]['catid'])
			and  in_array($BASE_CAT, $catlist)
			and !in_array(thisid, $catlist)
			) {
			continue;
		}

		$linkscat[$thisid]['parentid'] = $BASE_CAT; // Parentage is corrupt - re-root at the base of the tree

	}

	ldm_build_cat_parentlist($BASE_CAT);

	$mark_dirty = 0;
	foreach ($linkscat as $thisid=>$cat) {
		if ($linkscat[$thisid]['parentlist'] != $tmpcat[$thisid]['parentlist']
			or $linkscat[$thisid]['parentid'] != $tmpcat[$thisid]['parentid']) {
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET parentid = ".$linkscat[$thisid]['parentid'].",
					parentlist='".$linkscat[$thisid]['parentlist']."'
				WHERE catid='$thisid'
				LIMIT 1
			");
			$mark_dirty = 1;
		}
	}

	if ($mark_dirty) {
		ldm_datastore_markdirty('ldm_cats');
	}

}

/**
* Rebuild category parentlists for specified categoryid and recurse through its children
*
* @param	int		Categoryid
* @return			Null
*/

function ldm_build_cat_parentlist($catid) {
	global $vbulletin, $vbphrase;
	global $linkscat;
	global $BASE_CAT;

	if ($catid == $BASE_CAT) {
		foreach ($linkscat as $thisid=>$cat) {
			$linkscat[$thisid]['parentlist'] = "";
		}
	}

	$ids = array_keys($linkscat);
	foreach ($ids as $thisid) {
		if ($linkscat[$thisid]['parentid'] == $catid) {
			if ($linkscat[$thisid]['parentlist'] != "") {
				eval(standard_error($vbphrase['ll_error_recursive_cat'].'<br />'.
				$vbphrase['ll_error_cannotcontinue']));
				exit;
			}
			if ($catid == $BASE_CAT) {
				$linkscat[$thisid]['parentlist'] = $catid;
			}
			else {
				$linkscat[$thisid]['parentlist'] = $catid.",".$linkscat[$catid]['parentlist'];
			}
			ldm_build_cat_parentlist($thisid);
		}
	}

	if ($catid == $BASE_CAT) { // Look for orphans
		foreach ($linkscat as $thisid=>$cat) {
			if ($linkscat[$thisid]['parentlist'] == "") {
				$linkscat[$thisid]['parentlist'] == $BASE_CAT;
			}
		}
	}

}

/**
* Fix category entry counts and dates
*
* @return			Null
*/

function ldm_fix_cat_count() {
	global $vbulletin;
	global $linkscat;

	$catcount = array();
	$catdate = array();
	foreach ($linkscat as $catid => $cat) {
		$catcount[$catid] = 0;
		$catdate[$catid] = 0;
	}
	$asb = $vbulletin->db->query_read("
		SELECT ltoc.catid AS catid, link.linkdate AS linkdate
		FROM ".THIS_TABLE."linkslink AS link
		LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
		ON link.linkid = ltoc.linkid
	");
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		if (!isset($catdate[$myrow['catid']])) {
			$catcount[$myrow['catid']] = 1;
			$catdate[$myrow['catid']] = $myrow['linkdate'];
		}
		else {
			$catcount[$myrow['catid']] +=1;
			$catdate[$myrow['catid']] = max($catdate[$myrow['catid']], $myrow['linkdate']);
		}
	}
	$vbulletin->db->free_result($asb);

	$mark_dirty = 0;
	foreach ($catcount as $catid => $count) {
		if (isset($linkscat[$catid])) {
			if ($linkscat[$catid]['catentry'] != $count or $linkscat[$catid]['catdate'] != $catdate[$catid]) {
				$vbulletin->db->query_write("
					UPDATE ".THIS_TABLE."linkscat
					SET catentry=".$count.", catdate=".$catdate[$catid]."
					WHERE catid='$catid'
					LIMIT 1
				");
				$linkscat[$catid]['catentry'] = $count;
				$linkscat[$catid]['catdate'] = $catdate[$catid];
				$mark_dirty = 1;
			}
		}
	}
	if ($mark_dirty) {
		ldm_datastore_markdirty('ldm_cats');
	}

}

/**
* Sort helper routine for categories
*
* @param	int		Categoryid
* @param	int		Categoryid
* @return	int		Comparison -1/0/1
*/

function ldm_catcmp($a, $b) {
	global $ldm_holdsort, $ldm_holdcat;

// Display order always over-rides the rest
	if ($ldm_holdcat[$a]['displayorder'] < $ldm_holdcat[$b]['displayorder']) return(-1);
	if ($ldm_holdcat[$a]['displayorder'] > $ldm_holdcat[$b]['displayorder']) return( 1);

	switch ($ldm_holdsort) {
	case 'd':
		if ($ldm_holdcat[$a]['catdate'] == $ldm_holdcat[$b]['catdate']) return(0);
		if ($ldm_holdcat[$a]['catdate'] <  $ldm_holdcat[$b]['catdate']) return(1);
		return(-1);

	case 'D':
		if ($ldm_holdcat[$a]['catdate'] == $ldm_holdcat[$b]['catdate']) return(0);
		if ($ldm_holdcat[$a]['catdate'] >  $ldm_holdcat[$b]['catdate']) return(1);
		return(-1);

	case 'n':
		if ($ldm_holdcat[$a]['catname'] == $ldm_holdcat[$b]['catname']) return(0);
		if ($ldm_holdcat[$a]['catname'] <  $ldm_holdcat[$b]['catname']) return(1);
		return(-1);

	default:
		return strnatcasecmp($ldm_holdcat[$a]['catname'], $ldm_holdcat[$b]['catname']);
	}

}

/**
* Return an array of categories with given parent
*
* @param	int		Parent category
* @param	int		Number of sublevels to include
* @param	str		Required sort order
* @return	int*	Array of category ids
*/

function ldm_cat_walk($level, $dig, $sort='') {
	global $linkscat, $links_defaults;
	global $ldm_holdcat, $ldm_holdsort;
	static $ldm_holdcat_set = 0;

	if (!$ldm_holdcat_set) {
		$ldm_holdsort = ($sort=="" ? (isset($links_defaults['cat_default_sort_order']) ? $links_defaults['cat_default_sort_order'] : 'N') : $sort);
		$ldm_holdcat = $linkscat;
		uksort($ldm_holdcat, "ldm_catcmp");
		$ldm_holdcat_set = 1;
	}

	$tree = array();
	if ($dig) {
		$keys = array_keys($ldm_holdcat);
		foreach ($keys as $thiskey) {
			$thiscat = $ldm_holdcat[$thiskey];
			if ($thiscat['parentid'] == $level) {
				$tree[$thiscat['catid']] = ldm_cat_walk($thiscat['catid'], $dig-1, $sort);
			}
		}
	}

	return $tree;
}

function ldm_construct_keyword_list($list_id, $catid=0, $keyid_selected=0) {
	global $vbulletin, $vbphrase, $stylevar;

	$select_stage = 1;
	$stylewidth = "width:200px";
	$stylesize = "1";
	$selectsubmit = 1;
	$nkeys = 0;
	$label = $vbphrase['ll_keywords'];
	eval("\$optbit = \"".fetch_template('links_listselect')."\";");

	$select_stage = 2;
	if (!$catid) {
		$asb = $vbulletin->db->query_read("
			SELECT keyid, keyword
			FROM ". THIS_TABLE . "linkskeys
			ORDER BY keyword
		");
	}
	else {
		$asb = $vbulletin->db->query_read("
			SELECT DISTINCT lkeys.keyid AS keyid, lkeys.keyword AS keyword
			FROM ". THIS_TABLE . "linkskeys AS lkeys
			LEFT JOIN ". THIS_TABLE . "linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			LEFT JOIN ". THIS_TABLE . "linksltoc AS ltoc
			ON ltok.linkid = ltoc.linkid
			WHERE ltoc.catid = ".$catid."
			ORDER BY keyword
		");
	}
	$styleid = 0;
	$stylename = $vbphrase['ll_none'];
	$stylesel = ($keyid_selected ? 0 : 1);
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	while ($row=$vbulletin->db->fetch_array($asb)) {
		$nkeys += 1;
		$styleid = $row['keyid'];
		$stylename = $row['keyword'];
		$stylesel = ($styleid==$keyid_selected ? 1 : 0);
		eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	}
	$vbulletin->db->free_result($asb);

	$select_stage = 3;
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	if (!$nkeys) $optbit = "";
	return $optbit;

}

/**
* Transform array of key/value into hidden form fields
*
* @param	str*	Key/value pairs
* @return	str		Form fields
*/

function ldm_make_hidden_vars($vararray) {
	$vars = "";
	foreach ($vararray as $k=>$v) {
		$vars .= '<input type="hidden" name="'.$k.'" value="'.$v.'" />';
	}
	return $vars;
}

/* ======== URL/File utilities =================================================*/

/**
* Convert a set of strings into a file path, checking on directory separators
*
* @param	str*	Filename components
* @return	str		File path
*/

function ldm_make_filename() {
	$arg = func_get_args();
	$res = "";
	foreach ($arg as $a) {
		if (!$res) {
			$res = $a;
		}
		elseif (substr($res,-1,1) != '/') {
			$res .= (substr($a,0,1)=='/' ? $a : '/'.$a);
		}
		else {
			$res .= (substr($a,0,1)=='/' ? substr($a,1,strlen($a)-1) : $a);
		}
	}
	return $res;
}

/**
* As ldm_make_filename, but eliminates relative parts of the path
*
* @param	str*	Filename components
* @return	str		File path
*/

function ldm_make_filename_nonrel() {
	$arg = func_get_args();
	$res = "";
	foreach ($arg as $a) {
		if (!$res) {
			$res = $a;
		}
		elseif (substr($res,-1,1) != '/') {
			$res .= (substr($a,0,1)=='/' ? $a : '/'.$a);
		}
		else {
			$res .= (substr($a,0,1)=='/' ? substr($a,1,strlen($a)-1) : $a);
		}
	}

	$res = explode('/', $res);
	$keys = array_keys($res, '..');
	foreach($keys AS $keypos => $key) {
		array_splice($res, $key - ($keypos * 2 + 1), 2);
	}
	$res = implode('/', $res);
	$res = str_replace('./', '', $res);

	return $res;
}


/**
* Create directory if it does not already exist, optionally creating empty index.html file inside it
*
* @param	str		Full path to target directory
* @param	bool	Secure with an index.html
* @return	bool	Success/fail
*/

function ldm_create_directory($fullpath, $secure) {

	if (!file_exists($fullpath)) {
    	require_once(DIR . '/includes/functions_file.php');
		if (!vbmkdir($fullpath, 0777)) {
			return 0;
		}
	}

	if ($secure) {
		$securefile = ldm_make_filename($fullpath, "index.html");
		if (!file_exists($securefile)) {
			$fp = @fopen($securefile, "w");
			if ($fp) {
				fclose($fp);
			}
		}
	}
	return 1;

}

/**
* Check whether directory is accessible within current open_basedir settings
*
* @param	str		Full path to target directory
* @return	bool	Success/fail
*/

function ldm_can_openbasedir($fullpath) {
	global $LDM_environment;

	if (!$LDM_environment['open_basedir']) {
		return 1;
	}

	$ldir = str_replace(DIRECTORY_SEPARATOR, "/", trim($fullpath));
	foreach (explode(PATH_SEPARATOR, $LDM_environment['open_basedir']) as $thisdir) {
		$thisdir = trim($thisdir);
		if ($thisdir and preg_match("#^$thisdir#i", $ldir)) {
			return 1;
		}
	}

	return 0;
}

/**
* Check whether directory exists and is readable
*
* @param	str		Target directory
* @param	int		0/1, directory specified relative to server/filesystem
* @return	bool	Success/fail
*/

function ldm_can_accessdir($dir, $use_file_root=1) {
	global $vbulletin;
	global $LDM_environment;

	$ldir = trim($dir);

	if (!$use_file_root and $ldir{0} != "/") {
		$ldir = "./".$ldir;
		$ldir = realpath($ldir);
	}
	else {
		$ldir = ldm_get_local_filename($dir, $use_file_root);
	}

	if ($fp=@opendir($ldir)) {
		@closedir($fp);
		return 1;
	}

	return 0;
}

/**
* Convert path into an absolute filename
*
* @param	str		File path
* @param	int		Apply local_file_root
* @param	str		Use as local_file_root if not = "###"
* @param	str		Use as local_file_root_prefix if not = "###"
* @return	str		File path
*/

function ldm_get_local_filename($path, $use_file_root=1, $new_local_file_root="###", $new_local_file_root_prefix="###") {
	global $links_defaults;

	$lpath = preg_replace("/(.*)\?.*/", "\\1", $path);
	$lfr	= ($new_local_file_root=="###" ? $links_defaults["local_file_root"] : $new_local_file_root);
	$lfrp	= ($new_local_file_root_prefix=="###" ? $links_defaults["local_file_root_prefix"] : $new_local_file_root_prefix);
	if ($use_file_root) {
		if ($lfr) {
			$lpath = ldm_make_filename($lfrp,$path);
			$return_path = realpath($lpath);
			if (!$return_path) $return_path = $lpath;
			$return_path = str_replace("\\","/",$return_path);
		}
		else {
			$return_path = ldm_make_filename(LDM_DOCUMENT_ROOT, $lfrp, $lpath);
		}
	}
	else {
		$return_path = ldm_make_filename(LDM_DOCUMENT_ROOT, $lpath);
	}
	ldm_debug("ldm_get_local_filename", array($path, $return_path));
	return($return_path);
}

/**
* Variant on parse_url, catching Windows filenames that start X: (drivename)
* and treating any fragment component as part of the name of local files
*
* @param	str		url
* @return	arr		parse_url data structure
*/

function ldm_parse_url($url) {
	$urlInfo = @parse_url($url);
	if (!is_array($urlInfo)) {
		$urlInfo = array();
		$urlInfo['path'] = $url;
	}
	elseif (array_key_exists('scheme', $urlInfo)) {
		if (preg_match("/^[a-z]$/", strtolower($urlInfo['scheme']))) {
			unset($urlInfo);
			$urlInfo['path'] = $url;
		}
	}
	if (!array_key_exists('scheme', $urlInfo) and !array_key_exists('host', $urlInfo)) {
		unset($urlInfo);
		$urlInfo['path'] = $url;
	}

	return($urlInfo);
}

/**
* Strip out username and password and place it in a curl option
*
* @param	str		parse_url data structure
* @param	&str	parse_url data structure without username/password pair
* @param	&str	username:password if present
* @return
*/

function ldm_unglue_username_and_password($urlInfo, &$url, &$userpassword) {
	$userpassword = "";
	if ($urlInfo['user']) {
		$userpassword = $urlInfo['user'].($urlInfo['pass']? ':'.$urlInfo['pass'] : '');
		$url  = $urlInfo['scheme'] ? $urlInfo['scheme'].'://' : '';
		$url .= $urlInfo['host'] ? $urlInfo['host'] : '';
		$url .= $urlInfo['port'] ? ':'.$urlInfo['port'] : '';
		$url .= $urlInfo['path'] ? $urlInfo['path'] : '';
		$url .= $urlInfo['query'] ? '?'.$urlInfo['query'] : '';
		$url .= $urlInfo['fragment'] ? '#'.$urlInfo['fragment'] : '';
	}
}

/**
* Set linkimg to linkurl if linkurl points to an image type
*
* @param	str		url
* @param	&str	image
*/

function ldm_set_autoimage($linkurl, &$linkimg) {
	global $vbulletin, $vbphrase;
	global $links_defaults, $LDM_environment;
	global $LINK_OK;

	$urlInfo = ldm_parse_url($linkurl);
	if ($urlInfo['host'] and !$links_defaults['allow_remote_downloads']) {
		return;
	}

	($hook = vBulletinHook::fetch_hook('ldm_link_autoimage')) ? eval($hook) : false;

	if ($linkimg) {
		return;
	}

    require_once (DIR . '/includes/local_links_images.php');
    if (ldm_can_handle_as_image($linkurl)==1 or ldm_can_handle_as_mediaimage($linkurl)==1) {
		$linkimg = $linkurl;
		return;
	}

}

/**
* Tidy up a (potentially local/relative) url so that we can use it within an fopen()
*
* @param	str		url
* @return	str		cleaned url
*/

function ldm_cleanto_fopen($url) {
	global $ldm_protocol_schemes, $links_defaults;

	$urlInfo = ldm_parse_url($url);
	if (!$urlInfo['scheme'] and !$urlInfo['host']) {
		$url_clean = ldm_get_local_filename($url);
	}
	elseif (array_key_exists($urlInfo['scheme'], $ldm_protocol_schemes)) {
		$url_clean = preg_replace("/ *$/","",$urlInfo['path']);
		$url_clean = $urlInfo['scheme'].'://'.
			($urlInfo['user'] ? $urlInfo['user'] . ($urlInfo['pass'] ? ':'.$urlInfo['pass'] : '') . '@' : '') .
			$urlInfo['host'].
			preg_replace("/ /","%20",$url_clean);
	}
	else {
		$url_clean = $url;
	}

	ldm_debug("ldm_cleanto_fopen", array($url, $url_clean));
	return $url_clean;
}

/**
* Parse the $_SERVER superglobal, returning headers
*
* @return	array		header array [Key]=>value
*/

function ldm_parse_headers() {

	$headers = array();
	while (list($key, $value) = each ($_SERVER)) {
		if (strncmp($key, "HTTP_", 5) == 0) {
			$key = strtr(ucwords(strtolower(strtr(substr($key, 5), "_", " "))), " ", "-");
			$headers[$key] = $value;
		}
	}
	return $headers;
}

/**
* Attempt to fetch headers from url
*
* @param	str		url
* @return	str		header
*/

function ldm_fetch_headers($url) {
	global $LDM_environment;
	static $last_fetch;

	$headers = false;

	if (isset($last_fetch['url']) and $last_fetch['url']==$url) {
		$headers = $last_fetch['header'];
	}

	if ($LDM_environment['curl_available']) {
		$ch = @curl_init();
		if ($urlInfo['user']) {
			ldm_unglue_username_and_password($urlInfo, $rawurl, $userpassword);
			@curl_setopt($ch, CURLOPT_URL, str_replace(" ", "%20", $rawurl));
			@curl_setopt($ch, CURLOPT_USERPWD, $userpassword);
		}
		else {
			@curl_setopt($ch, CURLOPT_URL, str_replace(" ", "%20", $url));
		}
		@curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		@curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		@curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		@curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
		@curl_setopt($ch, CURLOPT_HEADER, true);
		@curl_setopt($ch, CURLOPT_NOBODY, true);
		@curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'HEAD');
		@curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$headers = @curl_exec($ch);
		$error = @curl_error($ch);
		@curl_close($ch);
		$last_curl['url'] = $url;
		$last_curl['header'] = $headers;
	}

	return $headers;

}

/**
* Status of url/file: update $url if scheme omitted and url found
*
* @param	str		url
* @return	int		status
*/

function ldm_check_url(&$url) {
	global $ldm_protocol_schemes, $links_defaults, $LDM_environment;
	global $LINK_BROKEN, $LINK_OK, $LINK_NO_ACCESS, $LINK_NO_REMOTE_DOWNLOADS;

	$urlInfo = ldm_parse_url($url);
	unset($holdurl);

	ldm_debug("ldm_check_url:", $urlInfo);

	if ($urlInfo['scheme']) {
		if (!array_key_exists($urlInfo['scheme'], $ldm_protocol_schemes)) {
			return $LINK_NO_ACCESS;
		}
		elseif ($ldm_protocol_schemes[$urlInfo['scheme']]["validate"]==0) {
			return $LINK_OK;
		}
	}

	if (!$urlInfo['host']) {
		$url_clean = ldm_get_local_filename($url);
		$conn = @fopen($url_clean, "rb");
		if ($conn) {
			fclose($conn);
			return $LINK_OK;
		}
	}

// check if this is a url with http:// omitted
	if (!$urlInfo['host']) {
		if (preg_match("/^[a-z0-9]+\.[a-z0-9]+\.*[a-z0-9]+/i", $url)) {
			$holdurl = $url;
			$url = "http://".$url;
			$urlInfo = ldm_parse_url($url);
		}
		else {
			return $LINK_BROKEN;
		}
	}

	$type = file_extension($urlInfo['path']);
	$mimetype = ldm_known_filetype($type);
	if ($mimetype and !$links_defaults['allow_remote_downloads']) {
		return $LINK_NO_REMOTE_DOWNLOADS;
	}

// can't check - assume ok so as not to kill everything
	if (!$LDM_environment['curl_available'] and !$LDM_environment['allow_url_fopen']) {
		if ($holdurl) {
			$url = $holdurl;
		}
		return $LINK_OK;
	}

	$header = ldm_fetch_headers($url);
	if ($header !== false) {
		if (preg_match("/HTTP.1.. 200/", $header)) {  // somewhere in the reply - may not be at the start if there is a 302 recursion
			return $LINK_OK;
		}
		else {
			if ($holdurl) $url = $holdurl;  //restore
			return $LINK_BROKEN;
		}
	}

	if ($LDM_environment['allow_url_fopen']) {
		$url_clean = ldm_cleanto_fopen($url);
		$conn = @fopen($url_clean, "rb");
		if ($conn) {
			fclose($conn);
			return $LINK_OK;
		}
	}

// everything failed, give up
	if ($holdurl) $url = $holdurl;
	return $LINK_BROKEN;

}

/**
* Return filesize of url if pointing to a filetype other than .htm/.html
*
* @param	str		url
* @return	int		filesize
*/

function ldm_get_sizeof_url($url) {
	global $LDM_environment;

	$urlInfo = ldm_parse_url($url);

	if (!$urlInfo['path']) {
		return (0);
	}

	$type = strtolower(file_extension($urlInfo['path']));
	if (strlen($type)<1 or $type=="html" or $type=="htm") {
		return 0;
	}

	if (!$urlInfo['scheme'] and !$urlInfo['host']) {
		$url_clean = ldm_get_local_filename($url);
		$conn = @fopen($url_clean, "rb");
		if (!$conn) {
			return(0);
		}
		else {
			$stat = @fstat($conn);
			fclose($conn);
			return(($stat[7]>0 ? $stat[7] : 0));
		}
	}

	$header = ldm_fetch_headers($url);
	if ($header !== false) {
		$regex = '/Content-Length:\s([0-9].+?)\s/';
		$count = preg_match($regex, $header, $matches);
		return (isset($matches[1]) ? $matches[1] : 0);
	}

	return(0);
}

/**
* Delete file, assumed to be an upload
*
* @param	str		url
* @return
*/

function ldm_delete_upload($linkurl) {
	if ($linkurl) {
		$fullfile = ldm_get_local_filename($linkurl);
		@unlink($fullfile);
	}
}

/**
* Delete file, assumed to be an thumbnail
*
* @param	str		url
* @return
*/

function ldm_delete_thumb($thumb) {
	if ($thumb) {
		$fullfile = ldm_get_local_filename($thumb, 0);
		@unlink($fullfile);
	}
}

/**
* Convert string to bytes (nK, nG, etc)
*
* @param	str		bytestring
* @return	int		bytes
*/

function ldm_decode_bytes($val) {
	global $vbphrase;

	if (!$val) {
		$val = 0;
	}

	if (!preg_match("/^\s*([\d\.]+)\s*([a-z]*)\s*$/", strtolower($val), $matches)) {
		return (-1);
	}

	$val = $matches[1];
	switch($matches[2]) {
	case 'g':
	case 'gb':
	case 'gbyte':
	case 'gbytes':
	case strtolower($vbphrase['ll_bytesG']):
		$val *= 1024;
	case 'm':
	case 'mb':
	case 'mbyte':
	case 'mbytes':
	case strtolower($vbphrase['ll_bytesM']):
		$val *= 1024;
	case 'k':
	case 'kb':
	case 'kbyte':
	case 'kbytes':
	case strtolower($vbphrase['ll_bytesK']):
		$val *= 1024;
	case strtolower($vbphrase['ll_bytes']):
	case '':
		break;
	default:
		return (-1);
	}

	return round($val);
}

/**
* Encode bytes as a string using K,M,G
*
* @param	str		bytes
* @return	int		bytestring
*/

function ldm_encode_bytes($val) {
	$K1 = 1024; $M1 = 1024*$K1; $G1 = 1024*$M1;
	if ($val>9.5*$G1) {
		$res = round($val/$G1).'G';
	}
	elseif ($val>9.5*$M1) {
		$res = round($val/$M1).'M';
	}
	elseif ($val>9.5*$K1) {
		$res = round($val/$K1).'K';
	}
	else {
		$res = $val;
	}
	return $res;
}

/**
* Encode bytes as a string using ll_bytesX phrases
*
* @param	str		bytes
* @return	int		bytestring
*/

function ldm_format_bytes($val, $decimal=2) {
	global $vbphrase;
	$K1 = 1024; $M1 = 1024*$K1; $G1 = 1024*$M1;
	if (!$val) {
		$val = 0;
	}
	if ($val>=$G1) {
		return sprintf("%.".$decimal."f", $val/$G1).' '.$vbphrase['ll_bytesG'];
	}
	elseif ($val>=$M1) {
		return sprintf("%.".$decimal."f", $val/$M1).' '.$vbphrase['ll_bytesM'];
	}
	elseif ($val>=$K1) {
		return sprintf("%.".$decimal."f", $val/$K1).' '.$vbphrase['ll_bytesK'];
	}
	else {
		return $val.' '.$vbphrase['ll_bytes'];
	}
}

/**
* Check for valid existing forum/default pseudo-forum
*
* @param	int		Forumid
* @param	bool	DEFAULT_FORUMID considered valid
* @return	bool	Valid
*/

function ldm_forumid_is_valid($forumid, $valid_default=true) {
	global $DEFAULT_FORUMID;
	if ($forumid == $DEFAULT_FORUMID and $valid_default) {
		return 1;
	}
	if ($forumid <= 0) {
		return 0;
	}
	else {
		return verify_id('forum', $forumid, 0, 0, 0);
	}
}

/**
* Check for valid existing category(ies)
*
* @param	mixed	Categoryid or array
* @return	bool	Valid
*/

function ldm_catid_is_valid($catid) {
	global $linkscat;
	if (is_array($catid)) {
		if (count($catid)<=0) return 0;
		foreach ($catid as $thiscat) {
			if (!is_numeric($thiscat)) return 0;
			if (intval($thiscat)!=$thiscat) return 0;
			if (!isset($linkscat[$thiscat]['parentid'])) return 0;
		}
	}
	else {
		if (!is_numeric($catid)) return 0;
		if (intval($catid)!=$catid) return 0;
		if (!isset($linkscat[$catid]['catid'])) return 0;
	}
	return 1;
}

/**
* Return the categories currently containing linkid
*
* @param	int		Linkid
* @return	array	Category ids
*/

function ldm_lookup_categories($linkid) {
	global $vbulletin;

	$catids = array();
	$asb = $vbulletin->db->query_read("
		SELECT link.linkid AS linkid, ltoc.catid AS linkcatid
		FROM ".THIS_TABLE."linkslink AS link
		LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
		ON link.linkid=ltoc.linkid
		WHERE link.linkid='".$linkid."'
				");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		$catids[] = $rec['linkcatid'];
	}
	return $catids;
}

/**
* Check array of usernames and return array of userids where valid, 0 otherwise
*
* @param	array	Usernames
* @return	array	Userids
*/

function ldm_lookup_userids($usernames) {
	global $vbulletin;

	$ids = array();
	$safe_usernames = array();
	foreach ($usernames as $k=>$v) {
		$usernames[$k] = trim($usernames[$k]);
		$safe_usernames[$k] = trim($vbulletin->db->escape_string(htmlspecialchars_uni($v)));
		$ids[$k] = 0;
	}
	$safe_userlist = implode("' ,'", $safe_usernames);
	if (!trim($safe_userlist)) return $ids;

	$query = "
		SELECT userid, username
		FROM " . TABLE_PREFIX . "user AS user
		WHERE username IN ('" . $safe_userlist . "')
		";
	$asb = $vbulletin->db->query_read($query);

	while ($rec=$vbulletin->db->fetch_array($asb)) {
		foreach ($usernames as $k=>$v) {
            $hv = htmlspecialchars_uni($v);
			if ($hv==$rec['username']) {
				$ids[$k] = $rec['userid'];
				continue;
			}
		}
	}
	$vbulletin->db->free_result($asb);

	return $ids;
}

/**
* Highlight string according to specified regexes, safely handling html/bbcodes
*
* @param	str		String
* @param	str		Find regex
* @param	str		Replace regex
* @return	str		New string
*/

function ldm_apply_highlight($string, $find, $replace) {

	$res = "";

// Split the string into substrings that look like/do not look like html and bbcode tags
	$substrings = preg_split("/(<[^>]*>|\[[^\]]\])/", $string, -1, PREG_SPLIT_DELIM_CAPTURE);

// Apply highlighting to each of the substrings
	$resstrings = preg_replace($find, $replace, $substrings);

	foreach ($resstrings as $k=>$r) {

// If substring was html/bbcode tag, keep the original, otherwise keep the highlight
		if (preg_match("/(<[^>]*>|\[[^\]]\])/", $substrings[$k])) {
			$res .= $substrings[$k];
		}
		else {
			$res .= $resstrings[$k];
		}
	}

	return $res;
}


/**
* Create the find and replace regexes required to highlight specified words
*
* @param	str		Words to highlight
* @param	int		Literal, =3, highlight exact phrase only
* @param	&str	'Find' regex for use in preg_replace
* @param	&str	'Replace' regex
*/

function ldm_make_highlight_regex($words, $literal, &$find, &$replace) {
	global $LDM_environment;

	$find = array();
	$replace = array();

	$words = preg_replace("/&quot;/", '"', $words);

	if ($LDM_environment['cando_utf8_regex']) {
		$regex_boundary = '[\p{C}\p{P}\p{Z}]';
		$regex_switch = '/iu';
	}
	else {
		$regex_boundary = '\b';
		$regex_switch = '/i';
	}

// Handle 'exact match' ($literal=3)
	if ($literal==3) {
		$words = preg_replace(
			array(
				"/[\\\+\-<>\(\)\~\"]/",			// 2) characters \ + - < > ( ) ~ "
				"/\//",							// 3) character /
				"/^\s+/",						// 4) white space at the beginning
				"/\s+$/",						// 5) white space at the end
				"/^\s*\*|\s\*/",				// 6) bare asterisks
				"/\*/",							// 7) other asterisks
			),
			array(
				"",								// 2) kill them
				"\/",							// 4) escape it
				"",								// 4) kill it
				"",								// 5) kill it
				"\w+",							// 6) replace by 'match one or more word characters'
				"\w*",							// 7) replace by 'match zero of more word characters'
			),
		$words);
		$find[] = '/(' . $regex_boundary .')(' . $words . ')(' . $regex_boundary .')' . $regex_switch;
		$replace[] = '$1<span class="highlight">$2</span>$3';
		$find[] = '/^(' . $words . ')(' . $regex_boundary . ')' . $regex_switch;
		$replace[] = '<span class="highlight">$1</span>$2';
		$find[] = '/(' . $regex_boundary . ')(' . $words . ')$' . $regex_switch;
		$replace[] = '$1<span class="highlight">$2</span>';
		$find[] = '/^(' . $words . ')$' . $regex_switch;
		$replace[] = '<span class="highlight">$1</span>';
	}
	else {

// Find and extract double-quoted sequences
		if (preg_match_all("/\"(.*?)\"/", $words, $quoted, PREG_PATTERN_ORDER) != 0) {
			foreach ($quoted[1] as $w) {
				if ($w) {
					$find[] = '/('.$w.')/i';
				}
			}
		}

// Tidy up what's left
		$words = preg_replace(
			array(
				"/\".*?\"/",					// 1) double quoted sequences
				"/[\\\+\-<>\(\)\~\"]/",			// 2) characters \ + - < > ( ) ~ "
				"/\//",							// 3) character /
				"/^\s+/",						// 4) white space at the beginning
				"/\s+$/",						// 5) white space at the end
				"/^\s*\*|\s\*/",				// 6) bare asterisks
				"/\*/",							// 7) other asterisks
				),
			array(
				"",								// 1) kill them
				"",								// 2) kill them
				"\/",							// 4) escape it
				"",								// 4) kill it
				"",								// 5) kill it
				"\w+",							// 6) replace by 'match one or more word characters'
				"\w*",							// 7) replace by 'match zero of more word characters'
			),
			$words);

// Break into 'words' separated by white space
		$words = preg_split("/\s+/", $words);
		foreach ($words AS $w) {
			if ($w != "") {
				$find[] = '/(' . $regex_boundary . ')(' . $w . ')(' . $regex_boundary . ')' . $regex_switch;
				$replace[] = '$1<span class="highlight">$2</span>$3';
				$find[] = '/^(' . $w . ')(' . $regex_boundary . ')' . $regex_switch;
				$replace[] = '<span class="highlight">$1</span>$2';
				$find[] = '/(' . $regex_boundary . ')(' . $w . ')$' . $regex_switch;
				$replace[] = '$1<span class="highlight">$2</span>';
				$find[] = '/^(' . $w . ')$' . $regex_switch;
				$replace[] = '<span class="highlight">$1</span>';
			}
		}
	}

	return;

}

/**
* Apply highlighting regexes to list of words
*
* @param	array	Words to highlight
* @param	str		Find regex
* @param	str		Replace regex
*/

function ldm_make_highlighted_keys($keywords, $find, $replace) {
	global $vbulletin, $vbphrase;
	$list = "";
	foreach ($keywords as $k) {
		$w = '<a href="'.SEARCH_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'action=show&amp;keys=1&amp;keyword='.htmlspecialchars_uni($k).'" title="'.$vbphrase['ll_search'].'">'.
			ldm_apply_highlight($k, $find, $replace).
			'</a>';
		$list .= $w.' ';
	}
	return trim($list);
}

/**
* Remove bbcodes and html from string, leaving the middle, i.e
* [color=red]fred[/color] => fred, except for img tags, where
* whole code is stripped out because the middle is the image url
*
* @param	str		String
* @return	str		Stripped string
*/

function ldm_kill_bbcodes($string) {

	$fixstring = $string;

// [img] bbcode
	$find = '#\[img\].*\[/img]#siU';
	$replace = '';
	$fixstring = preg_replace($find, $replace, $fixstring);

// other bbcodes
	$find = '#\[([^ ]+) *=?[^]]*\](.*)\[/\1\]#siU';
	$replace = '$2';
	$maxnest = 10; // to avoid pathological problems
	while (($maxnest--)>0 and preg_match($find, $fixstring)) {
		$fixstring = preg_replace($find, $replace, $fixstring);
	}

// html
	$find = '#<([^ ]+) *=?[^>]*>(.*)</\1>#siU';
	$replace = '$2';
	$maxnest = 10; // to avoid pathological problems
	while (($maxnest--)>0 and preg_match($find, $fixstring)) {
		$fixstring = preg_replace($find, $replace, $fixstring);
	}

	return $fixstring;
}

/**
* Strip template start and end comments and trim, i.e. return null if there's nothing else there
*
* @param	str		String
* @return	str		Stripped string
*/

function ldm_strip_template($str) {
	$str = preg_replace("/<!-- [a-z]+ TEMPLATE: [^-]+ -->/i", "", $str);
	$str = trim($str);
	return $str;
}

/**
* Check and compare user's downloads and bandwidth allowances against consumption
*
* @param	int		=0: return current allowances/consumption; >0: include assumed download of $check bytes
* @param	int		access linkid; not used in this code but may be required within hooks
* @return	arr		array of allowances and consumption
*/

function ldm_check_user_allowances($check, $linkid=0) {
	global $vbulletin, $vbphrase;
	global $links_defaults, $links_permissions;
	global $LINK_UPLOAD;
	static $allow;

	$usergroupid = $vbulletin->userinfo['usergroupid'];
	$allow = array(
				'bytescredit' => 0, 'bytesdaily' => 0, 'bytesenable' => 0, 'byteshit' => 0,
				'filescredit' => 0, 'filesdaily' => 0, 'filesenable' => 0, 'fileshit' => 0,
				'uploadlimit' => 0, 'uploadenable' => 0, 'can_upload' => 1,
				'carryforward' => 1, 'can_download' => 1, 'errormessage' => '',
				);

	if ($links_permissions['can_bypass_bandwidth_limits']) {
		return $allow;
	}

	if ($links_defaults['bandwidth_limit']) {
		$limit = unserialize($links_defaults['bandwidth_limit']);
		if (isset($limit[$usergroupid])) {
			foreach ($limit[$usergroupid] as $k=>$v) {
				$allow[$k] = $v;
			}
			$allow['bytesdaily'] = ldm_decode_bytes($allow['bytesdaily']);
		}
	}

	$days = ($allow['carryforward'] ? $allow['carryforward'] : 1);
	$allow['filesavail'] = $allow['filesdaily']*$days;
	$allow['bytesavail'] = $allow['bytesdaily']*$days;

	$usertime = TIMENOW - ($allow['carryforward'] ? $allow['carryforward'] : 1) *60*60*24;

	$usertest_upload = "linkuserid='".intval($vbulletin->userinfo['userid'])."'";

	if ($limit[-1]['restrictbyip'] and isset($_SERVER[REMOTE_ADDR])) {
		$usertest = "userip='".$_SERVER[REMOTE_ADDR]."'";
	}
	elseif ($vbulletin->userinfo['userid']) {
		$usertest = "userid='".intval($vbulletin->userinfo['userid'])."'";
	}
	elseif (isset($_SERVER[REMOTE_ADDR])) {
		$usertest = "userip='".$_SERVER[REMOTE_ADDR]."'";
	}
	else {
		$usertest = "userid='0'";
	}

	($hook = vBulletinHook::fetch_hook('ldm_precheck_user_allowances')) ? eval($hook) : false;

	if ($allow['bytesenable'] or $allow['filesenable']) { // read recent consumption

		$query = "
			SELECT COUNT(dlid) AS hits, SUM(bytes) AS data
			FROM ".THIS_TABLE."linksdownloads
			WHERE ".$usertest."
			AND usertime>'".$usertime."'
			AND linkid>0
			AND bytes>0
			";
		$myrow = $vbulletin->db->query_first($query);
		$allow['fileshit'] = ($myrow['hits'] ? $myrow['hits'] : 0);
		$allow['byteshit'] = ($myrow['data'] ? $myrow['data'] : 0);

	}

	if ($allow['uploadenable']) { // read disk space used

		$query = "
			SELECT SUM(linksize) AS spaceused
			FROM ".THIS_TABLE."linkslink
			WHERE ".$usertest_upload."
			AND linkstatus=$LINK_UPLOAD
			";
		$myrow = $vbulletin->db->query_first($query);
		$allow['uploadused'] = ($myrow['spaceused'] ? $myrow['spaceused'] : 0);

	}

	if ($allow['filesenable'] and (($allow['fileshit']+1)>$allow['filesavail'])) $allow['can_download'] = 0;
	if ($allow['bytesenable'] and (($allow['byteshit']+$check)>$allow['bytesavail'])) $allow['can_download'] = 0;
	if ($allow['uploadenable'] and ($allow['uploadused']>=$allow['uploadlimit'])) $allow['can_upload'] = 0;

	$allow['consumption'] = $allow['filesbit'] = $allow['bytesbit'] = "";
	if ($allow['filesenable']) {
		$allow['filesbit'] = construct_phrase($vbphrase['ll_band_filesuse'], $allow['filesavail'], $allow['fileshit']);
	}
	if ($allow['bytesenable']) {
		$bytesav = ldm_format_bytes($allow['bytesavail']);
		$bytesus = ldm_format_bytes($allow['byteshit']);
		$allow['bytesbit'] = construct_phrase($vbphrase['ll_band_bytesuse'], $bytesav, $bytesus);
	}
	if ($allow['uploadenable']) {
		$bytesav = ldm_format_bytes($allow['uploadlimit']);
		$bytesus = ldm_format_bytes($allow['uploadused']);
		$allow['uploadbit'] = construct_phrase($vbphrase['ll_band_uploaduse'], $bytesav, $bytesus);
	}
	if ($allow['filesenable'] or $allow['bytesenable'] or $allow['uploadenable']) {
		eval("\$c  = \"".fetch_template('links_bandwidthbit')."\";");
		$allow['consumption'] = $c;
	}

	if (!$allow['can_download']) {
		$allow['errormessage'] = construct_phrase($vbphrase['ll_error_allowances'], $allow['consumption']);
	}

	($hook = vBulletinHook::fetch_hook('ldm_check_user_allowances')) ? eval($hook) : false;

	return $allow;

}

/**
* Generate <a href="url">title</a> tag for given category/entryid and mode
*	mode -3: jump to entry's rate & comment page
*	mode -2: return just the url without tag
*	mode -1: view entry
*	mode  0: masked jump to entry
*	case  1: masked jump to entry
*	case  2: open jump to entry
*	case 11: as mode 1, using Javascript-triggered form
*
* @param	int		mode
* @param	int		catid
* @param	int		linkid
* @param	str		linkname
* @param	str		url
* @param	str		title
* @return	str		result
*/

function ldm_get_url_atag($linkmode, $catid, $linkid, $linkname, $linkurl="", $title="") {
	global $vbulletin, $vbphrase;
	global $links_permissions, $links_defaults;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$target = "target='_blank'";

	if ($linkurl) {
		$urlInfo = ldm_parse_url($linkurl);
		if (array_key_exists('scheme', $urlInfo)) {
			if (!$links_defaults['open_remote_links_newwindow']) $target = "";
		}
		else {
			if (!$links_defaults['open_local_links_newwindow']) $target = "";
		}
	}

	switch ($linkmode) {
	case -3: // jump to rate & comment page
		$atag = '<a href="' . $vbulletin->options['bburl'] . "/" . $LINKS_SCRIPT . '.php?'.$vbulletin->session->vars['sessionurl'].'action=ratelink&amp;catid='.$catid.'&amp;linkid='.$linkid.
			'" title="'. $title .'">'.
			$linkname.'</a>';
		return $atag;

	case -2: // just the url, no tag
		$atag = ldm_seo_url("links", $catid, $linkid);
		return $atag;

	case -1: // view tags
		$atag = '<a href="' . ldm_seo_url("links", $catid, $linkid) . '" title="'. $title .'">'. $linkname.'</a>';
		break;
	case 0: // masked jump tags
	case 1:
		$atag = '<a href="' . ldm_seo_url("jump", $catid, $linkid) . '" title="'. $title .'" '.$target.">".$linkname.'</a>';
		break;
	case 2: // open jump tag
		if ($linkurl and !array_key_exists('host', $urlInfo)) {
			if ($links_defaults['local_file_root']) { // can't provide a clean url
				$atag = '<a href="' . ldm_seo_url("jump", $catid, $linkid) . '" title="'. $title .'" '.$target.">". $linkname.'</a>';
				break;
			}
			elseif ($links_defaults['local_file_root_prefix']) {
				$linkurl = ldm_make_filename($links_defaults['local_file_root_prefix'], $linkurl);
			}
		}
		$atag = '<a href="'.$linkurl.'" title="'. $title .'" '.$target.'>' . $linkname.'</a>';
		break;
	case 11: // As 1, but use Javascript-triggered form
		$atag = '<a href="javascript:ldm_downloadme(\'ldm_download\', '.$linkid.','.$catid.');" title="'. $title .'" >'.$linkname.'</a>';
		break;
	}

	return ldm_process_permission($atag, $linkname, $catid);
}

/**
* Generate a url reflecting current LDM seo settings.
*
* @param	str		mode, jump/play/links
* @param	int		catid
* @param	int		linkid
* @param	int		entityid
* @param	int		pagenumber
* @return	str		url
*/

function ldm_seo_url($mode, $catid, $linkid=0, $entityid=0, $pagenumber=0) {
	global $vbulletin;
	global $links_defaults, $linkscat;
	global $LINKS_SCRIPT;

	switch ($links_defaults['seo_friendly']) {

// Full name and id seo
	case 2:

    	$base_url = $vbulletin->options['bburl'] . "/" . ( $links_defaults['seo_title'] ? $links_defaults['seo_title'] : $LINKS_SCRIPT);
		$base_cat = "";
		if ($catid>0) {
			$catname = $linkscat[$catid]["catname_clean"];
			$catname = preg_replace(array("/[^a-z0-9_ \-\(\)]/", "/ /"), array("", "-"), strtolower($catname));
			if (!$catname) $catname = "category";
			$base_cat = '/c-' . $catname . '-' . $catid;
		}
		switch ($mode) {
		case "jump":
			$seo_url = $base_url . "/jump" . $base_cat . "/$linkid";
			break;
		case "play":
			$seo_url = $base_url . "/play" . $base_cat . "/$linkid";
			break;
		case "links":
		default:
			$seo_url = $base_url . "/links" . $base_cat;
			if ($linkid) {
				$seo_url .= "/$linkid";
			}
			break;
		}

		if ($pagenumber) {
			$seo_url .= '?' . $vbulletin->session->vars['sessionurl'] . "page=$pagenumber";
		}
		else {
			$seo_url .= $vbulletin->session->vars['sessionurl_q'];
		}

		if ($entityid) {
			$seo_url .= '&amp;entityid='.$entityid;
		}

		break;

// Numeric seo
	case 1:

    	$base_url = $vbulletin->options['bburl'] . "/" . ( $links_defaults['seo_title'] ? $links_defaults['seo_title'] : $LINKS_SCRIPT);
		switch ($mode) {
		case "jump":
			$seo_url = $base_url . "/jump/$linkid" . ($catid ? "/$catid" : "");
			break;
		case "play":
			$seo_url = $base_url . "/play/$catid/$linkid";
			break;
		case "links":
		default:
			$seo_url = $base_url . "/links/$catid" . ($linkid ? "/$linkid" : "");
			break;
		}

		if ($pagenumber) {
			$seo_url .= '?' . $vbulletin->session->vars['sessionurl'] . "page=$pagenumber";
		}
		else {
			$seo_url .= $vbulletin->session->vars['sessionurl_q'];
		}

		if ($entityid) {
			$seo_url .= '&amp;entityid='.$entityid;
		}

		break;

// No seo
	case 0:
	default:

    	$base_url = $vbulletin->options['bburl'] . "/" . $LINKS_SCRIPT;
		switch ($mode) {
		case "jump":
			$seo_url = $base_url . ".php?" . $vbulletin->session->vars['sessionurl'] . "action=jump&amp;catid=$catid&amp;id=$linkid";
			break;
		case "play":
			$seo_url = $base_url . ".php?" . $vbulletin->session->vars['sessionurl'] . "action=play&amp;catid=$catid&amp;linkid=$linkid";
			break;
		case "links":
		default:
			$seo_url = $base_url . ".php?" . $vbulletin->session->vars['sessionurl'] . "catid=$catid" . ($linkid ? "&amp;linkid=$linkid" : "");
			break;
		}

		if ($entityid) {
			$seo_url .= '&amp;entityid='.$entityid;
		}

		if ($pagenumber) {
			$seo_url .= "&amp;page=$pagenumber";
		}

		break;

	}

	$token = ldm_encrypt_authority($linkid, $catid);
	if ($token) {
		$token = "&amp;token=".$token;
	}

	return $seo_url.$token;

}

/**
* Modify a url according to user's *can_access_link* permission and *protected_link* setting
*
* @param	str		url
* @param	str		linkname
* @param	int		catid
* @return	str		modified url
*/

function ldm_process_permission($atag, $linkname, $catid) {
	global $vbulletin, $vbphrase;
	global $links_defaults, $links_permissions;

	if (!ldm_lookup_permission($catid, 'can_access_link')) {
		switch ($links_defaults['protected_link']) {
		case 0:
			return $linkname; // no hyperlink
		case 1:
			return $atag; // will generate informative 'no permission' message when selected
		case 2:
			if ($vbulletin->userinfo['userid'] == 0) {
				return '<a href="register.php'.$vbulletin->session->vars['sessionurl_q'].'" title="'. $vbphrase['ll_registertoview']. '">'.$linkname.'</a>'; // force registration
			}
			else {
				return $atag; // will generate informative 'no permission' message when selected
			}
		}
	}
	return $atag; // OK

}

/**
* Obtain the master sql query
*
* @param	array	WHERE conditions
* @param	int		Optional, time after which to limit entries
* @param	bool	Optional, include JOIN on favourites table
* @param	str		Optional, ORDER BY clause
* @param	int		Optional, LIMIT clause
* @param	bool	Optional, perform double JOIN on ltoc table to find other categories in which entries fall
* @param	bool	Optional, include JOIN on keywords table
* @return	str		SQL query
*/

function ldm_get_mainsql($where, $hitssince=0, $joinfavs=0, $order=0, $limit=0, $othercats=1, $joinkeys=0) {
	global $vbulletin, $links_defaults;
	$query = "
		SELECT
			link.linkid AS linkid, link.linkname AS linkname, link.linkdoi AS linkdoi,
			link.linkuserid AS linkuserid, link.linkusername AS linkusername,
			link.linkurl AS linkurl, link.linkimg AS linkimg,
			link.linkimgthumb AS linkimgthumb, link.linkimgthumbsize AS linkimgthumbsize, link.linkforum AS linkforum,
			link.linkdesc AS linkdesc, link.numrate AS numrate, link.totrate AS totrate, link.numcomment AS numcomment,
			link.linkhits AS linkhits, link.linksize AS linksize, link.linkstatus AS linkstatus,
			link.linkdate AS linkdate, link.linkmoderate AS linkmoderate, link.linkmoddate AS linkmoddate,
			link.linkreviewfreq AS linkreviewfreq,
			ltoc.catid AS linkcatid, ltoc.displayorder AS linkdorder
			" . ($links_defaults['show_avatars'] ? ', user.userid AS userid, user.avatarid AS avatarid, user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight' : "") . "
			" . ($othercats ? ", ltoc2.catid AS linkcatid2" : "") . "
			" . ($hitssince ? ", COUNT(lhits.linkid) AS linkrecenthits" : "") . "
			" . ($joinkeys ? ", lkeys.keyid AS linkkeyid, lkeys.keyword AS linkkey" : "") . "
			FROM ".THIS_TABLE."linkslink AS link
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc ON link.linkid = ltoc.linkid
			" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = link.linkuserid)" : "") . "
			" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)" : "") . "
			" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)" : "") . "
	";

	if ($othercats) {
		$query .= "
			LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc2
			ON link.linkid = ltoc2.linkid
		";
	}
	if ($hitssince) {
		$query .= "
			LEFT JOIN ".THIS_TABLE."linksdownloads AS lhits
			ON link.linkid = lhits.linkid
		";
	}
	if ($joinfavs) {
		$query .= "
			LEFT JOIN ".THIS_TABLE."linksfavs AS lfav
			ON link.linkid = lfav.linkid
		";
	};
	if ($joinkeys) {
		$query .= "
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON link.linkid = ltok.linkid
			LEFT JOIN ".THIS_TABLE."linkskeys AS lkeys
			ON ltok.keyid = lkeys.keyid
		";
	};
	$nw = 0;
	foreach ($where as $w) {
		$query .= ($nw++ ? " AND " : " WHERE ") . $w . ' ';
	}
	if ($hitssince) {
		$query .= ($nw++ ? " AND " : " WHERE ") . "lhits.usertime>=" . $hitssince . "
			GROUP BY linkid, linkcatid" . ($othercats ? ", linkcatid2" : "") . ($joinkeys ? ", linkkey" : "") . "
		";
	}
	if ($order) {
		$query .= "
			ORDER BY ".$order;
	}
	if ($limit) {
		$query .= "
			LIMIT ".$limit;
	}

	($hook = vBulletinHook::fetch_hook('ldm_mainsql_complete')) ? eval($hook) : false;

	return $query;
}

/**
* Obtain sql sub-query used to sort linkbit searches
*
* @param	str		Sort type, character or number of days
* @param	bool	Include display order as a sort criterion
* @return	str		"ORDER BY" clause
*/

function ldm_get_sortsql($sort, $withlinkdorder=1) {
	$linkdorder = ($withlinkdorder ? "linkdorder ASC, " : "");
	if (is_numeric($sort)) {
		$sorder = $linkdorder."  linkrecenthits DESC, linkname ASC, linkcatid ASC";
	}
	else {
		switch ($sort) {
		case 'r': $sorder = $linkdorder."  IF(numrate>0,(totrate/numrate),numrate) DESC, linkname ASC, linkcatid ASC"; break;
		case 'R': $sorder = $linkdorder."  IF(numrate>0,(totrate/numrate),numrate) ASC,  linkname ASC, linkcatid ASC"; break;
		case 'd': $sorder = $linkdorder."  linkdate DESC, linkname ASC, linkcatid ASC"; break;
		case 'D': $sorder = $linkdorder."  linkdate ASC,  linkname ASC, linkcatid ASC"; break;
		case 'h': $sorder = $linkdorder."  linkhits DESC, linkname ASC, linkcatid ASC"; break;
		case 'H': $sorder = $linkdorder."  linkhits ASC,  linkname ASC, linkcatid ASC"; break;
		case 'u': $sorder = $linkdorder."  linkusername DESC,  linkname ASC, linkcatid ASC"; break;
		case 'U': $sorder = $linkdorder."  linkusername ASC,  linkname ASC, linkcatid ASC"; break;
		case 'n': $sorder = $linkdorder."  linkname DESC, linkcatid ASC"; break;
		case 'N':
		default:  $sorder = $linkdorder."  linkname ASC,  linkcatid ASC"; break;
		}
	}

	($hook = vBulletinHook::fetch_hook('ldm_sortsql_complete')) ? eval($hook) : false;

	return $sorder;
}

/**
* Process subtitles string
*
* @param	str		Multi-line string, each line 'nn subtitle'
* @return	array	Element 'nn' holds 'subtitle'
*
*/

function cache_LDMsubtitles($subtitles) {
	$subtitle_array = array();
	if ($subtitles) {
		$subtitles = explode("\n", $subtitles);
		foreach ($subtitles as $subtitle) {
			if (preg_match("/\s*(\d+)\s+(.+)\s*/", $subtitle, $matches)) {
				$subtitle_array[$matches[1]] = $matches[2];
			}
		}
	}
	return $subtitle_array;
}

/**
* Recursively construct subcategories bit inside main catbit
*
* @param	str		Template
* @param	str		Category tree provided by ldm_cat_walk
* @param	str		Maximum depth to process
* @param	str		Current depth
* @return	str		Subcategories bit
*
*/

function ldm_get_subcategorybit($subtemplate, $subtree, $limit, $depth=0) {
	global $vbulletin, $vbphrase, $stylevar;
	global $linkscat, $limitfids, $links_defaults, $ldm_icon_cache;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;
	static $count, $linecount, $dorder, $subicon="";

	$subcatbit = '';
//	$subicon = "";

	if ($depth==0) {
		$count = 0;
		$linecount = 0;
		$dorder = -999999;
	}

	foreach ($subtree as $subid=>$subchildren) {
		if (in_array($linkscat[$subid]["catforum"], $limitfids)) continue;

		$subname   = $linkscat[$subid]["catname_clean"];
		$sublink   = $linkscat[$subid]["childlinks"];
		$subdorder = $linkscat[$subid]["displayorder"];

		$thissubdate = (ldm_lookup_setting($subid, 'count_depth') ? $linkscat[$subid]['childdate'] : $linkscat[$subid]['catdate']);
		$subcatnew = ($vbulletin->userinfo['lastvisit'] < $thissubdate ? 1 : 0);

		$this_subicon_setting = ldm_lookup_setting($subid, 'subcat_icon');

		if ($this_subicon_setting=="0") {
			$this_subicon = "";
		}
		elseif ($this_subicon_setting=="") {
			$this_subicon = isset($ldm_icon_cache['category']) ? $ldm_icon_cache['category'] : "";
		}
		else {
			$this_subicon = $this_subicon_setting;
		}

		if ($this_subicon and ($this_subicon!=$subicon or ($depth==0 and $count==0))) {
			$parseicon = parse_url($this_subicon);
			if (!$parseicon['host']) {
				$this_subicon = ldm_make_filename_nonrel($vbulletin->options['bburl'], $this_subicon);
			}
			$subcatbit .= ldm_get_imagebit($this_subicon);
		}

		$subicon = $this_subicon;

		$count++;

		if ($limit and ($limit<$count)) {
			$subcatbit .= " ...";
			return $subcatbit;
		}

		$linebreak = 0;
		if ($links_defaults['cat_sub_display_perline']>0 and $linecount>=$links_defaults['cat_sub_display_perline']) {
			$linebreak = 1;
			$linecount = 0;
		}

		if ($linecount>0 and $links_defaults['cat_sub_display_dorder'] and $dorder!=$subdorder) {
			$linebreak = 1;
			$linecount = 0;
		}

        $dorder = $subdorder;
		$linecount++;

		$suburl = ldm_seo_url($links_defaults['seo_friendly'], $subid);
		eval("\$subcatbit .= \"".fetch_template($subtemplate)."\";");
		$subcatbit .= ldm_get_subcategorybit($subtemplate, $subchildren, $limit, $depth+1);

	}
	return $subcatbit;
}

/**
* Constructs main category bits
*
* @param	array	Returns with category bits
* @param	str		Template
* @param	str		Template
* @param	int		Category id to process
* @param	array	Child category ids to process
* @param	bool	If true, check moderation permissions before creating bit
* @param	int		Current depth
* @param	int		Current page number
*
*/

function ldm_get_categorybits(&$catlistarray, $template, $subtemplate, $thisid, $thischildren, $modcats, $subdepth=1, $categorypage=1) {
	global $vbulletin, $vbphrase, $stylevar;
	global $linkscat, $catstyle, $links_defaults;
	global $tomod, $links_permissions, $ldm_icon_cache;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;
	global $viewcatid;

	$thiscat = $linkscat[$thisid];
	$catid	= $thiscat["catid"];

	($hook = vBulletinHook::fetch_hook('ldm_catbit_start')) ? eval($hook) : false;

// Users can always see their own categories.  Otherwise, they require both forum-based and LDM access permissions
	if (!$vbulletin->userinfo['userid'] or $vbulletin->userinfo['userid'] != $thiscat['catuserid']) {

		if (!ldm_lookup_permission($catid, 'can_view_category')) {
			return;
		}

		$can_bypass =
			ldm_lookup_permission($catid, 'can_see_protected_links_on_portal') |
			ldm_lookup_permission($catid, 'can_bypass_forumperms');
		$limitfids = ldm_lookup_forum_protections($can_bypass);
		if (in_array($thiscat["catforum"], $limitfids)) {
			return;
		}

		if ($thiscat['catmoderate']) {
			if (!ldm_lookup_permission($catid, 'can_moderate_links') and !ldm_lookup_permission($catid, 'can_moderate_forums')) {
				return;
			}
		}
	}

	if ($modcats and $thiscat['catforum'] and !ldm_lookup_permission($catid, 'can_moderate_links')) {
		if (!can_moderate($thiscat['catforum'], 'canmoderateposts')) {
			return;
		}
	}

// Category is visible to user
	$catname = ldm_parse_features($thiscat["catname"]);
	$catusername = $thiscat['catusername'];
	$catuserid = $thiscat['catuserid'];
	$catdesc  = ldm_parse_features($thiscat["catdesc"]);
	$catshortdesc = ldm_kill_bbcodes($thiscat["catdesc"]);
	if (strlen($catshortdesc)>$links_defaults['length_shortdesc']) {
		$catshortdesc = substr($catshortdesc, 0, $links_defaults['length_shortdesc']).'...';
	}
	$cattext  = ldm_parse_features($thiscat["cattext"]);
	$catsub = $thiscat["catsub"];
	$catchildsub = $thiscat["childcats"];
	$catentry = $thiscat["catentry"];
	$catchildentry = $thiscat["childlinks"];
	$catclosed = $thiscat["catclosed"];
	$catsyncdone = (!$thiscat["catsyncdir"] or !ldm_lookup_setting($catid, 'sync_enabled') or $thiscat["catsyncdone"]);

	$thisdate = (ldm_lookup_setting($catid, 'count_depth') ? $thiscat['childdate'] : $thiscat['catdate']);
	$catdate = ldm_date($vbulletin->options['dateformat'], $thisdate);

	$catnew = 0;
	if ($vbulletin->userinfo['lastvisit'] < $thisdate) {
		$catnew = 1;
		if (!ldm_lookup_permission($catid, 'can_view_hidden')) {
			if (ldm_lookup_setting($catid, 'links_expiry_days')>0 and $thiscat['catdate']>TIMENOW) {
				$catnew = 0;
			}
		}
	}

	cache_LDMicons();

	$iconnew_setting = ldm_lookup_setting($catid, 'cat_icon_new');
	if ($iconnew_setting=="0") {
		$iconnew = "";
	}
	elseif ($iconnew_setting=="") {
		$iconnew = isset($ldm_icon_cache['category_new']) ? $ldm_icon_cache['category_new'] : "";
	}
	else {
		$iconnew = $iconnew_setting;
	}

	$iconold_setting = ldm_lookup_setting($catid, 'cat_icon');
	if ($iconold_setting=="0") {
		$iconold = "";
	}
	elseif ($iconold_setting=="") {
		$iconold = isset($ldm_icon_cache['category']) ? $ldm_icon_cache['category'] : "";
	}
	else {
		$iconold = $iconold_setting;
	}

	$caticonbit = "";
	if ($iconnew and $catnew) {
		$caticonbit = ldm_get_imagebit($iconnew, $vbphrase['ll_newentries']);
	}
	elseif ($iconold and !$catnew) {
		$caticonbit = ldm_get_imagebit($iconold);
	}

	$catmoderate = 0;
	if ($links_permissions['can_moderate_links']) {
		$catmoderate = $thiscat["catmoderate"];
	}
	elseif ($thiscat['catforum']>0 and $links_permissions['can_moderate_forums']) {
		if (can_moderate($thiscat['catforum'], 'canmoderateposts')) {
			$catmoderate = $thiscat["catmoderate"];
		}
	}
	$linkmoderate = $tomod[$thiscat['catid']];

	$subcatnames = "";

	if ($subdepth>=$links_defaults['cat_depth_display'] and $links_defaults['cat_sub_display']>0) {
		$subtree = ldm_cat_walk($thisid, $links_defaults['cat_sub_display']);
		$subcatnames = ldm_get_subcategorybit($subtemplate, $subtree, $links_defaults['cat_sub_display_limit']);
	}

	$cateditbit = "";
	if ($links_permissions['can_edit_category'] or ($vbulletin->userinfo['userid']==$catuserid)) {
		$cateditbit = (isset($ldm_icon_cache['pencil']) ? ldm_get_imagebit($ldm_icon_cache['pencil'], $vbphrase['ll_edit']) : '['.$vbphrase['ll_editlc'].']');
	}

	($hook = vBulletinHook::fetch_hook('ldm_catbit_create')) ? eval($hook) : false;

	$catindent = ($subdepth-1)*$links_defaults['cat_depth_indent']+1;

	$catseo = ldm_seo_url("links", $thisid);
	eval("\$catlistarray[] = \"".fetch_template($template)."\";");
	$catstyle = ($catstyle==1 ? 2 : 1);
	$thisorder = $displayorder;

	if (is_array($thischildren)) {
		foreach ($thischildren as $childid=>$grandchildren) {
			ldm_get_categorybits($catlistarray, $template, $subtemplate, $childid, $grandchildren, $modcats, $subdepth+1);
		}
	}

	return;
}

/**
* Map listbit vector onto a grid to produce multicolumn layouts
*
* @param	array	Listbit vector
* @param	int		No. columns
* @param	bool	Row then column (true); Column then row (false)
* @param	str		Template used for spacer rows
* @param	array	Array of subtitle strings for separator rows
* @return	bool	String, html
*
* Explanation: Listbit vectors are zero-based arrays of listbits. Each listbit element
* either contains a table row (<tr>..</tr>) or is null or holds an integer string.  Null listbits
* instruct LDM to add blank spacer rows using the $separator template. Integer
* listbits (set to 'n') add spacer rows which include the n-th title from $subtitles
*/

function ldm_map_listbit_to_grid($listbit, $columns=1, $horizontal=0, $separator='links_linkseparator', $subtitles='') {

	$ilast = count($listbit)-1;
	if ($ilast<0) {
		return "";
	}

	$result = "";
	$istart = 0;
	$inext = 0;

	if ($subtitles) {
		$subtitle_array = cache_LDMsubtitles($subtitles);
	}

	while (1) {
// End of array?
		if ($inext>$ilast) {
			break;
		}

		if ($listbit[$inext] and !ctype_digit($listbit[$inext])) {
			$inext++;
			continue;
		}

// We've hit a separator
		if ($inext>$istart) {
			$result .= ldm_layout_listbit(array_slice($listbit, $istart, $inext-$istart), $columns, $horizontal);
		}

		if ($inext<$ilast) {
			$linkseparator = "";
			$separator_title = "";
			if ($separator) {
				$listbitseq = $listbit[$inext];
				if ($subtitles and isset($subtitle_array[$listbitseq])) {
					$separator_title = $subtitle_array[$listbitseq];
				}
			}
			if ($separator and ($separator_title or $inext>$istart)) {
				eval("\$linkseparator = \"".fetch_template($separator)."\";");
				$result .= $linkseparator;
			}
		}

		$inext++;
		$istart = $inext;

	}

	if ($istart<=$ilast) {
		$result .= ldm_layout_listbit(array_slice($listbit, $istart), $columns, $horizontal);
	}
	return $result;

}

/**
* Do the detailed work for ldm_map_listbit_to_grid for one group of listbits
*
* @param	array	Listbit vector
* @param	int		No. columns
* @param	bool	Row then column (true); Column then row (false)
* @return	str		Table structure
*
*/

function ldm_layout_listbit($listbit, $columns, $horizontal) {
	global $stylevar;
	$result = "";

// Straightforward single column cases
	if ($columns==1) {
		$alt = 1;
		foreach ($listbit as $thisbit) {
			$result .= "\n".'<tr><td colspan="2" class="alt'.$alt.'">'."\n".
	    			'<table style="width:100%; height:100%;" border="0" cellpadding="0" cellspacing="0">'."\n".
		    		$thisbit.
			    	"\n</table></td></tr>\n";
		    $alt = ($alt==1 ? 2 : 1);
		}
		return $result;
	}

// Multicolumn cases
	$emptycell = '<tr><td>&nbsp;</td></tr>';
	if ($horizontal) {

		$kr = 1; $kc = 1;
		foreach ($listbit as $thisbit) {
			$table[$kr][$kc] = $thisbit;
			$kc+=1;
			if ($kc>$columns) {
				$kc=1;
				$kr+=1;
			}
		}
		if ($kc>1) {
			while ($kc<=$columns) {
				$table[$kr][$kc] = $emptycell;
				$kc+=1;
			}
		}

	}
	else {

		$nr = 1 + (int) (count($listbit)-1)/$columns;
		$kr = 1;
		$kc = 1;
		$table = array();
		foreach ($listbit as $thisbit) {
			$table[$kr][$kc] = $thisbit;
			$kr+=1;
			if ($kr>$nr) {
				$kr=1;
				$kc+=1;
			}
		}
		while ($kc<=$columns) {
			while ($kr<=$nr) {
				$table[$kr][$kc] = $emptycell;
				$kr+=1;
			}
			$kc+=1;
		}
	}

	$alt = 1;
	foreach ($table as $kr=>$row) {
		$result .= "\n".'<tr><td colspan="2" class="alt'.$alt.'">'."\n".
	    		'<table style="width:100%; height:100%;" border="0" cellpadding="0" cellspacing="0"><tr>'."\n";
		foreach ($row as $kc=>$cell) {
			$width = ($kc<$columns ? (int) round(100/$columns) : 100-($columns-1)*((int) round(100/$columns)));
			$result .= '<td valign="top" align="center" style="width:'.$width.'%; height:100%;">'.
	    			'<table style="width:100%; height:100%;" border="0" cellpadding="0" cellspacing="0">'."\n".
		    		$cell.
			    	"\n</table></td>\n";
			if ($kc<$columns) {
				$result .= '<td width="'.$stylevar['cellpadding'].'">&nbsp;</td>'."\n";
			}
		}
	    $result .= "\n</tr></table></td></tr>\n";
		$alt = ($alt==1 ? 2 : 1);
	}

	unset($table);
	return $result;

}

/**
* Return column count for given category template
*
* @param	str		Template
* @return	int		Columns
*
*/

function ldm_catbit_columns($template) {
	global $links_defaults, $ldm_catbitcache;
	if (!$links_defaults['cat_cols_display']) {
		$ncols = $ldm_catbitcache[$template]['defcol'];
	}
	elseif ($links_defaults['cat_cols_display']>$ldm_catbitcache[$template]['maxcol']) {
		$ncols = $ldm_catbitcache[$template]['maxcol'];
	}
	else {
		$ncols = $links_defaults['cat_cols_display'];
	}
	return $ncols;
}

/**
* Return column count for given entrybit template
*
* @param	str		Template
* @return	int		Columns
*
*/

function ldm_entrybit_columns($template) {
	global $links_defaults, $ldm_linkbitcache;
	if (!$links_defaults['link_cols_display']) {
		$ncols = $ldm_linkbitcache[$template]['defcol'];
	}
	elseif ($links_defaults['link_cols_display']>$ldm_linkbitcache[$template]['maxcol']) {
		$ncols = $ldm_linkbitcache[$template]['maxcol'];
	}
	else {
		$ncols = $links_defaults['link_cols_display'];
	}
	return $ncols;
}

/**
* Decipher avatar
*
* @param	array	avatar array
* @return	str		image tag for avatar
*/

function ldm_get_avatarinfo($avatarinfo) {
	global $vbulletin;
	global $links_defaults;

	if (!$links_defaults['show_avatars']) {
		return '';
	}

	$avatar_title = $avatarinfo['username'];

	if (!empty($avatarinfo['avatarpath'])) {
		return ldm_get_imagebit($avatarinfo['avatarpath'], $avatar_title);
	}

	if ($avatarinfo['hascustomavatar']) {
		$avatarurl = array();
		if ($vbulletin->options['usefileavatar']) {
			$avatarurl[] = $vbulletin->options['avatarurl'] . "/avatar".$avatarinfo['linkuserid']."_".$avatarinfo['avatarrevision'].".gif";
		}
		else {
			$avatarurl[] = "image.php?".$vbulletin->session->vars['sessionurl']."u=".$avatarinfo['linkuserid']."&amp;dateline=".$avatarinfo['avatardateline'];
		}

		if ($avatarinfo['width'] AND $avatarinfo['height']) {
			$avatarurl[] = " width=\"$avatarinfo[width]\" height=\"$avatarinfo[height]\" ";
		}
		else {
		    $avatarurl[] = "";
		}
        return ldm_get_imagebit($avatarurl[0], $avatar_title, $avatarurl[1]);
	}

	return ldm_get_imagebit($vbulletin->options['cleargifurl']);

}

/**
* Construct main linkbit
*
* @param	array	Returns with array of linkbits
* @param	array	Returns with array of linkids
* @param	array	Returns with array of expired linkids
* @param	str		Linkbit template
* @param	str		SQL query to grab entries
* @param	array	Build options
* @param	int		Pagenumber
* @param	int		Total pages
* @return	int		Total number of entries that match sql query
*/

function ldm_get_entrybits(&$linklistarray, &$hitids, &$expiredids, $template, $query, $options=array(), $pagenumber=1, $perpage=999999) {

	global $vbulletin, $stylevar, $vbphrase, $vbcollapse;
	global $links_permissions, $links_defaults;
	global $links_fav, $links_mystarred, $links_starred, $ldm_linkid_ratings;
	global $linkscat, $ldm_icon_cache, $LDM_environment;
	global $ldm_protocol_schemes;

	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;
	global $LINK_TO_MODERATE, $LINK_HIDDEN, $BASE_CAT, $NOM_CAT, $CNOM_CAT;

    // Needed in order to ensure unique entybit ids, e.g. for ajax processing
    static $uniqueid = 0;
    $unique_entrybitids = array();

	$first = $perpage*($pagenumber-1) + 1;
	$last = $first + $perpage - 1;
	$thits = 0;
	$nhits = 0;

	$sort = $options['sort'];
	$viewcatid = $options['viewcatid'];
	$viewlinkid = $options['viewlinkid'];

	$linkstyle = 1;
	$thisid = -1;
	$hitids = array();
	$entityhitids = array();
	$expiredids = array();
	$linkcatlist = array();
	$linkkeylist = array();
	$linklistarrayids = array();
	$linklistarraykey = 0;
	$linkcatname = "";
	$linkcat = 0;

	cache_LDMicons();
	$subtitle_array = cache_LDMsubtitles($links_defaults['cat_entry_dseq_titles']);

	$expire = 0;
	if ($links_defaults['links_expiry_days']>0) {
		$expire = $links_defaults['links_expiry_days']*86400;
	}

	$highlight_find = array();
	$highlight_repl = array();
	if (isset($options['highlight'])) {
		ldm_make_highlight_regex($options['highlight']['string'], $options['highlight']['literal'], $highlight_find, $highlight_repl);
	}

	require_once(DIR . '/includes/local_links_players.php');

	$linksavetext = (is_browser('mozilla') ? $vbphrase['ll_visitdownload_moz'] : $vbphrase['ll_visitdownload']);

	unset($thisorder);
	$asb = $vbulletin->db->query_read($query);
	while ($myrow=$vbulletin->db->fetch_array($asb)) {

// Successive database records can refer to same entry, e.g. when entry sits in multiple categories, etc
		if ($myrow["linkid"] == $thisid) {
			if (isset($myrow["linkcatid2"]) and $myrow["linkcatid2"] != $myrow["linkcatid"] and !in_array($myrow["linkcatid2"], $linkcatlist)) {
				$linkcatlist[] = $myrow["linkcatid2"];
			}
			if ($myrow["linkkey"] and !in_array($myrow["linkkey"], $linkkeylist)) {
				if ($links_defaults['apply_censor']) {
					$linkkeylist[$myrow["linkkeyid"]] = fetch_censored_text($myrow["linkkey"]);
				}
				else {
					$linkkeylist[$myrow["linkkeyid"]] = $myrow["linkkey"];
				}
			}
			continue;
		}

		($hook = vBulletinHook::fetch_hook('ldm_linkbit_read')) ? eval($hook) : false;

// Start by completing creation of previous linkbit if any
		if ($thisid > 0) {

			$accept_hit = 1;
			if (($linkstatus==$LINK_HIDDEN or $linkexpired) and !$link_can_view_hidden) {
				$accept_hit = 0;
			}

			if (isset($options['requirekeyid']) and !isset($linkkeylist[$options['requirekeyid']])) {
				$accept_hit = 0;
			}

			if ($accept_hit) {
				$thits++;
			}

			if ($accept_hit and $thits >= $first and $nhits <= $perpage-1) {

                $unique_entrybitids[$linkid] = (++$uniqueid);
				if (isset($thisorder) and isset($subtitle_array[$thisorder]) and !$linklistarraykey and !$options['forcedisplayorder']) {
					$linklistarray[$linklistarraykey] = $thisorder;
					$linklistarraykey++;
				}

				$linkkeys = ldm_make_highlighted_keys($linkkeylist, $highlight_find, $highlight_repl);
				$linkkeysraw = implode(' ', $linkkeylist);

				$linkratebitdropdown = $linkratebitinline = "";
				if ($links_defaults["dropdown_comment_and_rate"]) {
					eval("\$linkratebitdropdown = \"".fetch_template('links_ratebit_dropdown')."\";");
					$linkratebitdropdown = trim($linkratebitdropdown);
				}
				if ($links_defaults["inline_comment_and_rate"]) {
					eval("\$linkratebitinline = \"".fetch_template('links_ratebit_inline')."\";");
					$linkratebitinline = trim($linkratebitinline);
				}

				$linkothercatsbit = "";
				$linkshowothercatbit = 0;
				foreach ($linkcatlist as $linkothercat) {
					$linkothercatname = $linkscat[$linkothercat]["catname_clean"];
					if (!$options['showcatname']) {
						$linkshowothercatbit = 1;
					}
					eval("\$linkothercatsbit .= \"".fetch_template('links_othercatsbit')."\";");
				}

				eval("\$linkkeysbit = \"".fetch_template('links_keysbit')."\";");

				($hook = vBulletinHook::fetch_hook('ldm_linkbit_create')) ? eval($hook) : false;

				if (($linkstatus!=$LINK_HIDDEN and !$linkexpired) or $link_can_view_hidden) {
					eval("\$linklistarray[$linklistarraykey] = \"".fetch_template($template)."\";");
					$linklistarrayids[$linkid] = $linklistarraykey;
					$linklistarraykey++;
					$hitids[$linkid] = $linkcatid;
					if (ldm_lookup_setting($linkcatid, "display_entities") and ldm_lookup_permission($linkcatid, "can_view_entities")) {
						$entityhitids[$linkid] = $linkcatid;
					}
					$linkstyle = ($linkstyle==1 ? 2 : 1);
					$nhits++;
				}

				if (isset($thisorder) and $myrow["linkdorder"] != $thisorder and !$options['forcedisplayorder']) {
					$linklistarray[$linklistarraykey] = $myrow["linkdorder"];
					$linklistarraykey++;
				}
			}

			$thisid = -1;
			unset ($linkcatlist);
			$linkcatlist = array();
			$linkkeylist = array();
			$linkcatname = "";

		}

// Shall we start a new linkbit?
		$thisid = $linkid = $myrow["linkid"];
		if ($nhits >= $perpage) continue;
		if ($thits+1 < $first) continue;  // watch out for problems with this...

// Yes, build the data structures for the new linkbit
		$linkcatid = $myrow["linkcatid"];
		if (!$linkcatname) $linkcatname = $linkscat[$linkcatid]["catname_clean"];
		$thisorder = $myrow["linkdorder"];

		$link_can_access_link = ldm_lookup_permission($linkcatid, "can_access_link"); // NB: use lookup() as may not be in entry's category
		if ($link_can_access_link and $myrow['linkforum']>0) {
			$can_bypass = ldm_lookup_permission($linkcatid, 'can_bypass_forumperms');
			$limitfids = ldm_lookup_forum_protections($can_bypass);
			if (in_array($myrow['linkforum'], $limitfids)) {
				$link_can_access_link = 0;
			}
		}

        $ldmcollapseobj_linkbit = $vbcollapse['collapseobj_linkbit'.$linkid];
        $ldmcollapseimg = $stylevar['imgdir_button'].'/collapse_alt'.$vbcollapse['collapseimg_linkbit'.$linkid].'.gif';
        $ldmcollapseimg_linkbit = ldm_get_imagebit($ldmcollapseimg, "", "id=collapseimg_linkbit".$linkid);

		$link_can_view_hidden = ldm_lookup_permission($linkcatid, "can_view_hidden");
		$link_can_play_musicbox = ldm_lookup_permission($linkcatid, "can_play_musicbox");
		$link_can_save_musicbox = ldm_lookup_permission($linkcatid, "can_save_musicbox");

		$linkavatar = ldm_get_avatarinfo($myrow);

		if ($options['showcatname']) {
			if (!in_array($myrow["linkcatid"],$linkcatlist)) {
				$linkcatlist[] = $myrow["linkcatid"];
			}
		}
		if (isset($myrow["linkcatid2"]) and $myrow["linkcatid2"] != $myrow["linkcatid"]) {
			$linkcatlist[] = $myrow["linkcatid2"];
		}

		if ($myrow["linkkey"] and !in_array($myrow["linkkey"], $linkkeylist)) {
			if ($links_defaults['apply_censor']) {
				$linkkeylist[$myrow["linkkeyid"]] = fetch_censored_text($myrow["linkkey"]);
			}
			else {
				$linkkeylist[$myrow["linkkeyid"]] = $myrow["linkkey"];
			}
		}

		$linktopline = "";
		$linkbottomline = "";

		$linkmoddate = $myrow['linkmoddate'];
		$linkreviewfreq = $myrow['linkreviewfreq'];
		if ($linkreviewfreq>0) {
			$linkmoddate = $linkmoddate ? ldm_date($vbulletin->options['dateformat'], $linkmoddate) : $vbphrase['ll_never'];
		}

// Handle textual elements of linkbit
		$linkname	= $myrow["linkname"];
		$linkshortname = fetch_trimmed_title(ldm_kill_bbcodes($linkname), $links_defaults['length_shortname'], 1);
		$linkdesc	= $myrow["linkdesc"];
		$linkshortdesc = fetch_trimmed_title(ldm_kill_bbcodes($linkdesc), $links_defaults['length_shortdesc'], 1);
		$linkname	= ldm_parse_features(trim($linkname));
		$linkname_nohighlight = $linkname;
		$linkshortname	= ldm_parse_features(trim($linkshortname));
		$linkdesc	= ldm_parse_features(trim($linkdesc));
		$linkshortdesc	= ldm_parse_features(trim($linkshortdesc));
		if (isset($options['highlight']) and $options['highlight']['desc']) {
			$linkname	= ldm_apply_highlight($linkname, $highlight_find, $highlight_repl);
			$linkdesc	= ldm_apply_highlight($linkdesc, $highlight_find, $highlight_repl);
		}
		if (!trim($linkname)) $linkname = "&nbsp;";
		if (!trim($linkdesc)) $linkdesc = "&nbsp;";
		$linkdoi	= $myrow["linkdoi"];

// Handle url part of linkbit
		$linkurl	= $myrow["linkurl"];
		$linkfiletype = "";
		$linkshorturl = (strlen($linkurl)>$links_defaults['length_shortdesc'] ? substr($linkurl, 0, $links_defaults['length_shortdesc']).'...' : $linkurl);
		$urlInfo = ($linkurl ? ldm_parse_url($linkurl) : array());
		$linkurljump = $linkname;
		$linktypebit = "";
		$linksavebit = "";
		$linkurlextra = "";

		$linkurllink = ldm_get_url_atag(-1, $linkcatid, $linkid, $linkname);
		$linkurlshortlink = ldm_get_url_atag(-1, $linkcatid, $linkid, $linkshortname);
		$linksize = 0;
		$is_musicbox = 0;
		$link_known_mimetype = 0;

		if ($linkurl) {
			$urlInfo	= ldm_parse_url($linkurl);
			$urlType	= file_extension($urlInfo['path']);
			if (isset($urlInfo['scheme'])) {
				$linkmode = (isset($ldm_protocol_schemes[$urlInfo['scheme']]) ? $ldm_protocol_schemes[$urlInfo['scheme']]["mode"] : MODE_OPEN);
			}
			else {
				$linkmode = 1;
			}

			$linkmode	= max($linkmode, $links_defaults["force_redirect"]);
			$linkurljump = "";
			$linkurlsave = "";

			$link_known_mimetype = ldm_known_filetype($urlType);
			$linkfiletype = strtolower($urlType);

			if (get_ldm_playerid($linkid, $linkurl, $linkfiletype)>=0) {
				$is_musicbox = 1;
			}

			$musicbox_window = ($links_defaults['open_musicbox_newwindow'] ? 'target="player" onclick="ldm_popup(this.href);return false;"' : 'target="_top"');
			$musicbox_seo = ldm_seo_url("play", $linkcatid, $linkid, 0, $pagenumber);
			$musicbox_template = '<a href="'.$musicbox_seo.'" '.$musicbox_window.' rel="jukebox" title="'.$vbphrase['ll_playme'].'">%s</a>';

			if (!$link_can_access_link and isset($ldm_icon_cache['lock'])) {
				$linktypebit = ldm_get_imagebit($ldm_icon_cache['lock'], $vbphrase['ll_error_noaccess']);
			}
			else {
				$insert_into = $alttag = "";
				if ($link_can_access_link and $is_musicbox and $link_can_play_musicbox) {
					$insert_into = $musicbox_template;
					$alttag = $vbphrase['ll_playme'];
				}
				$linktypebit = ldm_get_typebit($urlInfo, $alttag, $insert_into);
			}

			if ($link_can_access_link and $link_known_mimetype) {
				eval("\$linksavebit .= \"".fetch_template('links_downloadbit', 0, 0)."\";");
			}

			$linkpopup = ($link_known_mimetype ? $linksavetext : $vbphrase['ll_visiturl']);

			if ($options['forcereview']) {
				$linkurljump = ldm_get_url_atag(-3, $linkcatid, $linkid, $linkname, $linkurl, $linkpopup);
			}
			else {
				$linkurljump = ldm_get_url_atag($linkmode, $linkcatid, $linkid, $linkname, $linkurl, $linkpopup);
			}

			if ($link_can_access_link) {
				if ($is_musicbox and !$option['forcereview']) {
					if ($link_can_play_musicbox) {
						$linkurljump = ldm_process_permission(sprintf($musicbox_template, $linkname), $linkname, $linkcatid);
					}
					if (isset($urlInfo['scheme'])) {
						if ($ldm_protocol_schemes[$urlInfo['scheme']]["musicbox"]==0) {
							$linkurljump = ldm_get_url_atag($linkmode, $linkcatid, $linkid, $linkname, $linkurl, $vbphrase['ll_playme']);
						}
						if ($link_can_save_musicbox and $ldm_protocol_schemes[$urlInfo['scheme']]["savemusicbox"]) {
							$linkurlsave = ldm_get_url_atag($linkmode, $linkcatid, $linkid, $linksavebit, $linkurl, $vbphrase['ll_save']);
						}
					}
					elseif ($link_can_save_musicbox) {
						$linkurlsave = ldm_get_url_atag($linkmode, $linkcatid, $linkid, $linksavebit, $linkurl, $vbphrase['ll_save']);
					}
				}
				elseif ($link_known_mimetype) {
					$linkurlsave = ldm_get_url_atag($linkmode, $linkcatid, $linkid, $linksavebit, $linkurl, $linksavetext);
				}
			}

			$linksize = $myrow["linksize"]>1 ? ldm_format_bytes($myrow["linksize"], 2) : 0;
		}

// Handle image part of the linkbit
		$linkimgsize = $links_defaults["link_imagesize"];
		$linkimg	= ($linkimgsize ? $myrow["linkimg"] : "");
		$linkimgthumb = $myrow["linkimgthumb"];
		$linkimgthumbsize = $myrow["linkimgthumbsize"];
		$linkimgshow = "";
		$linkimgsrc = "";
		$linkimgmag = "";
		$is_favicon = preg_match("/\.ico$/",$linkimg);

		if ($linkimgthumb and $linkimgthumbsize==$links_defaults['link_imagesize'] and !$urlInfo['user']) {
			$lf = ldm_get_local_filename($linkimgthumb,0);
			$conn = @fopen($lf, "r");
			if ($conn) {
				$linkimgsrc = create_full_url(($linkimgthumb{0}!= '/' ? "/" : "") . $linkimgthumb);
				fclose($conn);
			}
			else {
				$linkimgsrc = ldm_make_filename($vbulletin->options['bburl'],$RESIZE_SCRIPT).'.php?'.
					$vbulletin->session->vars['sessionurl'].'linkid='.$linkid.'&amp;catid='.$linkcatid.
					'&amp;size='.$linkimgsize;
			}
		}
		else {
			$linkimgsrc = ldm_make_filename($vbulletin->options['bburl'],$RESIZE_SCRIPT).'.php?'.
					$vbulletin->session->vars['sessionurl'].'linkid='.$linkid.'&amp;catid='.$linkcatid.
					'&amp;size='.$linkimgsize;
		}
		if ($linkimg and !$is_favicon) {
			$linkimgshow = ldm_get_imagebit($linkimgsrc);
		}

		$linkimglink = ($linkimg ? ldm_get_url_atag(-1, $linkcatid, $linkid, $linkimgshow) : "");
		$linkimgjump = "";
		$linkimgmag = "";

		if ($linkimg and !$is_favicon and $link_can_access_link) {
			eval("\$linkimgmag = \"".fetch_template('links_imgmag')."\";");
		}

		if ($linkimg) {
			if ($is_musicbox == 1) {
				if ($linkurl==$linkimg) {
					$linkimgmag = "";
				}
			}

			if (!$linktypebit and $is_favicon) {
				$linktypebit = ldm_get_imagebit($linkimg);
			}

			$linkimgjump = ($linkurl ? ldm_get_url_atag($linkmode, $linkcatid, $linkid, $linkimgshow, $linkurl, $linkpopup) : $linkimgshow);

			if ($link_can_access_link) {
				if ($is_musicbox and !$option['forcereview']) {
					if ($link_can_play_musicbox) {
						$linkimgjump = ($linkimg ? $linkimgshow : "");
					}
					if (isset($urlInfo['scheme'])) {
						if ($ldm_protocol_schemes[$urlInfo['scheme']]["musicbox"]==0) {
							$linkimgjump = ($linkimg ? ldm_get_url_atag($linkmode, $linkcatid, $linkid, $linkimgshow, $linkurl, $vbphrase['ll_playme']) : "");
						}
					}
				}
			}
		}

		$linkdatebin = $myrow["linkdate"];
		$linkdate	= ldm_date($vbulletin->options['dateformat'], $linkdatebin);

		$linkdateexp = "";
		$linkexpired = 0;
		if ($expire) {
			if ($linkdatebin>TIMENOW+60) {
				$linkexpired = -1;  // post-dated, so just invisible
			}
			elseif ($linkdatebin+$expire<TIMENOW) {
				$expiredids[] = array("linkid"=>$linkid, "catid"=>$linkcatid);
				$linkexpired = +1;
			}
			else {
				$linkdateexp	= ldm_date($vbulletin->options['dateformat'], $linkdatebin+$expire);
			}
		}

		if (array_key_exists("linkrecenthits", $myrow)) {
			$linkhits = $myrow["linkrecenthits"];
		}
		else {
			$linkhits = $myrow["linkhits"];
		}

		$linkhit 	= $thits + 1;
		$linkstatus = $myrow["linkstatus"];
		$linkuserid = $myrow["linkuserid"];
		$linkusername = $myrow["linkusername"];
		$linkmoderate = $myrow["linkmoderate"];
		$linknewbit = "";
		if ($vbulletin->userinfo['lastvisit'] < $myrow['linkdate']) {
			$linknewbit = (isset($ldm_icon_cache['new']) ? ldm_get_imagebit($ldm_icon_cache['new'], $vbphrase['ll_new']) : $vbphrase['ll_new']);
		}
		$linkrate = "";
		$linkraters = $myrow["numrate"];
		if ($linkraters>0) {
			$linkrate = round($myrow["totrate"]/$myrow["numrate"]);
		}
		$linkcomments = $myrow["numcomment"];

// Build action icons
		$linklegendbuttons = 0;
		$linkfavbit = "";
		if ($links_defaults["favandfeat_entries_enabled"]) {
			if (ldm_lookup_permission($linkcatid, "can_mark_link")) {
				$linkfav = (isset($links_fav[$linkid]) ? 1 : 0);
				$linkfavicon = $ldm_icon_cache['myfav'];
				eval("\$linkfavbit = \"".fetch_template('links_favbit', 0, 0)."\";");
				$linklegendbuttons = 1;
			}
		}

		$linkstarbit = $linkstarredbit = $linkmystarredbit	= "";
		if ($links_defaults["starred_entries_enabled"]) {
			if (ldm_lookup_permission($linkcatid, "can_nominate_link")) {
				eval("\$linkstarbit = \"".fetch_template('links_nominatebit', 0, 0)."\";");
				$linklegendbuttons = 1;
			}
			$linkstarredbit = ldm_get_nominated_leaderbit($linkid);
		}

		$linkeditbit = "";
		if (ldm_lookup_permission($linkcatid, "can_edit_link") or $vbulletin->userinfo['userid']==$linkuserid) {
			$linkediticon = $ldm_icon_cache['pencil'];
			eval("\$linkeditbit = \"".fetch_template('links_editbit', 0, 0)."\";");
			$linklegendbuttons = 1;
		}

		$linklikebit = "";
		if ($myrow["linkhits"] and $links_defaults['search_like_num']) {
			$linklikeicon = $ldm_icon_cache['similar'];
			eval("\$linklikebit = \"".fetch_template('links_likebit', 0, 0)."\";");
			$linklegendbuttons = 1;
		}

		$linksendtofriendbit = "";
		if (ldm_lookup_permission($linkcatid, "can_send_tofriend")) {
			eval("\$linksendtofriendbit = \"".fetch_template('links_sendtofriendbit', 0, 0)."\";");
			$linklegendbuttons = 1;
		}

		$linkreportlinkbit = "";
		if (ldm_lookup_permission($linkcatid, "can_report_link") and $linkuserid != $vbulletin->userinfo['userid']) {
			eval("\$linkreportlinkbit = \"".fetch_template('links_reportlinkbit', 0, 0)."\";");
			$linklegendbuttons = 1;
		}

	}

// Create the final linkbit
	if ($thisid > 0) {

        $unique_entrybitids[$linkid] = (++$uniqueid);

		$accept_hit = 1;
		if (($linkstatus==$LINK_HIDDEN or $linkexpired) and !$link_can_view_hidden) {
			$accept_hit = 0;
		}

		if (isset($options['requirekeyid']) and !isset($linkkeylist[$options['requirekeyid']])) {
			$accept_hit = 0;
		}

		if ($accept_hit) {
			$thits++;
		}

		if ($accept_hit and $thits >= $first and $nhits <= $perpage-1) {
			$linkkeys = ldm_make_highlighted_keys($linkkeylist, $highlight_find, $highlight_repl);
			$linkkeysraw = implode(' ', $linkkeylist);
			$linkratebitdropdown = $linkratebitinline = "";
			if ($links_defaults["dropdown_comment_and_rate"]) {
				eval("\$linkratebitdropdown = \"".fetch_template('links_ratebit_dropdown')."\";");
				$linkratebitdropdown = trim($linkratebitdropdown);
			}
			if ($links_defaults["inline_comment_and_rate"]) {
				eval("\$linkratebitinline = \"".fetch_template('links_ratebit_inline')."\";");
				$linkratebitinline = trim($linkratebitinline);
			}
			$linkothercatsbit = "";
			$linkshowothercatbit = 0;
			foreach ($linkcatlist as $linkothercat) {
				$linkothercatname = $linkscat[$linkothercat]["catname_clean"];
				if (!$options['showcatname']) {
					$linkshowothercatbit = 1;
				}
				eval("\$linkothercatsbit .= \"".fetch_template('links_othercatsbit')."\";");
			}

			eval("\$linkkeysbit = \"".fetch_template('links_keysbit')."\";");

			($hook = vBulletinHook::fetch_hook('ldm_linkbit_create')) ? eval($hook) : false;

			if (($linkstatus!=$LINK_HIDDEN and !$linkexpired) or $link_can_view_hidden) {
				eval("\$linklistarray[$linklistarraykey] = \"".fetch_template($template)."\";");
				$linklistarrayids[$linkid] = $linklistarraykey;
				$linklistarraykey++;
				$hitids[$linkid] = $linkcatid;
				if (ldm_lookup_setting($linkcatid, "display_entities") and ldm_lookup_permission($linkcatid, "can_view_entities")) {
					$entityhitids[$linkid] = $linkcatid;
				}
			}
		}
	}

// Patch in current nominations information
	if ($links_defaults['starred_entries_enabled']) {
		$linknominations = ldm_get_nominations($hitids);
		foreach ($hitids as $thisid=>$thishit) {
			if (isset($linklistarrayids[$thisid]) and isset($linknominations[$thisid])) {
				$thisnominations = $linknominations[$thisid]['count'];
				eval("\$thisnomination = \"".fetch_template('links_viewone_nomination')."\";");
				$linklistarray[$linklistarrayids[$thisid]] =
					str_replace("<!--$thisid::nominations-->", $thisnomination, $linklistarray[$linklistarrayids[$thisid]]);
				$thisnominators = array();
				foreach ($linknominations[$thisid]['nominations'] as $thisnominator) {
					eval("\$thisnominators[] = \"".fetch_template('links_viewone_nominator')."\";");
				}
				$linklistarray[$linklistarrayids[$thisid]] =
					str_replace("<!--$thisid::nominators-->", implode('',$thisnominators), $linklistarray[$linklistarrayids[$thisid]]);
			}
		}
	}

	if ($links_defaults["inline_comment_and_rate"]) {

// Patch in the inline ratings (do this before Quick Comment forms to get user's own ratings)
		$linkratings = ldm_get_ratingsbits($hitids, $pagenumber, 1);
		foreach ($hitids as $thisid=>$thishit) {
			if (isset($linklistarrayids[$thisid])) {
				$linklistarray[$linklistarrayids[$thisid]] =
					str_replace("<!--$thisid::rate-->", $linkratings[$thisid], $linklistarray[$linklistarrayids[$thisid]]);
			}
		}

// Patch in the Quick Comment forms
		if ($links_defaults["inline_ajax_comment_and_rate"] and $links_permissions["can_rate_link"]) {
			$linkajaxrates = ldm_get_ratebits_ajax($hitids, $unique_entrybitids, $ldm_linkid_ratings, $viewcatid, 'd');
			foreach ($hitids as $thisid=>$thishit) {
				if (isset($linklistarrayids[$thisid])) {
					$linklistarray[$linklistarrayids[$thisid]] =
						str_replace("<!--$thisid::ajaxrating-->", $linkajaxrates[$thisid], $linklistarray[$linklistarrayids[$thisid]]);
				}
			}
		}
	}

// Patch in the entities
	if (count($entityhitids)) {
		require_once(DIR . '/includes/local_links_entities.php');
		$linkentities = ldm_get_entitybits($entityhitids, "links_viewone_entity", "links_entitymarkupbit", $link_can_view_hidden, $options['highlight']['entities'], $highlight_find, $highlight_repl);
		foreach ($hitids as $thisid=>$thishit) {
			if (isset($linklistarrayids[$thisid])) {
				$linklistarray[$linklistarrayids[$thisid]] =
					str_replace("<!--$thisid::entities-->", $linkentities[$thisid], $linklistarray[$linklistarrayids[$thisid]]);
			}
		}
	}

	$vbulletin->db->free_result($asb);
	return $thits;
}

/**
* Prepare the ajax-enabled quick comment forms
*
* @param	int*	Array of linkids
* @param	int		Current display category
* @return	str		Array of html
*/

function ldm_get_ratebits_ajax($hitids, $uniqueids, $ldm_linkid_ratings, $viewcatid, $ratesort) {
	global $vbulletin, $vbphrase, $stylevar;
	global $LINKS_SCRIPT;
	global $links_defaults;

	$linkajaxrates = array();
	foreach ($hitids as $linkid=>$thishit) {
		$linkvote = $ldm_linkid_ratings[$linkid];
		$uniqueid = $uniqueids[$linkid];
		eval("\$linkajaxrates[$linkid] = \"".fetch_template("links_ratebit_ajax")."\";");
	}

	return $linkajaxrates;

}

/**
* Prepare a standard image tag
*
* @param	str		Image url
* @param	str		Alt tag (contents)
* @param	str		Other tags (fully spelled out, e.g. "width='10' height='20'")
* @return	str		html
*/

function ldm_get_imagebit($img, $alttag="", $othertags="") {
	return '<img class="inlineimg" border="0" src="'.$img.'" alt="'.$alttag.'" '.$othertags.' />';
}

/**
* Prepare image tag for given filetype
*
* @param	str*	Parsed url structure
* @param	str		Alt tag
* @param	str		If set, use sprintf to map the image tag into string
* @return	str		html
*/

function ldm_get_typebit($urlInfo, $alttag="", $insert_into="") {
	global $vbulletin, $vbphrase;
	global $ldm_icon_cache, $links_defaults;

	cache_LDMicons();

	$urlType = file_extension($urlInfo['path']);
	$linkfiletype = strtolower($urlType);

	($hook = vBulletinHook::fetch_hook('ldm_linkbit_gettypebit')) ? eval($hook) : false;

	$icon = "";
	$alt = "";
	if (isset($ldm_icon_cache[$linkfiletype])) {
		$alt = $linkfiletype;
		$icon = $ldm_icon_cache[$linkfiletype];
	}
	elseif (isset($ldm_icon_cache[$urlInfo['scheme']])) {
		$alt = $urlInfo['scheme'];
		$icon = $ldm_icon_cache[$alt];
	}

	$linktypebit = '';
	if ($icon) {
		if ($insert_into) {
			$linktypebit = sprintf($insert_into, ldm_get_imagebit($icon, $alttag));
		}
		else {
			$linktypebit = ldm_get_imagebit($icon, $alttag);
		}
		$linktypebit .= '&nbsp;';
	}

	return $linktypebit;

}

/**
* Reset a text string to specified width and height
*
* @param	str		Text
* @param	str		Width in chars
* @param	str		Height in rows
* @return	str		Reset text
*/

function ldm_cleantext_to_width_rows($text, $width, $rows) {

	$newtext = $text;
//	$newtext = ldm_kill_bbcodes($newtext);
	$newtext = str_replace("\r", "", $newtext);

	$lines = explode("\n", $newtext);
	$cache = array();

	foreach ($lines as $thisline) {
		if (strlen($thisline)<=$width or $width<=0) {
			$cache[] = $thisline;
		}
		else {
			while (strlen($thisline)>0) {
				$block = substr($thisline, 0, $width);
				$cache[] = $block;
				$thisline = substr($thisline, $width);
			}
		}
	}

	$cache = array_slice($cache, 0, min(count($cache), $rows));
	$result = implode("\n", $cache);
//	$result = htmlspecialchars_uni($result);

	return nl2br($result);

}

function ldm_get_catextdesc_popupbit($catid) {
	global $linkscat, $links_defaults;
	global $vbphrase, $vbulletin, $stylevar;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$catmouseovertext = "";
	foreach ($linkscat as $thiscat) {
		if ($thiscat['parentid']!=$catid) {
			continue;
		}
		$cattext  = ldm_parse_features($thiscat["cattext"]);
		if ($cattext) {
			eval("\$catmouseovertext .= \"".fetch_template("links_catmouseover")."\";");
		}
	}

	return $catmouseovertext;
}

/**
* Return the 'nominated winner' bit for selected linkid
*
* @param	int		linkid
* @return	str		nominatebit
*/

function ldm_get_nominated_leaderbit($linkid) {
	global $vbulletin, $vbphrase;
	global $links_defaults, $links_starred, $ldm_icon_cache;
	global $SEARCH_SCRIPT, $NOM_CAT;

	cache_LDMnominations();
	$bit = "";
	if ($links_defaults['starred_entries_enabled'] and is_array($links_starred)) {
		foreach ($links_starred as $thisperiod=>$thesestars) {
			foreach ($thesestars['scores'] as $thisstar) {
				if ($thisstar['linkid']==$linkid) {
					$starfrom = $thesestars['from'];
					$starto = $thesestars['to'];
					$starscore = $thisstar['score'];
					eval("\$bit .= \"".fetch_template('links_nominated_leaderbit', 0, 0)."\";");
				}
			}
		}
	}
	return $bit;
}

/**
* Return information on current nominations for selected linkid
*
* @param	int*	linkids
* @return	arr		nominations
*/

function ldm_get_nominations($linkids) {
	global $vbulletin, $vbphrase;
	global $links_defaults, $links_permissions, $ldm_icon_cache;

	$links_nominations = array();

	if (count($linkids)) {
		$query = "
			SELECT star.linkid AS linkid, star.usertime AS usertime, star.userid AS userid, user.username AS username
			FROM ".THIS_TABLE."linkstarred AS star
			LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON star.userid=user.userid
			WHERE star.usertime>=".intval($links_defaults['starred_entries_periodstart'])."
			AND star.linkid IN (" . implode(',', array_keys($linkids)) . ")
			ORDER BY username ASC
			";
		$asb = $vbulletin->db->query_read($query);

		while ($myrow=$vbulletin->db->fetch_array($asb)) {
			$links_nominations[$myrow['linkid']]['count'] += 1;
			$links_nominations[$myrow['linkid']]['nominations'][] =
				array('username' => $myrow['username'],
					'userid' => $myrow['userid'],
					'usertime' => vbdate($vbulletin->options['dateformat'], $myrow['usertime']),
					);
		}
	}

	return $links_nominations;
}

/**
* Return the ratings bits for the selected linkids
* As side effect, places current user's ratings in global $ldm_linkid_ratings;
*
* @param	intarr	Array of linkids
* @param	int		Current display page number, passed to templates for correct returns
* @return	strarr	Array of constructed ratebits
*/

function ldm_get_ratingsbits($linkids, $pagenumber, $inline) {
	global $vbulletin, $stylevar, $vbphrase;
	global $links_defaults, $links_permissions, $ldm_icon_cache, $ldm_linkid_ratings;
    global $LDM_environment;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	$linkrates = array();
	foreach ($linkids as $linkid) {
		$linkrates[$linkid] = "";
	}

	if ($inline) {
		$maxrate = $links_defaults["inline_comment_and_rate"];
		$ratetemplate =  'links_viewone_inline_comment';
		$width = '0';
		$rows = $links_defaults["inline_rows_comment_and_rate"];
	}
	else {
		$maxrate = $links_defaults["dropdown_comment_and_rate"];
		$ratetemplate =  'links_viewone_popup_comment';
		$width = $links_defaults["dropdown_width_comment_and_rate"];
		$rows = $links_defaults["dropdown_rows_comment_and_rate"];
	}

	if ($maxrate<=0) {
		return $linkrates;
	}

	$linkratearray = array();

	if (count($linkids)) {

		$lpage = 1;
		$ratesort = 'd';

		$query = "
			SELECT lrate.lrate AS lrate, lrate.linkid AS linkid, lrate.linkuserid AS linkuserid,
				lrate.linkusername AS linkusername, lrate.linkvote AS linkvote,
				lrate.lcomment AS lcomment, lrate.ltime AS ltime
				" . ($links_defaults['show_avatars'] ? ', user.*, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,customavatar.width AS avwidth,customavatar.height AS avheight' : "") . "
			FROM ".THIS_TABLE."linksrate AS lrate
				" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = lrate.linkuserid)" : "") . "
				" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)" : "") . "
				" . ($links_defaults['show_avatars'] ? "LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)" : "") . "
			WHERE linkid IN (" . implode(',', array_keys($linkids)) . ")
			ORDER BY linkid ASC, ltime DESC
		";

		$asb = $vbulletin->db->query_read($query);
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$linkid = $myrow['linkid'];
			$linkuserid = $myrow['linkuserid'];
			$rateid = $myrow['lrate'];

			if ($linkuserid==$vbulletin->userinfo['userid']) {
				$ldm_linkid_ratings[$linkid] = $myrow['linkvote'];
			}

			if (!is_array($linkratearray[$linkid])) {
				$linkratearray[$linkid] = array();
				$viewcatid = $linkids[$linkid];
				$linkid_menu = "ratings".$linkid."_menu";
				$stage = 1;
				eval("\$linkratearray[$linkid][] = \"".fetch_template($ratetemplate)."\";");
			}

			if (count($linkratearray[$linkid])<=$maxrate) {
				$comment = ldm_parse_features(ldm_cleantext_to_width_rows($myrow['lcomment'], $width, $rows));
//				if (strlen($comment) > 0 or $myrow["linkuserid"]==$vbulletin->userinfo['userid'] or $LDM_environment['is_admin']) {
				if (strlen($comment) > 0) {
					if (strlen($comment) == 0) {
					    $comment = $vbphrase['ll_noremark'];
					}
    				$linkusername = $myrow["linkusername"];
	    			$linkvote	= $myrow['linkvote'];
		    		$dateandtime = ldm_date($vbulletin->options['dateformat'], $myrow['ltime']).' '.ldm_date($vbulletin->options['timeformat'], $myrow['ltime']);
			    	$linkavatar = ldm_get_avatarinfo($myrow);
				    $stage = 2;
				    eval("\$linkratearray[$linkid][] = \"".fetch_template($ratetemplate)."\";");
				}
			}
			elseif (count($linkratearray[$linkid])==$maxrate+1) {
				$stage = 3;
				eval("\$linkratearray[$linkid][] = \"".fetch_template($ratetemplate)."\";");
			}

		}

		$stage = 4;
		foreach ($linkratearray as $linkid=>$thislinkratearray) {
			eval("\$linkratearray[$linkid][] = \"".fetch_template($ratetemplate)."\";");
			$linkrates[$linkid] = implode(" ", $linkratearray[$linkid]);
		}

	}

	unset($linkratearray);
	$vbulletin->db->free_result($asb);
	return $linkrates;

}

function ldm_get_keywordsbit($linkid=0) {
	global $vbulletin, $stylevar;
	global $links_defaults, $links_permissions;

	$keywordlistbit = "";
	$keys = array();
	$chosen = array();

	$asb = $vbulletin->db->query_read("
		SELECT ltok.linkid AS linkid, ltok.keyid AS keyid, lkeys.keyword AS keyword
		FROM ". THIS_TABLE . "linksltok AS ltok
		LEFT JOIN ". THIS_TABLE . "linkskeys AS lkeys
		ON ltok.keyid=lkeys.keyid
		WHERE linkid='".intval($linkid)."'
		");
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		$keys[$rec['keyid']] = $rec['keyword'];
	}

	$myset = array();
	foreach ($keys as $keyid=>$keyword) {
		$selected = 1;
		eval("\$myset[] = \"".fetch_template('links_selectkeyword')."\";");
	}

	$vbulletin->db->free_result($asb);

	$keywordlistbit = ldm_map_listbit_to_grid($myset, 5);
	return $keywordlistbit;
}

function ldm_get_tagcloud($limit, $useLogCurve, $minFontSize, $maxFontSize, $weightbyhits, $categories="") {
	global $vbulletin, $vbphrase;
	global $links_defaults, $links_permissions;

	$limit_aug = $limit + 50; // give some leeway for censored words, etc
	$can_bypass = $links_permissions['can_see_protected_links_on_portal'] | $links_permissions['can_bypass_forumperms'];
	$limitfids = ldm_lookup_forum_protections($can_bypass);

	if ($weightbyhits) {
		$query = "
			SELECT lkeys.keyword AS keyword, COUNT(ltok.linkid) AS keycount1, SUM(link.linkhits) AS keycount, link.linkforum
			FROM ".THIS_TABLE."linkskeys AS lkeys
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			LEFT JOIN ".THIS_TABLE."linkslink AS link
			ON ltok.linkid=link.linkid
			";

		if ($categories) {
			$query .= "
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid=ltoc.linkid
				";
		}

		$query .= "
			WHERE link.linkforum NOT IN (".implode(',', $limitfids).")
			";

		if ($categories) {
			$query .= "
				AND ltoc.catid IN (". $categories .")
				";
		}

		$query .= "
			GROUP BY keyword
			ORDER BY keycount DESC
			LIMIT $limit_aug
			";

	}
	elseif (count($limitfids)<=1) {
		$query = "
			SELECT lkeys.keyword AS keyword, COUNT(ltok.linkid) AS keycount
			FROM ".THIS_TABLE."linkskeys AS lkeys
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			";

		if ($categories) {
			$query .= "
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON ltok.linkid=ltoc.linkid
				WHERE ltoc.catid IN (". $categories .")
				";
		}

		$query .= "
			GROUP BY keyword
			ORDER BY keycount DESC
			LIMIT $limit_aug
			";
		}
	else {
		$query = "
			SELECT lkeys.keyword AS keyword, COUNT(ltok.linkid) AS keycount, link.linkforum
			FROM ".THIS_TABLE."linkskeys AS lkeys
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			LEFT JOIN ".THIS_TABLE."linkslink AS link
			ON link.linkid=ltok.linkid
			";

		if ($categories) {
			$query .= "
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid=ltoc.linkid
				";
		}

		$query .= "
			WHERE link.linkforum NOT IN (".implode(',', $limitfids).")
			";

		if ($categories) {
			$query .= "
				AND ltoc.catid IN (". $categories .")
				";
		}

		$query .= "
			GROUP BY keyword
			ORDER BY keycount DESC
			LIMIT $limit_aug
			";
	}

	$asb = $vbulletin->db->query_read($query);
	$nkeys = 0;
	$tags = array();
	while ($rec=$vbulletin->db->fetch_array($asb) and $nkeys<$limit) {
		if ($rec['keycount']<=0 or !trim($rec['keyword'])) continue;
		if ($links_defaults['apply_censor']) {
			if ($rec['keyword'] != fetch_censored_text($rec['keyword'])) continue;
		}
		$tags[$nkeys]['keyword'] = $rec['keyword'];
		$tags[$nkeys]['count'] = $rec['keycount'];
		$nkeys++;
	}
	$vbulletin->db->free_result($asb);

	$fontRange = $maxFontSize - $minFontSize;
	$maxTagCnt = 0;
	$minTagCnt = 10000000;

	foreach ($tags as $tag => $trec) {
		$cnt = $trec['count'];
		if ($cnt > $maxTagCnt) {
			$maxTagCnt = $cnt;
		}
		if ($cnt < $minTagCnt) {
			$minTagCnt = $cnt;
		}
	}
	$tagCntRange = $maxTagCnt+1 - $minTagCnt;

	$minLog = log($minTagCnt);
	$maxLog = log($maxTagCnt);
	$logRange = $maxLog - $minLog;
	if ($maxLog == $minLog) {
		$logRange = 1;
	}

	$tagcloud = array();
	foreach ($tags as $utag => $trec) {
		$cnt = $trec['count'];
		$logcnt = log($cnt);
		$tag = $trec['keyword'];
		$url =  $vbulletin->options['bburl']."/".SEARCH_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=show&sort=h&keys=1&keyword=".$tag;
		if ($useLogCurve) {
			$fsize = $minFontSize + $fontRange * ($logcnt-$minLog)/$logRange;
		}
		else {
			$fsize = $minFontSize + $fontRange * ($cnt - $minTagCnt)/$tagCntRange;
		}
		$tagcloud[$tag] = '<a href='.$url.' style="font-size:'.(int)$fsize.'px;" title="'.$vbphrase['ll_showkeys'].'">'.$tag.'</a> ';
	}
	ksort($tagcloud);
	$tagcloud = implode(' ', $tagcloud);

	return $tagcloud;
}

/**
* Translate a string into a list of lowercase keywords
*
* @param	str		input string
* @return	str*	keywords
*/

function ldm_explode_keywords($words) {
	if (trim($words)) {
		return preg_split("/[,;\s]+/", ldm_strtolower($words));
	}
	else {
		return array();
	}
}

/**
* Return array of indices for keywords in $list, in the process adding new words to the keyword table
*
* @param	str*	List of keywords
* @return	int*	List of keyword indices
*/

function ldm_lookup_keywords($list) {
	global $vbulletin;

	$indices = array();
	if (!count($list)) return $indices;

	$words = array();
	foreach ($list as $w) {
		if (!in_array($w, $words)) {
			$words[] = $vbulletin->db->escape_string($w);
		}
	}

	$query = "
		SELECT keyid, keyword
		FROM ". THIS_TABLE . "linkskeys
		WHERE keyword IN ('".implode("', '", $words)."')
		";
	$asb = $vbulletin->db->query_read($query);
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		foreach ($words as $k=>$w) {
			if ($rec['keyword']==$w) {
				$indices[$k] = $rec['keyid'];
			}
		}
	}
	$vbulletin->db->free_result($asb);

	foreach ($words as $k=>$w) {
		if (!isset($indices[$k])) {
			$query = "
				INSERT INTO ".THIS_TABLE."linkskeys
				SET
					keyword='".$w."'
			";
			$vbulletin->db->query_write($query);
			$indices[$k] = $vbulletin->db->insert_id();
		}
	}

	return $indices;
}

/**
* (De)associate keywordids with linkid
*
* @param	int		Linkid
* @param	int		Keyids
* @param	int		-1: Deassociate these keywordids; 0: Reset to only these keywordids; 1: associate keywordids
* @return	array	List of keyword indices
*/

function ldm_associate_keywords($linkid, $keyids, $add) {
	global $vbulletin;

	if (!is_array($linkid)) {
		$linkids = array($linkid);
	}
	else {
		$linkids = $linkid;
	}

	switch ($add) {
	case -1: // deassociate
	case  1: // add to current list
		if (count($keyids) and count($linkids)) {
			$query = "
				DELETE FROM ".THIS_TABLE."linksltok
				WHERE keyid IN (".implode(',', $keyids).")
				AND linkid IN  (".implode(',', $linkids).")
			";
			$vbulletin->db->query_write($query);
		}
		break;

	case  0: // only these words
		$query = "
			DELETE FROM ".THIS_TABLE."linksltok
			WHERE linkid='".intval($linkid)."'
			";
		$vbulletin->db->query_write($query);
		break;
	}

	switch ($add) {
	case  0:
	case  1:
		foreach ($keyids as $kid) {
			if ($kid) {
				foreach ($linkids as $lid) {
					if ($lid) {
						$query = "
							INSERT INTO ".THIS_TABLE."linksltok
							SET
								linkid='".$lid."',
								keyid='".intval($kid)."'
							";
						$vbulletin->db->query_write($query);
					}
				}
			}
		}
		break;

	case -1:
		break;
	}

}

/**
* Move expired entries to holding categories when appropriate
*
* @param	array	Array of arrays("linkid"=>LID, "catid"=>"CID")
* @return	int		Number of entries moved to new categories
*/

function ldm_process_expired($expiredids) {
	global $vbulletin;
	global $links_defaults, $linkscat;

	($hook = vBulletinHook::fetch_hook('ldm_process_expired_begin')) ? eval($hook) : false;

	$lastcatid = -1;
	$moved = 0;
	foreach ($expiredids as $expirek) {
		$thiscatid = $expirek["catid"];
		if ($thiscatid<=0) {
			continue;
		}
		if ($thiscatid!=$lastcatid) {
			$expirecatid = ldm_lookup_setting($thiscatid, 'links_expired_catid');
			$lastcatid = $thiscatid;
		}
		if ($expirecatid<=0 or $expirecatid==$thiscatid) {
			continue;
		}
		$thisid = $expirek["linkid"];

		$query = "
			UPDATE ".THIS_TABLE."linksltoc
			SET
				catid='".intval($expirecatid)."'
			WHERE linkid='".intval($thisid)."'
			AND catid='".intval($thiscatid)."'
			";
		$vbulletin->db->query_write($query);
		$query = "
			UPDATE ".THIS_TABLE."linkslink
			SET
				linkforum='".$linkscat[$expirecatid]['catforum']."'
			WHERE linkid='".intval($thisid)."'
			";
		$vbulletin->db->query_write($query);
		$moved++;
	}

	if ($moved) {
		ldm_fix_cat_count();
	}

	return $moved;
}

/**
* Record a hit, catching double clicks within timeout period
*
* @param	int		Entry id
* @param	str		Entry url
* @param	int		Entry status
* @param	int		Entry size (bytes)
*/

function ldm_record_hit($id, $url, $status, $size=0) {
	global $vbulletin;
	global $links_permissions, $links_defaults;
	global $LINK_BROKEN;

	if ($links_defaults["prune_downloadtable"]>0) {
		$when = TIMENOW-24*60*60*intval($links_defaults["prune_downloadtable"]);
		$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linksdownloads
			WHERE usertime<'".$when."'
		");
	}

	if ($links_permissions["can_bypass_hit_recording"]) {
		return;
	}

	$userip = (isset($_SERVER[REMOTE_ADDR]) ? $_SERVER[REMOTE_ADDR] : 'unknown');
	$username = $vbulletin->userinfo['username'];
	$userid = $vbulletin->userinfo['userid'];
	$thisurl = $vbulletin->db->escape_string($url);

	$time = TIMENOW;
	if ($links_defaults["timeout_hit_recording"]>0) {
		$timeout = $time - $links_defaults["timeout_hit_recording"];
		$jumplink = $vbulletin->db->query_read("
			SELECT * FROM ".THIS_TABLE."linksdownloads
			WHERE linkid='".$id."'
			AND userid='".$userid."'
			AND usertime>'".$timeout."'
			AND linkurl='".$thisurl."'
			LIMIT 1
			");
		if ($vbulletin->db->num_rows($jumplink)>0) {
			return;
		}
	}

	$asb = $vbulletin->db->query_read("
		SELECT linkid, linkstatus
		FROM ".THIS_TABLE."linkslink
		WHERE linkid='".intval($id)."'
		LIMIT 1
		");

	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		if ($status == $LINK_BROKEN and $myrow['linkstatus'] != $LINK_BROKEN) {
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkstatus=".intval($status)."
				WHERE linkid='".intval($id)."'
				LIMIT 1
			");
		}
		elseif ($status != $LINK_BROKEN and $myrow['linkstatus'] == $LINK_BROKEN) {
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET
					linkhits=linkhits+1,
					linkstatus=".intval($status)."
				WHERE linkid='".intval($id)."'
				LIMIT 1
			");
		}
		elseif ($status != $LINK_BROKEN) {
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET
					" . ($size ? "linksize=".intval($size)."," : "") . "
					linkhits=linkhits+1
				WHERE linkid='".intval($id)."'
				LIMIT 1
			");
		}
	}

	($hook = vBulletinHook::fetch_hook('ldm_record_hit')) ? eval($hook) : false;

	if ($status != $LINK_BROKEN) {
		$vbulletin->db->query_write("
			INSERT INTO ".THIS_TABLE."linksdownloads
			SET
				linkid='".intval($id)."',
				linkurl='".$thisurl."',
				username='".$vbulletin->db->escape_string(htmlspecialchars_uni($username))."',
				userid='".$userid."',
				userip='".$vbulletin->db->escape_string($userip)."',
				usertime=".$time.",
				bytes=".($links_permissions['can_bypass_bandwidth_limits'] ? 0 : intval($size))."
		");
	}

	return;
}

/**
* Store block to be placed in main template
*
* @param	str		Block
* @param	str		Placement
* @param	int		Place order in placement
*/

function ldm_place_block($block, $place, $placeorder) {
	global $ldm_toincludeinmain;

	if (!is_array($ldm_toincludeinmain)) {
		$ldm_toincludeinmain = array();
	}

	if (!is_array($ldm_toincludeinmain[$place])) {
		$ldm_toincludeinmain[$place] = array();
	}

	$ldm_toincludeinmain[$place][$placeorder][] = $block;

}

/**
* Incorporate placed blocks into the template variables
*
*/

function ldm_process_placed_blocks() {
	global $ldm_includeinmain, $ldm_toincludeinmain;

	foreach ($ldm_toincludeinmain as $place=>$vals) {
		ksort($vals);
		foreach ($vals as $thiskey=>$thisval) {
			$ldm_includeinmain[$place] .= implode(" ", $thisval);
		}
	}

}

/**
* Return message explaining why nothing is being displayed
*
* @param	int		Categoryid
* @return	str		Message
*/

function ldm_emptypage_warning($catid) {
	global $linkscat;
	global $vbphrase, $vbulletin;

	if (!count($linkscat)) {
		return construct_phrase($vbphrase['ll_empty_database'], ($links_defaults['database_name'] ? $links_defaults['database_name'] : $vbphrase['ll_links_database']));
	}

	$empty = 1;
	if ($catid) {
		foreach ($linkscat as $thiscat) {
			if ($thiscat['parentid']==$catid) {
				$empty = 0;
				break;
			}
		}
		if (!$hit) {
			$myrow = $vbulletin->db->query_first("
				SELECT COUNT(linkid) AS linkhits
				FROM ".THIS_TABLE."linksltoc
				WHERE catid='".intval($catid)."'
				");
			if ($myrow['linkhits']) {
				$empty = 0;
			}
		}
		if ($empty) {
			return $vbphrase['ll_empty_category'];
		}
	}

	return $vbphrase['ll_nothing_visible_to_user'];

}

/**
* Obtain security token to add to urls
*
* @param	int		Entryid
* @return	str		Token
*/

function ldm_encrypt_authority($linkid, $catid) {
	global $vbulletin;
	global $links_defaults;

	if ($catid<=0 or $linkid<=0) {  // should not happen but give up if it does
		return "";
	}

	if (!ldm_lookup_setting($catid, 'encrypt_lock_active')) {
		return "";
	}

	$lock_expirytime = ldm_lookup_setting($catid, 'encrypt_lock_expiry');
	if ($lock_expirytime>0) {
		$lock_expirytime = TIMENOW + $lock_expirytime*60;
	}
	else {
		$lock_expirytime = 0;
	}

	$lock_id = ldm_lookup_setting($catid, 'encrypt_lock_userid');
	if (!lock_id) {
		$lock_id = 0;
	}
	elseif (strtolower($lock_id)=="user") {
		$lock_id = $vbulletin->userinfo['userid'];
	}

	$lock_ip = ldm_lookup_setting($catid, 'encrypt_lock_userip');
	if (!$lock_ip) {
		$lock_ip = 0;
	}
	elseif (strtolower($lock_ip)=="ipaddress") {
		$lock_ip = IPADDRESS;
	}

	$lock_key = ldm_lookup_setting($catid, 'encrypt_lock_key');
	$lock_md5 = md5($lock_key.$linkid.$lock_expirytime.$lock_ip.$lock_id);
	$lock_auth = "$lock_expirytime#$lock_id#$lock_ip#$lock_md5";
	$lock_auth = base64_encode($lock_auth);

	return $lock_auth;

}

/**
* Decypt security token
*
* @param	str		Token
* @param	int		Entryid
* @param	int		Catid
* @param	str		Error message
* @return	bool	Validated
*/

function ldm_decrypt_authority($token, $linkid, $catid, &$error) {
	global $vbulletin, $vbphrase;
	global $links_defaults;

	if (!$token) {
		if (ldm_lookup_setting($catid, 'encrypt_lock_active')) {
			$error = $vbphrase['ll_error_encrypt_notauthenticated'];
			return 0;
		}
		else {
			return 1;
		}
	}

	$lock_auth = base64_decode($token);
	$lock_expirytime = strtok($lock_auth, '#');
	$lock_id = strtok('#');
	$lock_ip = strtok('#');
	$lock_md5 = strtok('#');

	$lock_key = ldm_lookup_setting($catid, 'encrypt_lock_key');
	$lock_check = md5($lock_key.$linkid.$lock_expirytime.$lock_ip.$lock_id);

	if ($lock_md5 != $lock_check) {
		$error = $vbphrase['ll_error_encrypt_notauthenticated'];
		return 0;
		exit;
	}

	if ($lock_id) {
		if (!in_array($vbulletin->userinfo['userid'], explode(',', $lock_id))) {
			$error = $vbphrase['ll_error_encrypt_notvaliduser'];
			return 0;
		}
	}

	if ($lock_expirytime>0 AND $lock_expirytime<TIMENOW) {
		$error = $vbphrase['ll_error_encrypt_expired'];
		return 0;
	}

	if ($lock_ip) {
		$ipo = array();
		$ipo[]=strtok($lock_ip, ".");
		$ipo[]=strtok(".");
		$ipo[]=strtok(".");
		$ipo[]=strtok(".");
		$ipn = array();
		$ipn[]=strtok(IPADDRESS,".");
		$ipn[]=strtok(".");
		$ipn[]=strtok(".");
		$ipn[]=strtok(".");
		foreach ($ipo as $k=>$ipc) {
			if ($ipc===false) {
				break;
			}
			if (intval($ipo[$k])!=intval($ipn[$k])) {
				$error = $vbphrase['ll_error_encrypt_notvalidip'];
				return 0;
			}
		}
	}

	$error = "";
	return 1;

}


?>