<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/**
* Clear the display bit cache and database tables
*
*/

function ldm_clear_bitcache() {
    global $vbulletin;
	global $links_bitcache;

    $links_bitcache = array();

	$query = "
		TRUNCATE TABLE ".THIS_TABLE."linksbitcache
		";
	$vbulletin->db->query_write($query);

	DEVDEBUG('clearing LDM bitcache');

}

/**
* Load the display bit cache entries for current usergroupid/styleid
*
* @param	bool	Force reload even if cache already loaded
*/

function ldm_load_bitcache($force_reload=0) {
    global $vbulletin;
	global $links_defaults;
	global $links_bitcache;
    static $have_bitcache = 0;

    if ($have_bitcache and !$force_reload) {
        return;
    }

    if ($links_defaults['bit_cache_usergroup_bypass']) {
        $bypass_ugids = preg_replace("/\s/", "", $links_defaults['bit_cache_usergroup_bypass']);
        $bypass_ugids = explode(',', $bypass_ugids);
        if (in_array($vbulletin->userinfo['usergroupid'], $bypass_ugids)) {
            return;
        }
    }

    if ($links_defaults['bit_cache_active'] and !$have_bitcache) {
        $links_bitcache = array();
        $expiry = $links_defaults['bit_cache_expiry'] ? (TIMENOW - $links_defaults['bit_cache_expiry']*60) : 0;
        $styleid = $vbulletin->userinfo['styleid'];
        $query = "SELECT bitname, bitcontents, bitdata
				  FROM ".THIS_TABLE."linksbitcache
				  WHERE usergroupid='".$vbulletin->userinfo['usergroupid']."'
				  AND styleid='".$vbulletin->userinfo['styleid']."'
				  AND timeline>'".$expiry."'
			";
    	$asb = $vbulletin->db->query_read($query);
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
		    $links_bitcache[$myrow['bitname']]['bitcontents'] = $myrow['bitcontents'];
		    $links_bitcache[$myrow['bitname']]['bitdata'] = $myrow['bitdata'];
    	}
    	$have_bitcache = 1;
    }
}


/**
* Fetch selected display bit from cache
*
* @param	str		Required display bit
* @param	&str	Display bit
* @param	&var	Accompanying data
* @return	str		True if display bit returned
*/

function ldm_fetch_cachedbit($bitname, &$bitcontents, &$bitdata) {
    global $vbulletin;
	global $links_defaults;
	global $links_bitcache;

    if (!$links_defaults['bit_cache_active']) {
        return false;
    }

    if ($links_defaults['bit_cache_usergroup_bypass']) {
        $bypass_ugids = preg_replace("/\s/", "", $links_defaults['bit_cache_usergroup_bypass']);
        $bypass_ugids = explode(',', $bypass_ugids);
        if (in_array($vbulletin->userinfo['usergroupid'], $bypass_ugids)) {
            return false;
        }
    }

    ldm_load_bitcache();

    if (isset($links_bitcache["$bitname"])) {
        $bitcontents = unserialize($links_bitcache["$bitname"]['bitcontents']);
        $bitdata = unserialize($links_bitcache["$bitname"]['bitdata']);
    	DEVDEBUG('fetching '.$bitname.' from LDM bitcache');
        return true;
    }

    return false;

}

/**
* Store new display bit in cache and database
*
* @param	str		Display bit
* @param	str		Display bit contents
* @param	var	    Accompanying data
*/

function ldm_store_cachedbit($bitname, $contents, $data) {
    global $vbulletin;
	global $links_defaults;
	global $links_bitcache;

    if (!$links_defaults['bit_cache_active']) {
        return;
    }

    $maxlen = pow(2, 23);

    $links_bitcache["$bitname"]['bitcontents'] = serialize($contents);
    $links_bitcache["$bitname"]['bitdata'] = serialize($data);

// Don't cache if data are too big to store (shouldn't occur)
    if (strlen($links_bitcache["$bitname"]['bitcontents'])>$maxlen or strlen($links_bitcache["$bitname"]['bitdata'])>$maxlen) {
        return;
    }

	$query = "
		DELETE FROM ".THIS_TABLE."linksbitcache
		WHERE bitname='". $vbulletin->db->escape_string($bitname). "'
		AND usergroupid='".$vbulletin->userinfo['usergroupid']."'
		AND styleid='".$vbulletin->userinfo['styleid']."'
			";
	$vbulletin->db->query_write($query);

	$query = "
		INSERT INTO ".THIS_TABLE."linksbitcache
		SET
			bitname='". $vbulletin->db->escape_string($bitname). "',
			bitcontents='". $vbulletin->db->escape_string($links_bitcache["$bitname"]['bitcontents']). "',
			bitdata='". $vbulletin->db->escape_string($links_bitcache["$bitname"]['bitdata']). "',
			usergroupid='".$vbulletin->userinfo['usergroupid']."',
			styleid='".$vbulletin->userinfo['styleid']."',
			timeline='".TIMENOW."'
			";
	$vbulletin->db->query_write($query);

    DEVDEBUG('storing '.$bitname.' in LDM bitcache');

}

?>