<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

/**
* Check environment
*
*/

$ldm_hack_version = "0";

function check_LDM_envt() {
	global $vbulletin;
	global $ldm_hack_version;

	echo '<b>Checking installation status...</b><br />';
	$hack_status = 0;

	$asb = $vbulletin->db->query_read("SHOW TABLES");
	$hack_table_prefix = THIS_TABLE."links";
	$hack_tables = array();

	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		foreach ($myrow AS $table) {
			if (preg_match ("/^$hack_table_prefix/", $table)) {
				$hack_tables[] = $table;
			}
		}
	}

	if (count($hack_tables) > 0) {
		if (in_array($hack_table_prefix."admin", $hack_tables)) {
			$asb = $vbulletin->db->query_read("SELECT * FROM ".THIS_TABLE."linksadmin");
			while ($admin_settings = $vbulletin->db->fetch_array($asb)) {
				if ($admin_settings[settingname] == "this_version") {
					$ldm_hack_version = $admin_settings[setting];
				}
			}
		}
		echo "Currently installed version: ".$ldm_hack_version."<br />";
	}

	if ($ldm_hack_version=='0') {
		echo "<b>New installation</b><br />";
	}

	echo '<b>Checking environment...</b><br />';
	$allow_url_fopen = ini_get('allow_url_fopen');
	$curl_available = function_exists('curl_init');
	if (!$allow_url_fopen and !$curl_available) {
		echo '<br /><font color="red">';
		echo 'Warning ';
		echo '<b>allow_url_fopen</b> is turned <b>off</b> in your PHP installation and cURL is not available<br />';
		echo 'You will not be able to offer remote file downloads<br />';
		echo '</font>';
	}

	$zlib = ini_get('zlib.output_compression');
	if ($zlib) {
		echo '<br /><font color="red">';
		echo 'Warning ';
		echo '<b>zlib.output_compression</b> is turned <b>on</b> in your PHP installation<br />';
		echo 'LDM is believed safe with this setting but there were problems reported early on.<br />';
		echo '</font>';
	}

	$obdir = ini_get('open_basedir');
	if ($obdir) {
		echo '<br /><font color="red">';
		echo 'Warning ';
		echo '<b>open_basedir</b> is set to <b>'.$LDM_environment['open_basedir'].'</b> in your PHP installation<br />';
		echo 'Refer to documentation for information on this setting<br />';
		echo '</font>';
	}

	$gdlib = function_exists('imagecreatefromjpeg');
	if (!$gdlib) {
		echo '<br /><font color="red">';
		echo 'Warning ';
		echo 'Cannot locate GD function <b>imagecreatefromjpeg</b><br />';
		echo 'Image thumbnail feature will not be available<br />';
		echo '</font>';
	}

	echo '<b>Environment checked</b><br />';

}

/**
* Check array of usernames and return array of userids where valid, 0 otherwise
*
* @param	array	Usernames
* @return	array	Userids
*/

if (!function_exists(ldm_lookup_userids)) {
function ldm_lookup_userids($usernames) {
	global $vbulletin;

	$ids = array();
	$safe_usernames = array();
	foreach ($usernames as $k=>$v) {
		$usernames[$k] = trim($usernames[$k]);
		$safe_usernames[$k] = trim($vbulletin->db->escape_string(htmlspecialchars_uni($v)));
		$ids[$k] = 0;
	}
	$safe_userlist = implode("' ,'", $safe_usernames);
	if (!trim($safe_userlist)) return $ids;

	$query = "
		SELECT userid, username
		FROM " . TABLE_PREFIX . "user AS user
		WHERE username IN ('" . $safe_userlist . "')
		";
	$asb = $vbulletin->db->query_read($query);

	while ($rec=$vbulletin->db->fetch_array($asb)) {
		foreach ($usernames as $k=>$v) {
			if ($v==$rec['username']) {
				$ids[$k] = $rec['userid'];
				continue;
			}
		}
	}
	$vbulletin->db->free_result($asb);

	return $ids;
}
}

/**
* Initialise admin table
*
*/

$ldm_required_admin_rows = array();
$ldm_current_admin_rows = array();
$ldm_admin_seqs = array();

function ldm_cache_admin_table() {
	global $vbulletin;
	global $ldm_required_admin_rows, $ldm_current_admin_rows, $ldm_admin_seqs;

	$kill_rows = array();

	$query = "
		SELECT *
		FROM ".THIS_TABLE."linksadmin
		ORDER BY sequence
	";
	$asb = $vbulletin->db->query_read($query);
	$open = 0;
	while ($rec=$vbulletin->db->fetch_array($asb)) {

// Ensure that records in the main part of the table are properly grouped.
// This prevents corrupt addons from damaging the table
		if ($rec['sequence']<=ADMIN_SETTINGS_END) {
			if ($rec['rowtype']=='title' or $rec['rowtype']=='title_perms') {
				if ($open) {
					$kill_rows[] = $rec['adminid'];
					continue;
				}
				$open = 1;
			}
			elseif ($rec['rowtype']=='close') {
				if (!$open) {
					$kill_rows[] = $rec['adminid'];
					continue;
				}
				$open = 0;
			}
			else {
				if (!$open) {
					$kill_rows[] = $rec['adminid'];
					continue;
				}
			}
		}

		$ldm_current_admin_rows[$rec['settingname']] = $rec;
		$ldm_admin_seqs[$rec['sequence']] = 1;

	}

	if (count($kill_rows)) {
		$query = "
			DELETE
			FROM ".THIS_TABLE."linksadmin
			WHERE adminid IN (".implode(',', $kill_rows).")
		";
		$asb = $vbulletin->db->query_read($query);
	}

}

/**
* Find space for an admin setting group of given size
*
* @param	int		Required size
* @return	int		First sequence number of required space
*/

function locate_LDMadminrow_space($nseq, $startat=ADMIN_ADDON_START, $endat=ADMIN_ADDON_END) {
	global $vbulletin;
	global $ldm_required_admin_rows, $ldm_current_admin_rows, $ldm_admin_seqs;

	ldm_cache_admin_table();

	$seq = $startat;
	$nfound = 0;
	while (isset($ldm_admin_seqs[$seq]) or $nfound<$nseq) {
		if (isset($ldm_admin_seqs[$seq])) {
			$nfound = 0;
		}
		else {
			if ($nfound==0) {
				$nstart = $seq;
			}
			$nfound++;
			if ($nfound>=$nseq) {
				return $nstart;
			}
		}
		if ($seq>$endat) {
			ldm_general_failure(
				"Critical Error: ".
				"No space left in settings table region ".$startat."-".$endat
				);
		}
		$seq++;
	}

}

/**
* (Re)-initialise one admin setting
*
* @param	int		Sequence number or 0 to create
* @param	str		Setting name
* @param	str		Initial value
* @param	str		Row type (text, yesno, etc)
* @param	int		If 1, categories can override the global setting
* @param	int		If 1, update current value if any.  If 0, leave current value intact
* @param	str		If set, text description of setting
* @return	str		Form bit
*/

function require_LDMadminrow($seq, $row, $initialvalue, $rowtype='text', $canoverride=0, $force_update=0, $rowtitle='') {
	global $vbulletin;
	global $ldm_required_admin_rows, $ldm_current_admin_rows, $ldm_admin_seqs;

	if (!count($ldm_current_admin_rows)) {
		ldm_cache_admin_table();
	}

	if (!isset($ldm_current_admin_rows[$row])) {
		if ($seq==0) { // use next free value within the private section
			$seq = ADMIN_PRIVATE_START+1;
			while (isset($ldm_admin_seqs[$seq])) {
				$seq++;
			}
			$ldm_admin_seqs[$seq] = 1;
		}

		$query = "
			INSERT INTO ".THIS_TABLE."linksadmin
			SET
				sequence='". $seq."',
				settingname='".$row."',
				setting='".$vbulletin->db->escape_string($initialvalue)."',
				rowtype='".$vbulletin->db->escape_string($rowtype)."',
				canoverride='".$canoverride."',
				rowtitle='".$vbulletin->db->escape_string($rowtitle)."'
		";
		$vbulletin->db->query_write($query);

	}
	else {

		if (($seq and $seq!=$ldm_current_admin_rows[$row]['sequence']) or
			$rowtype !=$ldm_current_admin_rows[$row]['rowtype'] or
			($force_update and $initialvalue!=$ldm_current_admin_rows[$row]['setting']) or
			$rowtitle!=$ldm_current_admin_rows[$row]['rowtitle'] or
			$canoverride!=$ldm_current_admin_rows[$row]['canoverride']
			) {

			$query = "
				UPDATE ".THIS_TABLE."linksadmin
				SET
					" . ($seq ? "sequence='".$seq."'," : "") . "
					rowtype='".$vbulletin->db->escape_string($rowtype)."',
					" . ($force_update ? "setting='".$vbulletin->db->escape_string($initialvalue)."'," : "") . "
					rowtitle='".$vbulletin->db->escape_string($rowtitle)."',
					canoverride='".$canoverride."'
				WHERE settingname='".$row."'
			";
			$vbulletin->db->query_write($query);
		}
	}

	$ldm_required_admin_rows[$row] = $vbulletin->db->escape_string($row);

}

/**
* Remove one or more admin settings
*
* @param	mixed	Setting name/array of setting names
*/

function remove_LDMadminrow($row) {
	global $vbulletin;

	if (is_array($row)) {
		foreach ($row as $k=>$v) {
			$row[$k] = $vbulletin->db->escape_string($row[$k]);
		}
		$query = "
			DELETE
			FROM ".THIS_TABLE."linksadmin
			WHERE settingname IN ('".implode("', '", $row)."')
		";
	}
	else {
		$query = "
			DELETE
			FROM ".THIS_TABLE."linksadmin
			WHERE settingname = '".$vbulletin->db->escape_string($row)."'
		";
	}
	$asb = $vbulletin->db->query_read($query);
}


/**
* Clean up admin settings table by deleting obsolete entries
*
*/

function tidy_LDMadminrow() {
	global $vbulletin;
	global $ldm_required_admin_rows;

	if (count($ldm_required_admin_rows)) {
		$query = "
			DELETE
			FROM ".THIS_TABLE."linksadmin
			WHERE sequence<".ADMIN_ADDON_START."
			AND settingname NOT IN ('".implode("', '", $ldm_required_admin_rows)."')
		";
		$asb = $vbulletin->db->query_read($query);
	}
}

/**
* Initialise main admin settings
*
*/

function init_LDMadmintable() {
	global $vbulletin;
	global $ldm_current_admin_rows;

// Admin tables has five settings per row:
// a) sequence number, which determines the display order
// b) row name, where for a row called 'XXX' there should be a corresponding explanatory phrase 'll_perms_XXX'
// c) initial value
// d) row type, e.g. 'yesno', 'usergroup_check', 'linkbit', 'textbox', determines type of form input and validation method
// e) inheritable (0,1).  inheritable values can be modified in categories, with the modified value applying to the category
//    itself and down its child trees

// permissions
	$seq = ADMIN_PERMISSIONS_START;

	require_LDMadminrow($seq++, 'title_data_rights', 'll_settings_title_access', 'title_perms', 1, 1);
		require_LDMadminrow($seq++, 'can_view_category', '1,2,3,4,5,6,7,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_access_link', '1,2,3,4,5,6,7,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_play_musicbox', '2,3,4,5,6,7,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_save_musicbox', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_search_link', '1,2,3,4,5,6,7,-1', 'usergroup_check');
	require_LDMadminrow($seq++, 'close_data_rights', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_data_access', 'll_settings_title_features', 'title_perms', 1, 1);
		require_LDMadminrow($seq++, 'can_rate_link', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'must_rate_download', '-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'must_rate_play', '-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_mark_link', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_nominate_link', '2,3,4,5,6,7,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_report_link', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_send_tofriend', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_view_hits', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_view_names', '2,3,4,5,6,7,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_view_entities', '2,3,4,5,6,7,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_view_nominations', '6,-1', 'usergroup_check', 1);
	require_LDMadminrow($seq++, 'close_data_access', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_data_entry', 'll_settings_title_entry', 'title_perms', 1, 1);
		require_LDMadminrow($seq++, 'can_add_link', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_link_files', '2,3,4,5,6,7,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_upload_files', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_add_image', '2,3,4,5,6,7,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_edit_link', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_delete_link', '6,-1', 'usergroup_check');
		require_LDMadminrow($seq++, 'can_select_category', '2,3,4,5,6,7,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_add_category', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_edit_category', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_delete_category', '6,-1', 'usergroup_check');
		require_LDMadminrow($seq++, 'can_add_keyword', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_edit_keyword', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'must_add_keyword', '-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_edit_entities', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_set_display_order', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_moderate_links', '6,-1', 'usergroup_check');
	require_LDMadminrow($seq++, 'close_data_entry', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_data_override', 'll_settings_title_override', 'title_perms', 1, 1);
		require_LDMadminrow($seq++, 'can_view_hidden', (isset($ldm_current_admin_rows['can_view_expired']) ? $ldm_current_admin_rows['can_view_expired']['setting'] : '6,-1'), 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_see_protected_links_on_portal', '6,-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_bypass_hit_recording', '-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_bypass_bandwidth_limits', '-1', 'usergroup_check', 1);
		require_LDMadminrow($seq++, 'can_bypass_forumperms', '-1', 'usergroup_check');
		require_LDMadminrow($seq++, 'can_set_permissions', '6,-1', 'usergroup_check');
	require_LDMadminrow($seq++, 'close_data_override', '', 'close', 1);

// settings
	$seq = ADMIN_SETTINGS_START;

	require_LDMadminrow($seq++, 'title_vbintegrate', 'll_settings_title_vbintegrate', 'title', 0, 1);
		require_LDMadminrow($seq++, 'database_name', '');
		require_LDMadminrow($seq++, 'profile_ldmactivity', '0', 'yesno');
	require_LDMadminrow($seq++, 'close_vbintegrate', '', 'close');

	require_LDMadminrow($seq++, 'title_upload', 'll_settings_title_upload', 'title', 1, 1);
		require_LDMadminrow($seq++, 'upload_enabled', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'upload_dir', '', '', 1);
		require_LDMadminrow($seq++, 'upload_filetypes', '', '', 1);
		require_LDMadminrow($seq++, 'upload_maxspace', '0');
	require_LDMadminrow($seq++, 'close_upload', '', 'close');

	require_LDMadminrow($seq++, 'title_images', 'll_settings_title_images', 'title', 1, 1);
		require_LDMadminrow($seq++, 'link_imagesize', $vbulletin->options['attachthumbssize'], '', 1);
		require_LDMadminrow($seq++, 'link_imagemagsize', '0', '', 1);
		require_LDMadminrow($seq++, 'thumbs_dir', '');
		require_LDMadminrow($seq++, 'create_thumbs_oninsert', '0', 'yesno');
		require_LDMadminrow($seq++, 'image_filetypes', 'jpg, jpeg, gif, png', '', 1);
		require_LDMadminrow($seq++, 'image_mediatypes', 'mp3', '', 1);
    	require_LDMadminrow($seq++, 'subtitle_images_icons', '', 'break');
		require_LDMadminrow($seq++, 'file_icons_dir', 'images/ldm-ox-icons');
	require_LDMadminrow($seq++, 'close_images', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_controls', 'll_settings_title_controls', 'title', 0, 1);
		require_LDMadminrow($seq++, 'use_instructions', '', 'textbox', 1);
		require_LDMadminrow($seq++, 'allow_add_multi',  '0', '', 1);
		require_LDMadminrow($seq++, 'allow_remote_downloads',  '1', 'yesno');
		require_LDMadminrow($seq++, 'allow_bbcode',  '1', 'yesno');
		require_LDMadminrow($seq++, 'allow_html',    '0', 'yesno');
		require_LDMadminrow($seq++, 'allow_images',  '1', 'yesno');
		require_LDMadminrow($seq++, 'allow_smilies', '1', 'yesno');
		require_LDMadminrow($seq++, 'allow_null_links',  '0', 'yesno');
		require_LDMadminrow($seq++, 'allow_duplicates',  '0', 'yesno');
		require_LDMadminrow($seq++, 'apply_censor',  '0', 'yesno');
		require_LDMadminrow($seq++, 'min_textlength', '0');
		require_LDMadminrow($seq++, 'max_textlength', '0');
		require_LDMadminrow($seq++, 'validate_on_entry', '1', 'yesno', 1);
		require_LDMadminrow($seq++, 'enable_doi', '0', 'yesno');
	require_LDMadminrow($seq++, 'close_controls', '', 'close');

	require_LDMadminrow($seq++, 'title_displayopt', 'll_settings_title_displayopt', 'title', 1, 1);
		require_LDMadminrow($seq++, 'cat_show_catbit', '1', 'yesno', 1);
		require_LDMadminrow($seq++, 'template_catbit', 'links_catbit', 'catbit', 1);
		require_LDMadminrow($seq++, 'cat_cols_display', '1', '', 1);
		require_LDMadminrow($seq++, 'default_style', '-1', 'style', 1);
		require_LDMadminrow($seq++, 'cat_default_sort_order', 'N', 'sortcat', 1);
		require_LDMadminrow($seq++, 'word_wrap', '0');
    	require_LDMadminrow($seq++, 'subtitle_displayopt_menus', '', 'break');
		require_LDMadminrow($seq++, 'category_filter_menu', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'category_keyword_menu', '1', 'yesno', 1);
		require_LDMadminrow($seq++, 'category_jump_menu', '1', 'yesno');
		require_LDMadminrow($seq++, 'cat_desc_popup', '0', 'yesno', 1);
    	require_LDMadminrow($seq++, 'subtitle_displayopt_highlights', '', 'break');
		require_LDMadminrow($seq++, 'cat_icon', '', 'icon', 1);
		require_LDMadminrow($seq++, 'cat_icon_new', '', 'icon', 1);
		require_LDMadminrow($seq++, 'subcat_icon', '', 'icon', 1);
		require_LDMadminrow($seq++, 'default_cat_dseq', '1');
		require_LDMadminrow($seq++, 'cat_sub_dseq_titles', '', 'textbox', 1);
		require_LDMadminrow($seq++, 'cat_entry_dseq_titles', '', 'textbox', 1);
		require_LDMadminrow($seq++, 'count_depth', '1', 'yesno', 1);
    	require_LDMadminrow($seq++, 'subtitle_displayopt_subitems', '', 'break');
		require_LDMadminrow($seq++, 'cat_depth_display', '1', '', 1);
		require_LDMadminrow($seq++, 'cat_depth_indent', '3', '', 1);
		require_LDMadminrow($seq++, 'cat_sub_display', '0', '', 1);
		require_LDMadminrow($seq++, 'cat_sub_display_perline', '0', '', 1);
		require_LDMadminrow($seq++, 'cat_sub_display_dorder', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'cat_sub_display_limit', '0', '', 1);
		require_LDMadminrow($seq++, 'cat_sub_display_bullet', '', '', 1);
		require_LDMadminrow($seq++, 'cat_name_colwidth', '20%', '', 1);
		require_LDMadminrow($seq++, 'cat_data_colwidth', '20%', '', 1);
    	require_LDMadminrow($seq++, 'subtitle_displayopt_columns', '', 'break');
		require_LDMadminrow($seq++, 'leftcol_width', '25%', '', 1);
		require_LDMadminrow($seq++, 'rightcol_width', '25%', '', 1);
    	require_LDMadminrow($seq++, 'subtitle_displayopt_selects', '', 'break');
		require_LDMadminrow($seq++, 'template_category_selection', 'links_addnewlink_catselect', 'category_selection');
	require_LDMadminrow($seq++, 'close_displayopt', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_displayopt_entries', 'll_settings_title_displayopt_entries', 'title', 1, 1);
		require_LDMadminrow($seq++, 'template_linkbit', 'links_linkbit', 'linkbit', 1);
		require_LDMadminrow($seq++, 'template_altbit', 'links_linkbit', 'linkbit', 1);
		require_LDMadminrow($seq++, 'link_cols_display', '', '', 1);
		require_LDMadminrow($seq++, 'links_per_page', '0', '', 1);
		require_LDMadminrow($seq++, 'links_show_othercats', '1', 'yesno', 1);
		require_LDMadminrow($seq++, 'show_avatars', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'links_jump_comment', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'length_shortname', '18', '', 1);
		require_LDMadminrow($seq++, 'length_shortdesc', '24', '', 1);
		require_LDMadminrow($seq++, 'default_link_dseq', '1');
		require_LDMadminrow($seq++, 'default_sort_order', 'N', 'sort', 1);
		require_LDMadminrow($seq++, 'protected_link', '0', 1);
	require_LDMadminrow($seq++, 'close_displayopt_entries', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_displayopt_entities', 'll_settings_title_displayopt_entities', 'title', 1, 1);
		require_LDMadminrow($seq++, 'display_entities', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'entity_cellwidth', '125', '', 1);
		require_LDMadminrow($seq++, 'entity_cellspacing', '5', '', 1);
		require_LDMadminrow($seq++, 'entity_imagesize', '75', '', 1);
		require_LDMadminrow($seq++, 'entity_perrow', '6', '', 1);
	require_LDMadminrow($seq++, 'close_displayopt_entities', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_moderate', 'll_settings_title_moderate', 'title', 1, 1);
		require_LDMadminrow($seq++, 'moderate_links', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'moderate_usernames', '', 'username', 1);
		require_LDMadminrow($seq++, 'moderate_email_accept', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'moderate_email_submit', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'show_moderators_catbit', '1', 'yesno', 1);
    	require_LDMadminrow($seq++, 'subtitle_moderate_reviews', '', 'break');
		require_LDMadminrow($seq++, 'link_review_freq', '0', '', 1);
		require_LDMadminrow($seq++, 'links_expiry_days', '-1', '', 1);
		require_LDMadminrow($seq++, 'links_expired_catid', '-1', 'category', 1);
    	require_LDMadminrow($seq++, 'subtitle_moderate_reports', '', 'break');
		require_LDMadminrow($seq++, 'report_email', '1', '', 1);
		require_LDMadminrow($seq++, 'report_email_usernames', '', 'username', 1);
	require_LDMadminrow($seq++, 'close_moderate', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_hitshandle', 'll_settings_title_hitshandle', 'title', 1, 1);
		require_LDMadminrow($seq++, 'force_accept', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'force_redirect', '0', '', 1);
		require_LDMadminrow($seq++, 'timeout_hit_allow', '0');
		require_LDMadminrow($seq++, 'timeout_hit_recording', '60');
		require_LDMadminrow($seq++, 'open_local_links_newwindow', '1', 'yesno');
		require_LDMadminrow($seq++, 'open_remote_links_newwindow', '1', 'yesno');
		require_LDMadminrow($seq++, 'javascript_dl_trigger', '0', 'yesno');
		require_LDMadminrow($seq++, 'prune_downloadtable', '0');
		require_LDMadminrow($seq++, 'perpage_downloadtable', '25');
	require_LDMadminrow($seq++, 'close_hitshandle', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_featured', 'll_settings_title_featured', 'title', 1, 1);
		require_LDMadminrow($seq++, 'favandfeat_entries_enabled', '1', 'yesno', 1);
		require_LDMadminrow($seq++, 'featured_all_categories', '1', '', 1);
		require_LDMadminrow($seq++, 'featured_user_favs', '', 'username', 1);
		require_LDMadminrow($seq++, 'featured_usergroupid_favs', '', '', 1);
		require_LDMadminrow($seq++, 'featured_sites', '0', '', 1);
		require_LDMadminrow($seq++, 'featured_linkbit', 'links_linkbit_featured', 'linkbit', 1);
    	require_LDMadminrow($seq++, 'subtitle_featured_starred', '', 'break');
		require_LDMadminrow($seq++, 'starred_entries_enabled', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'starred_entries_gather', '0', '', 0);
		require_LDMadminrow($seq++, 'starred_entries_pastperiods', '1', '', 0);
		require_LDMadminrow($seq++, 'starred_entries_perpast', '1', '', 0);
	require_LDMadminrow($seq++, 'close_featured', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_commentrate', 'll_settings_title_commentrate', 'title', 1, 1);
		require_LDMadminrow($seq++, 'must_comment_and_rate', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'hide_comment', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'hide_rate', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'min_commentlength', '0');
		require_LDMadminrow($seq++, 'max_commentlength', '0');
    	require_LDMadminrow($seq++, 'subtitle_images_icons', '', 'break');
		require_LDMadminrow($seq++, 'dropdown_comment_and_rate', '3', '', 1);
		require_LDMadminrow($seq++, 'dropdown_width_comment_and_rate', '60', '', 1);
		require_LDMadminrow($seq++, 'dropdown_rows_comment_and_rate', '3', '', 1);
		require_LDMadminrow($seq++, 'inline_comment_and_rate', '0', '', 1);
		require_LDMadminrow($seq++, 'inline_rows_comment_and_rate', '5', '', 1);
		require_LDMadminrow($seq++, 'inline_ajax_comment_and_rate', '0', 'yesno', 0);
	require_LDMadminrow($seq++, 'close_commentrate', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_media', 'll_settings_title_media', 'title', 1, 1);
		require_LDMadminrow($seq++, 'open_musicbox_newwindow', '1', 'yesno');
		require_LDMadminrow($seq++, 'musicbox_width', '760', '');
		require_LDMadminrow($seq++, 'musicbox_default_sort_order', 'h', 'sort', 1);
		require_LDMadminrow($seq++, 'musicbox_files_seen', '5', '', 1);
		require_LDMadminrow($seq++, 'musicbox_standalone_height', '600', '');
		require_LDMadminrow($seq++, 'musicbox_standalone_width', '800', '');
		require_LDMadminrow($seq++, 'musicbox_inline_comment_and_rate', '0', '', 1);
	require_LDMadminrow($seq++, 'close_media', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_portal', 'll_settings_title_portal', 'title', 0, 1);
		require_LDMadminrow($seq++, 'show_hit_parade', '1', '', 1);
		require_LDMadminrow($seq++, 'hit_parade_placement', 'closing', 'mainbit_placement', 1);
		require_LDMadminrow($seq++, 'hit_parade_placeorder', '1', '', 1);
		require_LDMadminrow($seq++, 'hit_parade_bullet', '&bull;', '', 1);
		require_LDMadminrow($seq++, 'show_hp_top', '1', 'yesno', 1);
		require_LDMadminrow($seq++, 'show_hp_topall', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'show_hp_new_summary', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'show_hp_new', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'show_hp_newcomment', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'show_hp_nominate', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'show_hp_random', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'links_seen_on_portal', '10');
		require_LDMadminrow($seq++, 'days_seen_on_portal', '30');
	require_LDMadminrow($seq++, 'close_portal', '', 'close');

	require_LDMadminrow($seq++, 'title_search', 'll_settings_title_search', 'title', 0, 1);
		require_LDMadminrow($seq++, 'match_using_like', '0', 'yesno');
		require_LDMadminrow($seq++, 'search_linkbit', 'links_linkbit', 'linkbit');
    	require_LDMadminrow($seq++, 'subtitle_search_what', '', 'break');
		require_LDMadminrow($seq++, 'default_search_all', '1');
		require_LDMadminrow($seq++, 'default_search_desc', '1', 'yesno');
		require_LDMadminrow($seq++, 'default_search_keys', '1', 'yesno');
		require_LDMadminrow($seq++, 'default_search_ents', '1', 'yesno');
    	require_LDMadminrow($seq++, 'subtitle_search_similar', '', 'break');
		require_LDMadminrow($seq++, 'search_like_favwt', '1');
		require_LDMadminrow($seq++, 'search_like_hitwt', '1');
		require_LDMadminrow($seq++, 'search_like_keywt', '1');
		require_LDMadminrow($seq++, 'search_like_num', '5');
		require_LDMadminrow($seq++, 'search_like_own', '0', 'yesno');
    	require_LDMadminrow($seq++, 'subtitle_search_saved', '', 'break');
		require_LDMadminrow($seq++, 'show_searchmenu', '0', 'yesno');
		require_LDMadminrow($seq++, 'profile_searchfield', '', 'profile');
		require_LDMadminrow($seq++, 'show_profilesearchmenu', '0', 'yesno');
		require_LDMadminrow($seq++, 'profile_search_all', '3');
	require_LDMadminrow($seq++, 'close_search', '', 'close');

	require_LDMadminrow($seq++, 'title_forumperms', 'll_settings_title_forumperms', 'title', 0, 1);
		require_LDMadminrow($seq++, 'default_forumid', '-999', 'forum');
	require_LDMadminrow($seq++, 'close_forumperms', '', 'close');

	require_LDMadminrow($seq++, 'title_autocreate', 'll_settings_title_autocreate', 'title', 1);
		require_LDMadminrow($seq++, 'autocreate_active', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'autocreate_both_ways', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'autocreate_sync_comments', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'autocreate_require_userok', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'autocreate_require_moderate', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'autocreate_forum', '-999', 'forumselect', 1);
		require_LDMadminrow($seq++, 'autocreate_prefix', '', 'special', 1);
		require_LDMadminrow($seq++, 'autocreate_allow_userprefix', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'autocreate_username', '', 'username_one', 1);
		require_LDMadminrow($seq++, 'autocreate_active_sync', '0', 'yesno', 1);
	require_LDMadminrow($seq++, 'close_autocreate', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_synchronise', 'll_settings_title_synchronise', 'title', 1, 1);
		require_LDMadminrow($seq++, 'sync_enabled', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'sync_freq', '86400', '', 1);
		require_LDMadminrow($seq++, 'sync_filetypes', '', '', 1);
		require_LDMadminrow($seq++, 'sync_populate_categories', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'sync_populate_entries', '1', 'yesno', 1);
		require_LDMadminrow($seq++, 'sync_username', '', 'username_one', 1);
		require_LDMadminrow($seq++, 'sync_depth', '1', '', 1);
		require_LDMadminrow($seq++, 'sync_flatten', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'monitor_template', 'links_scantext', '', 1);
		require_LDMadminrow($seq++, 'sync_maxcpu_allowed', '2', '');
		require_LDMadminrow($seq++, 'sync_maxcpu_allowed_manual', '10', '');
	require_LDMadminrow($seq++, 'close_synchronise', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_encrypt_lock', 'll_settings_title_encrypt_lock', 'title', 0, 1);
		require_LDMadminrow($seq++, 'encrypt_lock_active', '0', 'yesno', 1);
		require_LDMadminrow($seq++, 'encrypt_lock_key', 'my secret phrase', 'text', 0);
		require_LDMadminrow($seq++, 'encrypt_lock_expiry', '0', 'text', 1);
		require_LDMadminrow($seq++, 'encrypt_lock_userid', 'USER', 'text', 1);
		require_LDMadminrow($seq++, 'encrypt_lock_userip', 'IPADDRESS', 'text', 1);
	require_LDMadminrow($seq++, 'close_encrypt_lock', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_bit_cache', 'll_settings_title_bit_cache', 'title', 0, 1);
		require_LDMadminrow($seq++, 'bit_cache_active', '0', 'yesno');
		require_LDMadminrow($seq++, 'bit_cache_expiry', '0', '');
		require_LDMadminrow($seq++, 'bit_cache_usergroup_bypass', '', '');
	require_LDMadminrow($seq++, 'close_bit_cache', '', 'close', 1);

	require_LDMadminrow($seq++, 'title_security', 'll_settings_title_security', 'title', 0, 1);
		require_LDMadminrow($seq++, 'local_file_root', '0', 'yesno');
		require_LDMadminrow($seq++, 'local_file_root_prefix', '');
		require_LDMadminrow($seq++, 'allow_http_ranges', '1', 'yesno');
		require_LDMadminrow($seq++, 'force_fopen', '0', 'yesno');
		require_LDMadminrow($seq++, 'force_saveas', '0', 'yesno');
		require_LDMadminrow($seq++, 'secure_nullindexfile', '0', 'yesno');
		require_LDMadminrow($seq++, 'mod_rewrite', '');
		require_LDMadminrow($seq++, 'robots_meta_tag', 'index, nofollow');
		require_LDMadminrow($seq++, 'forms_fullwidth', '0', 'yesno');
	require_LDMadminrow($seq++, 'close_security', '', 'close');

// Remaining parameters are not set via main admin settings/permissions pages
	$seq = ADMIN_PRIVATE_START;

// Pre-defined linkbits - extend to match linkbits available in templates.xml ---------------------------------------
// name=X: name used in selection menus
// collapse=K: if not null, display collapse icon which toggles to this linkbit, usually link_linkbit_short
// defcol=N: default number of display columns
// maxcol=N: maximum number of columns that it makes sense to display
// altbit=M: alternative linkbit when user views a single entry, if 0 then pick up the general template_altbit setting
	require_LDMadminrow($seq++, 'links_linkbit', serialize(array("name"=>"Modern", "collapse"=>"links_linkbit_short", "defcol"=>1, "maxcol"=>1, "altbit"=>0)), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_mshort', serialize(array("name"=>"Modern (Short Description)", "collapse"=>"links_linkbit_short", "defcol"=>1, "maxcol"=>2, "altbit"=>0)), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_mtop', serialize(array("name"=>"Modern (Aligned at Top)", "collapse"=>"links_linkbit_short", "defcol"=>1, "maxcol"=>1, "altbit"=>0)), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_greg', serialize(array("name"=>"Bold", "collapse"=>"links_linkbit_short", "defcol"=>1, "maxcol"=>1, "altbit"=>0)), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_featured', serialize(array("name"=>"Featured", "collapse"=>"links_linkbit_short", "defcol"=>1, "maxcol"=>3, "altbit"=>0)), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_short', serialize(array("name"=>"Short (Title, Thumb, Short Description)", "collapse"=>0, "defcol"=>1, "maxcol"=>5, "altbit"=>0)), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_short_direct', serialize(array("name"=>"Short (Direct Link, No Thumb, No Description)", "collapse"=>"links_linkbit_table", "defcol"=>1, "maxcol"=>5, "altbit"=>"links_linkbit")), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_title', serialize(array("name"=>"Title Only", "collapse"=>0, "defcol"=>1, "maxcol"=>3, "altbit"=>0)), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_photo', serialize(array("name"=>"Photo Album", "collapse"=>0, "defcol"=>5, "maxcol"=>10, "altbit"=>0)), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_table', serialize(array("name"=>"Tabular", "collapse"=>"links_linkbit_short", "defcol"=>1, "maxcol"=>2, "altbit"=>0)), 'define_linkbit', 1);
	require_LDMadminrow($seq++, 'links_linkbit_jukebox', serialize(array("name"=>"Jukebox (brief)", "collapse"=>"links_linkbit_short", "defcol"=>1, "maxcol"=>1, "altbit"=>"links_linkbit_jukebox")), 'define_linkbit', 1);
// Pre-defined linkbits - extend to match linkbits available in templates.xml ---------------------------------------

// Pre-defined catbits - extend to match catbits available in templates.xml -----------------------------------------
// name=X: name used in selection menus
// defcol=N: default number of display columns
// maxcol=N: maximum number of columns that it makes sense to display
// subbit=M: template used for displaying subcategories within this catbit
	require_LDMadminrow($seq++, 'links_catbit', serialize(array("name"=>"Tabular", "defcol"=>1, "maxcol"=>4, "subbit"=>"links_subcatbit")), 'define_catbit', 1);
	require_LDMadminrow($seq++, 'links_catbit_brief', serialize(array("name"=>"Brief", "defcol"=>2, "maxcol"=>4, "subbit"=>"links_subcatbit")), 'define_catbit', 1);
// Pre-defined catbits - extend to match catbits available in templates.xml -----------------------------------------

	require_LDMadminrow($seq++, 'this_version', THIS_VERSION);
	require_LDMadminrow($seq++, 'version_installed', 0);
	require_LDMadminrow($seq++, 'bandwidth_limit', '');
	require_LDMadminrow($seq++, 'autocreate_userid', 0);
	require_LDMadminrow($seq++, 'sync_userid', 0);
	require_LDMadminrow($seq++, 'download_mirrors', serialize(array()));
	require_LDMadminrow($seq++, 'entity_definitions', serialize(array('entities'=>array(), 'groups'=>array())), 'text', 1);

	require_LDMadminrow($seq++, 'starred_entries_periodstart', 0);
	require_LDMadminrow($seq++, 'starred_entries_validuntil', 0);
	require_LDMadminrow($seq++, 'starred_entries', serialize(array(0)));

	$feat_userids = array();
	if ($ldm_current_admin_rows['featured_user_favs']['setting']) {
		$feat_users = explode(';', $ldm_current_admin_rows['featured_user_favs']['setting']);
		foreach ($feat_users as $k=>$v) {
			if (!trim($v)) {
				unset($feat_users[$k]);
			}
		}
		$feat_userids = ldm_lookup_userids($feat_users);
	}
	require_LDMadminrow($seq++, 'featured_userid_favs', serialize($feat_userids));

	require_LDMadminrow($seq++, 'DEBUG', '', 'yesno');
	require_LDMadminrow($seq++, 'TRACE', '', 'yesno');
	require_LDMadminrow($seq++, 'seo_friendly', '0', 'yesno');
	require_LDMadminrow($seq++, 'seo_title', '', '');

// Standard media players

	$players = create_ldm_players();
	foreach ($players as $thisplayer) {
		require_LDMadminrow($seq++, 'ldm_player_'.$thisplayer["name"], serialize($thisplayer), 'define_mediaplayer');
	}

// Tidy up old plugin...
	remove_LDMadminrow(array(
		'autocreate_title', 'autocreate_limitcats', 'autocreate_sync_comments_with_thread', 'autocreate_close',
		));

	tidy_LDMadminrow();

}

/**
* Initialise the player data structure
*
* @return	array	Array of player definitions
*/

function create_ldm_players() {
	global $ldm_current_admin_rows;

	$ldm_players = array();

// Format:
// - required settings
// 		name => player name, must be unique
//		priority => priority order, larger numbers higher
// 		opsys => array ("Windows"=>0/1, "Mac"=>0/1, "Linux"=>0/1) of user operating systems which can
//			handle this player
// 		playerbit => player's VB template
// 		filetypes_played => comma-separated list of filetypes handled (can be empty)
// 		vars => array of variables to instantiate before calling the player template
// 		player_stream => "stream" or "url" or "fullurl", indicated what url the player expects to be given
//		urlencode => 1 if the player_stream should be urlencoded
//		enabled => 1/0 allows you to disable a player
// - optional settings
//		player_header_func => function which returns any code to include in page header, e.g. javascript initialisation
//		playerid_func => function called within get_ldm_playerid() to determine
//			whether the player will handle the current entry
//		playerbit_func => function called within get_ldm_playerbit() to
//			handle the processing of the current entry
//		ismaster => if set, then player is stored in database, otherwise
//			it's treated as a temporary run-time extra
//      canremove => if set, player can be deleted by admin, otherwise
//          it's permanent
//

// Jeroen van Wijering's Flash Player
	$filetypes = "mp3, m4a";

	$ldm_players[] = array(
		"name" => "JWmp3Player",
		"priority" => 15,
		"enabled" => 1,
		"filetypes_played" => $filetypes,
		"playerbit" => "links_playerbit_JWPlayer",
		"playerheader" => "links_JWplayer_header",
		"opsys" => array( "Windows"=>1, "Linux"=>1, "Mac"=>1, ),
		"vars" => array( "player_width" => 320, "player_height" => 20, "player_start" => "true", "player_source" => "clientscript/JWmediaplayer.swf", ),
		"player_stream" => "stream",
		"urlencode" => 1,
		"ismaster" => 1,
		);

// Jeroen van Wijering's Flash Player
	$filetypes = "flv, m4v, mp4";

	$ldm_players[] = array(
		"name" => "JWflvPlayer",
		"priority" => 15,
		"enabled" => 1,
		"filetypes_played" => $filetypes,
		"playerbit" => "links_playerbit_JWPlayer",
		"playerheader" => "links_JWplayer_header",
		"opsys" => array( "Windows"=>1, "Linux"=>1, "Mac"=>1, ),
		"vars" => array( "player_width" => 320, "player_height" => 240, "player_start" => "true", "player_source" => "clientscript/JWmediaplayer.swf", ),
		"player_stream" => "stream",
		"urlencode" => 1,
		"ismaster" => 1,
		);

// Windows Media Player
	if (isset($ldm_current_admin_rows['musicbox_filetypes'])) {
		$filetypes = $ldm_current_admin_rows['musicbox_filetypes']['setting'];
	}
	else {
		$filetypes = "mpg, mpeg, wmv, mp3, asf, wma, avi, wav";
	}

	$ldm_players[] = array(
		"name" => "WindowsMediaPlayer",
		"priority" => 10,
		"enabled" => 1,
		"filetypes_played" => $filetypes,
		"playerbit" => "links_playerbit_MediaPlayer",
		"playerheader" => "",
		"opsys" => array( "Windows"=>1, "Linux"=>0, "Mac"=>0, ),
		"vars" => array( "player_width" => 320, "player_height" => 240, ),
		"player_stream" => "stream",
		"urlencode" => 0,
		"ismaster" => 1,
		);

// QuickTime Audio
	$filetypes = "mp3, wma, wav";

	$ldm_players[] = array(
		"name" => "QuickTimeAudio",
		"priority" => 8,
		"enabled" => 1,
		"filetypes_played" => $filetypes,
		"playerbit" => "links_playerbit_QuickTime",
		"playerheader" => "",
		"opsys" => array( "Windows"=>1, "Linux"=>0, "Mac"=>1, ),
		"vars" => array( "player_width" => 240, "player_height" => 16, ),
		"player_stream" => "stream",
		"urlencode" => 0,
		"ismaster" => 1,
		);

// QuickTime
	if (isset($ldm_current_admin_rows['musicbox_filetypes_quicktime'])) {
		$filetypes = $ldm_current_admin_rows['musicbox_filetypes_quicktime']['setting'];
	}
	else {
		$filetypes = "mov, qt, mpg, mpeg, wmv, asf, avi, 3gp";
	}

	$ldm_players[] = array(
		"name" => "QuickTime",
		"priority" => 8,
		"enabled" => 1,
		"filetypes_played" => $filetypes,
		"playerbit" => "links_playerbit_QuickTime",
		"playerheader" => "",
		"opsys" => array( "Windows"=>1, "Linux"=>0, "Mac"=>1, ),
		"vars" => array( "player_width" => 320, "player_height" => 256, ),
		"player_stream" => "stream",
		"urlencode" => 0,
		"ismaster" => 1,
		);

// Real Player
	if (isset($ldm_current_admin_rows['musicbox_filetypes_realplayer'])) {
		$filetypes = $ldm_current_admin_rows['musicbox_filetypes_player']['setting'];
	}
	else {
		$filetypes = "mp3, mpg, mpeg, avi, mov, qt, ra, ram, rm, rmvb, rpm, rv";
	}

	$ldm_players[] = array(
		"name" => "RealPlayer",
		"priority" => 3,
		"enabled" => 1,
		"filetypes_played" => $filetypes,
		"playerbit" => "links_playerbit_RealPlayer",
		"playerheader" => "",
		"opsys" => array( "Windows"=>1, "Linux"=>1, "Mac"=>1, ),
		"vars" => array( "player_width" => 320, "player_height" => 240, ),
		"player_stream" => "stream",
		"urlencode" => 0,
		"ismaster" => 1,
		);

// DivX
	if (isset($ldm_current_admin_rows['musicbox_filetypes_divx'])) {
		$filetypes = $ldm_current_admin_rows['musicbox_filetypes_divx']['setting'];
	}
	else {
		$filetypes = "divx, avi";
	}

	$ldm_players[] = array(
		"name" => "DivX",
		"priority" => 5,
		"enabled" => 1,
		"filetypes_played" => $filetypes,
		"playerbit" => "links_playerbit_DivX",
		"playerheader" => "",
		"opsys" => array( "Windows"=>1, "Linux"=>1, "Mac"=>1, ),
		"vars" => array( "player_width" => 320, "player_height" => 240, ),
		"player_stream" => "fullurl",
		"urlencode" => 0,
		"ismaster" => 1,
		);

	return $ldm_players;

}

/**
* Create the LD database table structures
*
*/

function create_LDMtables() {
	global $vbulletin;

	echo '<hr /><b>Verifying database tables</b><br />';

	$asb = $vbulletin->db->query_read("SHOW TABLES");
	$hack_table_prefix = THIS_TABLE."links";
	$hack_tables = array();
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		foreach ($myrow AS $table) {
			if (preg_match ("/^$hack_table_prefix(.*)/", $table)) {
				$hack_tables[$table] = 1;
			}
		}
	}

	if (!isset($hack_tables[THIS_TABLE."linksadmin"])) {
		echo "--- Creating ".THIS_TABLE."linksadmin<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linksadmin (
			 adminid INT(10) NOT NULL auto_increment,
			 settingname VARCHAR(255) NOT NULL,
			 setting TEXT NOT NULL,
			 sequence INT(10) NOT NULL,
			 rowtype TEXT NOT NULL,
			 rowtitle TEXT NOT NULL,
			 canoverride SMALLINT(2) NOT NULL,
			 catid SMALLINT(5) DEFAULT '-1' NOT NULL,
			 PRIMARY KEY (adminid)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linksbitcache"])) {
		echo "--- Creating ".THIS_TABLE."linksbitcache<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linksbitcache (
			 bitid INT(10) NOT NULL auto_increment,
			 bitname VARCHAR(255) NOT NULL,
			 bitcontents MEDIUMTEXT NOT NULL,
			 bitdata MEDIUMTEXT NOT NULL,
			 usergroupid INT(10) NOT NULL,
			 styleid INT(10) NOT NULL,
			 timeline INT(10) NOT NULL,
			 PRIMARY KEY (bitid)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linkscat"])) {
		echo "--- Creating ".THIS_TABLE."linkscat<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linkscat (
			 catid SMALLINT(5) NOT NULL auto_increment,
			 catname VARCHAR(255) NOT NULL,
			 catdesc TEXT NOT NULL,
			 cattext MEDIUMTEXT NOT NULL,
			 parentid SMALLINT(5) NOT NULL,
			 parentlist VARCHAR(250) NOT NULL,
			 catforum SMALLINT(5) NOT NULL,
			 catforumlink SMALLINT(5) DEFAULT '0' NOT NULL,
			 catusername TEXT NOT NULL,
			 catuserid INT(10) NOT NULL,
			 catentry MEDIUMINT(8) NOT NULL,
			 catdate INT(10) NOT NULL,
			 catmoderate INT(2) NOT NULL,
			 catclosed INT(2) DEFAULT '0' NOT NULL,
			 displayorder INT(11) DEFAULT '1' NOT NULL,
			 catsyncdir TEXT NOT NULL DEFAULT '',
			 catsynctime INT(10) NOT NULL,
			 catsyncdone INT(2) NOT NULL,
			 PRIMARY KEY (catid)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linksdebug"])) {
		echo "--- Creating ".THIS_TABLE."linksdebug<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linksdebug (
			 adminid SMALLINT(5) NOT NULL auto_increment,
			 userid INT(10) NOT NULL,
			 settingtime INT(10) NOT NULL,
			 message TEXT NOT NULL,
			 command TEXT NOT NULL,
			 get TEXT NOT NULL,
			 post TEXT NOT NULL,
			 files TEXT NOT NULL,
			 cookie TEXT NOT NULL,
			 settings TEXT NOT NULL,
			 PRIMARY KEY (adminid)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linksdownloads"])) {
		echo "--- Creating ".THIS_TABLE."linksdownloads<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linksdownloads (
			 dlid INT(11) NOT NULL auto_increment,
			 linkid INT(11) NOT NULL,
			 linkurl TEXT NOT NULL,
			 username TEXT NOT NULL,
			 userid INT(10) NOT NULL,
			 userip TEXT NOT NULL,
			 userbrowser TEXT NOT NULL,
			 usertime INT(10) NOT NULL,
			 bytes INT(10) NOT NULL,
			 PRIMARY KEY (dlid),
			 KEY (linkid),
			 KEY (usertime)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linksentities"])) {
		echo "--- Creating ".THIS_TABLE."linksentities<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linksentities (
			 entityid INT(11) NOT NULL auto_increment,
			 linkid INT(11) NOT NULL,
			 entityname VARCHAR(255) NOT NULL,
			 entitydesc TEXT NOT NULL,
			 entityvalue TEXT NOT NULL,
			 entitygroup VARCHAR(255) NOT NULL,
			 entitytype INT(3) NOT NULL,
			 entitydate INT(10) NOT NULL,
			 PRIMARY KEY (entityid),
			 KEY (linkid),
			 FULLTEXT KEY valuedesc (entityvalue, entitydesc)
		)
		TYPE = MYISAM
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linksfavs"])) {
		echo "--- Creating ".THIS_TABLE."linksfavs<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linksfavs (
			 lfav INT(11) NOT NULL auto_increment,
			 linkid INT(11) NOT NULL,
			 userid INT(10) NOT NULL,
			 PRIMARY KEY (lfav),
			 KEY (userid),
			 KEY (linkid)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linkskeys"])) {
		echo "--- Creating ".THIS_TABLE."linkskeys<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linkskeys (
			 keyid INT(11) NOT NULL auto_increment,
			 keyword VARCHAR(32),
			 PRIMARY KEY (keyid),
			 KEY (keyword)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linkslink"])) {
		echo "--- Creating ".THIS_TABLE."linkslink<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linkslink (
			 linkid INT(11) NOT NULL auto_increment,
			 linkname VARCHAR(255) NOT NULL,
			 linkdoi VARCHAR(255) NOT NULL,
			 linkdesc TEXT NOT NULL,
			 linkurl TEXT NOT NULL,
			 linkfile TEXT NOT NULL,
			 linkimg TEXT NOT NULL,
			 linkimgthumb MEDIUMTEXT DEFAULT '' NOT NULL,
			 linkimgthumbsize INT(5) DEFAULT '0' NOT NULL,
			 linkhits MEDIUMINT(8) UNSIGNED DEFAULT '0' NOT NULL,
			 linkforum SMALLINT(5) NOT NULL,
			 linkcheck INT(10) unsigned NOT NULL,
			 linksize INT(10) DEFAULT '0' NOT NULL,
			 linkstatus INT(10) DEFAULT '0' NOT NULL,
			 linkimgstatus INT(10) DEFAULT '0' NOT NULL,
			 linkdate INT(10) NOT NULL,
			 linkusername TEXT NOT NULL,
			 linkuserid INT(10) NOT NULL,
			 linkmoderate INT(2) NOT NULL,
			 linkmoddate INT(10) DEFAULT '0' NOT NULL,
			 linkreviewfreq SMALLINT(5) DEFAULT '0' NOT NULL,
			 linkthread INT(10) NOT NULL,
			 numcomment INT(10) DEFAULT '0' NOT NULL,
			 numrate INT(10) DEFAULT '0' NOT NULL,
			 totrate INT(10) DEFAULT '0' NOT NULL,
			 PRIMARY KEY (linkid),
			 FULLTEXT KEY namedesc (linkname,linkdesc)
		)
		TYPE = MYISAM
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linksltoc"])) {
		echo "--- Creating ".THIS_TABLE."linksltoc<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linksltoc (
			 ltoc INT(11) NOT NULL auto_increment,
			 linkid INT(11) NOT NULL,
			 catid SMALLINT(5) NOT NULL,
			 displayorder INT(11) DEFAULT '1' NOT NULL,
			 PRIMARY KEY (ltoc),
			 KEY (linkid)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linksltok"])) {
		echo "--- Creating ".THIS_TABLE."linksltok<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linksltok (
			 lkey INT(11) NOT NULL auto_increment,
			 linkid INT(11) NOT NULL,
			 keyid INT(11) NOT NULL,
			 PRIMARY KEY (lkey),
			 KEY (linkid),
			 KEY (keyid)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linksrate"])) {
		echo "--- Creating ".THIS_TABLE."linksrate<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linksrate (
			 lrate INT(11) NOT NULL auto_increment,
			 linkid INT(11) NOT NULL,
			 linkuserid INT(10) NOT NULL,
			 linkusername TEXT NOT NULL,
			 lcomment TEXT DEFAULT '' NOT NULL,
			 ltime INT(10) UNSIGNED DEFAULT '0' NOT NULL,
			 linkvote SMALLINT(5),
			 PRIMARY KEY (lrate)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linkssearch"])) {
		echo "--- Creating ".THIS_TABLE."linkssearch<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linkssearch (
			 searchid INT(11) NOT NULL auto_increment,
			 searchname TEXT DEFAULT '' NOT NULL,
			 searchparam TEXT NOT NULL,
			 searchusername TEXT NOT NULL,
			 searchuserid INT(10) NOT NULL,
			 searchtime INT(10) UNSIGNED DEFAULT '0' NOT NULL,
			 searchhits INT(10) NOT NULL,
			 searchmenu INT(2) NOT NULL,
			 PRIMARY KEY (searchid),
			 KEY (searchuserid),
			 KEY (searchmenu)
		)
		");
	}

	if (!isset($hack_tables[THIS_TABLE."linkstarred"])) {
		echo "--- Creating ".THIS_TABLE."linkstarred<br />";
		$asb = $vbulletin->db->query_write("
		CREATE TABLE IF NOT EXISTS ".THIS_TABLE."linkstarred(
			 starid INT(11) NOT NULL auto_increment,
			 linkid INT(11) NOT NULL,
			 userid INT(10) NOT NULL,
			 usertime INT(10) NOT NULL,
			 PRIMARY KEY (starid),
			 KEY (linkid),
			 KEY (usertime)
		)
		");
	}

}

function fetch_LDMtable_columns($table) {
	global $vbulletin;

	$columns = array();
	$asb = $vbulletin->db->query_read("SHOW COLUMNS FROM ".$table);
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$columns[$myrow['Field']] = $myrow;
	}

	return $columns;

}

/**
* Update datastore records
*
*/

function patch_LDMdatastore() {
	global $vbulletin;

	build_datastore('ldm_admin', 0, 0);
	build_datastore('ldm_cats', 0, 0);

}

/**
* Upgrade tables (if necessary) from earlier versions
*
*/

function patch_LDMtables($stage) {
	global $vbulletin;
	global $ldm_hack_version;
	static $redo_ratings = 0;

	switch ($stage) {
	case 1:

// Simple changes, no need to check
		if ($ldm_hack_version!='0' and substr($ldm_hack_version,0,1)<'2') {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				CHANGE linkhits linkhits MEDIUMINT( 8 ) UNSIGNED DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				CHANGE linkstatus linkstatus INT( 10 ) DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdownloads
				CHANGE dlid dlid INT( 11 ) NOT NULL AUTO_INCREMENT
			");
		}

		if ($ldm_hack_version!='0' and (substr($ldm_hack_version,0,1)<'2' or substr($ldm_hack_version,0,5)<'2.2.5')) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdebug
				CHANGE adminid adminid INT( 10 ) NOT NULL AUTO_INCREMENT
			");
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksadmin
				CHANGE sequence sequence INT( 10 ) NOT NULL
			");
		}

		if ($ldm_hack_version!='0' and substr($ldm_hack_version,0,5)<'2.3.1') {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksbitcache
			    CHANGE bitcontents bitcontents MEDIUMTEXT NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksbitcache
			    CHANGE bitdata bitdata MEDIUMTEXT NOT NULL
			");
		}

// linksadmin
		$columns = fetch_LDMtable_columns(THIS_TABLE."linksadmin");
		if (!$columns["sequence"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksadmin
				ADD COLUMN sequence SMALLINT(5) NOT NULL
			");
		}
		if (!$columns["rowtype"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksadmin
				ADD COLUMN rowtype TEXT NOT NULL
			");
		}
		if (!$columns["rowtitle"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksadmin
				ADD COLUMN rowtitle TEXT NOT NULL
			");
		}
		if (!$columns["canoverride"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksadmin
				ADD COLUMN canoverride SMALLINT(2) NOT NULL
			");
		}
		if (!$columns["catid"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksadmin
				ADD COLUMN catid SMALLINT(5) DEFAULT '-1'
			");
		}
		if ($columns["description"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksadmin
				DROP description
			");
		}

// linksdebug
		$columns = fetch_LDMtable_columns(THIS_TABLE."linksdebug");
		$debugmod = 0;
		if (!$columns["command"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdebug
				ADD COLUMN command TEXT NOT NULL
			");
			$debugmod = 1;
		}
		if (!$columns["get"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdebug
				ADD COLUMN get TEXT NOT NULL
			");
			$debugmod = 1;
		}
		if (!$columns["post"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdebug
				ADD COLUMN post TEXT NOT NULL
			");
			$debugmod = 1;
		}
		if (!$columns["files"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdebug
				ADD COLUMN files TEXT NOT NULL
			");
			$debugmod = 1;
		}
		if (!$columns["cookie"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdebug
				ADD COLUMN cookie TEXT NOT NULL
			");
			$debugmod = 1;
		}
		if ($debugmod) { // clear the debug table
			$asb = $vbulletin->db->query_write("
				TRUNCATE TABLE ".THIS_TABLE."linksdebug
			");
		}

// linksdownloads
		$columns = fetch_LDMtable_columns(THIS_TABLE."linksdownloads");
		if (!$columns["bytes"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdownloads
				ADD COLUMN bytes INT(10) NOT NULL
			");
		}
		$asb = $vbulletin->db->query_read("
			SHOW INDEX FROM ".THIS_TABLE."linksdownloads
		");
		$index = 0;
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			if (isset($myrow[Column_name]) and $myrow[Column_name] == "linkid") {
				$lindex = 1;
			}
			if (isset($myrow[Column_name]) and $myrow[Column_name] == "usertime") {
				$tindex = 1;
			}
		}
		if (!$lindex) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdownloads ADD INDEX ( linkid )
			");
		}
		if (!$tindex) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksdownloads ADD INDEX ( usertime )
			");
		}


// linksentities
		$columns = fetch_LDMtable_columns(THIS_TABLE."linksentities");
		if (!$columns["entitydesc"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksentities
				ADD COLUMN entitydesc TEXT NOT NULL
			");
		}
		if ($columns["username"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksentities
				DROP username
			");
		}
		if ($columns["userid"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksentities
				DROP userid
			");
		}

		$asb = $vbulletin->db->query_read("
			SHOW INDEX FROM ".THIS_TABLE."linksentities
		");
		$evindex = 0;
		$index = 0;
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			if (isset($myrow[Column_name])) {
				if ($myrow[Column_name] == "entityvalue" and $myrow[Key_name] == "namedesc" and $myrow[Index_type] == "FULLTEXT") {
					$evindex = 1;
				}
				if ($myrow[Column_name] == "entityvalue" and $myrow[Key_name] != "namedesc" and $myrow[Index_type] == "FULLTEXT") {
					$index += 1;
				}
				if ($myrow[Column_name] == "entitydesc" and $myrow[Index_type] == "FULLTEXT") {
					$index += 1;
				}
			}
		}
		if ($evindex==1) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksentities DROP INDEX namedesc
			");
		}
		if ($index<2) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksentities ADD FULLTEXT valuedesc (entityvalue, entitydesc)
			");
		}

// linkssearch
		$columns = fetch_LDMtable_columns(THIS_TABLE."linkssearch");
		if ($columns["searchexpires"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkssearch
				DROP searchexpires
			");
		}
		if (!$columns["searchmenu"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkssearch
				ADD COLUMN searchmenu INT(2) NOT NULL
			");
		}
		if (!$columns["searchuserid"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkssearch
				ADD COLUMN searchuserid INT(10) NOT NULL
			");
		}
		$asb = $vbulletin->db->query_read("
			SHOW INDEX FROM ".THIS_TABLE."linkssearch
		");
		$userindex = 0;
		$menuindex = 0;
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			if (isset($myrow[Column_name]) and $myrow[Column_name] == "searchuserid") {
				$userindex = 1;
			}
			if (isset($myrow[Column_name]) and $myrow[Column_name] == "searchmenu") {
				$menuindex = 1;
			}
		}
		if ($userindex==0) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkssearch ADD INDEX ( searchuserid )
			");
		}
		if ($menuindex==0) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkssearch ADD INDEX ( searchmenu )
			");
		}

// linksfavs
		$asb = $vbulletin->db->query_read("
			SHOW INDEX FROM ".THIS_TABLE."linksfavs
		");
		$index = 0;
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			if (isset($myrow[Column_name]) and $myrow[Column_name] == "linkid") {
				$index = 1;
			}
		}
		if ($index==0) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksfavs ADD INDEX ( linkid )
			");
		}

// linkslink
		$asb = $vbulletin->db->query_read("
			SHOW INDEX FROM ".THIS_TABLE."linkslink
		");
		$ftindex = 0;
		$uiindex = 0;
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			if (isset($myrow[Column_name])) {
				if ($myrow[Column_name] == "linkname") {
					$ftindex += 1;
				}
				if ($myrow[Column_name] == "linkdesc") {
					$ftindex += 1;
				}
			}
		}
		if ($ftindex<2) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink ADD FULLTEXT namedesc (linkname, linkdesc)
			");
		}

		$columns = fetch_LDMtable_columns(THIS_TABLE."linkslink");
		if (!$columns["numcomment"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN numcomment INT(10) DEFAULT '0' NOT NULL
			");
// added at 2.3.0, this also requires recalculating numrate and totrate
			$redo_ratings = 1;
		}
		if (!$columns["linkdoi"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linkdoi VARCHAR(255) NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkdoi=''
			");
		}
		if (!$columns["linkmoderate"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linkmoderate INT(2) NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkmoderate=0
			");
		}
		if (!$columns["linkreviewfreq"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linkmoddate INT(10) DEFAULT '0' NOT NULL,
				ADD COLUMN linkreviewfreq SMALLINT(5) DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkreviewfreq=0, linkmoddate=0
			");
		}
		if (!$columns["linkimg"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linkimg TEXT NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkimg=''
			");
		}
		if (!$columns["linkimgstatus"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linkimgstatus INT(10) DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkimgstatus=0
				WHERE linkimg = ''
		");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkimgstatus=1
				WHERE linkimg != ''
			");
		}
		if (!$columns["linkimgthumb"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linkimgthumb MEDIUMTEXT DEFAULT '' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkimgthumb=''
			");
		}
		if (!$columns["linkimgthumbsize"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linkimgthumbsize INT(5) DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkimgthumbsize='0'
			");
		}
		if (!$columns["linksize"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linksize INT(10) DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linksize=linkstatus
				WHERE linkstatus>1
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkstatus=1
				WHERE linkstatus>1
			");
		}
		if (!$columns["linkfile"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linkfile TEXT NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkfile=''
			");
		}
		if (!$columns["linkthread"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN linkthread INT(10) NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET linkthread=0
			");
		}
		if ($columns["linkthreadid"]) {
			$asb = $vbulletin->db->query_write("
			ALTER TABLE ".THIS_TABLE."linkslink
			DROP linkthreadid
			");
		}

// linksltoc
		$asb = $vbulletin->db->query_read("
			SHOW INDEX FROM ".THIS_TABLE."linksltoc
		");
		$index = 0;
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			if (isset($myrow[Column_name]) and $myrow[Column_name] == "linkid") {
				$index = 1;
			}
		}
		if ($index==0) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksltoc ADD INDEX ( linkid )
			");
		}

		$columns = fetch_LDMtable_columns(THIS_TABLE."linksltoc");
		if (!$columns["displayorder"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksltoc
				ADD COLUMN displayorder INT(11) DEFAULT '1' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linksltoc
				SET displayorder=1
			");
		}

// linkscat [nb .. after linksltoc ..]
		$columns = fetch_LDMtable_columns(THIS_TABLE."linkscat");
		if (!$columns["catentry"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkscat
				ADD COLUMN catentry MEDIUMINT(8) NOT NULL,
				ADD COLUMN catdate INT(10) NOT NULL
			");
			$asb = $vbulletin->db->query_read("
				SELECT ltoc.catid AS catid, link.linkdate AS linkdate
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid = ltoc.linkid
			");
			$catcount = array();
			$catdate = array();
			while ($myrow = $vbulletin->db->fetch_array($asb)) {
				if (!isset($catdate[$myrow[catid]])) {
					$catcount[$myrow[catid]] = 1;
					$catdate[$myrow[catid]] = $myrow[linkdate];
				}
				else {
					$catcount[$myrow[catid]] +=1;
					$catdate[$myrow[catid]] = max($catdate[$myrow[catid]], $myrow[linkdate]);
				}
			}
			foreach ($catcount as $catid => $count) {
				$vbulletin->db->query_write("
					UPDATE ".THIS_TABLE."linkscat
					SET catentry=".$count.", catdate=".$catdate[$catid]."
					WHERE catid='$catid'
					LIMIT 1
				");
			}
		}
		if (!$columns["catmoderate"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkscat
				ADD COLUMN catmoderate INT(2) NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET catmoderate=0
			");
		}
		if (!$columns["catclosed"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkscat
				ADD COLUMN catclosed INT(2) NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET catclosed=0
			");
		}
		if (!$columns["displayorder"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkscat
				ADD COLUMN displayorder INT(11) DEFAULT '1' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET displayorder=1
			");
		}
		if (!$columns["catforumlink"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkscat
				ADD COLUMN catforumlink SMALLINT(5) DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET catforumlink=0
			");
		}
		if (!$columns["catforumlink"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkscat
				ADD COLUMN catforumlink SMALLINT(5) DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET catforumlink=0
			");
		}
		if (!$columns["catsyncdir"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkscat
				ADD COLUMN catsyncdir TEXT DEFAULT '' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET catsyncdir=''
			");
		}
		if (!$columns["catsynctime"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkscat
				ADD COLUMN catsynctime INT(10) NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET catsynctime='0'
			");
		}
		if (!$columns["catsyncdone"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkscat
				ADD COLUMN catsyncdone INT(2) NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkscat
				SET catsyncdone='0'
			");
		}

// linksrate
		$columns = fetch_LDMtable_columns(THIS_TABLE."linksrate");
		if (!$columns["lcomment"]) {
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linksrate
				ADD COLUMN linkusername TEXT NOT NULL,
				ADD COLUMN lcomment TEXT DEFAULT '' NOT NULL,
				ADD COLUMN ltime INT(10) UNSIGNED DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				ALTER TABLE ".THIS_TABLE."linkslink
				ADD COLUMN numrate INT(10) DEFAULT '0' NOT NULL,
				ADD COLUMN totrate INT(10) DEFAULT '0' NOT NULL
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linksrate
				SET linkusername='', lcomment='',ltime='0'
			");
			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET numrate='0', totrate='0'
			");
		}

		break;

	case 2:

// linkscat
		$columns = fetch_LDMtable_columns(THIS_TABLE."linkscat");

// move some columns into the admin table
		if ($columns["styleid"]) {
			$adminrow = $vbulletin->db->query_first("
				SELECT * FROM ".THIS_TABLE."linksadmin
				WHERE settingname='default_style'
				AND catid='-1'
			");
			if (isset($adminrow['sequence'])) {
				$asb = $vbulletin->db->query_read("
					SELECT * FROM ".THIS_TABLE."linkscat
					WHERE styleid>0
				");
				while ($catrow=$vbulletin->db->fetch_array($asb)) {
					$vbulletin->db->query_write("
						INSERT INTO ".THIS_TABLE."linksadmin
						SET
							sequence='". $adminrow['sequence']."',
							settingname='".$adminrow['settingname']."',
							setting='".$vbulletin->db->escape_string($catrow['styleid'])."',
							rowtype='".$vbulletin->db->escape_string($adminrow['rowtype'])."',
							canoverride='".$adminrow['canoverride']."',
							catid='".$catrow['catid']."'
						");
				}
				$asb = $vbulletin->db->query_write("
					ALTER TABLE ".THIS_TABLE."linkscat
					DROP styleid
				");
			}
			unset($adminrow);
		}
		if ($columns["catsortorder"]) {
			$adminrow = $vbulletin->db->query_first("
				SELECT * FROM ".THIS_TABLE."linksadmin
				WHERE settingname='default_sort_order'
				AND catid='-1'
			");
			if (isset($adminrow['sequence'])) {
				$asb = $vbulletin->db->query_read("
					SELECT * FROM ".THIS_TABLE."linkscat
					WHERE catsortorder!=''
				");
				while ($catrow=$vbulletin->db->fetch_array($asb)) {
					$vbulletin->db->query_write("
						INSERT INTO ".THIS_TABLE."linksadmin
						SET
							sequence='". $adminrow['sequence']."',
							settingname='".$adminrow['settingname']."',
							setting='".$vbulletin->db->escape_string($catrow['catsortorder'])."',
							rowtype='".$vbulletin->db->escape_string($adminrow['rowtype'])."',
							canoverride='".$adminrow['canoverride']."',
							catid='".$catrow['catid']."'
					");
				}
				$asb = $vbulletin->db->query_write("
					ALTER TABLE ".THIS_TABLE."linkscat
					DROP catsortorder
				");
			}
			unset($adminrow);
		}
		if ($columns["catinstructions"]) {
			$adminrow = $vbulletin->db->query_first("
				SELECT * FROM ".THIS_TABLE."linksadmin
				WHERE settingname='use_instructions'
				AND catid='-1'
			");
			if (isset($adminrow['sequence'])) {
				$asb = $vbulletin->db->query_read("
					SELECT * FROM ".THIS_TABLE."linkscat
					WHERE catinstructions <> ''
				");
				while ($catrow=$vbulletin->db->fetch_array($asb)) {
					$vbulletin->db->query_write("
						INSERT INTO ".THIS_TABLE."linksadmin
						SET
							sequence='". $adminrow['sequence']."',
							settingname='".$adminrow['settingname']."',
							setting='".$vbulletin->db->escape_string($catrow['catinstructions'])."',
							rowtype='".$vbulletin->db->escape_string($adminrow['rowtype'])."',
							canoverride='".$adminrow['canoverride']."',
							catid='".$catrow['catid']."'
					");
				}
				$asb = $vbulletin->db->query_write("
					ALTER TABLE ".THIS_TABLE."linkscat
					DROP catinstructions
				");
			}
			unset($adminrow);
		}

// Fix at 2.3.0 to distinguish #comments and #ratings requires recalculating numrate and totrate columns in linkslink table
		if ($redo_ratings) {
			$asb = $vbulletin->db->query_read("
				SELECT linkid, linkuserid, linkvote
				FROM ".THIS_TABLE."linksrate
				WHERE linkvote>0
			");
			$rates = array();
// count only one vote per user
			while ($row = $vbulletin->db->fetch_array($asb)) {
				$rates[$row['linkid']][$row['linkuserid']] = $row['linkvote'];
			}
			$newrates = array();
			foreach ($rates as $thislinkid=>$theserates) {
				foreach ($theserates as $thisrate) {
					$newrates[$thislinkid]['numrate'] += 1;
					$newrates[$thislinkid]['totrate'] += $thisrate;
				}
			}
// count all the non-blank comments
			$asb = $vbulletin->db->query_read("
				SELECT linkid, COUNT(lcomment) AS numcomment
				FROM ".THIS_TABLE."linksrate
				WHERE lcomment!=''
				GROUP BY linkid
			");
			while ($row = $vbulletin->db->fetch_array($asb)) {
				$newrates[$row['linkid']]['numcomment'] = $row['numcomment'];
			}

			$asb = $vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink
				SET numcomment=0, numrate=0, totrate=0
			");

			foreach ($newrates as $thislinkid=>$thisrate) {
				$query = "
					UPDATE ".THIS_TABLE."linkslink
					SET numcomment=".intval($thisrate['numcomment']).", numrate=".intval($thisrate['numrate']).", totrate=".intval($thisrate['totrate'])."
					WHERE linkid=".$thislinkid."
				";
				$asb = $vbulletin->db->query_write($query);
			}
		}

	}

}

/**
* Delete unwanted templates
*
*/

function clean_LDM_templates() {
	global $vbulletin;

// Kill unwanted templates from very old (pre-product) versions
	$asb = $vbulletin->db->query_write("
		DELETE
		FROM ".TABLE_PREFIX."template
		WHERE title LIKE 'links_%'
		AND styleid>0
		AND product <> 'eirma_ldm'
		");

// Correct any mismatches between template versions and LDM product versions...
	if (THIS_VERSION<"3.0.0") {
		$vbulletin->db->query_write("
			UPDATE ".TABLE_PREFIX ."template
			SET version='2.2.5'
			WHERE product = 'eirma_ldm'
			AND version> '3.0.0'
		");
	}

}

/**
* Create/Remove vBulletin product to hold LDM extras
*
*/

function enable_LDM_extras_product($version, $enable) {
global $vbulletin;

    if ($enable) {

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "product
			WHERE productid = '". THIS_PRODUCT_EXTRA_NAME . "'
		");

		if ($vbulletin->db->num_rows($asb)) {
        	$vbulletin->db->query_write("
		        UPDATE " . TABLE_PREFIX . "product
        		SET version='" . $version . "'
    			WHERE productid = '". THIS_PRODUCT_EXTRA_NAME . "'
    		");
		}
		else {
        	$vbulletin->db->query_write("
		        INSERT INTO " . TABLE_PREFIX . "product
				SET
					productid='" . THIS_PRODUCT_EXTRA_NAME . "',
					title='Links and Downloads Manager Extras',
					description='Addons for LDM',
					version='" . $version . "',
					active='1',
					url='',
					versioncheckurl=''
			");
		}

    }
    else {

        $vbulletin->db->query_write("
		    DELETE
		    FROM " . TABLE_PREFIX . "product
    		WHERE productid = '". THIS_PRODUCT_EXTRA_NAME . "'
    	");
        $vbulletin->db->query_write("
		    DELETE
		    FROM " . TABLE_PREFIX . "plugin
    		WHERE product = '". THIS_PRODUCT_EXTRA_NAME . "'
    	");

    }

}

/**
* Record new version
*
*/

function record_LDM_version($version, $installed) {
	global $vbulletin;

	$asb = $vbulletin->db->query_read("SHOW TABLES");
	$hack_table_prefix = THIS_TABLE."links";
	$hack_tables = array();
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		foreach ($myrow AS $table) {
			if (preg_match ("/^$hack_table_prefix/", $table)) {
				$hack_tables[] = $table;
			}
		}
	}
	if (count($hack_tables) == 0) return (0); // something badly wrong
	unset ($hack_tables);

	$vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linksadmin
		SET setting='".$version."'
		WHERE settingname='this_version'
	");
	$vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linksadmin
		SET setting='".$installed."'
		WHERE settingname='version_installed'
	");
	return(1);

}

/**
* Remove tables completely
*
*/

function delete_LDMtables() {
	global $vbulletin;

// Kill LDM tables
	$queries = array(
		THIS_TABLE."linksadmin",
		THIS_TABLE."linksbitcache",
		THIS_TABLE."linkscat",
		THIS_TABLE."linksdebug",
		THIS_TABLE."linksdownloads",
		THIS_TABLE."linksentities",
		THIS_TABLE."linksfavs",
		THIS_TABLE."linkskeys",
		THIS_TABLE."linkslink",
		THIS_TABLE."linksltoc",
		THIS_TABLE."linksltok",
		THIS_TABLE."linksrate",
		THIS_TABLE."linkssearch",
		THIS_TABLE."linkstarred"
	);
	foreach ($queries as $query) {
		$asb = $vbulletin->db->query_write("DROP TABLE IF EXISTS ".$query);
	}

// Clean up the profile fields
	$texts = array();
	$texts[0] = $vbphrase['ldm_recent_hits'];
	if (!$texts[0]) $texts[0] = "My Recent LDM Hits";
	$texts[1] = $vbphrase['ldm_recent_entries'];
	if (!$texts[1]) $texts[1] = "My Recent LDM Entries";
	$profile = array();

// Take care - VB version specific - requires >=3.6
	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".TABLE_PREFIX."phrase
		WHERE fieldname = 'cprofilefield'
		AND varname LIKE 'field%_title'
		AND TEXT IN ('".implode("', '", $texts)."')
	");

	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$profilefieldid = preg_replace("/field(\d*)_title/", "$1", $myrow['varname']);
		$profile[$profilefieldid] = $myrow['text'];
	}

	$asb = $vbulletin->db->query_read("
		DELETE FROM ".TABLE_PREFIX."phrase
		WHERE fieldname = 'cprofilefield'
		AND varname LIKE 'field%'
		AND TEXT IN ('".implode("', '", $texts)."')
	");

// Take care - VB version specific

	foreach ($texts as $txt) {
		foreach ($profile as $kprofile=>$thisprofile) {
			if ($thisprofile==$txt) {
				$vbulletin->db->query_write("
					ALTER TABLE ".TABLE_PREFIX."userfield
					DROP field".$kprofile
					);
				$vbulletin->db->query_write("
					DELETE FROM ".TABLE_PREFIX."profilefield
					WHERE profilefieldid='".$kprofile."'
				");
				break;
			}
		}
	}

	$vbulletin->db->query_write("OPTIMIZE TABLE " . TABLE_PREFIX . "userfield");

// Clean up the vBulletin datastore
	$vbulletin->db->query_write("
		DELETE FROM " . TABLE_PREFIX . "datastore
		WHERE title IN(
			'ldm_admin',
			'ldm_cats'
		)"
	);

	vBulletinHook::build_datastore($vbulletin->db);

	return;

}

?>