<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

function ldm_parent_dir($pdir) {
	if (preg_match(":(.+)/[^/]*:", $pdir, $matches)) {
		return $matches[1];
	}
	else {
		return "/";
	}
}

/* ===========================================================================*/
// Directory scan
/* ===========================================================================*/

if ($this_action == "admin" and $adminset == "scan") {

	$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=admin&amp;set=categories";

	if (isset($_REQUEST['cancel'])) {
		eval(print_standard_redirect($vbphrase['ll_redirect'],0));
		exit;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'dir' => TYPE_STR,
		'state' => TYPE_INT,
		'start' => TYPE_INT,
		'scanfile' => TYPE_ARRAY_STR,
		'scanfileset' => TYPE_ARRAY_INT
	));

	$catid = $vbulletin->GPC['catid'];

	$catsyncdir = $linkscat[$catid]['catsyncdir'];
	$catsynctyp = ldm_lookup_setting($catid, 'sync_filetypes');
	$catsyncenb = ldm_lookup_setting($catid, 'sync_enabled');

	if ($linkscat[$catid]['catsynctime']) {
		$catsync_last = ldm_date($vbulletin->options['dateformat'], $linkscat[$catid]['catsynctime']).' '.ldm_date($vbulletin->options['timeformat'], $linkscat[$catid]['catsynctime']);
	}
	else {
		$catsync_last = $vbphrase['ll_never'];
	}

	$catsync_last = construct_phrase($vbphrase[ll_synctime_last], $catsync_last);
	$catclosed = $linkscat[$catid]['catclosed'];

	if ($vbulletin->GPC['dir']) {
		$monitor_dir = $vbulletin->GPC['dir'];
	}
	elseif ($catsyncdir) {
		$monitor_dir = $linkscat[$catid]['catsyncdir'];
	}
	else {
		$monitor_dir = '/';
	}

	$fulldir = ldm_cleanto_fopen($monitor_dir);

	$fail = 0;
	if ($monitor_dir{0}=='.') { // Block attempts to get outside the controlled zone
		$fail = 1;
	}
	else {
		if (!($dir_handle = @opendir($fulldir))) {
			$fail = 1;
		}
		else {
			closedir($dir_handle);
		}
	}

	if ($fail) {
		eval(standard_error($vbphrase['ll_error_openfail'].' '.$monitor_dir.' ('.$fulldir.')'.
			'<br /><br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$state = ($vbulletin->GPC['state'] ? $vbulletin->GPC['state'] : 0);

	$navbits = array();
	$navbits[LINKS_SCRIPT.".php".$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$this_navigation_title = $navbits[$ADMIN_SCRIPT.".php".$vbulletin->session->vars['sessionurl_q']] = $vbphrase['ll_links_administration'];
	$navbits[$url] = $vbphrase['ll_menu_admcats'];
	$navbits[""] = $vbphrase['ll_scansite'];
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	$adminscanbit = "";

	if (!isset($linkscat[$catid]['catid'])) {
		eval(standard_error(construct_phrase($vbphrase['ll_error_category'], $catid) .
			' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	$ignore = array();
	if ($file_handle = @fopen(ldm_make_filename($fulldir,"ignore.dat"), 'r')) {
		while (!feof ($file_handle)) {
			$line = trim(fgets($file_handle, 4096));
			if ($line != '') {
				$ignore[$line] = 1;
			}
		}
		fclose($file_handle);
	}

	require_once(DIR . '/includes/local_links_misc.php');

	switch ($state) {

	case 0: // First pass through - present user the list of what's available

		$d_list = array();
		$f_list = array();
		$skipped = array();

		$filetypes = array_keys($vbulletin->attachmentcache);
		ldm_read_directory($monitor_dir, $filetypes, $d_list, $f_list, $skipped);
		$d_list = array_keys($d_list);
		$f_list = array_keys($f_list);

		$def = preg_replace('/\s/','',$catsynctyp);
		$sel_filetypes = ($def ? array_intersect(explode(',', strtolower($def)), $filetypes) : $filetypes);

		$links = array();
		if (count($f_list)) {
			sort($f_list);
			$fl = $f_list;
			foreach ($fl as $k=>$flk) {
				$fl[$k] = ldm_make_filename($monitor_dir, $flk);
				$fl[$k] = str_replace("'", "\\'", $fl[$k]);
				$fl[$k] = "'".$fl[$k]."'";
			}
			$fl = implode(',', $fl);
			$query = "
				SELECT linkid, linkurl
				FROM ".THIS_TABLE."linkslink
				WHERE linkurl IN (".$fl.")
				";
			$asb = $vbulletin->db->query_read($query);
			while ($data = $vbulletin->db->fetch_array($asb)) {
				$links[$data["linkurl"]] = $data["linkid"];
			}
		}

		$dir_menu = array();

		$thisdirf = $monitor_dir;
		while (1) {
			$selected = ($thisdirf==$monitor_dir ? 'selected="selected"' : '');
			$dir_menu[] = '<option value="'.$thisdirf.'" '.$selected.'>'.htmlentities($thisdirf)."</option>\n";
			if (!$thisdirf or $thisdirf == '/') break;
			$thisdirf = ldm_parent_dir($thisdirf);
		}

		foreach ($d_list as $thisdir) {
			$thisdirf = ldm_make_filename($monitor_dir, $thisdir);
			$selected = '';
			$dir_menu[] = '<option value="'.$thisdirf.'" '.$selected.'>'.htmlentities($thisdirf)."</option>\n";
		}

		sort($dir_menu);
		$dir_menu = implode(' ', $dir_menu);

		eval("\$table = \"".fetch_template('links_admin_scan_start')."\";");
		$table_hid = $table_omt = $table_set = "";

		$settingseq = 0;
		foreach ($f_list as $file) {
			$this_one = ldm_make_filename($monitor_dir, $file);
			$setting = $file;
			$settingvalue = preg_replace(':":', '\\"', ldm_make_filename($monitor_dir, $file)); // nb not addslashes()
			$check_hid = $check_set = $check_omi = $setstyle = $explain = '';
			if (isset($ignore[$file])) {
				$check_hid = 'checked="checked"';
				$text = $vbphrase['ll_scan_ignore'];
				eval("\$table_hid .= \"".fetch_template('links_admin_scan_one')."\";");
			}
			elseif (isset($links[$this_one])) {
				$check_omi = 'checked="checked"';
				$text = $vbphrase['ll_scan_old'];
				$setstyle = "alt2";
				eval("\$table_omi .= \"".fetch_template('links_admin_scan_one')."\";");
			}
			else {
				$type = strtolower(file_extension($file));
				if (!$catsyncdir or in_array($type, $sel_filetypes)) {
					$check_set = 'checked="checked"';
				}
				else {
					$check_omi = 'checked="checked"';
				}
				$text = "";
				eval("\$table_set .= \"".fetch_template('links_admin_scan_one')."\";");
			}
			$settingseq += 1;
		}

		$table = $table.$table_set.$table_omi.$table_hid;

		$hidden_setting = "";
		$state = 1;
		$endmessage = "";
		foreach ($skipped as $type=>$numf) {
			$endmessage .= $type.' ['.$numf.'] ';
		}
		if ($endmessage) {
			$endmessage = $vbphrase['ll_scan_ignmime'].$endmessage;
		}
		eval("\$table .= \"".fetch_template('links_admin_scan_end')."\";");
		$adminscanbit .= $table;
		break;

	case 1: // User has already selected, so start processing

		require_once(DIR . '/includes/functions_misc.php');
		$start_time = microtime();
		$max_time = ini_get('max_execution_time');
		$PERCYCLE = (!$max_time ? 10 : min($max_time*0.8, 20)); // seconds cpu time per pass (cost is in creating possible thumbnails)

		$start = ($vbulletin->GPC_exists['start'] ? $vbulletin->GPC['start'] : 1);

		$files =& $vbulletin->GPC['scanfile'];
		$fileset =& $vbulletin->GPC['scanfileset'];

		$element = 0;
		$process = 1;
		$nproc   = 0;

		eval("\$table = \"".fetch_template('links_admin_scan_start')."\";");

		$auto_forumid = $links_defaults['autocreate_forum']>0 ? $links_defaults['autocreate_forum'] : $links_defaults['default_forumid'];
		$auto_username = $links_defaults['autocreate_username'] ? $links_defaults['autocreate_username'] :
			$links_defaults['sync_username'] ? $links_defaults['sync_username'] : $vbulletin->userinfo['username'];
		$auto_userid = $links_defaults['autocreate_userid']>0 ? $links_defaults['autocreate_userid'] :
			$links_defaults['sync_userid']>0 ? $links_defaults['sync_userid'] : $vbulletin->userinfo['userid'];

		$linkdesctemplate = $links_defaults['monitor_template'];
		foreach ($files as $element=>$linkurl) {

			$this_setting = $fileset[$element];

			switch ($process) {

			case 1: // not yet started inserting, perhaps already done so last time round
				if ($element<$start) {
					$hidden_setting = '
						<input type="hidden" name="scanfile['.$element.'] value="'.$linkurl.']" />
						<input type="hidden" name="scanfileset['.$element.'] value="'.$this_setting.'" />
						';
					$setting = construct_phrase($vbphrase['ll_scan_status_processed'],$linkurl);
					eval("\$table .= \"".fetch_template('links_admin_scan_line')."\";");
					break;
				}
				$process = 2;

			case 2: // now we're inserting
				$linkurl = stripslashes($linkurl);
				$hidden_setting = '
					<input type="hidden" name="scanfile['.$element.'] value="'.$linkurl.']" />
					<input type="hidden" name="scanfileset['.$element.'] value="'.$this_setting.'" />
					';
				switch ($this_setting) {
				case -1:
					$setting = construct_phrase($vbphrase['ll_scan_status_ignored'],$linkurl);
					eval("\$table .= \"".fetch_template('links_admin_scan_line')."\";");
					break;

				case 0:
					$setting = construct_phrase($vbphrase['ll_scan_status_omitted'],$linkurl);
					eval("\$table .= \"".fetch_template('links_admin_scan_line')."\";");
					break;

				case 1:
					$statuscheck = $LINK_OK;
					$filesize = ldm_get_sizeof_url($linkurl);
					$file = array();
					ldm_get_file_info($linkurl, $file, $linkdesctemplate);
					$linkuser = $vbulletin->userinfo['username'];
					$linkuserid = $vbulletin->userinfo['userid'];
					$linkdesc	= $file['linkdesc'];
					$linkname	= $file['linkname'];
					$linkimg	= $file['linkimg'];
					$linkimgthumb	= $file['imgthumb'];
					$linkimgthumbsize = $file['imgthumbsize'];
					$linkdate	= TIMENOW;
					$linkfile = '';
					$linkdoi = '';
					$linkreviewfreq = 0;
					$linkdups = 1;
					$pforum = $links_defaults['default_forumid'];
					$imgstatuscheck = 0;
					$moderate = $LINK_ACCEPTED;

					$linkkeywords = array();
					$linknewkeywords = "";
					$linkentities = array();

					($hook = vBulletinHook::fetch_hook('ldm_addlink_preinsert')) ? eval($hook) : false;

        			require_once(DIR . '/includes/local_links_misc.php');
					$ldm_entry = ldm_entry_template(
						array(
							'linkname' => $linkname,
							'linkdesc' => $linkdesc,
							'linkdoi' => $linkdoi,
							'linkurl' => $linkurl,
							'linkfile' => $linkfile,
							'linkimg' => $linkimg,
							'linkimgthumb' => $linkimgthumb,
							'linkimgthumbsize' => $linkimgthumbsize,
							'linkforum' => $pforum,
							'linksize' => $filesize,
							'linkstatus' => $statuscheck,
							'linkimgstatus' => $imgstatuscheck,
							'linkdate' => $linkdate,
							'linkusername' => $linkuser,
							'linkuserid' => $linkuserid,
							'linkmoderate' => $moderate,
							'linkreviewfreq' => $linkreviewfreq,
							)
						);

					list ($insert_status, $linkid) = ldm_create_entry($ldm_entry, $linkdups);

					if ($linkid) {
						ldm_insert_entry_in_category($linkid, array($catid));
					}

					if (count($linkkeywords)) {
						ldm_associate_keywords($linkid, $linkkeywords, 0);
					}
					if ($linknewkeywords) {
						ldm_associate_keywords($linkid, ldm_lookup_keywords(ldm_explode_keywords($linknewkeywords)), 1);
					}
					if (count($linkentities)) {
						require_once(DIR . '/includes/local_links_entities.php');
						ldm_associate_entities($linkid, $linkentities, $linkentityfiles, $message);
					}

// Be very careful about enabling this - it may run riot with your forums....
					if ($links_defaults['autocreate_active'] and
						$links_defaults['autocreate_active_sync'] and
						$auto_forumid>0) {

						require_once(DIR . '/includes/local_links_forumsinterface.php');

                		$auto_prefix = ldm_lookup_setting($catid, 'autocreate_prefix');

                        if ($auto_prefix) {
            				require_once(DIR . '/includes/local_links_forumsinterface.php');
                            if (!ldm_validate_threadprefix($auto_prefix, $catid, $auto_forumid)) {
                                $auto_prefix = "";
                            }
                        }

						$viewcatid = $catid;
						list($error, $message) = ldm_announce_in_forum(
							$auto_forumid,
							$links_defaults['autocreate_both_ways'],
							$linkid,
							$catid,
							$linkname,
							$linkdesc,
							(in_array(strtolower(file_extension($linkimg)), array("jpg", "gif", "png")) ? $linkimg : ""),
							$auto_prefix,
							$auto_username,
							$auto_userid
							);
					}

					($hook = vBulletinHook::fetch_hook('ldm_sync_link_inserted')) ? eval($hook) : false;

					$setting = construct_phrase($vbphrase['ll_scan_status_inserted'],$linkurl, $linkid);
					eval("\$table .= \"".fetch_template('links_admin_scan_line')."\";");

					if (fetch_microtime_difference($start_time)>$PERCYCLE) {
						$process = 3;
						$start = $element+1;
					}
					break;

				}
				break;

			case 3: // processed all we can manage in this cycle
				$setting = $linkurl;
				$settingvalue = $linkurl;
				$settingseq = $element;
				$check_hid = $check_set = $check_omi = '';
				switch ($this_setting) {
				case -1:
					$check_hid = 'checked="checked"';
					break;
				case 0:
					$check_omi = 'checked="checked"';
					break;
				case 1:
					$check_set = 'checked="checked"';
				}
				eval("\$table .= \"".fetch_template('links_admin_scan_one')."\";");
				break;

			}

		}

// scan complete, what state did we leave it in?
		switch ($process) {

		case 1:
		case 2: // complete, so deal with the 'ignore.dat' file
			$state = 2;
			foreach ($files as $element=>$linkurl) {
				$this_setting = $fileset[$element];
				if (isset($ignore[$linkurl])) {
					if ($this_setting>=0) {
						unset($ignore[$linkurl]);
					}
				}
				elseif ($this_setting<0) {
					$ignore[$linkurl] = 1;
				}
			}
			if ($file_handle = @fopen(ldm_make_filename($fulldir,"ignore.dat"), 'w')) {
				foreach ($ignore as $key=>$this_ignore) {
					if (preg_match(":/([^/]*)$:", trim($key), $matches)) {
						fwrite($file_handle, $matches[1]."\r\n");
					}
				}
				fclose ($file_handle);
			}

			$hidden_setting = "";
			break;

		case 3: // at least one more pass required
			break;

		}

		eval("\$table .= \"".fetch_template('links_admin_scan_end')."\";");
		$adminscanbit .= $table;

	}

}

?>