<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

if (!$links_permissions['is_vbsuperadmin']) {
	print_no_permission();
	exit;
}

function ldm_fetchplugins() {
	global $vbulletin;
	global $ldm_extras_loaded;

	$ldm_plugins = array();

	$asb = $vbulletin->db->query_read("
		SELECT pluginid, title, hookname, product, active
		FROM " . TABLE_PREFIX . "plugin
		WHERE product = '".THIS_PRODUCT_NAME."'
		OR product = '".THIS_PRODUCT_EXTRA_NAME."'
		ORDER BY product ASC, title ASC, hookname ASC
	");

	while ($row=$vbulletin->db->fetch_array($asb)) {
		$ldm_plugins[$row['title']][$row['hookname']] = $row;
	}

    foreach ($ldm_plugins as $thistitle=>$thisplugin) {
        $version = "";
        foreach ($ldm_extras_loaded as $thisloaded) {
            if ($thisloaded["fullname"]==$thistitle) {
                $version = $thisloaded["version"];
                break;
            }
        }
        foreach ($thisplugin as $thishookname=>$thishook) {
            $ldm_plugins[$thistitle][$thishookname]["pluginversion"] = $version;
        }
    }

	$asb = $vbulletin->db->query_read("
		SELECT productid, version, active
		FROM " . TABLE_PREFIX . "product
		WHERE productid = '".THIS_PRODUCT_NAME."'
		OR productid = '".THIS_PRODUCT_EXTRA_NAME."'
	");

	while ($row=$vbulletin->db->fetch_array($asb)) {
	    $product = $row['productid'];
	    $productactive = $row['active'];
	    $productversion = $row['version'];

        foreach ($ldm_plugins as $thistitle=>$thisplugin) {
            foreach ($thisplugin as $thishookname=>$thishook) {
                if ($ldm_plugins[$thistitle][$thishookname]['product']==$product) {
                    $ldm_plugins[$thistitle][$thishookname]["productactive"] = $productactive;
                    $ldm_plugins[$thistitle][$thishookname]["productversion"] = $productversion;
                }
            }
        }

	}

    if ($xml = @file_get_contents(DIR . '/includes/xml/ldm_extras.xml')) {

    	require_once(DIR . '/includes/adminfunctions.php');
	    require_once(DIR . '/includes/class_xml.php');

    	$xmlobj = new vB_XML_Parser($xml);
    	if ($xmlobj->error_no == 1 or $xmlobj->error_no == 2) {
	    	$err = construct_phrase($vbphrase['ll_error_importxml_createparser'],$vbulletin->GPC['xmlimport']['name']);
		    eval(standard_error($err));
		    exit;
	    }

    	if (!$arr =& $xmlobj->parse()) {
            $errcode = $xmlobj->error_code;
		    $err = construct_phrase($vbphrase['ll_error_importxml_doparser'], $xmlobj->error_line(), $vbulletin->GPC['xmlimport']['name'], $errcode, xml_error_string($errcode));
    		eval(standard_error($err));
	    	exit;
	    }

        if (is_array($arr['extra'])) {
            foreach ($arr['extra'] as $thisextra) {
                $thistitle = $thisextra['title'];
                if (isset($ldm_plugins[$thistitle])) {
                    foreach ($ldm_plugins[$thistitle] as $thishookname=>$thishook) {
                        $ldm_plugins[$thistitle][$thishookname]["releaseversion"] = $thisextra['version'];
                    }
                }
            }
        }
    }

	return $ldm_plugins;
}

/* ===========================================================================*/
// List plugins
/* ===========================================================================*/

if ($adminset == "plugins") {

	$navbits[""] = $vbphrase['ll_admin_plugins'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$vbulletin->url = $debugscript = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=plugins";

	$ldm_plugins = ldm_fetchplugins();
	$plugininfo = "";
	$productname = "";

	foreach ($ldm_plugins as $thisname=>$thesehooks) {
		$plugins = "";
		$thisproductactive = 0;
		$thisreleaseversion = 0;
		$theseids = array();

		foreach ($thesehooks as $thishook=>$thisstruct) {
			$thisactive = $thisstruct['active'];
			$thisproductactive = $thisstruct['productactive'];
			$thisreleaseversion = $thisstruct['releaseversion'];
			$thispluginversion = $thisstruct['pluginversion'];
			$theseids[] = $thisstruct['pluginid'];
            if ($thisstruct['product'] == THIS_PRODUCT_NAME) {
        		$thisproductname = "LDM Core";
            }
            elseif ($thisstruct['product'] == THIS_PRODUCT_EXTRA_NAME) {
        		$thisproductname = "LDM Extras";
            }
            else {
        		$thisproductname = "Unknown";
            }
		}

        $whichhooks = array_keys($thesehooks);
        sort($whichhooks);
        $whichhooks = implode(', ', $whichhooks);
        $whichids = implode(',', $theseids);

        if ($productname != $thisproductname) {
            $plugininfo .=
			'<tr>'."\n".
			'<td class="thead" colspan="2">'."\n".
			'<span class="smallfont"><strong>'."\n".
			($thisproductactive ? '' : '<strike>').$thisproductname.($thisproductactive ? '' : '</strike>')."\n".
			'</strong></span>'."\n".
			'</td>'."\n".
			'<td class="thead" align="center">&nbsp;</td>'."\n".
			'<td class="thead" align="center">&nbsp;</td>'."\n".
			'</tr>'."\n";
            $productname = $thisproductname;
        }

		$plugingroup =
			'<tr>'."\n".
			'<td class="alt2" colspan="2">'."\n".
			(($thispluginversion and $thisreleaseversion and $thispluginversion != $thisreleaseversion)
			    ? ' <div class="highlight smallfont" style="float:right;">[Warning: Current Extra Version = ' .$thisreleaseversion. ']</div>'
			    : ''
			    )."\n".
			'<span class="smallfont"><strong>'."\n".
			($thisactive ? '' : '<strike>').$thisname.($thisactive ? '' : '</strike>')."\n".
			($thispluginversion ? ' version # ' . $thispluginversion : '')."\n".
			'</strong></span>'."\n".
			'</td>'."\n".
			'<td class="alt2" align="center">'."\n".
			'<span class="smallfont">'."\n".
			'<input type="radio" name="ldmactiveplugins['.$thisname.']" value="1" '. ($thisactive ? 'checked="checked"' : ''). ' /> ' . $vbphrase['ll_yes'] ."\n".
			'<input type="radio" name="ldmactiveplugins['.$thisname.']" value="0" '. ($thisactive ? '' : 'checked="checked"'). ' /> ' . $vbphrase['ll_no'] ."\n".
			'</span>'."\n".
			'</td>'."\n".
			'<td class="alt2" align="center">'."\n".
            ($thisproductname == "LDM Extras"
    			? '<input type="checkbox" name="ldmdeleteplugins['.$thisname.']" value="1" '. ' /> ' ."\n"
    			: '') .
            '</td>'."\n".
			'</tr>'."\n";

		$plugininfo .= $plugingroup .
			'<tr>'."\n".
			'<td class="alt1">&nbsp;</td>'."\n".
			'<td class="alt1"><span class="smallfont">'.$whichhooks.'</span></td>'."\n".
    		'<td class="alt1">&nbsp;</td>'."\n".
			'<td class="alt1">&nbsp;</td>'."\n".
			'</tr>'."\n";

	}

}

/* ===========================================================================*/
// Plugins action
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST['doplugins'])) {

	$vbulletin->input->clean_array_gpc('r', array(
		'ldmactiveplugins' => TYPE_ARRAY_STR,
		'ldmdeleteplugins' => TYPE_ARRAY_STR,
	));

    $ldm_activeplugins =& $vbulletin->GPC['ldmactiveplugins'];
	foreach ($ldm_activeplugins as $thisname=>$thisactive) {
		$query = "
			UPDATE ".TABLE_PREFIX."plugin
			SET
				active=".intval($thisactive)."
			WHERE title='". $vbulletin->db->escape_string($thisname) ."'
    	    AND (product = '".THIS_PRODUCT_NAME."'
        		OR product = '".THIS_PRODUCT_EXTRA_NAME."')
			";
		$vbulletin->db->query_write($query);
	}

    $ldm_deleteplugins =& $vbulletin->GPC['ldmdeleteplugins'];
	foreach ($ldm_deleteplugins as $thisname=>$thisdelete) {
	    if ($thisdelete==1) {
    		$query = "
	    		DELETE FROM ".TABLE_PREFIX."plugin
    			WHERE title='". $vbulletin->db->escape_string($thisname) ."'
        	    AND (product = '".THIS_PRODUCT_EXTRA_NAME."')
			";
		    $vbulletin->db->query_write($query);
        }
	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	vBulletinHook::build_datastore($vbulletin->db);

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=plugins";
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

}

?>