<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// Analyse setting/permission over-rides
/* ===========================================================================*/

if ($adminset == "overrides") {

	$navbits[""] = $vbphrase['ll_desc_admorvd'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$setting_overridebits = "";
	$permission_overridebits = "";

	foreach ($ldm_master_settings as $settingname=>$settings) {

	    if (count($settings)<=1) {
	        continue;
	    }

        if ($settings[$BASE_CAT]['sequence']>=ADMIN_SETTINGS_START and $settings[$BASE_CAT]['sequence']<=ADMIN_SETTINGS_END) {

            $setting_overridebits .= '
<tr>
    <td class="alt1" colspan="2">
    <span class="smallfont">
    <strong>'.$settingname.'</strong><br />'.$vbphrase['ll_perms_'.$settingname].'
    </span>
    </td>
    <td class="alt1">
    <span class="smallfont">'.($settings[$BASE_CAT]['setting'] ? $settings[$BASE_CAT]['setting'] : $vbphrase['ll_unset']).'</span>
    </td>
    <td class="alt1">
	&nbsp;
    </td>
</tr>
            ';
            foreach ($settings as $thiscatid=>$thissetting) {
                if ($thiscatid>0) {
                    $setting_overridebits .= '
<tr>
    <td class="alt2" width="10%">
    &nbsp;
    </td>
    <td class="alt2" width="50%">
    <span class="smallfont">'.$linkscat[$thiscatid]['catname'].'</span>
    </td>
    <td class="alt2">
    <span class="smallfont">'.$thissetting['setting'].'</span>
    </td>
    <td class="alt2" width="10%" align="center">
	<input type="checkbox" name="'.$settingname.'['.$thiscatid.'] value="1" />
    </td>
</tr>
                    ';
                }
            }

        }

        if ($settings[$BASE_CAT]['sequence']>=ADMIN_PERMISSIONS_START and $settings[$BASE_CAT]['sequence']<=ADMIN_PERMISSIONS_END) {

            $permission_overridebits .= '
<tr>
    <td class="alt1" colspan="2">
    <span class="smallfont">
    <strong>'.$settingname.'</strong><br />'.$vbphrase['ll_perms_'.$settingname].'
    </span>
    </td>
    <td class="alt1">
    <span class="smallfont">'.($settings[$BASE_CAT]['setting'] ? $settings[$BASE_CAT]['setting'] : $vbphrase['ll_unset']).'</span>
    </td>
    <td class="alt1">
	&nbsp;
    </td>
</tr>
            ';
            foreach ($settings as $thiscatid=>$thissetting) {
                if ($thiscatid>0) {
                    $permission_overridebits .= '
<tr>
    <td class="alt2" width="10%">
    &nbsp;
    </td>
    <td class="alt2" width="50%">
    <span class="smallfont">'.$linkscat[$thiscatid]['catname'].'</span>
    </td>
    <td class="alt2">
    <span class="smallfont">'.$thissetting['setting'].'</span>
    </td>
    <td class="alt2" width="10%" align="center">
	<input type="checkbox" name="'.$settingname.'['.$thiscatid.'] value="1" />
    </td>
</tr>
                    ';
                }
            }

		}
	}

}

/* ===========================================================================*/
// Follow-up action
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST["dooverrides"])) {

	foreach ($ldm_master_settings as $settingname=>$settings) {

	    if (isset($_REQUEST[$settingname]) and is_array($_REQUEST[$settingname])) {
	        foreach (array_keys($_REQUEST[$settingname]) as $catid) {
                if (!ldm_catid_is_valid($catid)) {
                    continue;
                }
        		$query = "
	        		DELETE FROM ".THIS_TABLE."linksadmin
		        	WHERE settingname='" . $vbulletin->db->escape_string($settingname) . "'
		        	AND catid='" . $vbulletin->db->escape_string($catid) . "'
			        ";
    		    $vbulletin->db->query_write($query);
    		}
	    }

    }

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();
	ldm_datastore_markdirty('ldm_admin');
	ldm_datastore_markdirty('ldm_cats');

	$url  = ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl'].
	    "action=admin&amp;set=overrides".

	eval(print_standard_redirect($vbphrase['ll_deleted'],0));
    exit;

}

?>