<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// Analyse starred entry nominations
/* ===========================================================================*/

if ($adminset == "nominations") {

	function ldm_sorttimeslot($a, $b) {
		global $periodstars, $timeslot;
		$ac = $periodstars[$timeslot][$a]['entry']['nominations'];
		$bc = $periodstars[$timeslot][$b]['entry']['nominations'];
		if ($ac<$bc) {
			return 1;
		}
		elseif ($ac==$bc) {
			return 0;
		}
		else {
			return -1;
		}
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'period' => TYPE_INT,
		'entry' => TYPE_INT,
	));

	$timeslot = $vbulletin->GPC['period'];
	$entry = $vbulletin->GPC['entry'];

	$navbits[""] = $vbphrase['ll_menu_admnoms'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	require_once(DIR . '/includes/local_links_misc.php');

// Recalculate the results (not actually necessray, but a good way to force the recalculation)
	ldm_recalc_nominations();

// Work out the time slots
	$periodstart = ldm_nomination_timeslots();
	for ($thatperiod=1; $thatperiod<=$links_defaults['starred_entries_pastperiods']; $thatperiod++) {
		$period[$thatperiod]['start'] = ldm_date($vbulletin->options['dateformat'], $periodstart[$thatperiod]);
		$period[$thatperiod]['end'] = ldm_date($vbulletin->options['dateformat'], $periodstart[$thatperiod-1]);
	}

	$periodstars = array();
	$periodhits = array();
	for ($thatperiod=1; $thatperiod<=$links_defaults['starred_entries_pastperiods']; $thatperiod++) {
		$periodstars[$thatperiod] = array();
		$periodhits[$thatperiod] = 0;
	}

// Always gather the counts per period for all periods
	$query = "
		SELECT
			linkid, usertime, userid
		FROM " . THIS_TABLE . "linkstarred
		WHERE usertime<=".TIMENOW."
		AND usertime>".$periodstart[$links_defaults['starred_entries_pastperiods']+1]."
		ORDER BY userid ASC, usertime ASC
		";

	$lastuserid = -1;
	$lastperiod = -1;

	$asb = $vbulletin->db->query_read($query);
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		for ($thatperiod=1; $thatperiod<=$links_defaults['starred_entries_pastperiods']; $thatperiod++) {
			if ($myrow['usertime']>$periodstart[$thatperiod] and $myrow['usertime']<=$periodstart[$thatperiod-1]) {
				if ($lastuserid!=$myrow['userid'] or $lastperiod!=$thatperiod) {
					$periodhits[$thatperiod] += 1;
				}
				$lastuserid = $myrow['userid'];
				$lastperiod = $thatperiod;
				continue 2;
			}
		}
	}

// Drill down into the selected period if requested
	if ($timeslot and isset($periodstart[$timeslot])) {

// Note that we analyse the current period as well those which are complete.  Results presented
// via the general user interface keeps the current period's voting secret until it's over
		$query = "
			SELECT
					star.starid AS starid, star.linkid AS linkid, star.userid AS userid, star.usertime AS usertime,
					user.username AS username,
					links.linkname AS linkname,
					ltoc.catid AS catid
			FROM " . THIS_TABLE . "linkstarred AS star
			LEFT JOIN " . THIS_TABLE . "linkslink AS links
			ON star.linkid=links.linkid
			LEFT JOIN " . THIS_TABLE . "linksltoc AS ltoc
			ON star.linkid=ltoc.linkid
			LEFT JOIN " . TABLE_PREFIX ."user AS user
			ON star.userid=user.userid
			WHERE star.usertime>".$periodstart[$timeslot]."
			AND star.usertime<=".$periodstart[$timeslot-1]."
			ORDER BY star.usertime DESC
			";
		$asb = $vbulletin->db->query_read($query);

// Gather the detailed counts for this period
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
// Only accept the last nomination (first read from the DB) from a user in a given period
			if (!isset($periodstars[$timeslot][$myrow['linkid']]['nominations'][$myrow['userid']])) {
				$periodstars[$timeslot][$myrow['linkid']]['nominations'][$myrow['userid']] = array(
					'starid'=>$myrow['starid'],
					'userid'=>$myrow['userid'],
					'username'=>$myrow['username'],
					'usertime'=>$myrow['usertime'],
					);
				$periodstars[$timeslot][$myrow['linkid']]['entry'] = array(
					'linkid'=>$myrow['linkid'],
					'linkname'=>$myrow['linkname'],
					'catid'=>$myrow['catid'],
					);
			}
		}
		$vbulletin->db->free_result($asb);

		foreach ($periodstars[$timeslot] as $thisid=>$thesenoms) {
			$periodstars[$timeslot][$thisid]['entry']['nominations'] = count($thesenoms['nominations']);
		}

		uksort($periodstars[$timeslot], 'ldm_sorttimeslot');

	}

// Present the results
	$state = 0;
	eval("\$nominatebits = \"".fetch_template('links_admin_onenominate')."\";");

	for ($thatperiod=1; $thatperiod<=$links_defaults['starred_entries_pastperiods']; $thatperiod++) {
		$state = 1;
		eval("\$nominatebits .= \"".fetch_template('links_admin_onenominate')."\";");
		foreach ($periodstars[$thatperiod] as $thesenoms) {
			$state = 2;
			eval("\$nominatebits .= \"".fetch_template('links_admin_onenominate')."\";");

// Drilldown into one entry if requested
			if ($entry and $entry==$thesenoms['entry']['linkid']) {
				foreach ($thesenoms['nominations'] as $thisnom) {
					$datetime = ldm_date($vbulletin->options['dateformat'], $thisnom['usertime']).' '.ldm_date($vbulletin->options['timeformat'], $thisnom['usertime']);
					$state = 3;
					eval("\$nominatebits .= \"".fetch_template('links_admin_onenominate')."\";");
				}
			}

		}
	}

	$state = 4;
	eval("\$nominatebits .= \"".fetch_template('links_admin_onenominate')."\";");

}

?>