<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// Manage download mirrors
/* ===========================================================================*/

if ($this_action == "admin" and $adminset == "mirrors") {

	$navbits[""] = $vbphrase['ll_menu_admmirr'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$mirrorbits = "";
	$mirrorusagebits = "";
	$ldm_mirrors = unserialize($links_defaults['download_mirrors']);

	$mirror_seq = 0;
	foreach ($ldm_mirrors as $thismirror) {
		$mirror_name = $thismirror['name'];
		$mirror_find = $thismirror['find'];
		$mirror_repl = $thismirror['replace'];
		$mirror_prior = ($thismirror['priority'] ? $thismirror['priority'] : 100 );
		$mirror_active = isset($thismirror['active']) ? $thismirror['active'] : 1;
		eval('$mirrorbits .= "' . fetch_template('links_admin_onemirror') . '";');
		$mirror_seq++;
	}

	$mirror_name = "";
	$mirror_find = $vbulletin->options['homeurl'];
	$mirror_repl = "";
	$mirror_prior = 100;
	$mirror_active = 0;
	for ($i = 1; $i <= 3; $i++) {
		eval('$mirrorbits .= "' . fetch_template('links_admin_onemirror') . '";');
		$mirror_seq++;
	}

    $day_1  = TIMENOW -    24*60*60;
    $day_7  = TIMENOW -  7*24*60*60;
    $day_30 = TIMENOW - 30*24*60*60;

    foreach ($ldm_mirrors as $k=>$thismirror) {
        $ldm_mirrors[$k]['hits1'] = 0;
        $ldm_mirrors[$k]['hits7'] = 0;
        $ldm_mirrors[$k]['hits30'] = 0;
        $ldm_mirrors[$k]['bytes1'] = 0;
        $ldm_mirrors[$k]['bytes7'] = 0;
        $ldm_mirrors[$k]['bytes30'] = 0;
    }

	$query  = "
		SELECT linkurl, userip, usertime, bytes
		FROM " . THIS_TABLE . "linksdownloads
		WHERE usertime>=" . $day_30;
	$asb = $vbulletin->db->query_read($query);

	while ($myrow=$vbulletin->db->fetch_array($asb)) {
        foreach ($ldm_mirrors as $k=>$thismirror) {
        	if (preg_match('#^'.$ldm_mirrors[$k]['replace'].'#i', $myrow['linkurl'])) {
                $ldm_mirrors[$k]['hits30'] ++;
                $ldm_mirrors[$k]['bytes30'] += $myrow['bytes'];
                if ($myrow['usertime']>=$day_7) {
                    $ldm_mirrors[$k]['hits7'] ++;
                    $ldm_mirrors[$k]['bytes7'] += $myrow['bytes'];
                }
                if ($myrow['usertime']>=$day_1) {
                    $ldm_mirrors[$k]['hits1'] ++;
                    $ldm_mirrors[$k]['bytes1'] += $myrow['bytes'];
                }
            }
        }
    }

    foreach ($ldm_mirrors as $k=>$thismirror) {
        $ldm_mirrors[$k]['bytes1']  = ldm_encode_bytes($ldm_mirrors[$k]['bytes1']);
        $ldm_mirrors[$k]['bytes7']  = ldm_encode_bytes($ldm_mirrors[$k]['bytes7']);
        $ldm_mirrors[$k]['bytes30'] = ldm_encode_bytes($ldm_mirrors[$k]['bytes30']);
		eval('$mirrorusagebits .= "' . fetch_template('links_admin_onemirror_usage') . '";');
    }

	($hook = vBulletinHook::fetch_hook('ldm_admin_mirrors')) ? eval($hook) : false;

}


/* ===========================================================================*/
// Follow-up action: Do Mirrors
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST["domirrors"])) {

	$url  = ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=admin&amp;set=mirrors";

	$vbulletin->input->clean_array_gpc('r', array(
		'mname' => TYPE_ARRAY_STR,
		'mfind' => TYPE_ARRAY_STR,
		'mrepl' => TYPE_ARRAY_STR,
		'mprior' => TYPE_ARRAY_INT,
		'mdelete' => TYPE_ARRAY_INT,
		'mactive' => TYPE_ARRAY_INT,
	));

	$m_find = $vbulletin->GPC['mfind'];
	$m_repl = $vbulletin->GPC['mrepl'];
	$m_prior = $vbulletin->GPC['mprior'];
	$m_name = preg_replace(array("/[^ \w.,;:?!@#$%*()'+-=]/", "/ /"), array("", "_"), $vbulletin->GPC['mname']);
	$m_delete = $vbulletin->GPC['mdelete'];
	$m_active = $vbulletin->GPC['mactive'];

	$ldm_new_mirrors = array();
	foreach ($m_name as $k=>$kname) {

		if (!trim($kname) or !trim($m_find[$k]) or isset($m_delete[$k])) {
			continue;
		}

		$ldm_new_mirrors[] = array(
			"name" =>	$kname,
			"find" =>	trim($m_find[$k]),
			"replace"=>	trim($m_repl[$k]),
			"priority"=> $m_prior[$k],
			"active"=>	isset($m_active[$k]) ? $m_active[$k] : 0,
			);

	}

	$query = "
		UPDATE ".THIS_TABLE."linksadmin
		SET
			setting='".$vbulletin->db->escape_string(serialize($ldm_new_mirrors))."'
		WHERE settingname='download_mirrors'
		";
	$vbulletin->db->query_write($query);

	ldm_datastore_markdirty('ldm_admin');

	eval(print_standard_redirect($vbphrase['ll_accepted'],0));
	exit;

}

?>