<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/**
* Interface to geolocation code, if installed
*
* @param	str		IP address
* @return   str     Country code, if available, else blank
*/

function ldm_ip_locate($ip) {
    global $links_defaults;
    static $ips;

    if (isset($ips[$ip])) {
        return $ips[$ip];
    }

    if (!$links_defaults['geoip_active']) {
        return "";
    }

    @include_once(LDM_GEOIP_PHP);
    if (!defined("GEOIP_COUNTRY_BEGIN")) {
        return "";
    }

    $ldm_gi = @geoip_open(LDM_GEOIP_DB, GEOIP_STANDARD);
    $gcode = @geoip_country_code_by_addr($ldm_gi, $ip);
    @geoip_close($ldm_gi);

    if (!is_array($ips)) {
        $ips = array();
    }
    $ips[$ip] = $gcode;

    if (!$gcode) {
        return "";
    }

    return $gcode;

}

/* ===========================================================================*/
// Analyse hit activity
/* ===========================================================================*/

if ($this_action == "admin" and $adminset == "logjumps") {

	$vbulletin->input->clean_array_gpc('r', array(
		'archive' => TYPE_INT,
		'delete' => TYPE_INT,
		'end' => TYPE_STR,
		'endint' => TYPE_INT,
		'expand' => TYPE_INT,
		'hitsperpage' => TYPE_INT,
		'hostname' => TYPE_STR,
		'linkid' => TYPE_INT,
		'page2' => TYPE_INT,
		'prune_downloadtable' => TYPE_INT,
		'showdates' => TYPE_INT,
		'sortby' => TYPE_STR,
		'sortdir' => TYPE_STR,
		'start' => TYPE_STR,
		'startint' => TYPE_INT,
		'userid' => TYPE_INT,
		'userip' => TYPE_STR,
	));

	construct_forum_jump();
	$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=logjumps";

	require_once(DIR . '/includes/functions_misc.php');

	if ($vbulletin->GPC_exists['prune_downloadtable'] and $vbulletin->GPC['prune_downloadtable']>=0) {
		$links_defaults['prune_downloadtable'] = $vbulletin->GPC['prune_downloadtable'];
		ldm_update_oneadminrow(-1, 'prune_downloadtable', $links_defaults['prune_downloadtable']);
	}

	$myrow = $vbulletin->db->query_first("
		SELECT COUNT(*) AS hits, MIN(usertime) AS first, MAX(usertime) AS last
		FROM ".THIS_TABLE."linksdownloads
		WHERE linkid>0
		");
	$totalhits = $myrow['hits'];
	$firsthit = intval($myrow['first']);
	$firstdate = ldm_date($vbulletin->options['dateformat'], $firsthit);
	$lasthit = intval($myrow['last']);
	$lastdate = ldm_date($vbulletin->options['dateformat'], $lasthit);

	$hitsperpage = ($vbulletin->GPC['hitsperpage'] ? $vbulletin->GPC['hitsperpage'] : ($links_defaults['perpage_downloadtable'] ? $links_defaults['perpage_downloadtable'] : 25));

	cache_LDMusergroup();

	$can_bypass_hit_recording = array();
	foreach ($ldm_master_settings['can_bypass_hit_recording'] as $bypasscat=>$bypassperms) {
	    $bypassarray = explode(',', $bypassperms['setting']);
    	foreach ($ldm_usergroup_cache as $usergroupid => $title) {
			if (in_array($usergroupid, $bypassarray)) {
				$can_bypass_hit_recording[$title] = $title;
			}
		}
	}
	$can_bypass_hit_recording = implode(', ', $can_bypass_hit_recording);

	unset($startat);
	unset($endat);

	$hostname = "";
	if ($vbulletin->GPC['hostname']) {
		$hostname = $vbulletin->GPC['hostname'];
	}

	if ($vbulletin->GPC_exists['startint']) {
		$startat = max($vbulletin->GPC['startint'], $firsthit);
		$datesel = -2;
	}
	elseif ($vbulletin->GPC_exists['endint']) {
		$startat = $firsthit - 1;
		$datesel = -2;
	}
	elseif ($vbulletin->GPC['showdates']==-1) {
		$startat = $firsthit - 1;
		$datesel = -1;
	}
	elseif ($vbulletin->GPC['showdates']>0) {
		$startat = $lasthit - $vbulletin->GPC['showdates']*24*60*60 - 1;
		$datesel = $vbulletin->GPC['showdates'];
	}
	elseif ($vbulletin->GPC['start']) {
		if (preg_match("/\d\d\d\d.\d\d.\d\d/", $vbulletin->GPC['start'])) {
			$chars = preg_split('/-/', $vbulletin->GPC['start'], 3, PREG_SPLIT_NO_EMPTY);
			$startat = vbmktime ( 0, 0, 0, $chars[1], $chars[2], $chars[0]);
			$datesel = -2;
		}
		else {
			$err = $vbphrase['ll_error_downloads_dates'].'<br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
	}
	else {
		$startat = $firsthit - 1;
		$datesel = -1;
	}

	if ($vbulletin->GPC_exists['endint']) {
		$endat = min($lasthit, $vbulletin->GPC['endint']);
	}
	elseif ($vbulletin->GPC_exists['startint']) {
		$endat = $lasthit + 1;
	}
	elseif ($vbulletin->GPC['showdates']==-1) {
		$endat = $lasthit + 1;
	}
	elseif ($vbulletin->GPC['showdates']>0) {
		$endat = $lasthit + 1;
	}
	elseif ($vbulletin->GPC['end']) {
		if (preg_match("/\d\d\d\d.\d\d.\d\d/", $vbulletin->GPC['end'])) {
			$chars = preg_split('/-/', $vbulletin->GPC['end'], 3, PREG_SPLIT_NO_EMPTY);
			$endat = vbmktime ( 23, 59, 59, $chars[1], $chars[2], $chars[0]);
		}
		else {
			$err = $vbphrase['ll_error_downloads_dates'].'<br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}
	}
	else {
		$endat = $lasthit + 1;
	}

	$startdate = vbdate ("Y-m-d", $startat);
	$enddate = vbdate ("Y-m-d", $endat);

	unset($userid);
	if ($vbulletin->GPC_exists['userid']) {
		$userid = $vbulletin->GPC['userid'];
	}
	unset($linkid);
	if ($vbulletin->GPC_exists['linkid']) {
		$linkid = $vbulletin->GPC['linkid'];
	}
	unset($userip);
	if ($vbulletin->GPC_exists['userip']) {
		$userip = $vbulletin->GPC['userip'];
	}

	$sortby  = ($vbulletin->GPC_exists['sortby'] ? $vbulletin->GPC['sortby'] : "byuser");
	$sortdir = ($vbulletin->GPC_exists['sortdir'] ? $vbulletin->GPC['sortdir'] : "asc");

	$pagenumber2 = ($vbulletin->GPC['page2'] ? $vbulletin->GPC['page2'] : 1);

	$script = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl'].
	    "set=logjumps".
	    "&amp;sortby=".$sortby.
	    "&amp;sortdir=".$sortdir.
		"&amp;start=".$startdate.
		"&amp;end=".$enddate;

	$logscript = $script .
		(isset($userid) ? "&amp;userid=".$userid : "") .
		(isset($linkid) ? "&amp;linkid=".$linkid : "") .
		(isset($userip) ? "&amp;userip=".$userip : "") ;

	$linktotalsbit = "";
	$linkdetailsbit = "";

	$pagenav = "";
	$pagenav2 = "";

	$expand = $vbulletin->GPC['expand'];

// Tidy downloads table
	if ($vbulletin->GPC_exists['archive'] and $vbulletin->GPC['archive']) {

		$tmpfname = tempnam("", "arc");
		$temp = @fopen($tmpfname, "w");
		if (!$temp) {
			$err = $vbphrase['ll_error_downloads_temp'].'<br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
			eval(standard_error($err));
			exit;
		}

		$query = "SELECT *
				FROM ".THIS_TABLE."linksdownloads
				WHERE usertime>=".$startat." AND usertime<=".$endat."
				AND linkid>0
				";

		switch ($sortby) {

		case "bydoc":
			$query .= "ORDER BY linkid $sortdir, usertime";
			break;

		case "byip":
			$query .= "ORDER BY userip $sortdir, usertime";
			break;

		case "bydate":
			$query .= "ORDER BY usertime $sortdir";
			break;

		case "bysite":
			$query .= "ORDER BY linkid $sortdir, usertime";
			break;

		case "byuser":
		default:
			$query .= "ORDER BY username $sortdir, usertime";
			break;
		}

		fwrite($temp, "LinkID,LinkURL,UserName,UserID,UserIP,Time\r\n");

		$asb = $vbulletin->db->query_read($query);
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$dateandtime = ldm_date($vbulletin->options['dateformat'], $myrow["usertime"]).
				' '.
				ldm_date($vbulletin->options['timeformat'], $myrow["usertime"]);
			fwrite($temp, '"'.$myrow["linkid"].'","'.$myrow["linkurl"].'","'.$myrow["username"].'","'.$myrow["userid"].'","'
				.$myrow["userip"].'","'.$dateandtime.'"'."\r\n");
		}
		fclose($temp);
		$temp = @fopen($tmpfname, "r");
		$filesize = filesize($tmpfname);
		@header("HTTP/1.1 200");
		@header("Expires: 0");

		if (strtolower($_SERVER['HTTPS'])=="https" or $_SERVER['SERVER_PORT']==443) { // Get round IE ssl cache problem
			@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
		}
		else {
			@header("Cache-Control: private, post-check=0, pre-check=0, max-age=0", false);
			@header("Pragma: no-cache"); // HTTP/1.0
		}

		@header("Content-Length: $filesize");
		@header("Content-type: application/octet-stream");
		@header("Content-disposition: attachment; filename=downloads.csv");
		fpassthru($temp);
		fclose($temp);
		unlink($tmpfname);
	}

	if ($vbulletin->GPC_exists['delete'] and $vbulletin->GPC['delete']) {
		$query = "
			DELETE
			FROM ".THIS_TABLE."linksdownloads
			WHERE linkid>0
			";
		if ($vbulletin->GPC['delete']==1) {
			$query .= "
			AND usertime>=".$startat."
			AND usertime<=".$endat."
			";
		}
		else {
			$query .= "
			AND usertime<".$startat."
			";
		}
		$vbulletin->db->query_write($query);

		$myrow = $vbulletin->db->query_first("
			SELECT COUNT(*) AS hits, MIN(usertime) AS first, MAX(usertime) AS last
			FROM ".THIS_TABLE."linksdownloads
			WHERE linkid>0
			");
		$totalhits = $myrow['hits'];
		$firsthit = $myrow['first'];
		$firstdate = ldm_date($vbulletin->options['dateformat'], $firsthit);
		$lasthit = $myrow['last'];
		$lastdate = ldm_date($vbulletin->options['dateformat'], $lasthit);
	}

	if ($vbulletin->GPC_exists['archive'] and $vbulletin->GPC['archive']) {
		exit;
	}

	if (!$expand) { // Summarise downloads table

		$navbits[""] = $vbphrase['ll_viewhits'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		$counts = array();
		switch ($sortby) {

		case "bydoc":
			$query = "
				SELECT lhits.linkid AS linkid, lhits.linkurl AS linkurl, COUNT(lhits.bytes) AS hits, SUM(lhits.bytes) AS bytes,
						links.linkname AS linkname
				FROM ".THIS_TABLE."linksdownloads AS lhits
				LEFT JOIN ".THIS_TABLE."linkslink AS links
				ON lhits.linkid=links.linkid
				WHERE lhits.usertime>=".$startat." AND lhits.usertime<=".$endat.
				(isset($userid) ? " AND lhits.userid='".$userid."'" : "").
				(isset($userip) ? " AND lhits.userip='".$userip."'" : "").
				(isset($linkid) ? " AND lhits.linkid='".$linkid."'" : " AND lhits.linkid>0")."
				GROUP BY lhits.linkid
				ORDER BY links.linkname $sortdir
				";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow=$vbulletin->db->fetch_array($asb)) {
				$counts[$myrow['linkname']]['hits'] = $myrow['hits'];
				$counts[$myrow['linkname']]['bytes'] = $myrow['bytes'];
				$counts[$myrow['linkname']]['title'] = ($myrow['linkname'] ? $myrow['linkname'] : construct_phrase($vbphrase['ll_hint_thisentry_notavail'], $myrow['linkid']));
				$counts[$myrow['linkname']]['drill'] = $script."&amp;expand=1&amp;startint=".$startat."&amp;endint=".$endat.
					"&amp;linkid=".$myrow['linkid'].
					(isset($userid) ? "&amp;userid=".$userid : "") . (isset($userip) ? "&amp;userip=".$userip : "").
					"&amp;hitsperpage=".$hitsperpage;
			}
			break;

		case "byip":
			$subscript = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl'].
			        "set=logjumps".
			        "&amp;sortby=bydoc".
            	    "&amp;sortdir=".$sortdir.
					"&amp;start=".$startdate.
					"&amp;end=".$enddate;
			$query = "
				SELECT linkid, linkurl, userip, userid, username, COUNT(bytes) AS hits, SUM(bytes) AS bytes
				FROM ".THIS_TABLE."linksdownloads
				WHERE usertime>=".$startat." AND usertime<=".$endat.
				(isset($userid) ? " AND userid='".$userid."'" : "").
				(isset($userip) ? " AND lhits.userip='".$userip."'" : "").
				(isset($linkid) ? " AND linkid='".$linkid."'" : " AND linkid>0")."
				GROUP BY userip, userid
				ORDER BY userip $sortdir
				";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow=$vbulletin->db->fetch_array($asb)) {
				if (preg_match("/(\d+)\.(\d+)\.(\d+)\.(\d+)/", $myrow['userip'], $matches)) {
					$key = sprintf("%03d.%03d.%03d.%03d", $matches[1], $matches[2], $matches[3], $matches[4]);
					$mytitle = $myrow['userip'] . " " . ldm_ip_locate($myrow['userip']);
				}
				else {
					$key = "000.000.000.000";
					$mytitle = $vbphrase['ll_unknown_ip'];
				}
				$key = $key.':'.$myrow['userid'];
				$counts[$key]['title'] = $mytitle;
				$counts[$key]['subtitle'] = $myrow['username'];
				$counts[$key]['hits'] = $myrow['hits'];
				$counts[$key]['bytes'] = $myrow['bytes'];
				$counts[$key]['drill'] = $script."&amp;expand=1&amp;startint=".$startat."&amp;endint=".$endat.
					"&amp;userip=".$myrow['userip'].
					(isset($userid) ? "&amp;userid=".$userid : "") . (isset($linkid) ? "&amp;linkid=".$linkid : "").
					"&amp;hitsperpage=".$hitsperpage;
				$counts[$key]['subdrill'] = $subscript."&amp;expand=1&amp;startint=".$startat."&amp;endint=".$endat.
					"&amp;userip=".$myrow['userip'].
					"&amp;userid=".$myrow['userid'].
					"&amp;hitsperpage=".$hitsperpage;
			}
			break;

		case "bydate":
			$query = "
				SELECT linkid, linkurl, bytes, usertime
				FROM ".THIS_TABLE."linksdownloads
				WHERE usertime>=".$startat." AND usertime<=".$endat.
				(isset($userid) ? " AND userid='".$userid."'" : "").
				(isset($userip) ? " AND lhits.userip='".$userip."'" : "").
				(isset($linkid) ? " AND linkid='".$linkid."'" : " AND linkid>0")."
				ORDER BY usertime $sortdir
				";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow=$vbulletin->db->fetch_array($asb)) {
				$key	= date('ymd', $myrow['usertime']);
				$kstartat = vbmktime ( 0, 0, 0, substr($key,2,2), substr($key,4,2), substr($key,0,2));
				$kendat	= $kstartat + 24*60*60;
				$counts[$key]['hits'] += 1;
				$counts[$key]['bytes'] += $myrow['bytes'];
				$counts[$key]['title'] = ldm_date($vbulletin->options['dateformat'], $myrow['usertime']);
				$counts[$key]['drill'] = $script."&amp;expand=1&amp;startint=".$kstartat."&amp;endint=".$kendat.
					(isset($userid) ? "&amp;userid=".$userid : "") . (isset($linkid) ? "&amp;linkid=".$linkid : "") . (isset($userip) ? "&amp;userip=".$userip : "").
					"&amp;hitsperpage=".$hitsperpage;
			}
			break;

		case "bysite":
			$query = "
				SELECT linkid, linkurl, bytes
				FROM ".THIS_TABLE."linksdownloads
				WHERE usertime>=".$startat." AND usertime<=".$endat.
				(isset($userid) ? " AND userid='".$userid."'" : "").
				(isset($userip) ? " AND userip='".$userip."'" : "").
				(isset($linkid) ? " AND linkid='".$linkid."'" : " AND linkid>0")."
				ORDER BY linkid $sortdir
				";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow=$vbulletin->db->fetch_array($asb)) {
				$urlInfo = ldm_parse_url($myrow['linkurl']);
				if ($urlInfo['host']) {
					$hostname = $urlInfo['host'];
				}
				else {
					$hostname = $vbulletin->options['bbtitle'];
				}
				$counts[$hostname]['hits'] += 1;
				$counts[$hostname]['bytes'] += $myrow['bytes'];
				$counts[$hostname]['title'] = $hostname;
				$counts[$hostname]['drill'] = $script."&amp;expand=1&amp;startint=".$startat."&amp;endint=".$endat.
					"&amp;hostname=".$hostname.
					(isset($userid) ? "&amp;userid=".$userid : "") . (isset($userip) ? "&amp;userip=".$userip : "").
					(isset($linkid) ? "&amp;linkid=".$linkid : "").
					"&amp;hitsperpage=".$hitsperpage;
			}
			break;

		case "byuser":
		default:
			$query = "
				SELECT userid, userip, username, COUNT(bytes) AS hits, SUM(bytes) AS bytes
				FROM ".THIS_TABLE."linksdownloads
				WHERE usertime>=".$startat." AND usertime<=".$endat.
				(isset($userid) ? " AND userid='".$userid."'" : "").
				(isset($userip) ? " AND lhits.userip='".$userip."'" : "").
				(isset($linkid) ? " AND linkid='".$linkid."'" : " AND linkid>0")."
				GROUP BY userid, userip
				ORDER BY username $sortdir
				";
			$asb = $vbulletin->db->query_read($query);
			while ($myrow=$vbulletin->db->fetch_array($asb)) {
				$my_user = ($myrow['userid'] ? unhtmlentities($myrow['username']) : $vbphrase['unregistered']);
				$key = strtolower($my_user);
				$counts[$key]['hits'] += $myrow['hits'];
				$counts[$key]['bytes'] += $myrow['bytes'];
				$counts[$key]['subtitle'] += 1;
				$counts[$key]['title'] = unhtmlentities($my_user);
				$counts[$key]['drill'] = $script."&amp;expand=1&amp;startint=".$startat."&amp;endint=".$endat.
					"&amp;userid=".$myrow['userid'].
					(isset($linkid) ? "&amp;linkid=".$linkid : "") . (isset($userip) ? "&amp;userip=".$userip : "").
					"&amp;hitsperpage=".$hitsperpage;
				$counts[$key]['userid'] = $myrow['userid'];
			}
			$subscript = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl'].
			        "set=logjumps".
			        "&amp;sortby=byip".
            	    "&amp;sortdir=".$sortdir.
					"&amp;start=".$startdate.
					"&amp;end=".$enddate;
			foreach (array_keys($counts) as $key) {
				$counts[$key]['subtitle'] = construct_phrase($vbphrase['ll_admin_hits_ips'], $counts[$key]['subtitle']);
				$counts[$key]['subdrill'] = $subscript."&amp;startint=".$startat."&amp;endint=".$endat.
					"&amp;userid=".$counts[$key]['userid'].
					"&amp;hitsperpage=".$hitsperpage;
			}
			break;

		}

        $cmpfunc = 'if ("'.$sortdir.'"=="asc") { return strnatcasecmp($a, $b); } else { return strnatcasecmp($b, $a); };';
    	uksort($counts, create_function('$a,$b', $cmpfunc));

		$nstart	= ($pagenumber-1)*$hitsperpage+1;
		$nend	= $pagenumber*$hitsperpage;
		$nrow	= 0;
		$itemhits 	= 0;

		foreach ($counts as $key=>$this_count) {
			$nrow++;
			$itemhits += $this_count['hits'];
			if ($nrow<$nstart or $nrow>$nend) {
				continue;
			}
			$this_count['encode_bytes'] = ldm_encode_bytes($this_count['bytes']);
			eval("\$linktotalsbit .= \"".fetch_template('links_admin_downloads_group')."\";");
		}

		if (isset($userid)) {
			$itemstitle = construct_phrase($vbphrase['ll_admin_total_hits_byuser'], $itemhits, $userid, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		elseif (isset($userip)) {
			$itemstitle = construct_phrase($vbphrase['ll_admin_total_hits_byip'], $itemhits, $userip, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		elseif (isset($linkid)) {
			$itemstitle = construct_phrase($vbphrase['ll_admin_total_hits_byentry'], $itemhits, $linkid, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		else {
			$itemstitle = construct_phrase($vbphrase['ll_admin_total_hits'], $itemhits, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}

		$pagenav = construct_page_nav($pagenumber, $hitsperpage, count($counts), $logscript,"&amp;hitsperpage=$hitsperpage");

	}

	else { // Give detailed table for selected user/ip/entry

		$navbits[$ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=logjumps"] = $vbphrase['ll_viewhits'];
		$lastnavbits = $vbphrase['ll_hits'];
		if (isset($userid)) {
			$lastnavbits .= " (Userid $userid)";
		}
		if (isset($linkid)) {
			$lastnavbits .= " (Linkid $linkid)";
		}
		if (isset($userip)) {
			$lastnavbits .= " (IP $userip)";
		}
		$navbits[""] = $lastnavbits;
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		$query = "
			SELECT hits.dlid AS dlid, hits.usertime AS usertime, hits.bytes AS bytes, hits.linkid AS linkid,
				hits.linkurl AS linkurl, hits.username AS username, hits.userid AS userid,
				hits.userip AS userip, links.linkname AS linkname
			FROM ".THIS_TABLE."linksdownloads AS hits
			LEFT JOIN ".THIS_TABLE."linkslink AS links
			ON hits.linkid=links.linkid
			WHERE hits.usertime>=".$startat."
			AND hits.usertime<=".$endat."
			AND hits.linkid>0
			";

		$subquery = "";
		$subsort = "ORDER BY hits.usertime";
		if (isset($userid)) {
			$subquery .= "AND hits.userid='".$userid."'";
			$subsort = "ORDER BY links.linkname, hits.usertime";
		}
		if (isset($linkid)) {
			$subquery .= "AND hits.linkid='".$linkid."'";
			$subsort = "ORDER BY hits.username";
		}
		if (isset($userip)) {
			$subquery .= "AND hits.userip='".$vbulletin->db->escape_string($userip)."'";
			$subsort = "ORDER BY links.linkname, hits.usertime";
		}
		$query .= $subquery . ' ' . $subsort;

		$asb = $vbulletin->db->query_read($query);

		$nrow = 0;
		$nstart = ($pagenumber2-1)*$hitsperpage+1;
		$nend = $nstart + $hitsperpage;
		$lastlink = -1;
		$alt = '';

		while ($myrow=$vbulletin->db->fetch_array($asb)) {

			if ($hostname) {
				$urlInfo = ldm_parse_url($myrow['linkurl']);
				if ((!$urlInfo['host'] and $hostname!=$vbulletin->options['bbtitle']) or ($urlInfo['host'] and $urlInfo['host']!=$hostname)) {
					continue;
				}
			}

			$nrow++;
			if ($nrow<$nstart or $nrow>$nend) {
				continue;
			}

			$my_bytes = $myrow['bytes'] ? ldm_format_bytes($myrow['bytes']) : 'OK';
			$my_whenh = ldm_date($vbulletin->options['timeformat'], $myrow['usertime']);
			$my_whend = ldm_date($vbulletin->options['dateformat'], $myrow['usertime']);
			if (preg_match("/(\d+)\.(\d+)\.(\d+)\.(\d+)/", $myrow['userip'], $matches)) {
				$my_ip = $myrow['userip'] . " " . ldm_ip_locate($myrow['userip']);
			}
			else {
				$my_ip = $vbphrase['ll_unknown_ip'];
			}
			if (!isset($userip)) {
				$my_ip .= ' '.
					'<a title="'.construct_phrase($vbphrase['ll_hint_thisip'], $myrow['userip']).'" href="'.$script."&amp;expand=1&amp;startint=".$startat."&amp;endint=".$endat.
					'&amp;userip='.$myrow['userip'].
					"&amp;hitsperpage=".$hitsperpage.'">'.
					(isset($ldm_icon_cache['magnify']) ? ldm_get_imagebit($ldm_icon_cache['magnify'], $vbphrase['ll_hint_thisip']) : '['.$vbphrase[ll_viewhits].']').
					'</a>';
			}
			$my_userid = construct_phrase($vbphrase['ll_admin_userid'], $myrow['userid']);
			$my_user = ($myrow['userid'] ? unhtmlentities($myrow['username']) : $vbphrase['unregistered']);
			if (!isset($userid)) {
				$my_user .= ' '.
					'<a title="'.$vbphrase['ll_hint_thisuser'].'" href="'.$script."&amp;expand=1&amp;startint=".$startat."&amp;endint=".$endat.
					'&amp;userid='.$myrow['userid'].
					"&amp;hitsperpage=".$hitsperpage.'">'.
					(isset($ldm_icon_cache['magnify']) ? ldm_get_imagebit($ldm_icon_cache['magnify'], $vbphrase['ll_hint_thisuser']) : '['.$vbphrase[ll_viewhits].']').
					'</a>';
			}
			if ($myrow['linkname']) {
    			$my_entryname = $myrow['linkname'];
    			$my_entry =
					'<a href="'.$ADMIN_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'set=showinfo&amp;linkid='.$myrow['linkid'].'" title="'.$vbphrase['ll_viewdetails'].'" target="_blank">'.ldm_get_imagebit($ldm_icon_cache['info'], $vbphrase['ll_viewdetails']).'</a> '.
					$my_entryname;
			}
			else {
    			$my_entry = construct_phrase($vbphrase['ll_hint_thisentry_notavail'],$myrow['linkid']);
			}
			if (!isset($linkid)) {
				$my_hint = construct_phrase($vbphrase['ll_hint_thisentry'], $myrow['linkid']);
				$my_entry .= ' '.
					'<a title="'.$my_hint.'" href="'.$script."&amp;expand=1&amp;startint=".$startat."&amp;endint=".$endat.'&amp;linkid='.$myrow['linkid'].
					"&amp;hitsperpage=".$hitsperpage.'">'.
					(isset($ldm_icon_cache['magnify']) ? ldm_get_imagebit($ldm_icon_cache['magnify'], $my_hint) : '['.$vbphrase[ll_viewhits].']').
					'</a>';
			}
			$my_delete = '<input type="checkbox" value="'.$myrow['dlid'].'" name=entrydelete[] />';
			$alt = ($myrow['linkid']==$lastlink ? $alt : ($alt=='alt1' ? 'alt2' : 'alt1'));
			$lastlink = $myrow['linkid'];
			eval("\$linkdetailsbit .= \"".fetch_template('links_admin_downloads_item')."\";");
		}

		if (!$linkdetailsbit) {
			eval("\$linkdetailsbit = \"".fetch_template('links_admin_downloads_item_none')."\";");
		}

		if (isset($userid)) {
			$detailstitle = construct_phrase($vbphrase['ll_admin_total_hits_byuser'], $nrow, $userid, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		elseif (isset($userip)) {
			$detailstitle = construct_phrase($vbphrase['ll_admin_total_hits_byip'], $nrow, $userip, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		elseif (isset($linkid)) {
			$detailstitle = construct_phrase($vbphrase['ll_admin_total_hits_byentry'], $nrow, $linkid, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}
		else {
			$detailstitle = construct_phrase($vbphrase['ll_admin_total_hits'], $nrow, ldm_date($vbulletin->options['dateformat'], $startat), ldm_date($vbulletin->options['dateformat'], $endat));
		}

		$drillscript = $logscript."&amp;expand=1&amp;startint=".$startat."&amp;endint=".$endat;
		$pagenav2 = construct_page_nav($pagenumber2, $hitsperpage, $nrow, $drillscript, "&amp;hitsperpage=$hitsperpage");
		$pagenav2 = preg_replace("/;page=/", ";page2=", $pagenav2);

	}

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_edit_category"] = 0;
	$viewcatid=-1;

	$hitstitle = construct_phrase($vbphrase['ll_admin_total_hits'], $totalhits, $firstdate, $lastdate);
	eval("\$logjumpsbit = \"".fetch_template('links_admin_downloads')."\";");

}

/* ===========================================================================*/
// Follow-up action
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST["dologjumps"])) {

	$vbulletin->input->clean_array_gpc('r', array(
		'datesel' => TYPE_INT,
		'expand' => TYPE_INT,
		'enddate' => TYPE_STR,
		'sortby' => TYPE_STR,
		'sortdir' => TYPE_STR,
		'startdate' => TYPE_STR,
		'entrydelete' => TYPE_ARRAY_INT,
	));

	$sortby  = ($vbulletin->GPC_exists['sortby'] ? $vbulletin->GPC['sortby'] : "byuser");
	$sortdir = ($vbulletin->GPC_exists['sortdir'] ? $vbulletin->GPC['sortdir'] : "asc");

	$url  = ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl'].
	    "action=admin&amp;set=logjumps".
	    "&amp;sortby=$sortby".
	    "&amp;sortdir=$sortdir".
	    ($vbulletin->GPC_exists['startdate'] ? "&amp;startdate=".$vbulletin->GPC['startdate'] : "").
	    ($vbulletin->GPC_exists['enddate']   ? "&amp;enddate=".$vbulletin->GPC['enddate'] : "").
	    ($vbulletin->GPC_exists['datesel']   ? "&amp;datesel=".$vbulletin->GPC['datesel'] : "");

	if (count($vbulletin->GPC['entrydelete'])) {
		$query = "
			DELETE FROM ".THIS_TABLE."linksdownloads
			WHERE dlid IN (" . implode(',', $vbulletin->GPC['entrydelete']) . ")
			";
		$vbulletin->db->query_write($query);
	}

	eval(print_standard_redirect($vbphrase['ll_deleted'],0));
	exit;

}

?>