<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// Analyse keywords
/* ===========================================================================*/

if ($adminset == "keywords") {
	require_once(DIR . '/includes/local_links_admin_nominations.php');

	$navbits[""] = $vbphrase['ll_menu_admkey'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$percols = 4;
	$perpage = $percols*$perpage;
	$ist = ($pagenumber-1)*$perpage;
	$ifn = $ist + $perpage;

	$keywords = "";
	$asb = $vbulletin->db->query_read("
		SELECT lkeys.keyid AS keyid, lkeys.keyword AS keyword, COUNT(ltok.linkid) as paired
		FROM ". THIS_TABLE . "linkskeys AS lkeys
		LEFT JOIN ". THIS_TABLE . "linksltok AS ltok
		ON lkeys.keyid=ltok.keyid
		GROUP BY lkeys.keyid
		ORDER BY keyword
		LIMIT ".$ist.", ".$perpage."
	");

	$selected = 0;
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$keyword = $myrow['keyword'];
		$keyid = $myrow['keyid'];
		$keycount = $myrow['paired'] ? $myrow['paired']: 0;
		eval('$keys[] = "' . fetch_template('links_selectkeyword') . '";');
	}

	$rows = $vbulletin->db->query_first("
		SELECT COUNT(*) AS nrec
		FROM ". THIS_TABLE . "linkskeys AS lkeys
	");

	$pagenav = construct_page_nav($pagenumber, $perpage, $rows['nrec'], $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=keywords");
	$keywords = ldm_map_listbit_to_grid($keys, $percols, 1);

}

/* ===========================================================================*/
// Follow-up action
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST['dokeywords'])) {
	require_once(DIR . '/includes/local_links_admin_keywords.php');
	$vbulletin->input->clean_array_gpc('p', array(
		'editkeys' => TYPE_INT,
		'keywords' => TYPE_ARRAY_INT,
		'mergekeyword' => TYPE_STR,
		'newkeywords' => TYPE_STR,
	));

	$list = implode("', '", $vbulletin->GPC['keywords']);

	switch ($vbulletin->GPC['editkeys']) {

	case 1: // Merge keywords

    	$newkeyword = $vbulletin->GPC['mergekeyword'];
	    if ($newkeyword) {
// add the new keyword
		    $vbulletin->db->query_write("
			    INSERT INTO ".THIS_TABLE."linkskeys
			    SET
				    keyword='".$vbulletin->db->escape_string($newkeyword)."'
			    ");
		    $newkeyid = $vbulletin->db->insert_id();
// find everything associated with existing keywords
		    $asb = $vbulletin->db->query_read("
			    SELECT linkid FROM ".THIS_TABLE."linksltok
			    WHERE keyid IN ('-1', '".$list."')
			    ");
		    $linkids = array();
		    while ($row=$vbulletin->db->fetch_array($asb)) {
			    $linkids[$row['linkid']] = 1;
		    }
// associate these with the new keyword
		    foreach (array_keys($linkids) as $thislinkid) {
			    $vbulletin->db->query_write("
				    INSERT INTO ".THIS_TABLE."linksltok
				    SET
					    linkid='".$thislinkid."',
					    keyid='".$newkeyid."'
				    ");
		    }
// get rid of old associations and keywords
		    $vbulletin->db->query_write("
			    DELETE FROM ".THIS_TABLE."linkskeys
			    WHERE keyid IN ('-1', '".$list."')
			    ");
		    $vbulletin->db->query_write("
			    DELETE FROM ".THIS_TABLE."linksltok
			    WHERE keyid IN ('-1', '".$list."')
			    ");
	    }
	    break;

	case 2: // Delete keywords

    	$vbulletin->db->query_write("
	    	DELETE FROM ".THIS_TABLE."linkskeys
		    WHERE keyid IN ('-1', '".$list."')
		    ");
    	$vbulletin->db->query_write("
	    	DELETE FROM ".THIS_TABLE."linksltok
		    WHERE keyid IN ('-1', '".$list."')
		    ");
	    break;

	}

	ldm_lookup_keywords(ldm_explode_keywords($vbulletin->GPC['newkeywords']));

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=keywords&amp;page=$pagenumber";
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

}

?>