<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

if ($adminset == "showinfo") {

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid'	=> TYPE_INT,
	));

	$linkid = ($vbulletin->GPC_exists['linkid'] ? $vbulletin->GPC['linkid'] : 0);

	unset($link);
	if ($linkid) {
		$link = $vbulletin->db->query_first("
			SELECT *
			FROM ".THIS_TABLE."linkslink
			WHERE linkid='".$linkid."'
			");

		if (!isset($link['linkid'])) {
			eval(standard_error(construct_phrase($vbphrase['ll_error_linkid'], $linkid)));
			exit;
		}

		$link['categories'] = array();
		$lcats = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksltoc
			WHERE linkid='".$linkid."'
			");
		while ($rec=$vbulletin->db->fetch_array($lcats)) {
			$linkcatid = $rec['catid'];
			$linkcatname = ldm_parse_features($linkscat[$linkcatid]['catname']);
			$link['categories'][$linkcatid] = $linkcatname;
		}
		$linkcatnames = implode(', ', $link['categories']);

		$stars = $vbulletin->db->query_first("
			SELECT COUNT(userid) AS starred
			FROM ".THIS_TABLE."linkstarred
			WHERE linkid='".$linkid."'
			");
		$link['nominations'] = $stars['starred'];

		$noms = $vbulletin->db->query_first("
			SELECT COUNT(userid) AS nominated
			FROM ".THIS_TABLE."linksfavs
			WHERE linkid='".$linkid."'
			");
		$link['favourites'] = $noms['nominated'];

		$rates = $vbulletin->db->query_first("
			SELECT COUNT(*) AS votes
			FROM ".THIS_TABLE."linksrate
			WHERE linkid='".$linkid."'
			");
		$link['votes'] = $rates['votes'];

		$link['keywords'] = array();
		$keys = $vbulletin->db->query_read("
			SELECT lkeys.keyword AS keyword
			FROM ".THIS_TABLE."linkskeys AS lkeys
			LEFT JOIN ".THIS_TABLE."linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			WHERE linkid='".$linkid."'
			");
		while ($rec=$vbulletin->db->fetch_array($keys)) {
			$link['keywords'][] = $rec['keyword'];
		}
		$linkkeywords = implode(', ', $link['keywords']);
	}

	if (is_array($link)) {

		require_once(DIR . '/includes/local_links_players.php');

		if ($link['linkimg']) {
			$linkimgsrc = ldm_make_filename($vbulletin->options['bburl'],$RESIZE_SCRIPT).'.php?'.$vbulletin->session->vars['sessionurl'].'linkid='.$linkid;
			$link['linkimgshow'] = ldm_get_imagebit($linkimgsrc);
		}

		$is_hidden = 0;

		switch ($link[linkstatus]) {
		case $LINK_BROKEN:
			$link[linkstatus] = $vbphrase['ll_broken'];
			break;
		case $LINK_UPLOAD:
			$link[linkstatus] = $vbphrase['ll_uploaded'];
			break;
		case $LINK_HIDDEN:
			$link[linkstatus] = $vbphrase['ll_hidden'];
			$is_hidden = 1;
			break;
		default:
			$link[linkstatus] = $vbphrase['ll_ok'];
			break;
		}

		$link['linkformatteddate'] = ldm_date($vbulletin->options['dateformat'], $link['linkdate']) . ' ' .
			ldm_date($vbulletin->options['timeformat'], $link['linkdate']);
		$link['linkdesc'] = ldm_parse_features(trim($link['linkdesc']));
		if ($link['linkreviewfreq']>0) {
			$link['linkmoddate'] = $link['linkmoddate'] ? ldm_date($vbulletin->options['dateformat'], $link['linkmoddate']) : $vbphrase['ll_never'];
		}
		if ($link['linksize']) {
			$link['linksize'] = ldm_format_bytes($link['linksize']);
		}

		$urlInfo = ldm_parse_url($link['linkurl']);
		$urlType	= file_extension($urlInfo['path']);
		$link['knownmimetype'] = ldm_get_mimetype($urlType);
		if (is_array($link['knownmimetype'])) {
			$link['knownmimetype'] = implode('</br >', $link['knownmimetype']);
		}
		else {
			$link['knownmimetype'] = '';
		}
		$link['filetype'] = strtolower($urlType);
		$link['media'] = 0;

		if (get_ldm_playerid($linkid, $link['linkurl'], $link['filetype'])>=0) {
			$link['media'] = 1;
		}

		eval("\$entryinfo = \"".fetch_template('links_admin_entryinfo')."\";");

		cache_LDMusergroup();
		$permsinfo = "";

// Work out the forum-based access permissions
		if ($link['linkforum']>0 and isset($forum[$link['linkforum']])) {
			require_once(DIR . '/includes/adminfunctions_forums.php');
			$forumperms = array();
			foreach ($ldm_usergroup_cache as $usergroupid => $title) {
				$perms = fetch_forum_permissions($usergroupid, $link['linkforum']);
				$forumperms[$usergroupid]['canview'] = ($perms['forumpermissions'] & $vbulletin->bf_ugp_forumpermissions['canview']);
				$forumperms[$usergroupid]['canviewothers'] = ($perms['forumpermissions'] & $vbulletin->bf_ugp_forumpermissions['canviewothers']);
			}
		}

		$cache_usergroupids = $links_usergroupids;

		foreach ($link['categories'] as $catid=>$catname) {

			$expire = max(0,ldm_lookup_setting($catid, 'links_expiry_days'))*24*60*60;
			$catstatus = "";
			if ($expire>0) {
				if ($link['linkdate']>TIMENOW+60) {
					$catstatus = $vbphrase['ll_notyetvisible'];
					$catstatusdate = ldm_date($vbulletin->options['dateformat'], $link['linkdate']);
					$is_hidden = 1;
				}
				elseif ($link['linkdate']+$expire<TIMENOW) {
					$catstatus = $vbphrase['ll_expired'];
					$catstatusdate = ldm_date($vbulletin->options['dateformat'], $link['linkdate']+$expire);
					$is_hidden = 1;
				}
			}

// Work out the category-based access permissions
			$thisperminfo = '';
			foreach ($ldm_usergroup_cache as $usergroupid => $title) {
// Temporarily modify current usergroup
				$links_usergroupids = array($usergroupid);
				$usergroup_title = $title;

				$yesno_access = ldm_lookup_permission($catid, 'can_access_link');
				$usergroup_ldm = ( $yesno_access ? '<em>can_access_link</em>' : $vbphrase['ll_no'] );

				$yesno_hidden = 1;
				if ($is_hidden) {
					$yesno_hidden = ldm_lookup_permission($catid, 'can_view_hidden');
				}
				$usergroup_hidden = ( $yesno_hidden ? '<em>can_view_hidden</em>' : $vbphrase['ll_yes'] );

				if (isset($forumperms[$usergroupid])) {
					$usergroup_forum = array();
					if ($forumperms[$usergroupid]['canview']) {
						$usergroup_forum[] = '<em>canview</em>';
					}
					if ($forumperms[$usergroupid]['canviewothers']) {
						$usergroup_forum[] = '<em>canviewothers</em>';
					}
					$usergroup_forum = implode('<br />', $usergroup_forum);
				}
				else {
					$usergroup_forum = $vbphrase['ll_none'];
				}

				$yesno_forum = ldm_lookup_permission($catid, 'can_bypass_forumperms');
				if (!$yesno_forum) {
					if (isset($forumperms[$usergroupid])) {
						$yesno_forum = $forumperms[$usergroupid]['canview'] && $forumperms[$usergroupid]['canviewothers'];
					}
					else {
						$yesno_forum = 1;
					}
				}

				$usergroup_aggreg = $vbphrase['ll_yes'];
				if (!$yesno_access or !$yesno_hidden or !$yesno_forum) {
					$usergroup_aggreg = $vbphrase['ll_no'];
				}

				$usergroup_bypass = array();
				if (ldm_lookup_permission($catid, 'can_bypass_forumperms')) {
					$usergroup_bypass[] = '<em>can_bypass_forumperms</em>';
				}
				if (ldm_lookup_permission($catid, 'can_bypass_hit_recording')) {
					$usergroup_bypass[] = '<em>can_bypass_hit_recording</em>';
				}
				if (ldm_lookup_permission($catid, 'can_bypass_bandwidth_limits')) {
					$usergroup_bypass[] = '<em>can_bypass_bandwidth_limits</em>';
				}
				$usergroup_bypass = implode('<br />', $usergroup_bypass);

				eval("\$thisperminfo .= \"".fetch_template('links_admin_permsinfo')."\";");
			}
			$cateditbit = (isset($ldm_icon_cache['pencil']) ? ldm_get_imagebit($ldm_icon_cache['pencil'], $vbphrase['ll_edit']) : '['.$vbphrase['ll_editlc'].']');
			eval("\$permsinfo .= \"".fetch_template('links_admin_permscategory')."\";");
		}

		$links_usergroupids = $cache_usergroupids;

	}

}

?>