<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

if (!$links_permissions['is_vbsuperadmin']) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// XML Export
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST['doexportxml'])) {

	$cpumax = ini_get('max_execution_time');
	if ($cpumax and $cpumax<$ADMIN_IMPEXP) {
		@ini_set('max_execution_time', min(ini_get('max_execution_time'), $ADMIN_IMPEXP));
	}
	@ini_set('memory_limit', -1);


	function ldm_impexp_patchme(&$arr) {
		global $vbulletin;

		$search = array ("\r", "\n");
		$replace = array ("\\r", "\\n");
		$arr = str_replace($search, $replace, $arr);
		foreach ($arr as $k=>$v) {
			$arr[$k] = htmlspecialchars_uni($v);
		}
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'xmlexp' => TYPE_INT,
		'xmlgzip' => TYPE_INT,
	));

	if ($vbulletin->GPC['xmlexp']==1) {
// Standard LDM format

		require_once(DIR . '/includes/class_xml.php');

// Version 3.6 or greater of VBulletin
		$xml = new XMLexporter($vbulletin);

		$xml->add_group('LDM', array('name' => $master_title, 'version' => $links_defaults["this_version"],
			'date' => ldm_date($vbulletin->options['dateformat'], TIMENOW).' '.ldm_date($vbulletin->options['timeformat'], TIMENOW)));

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksadmin
			");

		$xml->add_group('admin', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			ldm_impexp_patchme($myrow);
			$xml->add_tag('admin', $myrow['adminid'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linkscat
			ORDER BY catid
			");

		$xml->add_group('categories', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			ldm_impexp_patchme($myrow);
			$xml->add_tag('category', $myrow['catid'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linkslink
			ORDER BY linkid
			");

		$xml->add_group('links', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			ldm_impexp_patchme($myrow);
			$xml->add_tag('link', $myrow['linkid'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksltoc
			ORDER BY ltoc
			");

		$xml->add_group('linkcats', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			ldm_impexp_patchme($myrow);
			$xml->add_tag('ltoc', $myrow['ltoc'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linkskeys
			ORDER BY keyid
			");

		$xml->add_group('keywords', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			ldm_impexp_patchme($myrow);
			$xml->add_tag('keyword', $myrow['keyid'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksltok
			ORDER BY lkey
			");

		$xml->add_group('linkkeys', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			ldm_impexp_patchme($myrow);
			$xml->add_tag('ltok', $myrow['lkey'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksentities
			ORDER BY entityid
			");

		$xml->add_group('entities', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			ldm_impexp_patchme($myrow);
			$xml->add_tag('entity', $myrow['entityid'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksfavs
			ORDER BY lfav
			");

		$xml->add_group('favourites', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			ldm_impexp_patchme($myrow);
			$xml->add_tag('fav', $myrow['lfav'], $myrow, true);
		}
		$xml->close_group();

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksrate
			ORDER BY lrate
			");

		$xml->add_group('ratings', array());
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			ldm_impexp_patchme($myrow);
			$xml->add_tag('rate', $myrow['lrate'], $myrow, true);
		}
		$xml->close_group();

		$xml->close_group();

		$doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n";

        if ($entities = @file_get_contents(DIR . '/includes/xml/entities_ldm.xml')) {
            $doc .= $entities;
            $doc .= "\n\n";
        }

		$doc .= $xml->output();
		$xml = null;

		require_once(DIR . '/includes/functions_file.php');
		if ($vbulletin->GPC['xmlgzip']) {
			file_download(gzencode($doc), 'export.xml.gz', 'application/x-gzip');
		}
		else {
			file_download($doc, 'export.xml', 'text/xml');
		}
		exit;

	}

	if ($vbulletin->GPC['xmlexp']==2) {
// Google Sitemap format

		$asb = $vbulletin->db->query_read("
			SELECT catid, catdate
			FROM ".THIS_TABLE."linkscat
			");

		$doc  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n\r\n";
		$doc .= "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\r\n";
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$doc .= "<url>\r\n";
			$doc .= "<loc>".$vbulletin->options['bburl']."/".$LINKS_SCRIPT.".php?catid=".$myrow['catid']."</loc>\r\n";
			$doc .= "<lastmod>".date("Y-m-d", $myrow['catdate'])."</lastmod>\r\n";
			$doc .= "</url>\r\n";
		}
		$doc .= "</urlset>";

		require_once(DIR . '/includes/functions_file.php');
		if ($vbulletin->GPC['xmlgzip']) {
			file_download(gzencode($doc), 'sitemap.xml.gz', 'application/x-gzip');
		}
		else {
			file_download($doc, 'sitemap.xml', 'text/xml');
		}
		exit;

	}


}

/* ===========================================================================*/
// CSV file import
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST['doimport'])) {

	$cpumax = ini_get('max_execution_time');
	if ($cpumax and $cpumax<$ADMIN_IMPEXP) {
		@ini_set('max_execution_time', min(ini_get('max_execution_time'), $ADMIN_IMPEXP));
	}
	@ini_set('memory_limit', -1);

	$file = $_FILES["import"]["tmp_name"];
	if ($file) {
		$messages = "Importing ".$_FILES["import"]["name"]."<br />";
		$tcat = 0;
		$keys = array_keys($linkscat);
		foreach ($keys as $thiskey) { $tcat++; }
		$ncat = 0;
		$nlnk = 0;
		$fp = @fopen($file, "r");
		if (!$fp) {
			$messages .= $vbphrase['ll_error_openfail'].' '.$file;
		}
		else {
			unset ($data);

			while ($data = fgetcsv ($fp, 1000, ",")) {
				$num = count ($data);
				for ($c=0; $c < $num; $c++) {
					$data[$c] = preg_replace ("/^ *(\")(.*)\\1/", "\\2", $data[$c]);
					$data[$c] = preg_replace ("/\\x5Cr/", "\r", $data[$c]);
					$data[$c] = preg_replace ("/\\x5Cn/", "\n", $data[$c]);
				}

				if (preg_match("/category/i", $data[0])) {
					if ($tcat>0) {
						$messages .= "&raquo; create cat $data[2] failed: categories already exist<br />";
						continue;
					}
					if (!isset($data[4]) or !preg_match ( "/^[\s\d-,]+$/", $data[4])) {
						$messages .= "&raquo; create cat $data[2] failed: invalid parentlist $data[4]<br />";
						continue;
					}
					if (!isset($data[5])) {
						$data[5] = $links_defaults["default_forumid"];
					}
					else {
						if (!preg_match ( "/^[\s\d]+$/", $data[5])) {
							$messages .= "&raquo; create cat $data[2] failed: invalid forumid $data[5]<br />";
							continue;
						}
					}

					$parentid = explode(',', $data[4]);
					$vbulletin->db->query_write("
					INSERT INTO ".THIS_TABLE."linkscat
					SET
						catid='".$data[1]."',
						catname='".$vbulletin->db->escape_string($data[2])."',
						catdesc='".$vbulletin->db->escape_string($data[3])."',
						cattext='".$vbulletin->db->escape_string($data[3])."',
						parentid='".$parentid[0]."',
						parentlist='".$data[4]."',
						catforum='".$data[5]."',
						catusername='".$vbulletin->db->escape_string(htmlspecialchars_uni($vbulletin->userinfo['username']))."',
						catuserid=".$vbulletin->userinfo[userid].",
						catentry='0',
						catdate='0',
						catmoderate='".$LINK_ACCEPTED."'
					");
					ldm_datastore_markdirty('ldm_cats');

					$ncat++;
					$linkscat[$data[1]] = array(); // force it to be set
				}

				if (preg_match("/link/i", $data[0])) {
					if (!isset($data[5])) {
						$data[5] = $links_defaults["default_forumid"];
					}
					else {
						if (!preg_match ( "/^\s*-*\d+$/", $data[5])) {
							$messages .= "&raquo; $data[2] failed: invalid forumid $data[5]<br />";
							continue;
						}
					}
					if (!preg_match ( "/^[,\s\d]+$/", $data[4])) {
						$messages .= "&raquo; $data[2] failed: invalid category id list $data[4]<br />";
						continue;
					}
					$pcatid = explode(',', $data[4]);
					foreach ($pcatid as $p) {
						if (!isset($linkscat[$p])) {
							$messages .= "&raquo; $data[2] failed: non-existent category id $p<br />";
							continue 2;
						}
					}

					$linkname =& $data[1];
					$linkurl =& $data[2];
					$linkimg =& $data[6];
					$linkdesc =& $data[3];
					$pforum =& $data[5];
					$linkreviewfreq =& $data[7];

        			require_once(DIR . '/includes/local_links_misc.php');
					$ldm_entry = ldm_entry_template(
						array(
							'linkname' => $linkname,
							'linkdesc' => $linkdesc,
							'linkurl' => $linkurl,
							'linkimg' => $linkimg,
							'linkforum' => $pforum,
							'linksize' => 0,
							'linkstatus' => $LINK_BROKEN,
							'linkreviewfreq' => $linkreviewfreq,
							)
						);

					list ($insert_status, $linkid) = ldm_create_entry($ldm_entry, 0);

					if ($linkid) {
						ldm_insert_entry_in_category($linkid, $pcatid);
					}
					$nlnk++;
				}

			}
		}
		fclose ($fp);
		$messages .= 'Import completed: '.$ncat.' categories, '.$nlnk.' links inserted';
	}

	ldm_datastore_markdirty('ldm_admin');
	ldm_datastore_markdirty('ldm_cats');

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

	$this_navigation_title = $vbphrase['ll_links_administration'];
	construct_forum_jump();

	// Make Links Nav Bar
	$navbits = array();
	$navbits[LINKS_SCRIPT.".php".$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$navbits[""] = $vbphrase['ll_links_administration'];
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	unset($pcatid);
	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_edit_category"] = 0;
	$viewcatid=-1;

	eval("\$output  = \"".fetch_template('links_header')."\";");

	$output .= '<table class="tborder" width="50%" align="center">'.
		'<tr><td class="thead" align="center">CSV Import</td></tr>'.
		'<tr><td class="alt1">'.$messages.'</td></tr>'.
		'<tr><td class="tfoot" align="center">'.
		'<input type="button" class="button" value="Validate" onclick="window.location=\''.$ADMIN_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl_js'].'action=validate\';" />'.
		'&nbsp;&nbsp;'.
		'<input type="button" class="button" value="Return" onclick="window.location=\''.$ADMIN_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q'].'\';" />'.
		'</td></tr>'.
		'</table><br /><br />';
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

/* ===========================================================================*/
// XML Import
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST['doimportxml'])) {

	$cpumax = ini_get('max_execution_time');
	if ($cpumax and $cpumax<$ADMIN_IMPEXP) {
		@ini_set('max_execution_time', min(ini_get('max_execution_time'), $ADMIN_IMPEXP));
	}
	@ini_set('memory_limit', -1);

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=importexport";

	require_once(DIR . '/includes/adminfunctions.php');
	require_once(DIR . '/includes/class_xml.php');

if (function_exists('mb_convert_encoding')) {
	class LDM_XMLparser extends vB_XML_Parser {

	function handle_element_start(&$parser, $name, $attribs) {
		$this->cdata = '';

		foreach ($attribs AS $key => $val) {
			$attribs["$key"] = mb_convert_encoding($val, 'HTML-ENTITIES', 'UTF-8');
		}

		array_unshift($this->stack, array('name' => $name, 'attribs' => $attribs, 'tag_count' => ++$this->tag_count));
	}

	function &parse($encoding = 'ISO-8859-1', $emptydata = true) {
		if (empty($this->xmldata) OR $this->error_no > 0) {
			return false;
		}

		if (!($this->xml_parser = xml_parser_create($encoding))) {
			return false;
		}

		xml_parser_set_option($this->xml_parser, XML_OPTION_SKIP_WHITE, 0);
		xml_parser_set_option($this->xml_parser, XML_OPTION_CASE_FOLDING, 0);
		xml_parser_set_option($this->xml_parser, XML_OPTION_TARGET_ENCODING, 'UTF-8');

		xml_set_character_data_handler($this->xml_parser, array(&$this, 'handle_cdata'));
		xml_set_element_handler($this->xml_parser, array(&$this, 'handle_element_start'), array(&$this, 'handle_element_end'));

		xml_parse($this->xml_parser, $this->xmldata);
		$err = xml_get_error_code($this->xml_parser);

		if ($emptydata) {
			$this->xmldata = '';
			$this->stack = array();
			$this->cdata = '';
		}

		if ($err) {
			$this->error_code = @xml_get_error_code($this->xml_parser);
			$this->error_line = @xml_get_current_line_number($this->xml_parser);
			xml_parser_free($this->xml_parser);
			return false;
		}

		xml_parser_free($this->xml_parser);

		return $this->parseddata;
	}

	}
}
else {
	class LDM_XMLparser extends vB_XML_Parser {
	}
}

	function ldm_impexp_import_row($table, &$row, $indexfield, $columns=0) {
		global $vbulletin;

		$search = array ("\r", "\n");
		$replace = array ("\\r", "\\n");

		$myrow = $row;
		$myrow = str_replace($replace, $search, $myrow);

		$tags = array();
		$values = array();
		foreach ($myrow as $tag=>$element) {
			if ($tag=='value') continue;
			if ($tag==$indexfield) continue;
			if (is_array($columns)) {
				if (!in_array($tag,$columns)) {
					continue;
				}
			}
			$tags[] = $tag;
			$values[] = $vbulletin->db->escape_string($element);
		}
		if (count($tags)) {
			$query = 'INSERT INTO '.THIS_TABLE.$table.
					' ('.implode(', ',$tags).') '.
					'VALUES ("'.implode('", "',$values).'")';
			$vbulletin->db->query_write($query);
			$row['value'] = $vbulletin->db->insert_id();
		}
	}

	function ldm_impexp_update_row($table, $rowid, $rowval, $fields) {
		global $vbulletin;

		$search = array ("\r", "\n");
       	$replace = array ("\\r", "\\n");
		$values = array();

		foreach ($fields as $tag=>$element) {
    		$element = str_replace($replace, $search, $element);
			$tags[] = $tag.'="'.$vbulletin->db->escape_string($element).'"';
		}
		if (count($tags)) {
			$query = 'UPDATE '.THIS_TABLE.$table.
					' SET '.implode(', ',$tags).
					' WHERE '.$rowid.'="'.$vbulletin->db->escape_string($rowval).'"';
			$vbulletin->db->query_write($query);
		}
	}

	function ldm_impexp_fix_table(&$arr) {
		if (array_key_exists('value', $arr)) { // one row only
			$temparray = array();
			foreach ($arr as $l=>$v) {
				$temparray[$l] = $v;
				unset($arr[$l]);
			}
			$arr[0] = $temparray;
		}
	}

	function ldm_impexp_import_table(&$arr, $table, $indexfield, $columns=0) {
		$nrec = 0;
		foreach ($arr as $l=>$t2) {
			ldm_impexp_import_row($table, $arr[$l], $indexfield, $columns);
			$nrec+=1;
		}
		return $nrec;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'xmlinit' => TYPE_INT,
		'xmlappend' => TYPE_INT,
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'xmlimport' => TYPE_FILE,
	));

	require_once(DIR . '/includes/local_links_admininclude.php');

// Require valid import
	if (!$vbulletin->GPC['xmlimport']['name'] or !$vbulletin->GPC['xmlimport']['tmp_name']
		or !$vbulletin->GPC['xmlimport']['size']
		or !is_uploaded_file($vbulletin->GPC['xmlimport']['tmp_name'])) {
		$err = $vbphrase['ll_error_importxml_read'].' <a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	$fp = @gzopen($vbulletin->GPC['xmlimport']['tmp_name'], "rb");
	$xml = '';
	while (!@feof($fp)) {
		$xml .= @fread($fp, 8192);
	}
	@fclose($fp);

	if (!$xml) {
		$err = construct_phrase($vbphrase['ll_error_importxml_interpret'],$vbulletin->GPC['xmlimport']['name']).' <a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}


	$xmlobj = new LDM_XMLparser($xml);
	if ($xmlobj->error_no == 1 or $xmlobj->error_no == 2) {
		$err = construct_phrase($vbphrase['ll_error_importxml_createparser'],$vbulletin->GPC['xmlimport']['name']).' <a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

	if (!$arr =& $xmlobj->parse()) {
        $errcode = $xmlobj->error_code;
		$err = construct_phrase($vbphrase['ll_error_importxml_doparser'], $xmlobj->error_line(), $vbulletin->GPC['xmlimport']['name'], $errcode, xml_error_string($errcode)).' <a href="'.$vbulletin->url.'"><b>'.$vbphrase['ll_return'].'</b></a>';
		eval(standard_error($err));
		exit;
	}

// Check that import file is compatible with current table structure
	$mismatches = array();

// This mapping should have been unnecessary, except that at some point we changed the naming convention...
	$tables = array(
		'admin' => THIS_TABLE."linksadmin",
		'categories' => THIS_TABLE."linkscat",
		'links' => THIS_TABLE."linkslink",
		'linkcats' => THIS_TABLE."linksltoc",
		'keywords' => THIS_TABLE."linkskeys",
		'linkkeys' => THIS_TABLE."linksltok",
		'entities' => THIS_TABLE."linksentities",
		'ratings' => THIS_TABLE."linksrate",
		'favourites' => THIS_TABLE."linksfavs",
		'downloads' => THIS_TABLE."linksdownloads",
		);


	$arecats = 0;
	if (array_key_exists('categories', $arr)) {
		if (is_array($arr['categories'])) {
			if (array_key_exists('category', $arr['categories'])) {
				if (count($arr['categories']['category'])) {
					$arecats = 1;
				}
			}
		}
	}

	if (!$arecats) {
		$kcat = $klink = 0;
		eval(print_standard_redirect(construct_phrase($vbphrase['ll_xmlimport_complete'],$kcat,$klink),0));
		exit;
	}

	foreach ($tables as $thisimport=>$thistable) {
		$tablecols[$thisimport] = array_keys(fetch_LDMtable_columns($thistable));
	}

	switch ($vbulletin->GPC['xmlappend']) {
	case 0:
		ldm_admin_clearfromtable('linksadmin', 'catid>0');
		ldm_admin_clearfromtable('linkscat');
		ldm_admin_clearfromtable('linkslink');
		ldm_admin_clearfromtable('linksltoc');
		ldm_admin_clearfromtable('linkskeys');
		ldm_admin_clearfromtable('linksltok');
		ldm_admin_clearfromtable('linksentities');
		ldm_admin_clearfromtable('linksfavs');
		ldm_admin_clearfromtable('linksrate');
		ldm_admin_clearfromtable('linksdownloads');
		break;
    default:
        break;
	}

	switch ($vbulletin->GPC['xmlappend']) {
	case 0:
	case 1:
    	$categories =& $arr['categories']['category'];
	    ldm_impexp_fix_table($categories);
	    $kcat = ldm_impexp_import_table($categories, 'linkscat', 'catid', $tablecols['categories']);

    	$catid_map = array();
	    foreach ($categories as $l=>$t1) {
		    $catid_map[$categories[$l]['catid']] = $categories[$l]['value'];
	    }
	    foreach ($categories as $l=>$t1) {
		    if ($categories[$l]['parentid']>0) {
			    $categories[$l]['parentid'] = $catid_map[$categories[$l]['parentid']];
			    $parents = explode(',', $categories[$l]['parentlist']);
			    foreach ($parents as $m=>$t2) {
		    		if ($parents[$m]>0) {
			    		$parents[$m] = $catid_map[$parents[$m]];
				    }
			    }
			    $categories[$l]['parentlist'] = implode(',', $parents);
			    ldm_impexp_update_row('linkscat', 'catid', $categories[$l]['value'], array('parentid'=>$categories[$l]['parentid'], 'parentlist'=>$categories[$l]['parentlist']));
		    }
	    }

	    $linkid_map = array();
	    $klink = 0;

	    if (array_key_exists('links', $arr)) {
		    if (is_array($arr['links'])) {
			    if (array_key_exists('link', $arr['links'])) {
				    $links =& $arr['links']['link'];
				    ldm_impexp_fix_table($links);
				    foreach ($links as $k=>$t1) {
					    $links[$k]['totrate'] = $links[$k]['numrate'] = $links[$k]['numcomment'] = 0;
				    }
				    $klink = ldm_impexp_import_table($links, 'linkslink', 'linkid', $tablecols['links']);

    				foreach ($links as $l=>$t1) {
	    				$linkid_map[$links[$l]['linkid']] = $links[$l]['value'];
		    		}
			    }
		    }
	    }

    	if (array_key_exists('linkcats', $arr)) {
	    	if (is_array($arr['linkcats'])) {
		    	if (array_key_exists('ltoc', $arr['linkcats'])) {
			    	$ltocs =& $arr['linkcats']['ltoc'];
				    ldm_impexp_fix_table($ltocs);
				    foreach ($ltocs as $l=>$t1) {
					    $ltocs[$l]['linkid'] = $linkid_map[$ltocs[$l]['linkid']];
					    $ltocs[$l]['catid']  = $catid_map[$ltocs[$l]['catid']];
				    }
				    $kltoc = ldm_impexp_import_table($ltocs, 'linksltoc', 'ltoc', $tablecols['linkcats']);
			    }
		    }
	    }

	    $keyids = array();
	    if (array_key_exists('keywords', $arr)) {
		    if (is_array($arr['keywords'])) {
			    if (array_key_exists('keyword', $arr['keywords'])) {
				    $keywords =& $arr['keywords']['keyword'];
				    ldm_impexp_fix_table($keywords);
				    $keyword_list = array();
				    foreach ($keywords as $v) {
					    $keyword_list[] = $v['keyword'];
				    }
				    $keyid_map = ldm_lookup_keywords($keyword_list);
			    }
		    }
	    }

	    if (array_key_exists('linkkeys', $arr)) {
		    if (is_array($arr['linkkeys'])) {
			    if (array_key_exists('ltok', $arr['linkkeys'])) {
				    $ltoks =& $arr['linkkeys']['ltok'];
				    ldm_impexp_fix_table($ltoks);
				    foreach ($ltoks as $l=>$t1) {
					    $ltoks[$l]['linkid'] = $linkid_map[$ltoks[$l]['linkid']];
					    $ltoks[$l]['keyid']  = $keyid_map[$ltoks[$l]['keyid']-1];
				    }
    				$kltok = ldm_impexp_import_table($ltoks, 'linksltok', 'lkey', $tablecols['linkkeys']);
	    		}
		    }
	    }

    	if (array_key_exists('entities', $arr)) {
	    	if (is_array($arr['entities'])) {
		    	if (array_key_exists('entity', $arr['entities'])) {
			    	$entities =& $arr['entities']['entity'];
				    ldm_impexp_fix_table($entities);
				    foreach ($entities as $l=>$t1) {
					    $entities[$l]['linkid'] = $linkid_map[$entities[$l]['linkid']];
				    }
				    $kents = ldm_impexp_import_table($entities, 'linksentities', 'entityid', $tablecols['entities']);
				    $entity_definitions = unserialize($ldm_master_settings['entity_definitions'][-1]['setting']);

    				require_once(DIR . '/includes/local_links_entities.php');
	    			ldm_check_entity_consistency($entities, $entity_definitions);

		    	}
		    }
	    }


    	if ($vbulletin->GPC['xmlinit']>=1 and array_key_exists('admin', $arr)) {
	    	if (is_array($arr['admin'])) {
		    	if (array_key_exists('admin', $arr['admin'])) {
			    	$admin =& $arr['admin']['admin'];
				    ldm_impexp_fix_table($admin);

    				switch ($vbulletin->GPC['xmlinit']) {
	    			case 1:
// Apply imported settings as overrides for imported data only
    					foreach ($admin as $l=>$t1) {
	    					if ($admin[$l]['catid']>0) {
		    					$admin[$l]['catid'] = $catid_map[$admin[$l]['catid']];
			    				ldm_impexp_import_row('linksadmin', $admin[$l], 'adminid', $tablecols['admin']);
				    		}
					    }
    					break;

	    			case 2:
// Apply imported settings everywhere
// First, reinitialise the table in case there are mismatches between imported data and current structure
		    			ldm_admin_clearfromtable('linksadmin');
			    		init_LDMadmintable();

				    	foreach ($admin as $l=>$t1) {
					    	if ($admin[$l]['catid']>0) {
						    	$admin[$l]['catid'] = $catid_map[$admin[$l]['catid']];
							    ldm_impexp_import_row('linksadmin', $admin[$l], 'adminid', $tablecols['admin']);
						    }
						    else {
							    $query = 'UPDATE '.THIS_TABLE.'linksadmin'.
								    	' SET setting="'.$vbulletin->db->escape_string($admin[$l]['setting']).'"'.
									    ' WHERE settingname="'.$admin[$l]['settingname'].'"'.
									    ' AND catid<0';
							    $vbulletin->db->query_write($query);
						    }
					    }
    					record_LDM_version(THIS_VERSION, 1);

	    			}
		    	}
		    }
	    }

// Ensure we have a clean category structure
		ldm_fix_cat_parentlist();
        ldm_fix_cat_count();

    	ldm_datastore_markdirty('ldm_admin');
	    ldm_datastore_markdirty('ldm_cats');

	    break;

	case 2: // Update names/descriptions of existing entries based on url

        $kcat = $klink = 0;
	    if (array_key_exists('links', $arr)) {
		    if (is_array($arr['links'])) {
			    if (array_key_exists('link', $arr['links'])) {
				    $links =& $arr['links']['link'];
				    ldm_impexp_fix_table($links);
				    foreach ($links as $k=>$t1) {
            		    ldm_impexp_update_row('linkslink', 'linkurl', $links[$k]['linkurl'],
            		        array('linkname'=>$links[$k]['linkname'], 'linkdesc'=>$links[$k]['linkdesc']));
                        $klink++;
				    }
			    }
		    }
	    }

	    break;

	default:
        $kcat = $klink = 0;
	    break;
	}

    require_once(DIR . '/includes/local_links_bitcache.php');
    ldm_clear_bitcache();

    eval(print_standard_redirect(construct_phrase($vbphrase['ll_xmlimport_complete'],$kcat,$klink),0));

	exit;

}

?>